/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class GpsMeasurement
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "GpsMeasurement";
    private int mFlags;
    private byte mPrn;
    private double mTimeOffsetInNs;
    private short mState;
    private long mReceivedGpsTowInNs;
    private long mReceivedGpsTowUncertaintyInNs;
    private double mCn0InDbHz;
    private double mPseudorangeRateInMetersPerSec;
    private double mPseudorangeRateUncertaintyInMetersPerSec;
    private short mAccumulatedDeltaRangeState;
    private double mAccumulatedDeltaRangeInMeters;
    private double mAccumulatedDeltaRangeUncertaintyInMeters;
    private double mPseudorangeInMeters;
    private double mPseudorangeUncertaintyInMeters;
    private double mCodePhaseInChips;
    private double mCodePhaseUncertaintyInChips;
    private float mCarrierFrequencyInHz;
    private long mCarrierCycles;
    private double mCarrierPhase;
    private double mCarrierPhaseUncertainty;
    private byte mLossOfLock;
    private int mBitNumber;
    private short mTimeFromLastBitInMs;
    private double mDopplerShiftInHz;
    private double mDopplerShiftUncertaintyInHz;
    private byte mMultipathIndicator;
    private double mSnrInDb;
    private double mElevationInDeg;
    private double mElevationUncertaintyInDeg;
    private double mAzimuthInDeg;
    private double mAzimuthUncertaintyInDeg;
    private boolean mUsedInFix;
    private static int HAS_NO_FLAGS = 0;
    private static int HAS_SNR = 1;
    private static int HAS_ELEVATION = 2;
    private static int HAS_ELEVATION_UNCERTAINTY = 4;
    private static int HAS_AZIMUTH = 8;
    private static int HAS_AZIMUTH_UNCERTAINTY = 16;
    private static int HAS_PSEUDORANGE = 32;
    private static int HAS_PSEUDORANGE_UNCERTAINTY = 64;
    private static int HAS_CODE_PHASE = 128;
    private static int HAS_CODE_PHASE_UNCERTAINTY = 256;
    private static int HAS_CARRIER_FREQUENCY = 512;
    private static int HAS_CARRIER_CYCLES = 1024;
    private static int HAS_CARRIER_PHASE = 2048;
    private static int HAS_CARRIER_PHASE_UNCERTAINTY = 4096;
    private static int HAS_BIT_NUMBER = 8192;
    private static int HAS_TIME_FROM_LAST_BIT = 16384;
    private static int HAS_DOPPLER_SHIFT = 32768;
    private static int HAS_DOPPLER_SHIFT_UNCERTAINTY = 65536;
    public static byte LOSS_OF_LOCK_UNKNOWN = 0;
    public static byte LOSS_OF_LOCK_OK = 1;
    public static byte LOSS_OF_LOCK_CYCLE_SLIP = 2;
    public static byte MULTIPATH_INDICATOR_UNKNOWN = 0;
    public static byte MULTIPATH_INDICATOR_DETECTED = 1;
    public static byte MULTIPATH_INDICATOR_NOT_USED = 2;
    public static short STATE_UNKNOWN = 0;
    public static short STATE_CODE_LOCK = 1;
    public static short STATE_BIT_SYNC = 2;
    public static short STATE_SUBFRAME_SYNC = 4;
    public static short STATE_TOW_DECODED = 8;
    public static short ADR_STATE_UNKNOWN = 0;
    public static short ADR_STATE_VALID = 1;
    public static short ADR_STATE_RESET = 2;
    public static short ADR_STATE_CYCLE_SLIP = 4;
    public static Parcelable.Creator<GpsMeasurement> CREATOR;

    private void $$robo$$android_location_GpsMeasurement$__constructor__() {
        this.initialize();
    }

    private final void $$robo$$android_location_GpsMeasurement$set(GpsMeasurement measurement) {
        this.mFlags = measurement.mFlags;
        this.mPrn = measurement.mPrn;
        this.mTimeOffsetInNs = measurement.mTimeOffsetInNs;
        this.mState = measurement.mState;
        this.mReceivedGpsTowInNs = measurement.mReceivedGpsTowInNs;
        this.mReceivedGpsTowUncertaintyInNs = measurement.mReceivedGpsTowUncertaintyInNs;
        this.mCn0InDbHz = measurement.mCn0InDbHz;
        this.mPseudorangeRateInMetersPerSec = measurement.mPseudorangeRateInMetersPerSec;
        this.mPseudorangeRateUncertaintyInMetersPerSec = measurement.mPseudorangeRateUncertaintyInMetersPerSec;
        this.mAccumulatedDeltaRangeState = measurement.mAccumulatedDeltaRangeState;
        this.mAccumulatedDeltaRangeInMeters = measurement.mAccumulatedDeltaRangeInMeters;
        this.mAccumulatedDeltaRangeUncertaintyInMeters = measurement.mAccumulatedDeltaRangeUncertaintyInMeters;
        this.mPseudorangeInMeters = measurement.mPseudorangeInMeters;
        this.mPseudorangeUncertaintyInMeters = measurement.mPseudorangeUncertaintyInMeters;
        this.mCodePhaseInChips = measurement.mCodePhaseInChips;
        this.mCodePhaseUncertaintyInChips = measurement.mCodePhaseUncertaintyInChips;
        this.mCarrierFrequencyInHz = measurement.mCarrierFrequencyInHz;
        this.mCarrierCycles = measurement.mCarrierCycles;
        this.mCarrierPhase = measurement.mCarrierPhase;
        this.mCarrierPhaseUncertainty = measurement.mCarrierPhaseUncertainty;
        this.mLossOfLock = measurement.mLossOfLock;
        this.mBitNumber = measurement.mBitNumber;
        this.mTimeFromLastBitInMs = measurement.mTimeFromLastBitInMs;
        this.mDopplerShiftInHz = measurement.mDopplerShiftInHz;
        this.mDopplerShiftUncertaintyInHz = measurement.mDopplerShiftUncertaintyInHz;
        this.mMultipathIndicator = measurement.mMultipathIndicator;
        this.mSnrInDb = measurement.mSnrInDb;
        this.mElevationInDeg = measurement.mElevationInDeg;
        this.mElevationUncertaintyInDeg = measurement.mElevationUncertaintyInDeg;
        this.mAzimuthInDeg = measurement.mAzimuthInDeg;
        this.mAzimuthUncertaintyInDeg = measurement.mAzimuthUncertaintyInDeg;
        this.mUsedInFix = measurement.mUsedInFix;
    }

    private final void $$robo$$android_location_GpsMeasurement$reset() {
        this.initialize();
    }

    private final byte $$robo$$android_location_GpsMeasurement$getPrn() {
        return this.mPrn;
    }

    private final void $$robo$$android_location_GpsMeasurement$setPrn(byte value) {
        this.mPrn = value;
    }

    private final double $$robo$$android_location_GpsMeasurement$getTimeOffsetInNs() {
        return this.mTimeOffsetInNs;
    }

    private final void $$robo$$android_location_GpsMeasurement$setTimeOffsetInNs(double value) {
        this.mTimeOffsetInNs = value;
    }

    private final short $$robo$$android_location_GpsMeasurement$getState() {
        return this.mState;
    }

    private final void $$robo$$android_location_GpsMeasurement$setState(short value) {
        switch (value) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                this.mState = value;
                break;
            }
            default: {
                Log.d("GpsMeasurement", "Sanitizing invalid 'sync state': " + value);
                this.mState = 0;
            }
        }
    }

    private final String $$robo$$android_location_GpsMeasurement$getStateString() {
        switch (this.mState) {
            case 0: {
                return "Unknown";
            }
            case 2: {
                return "BitSync";
            }
            case 1: {
                return "CodeLock";
            }
            case 4: {
                return "SubframeSync";
            }
            case 8: {
                return "TowDecoded";
            }
        }
        return "<Invalid>";
    }

    private final long $$robo$$android_location_GpsMeasurement$getReceivedGpsTowInNs() {
        return this.mReceivedGpsTowInNs;
    }

    private final void $$robo$$android_location_GpsMeasurement$setReceivedGpsTowInNs(long value) {
        this.mReceivedGpsTowInNs = value;
    }

    private final long $$robo$$android_location_GpsMeasurement$getReceivedGpsTowUncertaintyInNs() {
        return this.mReceivedGpsTowUncertaintyInNs;
    }

    private final void $$robo$$android_location_GpsMeasurement$setReceivedGpsTowUncertaintyInNs(long value) {
        this.mReceivedGpsTowUncertaintyInNs = value;
    }

    private final double $$robo$$android_location_GpsMeasurement$getCn0InDbHz() {
        return this.mCn0InDbHz;
    }

    private final void $$robo$$android_location_GpsMeasurement$setCn0InDbHz(double value) {
        this.mCn0InDbHz = value;
    }

    private final double $$robo$$android_location_GpsMeasurement$getPseudorangeRateInMetersPerSec() {
        return this.mPseudorangeRateInMetersPerSec;
    }

    private final void $$robo$$android_location_GpsMeasurement$setPseudorangeRateInMetersPerSec(double value) {
        this.mPseudorangeRateInMetersPerSec = value;
    }

    private final double $$robo$$android_location_GpsMeasurement$getPseudorangeRateUncertaintyInMetersPerSec() {
        return this.mPseudorangeRateUncertaintyInMetersPerSec;
    }

    private final void $$robo$$android_location_GpsMeasurement$setPseudorangeRateUncertaintyInMetersPerSec(double value) {
        this.mPseudorangeRateUncertaintyInMetersPerSec = value;
    }

    private final short $$robo$$android_location_GpsMeasurement$getAccumulatedDeltaRangeState() {
        return this.mAccumulatedDeltaRangeState;
    }

    private final void $$robo$$android_location_GpsMeasurement$setAccumulatedDeltaRangeState(short value) {
        switch (value) {
            case 0: 
            case 1: 
            case 2: 
            case 4: {
                this.mAccumulatedDeltaRangeState = value;
                break;
            }
            default: {
                Log.d("GpsMeasurement", "Sanitizing invalid 'Accumulated Delta Range state': " + value);
                this.mAccumulatedDeltaRangeState = 0;
            }
        }
    }

    private final String $$robo$$android_location_GpsMeasurement$getAccumulatedDeltaRangeStateString() {
        switch (this.mAccumulatedDeltaRangeState) {
            case 0: {
                return "Unknown";
            }
            case 1: {
                return "Valid";
            }
            case 2: {
                return "Reset";
            }
            case 4: {
                return "CycleSlip";
            }
        }
        return "<Invalid>";
    }

    private final double $$robo$$android_location_GpsMeasurement$getAccumulatedDeltaRangeInMeters() {
        return this.mAccumulatedDeltaRangeInMeters;
    }

    private final void $$robo$$android_location_GpsMeasurement$setAccumulatedDeltaRangeInMeters(double value) {
        this.mAccumulatedDeltaRangeInMeters = value;
    }

    private final double $$robo$$android_location_GpsMeasurement$getAccumulatedDeltaRangeUncertaintyInMeters() {
        return this.mAccumulatedDeltaRangeUncertaintyInMeters;
    }

    private final void $$robo$$android_location_GpsMeasurement$setAccumulatedDeltaRangeUncertaintyInMeters(double value) {
        this.mAccumulatedDeltaRangeUncertaintyInMeters = value;
    }

    private final boolean $$robo$$android_location_GpsMeasurement$hasPseudorangeInMeters() {
        return this.isFlagSet(32);
    }

    private final double $$robo$$android_location_GpsMeasurement$getPseudorangeInMeters() {
        return this.mPseudorangeInMeters;
    }

    private final void $$robo$$android_location_GpsMeasurement$setPseudorangeInMeters(double value) {
        this.setFlag(32);
        this.mPseudorangeInMeters = value;
    }

    private final void $$robo$$android_location_GpsMeasurement$resetPseudorangeInMeters() {
        this.resetFlag(32);
        this.mPseudorangeInMeters = Double.NaN;
    }

    private final boolean $$robo$$android_location_GpsMeasurement$hasPseudorangeUncertaintyInMeters() {
        return this.isFlagSet(64);
    }

    private final double $$robo$$android_location_GpsMeasurement$getPseudorangeUncertaintyInMeters() {
        return this.mPseudorangeUncertaintyInMeters;
    }

    private final void $$robo$$android_location_GpsMeasurement$setPseudorangeUncertaintyInMeters(double value) {
        this.setFlag(64);
        this.mPseudorangeUncertaintyInMeters = value;
    }

    private final void $$robo$$android_location_GpsMeasurement$resetPseudorangeUncertaintyInMeters() {
        this.resetFlag(64);
        this.mPseudorangeUncertaintyInMeters = Double.NaN;
    }

    private final boolean $$robo$$android_location_GpsMeasurement$hasCodePhaseInChips() {
        return this.isFlagSet(128);
    }

    private final double $$robo$$android_location_GpsMeasurement$getCodePhaseInChips() {
        return this.mCodePhaseInChips;
    }

    private final void $$robo$$android_location_GpsMeasurement$setCodePhaseInChips(double value) {
        this.setFlag(128);
        this.mCodePhaseInChips = value;
    }

    private final void $$robo$$android_location_GpsMeasurement$resetCodePhaseInChips() {
        this.resetFlag(128);
        this.mCodePhaseInChips = Double.NaN;
    }

    private final boolean $$robo$$android_location_GpsMeasurement$hasCodePhaseUncertaintyInChips() {
        return this.isFlagSet(256);
    }

    private final double $$robo$$android_location_GpsMeasurement$getCodePhaseUncertaintyInChips() {
        return this.mCodePhaseUncertaintyInChips;
    }

    private final void $$robo$$android_location_GpsMeasurement$setCodePhaseUncertaintyInChips(double value) {
        this.setFlag(256);
        this.mCodePhaseUncertaintyInChips = value;
    }

    private final void $$robo$$android_location_GpsMeasurement$resetCodePhaseUncertaintyInChips() {
        this.resetFlag(256);
        this.mCodePhaseUncertaintyInChips = Double.NaN;
    }

    private final boolean $$robo$$android_location_GpsMeasurement$hasCarrierFrequencyInHz() {
        return this.isFlagSet(512);
    }

    private final float $$robo$$android_location_GpsMeasurement$getCarrierFrequencyInHz() {
        return this.mCarrierFrequencyInHz;
    }

    private final void $$robo$$android_location_GpsMeasurement$setCarrierFrequencyInHz(float carrierFrequencyInHz) {
        this.setFlag(512);
        this.mCarrierFrequencyInHz = carrierFrequencyInHz;
    }

    private final void $$robo$$android_location_GpsMeasurement$resetCarrierFrequencyInHz() {
        this.resetFlag(512);
        this.mCarrierFrequencyInHz = Float.NaN;
    }

    private final boolean $$robo$$android_location_GpsMeasurement$hasCarrierCycles() {
        return this.isFlagSet(1024);
    }

    private final long $$robo$$android_location_GpsMeasurement$getCarrierCycles() {
        return this.mCarrierCycles;
    }

    private final void $$robo$$android_location_GpsMeasurement$setCarrierCycles(long value) {
        this.setFlag(1024);
        this.mCarrierCycles = value;
    }

    private final void $$robo$$android_location_GpsMeasurement$resetCarrierCycles() {
        this.resetFlag(1024);
        this.mCarrierCycles = Long.MIN_VALUE;
    }

    private final boolean $$robo$$android_location_GpsMeasurement$hasCarrierPhase() {
        return this.isFlagSet(2048);
    }

    private final double $$robo$$android_location_GpsMeasurement$getCarrierPhase() {
        return this.mCarrierPhase;
    }

    private final void $$robo$$android_location_GpsMeasurement$setCarrierPhase(double value) {
        this.setFlag(2048);
        this.mCarrierPhase = value;
    }

    private final void $$robo$$android_location_GpsMeasurement$resetCarrierPhase() {
        this.resetFlag(2048);
        this.mCarrierPhase = Double.NaN;
    }

    private final boolean $$robo$$android_location_GpsMeasurement$hasCarrierPhaseUncertainty() {
        return this.isFlagSet(4096);
    }

    private final double $$robo$$android_location_GpsMeasurement$getCarrierPhaseUncertainty() {
        return this.mCarrierPhaseUncertainty;
    }

    private final void $$robo$$android_location_GpsMeasurement$setCarrierPhaseUncertainty(double value) {
        this.setFlag(4096);
        this.mCarrierPhaseUncertainty = value;
    }

    private final void $$robo$$android_location_GpsMeasurement$resetCarrierPhaseUncertainty() {
        this.resetFlag(4096);
        this.mCarrierPhaseUncertainty = Double.NaN;
    }

    private final byte $$robo$$android_location_GpsMeasurement$getLossOfLock() {
        return this.mLossOfLock;
    }

    private final void $$robo$$android_location_GpsMeasurement$setLossOfLock(byte value) {
        switch (value) {
            case 0: 
            case 1: 
            case 2: {
                this.mLossOfLock = value;
                break;
            }
            default: {
                Log.d("GpsMeasurement", "Sanitizing invalid 'loss of lock': " + value);
                this.mLossOfLock = 0;
            }
        }
    }

    private final String $$robo$$android_location_GpsMeasurement$getLossOfLockString() {
        switch (this.mLossOfLock) {
            case 0: {
                return "Unknown";
            }
            case 1: {
                return "Ok";
            }
            case 2: {
                return "CycleSlip";
            }
        }
        return "<Invalid>";
    }

    private final boolean $$robo$$android_location_GpsMeasurement$hasBitNumber() {
        return this.isFlagSet(8192);
    }

    private final int $$robo$$android_location_GpsMeasurement$getBitNumber() {
        return this.mBitNumber;
    }

    private final void $$robo$$android_location_GpsMeasurement$setBitNumber(int bitNumber) {
        this.setFlag(8192);
        this.mBitNumber = bitNumber;
    }

    private final void $$robo$$android_location_GpsMeasurement$resetBitNumber() {
        this.resetFlag(8192);
        this.mBitNumber = Integer.MIN_VALUE;
    }

    private final boolean $$robo$$android_location_GpsMeasurement$hasTimeFromLastBitInMs() {
        return this.isFlagSet(16384);
    }

    private final short $$robo$$android_location_GpsMeasurement$getTimeFromLastBitInMs() {
        return this.mTimeFromLastBitInMs;
    }

    private final void $$robo$$android_location_GpsMeasurement$setTimeFromLastBitInMs(short value) {
        this.setFlag(16384);
        this.mTimeFromLastBitInMs = value;
    }

    private final void $$robo$$android_location_GpsMeasurement$resetTimeFromLastBitInMs() {
        this.resetFlag(16384);
        this.mTimeFromLastBitInMs = Short.MIN_VALUE;
    }

    private final boolean $$robo$$android_location_GpsMeasurement$hasDopplerShiftInHz() {
        return this.isFlagSet(32768);
    }

    private final double $$robo$$android_location_GpsMeasurement$getDopplerShiftInHz() {
        return this.mDopplerShiftInHz;
    }

    private final void $$robo$$android_location_GpsMeasurement$setDopplerShiftInHz(double value) {
        this.setFlag(32768);
        this.mDopplerShiftInHz = value;
    }

    private final void $$robo$$android_location_GpsMeasurement$resetDopplerShiftInHz() {
        this.resetFlag(32768);
        this.mDopplerShiftInHz = Double.NaN;
    }

    private final boolean $$robo$$android_location_GpsMeasurement$hasDopplerShiftUncertaintyInHz() {
        return this.isFlagSet(65536);
    }

    private final double $$robo$$android_location_GpsMeasurement$getDopplerShiftUncertaintyInHz() {
        return this.mDopplerShiftUncertaintyInHz;
    }

    private final void $$robo$$android_location_GpsMeasurement$setDopplerShiftUncertaintyInHz(double value) {
        this.setFlag(65536);
        this.mDopplerShiftUncertaintyInHz = value;
    }

    private final void $$robo$$android_location_GpsMeasurement$resetDopplerShiftUncertaintyInHz() {
        this.resetFlag(65536);
        this.mDopplerShiftUncertaintyInHz = Double.NaN;
    }

    private final byte $$robo$$android_location_GpsMeasurement$getMultipathIndicator() {
        return this.mMultipathIndicator;
    }

    private final void $$robo$$android_location_GpsMeasurement$setMultipathIndicator(byte value) {
        switch (value) {
            case 0: 
            case 1: 
            case 2: {
                this.mMultipathIndicator = value;
                break;
            }
            default: {
                Log.d("GpsMeasurement", "Sanitizing invalid 'muti-path indicator': " + value);
                this.mMultipathIndicator = 0;
            }
        }
    }

    private final String $$robo$$android_location_GpsMeasurement$getMultipathIndicatorString() {
        switch (this.mMultipathIndicator) {
            case 0: {
                return "Unknown";
            }
            case 1: {
                return "Detected";
            }
            case 2: {
                return "NotUsed";
            }
        }
        return "<Invalid>";
    }

    private final boolean $$robo$$android_location_GpsMeasurement$hasSnrInDb() {
        return this.isFlagSet(1);
    }

    private final double $$robo$$android_location_GpsMeasurement$getSnrInDb() {
        return this.mSnrInDb;
    }

    private final void $$robo$$android_location_GpsMeasurement$setSnrInDb(double snrInDb) {
        this.setFlag(1);
        this.mSnrInDb = snrInDb;
    }

    private final void $$robo$$android_location_GpsMeasurement$resetSnrInDb() {
        this.resetFlag(1);
        this.mSnrInDb = Double.NaN;
    }

    private final boolean $$robo$$android_location_GpsMeasurement$hasElevationInDeg() {
        return this.isFlagSet(2);
    }

    private final double $$robo$$android_location_GpsMeasurement$getElevationInDeg() {
        return this.mElevationInDeg;
    }

    private final void $$robo$$android_location_GpsMeasurement$setElevationInDeg(double elevationInDeg) {
        this.setFlag(2);
        this.mElevationInDeg = elevationInDeg;
    }

    private final void $$robo$$android_location_GpsMeasurement$resetElevationInDeg() {
        this.resetFlag(2);
        this.mElevationInDeg = Double.NaN;
    }

    private final boolean $$robo$$android_location_GpsMeasurement$hasElevationUncertaintyInDeg() {
        return this.isFlagSet(4);
    }

    private final double $$robo$$android_location_GpsMeasurement$getElevationUncertaintyInDeg() {
        return this.mElevationUncertaintyInDeg;
    }

    private final void $$robo$$android_location_GpsMeasurement$setElevationUncertaintyInDeg(double value) {
        this.setFlag(4);
        this.mElevationUncertaintyInDeg = value;
    }

    private final void $$robo$$android_location_GpsMeasurement$resetElevationUncertaintyInDeg() {
        this.resetFlag(4);
        this.mElevationUncertaintyInDeg = Double.NaN;
    }

    private final boolean $$robo$$android_location_GpsMeasurement$hasAzimuthInDeg() {
        return this.isFlagSet(8);
    }

    private final double $$robo$$android_location_GpsMeasurement$getAzimuthInDeg() {
        return this.mAzimuthInDeg;
    }

    private final void $$robo$$android_location_GpsMeasurement$setAzimuthInDeg(double value) {
        this.setFlag(8);
        this.mAzimuthInDeg = value;
    }

    private final void $$robo$$android_location_GpsMeasurement$resetAzimuthInDeg() {
        this.resetFlag(8);
        this.mAzimuthInDeg = Double.NaN;
    }

    private final boolean $$robo$$android_location_GpsMeasurement$hasAzimuthUncertaintyInDeg() {
        return this.isFlagSet(16);
    }

    private final double $$robo$$android_location_GpsMeasurement$getAzimuthUncertaintyInDeg() {
        return this.mAzimuthUncertaintyInDeg;
    }

    private final void $$robo$$android_location_GpsMeasurement$setAzimuthUncertaintyInDeg(double value) {
        this.setFlag(16);
        this.mAzimuthUncertaintyInDeg = value;
    }

    private final void $$robo$$android_location_GpsMeasurement$resetAzimuthUncertaintyInDeg() {
        this.resetFlag(16);
        this.mAzimuthUncertaintyInDeg = Double.NaN;
    }

    private final boolean $$robo$$android_location_GpsMeasurement$isUsedInFix() {
        return this.mUsedInFix;
    }

    private final void $$robo$$android_location_GpsMeasurement$setUsedInFix(boolean value) {
        this.mUsedInFix = value;
    }

    private final void $$robo$$android_location_GpsMeasurement$writeToParcel(Parcel parcel, int flags) {
        parcel.writeInt(this.mFlags);
        parcel.writeByte(this.mPrn);
        parcel.writeDouble(this.mTimeOffsetInNs);
        parcel.writeInt(this.mState);
        parcel.writeLong(this.mReceivedGpsTowInNs);
        parcel.writeLong(this.mReceivedGpsTowUncertaintyInNs);
        parcel.writeDouble(this.mCn0InDbHz);
        parcel.writeDouble(this.mPseudorangeRateInMetersPerSec);
        parcel.writeDouble(this.mPseudorangeRateUncertaintyInMetersPerSec);
        parcel.writeInt(this.mAccumulatedDeltaRangeState);
        parcel.writeDouble(this.mAccumulatedDeltaRangeInMeters);
        parcel.writeDouble(this.mAccumulatedDeltaRangeUncertaintyInMeters);
        parcel.writeDouble(this.mPseudorangeInMeters);
        parcel.writeDouble(this.mPseudorangeUncertaintyInMeters);
        parcel.writeDouble(this.mCodePhaseInChips);
        parcel.writeDouble(this.mCodePhaseUncertaintyInChips);
        parcel.writeFloat(this.mCarrierFrequencyInHz);
        parcel.writeLong(this.mCarrierCycles);
        parcel.writeDouble(this.mCarrierPhase);
        parcel.writeDouble(this.mCarrierPhaseUncertainty);
        parcel.writeByte(this.mLossOfLock);
        parcel.writeInt(this.mBitNumber);
        parcel.writeInt(this.mTimeFromLastBitInMs);
        parcel.writeDouble(this.mDopplerShiftInHz);
        parcel.writeDouble(this.mDopplerShiftUncertaintyInHz);
        parcel.writeByte(this.mMultipathIndicator);
        parcel.writeDouble(this.mSnrInDb);
        parcel.writeDouble(this.mElevationInDeg);
        parcel.writeDouble(this.mElevationUncertaintyInDeg);
        parcel.writeDouble(this.mAzimuthInDeg);
        parcel.writeDouble(this.mAzimuthUncertaintyInDeg);
        parcel.writeInt(this.mUsedInFix ? 1 : 0);
    }

    private final int $$robo$$android_location_GpsMeasurement$describeContents() {
        return 0;
    }

    private final String $$robo$$android_location_GpsMeasurement$toString() {
        String format = "   %-29s = %s\n";
        String formatWithUncertainty = "   %-29s = %-25s   %-40s = %s\n";
        StringBuilder builder = new StringBuilder("GpsMeasurement:\n");
        builder.append(String.format("   %-29s = %s\n", "Prn", this.mPrn));
        builder.append(String.format("   %-29s = %s\n", "TimeOffsetInNs", this.mTimeOffsetInNs));
        builder.append(String.format("   %-29s = %s\n", "State", this.getStateString()));
        builder.append(String.format("   %-29s = %-25s   %-40s = %s\n", "ReceivedGpsTowInNs", this.mReceivedGpsTowInNs, "ReceivedGpsTowUncertaintyInNs", this.mReceivedGpsTowUncertaintyInNs));
        builder.append(String.format("   %-29s = %s\n", "Cn0InDbHz", this.mCn0InDbHz));
        builder.append(String.format("   %-29s = %-25s   %-40s = %s\n", "PseudorangeRateInMetersPerSec", this.mPseudorangeRateInMetersPerSec, "PseudorangeRateUncertaintyInMetersPerSec", this.mPseudorangeRateUncertaintyInMetersPerSec));
        builder.append(String.format("   %-29s = %s\n", "AccumulatedDeltaRangeState", this.getAccumulatedDeltaRangeStateString()));
        builder.append(String.format("   %-29s = %-25s   %-40s = %s\n", "AccumulatedDeltaRangeInMeters", this.mAccumulatedDeltaRangeInMeters, "AccumulatedDeltaRangeUncertaintyInMeters", this.mAccumulatedDeltaRangeUncertaintyInMeters));
        builder.append(String.format("   %-29s = %-25s   %-40s = %s\n", "PseudorangeInMeters", this.hasPseudorangeInMeters() ? Double.valueOf(this.mPseudorangeInMeters) : null, "PseudorangeUncertaintyInMeters", this.hasPseudorangeUncertaintyInMeters() ? Double.valueOf(this.mPseudorangeUncertaintyInMeters) : null));
        builder.append(String.format("   %-29s = %-25s   %-40s = %s\n", "CodePhaseInChips", this.hasCodePhaseInChips() ? Double.valueOf(this.mCodePhaseInChips) : null, "CodePhaseUncertaintyInChips", this.hasCodePhaseUncertaintyInChips() ? Double.valueOf(this.mCodePhaseUncertaintyInChips) : null));
        builder.append(String.format("   %-29s = %s\n", "CarrierFrequencyInHz", this.hasCarrierFrequencyInHz() ? Float.valueOf(this.mCarrierFrequencyInHz) : null));
        builder.append(String.format("   %-29s = %s\n", "CarrierCycles", this.hasCarrierCycles() ? Long.valueOf(this.mCarrierCycles) : null));
        builder.append(String.format("   %-29s = %-25s   %-40s = %s\n", "CarrierPhase", this.hasCarrierPhase() ? Double.valueOf(this.mCarrierPhase) : null, "CarrierPhaseUncertainty", this.hasCarrierPhaseUncertainty() ? Double.valueOf(this.mCarrierPhaseUncertainty) : null));
        builder.append(String.format("   %-29s = %s\n", "LossOfLock", this.getLossOfLockString()));
        builder.append(String.format("   %-29s = %s\n", "BitNumber", this.hasBitNumber() ? Integer.valueOf(this.mBitNumber) : null));
        builder.append(String.format("   %-29s = %s\n", "TimeFromLastBitInMs", this.hasTimeFromLastBitInMs() ? Short.valueOf(this.mTimeFromLastBitInMs) : null));
        builder.append(String.format("   %-29s = %-25s   %-40s = %s\n", "DopplerShiftInHz", this.hasDopplerShiftInHz() ? Double.valueOf(this.mDopplerShiftInHz) : null, "DopplerShiftUncertaintyInHz", this.hasDopplerShiftUncertaintyInHz() ? Double.valueOf(this.mDopplerShiftUncertaintyInHz) : null));
        builder.append(String.format("   %-29s = %s\n", "MultipathIndicator", this.getMultipathIndicatorString()));
        builder.append(String.format("   %-29s = %s\n", "SnrInDb", this.hasSnrInDb() ? Double.valueOf(this.mSnrInDb) : null));
        builder.append(String.format("   %-29s = %-25s   %-40s = %s\n", "ElevationInDeg", this.hasElevationInDeg() ? Double.valueOf(this.mElevationInDeg) : null, "ElevationUncertaintyInDeg", this.hasElevationUncertaintyInDeg() ? Double.valueOf(this.mElevationUncertaintyInDeg) : null));
        builder.append(String.format("   %-29s = %-25s   %-40s = %s\n", "AzimuthInDeg", this.hasAzimuthInDeg() ? Double.valueOf(this.mAzimuthInDeg) : null, "AzimuthUncertaintyInDeg", this.hasAzimuthUncertaintyInDeg() ? Double.valueOf(this.mAzimuthUncertaintyInDeg) : null));
        builder.append(String.format("   %-29s = %s\n", "UsedInFix", this.mUsedInFix));
        return builder.toString();
    }

    private final void $$robo$$android_location_GpsMeasurement$initialize() {
        this.mFlags = 0;
        this.setPrn((byte)-128);
        this.setTimeOffsetInNs(-9.223372036854776E18);
        this.setState((short)0);
        this.setReceivedGpsTowInNs(Long.MIN_VALUE);
        this.setReceivedGpsTowUncertaintyInNs(Long.MAX_VALUE);
        this.setCn0InDbHz(Double.MIN_VALUE);
        this.setPseudorangeRateInMetersPerSec(Double.MIN_VALUE);
        this.setPseudorangeRateUncertaintyInMetersPerSec(Double.MIN_VALUE);
        this.setAccumulatedDeltaRangeState((short)0);
        this.setAccumulatedDeltaRangeInMeters(Double.MIN_VALUE);
        this.setAccumulatedDeltaRangeUncertaintyInMeters(Double.MIN_VALUE);
        this.resetPseudorangeInMeters();
        this.resetPseudorangeUncertaintyInMeters();
        this.resetCodePhaseInChips();
        this.resetCodePhaseUncertaintyInChips();
        this.resetCarrierFrequencyInHz();
        this.resetCarrierCycles();
        this.resetCarrierPhase();
        this.resetCarrierPhaseUncertainty();
        this.setLossOfLock((byte)0);
        this.resetBitNumber();
        this.resetTimeFromLastBitInMs();
        this.resetDopplerShiftInHz();
        this.resetDopplerShiftUncertaintyInHz();
        this.setMultipathIndicator((byte)0);
        this.resetSnrInDb();
        this.resetElevationInDeg();
        this.resetElevationUncertaintyInDeg();
        this.resetAzimuthInDeg();
        this.resetAzimuthUncertaintyInDeg();
        this.setUsedInFix(false);
    }

    private final void $$robo$$android_location_GpsMeasurement$setFlag(int flag) {
        this.mFlags |= flag;
    }

    private final void $$robo$$android_location_GpsMeasurement$resetFlag(int flag) {
        this.mFlags &= ~flag;
    }

    private final boolean $$robo$$android_location_GpsMeasurement$isFlagSet(int flag) {
        return (this.mFlags & flag) == flag;
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<GpsMeasurement>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_location_GpsMeasurement_1$__constructor__() {
            }

            private final GpsMeasurement $$robo$$android_location_GpsMeasurement_1$createFromParcel(Parcel parcel) {
                GpsMeasurement gpsMeasurement = new GpsMeasurement();
                gpsMeasurement.mFlags = parcel.readInt();
                gpsMeasurement.mPrn = parcel.readByte();
                gpsMeasurement.mTimeOffsetInNs = parcel.readDouble();
                gpsMeasurement.mState = (short)parcel.readInt();
                gpsMeasurement.mReceivedGpsTowInNs = parcel.readLong();
                gpsMeasurement.mReceivedGpsTowUncertaintyInNs = parcel.readLong();
                gpsMeasurement.mCn0InDbHz = parcel.readDouble();
                gpsMeasurement.mPseudorangeRateInMetersPerSec = parcel.readDouble();
                gpsMeasurement.mPseudorangeRateUncertaintyInMetersPerSec = parcel.readDouble();
                gpsMeasurement.mAccumulatedDeltaRangeState = (short)parcel.readInt();
                gpsMeasurement.mAccumulatedDeltaRangeInMeters = parcel.readDouble();
                gpsMeasurement.mAccumulatedDeltaRangeUncertaintyInMeters = parcel.readDouble();
                gpsMeasurement.mPseudorangeInMeters = parcel.readDouble();
                gpsMeasurement.mPseudorangeUncertaintyInMeters = parcel.readDouble();
                gpsMeasurement.mCodePhaseInChips = parcel.readDouble();
                gpsMeasurement.mCodePhaseUncertaintyInChips = parcel.readDouble();
                gpsMeasurement.mCarrierFrequencyInHz = parcel.readFloat();
                gpsMeasurement.mCarrierCycles = parcel.readLong();
                gpsMeasurement.mCarrierPhase = parcel.readDouble();
                gpsMeasurement.mCarrierPhaseUncertainty = parcel.readDouble();
                gpsMeasurement.mLossOfLock = parcel.readByte();
                gpsMeasurement.mBitNumber = parcel.readInt();
                gpsMeasurement.mTimeFromLastBitInMs = (short)parcel.readInt();
                gpsMeasurement.mDopplerShiftInHz = parcel.readDouble();
                gpsMeasurement.mDopplerShiftUncertaintyInHz = parcel.readDouble();
                gpsMeasurement.mMultipathIndicator = parcel.readByte();
                gpsMeasurement.mSnrInDb = parcel.readDouble();
                gpsMeasurement.mElevationInDeg = parcel.readDouble();
                gpsMeasurement.mElevationUncertaintyInDeg = parcel.readDouble();
                gpsMeasurement.mAzimuthInDeg = parcel.readDouble();
                gpsMeasurement.mAzimuthUncertaintyInDeg = parcel.readDouble();
                gpsMeasurement.mUsedInFix = parcel.readInt() != 0;
                return gpsMeasurement;
            }

            private final GpsMeasurement[] $$robo$$android_location_GpsMeasurement_1$newArray(int i) {
                return new GpsMeasurement[i];
            }

            private void __constructor__() {
                this.$$robo$$android_location_GpsMeasurement_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_location_GpsMeasurement_1$__constructor__(), 0, this);
            }

            @Override
            public GpsMeasurement createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_location_GpsMeasurement_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public GpsMeasurement[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_location_GpsMeasurement_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__() {
        this.$$robo$$android_location_GpsMeasurement$__constructor__();
    }

    GpsMeasurement() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_location_GpsMeasurement$__constructor__(), 0, this);
    }

    public void set(GpsMeasurement gpsMeasurement) {
        InvokeDynamicSupport.bootstrap("set", $$robo$$android_location_GpsMeasurement$set(android.location.GpsMeasurement ), 0, this, gpsMeasurement);
    }

    public void reset() {
        InvokeDynamicSupport.bootstrap("reset", $$robo$$android_location_GpsMeasurement$reset(), 0, this);
    }

    public byte getPrn() {
        return (byte)InvokeDynamicSupport.bootstrap("getPrn", $$robo$$android_location_GpsMeasurement$getPrn(), 0, this);
    }

    public void setPrn(byte by) {
        InvokeDynamicSupport.bootstrap("setPrn", $$robo$$android_location_GpsMeasurement$setPrn(byte ), 0, this, by);
    }

    public double getTimeOffsetInNs() {
        return (double)InvokeDynamicSupport.bootstrap("getTimeOffsetInNs", $$robo$$android_location_GpsMeasurement$getTimeOffsetInNs(), 0, this);
    }

    public void setTimeOffsetInNs(double d) {
        InvokeDynamicSupport.bootstrap("setTimeOffsetInNs", $$robo$$android_location_GpsMeasurement$setTimeOffsetInNs(double ), 0, this, d);
    }

    public short getState() {
        return (short)InvokeDynamicSupport.bootstrap("getState", $$robo$$android_location_GpsMeasurement$getState(), 0, this);
    }

    public void setState(short s) {
        InvokeDynamicSupport.bootstrap("setState", $$robo$$android_location_GpsMeasurement$setState(short ), 0, this, s);
    }

    private String getStateString() {
        return InvokeDynamicSupport.bootstrap("getStateString", $$robo$$android_location_GpsMeasurement$getStateString(), 0, this);
    }

    public long getReceivedGpsTowInNs() {
        return (long)InvokeDynamicSupport.bootstrap("getReceivedGpsTowInNs", $$robo$$android_location_GpsMeasurement$getReceivedGpsTowInNs(), 0, this);
    }

    public void setReceivedGpsTowInNs(long l) {
        InvokeDynamicSupport.bootstrap("setReceivedGpsTowInNs", $$robo$$android_location_GpsMeasurement$setReceivedGpsTowInNs(long ), 0, this, l);
    }

    public long getReceivedGpsTowUncertaintyInNs() {
        return (long)InvokeDynamicSupport.bootstrap("getReceivedGpsTowUncertaintyInNs", $$robo$$android_location_GpsMeasurement$getReceivedGpsTowUncertaintyInNs(), 0, this);
    }

    public void setReceivedGpsTowUncertaintyInNs(long l) {
        InvokeDynamicSupport.bootstrap("setReceivedGpsTowUncertaintyInNs", $$robo$$android_location_GpsMeasurement$setReceivedGpsTowUncertaintyInNs(long ), 0, this, l);
    }

    public double getCn0InDbHz() {
        return (double)InvokeDynamicSupport.bootstrap("getCn0InDbHz", $$robo$$android_location_GpsMeasurement$getCn0InDbHz(), 0, this);
    }

    public void setCn0InDbHz(double d) {
        InvokeDynamicSupport.bootstrap("setCn0InDbHz", $$robo$$android_location_GpsMeasurement$setCn0InDbHz(double ), 0, this, d);
    }

    public double getPseudorangeRateInMetersPerSec() {
        return (double)InvokeDynamicSupport.bootstrap("getPseudorangeRateInMetersPerSec", $$robo$$android_location_GpsMeasurement$getPseudorangeRateInMetersPerSec(), 0, this);
    }

    public void setPseudorangeRateInMetersPerSec(double d) {
        InvokeDynamicSupport.bootstrap("setPseudorangeRateInMetersPerSec", $$robo$$android_location_GpsMeasurement$setPseudorangeRateInMetersPerSec(double ), 0, this, d);
    }

    public double getPseudorangeRateUncertaintyInMetersPerSec() {
        return (double)InvokeDynamicSupport.bootstrap("getPseudorangeRateUncertaintyInMetersPerSec", $$robo$$android_location_GpsMeasurement$getPseudorangeRateUncertaintyInMetersPerSec(), 0, this);
    }

    public void setPseudorangeRateUncertaintyInMetersPerSec(double d) {
        InvokeDynamicSupport.bootstrap("setPseudorangeRateUncertaintyInMetersPerSec", $$robo$$android_location_GpsMeasurement$setPseudorangeRateUncertaintyInMetersPerSec(double ), 0, this, d);
    }

    public short getAccumulatedDeltaRangeState() {
        return (short)InvokeDynamicSupport.bootstrap("getAccumulatedDeltaRangeState", $$robo$$android_location_GpsMeasurement$getAccumulatedDeltaRangeState(), 0, this);
    }

    public void setAccumulatedDeltaRangeState(short s) {
        InvokeDynamicSupport.bootstrap("setAccumulatedDeltaRangeState", $$robo$$android_location_GpsMeasurement$setAccumulatedDeltaRangeState(short ), 0, this, s);
    }

    private String getAccumulatedDeltaRangeStateString() {
        return InvokeDynamicSupport.bootstrap("getAccumulatedDeltaRangeStateString", $$robo$$android_location_GpsMeasurement$getAccumulatedDeltaRangeStateString(), 0, this);
    }

    public double getAccumulatedDeltaRangeInMeters() {
        return (double)InvokeDynamicSupport.bootstrap("getAccumulatedDeltaRangeInMeters", $$robo$$android_location_GpsMeasurement$getAccumulatedDeltaRangeInMeters(), 0, this);
    }

    public void setAccumulatedDeltaRangeInMeters(double d) {
        InvokeDynamicSupport.bootstrap("setAccumulatedDeltaRangeInMeters", $$robo$$android_location_GpsMeasurement$setAccumulatedDeltaRangeInMeters(double ), 0, this, d);
    }

    public double getAccumulatedDeltaRangeUncertaintyInMeters() {
        return (double)InvokeDynamicSupport.bootstrap("getAccumulatedDeltaRangeUncertaintyInMeters", $$robo$$android_location_GpsMeasurement$getAccumulatedDeltaRangeUncertaintyInMeters(), 0, this);
    }

    public void setAccumulatedDeltaRangeUncertaintyInMeters(double d) {
        InvokeDynamicSupport.bootstrap("setAccumulatedDeltaRangeUncertaintyInMeters", $$robo$$android_location_GpsMeasurement$setAccumulatedDeltaRangeUncertaintyInMeters(double ), 0, this, d);
    }

    public boolean hasPseudorangeInMeters() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasPseudorangeInMeters", $$robo$$android_location_GpsMeasurement$hasPseudorangeInMeters(), 0, this);
    }

    public double getPseudorangeInMeters() {
        return (double)InvokeDynamicSupport.bootstrap("getPseudorangeInMeters", $$robo$$android_location_GpsMeasurement$getPseudorangeInMeters(), 0, this);
    }

    public void setPseudorangeInMeters(double d) {
        InvokeDynamicSupport.bootstrap("setPseudorangeInMeters", $$robo$$android_location_GpsMeasurement$setPseudorangeInMeters(double ), 0, this, d);
    }

    public void resetPseudorangeInMeters() {
        InvokeDynamicSupport.bootstrap("resetPseudorangeInMeters", $$robo$$android_location_GpsMeasurement$resetPseudorangeInMeters(), 0, this);
    }

    public boolean hasPseudorangeUncertaintyInMeters() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasPseudorangeUncertaintyInMeters", $$robo$$android_location_GpsMeasurement$hasPseudorangeUncertaintyInMeters(), 0, this);
    }

    public double getPseudorangeUncertaintyInMeters() {
        return (double)InvokeDynamicSupport.bootstrap("getPseudorangeUncertaintyInMeters", $$robo$$android_location_GpsMeasurement$getPseudorangeUncertaintyInMeters(), 0, this);
    }

    public void setPseudorangeUncertaintyInMeters(double d) {
        InvokeDynamicSupport.bootstrap("setPseudorangeUncertaintyInMeters", $$robo$$android_location_GpsMeasurement$setPseudorangeUncertaintyInMeters(double ), 0, this, d);
    }

    public void resetPseudorangeUncertaintyInMeters() {
        InvokeDynamicSupport.bootstrap("resetPseudorangeUncertaintyInMeters", $$robo$$android_location_GpsMeasurement$resetPseudorangeUncertaintyInMeters(), 0, this);
    }

    public boolean hasCodePhaseInChips() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasCodePhaseInChips", $$robo$$android_location_GpsMeasurement$hasCodePhaseInChips(), 0, this);
    }

    public double getCodePhaseInChips() {
        return (double)InvokeDynamicSupport.bootstrap("getCodePhaseInChips", $$robo$$android_location_GpsMeasurement$getCodePhaseInChips(), 0, this);
    }

    public void setCodePhaseInChips(double d) {
        InvokeDynamicSupport.bootstrap("setCodePhaseInChips", $$robo$$android_location_GpsMeasurement$setCodePhaseInChips(double ), 0, this, d);
    }

    public void resetCodePhaseInChips() {
        InvokeDynamicSupport.bootstrap("resetCodePhaseInChips", $$robo$$android_location_GpsMeasurement$resetCodePhaseInChips(), 0, this);
    }

    public boolean hasCodePhaseUncertaintyInChips() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasCodePhaseUncertaintyInChips", $$robo$$android_location_GpsMeasurement$hasCodePhaseUncertaintyInChips(), 0, this);
    }

    public double getCodePhaseUncertaintyInChips() {
        return (double)InvokeDynamicSupport.bootstrap("getCodePhaseUncertaintyInChips", $$robo$$android_location_GpsMeasurement$getCodePhaseUncertaintyInChips(), 0, this);
    }

    public void setCodePhaseUncertaintyInChips(double d) {
        InvokeDynamicSupport.bootstrap("setCodePhaseUncertaintyInChips", $$robo$$android_location_GpsMeasurement$setCodePhaseUncertaintyInChips(double ), 0, this, d);
    }

    public void resetCodePhaseUncertaintyInChips() {
        InvokeDynamicSupport.bootstrap("resetCodePhaseUncertaintyInChips", $$robo$$android_location_GpsMeasurement$resetCodePhaseUncertaintyInChips(), 0, this);
    }

    public boolean hasCarrierFrequencyInHz() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasCarrierFrequencyInHz", $$robo$$android_location_GpsMeasurement$hasCarrierFrequencyInHz(), 0, this);
    }

    public float getCarrierFrequencyInHz() {
        return (float)InvokeDynamicSupport.bootstrap("getCarrierFrequencyInHz", $$robo$$android_location_GpsMeasurement$getCarrierFrequencyInHz(), 0, this);
    }

    public void setCarrierFrequencyInHz(float f) {
        InvokeDynamicSupport.bootstrap("setCarrierFrequencyInHz", $$robo$$android_location_GpsMeasurement$setCarrierFrequencyInHz(float ), 0, this, f);
    }

    public void resetCarrierFrequencyInHz() {
        InvokeDynamicSupport.bootstrap("resetCarrierFrequencyInHz", $$robo$$android_location_GpsMeasurement$resetCarrierFrequencyInHz(), 0, this);
    }

    public boolean hasCarrierCycles() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasCarrierCycles", $$robo$$android_location_GpsMeasurement$hasCarrierCycles(), 0, this);
    }

    public long getCarrierCycles() {
        return (long)InvokeDynamicSupport.bootstrap("getCarrierCycles", $$robo$$android_location_GpsMeasurement$getCarrierCycles(), 0, this);
    }

    public void setCarrierCycles(long l) {
        InvokeDynamicSupport.bootstrap("setCarrierCycles", $$robo$$android_location_GpsMeasurement$setCarrierCycles(long ), 0, this, l);
    }

    public void resetCarrierCycles() {
        InvokeDynamicSupport.bootstrap("resetCarrierCycles", $$robo$$android_location_GpsMeasurement$resetCarrierCycles(), 0, this);
    }

    public boolean hasCarrierPhase() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasCarrierPhase", $$robo$$android_location_GpsMeasurement$hasCarrierPhase(), 0, this);
    }

    public double getCarrierPhase() {
        return (double)InvokeDynamicSupport.bootstrap("getCarrierPhase", $$robo$$android_location_GpsMeasurement$getCarrierPhase(), 0, this);
    }

    public void setCarrierPhase(double d) {
        InvokeDynamicSupport.bootstrap("setCarrierPhase", $$robo$$android_location_GpsMeasurement$setCarrierPhase(double ), 0, this, d);
    }

    public void resetCarrierPhase() {
        InvokeDynamicSupport.bootstrap("resetCarrierPhase", $$robo$$android_location_GpsMeasurement$resetCarrierPhase(), 0, this);
    }

    public boolean hasCarrierPhaseUncertainty() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasCarrierPhaseUncertainty", $$robo$$android_location_GpsMeasurement$hasCarrierPhaseUncertainty(), 0, this);
    }

    public double getCarrierPhaseUncertainty() {
        return (double)InvokeDynamicSupport.bootstrap("getCarrierPhaseUncertainty", $$robo$$android_location_GpsMeasurement$getCarrierPhaseUncertainty(), 0, this);
    }

    public void setCarrierPhaseUncertainty(double d) {
        InvokeDynamicSupport.bootstrap("setCarrierPhaseUncertainty", $$robo$$android_location_GpsMeasurement$setCarrierPhaseUncertainty(double ), 0, this, d);
    }

    public void resetCarrierPhaseUncertainty() {
        InvokeDynamicSupport.bootstrap("resetCarrierPhaseUncertainty", $$robo$$android_location_GpsMeasurement$resetCarrierPhaseUncertainty(), 0, this);
    }

    public byte getLossOfLock() {
        return (byte)InvokeDynamicSupport.bootstrap("getLossOfLock", $$robo$$android_location_GpsMeasurement$getLossOfLock(), 0, this);
    }

    public void setLossOfLock(byte by) {
        InvokeDynamicSupport.bootstrap("setLossOfLock", $$robo$$android_location_GpsMeasurement$setLossOfLock(byte ), 0, this, by);
    }

    private String getLossOfLockString() {
        return InvokeDynamicSupport.bootstrap("getLossOfLockString", $$robo$$android_location_GpsMeasurement$getLossOfLockString(), 0, this);
    }

    public boolean hasBitNumber() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasBitNumber", $$robo$$android_location_GpsMeasurement$hasBitNumber(), 0, this);
    }

    public int getBitNumber() {
        return (int)InvokeDynamicSupport.bootstrap("getBitNumber", $$robo$$android_location_GpsMeasurement$getBitNumber(), 0, this);
    }

    public void setBitNumber(int n) {
        InvokeDynamicSupport.bootstrap("setBitNumber", $$robo$$android_location_GpsMeasurement$setBitNumber(int ), 0, this, n);
    }

    public void resetBitNumber() {
        InvokeDynamicSupport.bootstrap("resetBitNumber", $$robo$$android_location_GpsMeasurement$resetBitNumber(), 0, this);
    }

    public boolean hasTimeFromLastBitInMs() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasTimeFromLastBitInMs", $$robo$$android_location_GpsMeasurement$hasTimeFromLastBitInMs(), 0, this);
    }

    public short getTimeFromLastBitInMs() {
        return (short)InvokeDynamicSupport.bootstrap("getTimeFromLastBitInMs", $$robo$$android_location_GpsMeasurement$getTimeFromLastBitInMs(), 0, this);
    }

    public void setTimeFromLastBitInMs(short s) {
        InvokeDynamicSupport.bootstrap("setTimeFromLastBitInMs", $$robo$$android_location_GpsMeasurement$setTimeFromLastBitInMs(short ), 0, this, s);
    }

    public void resetTimeFromLastBitInMs() {
        InvokeDynamicSupport.bootstrap("resetTimeFromLastBitInMs", $$robo$$android_location_GpsMeasurement$resetTimeFromLastBitInMs(), 0, this);
    }

    public boolean hasDopplerShiftInHz() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasDopplerShiftInHz", $$robo$$android_location_GpsMeasurement$hasDopplerShiftInHz(), 0, this);
    }

    public double getDopplerShiftInHz() {
        return (double)InvokeDynamicSupport.bootstrap("getDopplerShiftInHz", $$robo$$android_location_GpsMeasurement$getDopplerShiftInHz(), 0, this);
    }

    public void setDopplerShiftInHz(double d) {
        InvokeDynamicSupport.bootstrap("setDopplerShiftInHz", $$robo$$android_location_GpsMeasurement$setDopplerShiftInHz(double ), 0, this, d);
    }

    public void resetDopplerShiftInHz() {
        InvokeDynamicSupport.bootstrap("resetDopplerShiftInHz", $$robo$$android_location_GpsMeasurement$resetDopplerShiftInHz(), 0, this);
    }

    public boolean hasDopplerShiftUncertaintyInHz() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasDopplerShiftUncertaintyInHz", $$robo$$android_location_GpsMeasurement$hasDopplerShiftUncertaintyInHz(), 0, this);
    }

    public double getDopplerShiftUncertaintyInHz() {
        return (double)InvokeDynamicSupport.bootstrap("getDopplerShiftUncertaintyInHz", $$robo$$android_location_GpsMeasurement$getDopplerShiftUncertaintyInHz(), 0, this);
    }

    public void setDopplerShiftUncertaintyInHz(double d) {
        InvokeDynamicSupport.bootstrap("setDopplerShiftUncertaintyInHz", $$robo$$android_location_GpsMeasurement$setDopplerShiftUncertaintyInHz(double ), 0, this, d);
    }

    public void resetDopplerShiftUncertaintyInHz() {
        InvokeDynamicSupport.bootstrap("resetDopplerShiftUncertaintyInHz", $$robo$$android_location_GpsMeasurement$resetDopplerShiftUncertaintyInHz(), 0, this);
    }

    public byte getMultipathIndicator() {
        return (byte)InvokeDynamicSupport.bootstrap("getMultipathIndicator", $$robo$$android_location_GpsMeasurement$getMultipathIndicator(), 0, this);
    }

    public void setMultipathIndicator(byte by) {
        InvokeDynamicSupport.bootstrap("setMultipathIndicator", $$robo$$android_location_GpsMeasurement$setMultipathIndicator(byte ), 0, this, by);
    }

    private String getMultipathIndicatorString() {
        return InvokeDynamicSupport.bootstrap("getMultipathIndicatorString", $$robo$$android_location_GpsMeasurement$getMultipathIndicatorString(), 0, this);
    }

    public boolean hasSnrInDb() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasSnrInDb", $$robo$$android_location_GpsMeasurement$hasSnrInDb(), 0, this);
    }

    public double getSnrInDb() {
        return (double)InvokeDynamicSupport.bootstrap("getSnrInDb", $$robo$$android_location_GpsMeasurement$getSnrInDb(), 0, this);
    }

    public void setSnrInDb(double d) {
        InvokeDynamicSupport.bootstrap("setSnrInDb", $$robo$$android_location_GpsMeasurement$setSnrInDb(double ), 0, this, d);
    }

    public void resetSnrInDb() {
        InvokeDynamicSupport.bootstrap("resetSnrInDb", $$robo$$android_location_GpsMeasurement$resetSnrInDb(), 0, this);
    }

    public boolean hasElevationInDeg() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasElevationInDeg", $$robo$$android_location_GpsMeasurement$hasElevationInDeg(), 0, this);
    }

    public double getElevationInDeg() {
        return (double)InvokeDynamicSupport.bootstrap("getElevationInDeg", $$robo$$android_location_GpsMeasurement$getElevationInDeg(), 0, this);
    }

    public void setElevationInDeg(double d) {
        InvokeDynamicSupport.bootstrap("setElevationInDeg", $$robo$$android_location_GpsMeasurement$setElevationInDeg(double ), 0, this, d);
    }

    public void resetElevationInDeg() {
        InvokeDynamicSupport.bootstrap("resetElevationInDeg", $$robo$$android_location_GpsMeasurement$resetElevationInDeg(), 0, this);
    }

    public boolean hasElevationUncertaintyInDeg() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasElevationUncertaintyInDeg", $$robo$$android_location_GpsMeasurement$hasElevationUncertaintyInDeg(), 0, this);
    }

    public double getElevationUncertaintyInDeg() {
        return (double)InvokeDynamicSupport.bootstrap("getElevationUncertaintyInDeg", $$robo$$android_location_GpsMeasurement$getElevationUncertaintyInDeg(), 0, this);
    }

    public void setElevationUncertaintyInDeg(double d) {
        InvokeDynamicSupport.bootstrap("setElevationUncertaintyInDeg", $$robo$$android_location_GpsMeasurement$setElevationUncertaintyInDeg(double ), 0, this, d);
    }

    public void resetElevationUncertaintyInDeg() {
        InvokeDynamicSupport.bootstrap("resetElevationUncertaintyInDeg", $$robo$$android_location_GpsMeasurement$resetElevationUncertaintyInDeg(), 0, this);
    }

    public boolean hasAzimuthInDeg() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasAzimuthInDeg", $$robo$$android_location_GpsMeasurement$hasAzimuthInDeg(), 0, this);
    }

    public double getAzimuthInDeg() {
        return (double)InvokeDynamicSupport.bootstrap("getAzimuthInDeg", $$robo$$android_location_GpsMeasurement$getAzimuthInDeg(), 0, this);
    }

    public void setAzimuthInDeg(double d) {
        InvokeDynamicSupport.bootstrap("setAzimuthInDeg", $$robo$$android_location_GpsMeasurement$setAzimuthInDeg(double ), 0, this, d);
    }

    public void resetAzimuthInDeg() {
        InvokeDynamicSupport.bootstrap("resetAzimuthInDeg", $$robo$$android_location_GpsMeasurement$resetAzimuthInDeg(), 0, this);
    }

    public boolean hasAzimuthUncertaintyInDeg() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasAzimuthUncertaintyInDeg", $$robo$$android_location_GpsMeasurement$hasAzimuthUncertaintyInDeg(), 0, this);
    }

    public double getAzimuthUncertaintyInDeg() {
        return (double)InvokeDynamicSupport.bootstrap("getAzimuthUncertaintyInDeg", $$robo$$android_location_GpsMeasurement$getAzimuthUncertaintyInDeg(), 0, this);
    }

    public void setAzimuthUncertaintyInDeg(double d) {
        InvokeDynamicSupport.bootstrap("setAzimuthUncertaintyInDeg", $$robo$$android_location_GpsMeasurement$setAzimuthUncertaintyInDeg(double ), 0, this, d);
    }

    public void resetAzimuthUncertaintyInDeg() {
        InvokeDynamicSupport.bootstrap("resetAzimuthUncertaintyInDeg", $$robo$$android_location_GpsMeasurement$resetAzimuthUncertaintyInDeg(), 0, this);
    }

    public boolean isUsedInFix() {
        return (boolean)InvokeDynamicSupport.bootstrap("isUsedInFix", $$robo$$android_location_GpsMeasurement$isUsedInFix(), 0, this);
    }

    public void setUsedInFix(boolean bl) {
        InvokeDynamicSupport.bootstrap("setUsedInFix", $$robo$$android_location_GpsMeasurement$setUsedInFix(boolean ), 0, this, bl);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_location_GpsMeasurement$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_location_GpsMeasurement$describeContents(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_location_GpsMeasurement$toString(), 0, this);
    }

    private void initialize() {
        InvokeDynamicSupport.bootstrap("initialize", $$robo$$android_location_GpsMeasurement$initialize(), 0, this);
    }

    private void setFlag(int n) {
        InvokeDynamicSupport.bootstrap("setFlag", $$robo$$android_location_GpsMeasurement$setFlag(int ), 0, this, n);
    }

    private void resetFlag(int n) {
        InvokeDynamicSupport.bootstrap("resetFlag", $$robo$$android_location_GpsMeasurement$resetFlag(int ), 0, this, n);
    }

    private boolean isFlagSet(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isFlagSet", $$robo$$android_location_GpsMeasurement$isFlagSet(int ), 0, this, n);
    }

    static {
        RobolectricInternals.classInitializing(GpsMeasurement.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GpsMeasurement)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

