/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.os.RemoteException;
import android.util.Log;
import com.android.internal.util.Preconditions;
import java.util.ArrayList;
import java.util.HashSet;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;

public abstract class LocalListenerHelper<TListener> {
    public transient /* synthetic */ Object __robo_data__;
    private HashSet<TListener> mListeners;
    private String mTag;

    private void $$robo$$android_location_LocalListenerHelper$__constructor__(String name) {
        this.mListeners = new HashSet();
        Preconditions.checkNotNull(name);
        this.mTag = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_location_LocalListenerHelper$add(TListener listener) {
        Preconditions.checkNotNull(listener);
        HashSet<TListener> hashSet = this.mListeners;
        synchronized (hashSet) {
            if (this.mListeners.isEmpty()) {
                boolean registeredWithService;
                try {
                    registeredWithService = this.registerWithServer();
                }
                catch (RemoteException e) {
                    Log.e(this.mTag, "Error handling first listener.", e);
                    return false;
                }
                if (!registeredWithService) {
                    Log.e(this.mTag, "Unable to register listener transport.");
                    return false;
                }
            }
            if (this.mListeners.contains(listener)) {
                return true;
            }
            this.mListeners.add(listener);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_location_LocalListenerHelper$remove(TListener listener) {
        Preconditions.checkNotNull(listener);
        HashSet<TListener> hashSet = this.mListeners;
        synchronized (hashSet) {
            boolean isLastRemoved;
            boolean removed = this.mListeners.remove(listener);
            boolean bl = isLastRemoved = removed && this.mListeners.isEmpty();
            if (isLastRemoved) {
                try {
                    this.unregisterFromServer();
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
    }

    protected abstract boolean registerWithServer() throws RemoteException;

    protected abstract void unregisterFromServer() throws RemoteException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_location_LocalListenerHelper$foreach(ListenerOperation operation) {
        ArrayList<TListener> listeners;
        HashSet<TListener> hashSet = this.mListeners;
        synchronized (hashSet) {
            listeners = new ArrayList<TListener>(this.mListeners);
        }
        for (Object listener : listeners) {
            try {
                operation.execute(listener);
            }
            catch (RemoteException e) {
                Log.e(this.mTag, "Error in monitored listener.", e);
            }
        }
    }

    private void __constructor__(String string2) {
        this.$$robo$$android_location_LocalListenerHelper$__constructor__(string2);
    }

    protected LocalListenerHelper(String string2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_location_LocalListenerHelper$__constructor__(java.lang.String ), 0, this, string2);
    }

    public boolean add(TListener TListener) {
        return (boolean)InvokeDynamicSupport.bootstrap("add", $$robo$$android_location_LocalListenerHelper$add(TListener ), 0, this, TListener);
    }

    public void remove(TListener TListener) {
        InvokeDynamicSupport.bootstrap("remove", $$robo$$android_location_LocalListenerHelper$remove(TListener ), 0, this, TListener);
    }

    protected void foreach(ListenerOperation listenerOperation) {
        InvokeDynamicSupport.bootstrap("foreach", $$robo$$android_location_LocalListenerHelper$foreach(android.location.LocalListenerHelper$ListenerOperation ), 0, this, listenerOperation);
    }

    public /* synthetic */ LocalListenerHelper() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LocalListenerHelper)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    protected static interface ListenerOperation<TListener> {
        public void execute(TListener var1) throws RemoteException;
    }
}

