/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.app.PendingIntent;
import android.content.Context;
import android.location.Criteria;
import android.location.Geofence;
import android.location.GpsMeasurementListenerTransport;
import android.location.GpsMeasurementsEvent;
import android.location.GpsNavigationMessageEvent;
import android.location.GpsNavigationMessageListenerTransport;
import android.location.GpsStatus;
import android.location.IGpsStatusListener;
import android.location.ILocationListener;
import android.location.ILocationManager;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationProvider;
import android.location.LocationRequest;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import com.android.internal.location.ProviderProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class LocationManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "LocationManager";
    private Context mContext;
    private ILocationManager mService;
    private GpsMeasurementListenerTransport mGpsMeasurementListenerTransport;
    private GpsNavigationMessageListenerTransport mGpsNavigationMessageListenerTransport;
    private HashMap<GpsStatus.Listener, GpsStatusListenerTransport> mGpsStatusListeners;
    private HashMap<GpsStatus.NmeaListener, GpsStatusListenerTransport> mNmeaListeners;
    private GpsStatus mGpsStatus;
    public static String NETWORK_PROVIDER = "network";
    public static String GPS_PROVIDER = "gps";
    public static String PASSIVE_PROVIDER = "passive";
    public static String FUSED_PROVIDER = "fused";
    public static String KEY_PROXIMITY_ENTERING = "entering";
    public static String KEY_STATUS_CHANGED = "status";
    public static String KEY_PROVIDER_ENABLED = "providerEnabled";
    public static String KEY_LOCATION_CHANGED = "location";
    public static String GPS_ENABLED_CHANGE_ACTION = "android.location.GPS_ENABLED_CHANGE";
    public static String PROVIDERS_CHANGED_ACTION = "android.location.PROVIDERS_CHANGED";
    public static String MODE_CHANGED_ACTION = "android.location.MODE_CHANGED";
    public static String GPS_FIX_CHANGE_ACTION = "android.location.GPS_FIX_CHANGE";
    public static String EXTRA_GPS_ENABLED = "enabled";
    public static String HIGH_POWER_REQUEST_CHANGE_ACTION = "android.location.HIGH_POWER_REQUEST_CHANGE";
    private HashMap<LocationListener, ListenerTransport> mListeners;

    private void $$robo$$android_location_LocationManager$__constructor__(Context context, ILocationManager service) {
        this.mGpsStatusListeners = new HashMap();
        this.mNmeaListeners = new HashMap();
        this.mGpsStatus = new GpsStatus();
        this.mListeners = new HashMap();
        this.mService = service;
        this.mContext = context;
        this.mGpsMeasurementListenerTransport = new GpsMeasurementListenerTransport(this.mContext, this.mService);
        this.mGpsNavigationMessageListenerTransport = new GpsNavigationMessageListenerTransport(this.mContext, this.mService);
    }

    private final LocationProvider $$robo$$android_location_LocationManager$createProvider(String name, ProviderProperties properties) {
        return new LocationProvider(name, properties);
    }

    private final List<String> $$robo$$android_location_LocationManager$getAllProviders() {
        try {
            return this.mService.getAllProviders();
        }
        catch (RemoteException e) {
            Log.e("LocationManager", "RemoteException", e);
            return null;
        }
    }

    private final List<String> $$robo$$android_location_LocationManager$getProviders(boolean enabledOnly) {
        try {
            return this.mService.getProviders(null, enabledOnly);
        }
        catch (RemoteException e) {
            Log.e("LocationManager", "RemoteException", e);
            return null;
        }
    }

    private final LocationProvider $$robo$$android_location_LocationManager$getProvider(String name) {
        LocationManager.checkProvider(name);
        try {
            ProviderProperties properties = this.mService.getProviderProperties(name);
            if (properties == null) {
                return null;
            }
            return this.createProvider(name, properties);
        }
        catch (RemoteException e) {
            Log.e("LocationManager", "RemoteException", e);
            return null;
        }
    }

    private final List<String> $$robo$$android_location_LocationManager$getProviders(Criteria criteria, boolean enabledOnly) {
        LocationManager.checkCriteria(criteria);
        try {
            return this.mService.getProviders(criteria, enabledOnly);
        }
        catch (RemoteException e) {
            Log.e("LocationManager", "RemoteException", e);
            return null;
        }
    }

    private final String $$robo$$android_location_LocationManager$getBestProvider(Criteria criteria, boolean enabledOnly) {
        LocationManager.checkCriteria(criteria);
        try {
            return this.mService.getBestProvider(criteria, enabledOnly);
        }
        catch (RemoteException e) {
            Log.e("LocationManager", "RemoteException", e);
            return null;
        }
    }

    private final void $$robo$$android_location_LocationManager$requestLocationUpdates(String provider, long minTime, float minDistance, LocationListener listener) {
        LocationManager.checkProvider(provider);
        LocationManager.checkListener(listener);
        LocationRequest request = LocationRequest.createFromDeprecatedProvider(provider, minTime, minDistance, false);
        this.requestLocationUpdates(request, listener, null, null);
    }

    private final void $$robo$$android_location_LocationManager$requestLocationUpdates(String provider, long minTime, float minDistance, LocationListener listener, Looper looper) {
        LocationManager.checkProvider(provider);
        LocationManager.checkListener(listener);
        LocationRequest request = LocationRequest.createFromDeprecatedProvider(provider, minTime, minDistance, false);
        this.requestLocationUpdates(request, listener, looper, null);
    }

    private final void $$robo$$android_location_LocationManager$requestLocationUpdates(long minTime, float minDistance, Criteria criteria, LocationListener listener, Looper looper) {
        LocationManager.checkCriteria(criteria);
        LocationManager.checkListener(listener);
        LocationRequest request = LocationRequest.createFromDeprecatedCriteria(criteria, minTime, minDistance, false);
        this.requestLocationUpdates(request, listener, looper, null);
    }

    private final void $$robo$$android_location_LocationManager$requestLocationUpdates(String provider, long minTime, float minDistance, PendingIntent intent) {
        LocationManager.checkProvider(provider);
        this.checkPendingIntent(intent);
        LocationRequest request = LocationRequest.createFromDeprecatedProvider(provider, minTime, minDistance, false);
        this.requestLocationUpdates(request, null, null, intent);
    }

    private final void $$robo$$android_location_LocationManager$requestLocationUpdates(long minTime, float minDistance, Criteria criteria, PendingIntent intent) {
        LocationManager.checkCriteria(criteria);
        this.checkPendingIntent(intent);
        LocationRequest request = LocationRequest.createFromDeprecatedCriteria(criteria, minTime, minDistance, false);
        this.requestLocationUpdates(request, null, null, intent);
    }

    private final void $$robo$$android_location_LocationManager$requestSingleUpdate(String provider, LocationListener listener, Looper looper) {
        LocationManager.checkProvider(provider);
        LocationManager.checkListener(listener);
        LocationRequest request = LocationRequest.createFromDeprecatedProvider(provider, 0L, 0.0f, true);
        this.requestLocationUpdates(request, listener, looper, null);
    }

    private final void $$robo$$android_location_LocationManager$requestSingleUpdate(Criteria criteria, LocationListener listener, Looper looper) {
        LocationManager.checkCriteria(criteria);
        LocationManager.checkListener(listener);
        LocationRequest request = LocationRequest.createFromDeprecatedCriteria(criteria, 0L, 0.0f, true);
        this.requestLocationUpdates(request, listener, looper, null);
    }

    private final void $$robo$$android_location_LocationManager$requestSingleUpdate(String provider, PendingIntent intent) {
        LocationManager.checkProvider(provider);
        this.checkPendingIntent(intent);
        LocationRequest request = LocationRequest.createFromDeprecatedProvider(provider, 0L, 0.0f, true);
        this.requestLocationUpdates(request, null, null, intent);
    }

    private final void $$robo$$android_location_LocationManager$requestSingleUpdate(Criteria criteria, PendingIntent intent) {
        LocationManager.checkCriteria(criteria);
        this.checkPendingIntent(intent);
        LocationRequest request = LocationRequest.createFromDeprecatedCriteria(criteria, 0L, 0.0f, true);
        this.requestLocationUpdates(request, null, null, intent);
    }

    private final void $$robo$$android_location_LocationManager$requestLocationUpdates(LocationRequest request, LocationListener listener, Looper looper) {
        LocationManager.checkListener(listener);
        this.requestLocationUpdates(request, listener, looper, null);
    }

    private final void $$robo$$android_location_LocationManager$requestLocationUpdates(LocationRequest request, PendingIntent intent) {
        this.checkPendingIntent(intent);
        this.requestLocationUpdates(request, null, null, intent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ListenerTransport $$robo$$android_location_LocationManager$wrapListener(LocationListener listener, Looper looper) {
        if (listener == null) {
            return null;
        }
        HashMap<LocationListener, ListenerTransport> hashMap = this.mListeners;
        synchronized (hashMap) {
            ListenerTransport transport = this.mListeners.get(listener);
            if (transport == null) {
                transport = new ListenerTransport(this, listener, looper);
            }
            this.mListeners.put(listener, transport);
            return transport;
        }
    }

    private final void $$robo$$android_location_LocationManager$requestLocationUpdates(LocationRequest request, LocationListener listener, Looper looper, PendingIntent intent) {
        String packageName = this.mContext.getPackageName();
        ListenerTransport transport = this.wrapListener(listener, looper);
        try {
            this.mService.requestLocationUpdates(request, transport, intent, packageName);
        }
        catch (RemoteException e) {
            Log.e("LocationManager", "RemoteException", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_location_LocationManager$removeUpdates(LocationListener listener) {
        ListenerTransport transport;
        LocationManager.checkListener(listener);
        String packageName = this.mContext.getPackageName();
        HashMap<LocationListener, ListenerTransport> hashMap = this.mListeners;
        synchronized (hashMap) {
            transport = this.mListeners.remove(listener);
        }
        if (transport == null) {
            return;
        }
        try {
            this.mService.removeUpdates(transport, null, packageName);
        }
        catch (RemoteException e) {
            Log.e("LocationManager", "RemoteException", e);
        }
    }

    private final void $$robo$$android_location_LocationManager$removeUpdates(PendingIntent intent) {
        this.checkPendingIntent(intent);
        String packageName = this.mContext.getPackageName();
        try {
            this.mService.removeUpdates(null, intent, packageName);
        }
        catch (RemoteException e) {
            Log.e("LocationManager", "RemoteException", e);
        }
    }

    private final void $$robo$$android_location_LocationManager$addProximityAlert(double latitude, double longitude, float radius, long expiration, PendingIntent intent) {
        this.checkPendingIntent(intent);
        if (expiration < 0L) {
            expiration = Long.MAX_VALUE;
        }
        Geofence fence = Geofence.createCircle(latitude, longitude, radius);
        LocationRequest request = new LocationRequest().setExpireIn(expiration);
        try {
            this.mService.requestGeofence(request, fence, intent, this.mContext.getPackageName());
        }
        catch (RemoteException e) {
            Log.e("LocationManager", "RemoteException", e);
        }
    }

    private final void $$robo$$android_location_LocationManager$addGeofence(LocationRequest request, Geofence fence, PendingIntent intent) {
        this.checkPendingIntent(intent);
        LocationManager.checkGeofence(fence);
        try {
            this.mService.requestGeofence(request, fence, intent, this.mContext.getPackageName());
        }
        catch (RemoteException e) {
            Log.e("LocationManager", "RemoteException", e);
        }
    }

    private final void $$robo$$android_location_LocationManager$removeProximityAlert(PendingIntent intent) {
        this.checkPendingIntent(intent);
        String packageName = this.mContext.getPackageName();
        try {
            this.mService.removeGeofence(null, intent, packageName);
        }
        catch (RemoteException e) {
            Log.e("LocationManager", "RemoteException", e);
        }
    }

    private final void $$robo$$android_location_LocationManager$removeGeofence(Geofence fence, PendingIntent intent) {
        this.checkPendingIntent(intent);
        LocationManager.checkGeofence(fence);
        String packageName = this.mContext.getPackageName();
        try {
            this.mService.removeGeofence(fence, intent, packageName);
        }
        catch (RemoteException e) {
            Log.e("LocationManager", "RemoteException", e);
        }
    }

    private final void $$robo$$android_location_LocationManager$removeAllGeofences(PendingIntent intent) {
        this.checkPendingIntent(intent);
        String packageName = this.mContext.getPackageName();
        try {
            this.mService.removeGeofence(null, intent, packageName);
        }
        catch (RemoteException e) {
            Log.e("LocationManager", "RemoteException", e);
        }
    }

    private final boolean $$robo$$android_location_LocationManager$isProviderEnabled(String provider) {
        LocationManager.checkProvider(provider);
        try {
            return this.mService.isProviderEnabled(provider);
        }
        catch (RemoteException e) {
            Log.e("LocationManager", "RemoteException", e);
            return false;
        }
    }

    private final Location $$robo$$android_location_LocationManager$getLastLocation() {
        String packageName = this.mContext.getPackageName();
        try {
            return this.mService.getLastLocation(null, packageName);
        }
        catch (RemoteException e) {
            Log.e("LocationManager", "RemoteException", e);
            return null;
        }
    }

    private final Location $$robo$$android_location_LocationManager$getLastKnownLocation(String provider) {
        LocationManager.checkProvider(provider);
        String packageName = this.mContext.getPackageName();
        LocationRequest request = LocationRequest.createFromDeprecatedProvider(provider, 0L, 0.0f, true);
        try {
            return this.mService.getLastLocation(request, packageName);
        }
        catch (RemoteException e) {
            Log.e("LocationManager", "RemoteException", e);
            return null;
        }
    }

    private final void $$robo$$android_location_LocationManager$addTestProvider(String name, boolean requiresNetwork, boolean requiresSatellite, boolean requiresCell, boolean hasMonetaryCost, boolean supportsAltitude, boolean supportsSpeed, boolean supportsBearing, int powerRequirement, int accuracy) {
        ProviderProperties properties = new ProviderProperties(requiresNetwork, requiresSatellite, requiresCell, hasMonetaryCost, supportsAltitude, supportsSpeed, supportsBearing, powerRequirement, accuracy);
        if (name.matches("[^a-zA-Z0-9]")) {
            throw new IllegalArgumentException("provider name contains illegal character: " + name);
        }
        try {
            this.mService.addTestProvider(name, properties);
        }
        catch (RemoteException e) {
            Log.e("LocationManager", "RemoteException", e);
        }
    }

    private final void $$robo$$android_location_LocationManager$removeTestProvider(String provider) {
        try {
            this.mService.removeTestProvider(provider);
        }
        catch (RemoteException e) {
            Log.e("LocationManager", "RemoteException", e);
        }
    }

    private final void $$robo$$android_location_LocationManager$setTestProviderLocation(String provider, Location loc) {
        if (!loc.isComplete()) {
            IllegalArgumentException e = new IllegalArgumentException("Incomplete location object, missing timestamp or accuracy? " + loc);
            if (this.mContext.getApplicationInfo().targetSdkVersion <= 16) {
                Log.w("LocationManager", e);
                loc.makeComplete();
            } else {
                throw e;
            }
        }
        try {
            this.mService.setTestProviderLocation(provider, loc);
        }
        catch (RemoteException e) {
            Log.e("LocationManager", "RemoteException", e);
        }
    }

    private final void $$robo$$android_location_LocationManager$clearTestProviderLocation(String provider) {
        try {
            this.mService.clearTestProviderLocation(provider);
        }
        catch (RemoteException e) {
            Log.e("LocationManager", "RemoteException", e);
        }
    }

    private final void $$robo$$android_location_LocationManager$setTestProviderEnabled(String provider, boolean enabled) {
        try {
            this.mService.setTestProviderEnabled(provider, enabled);
        }
        catch (RemoteException e) {
            Log.e("LocationManager", "RemoteException", e);
        }
    }

    private final void $$robo$$android_location_LocationManager$clearTestProviderEnabled(String provider) {
        try {
            this.mService.clearTestProviderEnabled(provider);
        }
        catch (RemoteException e) {
            Log.e("LocationManager", "RemoteException", e);
        }
    }

    private final void $$robo$$android_location_LocationManager$setTestProviderStatus(String provider, int status, Bundle extras, long updateTime) {
        try {
            this.mService.setTestProviderStatus(provider, status, extras, updateTime);
        }
        catch (RemoteException e) {
            Log.e("LocationManager", "RemoteException", e);
        }
    }

    private final void $$robo$$android_location_LocationManager$clearTestProviderStatus(String provider) {
        try {
            this.mService.clearTestProviderStatus(provider);
        }
        catch (RemoteException e) {
            Log.e("LocationManager", "RemoteException", e);
        }
    }

    private final boolean $$robo$$android_location_LocationManager$addGpsStatusListener(GpsStatus.Listener listener) {
        boolean result;
        if (this.mGpsStatusListeners.get(listener) != null) {
            return true;
        }
        try {
            GpsStatusListenerTransport transport = new GpsStatusListenerTransport(this, listener);
            result = this.mService.addGpsStatusListener(transport, this.mContext.getPackageName());
            if (result) {
                this.mGpsStatusListeners.put(listener, transport);
            }
        }
        catch (RemoteException e) {
            Log.e("LocationManager", "RemoteException in registerGpsStatusListener: ", e);
            result = false;
        }
        return result;
    }

    private final void $$robo$$android_location_LocationManager$removeGpsStatusListener(GpsStatus.Listener listener) {
        try {
            GpsStatusListenerTransport transport = this.mGpsStatusListeners.remove(listener);
            if (transport != null) {
                this.mService.removeGpsStatusListener(transport);
            }
        }
        catch (RemoteException e) {
            Log.e("LocationManager", "RemoteException in unregisterGpsStatusListener: ", e);
        }
    }

    private final boolean $$robo$$android_location_LocationManager$addNmeaListener(GpsStatus.NmeaListener listener) {
        boolean result;
        if (this.mNmeaListeners.get(listener) != null) {
            return true;
        }
        try {
            GpsStatusListenerTransport transport = new GpsStatusListenerTransport(this, listener);
            result = this.mService.addGpsStatusListener(transport, this.mContext.getPackageName());
            if (result) {
                this.mNmeaListeners.put(listener, transport);
            }
        }
        catch (RemoteException e) {
            Log.e("LocationManager", "RemoteException in registerGpsStatusListener: ", e);
            result = false;
        }
        return result;
    }

    private final void $$robo$$android_location_LocationManager$removeNmeaListener(GpsStatus.NmeaListener listener) {
        try {
            GpsStatusListenerTransport transport = this.mNmeaListeners.remove(listener);
            if (transport != null) {
                this.mService.removeGpsStatusListener(transport);
            }
        }
        catch (RemoteException e) {
            Log.e("LocationManager", "RemoteException in unregisterGpsStatusListener: ", e);
        }
    }

    private final boolean $$robo$$android_location_LocationManager$addGpsMeasurementListener(GpsMeasurementsEvent.Listener listener) {
        return this.mGpsMeasurementListenerTransport.add(listener);
    }

    private final void $$robo$$android_location_LocationManager$removeGpsMeasurementListener(GpsMeasurementsEvent.Listener listener) {
        this.mGpsMeasurementListenerTransport.remove(listener);
    }

    private final boolean $$robo$$android_location_LocationManager$addGpsNavigationMessageListener(GpsNavigationMessageEvent.Listener listener) {
        return this.mGpsNavigationMessageListenerTransport.add(listener);
    }

    private final void $$robo$$android_location_LocationManager$removeGpsNavigationMessageListener(GpsNavigationMessageEvent.Listener listener) {
        this.mGpsNavigationMessageListenerTransport.remove(listener);
    }

    private final GpsStatus $$robo$$android_location_LocationManager$getGpsStatus(GpsStatus status) {
        if (status == null) {
            status = new GpsStatus();
        }
        status.setStatus(this.mGpsStatus);
        return status;
    }

    private final boolean $$robo$$android_location_LocationManager$sendExtraCommand(String provider, String command, Bundle extras) {
        try {
            return this.mService.sendExtraCommand(provider, command, extras);
        }
        catch (RemoteException e) {
            Log.e("LocationManager", "RemoteException in sendExtraCommand: ", e);
            return false;
        }
    }

    private final boolean $$robo$$android_location_LocationManager$sendNiResponse(int notifId, int userResponse) {
        try {
            return this.mService.sendNiResponse(notifId, userResponse);
        }
        catch (RemoteException e) {
            Log.e("LocationManager", "RemoteException in sendNiResponse: ", e);
            return false;
        }
    }

    private static final void $$robo$$android_location_LocationManager$checkProvider(String provider) {
        if (provider == null) {
            throw new IllegalArgumentException("invalid provider: " + provider);
        }
    }

    private static final void $$robo$$android_location_LocationManager$checkCriteria(Criteria criteria) {
        if (criteria == null) {
            throw new IllegalArgumentException("invalid criteria: " + criteria);
        }
    }

    private static final void $$robo$$android_location_LocationManager$checkListener(LocationListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("invalid listener: " + listener);
        }
    }

    private final void $$robo$$android_location_LocationManager$checkPendingIntent(PendingIntent intent) {
        if (intent == null) {
            throw new IllegalArgumentException("invalid pending intent: " + intent);
        }
        if (!intent.isTargetedToPackage()) {
            IllegalArgumentException e = new IllegalArgumentException("pending intent must be targeted to package");
            if (this.mContext.getApplicationInfo().targetSdkVersion > 16) {
                throw e;
            }
            Log.w("LocationManager", e);
        }
    }

    private static final void $$robo$$android_location_LocationManager$checkGeofence(Geofence fence) {
        if (fence == null) {
            throw new IllegalArgumentException("invalid geofence: " + fence);
        }
    }

    private void __constructor__(Context context, ILocationManager iLocationManager) {
        this.$$robo$$android_location_LocationManager$__constructor__(context, iLocationManager);
    }

    public LocationManager(Context context, ILocationManager iLocationManager) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_location_LocationManager$__constructor__(android.content.Context android.location.ILocationManager ), 0, this, context, iLocationManager);
    }

    private LocationProvider createProvider(String string2, ProviderProperties providerProperties) {
        return InvokeDynamicSupport.bootstrap("createProvider", $$robo$$android_location_LocationManager$createProvider(java.lang.String com.android.internal.location.ProviderProperties ), 0, this, string2, providerProperties);
    }

    public List<String> getAllProviders() {
        return InvokeDynamicSupport.bootstrap("getAllProviders", $$robo$$android_location_LocationManager$getAllProviders(), 0, this);
    }

    public List<String> getProviders(boolean bl) {
        return InvokeDynamicSupport.bootstrap("getProviders", $$robo$$android_location_LocationManager$getProviders(boolean ), 0, this, bl);
    }

    public LocationProvider getProvider(String string2) {
        return InvokeDynamicSupport.bootstrap("getProvider", $$robo$$android_location_LocationManager$getProvider(java.lang.String ), 0, this, string2);
    }

    public List<String> getProviders(Criteria criteria, boolean bl) {
        return InvokeDynamicSupport.bootstrap("getProviders", $$robo$$android_location_LocationManager$getProviders(android.location.Criteria boolean ), 0, this, criteria, bl);
    }

    public String getBestProvider(Criteria criteria, boolean bl) {
        return InvokeDynamicSupport.bootstrap("getBestProvider", $$robo$$android_location_LocationManager$getBestProvider(android.location.Criteria boolean ), 0, this, criteria, bl);
    }

    public void requestLocationUpdates(String string2, long l, float f, LocationListener locationListener) {
        InvokeDynamicSupport.bootstrap("requestLocationUpdates", $$robo$$android_location_LocationManager$requestLocationUpdates(java.lang.String long float android.location.LocationListener ), 0, this, string2, l, f, locationListener);
    }

    public void requestLocationUpdates(String string2, long l, float f, LocationListener locationListener, Looper looper) {
        InvokeDynamicSupport.bootstrap("requestLocationUpdates", $$robo$$android_location_LocationManager$requestLocationUpdates(java.lang.String long float android.location.LocationListener android.os.Looper ), 0, this, string2, l, f, locationListener, looper);
    }

    public void requestLocationUpdates(long l, float f, Criteria criteria, LocationListener locationListener, Looper looper) {
        InvokeDynamicSupport.bootstrap("requestLocationUpdates", $$robo$$android_location_LocationManager$requestLocationUpdates(long float android.location.Criteria android.location.LocationListener android.os.Looper ), 0, this, l, f, criteria, locationListener, looper);
    }

    public void requestLocationUpdates(String string2, long l, float f, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("requestLocationUpdates", $$robo$$android_location_LocationManager$requestLocationUpdates(java.lang.String long float android.app.PendingIntent ), 0, this, string2, l, f, pendingIntent);
    }

    public void requestLocationUpdates(long l, float f, Criteria criteria, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("requestLocationUpdates", $$robo$$android_location_LocationManager$requestLocationUpdates(long float android.location.Criteria android.app.PendingIntent ), 0, this, l, f, criteria, pendingIntent);
    }

    public void requestSingleUpdate(String string2, LocationListener locationListener, Looper looper) {
        InvokeDynamicSupport.bootstrap("requestSingleUpdate", $$robo$$android_location_LocationManager$requestSingleUpdate(java.lang.String android.location.LocationListener android.os.Looper ), 0, this, string2, locationListener, looper);
    }

    public void requestSingleUpdate(Criteria criteria, LocationListener locationListener, Looper looper) {
        InvokeDynamicSupport.bootstrap("requestSingleUpdate", $$robo$$android_location_LocationManager$requestSingleUpdate(android.location.Criteria android.location.LocationListener android.os.Looper ), 0, this, criteria, locationListener, looper);
    }

    public void requestSingleUpdate(String string2, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("requestSingleUpdate", $$robo$$android_location_LocationManager$requestSingleUpdate(java.lang.String android.app.PendingIntent ), 0, this, string2, pendingIntent);
    }

    public void requestSingleUpdate(Criteria criteria, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("requestSingleUpdate", $$robo$$android_location_LocationManager$requestSingleUpdate(android.location.Criteria android.app.PendingIntent ), 0, this, criteria, pendingIntent);
    }

    public void requestLocationUpdates(LocationRequest locationRequest, LocationListener locationListener, Looper looper) {
        InvokeDynamicSupport.bootstrap("requestLocationUpdates", $$robo$$android_location_LocationManager$requestLocationUpdates(android.location.LocationRequest android.location.LocationListener android.os.Looper ), 0, this, locationRequest, locationListener, looper);
    }

    public void requestLocationUpdates(LocationRequest locationRequest, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("requestLocationUpdates", $$robo$$android_location_LocationManager$requestLocationUpdates(android.location.LocationRequest android.app.PendingIntent ), 0, this, locationRequest, pendingIntent);
    }

    private ListenerTransport wrapListener(LocationListener locationListener, Looper looper) {
        return InvokeDynamicSupport.bootstrap("wrapListener", $$robo$$android_location_LocationManager$wrapListener(android.location.LocationListener android.os.Looper ), 0, this, locationListener, looper);
    }

    private void requestLocationUpdates(LocationRequest locationRequest, LocationListener locationListener, Looper looper, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("requestLocationUpdates", $$robo$$android_location_LocationManager$requestLocationUpdates(android.location.LocationRequest android.location.LocationListener android.os.Looper android.app.PendingIntent ), 0, this, locationRequest, locationListener, looper, pendingIntent);
    }

    public void removeUpdates(LocationListener locationListener) {
        InvokeDynamicSupport.bootstrap("removeUpdates", $$robo$$android_location_LocationManager$removeUpdates(android.location.LocationListener ), 0, this, locationListener);
    }

    public void removeUpdates(PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("removeUpdates", $$robo$$android_location_LocationManager$removeUpdates(android.app.PendingIntent ), 0, this, pendingIntent);
    }

    public void addProximityAlert(double d, double d2, float f, long l, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("addProximityAlert", $$robo$$android_location_LocationManager$addProximityAlert(double double float long android.app.PendingIntent ), 0, this, d, d2, f, l, pendingIntent);
    }

    public void addGeofence(LocationRequest locationRequest, Geofence geofence, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("addGeofence", $$robo$$android_location_LocationManager$addGeofence(android.location.LocationRequest android.location.Geofence android.app.PendingIntent ), 0, this, locationRequest, geofence, pendingIntent);
    }

    public void removeProximityAlert(PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("removeProximityAlert", $$robo$$android_location_LocationManager$removeProximityAlert(android.app.PendingIntent ), 0, this, pendingIntent);
    }

    public void removeGeofence(Geofence geofence, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("removeGeofence", $$robo$$android_location_LocationManager$removeGeofence(android.location.Geofence android.app.PendingIntent ), 0, this, geofence, pendingIntent);
    }

    public void removeAllGeofences(PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("removeAllGeofences", $$robo$$android_location_LocationManager$removeAllGeofences(android.app.PendingIntent ), 0, this, pendingIntent);
    }

    public boolean isProviderEnabled(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isProviderEnabled", $$robo$$android_location_LocationManager$isProviderEnabled(java.lang.String ), 0, this, string2);
    }

    public Location getLastLocation() {
        return InvokeDynamicSupport.bootstrap("getLastLocation", $$robo$$android_location_LocationManager$getLastLocation(), 0, this);
    }

    public Location getLastKnownLocation(String string2) {
        return InvokeDynamicSupport.bootstrap("getLastKnownLocation", $$robo$$android_location_LocationManager$getLastKnownLocation(java.lang.String ), 0, this, string2);
    }

    public void addTestProvider(String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, int n, int n2) {
        InvokeDynamicSupport.bootstrap("addTestProvider", $$robo$$android_location_LocationManager$addTestProvider(java.lang.String boolean boolean boolean boolean boolean boolean boolean int int ), 0, this, string2, bl, bl2, bl3, bl4, bl5, bl6, bl7, n, n2);
    }

    public void removeTestProvider(String string2) {
        InvokeDynamicSupport.bootstrap("removeTestProvider", $$robo$$android_location_LocationManager$removeTestProvider(java.lang.String ), 0, this, string2);
    }

    public void setTestProviderLocation(String string2, Location location) {
        InvokeDynamicSupport.bootstrap("setTestProviderLocation", $$robo$$android_location_LocationManager$setTestProviderLocation(java.lang.String android.location.Location ), 0, this, string2, location);
    }

    public void clearTestProviderLocation(String string2) {
        InvokeDynamicSupport.bootstrap("clearTestProviderLocation", $$robo$$android_location_LocationManager$clearTestProviderLocation(java.lang.String ), 0, this, string2);
    }

    public void setTestProviderEnabled(String string2, boolean bl) {
        InvokeDynamicSupport.bootstrap("setTestProviderEnabled", $$robo$$android_location_LocationManager$setTestProviderEnabled(java.lang.String boolean ), 0, this, string2, bl);
    }

    public void clearTestProviderEnabled(String string2) {
        InvokeDynamicSupport.bootstrap("clearTestProviderEnabled", $$robo$$android_location_LocationManager$clearTestProviderEnabled(java.lang.String ), 0, this, string2);
    }

    public void setTestProviderStatus(String string2, int n, Bundle bundle, long l) {
        InvokeDynamicSupport.bootstrap("setTestProviderStatus", $$robo$$android_location_LocationManager$setTestProviderStatus(java.lang.String int android.os.Bundle long ), 0, this, string2, n, bundle, l);
    }

    public void clearTestProviderStatus(String string2) {
        InvokeDynamicSupport.bootstrap("clearTestProviderStatus", $$robo$$android_location_LocationManager$clearTestProviderStatus(java.lang.String ), 0, this, string2);
    }

    public boolean addGpsStatusListener(GpsStatus.Listener listener) {
        return (boolean)InvokeDynamicSupport.bootstrap("addGpsStatusListener", $$robo$$android_location_LocationManager$addGpsStatusListener(android.location.GpsStatus$Listener ), 0, this, listener);
    }

    public void removeGpsStatusListener(GpsStatus.Listener listener) {
        InvokeDynamicSupport.bootstrap("removeGpsStatusListener", $$robo$$android_location_LocationManager$removeGpsStatusListener(android.location.GpsStatus$Listener ), 0, this, listener);
    }

    public boolean addNmeaListener(GpsStatus.NmeaListener nmeaListener) {
        return (boolean)InvokeDynamicSupport.bootstrap("addNmeaListener", $$robo$$android_location_LocationManager$addNmeaListener(android.location.GpsStatus$NmeaListener ), 0, this, nmeaListener);
    }

    public void removeNmeaListener(GpsStatus.NmeaListener nmeaListener) {
        InvokeDynamicSupport.bootstrap("removeNmeaListener", $$robo$$android_location_LocationManager$removeNmeaListener(android.location.GpsStatus$NmeaListener ), 0, this, nmeaListener);
    }

    public boolean addGpsMeasurementListener(GpsMeasurementsEvent.Listener listener) {
        return (boolean)InvokeDynamicSupport.bootstrap("addGpsMeasurementListener", $$robo$$android_location_LocationManager$addGpsMeasurementListener(android.location.GpsMeasurementsEvent$Listener ), 0, this, listener);
    }

    public void removeGpsMeasurementListener(GpsMeasurementsEvent.Listener listener) {
        InvokeDynamicSupport.bootstrap("removeGpsMeasurementListener", $$robo$$android_location_LocationManager$removeGpsMeasurementListener(android.location.GpsMeasurementsEvent$Listener ), 0, this, listener);
    }

    public boolean addGpsNavigationMessageListener(GpsNavigationMessageEvent.Listener listener) {
        return (boolean)InvokeDynamicSupport.bootstrap("addGpsNavigationMessageListener", $$robo$$android_location_LocationManager$addGpsNavigationMessageListener(android.location.GpsNavigationMessageEvent$Listener ), 0, this, listener);
    }

    public void removeGpsNavigationMessageListener(GpsNavigationMessageEvent.Listener listener) {
        InvokeDynamicSupport.bootstrap("removeGpsNavigationMessageListener", $$robo$$android_location_LocationManager$removeGpsNavigationMessageListener(android.location.GpsNavigationMessageEvent$Listener ), 0, this, listener);
    }

    public GpsStatus getGpsStatus(GpsStatus gpsStatus) {
        return InvokeDynamicSupport.bootstrap("getGpsStatus", $$robo$$android_location_LocationManager$getGpsStatus(android.location.GpsStatus ), 0, this, gpsStatus);
    }

    public boolean sendExtraCommand(String string2, String string3, Bundle bundle) {
        return (boolean)InvokeDynamicSupport.bootstrap("sendExtraCommand", $$robo$$android_location_LocationManager$sendExtraCommand(java.lang.String java.lang.String android.os.Bundle ), 0, this, string2, string3, bundle);
    }

    public boolean sendNiResponse(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("sendNiResponse", $$robo$$android_location_LocationManager$sendNiResponse(int int ), 0, this, n, n2);
    }

    private static void checkProvider(String string2) {
        InvokeDynamicSupport.bootstrapStatic("checkProvider", $$robo$$android_location_LocationManager$checkProvider(java.lang.String ), 0, (String)string2);
    }

    private static void checkCriteria(Criteria criteria) {
        InvokeDynamicSupport.bootstrapStatic("checkCriteria", $$robo$$android_location_LocationManager$checkCriteria(android.location.Criteria ), 0, (Criteria)criteria);
    }

    private static void checkListener(LocationListener locationListener) {
        InvokeDynamicSupport.bootstrapStatic("checkListener", $$robo$$android_location_LocationManager$checkListener(android.location.LocationListener ), 0, (LocationListener)locationListener);
    }

    private void checkPendingIntent(PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("checkPendingIntent", $$robo$$android_location_LocationManager$checkPendingIntent(android.app.PendingIntent ), 0, this, pendingIntent);
    }

    private static void checkGeofence(Geofence geofence) {
        InvokeDynamicSupport.bootstrapStatic("checkGeofence", $$robo$$android_location_LocationManager$checkGeofence(android.location.Geofence ), 0, (Geofence)geofence);
    }

    public /* synthetic */ LocationManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LocationManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class GpsStatusListenerTransport
    extends IGpsStatusListener.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private GpsStatus.Listener mListener;
        private GpsStatus.NmeaListener mNmeaListener;
        private static int NMEA_RECEIVED = 1000;
        private ArrayList<Nmea> mNmeaBuffer;
        private Handler mGpsHandler;
        /* synthetic */ LocationManager this$0;

        private void $$robo$$android_location_LocationManager_GpsStatusListenerTransport$__constructor__(LocationManager locationManager, GpsStatus.Listener listener) {
            this.mGpsHandler = new ShadowedObject(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ GpsStatusListenerTransport this$1;

                private void $$robo$$android_location_LocationManager_GpsStatusListenerTransport_1$__constructor__(GpsStatusListenerTransport gpsStatusListenerTransport) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private final void $$robo$$android_location_LocationManager_GpsStatusListenerTransport_1$handleMessage(Message msg) {
                    if (msg.what == 1000) {
                        ArrayList arrayList = this.this$1.mNmeaBuffer;
                        synchronized (arrayList) {
                            int length = this.this$1.mNmeaBuffer.size();
                            for (int i = 0; i < length; ++i) {
                                Nmea nmea = (Nmea)this.this$1.mNmeaBuffer.get(i);
                                this.this$1.mNmeaListener.onNmeaReceived(nmea.mTimestamp, nmea.mNmea);
                            }
                            this.this$1.mNmeaBuffer.clear();
                        }
                    }
                    GpsStatus gpsStatus = this.this$1.this$0.mGpsStatus;
                    synchronized (gpsStatus) {
                        this.this$1.mListener.onGpsStatusChanged(msg.what);
                    }
                }

                private void __constructor__(GpsStatusListenerTransport gpsStatusListenerTransport) {
                    this.$$robo$$android_location_LocationManager_GpsStatusListenerTransport_1$__constructor__(gpsStatusListenerTransport);
                }
                {
                    this.this$1 = gpsStatusListenerTransport;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_location_LocationManager_GpsStatusListenerTransport_1$__constructor__(android.location.LocationManager$GpsStatusListenerTransport ), 0, this, gpsStatusListenerTransport);
                }

                @Override
                public void handleMessage(Message message) {
                    InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_location_LocationManager_GpsStatusListenerTransport_1$handleMessage(android.os.Message ), 0, this, message);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            this.mListener = listener;
            this.mNmeaListener = null;
        }

        private void $$robo$$android_location_LocationManager_GpsStatusListenerTransport$__constructor__(LocationManager locationManager, GpsStatus.NmeaListener listener) {
            this.mGpsHandler = new /* invalid duplicate definition of identical inner class */;
            this.mNmeaListener = listener;
            this.mListener = null;
            this.mNmeaBuffer = new ArrayList();
        }

        private final void $$robo$$android_location_LocationManager_GpsStatusListenerTransport$onGpsStarted() {
            if (this.mListener != null) {
                Message msg = Message.obtain();
                msg.what = 1;
                this.mGpsHandler.sendMessage(msg);
            }
        }

        private final void $$robo$$android_location_LocationManager_GpsStatusListenerTransport$onGpsStopped() {
            if (this.mListener != null) {
                Message msg = Message.obtain();
                msg.what = 2;
                this.mGpsHandler.sendMessage(msg);
            }
        }

        private final void $$robo$$android_location_LocationManager_GpsStatusListenerTransport$onFirstFix(int ttff) {
            if (this.mListener != null) {
                this.this$0.mGpsStatus.setTimeToFirstFix(ttff);
                Message msg = Message.obtain();
                msg.what = 3;
                this.mGpsHandler.sendMessage(msg);
            }
        }

        private final void $$robo$$android_location_LocationManager_GpsStatusListenerTransport$onSvStatusChanged(int svCount, int[] prns, float[] snrs, float[] elevations, float[] azimuths, int ephemerisMask, int almanacMask, int usedInFixMask) {
            if (this.mListener != null) {
                this.this$0.mGpsStatus.setStatus(svCount, prns, snrs, elevations, azimuths, ephemerisMask, almanacMask, usedInFixMask);
                Message msg = Message.obtain();
                msg.what = 4;
                this.mGpsHandler.removeMessages(4);
                this.mGpsHandler.sendMessage(msg);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_location_LocationManager_GpsStatusListenerTransport$onNmeaReceived(long timestamp, String nmea) {
            if (this.mNmeaListener != null) {
                ArrayList<Nmea> arrayList = this.mNmeaBuffer;
                synchronized (arrayList) {
                    this.mNmeaBuffer.add(new Nmea(this, timestamp, nmea));
                }
                Message msg = Message.obtain();
                msg.what = 1000;
                this.mGpsHandler.removeMessages(1000);
                this.mGpsHandler.sendMessage(msg);
            }
        }

        private void __constructor__(LocationManager locationManager, GpsStatus.Listener listener) {
            this.$$robo$$android_location_LocationManager_GpsStatusListenerTransport$__constructor__(locationManager, listener);
        }

        GpsStatusListenerTransport(LocationManager locationManager, GpsStatus.Listener listener) {
            this.this$0 = locationManager;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_location_LocationManager_GpsStatusListenerTransport$__constructor__(android.location.LocationManager android.location.GpsStatus$Listener ), 0, this, locationManager, listener);
        }

        private void __constructor__(LocationManager locationManager, GpsStatus.NmeaListener nmeaListener) {
            this.$$robo$$android_location_LocationManager_GpsStatusListenerTransport$__constructor__(locationManager, nmeaListener);
        }

        GpsStatusListenerTransport(LocationManager locationManager, GpsStatus.NmeaListener nmeaListener) {
            this.this$0 = locationManager;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_location_LocationManager_GpsStatusListenerTransport$__constructor__(android.location.LocationManager android.location.GpsStatus$NmeaListener ), 0, this, locationManager, nmeaListener);
        }

        @Override
        public void onGpsStarted() {
            InvokeDynamicSupport.bootstrap("onGpsStarted", $$robo$$android_location_LocationManager_GpsStatusListenerTransport$onGpsStarted(), 0, this);
        }

        @Override
        public void onGpsStopped() {
            InvokeDynamicSupport.bootstrap("onGpsStopped", $$robo$$android_location_LocationManager_GpsStatusListenerTransport$onGpsStopped(), 0, this);
        }

        @Override
        public void onFirstFix(int n) {
            InvokeDynamicSupport.bootstrap("onFirstFix", $$robo$$android_location_LocationManager_GpsStatusListenerTransport$onFirstFix(int ), 0, this, n);
        }

        @Override
        public void onSvStatusChanged(int n, int[] nArray, float[] fArray, float[] fArray2, float[] fArray3, int n2, int n3, int n4) {
            InvokeDynamicSupport.bootstrap("onSvStatusChanged", $$robo$$android_location_LocationManager_GpsStatusListenerTransport$onSvStatusChanged(int int[] float[] float[] float[] int int int ), 0, this, n, nArray, fArray, fArray2, fArray3, n2, n3, n4);
        }

        @Override
        public void onNmeaReceived(long l, String string2) {
            InvokeDynamicSupport.bootstrap("onNmeaReceived", $$robo$$android_location_LocationManager_GpsStatusListenerTransport$onNmeaReceived(long java.lang.String ), 0, this, l, string2);
        }

        public /* synthetic */ GpsStatusListenerTransport() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GpsStatusListenerTransport)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        private class Nmea
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            long mTimestamp;
            String mNmea;
            /* synthetic */ GpsStatusListenerTransport this$1;

            private void $$robo$$android_location_LocationManager_GpsStatusListenerTransport_Nmea$__constructor__(GpsStatusListenerTransport gpsStatusListenerTransport, long timestamp, String nmea) {
                this.mTimestamp = timestamp;
                this.mNmea = nmea;
            }

            private void __constructor__(GpsStatusListenerTransport gpsStatusListenerTransport, long l, String string2) {
                this.$$robo$$android_location_LocationManager_GpsStatusListenerTransport_Nmea$__constructor__(gpsStatusListenerTransport, l, string2);
            }

            Nmea(GpsStatusListenerTransport gpsStatusListenerTransport, long l, String string2) {
                this.this$1 = gpsStatusListenerTransport;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_location_LocationManager_GpsStatusListenerTransport_Nmea$__constructor__(android.location.LocationManager$GpsStatusListenerTransport long java.lang.String ), 0, this, gpsStatusListenerTransport, l, string2);
            }

            public /* synthetic */ Nmea() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Nmea)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    private class ListenerTransport
    extends ILocationListener.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int TYPE_LOCATION_CHANGED = 1;
        private static int TYPE_STATUS_CHANGED = 2;
        private static int TYPE_PROVIDER_ENABLED = 3;
        private static int TYPE_PROVIDER_DISABLED = 4;
        private LocationListener mListener;
        private Handler mListenerHandler;
        /* synthetic */ LocationManager this$0;

        private void $$robo$$android_location_LocationManager_ListenerTransport$__constructor__(LocationManager locationManager, LocationListener listener, Looper looper) {
            this.mListener = listener;
            this.mListenerHandler = looper == null ? new ShadowedObject(this, locationManager){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ LocationManager val$this$0;
                /* synthetic */ ListenerTransport this$1;

                private void $$robo$$android_location_LocationManager_ListenerTransport_1$__constructor__(ListenerTransport listenerTransport, LocationManager locationManager) {
                }

                private final void $$robo$$android_location_LocationManager_ListenerTransport_1$handleMessage(Message msg) {
                    this.this$1._handleMessage(msg);
                }

                private void __constructor__(ListenerTransport listenerTransport, LocationManager locationManager) {
                    this.$$robo$$android_location_LocationManager_ListenerTransport_1$__constructor__(listenerTransport, locationManager);
                }
                {
                    this.this$1 = listenerTransport;
                    this.val$this$0 = locationManager;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_location_LocationManager_ListenerTransport_1$__constructor__(android.location.LocationManager$ListenerTransport android.location.LocationManager ), 0, this, listenerTransport, locationManager);
                }

                @Override
                public void handleMessage(Message message) {
                    InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_location_LocationManager_ListenerTransport_1$handleMessage(android.os.Message ), 0, this, message);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            } : new ShadowedObject(this, looper, locationManager){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ LocationManager val$this$0;
                /* synthetic */ ListenerTransport this$1;

                private void $$robo$$android_location_LocationManager_ListenerTransport_2$__constructor__(ListenerTransport listenerTransport, Looper x0, LocationManager locationManager) {
                }

                private final void $$robo$$android_location_LocationManager_ListenerTransport_2$handleMessage(Message msg) {
                    this.this$1._handleMessage(msg);
                }

                private void __constructor__(ListenerTransport listenerTransport, Looper looper, LocationManager locationManager) {
                    this.$$robo$$android_location_LocationManager_ListenerTransport_2$__constructor__(listenerTransport, looper, locationManager);
                }
                {
                    this.this$1 = listenerTransport;
                    this.val$this$0 = locationManager;
                    super(looper);
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_location_LocationManager_ListenerTransport_2$__constructor__(android.location.LocationManager$ListenerTransport android.os.Looper android.location.LocationManager ), 0, this, listenerTransport, looper, locationManager);
                }

                @Override
                public void handleMessage(Message message) {
                    InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_location_LocationManager_ListenerTransport_2$handleMessage(android.os.Message ), 0, this, message);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private final void $$robo$$android_location_LocationManager_ListenerTransport$onLocationChanged(Location location) {
            Message msg = Message.obtain();
            msg.what = 1;
            msg.obj = location;
            this.mListenerHandler.sendMessage(msg);
        }

        private final void $$robo$$android_location_LocationManager_ListenerTransport$onStatusChanged(String provider, int status, Bundle extras) {
            Message msg = Message.obtain();
            msg.what = 2;
            Bundle b = new Bundle();
            b.putString("provider", provider);
            b.putInt("status", status);
            if (extras != null) {
                b.putBundle("extras", extras);
            }
            msg.obj = b;
            this.mListenerHandler.sendMessage(msg);
        }

        private final void $$robo$$android_location_LocationManager_ListenerTransport$onProviderEnabled(String provider) {
            Message msg = Message.obtain();
            msg.what = 3;
            msg.obj = provider;
            this.mListenerHandler.sendMessage(msg);
        }

        private final void $$robo$$android_location_LocationManager_ListenerTransport$onProviderDisabled(String provider) {
            Message msg = Message.obtain();
            msg.what = 4;
            msg.obj = provider;
            this.mListenerHandler.sendMessage(msg);
        }

        private final void $$robo$$android_location_LocationManager_ListenerTransport$_handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    Location location = new Location((Location)msg.obj);
                    this.mListener.onLocationChanged(location);
                    break;
                }
                case 2: {
                    Bundle b = (Bundle)msg.obj;
                    String provider = b.getString("provider");
                    int status = b.getInt("status");
                    Bundle extras = b.getBundle("extras");
                    this.mListener.onStatusChanged(provider, status, extras);
                    break;
                }
                case 3: {
                    this.mListener.onProviderEnabled((String)msg.obj);
                    break;
                }
                case 4: {
                    this.mListener.onProviderDisabled((String)msg.obj);
                }
            }
            try {
                this.this$0.mService.locationCallbackFinished(this);
            }
            catch (RemoteException e) {
                Log.e("LocationManager", "locationCallbackFinished: RemoteException", e);
            }
        }

        private void __constructor__(LocationManager locationManager, LocationListener locationListener, Looper looper) {
            this.$$robo$$android_location_LocationManager_ListenerTransport$__constructor__(locationManager, locationListener, looper);
        }

        ListenerTransport(LocationManager locationManager, LocationListener locationListener, Looper looper) {
            this.this$0 = locationManager;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_location_LocationManager_ListenerTransport$__constructor__(android.location.LocationManager android.location.LocationListener android.os.Looper ), 0, this, locationManager, locationListener, looper);
        }

        @Override
        public void onLocationChanged(Location location) {
            InvokeDynamicSupport.bootstrap("onLocationChanged", $$robo$$android_location_LocationManager_ListenerTransport$onLocationChanged(android.location.Location ), 0, this, location);
        }

        @Override
        public void onStatusChanged(String string2, int n, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onStatusChanged", $$robo$$android_location_LocationManager_ListenerTransport$onStatusChanged(java.lang.String int android.os.Bundle ), 0, this, string2, n, bundle);
        }

        @Override
        public void onProviderEnabled(String string2) {
            InvokeDynamicSupport.bootstrap("onProviderEnabled", $$robo$$android_location_LocationManager_ListenerTransport$onProviderEnabled(java.lang.String ), 0, this, string2);
        }

        @Override
        public void onProviderDisabled(String string2) {
            InvokeDynamicSupport.bootstrap("onProviderDisabled", $$robo$$android_location_LocationManager_ListenerTransport$onProviderDisabled(java.lang.String ), 0, this, string2);
        }

        private void _handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("_handleMessage", $$robo$$android_location_LocationManager_ListenerTransport$_handleMessage(android.os.Message ), 0, this, message);
        }

        public /* synthetic */ ListenerTransport() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ListenerTransport)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

