/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.app.PendingIntent;
import android.bluetooth.BluetoothDevice;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.media.AudioDevicePort;
import android.media.AudioGain;
import android.media.AudioGainConfig;
import android.media.AudioPatch;
import android.media.AudioPort;
import android.media.AudioPortConfig;
import android.media.AudioPortEventHandler;
import android.media.AudioSystem;
import android.media.IAudioFocusDispatcher;
import android.media.IAudioService;
import android.media.IRemoteControlDisplay;
import android.media.IRingtonePlayer;
import android.media.IVolumeController;
import android.media.RemoteControlClient;
import android.media.RemoteController;
import android.media.audiopolicy.AudioPolicy;
import android.media.session.MediaSessionLegacyHelper;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.provider.Settings;
import android.util.Log;
import android.view.KeyEvent;
import java.util.ArrayList;
import java.util.HashMap;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class AudioManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private Context mContext;
    private long mVolumeKeyUpTime;
    private boolean mUseMasterVolume;
    private boolean mUseVolumeKeySounds;
    private boolean mUseFixedVolume;
    private Binder mToken;
    private static String TAG;
    AudioPortEventHandler mAudioPortEventHandler;
    public static String ACTION_AUDIO_BECOMING_NOISY = "android.media.AUDIO_BECOMING_NOISY";
    public static String RINGER_MODE_CHANGED_ACTION = "android.media.RINGER_MODE_CHANGED";
    public static String EXTRA_RINGER_MODE = "android.media.EXTRA_RINGER_MODE";
    public static String VIBRATE_SETTING_CHANGED_ACTION = "android.media.VIBRATE_SETTING_CHANGED";
    public static String VOLUME_CHANGED_ACTION = "android.media.VOLUME_CHANGED_ACTION";
    public static String MASTER_VOLUME_CHANGED_ACTION = "android.media.MASTER_VOLUME_CHANGED_ACTION";
    public static String MASTER_MUTE_CHANGED_ACTION = "android.media.MASTER_MUTE_CHANGED_ACTION";
    public static String EXTRA_VIBRATE_SETTING = "android.media.EXTRA_VIBRATE_SETTING";
    public static String EXTRA_VIBRATE_TYPE = "android.media.EXTRA_VIBRATE_TYPE";
    public static String EXTRA_VOLUME_STREAM_TYPE = "android.media.EXTRA_VOLUME_STREAM_TYPE";
    public static String EXTRA_VOLUME_STREAM_VALUE = "android.media.EXTRA_VOLUME_STREAM_VALUE";
    public static String EXTRA_PREV_VOLUME_STREAM_VALUE = "android.media.EXTRA_PREV_VOLUME_STREAM_VALUE";
    public static String EXTRA_MASTER_VOLUME_VALUE = "android.media.EXTRA_MASTER_VOLUME_VALUE";
    public static String EXTRA_PREV_MASTER_VOLUME_VALUE = "android.media.EXTRA_PREV_MASTER_VOLUME_VALUE";
    public static String EXTRA_MASTER_VOLUME_MUTED = "android.media.EXTRA_MASTER_VOLUME_MUTED";
    public static String ACTION_HEADSET_PLUG = "android.intent.action.HEADSET_PLUG";
    public static String ACTION_HDMI_AUDIO_PLUG = "android.media.action.HDMI_AUDIO_PLUG";
    public static String EXTRA_AUDIO_PLUG_STATE = "android.media.extra.AUDIO_PLUG_STATE";
    public static String EXTRA_MAX_CHANNEL_COUNT = "android.media.extra.MAX_CHANNEL_COUNT";
    public static String EXTRA_ENCODINGS = "android.media.extra.ENCODINGS";
    public static String ACTION_ANALOG_AUDIO_DOCK_PLUG = "android.media.action.ANALOG_AUDIO_DOCK_PLUG";
    public static String ACTION_DIGITAL_AUDIO_DOCK_PLUG = "android.media.action.DIGITAL_AUDIO_DOCK_PLUG";
    public static String ACTION_USB_AUDIO_ACCESSORY_PLUG = "android.media.action.USB_AUDIO_ACCESSORY_PLUG";
    public static String ACTION_USB_AUDIO_DEVICE_PLUG = "android.media.action.USB_AUDIO_DEVICE_PLUG";
    public static int STREAM_VOICE_CALL = 0;
    public static int STREAM_SYSTEM = 1;
    public static int STREAM_RING = 2;
    public static int STREAM_MUSIC = 3;
    public static int STREAM_ALARM = 4;
    public static int STREAM_NOTIFICATION = 5;
    public static int STREAM_BLUETOOTH_SCO = 6;
    public static int STREAM_SYSTEM_ENFORCED = 7;
    public static int STREAM_DTMF = 8;
    public static int STREAM_TTS = 9;
    @Deprecated
    public static int NUM_STREAMS = 5;
    public static int[] DEFAULT_STREAM_VOLUME;
    public static int ADJUST_RAISE = 1;
    public static int ADJUST_LOWER = -1;
    public static int ADJUST_SAME = 0;
    public static int FLAG_SHOW_UI = 1;
    public static int FLAG_ALLOW_RINGER_MODES = 2;
    public static int FLAG_PLAY_SOUND = 4;
    public static int FLAG_REMOVE_SOUND_AND_VIBRATE = 8;
    public static int FLAG_VIBRATE = 16;
    public static int FLAG_FIXED_VOLUME = 32;
    public static int FLAG_BLUETOOTH_ABS_VOLUME = 64;
    public static int FLAG_SHOW_SILENT_HINT = 128;
    public static int FLAG_HDMI_SYSTEM_AUDIO_VOLUME = 256;
    public static int FLAG_ACTIVE_MEDIA_ONLY = 512;
    public static int FLAG_SHOW_UI_WARNINGS = 1024;
    public static int RINGER_MODE_SILENT = 0;
    public static int RINGER_MODE_VIBRATE = 1;
    public static int RINGER_MODE_NORMAL = 2;
    private static int RINGER_MODE_MAX = 2;
    public static int VIBRATE_TYPE_RINGER = 0;
    public static int VIBRATE_TYPE_NOTIFICATION = 1;
    public static int VIBRATE_SETTING_OFF = 0;
    public static int VIBRATE_SETTING_ON = 1;
    public static int VIBRATE_SETTING_ONLY_SILENT = 2;
    public static int USE_DEFAULT_STREAM_TYPE = Integer.MIN_VALUE;
    private static IAudioService sService;
    @Deprecated
    public static String ACTION_SCO_AUDIO_STATE_CHANGED = "android.media.SCO_AUDIO_STATE_CHANGED";
    public static String ACTION_SCO_AUDIO_STATE_UPDATED = "android.media.ACTION_SCO_AUDIO_STATE_UPDATED";
    public static String EXTRA_SCO_AUDIO_STATE = "android.media.extra.SCO_AUDIO_STATE";
    public static String EXTRA_SCO_AUDIO_PREVIOUS_STATE = "android.media.extra.SCO_AUDIO_PREVIOUS_STATE";
    public static int SCO_AUDIO_STATE_DISCONNECTED = 0;
    public static int SCO_AUDIO_STATE_CONNECTED = 1;
    public static int SCO_AUDIO_STATE_CONNECTING = 2;
    public static int SCO_AUDIO_STATE_ERROR = -1;
    public static int MODE_INVALID = -2;
    public static int MODE_CURRENT = -1;
    public static int MODE_NORMAL = 0;
    public static int MODE_RINGTONE = 1;
    public static int MODE_IN_CALL = 2;
    public static int MODE_IN_COMMUNICATION = 3;
    @Deprecated
    public static int ROUTE_EARPIECE = 1;
    @Deprecated
    public static int ROUTE_SPEAKER = 2;
    @Deprecated
    public static int ROUTE_BLUETOOTH = 4;
    @Deprecated
    public static int ROUTE_BLUETOOTH_SCO = 4;
    @Deprecated
    public static int ROUTE_HEADSET = 8;
    @Deprecated
    public static int ROUTE_BLUETOOTH_A2DP = 16;
    @Deprecated
    public static int ROUTE_ALL = -1;
    public static int AUDIO_SESSION_ID_GENERATE = 0;
    public static int FX_KEY_CLICK = 0;
    public static int FX_FOCUS_NAVIGATION_UP = 1;
    public static int FX_FOCUS_NAVIGATION_DOWN = 2;
    public static int FX_FOCUS_NAVIGATION_LEFT = 3;
    public static int FX_FOCUS_NAVIGATION_RIGHT = 4;
    public static int FX_KEYPRESS_STANDARD = 5;
    public static int FX_KEYPRESS_SPACEBAR = 6;
    public static int FX_KEYPRESS_DELETE = 7;
    public static int FX_KEYPRESS_RETURN = 8;
    public static int FX_KEYPRESS_INVALID = 9;
    public static int NUM_SOUND_EFFECTS = 10;
    public static int AUDIOFOCUS_NONE = 0;
    public static int AUDIOFOCUS_GAIN = 1;
    public static int AUDIOFOCUS_GAIN_TRANSIENT = 2;
    public static int AUDIOFOCUS_GAIN_TRANSIENT_MAY_DUCK = 3;
    public static int AUDIOFOCUS_GAIN_TRANSIENT_EXCLUSIVE = 4;
    public static int AUDIOFOCUS_LOSS = -1;
    public static int AUDIOFOCUS_LOSS_TRANSIENT = -2;
    public static int AUDIOFOCUS_LOSS_TRANSIENT_CAN_DUCK = -3;
    private HashMap<String, OnAudioFocusChangeListener> mAudioFocusIdListenerMap;
    private Object mFocusListenerLock;
    private FocusEventHandlerDelegate mAudioFocusEventHandlerDelegate;
    private IAudioFocusDispatcher mAudioFocusDispatcher;
    public static int AUDIOFOCUS_REQUEST_FAILED = 0;
    public static int AUDIOFOCUS_REQUEST_GRANTED = 1;
    private IBinder mICallBack;
    public static int DEVICE_NONE = 0;
    public static int DEVICE_OUT_EARPIECE = 1;
    public static int DEVICE_OUT_SPEAKER = 2;
    public static int DEVICE_OUT_WIRED_HEADSET = 4;
    public static int DEVICE_OUT_WIRED_HEADPHONE = 8;
    public static int DEVICE_OUT_BLUETOOTH_SCO = 16;
    public static int DEVICE_OUT_BLUETOOTH_SCO_HEADSET = 32;
    public static int DEVICE_OUT_BLUETOOTH_SCO_CARKIT = 64;
    public static int DEVICE_OUT_BLUETOOTH_A2DP = 128;
    public static int DEVICE_OUT_BLUETOOTH_A2DP_HEADPHONES = 256;
    public static int DEVICE_OUT_BLUETOOTH_A2DP_SPEAKER = 512;
    public static int DEVICE_OUT_AUX_DIGITAL = 1024;
    public static int DEVICE_OUT_HDMI = 1024;
    public static int DEVICE_OUT_ANLG_DOCK_HEADSET = 2048;
    public static int DEVICE_OUT_DGTL_DOCK_HEADSET = 4096;
    public static int DEVICE_OUT_USB_ACCESSORY = 8192;
    public static int DEVICE_OUT_USB_DEVICE = 16384;
    public static int DEVICE_OUT_REMOTE_SUBMIX = 32768;
    public static int DEVICE_OUT_TELEPHONY_TX = 65536;
    public static int DEVICE_OUT_LINE = 131072;
    public static int DEVICE_OUT_HDMI_ARC = 262144;
    public static int DEVICE_OUT_SPDIF = 524288;
    public static int DEVICE_OUT_FM = 0x100000;
    public static int DEVICE_OUT_DEFAULT = 0x40000000;
    public static int DEVICE_IN_BUILTIN_MIC = -2147483644;
    public static int DEVICE_IN_BLUETOOTH_SCO_HEADSET = -2147483640;
    public static int DEVICE_IN_WIRED_HEADSET = -2147483632;
    public static int DEVICE_IN_HDMI = -2147483616;
    public static int DEVICE_IN_TELEPHONY_RX = -2147483584;
    public static int DEVICE_IN_BACK_MIC = -2147483520;
    public static int DEVICE_IN_ANLG_DOCK_HEADSET = -2147483136;
    public static int DEVICE_IN_DGTL_DOCK_HEADSET = -2147482624;
    public static int DEVICE_IN_USB_ACCESSORY = -2147481600;
    public static int DEVICE_IN_USB_DEVICE = -2147479552;
    public static int DEVICE_IN_FM_TUNER = -2147475456;
    public static int DEVICE_IN_TV_TUNER = -2147467264;
    public static int DEVICE_IN_LINE = -2147450880;
    public static int DEVICE_IN_SPDIF = -2147418112;
    public static int DEVICE_IN_LOOPBACK = -2147221504;
    public static String PROPERTY_OUTPUT_SAMPLE_RATE = "android.media.property.OUTPUT_SAMPLE_RATE";
    public static String PROPERTY_OUTPUT_FRAMES_PER_BUFFER = "android.media.property.OUTPUT_FRAMES_PER_BUFFER";
    public static int SUCCESS = 0;
    public static int ERROR = -1;
    public static int ERROR_BAD_VALUE = -2;
    public static int ERROR_INVALID_OPERATION = -3;
    public static int ERROR_PERMISSION_DENIED = -4;
    public static int ERROR_NO_INIT = -5;
    public static int ERROR_DEAD_OBJECT = -6;
    static int AUDIOPORT_GENERATION_INIT = 0;
    Integer mAudioPortGeneration;
    ArrayList<AudioPort> mAudioPortsCached;
    ArrayList<AudioPatch> mAudioPatchesCached;

    private void $$robo$$android_media_AudioManager$__constructor__(Context context) {
        this.mToken = new Binder();
        this.mAudioFocusIdListenerMap = new HashMap();
        this.mFocusListenerLock = new Object();
        this.mAudioFocusEventHandlerDelegate = new FocusEventHandlerDelegate(this);
        this.mAudioFocusDispatcher = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ AudioManager this$0;

            private void $$robo$$android_media_AudioManager_1$__constructor__(AudioManager audioManager) {
            }

            private final void $$robo$$android_media_AudioManager_1$dispatchAudioFocusChange(int focusChange, String id2) {
                Message m = this.this$0.mAudioFocusEventHandlerDelegate.getHandler().obtainMessage(focusChange, id2);
                this.this$0.mAudioFocusEventHandlerDelegate.getHandler().sendMessage(m);
            }

            private void __constructor__(AudioManager audioManager) {
                this.$$robo$$android_media_AudioManager_1$__constructor__(audioManager);
            }
            {
                this.this$0 = audioManager;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioManager_1$__constructor__(android.media.AudioManager ), 0, this, audioManager);
            }

            @Override
            public void dispatchAudioFocusChange(int n, String string2) {
                InvokeDynamicSupport.bootstrap("dispatchAudioFocusChange", $$robo$$android_media_AudioManager_1$dispatchAudioFocusChange(int java.lang.String ), 0, this, n, string2);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mICallBack = new Binder();
        this.mAudioPortGeneration = new Integer(0);
        this.mAudioPortsCached = new ArrayList();
        this.mAudioPatchesCached = new ArrayList();
        this.mContext = context;
        this.mUseMasterVolume = this.mContext.getResources().getBoolean(0x1120010);
        this.mUseVolumeKeySounds = this.mContext.getResources().getBoolean(0x1120011);
        this.mAudioPortEventHandler = new AudioPortEventHandler(this);
        this.mUseFixedVolume = this.mContext.getResources().getBoolean(17956968);
    }

    private static final IAudioService $$robo$$android_media_AudioManager$getService() {
        if (sService != null) {
            return sService;
        }
        IBinder b = ServiceManager.getService("audio");
        sService = IAudioService.Stub.asInterface(b);
        return sService;
    }

    private final void $$robo$$android_media_AudioManager$dispatchMediaKeyEvent(KeyEvent keyEvent) {
        MediaSessionLegacyHelper helper = MediaSessionLegacyHelper.getHelper(this.mContext);
        helper.sendMediaButtonEvent(keyEvent, false);
    }

    private final void $$robo$$android_media_AudioManager$preDispatchKeyEvent(KeyEvent event, int stream) {
        int keyCode = event.getKeyCode();
        if (keyCode != 25 && keyCode != 24 && keyCode != 164 && this.mVolumeKeyUpTime + 300L > SystemClock.uptimeMillis()) {
            if (this.mUseMasterVolume) {
                this.adjustMasterVolume(0, 8);
            } else {
                this.adjustSuggestedStreamVolume(0, stream, 8);
            }
        }
    }

    private final void $$robo$$android_media_AudioManager$handleKeyDown(KeyEvent event, int stream) {
        int keyCode = event.getKeyCode();
        switch (keyCode) {
            case 24: 
            case 25: {
                int flags = 17;
                if (this.mUseMasterVolume) {
                    this.adjustMasterVolume(keyCode == 24 ? 1 : -1, flags);
                    break;
                }
                this.adjustSuggestedStreamVolume(keyCode == 24 ? 1 : -1, stream, flags);
                break;
            }
            case 164: {
                if (event.getRepeatCount() != 0 || !this.mUseMasterVolume) break;
                this.setMasterMute(!this.isMasterMute());
            }
        }
    }

    private final void $$robo$$android_media_AudioManager$handleKeyUp(KeyEvent event, int stream) {
        int keyCode = event.getKeyCode();
        switch (keyCode) {
            case 24: 
            case 25: {
                if (this.mUseVolumeKeySounds) {
                    if (this.mUseMasterVolume) {
                        this.adjustMasterVolume(0, 4);
                    } else {
                        int flags = 4;
                        this.adjustSuggestedStreamVolume(0, stream, flags);
                    }
                }
                this.mVolumeKeyUpTime = SystemClock.uptimeMillis();
            }
        }
    }

    private final boolean $$robo$$android_media_AudioManager$isVolumeFixed() {
        return this.mUseFixedVolume;
    }

    private final void $$robo$$android_media_AudioManager$adjustStreamVolume(int streamType, int direction, int flags) {
        IAudioService service = AudioManager.getService();
        try {
            if (this.mUseMasterVolume) {
                service.adjustMasterVolume(direction, flags, this.mContext.getOpPackageName());
            } else {
                service.adjustStreamVolume(streamType, direction, flags, this.mContext.getOpPackageName());
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in adjustStreamVolume", e);
        }
    }

    private final void $$robo$$android_media_AudioManager$adjustVolume(int direction, int flags) {
        IAudioService service = AudioManager.getService();
        try {
            if (this.mUseMasterVolume) {
                service.adjustMasterVolume(direction, flags, this.mContext.getOpPackageName());
            } else {
                MediaSessionLegacyHelper helper = MediaSessionLegacyHelper.getHelper(this.mContext);
                helper.sendAdjustVolumeBy(Integer.MIN_VALUE, direction, flags);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in adjustVolume", e);
        }
    }

    private final void $$robo$$android_media_AudioManager$adjustSuggestedStreamVolume(int direction, int suggestedStreamType, int flags) {
        IAudioService service = AudioManager.getService();
        try {
            if (this.mUseMasterVolume) {
                service.adjustMasterVolume(direction, flags, this.mContext.getOpPackageName());
            } else {
                MediaSessionLegacyHelper helper = MediaSessionLegacyHelper.getHelper(this.mContext);
                helper.sendAdjustVolumeBy(suggestedStreamType, direction, flags);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in adjustSuggestedStreamVolume", e);
        }
    }

    private final void $$robo$$android_media_AudioManager$adjustMasterVolume(int steps, int flags) {
        IAudioService service = AudioManager.getService();
        try {
            service.adjustMasterVolume(steps, flags, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in adjustMasterVolume", e);
        }
    }

    private final int $$robo$$android_media_AudioManager$getRingerMode() {
        IAudioService service = AudioManager.getService();
        try {
            return service.getRingerMode();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in getRingerMode", e);
            return 2;
        }
    }

    private static final boolean $$robo$$android_media_AudioManager$isValidRingerMode(int ringerMode) {
        return ringerMode >= 0 && ringerMode <= 2;
    }

    private final int $$robo$$android_media_AudioManager$getStreamMaxVolume(int streamType) {
        IAudioService service = AudioManager.getService();
        try {
            if (this.mUseMasterVolume) {
                return service.getMasterMaxVolume();
            }
            return service.getStreamMaxVolume(streamType);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in getStreamMaxVolume", e);
            return 0;
        }
    }

    private final int $$robo$$android_media_AudioManager$getStreamVolume(int streamType) {
        IAudioService service = AudioManager.getService();
        try {
            if (this.mUseMasterVolume) {
                return service.getMasterVolume();
            }
            return service.getStreamVolume(streamType);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in getStreamVolume", e);
            return 0;
        }
    }

    private final int $$robo$$android_media_AudioManager$getLastAudibleStreamVolume(int streamType) {
        IAudioService service = AudioManager.getService();
        try {
            if (this.mUseMasterVolume) {
                return service.getLastAudibleMasterVolume();
            }
            return service.getLastAudibleStreamVolume(streamType);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in getLastAudibleStreamVolume", e);
            return 0;
        }
    }

    private final int $$robo$$android_media_AudioManager$getMasterStreamType() {
        IAudioService service = AudioManager.getService();
        try {
            return service.getMasterStreamType();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in getMasterStreamType", e);
            return 2;
        }
    }

    private final void $$robo$$android_media_AudioManager$setRingerMode(int ringerMode) {
        this.setRingerMode(ringerMode, true);
    }

    private final void $$robo$$android_media_AudioManager$setRingerMode(int ringerMode, boolean checkZen) {
        if (!AudioManager.isValidRingerMode(ringerMode)) {
            return;
        }
        IAudioService service = AudioManager.getService();
        try {
            service.setRingerMode(ringerMode, checkZen);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in setRingerMode", e);
        }
    }

    private final void $$robo$$android_media_AudioManager$setStreamVolume(int streamType, int index, int flags) {
        IAudioService service = AudioManager.getService();
        try {
            if (this.mUseMasterVolume) {
                service.setMasterVolume(index, flags, this.mContext.getOpPackageName());
            } else {
                service.setStreamVolume(streamType, index, flags, this.mContext.getOpPackageName());
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in setStreamVolume", e);
        }
    }

    private final int $$robo$$android_media_AudioManager$getMasterMaxVolume() {
        IAudioService service = AudioManager.getService();
        try {
            return service.getMasterMaxVolume();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in getMasterMaxVolume", e);
            return 0;
        }
    }

    private final int $$robo$$android_media_AudioManager$getMasterVolume() {
        IAudioService service = AudioManager.getService();
        try {
            return service.getMasterVolume();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in getMasterVolume", e);
            return 0;
        }
    }

    private final int $$robo$$android_media_AudioManager$getLastAudibleMasterVolume() {
        IAudioService service = AudioManager.getService();
        try {
            return service.getLastAudibleMasterVolume();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in getLastAudibleMasterVolume", e);
            return 0;
        }
    }

    private final void $$robo$$android_media_AudioManager$setMasterVolume(int index, int flags) {
        IAudioService service = AudioManager.getService();
        try {
            service.setMasterVolume(index, flags, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in setMasterVolume", e);
        }
    }

    private final void $$robo$$android_media_AudioManager$setStreamSolo(int streamType, boolean state) {
        IAudioService service = AudioManager.getService();
        try {
            service.setStreamSolo(streamType, state, this.mICallBack);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in setStreamSolo", e);
        }
    }

    private final void $$robo$$android_media_AudioManager$setStreamMute(int streamType, boolean state) {
        IAudioService service = AudioManager.getService();
        try {
            service.setStreamMute(streamType, state, this.mICallBack);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in setStreamMute", e);
        }
    }

    private final boolean $$robo$$android_media_AudioManager$isStreamMute(int streamType) {
        IAudioService service = AudioManager.getService();
        try {
            return service.isStreamMute(streamType);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in isStreamMute", e);
            return false;
        }
    }

    private final void $$robo$$android_media_AudioManager$setMasterMute(boolean state) {
        this.setMasterMute(state, 1);
    }

    private final void $$robo$$android_media_AudioManager$setMasterMute(boolean state, int flags) {
        IAudioService service = AudioManager.getService();
        try {
            service.setMasterMute(state, flags, this.mContext.getOpPackageName(), this.mICallBack);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in setMasterMute", e);
        }
    }

    private final boolean $$robo$$android_media_AudioManager$isMasterMute() {
        IAudioService service = AudioManager.getService();
        try {
            return service.isMasterMute();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in isMasterMute", e);
            return false;
        }
    }

    private final void $$robo$$android_media_AudioManager$forceVolumeControlStream(int streamType) {
        IAudioService service = AudioManager.getService();
        try {
            service.forceVolumeControlStream(streamType, this.mICallBack);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in forceVolumeControlStream", e);
        }
    }

    private final boolean $$robo$$android_media_AudioManager$shouldVibrate(int vibrateType) {
        IAudioService service = AudioManager.getService();
        try {
            return service.shouldVibrate(vibrateType);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in shouldVibrate", e);
            return false;
        }
    }

    private final int $$robo$$android_media_AudioManager$getVibrateSetting(int vibrateType) {
        IAudioService service = AudioManager.getService();
        try {
            return service.getVibrateSetting(vibrateType);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in getVibrateSetting", e);
            return 0;
        }
    }

    private final void $$robo$$android_media_AudioManager$setVibrateSetting(int vibrateType, int vibrateSetting) {
        IAudioService service = AudioManager.getService();
        try {
            service.setVibrateSetting(vibrateType, vibrateSetting);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in setVibrateSetting", e);
        }
    }

    private final void $$robo$$android_media_AudioManager$setSpeakerphoneOn(boolean on) {
        IAudioService service = AudioManager.getService();
        try {
            service.setSpeakerphoneOn(on);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in setSpeakerphoneOn", e);
        }
    }

    private final boolean $$robo$$android_media_AudioManager$isSpeakerphoneOn() {
        IAudioService service = AudioManager.getService();
        try {
            return service.isSpeakerphoneOn();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in isSpeakerphoneOn", e);
            return false;
        }
    }

    private final boolean $$robo$$android_media_AudioManager$isBluetoothScoAvailableOffCall() {
        return this.mContext.getResources().getBoolean(17956927);
    }

    private final void $$robo$$android_media_AudioManager$startBluetoothSco() {
        IAudioService service = AudioManager.getService();
        try {
            service.startBluetoothSco(this.mICallBack, this.mContext.getApplicationInfo().targetSdkVersion);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in startBluetoothSco", e);
        }
    }

    private final void $$robo$$android_media_AudioManager$startBluetoothScoVirtualCall() {
        IAudioService service = AudioManager.getService();
        try {
            service.startBluetoothScoVirtualCall(this.mICallBack);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in startBluetoothScoVirtualCall", e);
        }
    }

    private final void $$robo$$android_media_AudioManager$stopBluetoothSco() {
        IAudioService service = AudioManager.getService();
        try {
            service.stopBluetoothSco(this.mICallBack);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in stopBluetoothSco", e);
        }
    }

    private final void $$robo$$android_media_AudioManager$setBluetoothScoOn(boolean on) {
        IAudioService service = AudioManager.getService();
        try {
            service.setBluetoothScoOn(on);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in setBluetoothScoOn", e);
        }
    }

    private final boolean $$robo$$android_media_AudioManager$isBluetoothScoOn() {
        IAudioService service = AudioManager.getService();
        try {
            return service.isBluetoothScoOn();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in isBluetoothScoOn", e);
            return false;
        }
    }

    @Deprecated
    private final void $$robo$$android_media_AudioManager$setBluetoothA2dpOn(boolean on) {
    }

    private final boolean $$robo$$android_media_AudioManager$isBluetoothA2dpOn() {
        return AudioSystem.getDeviceConnectionState(128, "") != 0;
    }

    @Deprecated
    private final void $$robo$$android_media_AudioManager$setWiredHeadsetOn(boolean on) {
    }

    private final boolean $$robo$$android_media_AudioManager$isWiredHeadsetOn() {
        return AudioSystem.getDeviceConnectionState(4, "") != 0 || AudioSystem.getDeviceConnectionState(8, "") != 0;
    }

    private final void $$robo$$android_media_AudioManager$setMicrophoneMute(boolean on) {
        IAudioService service = AudioManager.getService();
        try {
            service.setMicrophoneMute(on, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in setMicrophoneMute", e);
        }
    }

    private final boolean $$robo$$android_media_AudioManager$isMicrophoneMute() {
        return AudioSystem.isMicrophoneMuted();
    }

    private final void $$robo$$android_media_AudioManager$setMode(int mode) {
        IAudioService service = AudioManager.getService();
        try {
            service.setMode(mode, this.mICallBack);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in setMode", e);
        }
    }

    private final int $$robo$$android_media_AudioManager$getMode() {
        IAudioService service = AudioManager.getService();
        try {
            return service.getMode();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in getMode", e);
            return -2;
        }
    }

    @Deprecated
    private final void $$robo$$android_media_AudioManager$setRouting(int mode, int routes, int mask) {
    }

    @Deprecated
    private final int $$robo$$android_media_AudioManager$getRouting(int mode) {
        return -1;
    }

    private final boolean $$robo$$android_media_AudioManager$isMusicActive() {
        return AudioSystem.isStreamActive(3, 0);
    }

    private final boolean $$robo$$android_media_AudioManager$isMusicActiveRemotely() {
        return AudioSystem.isStreamActiveRemotely(3, 0);
    }

    private final boolean $$robo$$android_media_AudioManager$isAudioFocusExclusive() {
        IAudioService service = AudioManager.getService();
        try {
            return service.getCurrentAudioFocus() == 4;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in isAudioFocusExclusive()", e);
            return false;
        }
    }

    private final int $$robo$$android_media_AudioManager$generateAudioSessionId() {
        int session = AudioSystem.newAudioSessionId();
        if (session > 0) {
            return session;
        }
        Log.e(TAG, "Failure to generate a new audio session ID");
        return -1;
    }

    @Deprecated
    private final void $$robo$$android_media_AudioManager$setParameter(String key, String value) {
        this.setParameters(key + "=" + value);
    }

    private final void $$robo$$android_media_AudioManager$setParameters(String keyValuePairs) {
        AudioSystem.setParameters(keyValuePairs);
    }

    private final String $$robo$$android_media_AudioManager$getParameters(String keys) {
        return AudioSystem.getParameters(keys);
    }

    private final void $$robo$$android_media_AudioManager$playSoundEffect(int effectType) {
        if (effectType < 0 || effectType >= 10) {
            return;
        }
        if (!this.querySoundEffectsEnabled(Process.myUserHandle().getIdentifier())) {
            return;
        }
        IAudioService service = AudioManager.getService();
        try {
            service.playSoundEffect(effectType);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in playSoundEffect" + e);
        }
    }

    private final void $$robo$$android_media_AudioManager$playSoundEffect(int effectType, int userId) {
        if (effectType < 0 || effectType >= 10) {
            return;
        }
        if (!this.querySoundEffectsEnabled(userId)) {
            return;
        }
        IAudioService service = AudioManager.getService();
        try {
            service.playSoundEffect(effectType);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in playSoundEffect" + e);
        }
    }

    private final void $$robo$$android_media_AudioManager$playSoundEffect(int effectType, float volume) {
        if (effectType < 0 || effectType >= 10) {
            return;
        }
        IAudioService service = AudioManager.getService();
        try {
            service.playSoundEffectVolume(effectType, volume);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in playSoundEffect" + e);
        }
    }

    private final boolean $$robo$$android_media_AudioManager$querySoundEffectsEnabled(int user) {
        return Settings.System.getIntForUser(this.mContext.getContentResolver(), "sound_effects_enabled", 0, user) != 0;
    }

    private final void $$robo$$android_media_AudioManager$loadSoundEffects() {
        IAudioService service = AudioManager.getService();
        try {
            service.loadSoundEffects();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in loadSoundEffects" + e);
        }
    }

    private final void $$robo$$android_media_AudioManager$unloadSoundEffects() {
        IAudioService service = AudioManager.getService();
        try {
            service.unloadSoundEffects();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in unloadSoundEffects" + e);
        }
    }

    private final OnAudioFocusChangeListener $$robo$$android_media_AudioManager$findFocusListener(String id2) {
        return this.mAudioFocusIdListenerMap.get(id2);
    }

    private final String $$robo$$android_media_AudioManager$getIdForAudioFocusListener(OnAudioFocusChangeListener l) {
        if (l == null) {
            return new String(this.toString());
        }
        return new String(this.toString() + l.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_AudioManager$registerAudioFocusListener(OnAudioFocusChangeListener l) {
        Object object = this.mFocusListenerLock;
        synchronized (object) {
            if (this.mAudioFocusIdListenerMap.containsKey(this.getIdForAudioFocusListener(l))) {
                return;
            }
            this.mAudioFocusIdListenerMap.put(this.getIdForAudioFocusListener(l), l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_AudioManager$unregisterAudioFocusListener(OnAudioFocusChangeListener l) {
        Object object = this.mFocusListenerLock;
        synchronized (object) {
            this.mAudioFocusIdListenerMap.remove(this.getIdForAudioFocusListener(l));
        }
    }

    private final int $$robo$$android_media_AudioManager$requestAudioFocus(OnAudioFocusChangeListener l, int streamType, int durationHint) {
        int status = 0;
        if (durationHint < 1 || durationHint > 4) {
            Log.e(TAG, "Invalid duration hint, audio focus request denied");
            return status;
        }
        this.registerAudioFocusListener(l);
        IAudioService service = AudioManager.getService();
        try {
            status = service.requestAudioFocus(streamType, durationHint, this.mICallBack, this.mAudioFocusDispatcher, this.getIdForAudioFocusListener(l), this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            Log.e(TAG, "Can't call requestAudioFocus() on AudioService due to " + e);
        }
        return status;
    }

    private final void $$robo$$android_media_AudioManager$requestAudioFocusForCall(int streamType, int durationHint) {
        IAudioService service = AudioManager.getService();
        try {
            service.requestAudioFocus(streamType, durationHint, this.mICallBack, null, "AudioFocus_For_Phone_Ring_And_Calls", this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            Log.e(TAG, "Can't call requestAudioFocusForCall() on AudioService due to " + e);
        }
    }

    private final void $$robo$$android_media_AudioManager$abandonAudioFocusForCall() {
        IAudioService service = AudioManager.getService();
        try {
            service.abandonAudioFocus(null, "AudioFocus_For_Phone_Ring_And_Calls");
        }
        catch (RemoteException e) {
            Log.e(TAG, "Can't call abandonAudioFocusForCall() on AudioService due to " + e);
        }
    }

    private final int $$robo$$android_media_AudioManager$abandonAudioFocus(OnAudioFocusChangeListener l) {
        int status = 0;
        this.unregisterAudioFocusListener(l);
        IAudioService service = AudioManager.getService();
        try {
            status = service.abandonAudioFocus(this.mAudioFocusDispatcher, this.getIdForAudioFocusListener(l));
        }
        catch (RemoteException e) {
            Log.e(TAG, "Can't call abandonAudioFocus() on AudioService due to " + e);
        }
        return status;
    }

    @Deprecated
    private final void $$robo$$android_media_AudioManager$registerMediaButtonEventReceiver(ComponentName eventReceiver) {
        if (eventReceiver == null) {
            return;
        }
        if (!eventReceiver.getPackageName().equals(this.mContext.getPackageName())) {
            Log.e(TAG, "registerMediaButtonEventReceiver() error: receiver and context package names don't match");
            return;
        }
        Intent mediaButtonIntent = new Intent("android.intent.action.MEDIA_BUTTON");
        mediaButtonIntent.setComponent(eventReceiver);
        PendingIntent pi = PendingIntent.getBroadcast(this.mContext, 0, mediaButtonIntent, 0);
        this.registerMediaButtonIntent(pi, eventReceiver);
    }

    @Deprecated
    private final void $$robo$$android_media_AudioManager$registerMediaButtonEventReceiver(PendingIntent eventReceiver) {
        if (eventReceiver == null) {
            return;
        }
        this.registerMediaButtonIntent(eventReceiver, null);
    }

    private final void $$robo$$android_media_AudioManager$registerMediaButtonIntent(PendingIntent pi, ComponentName eventReceiver) {
        if (pi == null) {
            Log.e(TAG, "Cannot call registerMediaButtonIntent() with a null parameter");
            return;
        }
        MediaSessionLegacyHelper helper = MediaSessionLegacyHelper.getHelper(this.mContext);
        helper.addMediaButtonListener(pi, eventReceiver, this.mContext);
    }

    @Deprecated
    private final void $$robo$$android_media_AudioManager$unregisterMediaButtonEventReceiver(ComponentName eventReceiver) {
        if (eventReceiver == null) {
            return;
        }
        Intent mediaButtonIntent = new Intent("android.intent.action.MEDIA_BUTTON");
        mediaButtonIntent.setComponent(eventReceiver);
        PendingIntent pi = PendingIntent.getBroadcast(this.mContext, 0, mediaButtonIntent, 0);
        this.unregisterMediaButtonIntent(pi);
    }

    @Deprecated
    private final void $$robo$$android_media_AudioManager$unregisterMediaButtonEventReceiver(PendingIntent eventReceiver) {
        if (eventReceiver == null) {
            return;
        }
        this.unregisterMediaButtonIntent(eventReceiver);
    }

    private final void $$robo$$android_media_AudioManager$unregisterMediaButtonIntent(PendingIntent pi) {
        MediaSessionLegacyHelper helper = MediaSessionLegacyHelper.getHelper(this.mContext);
        helper.removeMediaButtonListener(pi);
    }

    @Deprecated
    private final void $$robo$$android_media_AudioManager$registerRemoteControlClient(RemoteControlClient rcClient) {
        if (rcClient == null || rcClient.getRcMediaIntent() == null) {
            return;
        }
        rcClient.registerWithSession(MediaSessionLegacyHelper.getHelper(this.mContext));
    }

    @Deprecated
    private final void $$robo$$android_media_AudioManager$unregisterRemoteControlClient(RemoteControlClient rcClient) {
        if (rcClient == null || rcClient.getRcMediaIntent() == null) {
            return;
        }
        rcClient.unregisterWithSession(MediaSessionLegacyHelper.getHelper(this.mContext));
    }

    @Deprecated
    private final boolean $$robo$$android_media_AudioManager$registerRemoteController(RemoteController rctlr) {
        if (rctlr == null) {
            return false;
        }
        rctlr.startListeningToSessions();
        return true;
    }

    @Deprecated
    private final void $$robo$$android_media_AudioManager$unregisterRemoteController(RemoteController rctlr) {
        if (rctlr == null) {
            return;
        }
        rctlr.stopListeningToSessions();
    }

    private final void $$robo$$android_media_AudioManager$registerRemoteControlDisplay(IRemoteControlDisplay rcd) {
        this.registerRemoteControlDisplay(rcd, -1, -1);
    }

    private final void $$robo$$android_media_AudioManager$registerRemoteControlDisplay(IRemoteControlDisplay rcd, int w, int h) {
        if (rcd == null) {
            return;
        }
        IAudioService service = AudioManager.getService();
        try {
            service.registerRemoteControlDisplay(rcd, w, h);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in registerRemoteControlDisplay " + e);
        }
    }

    private final void $$robo$$android_media_AudioManager$unregisterRemoteControlDisplay(IRemoteControlDisplay rcd) {
        if (rcd == null) {
            return;
        }
        IAudioService service = AudioManager.getService();
        try {
            service.unregisterRemoteControlDisplay(rcd);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in unregisterRemoteControlDisplay " + e);
        }
    }

    private final void $$robo$$android_media_AudioManager$remoteControlDisplayUsesBitmapSize(IRemoteControlDisplay rcd, int w, int h) {
        if (rcd == null) {
            return;
        }
        IAudioService service = AudioManager.getService();
        try {
            service.remoteControlDisplayUsesBitmapSize(rcd, w, h);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in remoteControlDisplayUsesBitmapSize " + e);
        }
    }

    private final void $$robo$$android_media_AudioManager$remoteControlDisplayWantsPlaybackPositionSync(IRemoteControlDisplay rcd, boolean wantsSync) {
        if (rcd == null) {
            return;
        }
        IAudioService service = AudioManager.getService();
        try {
            service.remoteControlDisplayWantsPlaybackPositionSync(rcd, wantsSync);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in remoteControlDisplayWantsPlaybackPositionSync " + e);
        }
    }

    private final int $$robo$$android_media_AudioManager$registerAudioPolicy(AudioPolicy policy) {
        if (policy == null) {
            throw new IllegalArgumentException("Illegal null AudioPolicy argument");
        }
        IAudioService service = AudioManager.getService();
        try {
            if (!service.registerAudioPolicy(policy.getConfig(), policy.token())) {
                return -1;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in registerAudioPolicyAsync()", e);
            return -1;
        }
        return 0;
    }

    private final void $$robo$$android_media_AudioManager$unregisterAudioPolicyAsync(AudioPolicy policy) {
        if (policy == null) {
            throw new IllegalArgumentException("Illegal null AudioPolicy argument");
        }
        IAudioService service = AudioManager.getService();
        try {
            service.unregisterAudioPolicyAsync(policy.token());
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in unregisterAudioPolicyAsync()", e);
        }
    }

    private final void $$robo$$android_media_AudioManager$reloadAudioSettings() {
        IAudioService service = AudioManager.getService();
        try {
            service.reloadAudioSettings();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in reloadAudioSettings" + e);
        }
    }

    private final void $$robo$$android_media_AudioManager$avrcpSupportsAbsoluteVolume(String address, boolean support) {
        IAudioService service = AudioManager.getService();
        try {
            service.avrcpSupportsAbsoluteVolume(address, support);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in avrcpSupportsAbsoluteVolume", e);
        }
    }

    private final boolean $$robo$$android_media_AudioManager$isSilentMode() {
        int ringerMode = this.getRingerMode();
        boolean silentMode = ringerMode == 0 || ringerMode == 1;
        return silentMode;
    }

    private static final boolean $$robo$$android_media_AudioManager$isOutputDevice(int device) {
        return (device & Integer.MIN_VALUE) == 0;
    }

    private static final boolean $$robo$$android_media_AudioManager$isInputDevice(int device) {
        return (device & Integer.MIN_VALUE) == Integer.MIN_VALUE;
    }

    private final int $$robo$$android_media_AudioManager$getDevicesForStream(int streamType) {
        switch (streamType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                return AudioSystem.getDevicesForStream(streamType);
            }
        }
        return 0;
    }

    private final void $$robo$$android_media_AudioManager$setWiredDeviceConnectionState(int device, int state, String name) {
        IAudioService service = AudioManager.getService();
        try {
            service.setWiredDeviceConnectionState(device, state, name);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in setWiredDeviceConnectionState " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_media_AudioManager$setBluetoothA2dpDeviceConnectionState(BluetoothDevice device, int state, int profile) {
        IAudioService service = AudioManager.getService();
        int delay = 0;
        try {
            delay = service.setBluetoothA2dpDeviceConnectionState(device, state, profile);
            return delay;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in setBluetoothA2dpDeviceConnectionState " + e);
        }
        finally {
            return delay;
        }
    }

    private final IRingtonePlayer $$robo$$android_media_AudioManager$getRingtonePlayer() {
        try {
            return AudioManager.getService().getRingtonePlayer();
        }
        catch (RemoteException e) {
            return null;
        }
    }

    private final String $$robo$$android_media_AudioManager$getProperty(String key) {
        if ("android.media.property.OUTPUT_SAMPLE_RATE".equals(key)) {
            int outputSampleRate = AudioSystem.getPrimaryOutputSamplingRate();
            return outputSampleRate > 0 ? Integer.toString(outputSampleRate) : null;
        }
        if ("android.media.property.OUTPUT_FRAMES_PER_BUFFER".equals(key)) {
            int outputFramesPerBuffer = AudioSystem.getPrimaryOutputFrameCount();
            return outputFramesPerBuffer > 0 ? Integer.toString(outputFramesPerBuffer) : null;
        }
        return null;
    }

    private final int $$robo$$android_media_AudioManager$getOutputLatency(int streamType) {
        return AudioSystem.getOutputLatency(streamType);
    }

    private final void $$robo$$android_media_AudioManager$setVolumeController(IVolumeController controller) {
        try {
            AudioManager.getService().setVolumeController(controller);
        }
        catch (RemoteException e) {
            Log.w(TAG, "Error setting volume controller", e);
        }
    }

    private final void $$robo$$android_media_AudioManager$notifyVolumeControllerVisible(IVolumeController controller, boolean visible) {
        try {
            AudioManager.getService().notifyVolumeControllerVisible(controller, visible);
        }
        catch (RemoteException e) {
            Log.w(TAG, "Error notifying about volume controller visibility", e);
        }
    }

    private final boolean $$robo$$android_media_AudioManager$isStreamAffectedByRingerMode(int streamType) {
        try {
            return AudioManager.getService().isStreamAffectedByRingerMode(streamType);
        }
        catch (RemoteException e) {
            Log.w(TAG, "Error calling isStreamAffectedByRingerMode", e);
            return false;
        }
    }

    private final void $$robo$$android_media_AudioManager$disableSafeMediaVolume() {
        try {
            AudioManager.getService().disableSafeMediaVolume();
        }
        catch (RemoteException e) {
            Log.w(TAG, "Error disabling safe media volume", e);
        }
    }

    private final int $$robo$$android_media_AudioManager$setHdmiSystemAudioSupported(boolean on) {
        try {
            return AudioManager.getService().setHdmiSystemAudioSupported(on);
        }
        catch (RemoteException e) {
            Log.w(TAG, "Error setting system audio mode", e);
            return 0;
        }
    }

    private final boolean $$robo$$android_media_AudioManager$isHdmiSystemAudioSupported() {
        try {
            return AudioManager.getService().isHdmiSystemAudioSupported();
        }
        catch (RemoteException e) {
            Log.w(TAG, "Error querying system audio mode", e);
            return false;
        }
    }

    private final int $$robo$$android_media_AudioManager$listAudioPorts(ArrayList<AudioPort> ports) {
        return this.updateAudioPortCache(ports, null);
    }

    private final int $$robo$$android_media_AudioManager$listAudioDevicePorts(ArrayList<AudioPort> devices) {
        ArrayList<AudioPort> ports = new ArrayList<AudioPort>();
        int status = this.updateAudioPortCache(ports, null);
        if (status == 0) {
            devices.clear();
            for (int i = 0; i < ports.size(); ++i) {
                if (!(ports.get(i) instanceof AudioDevicePort)) continue;
                devices.add(ports.get(i));
            }
        }
        return status;
    }

    private final int $$robo$$android_media_AudioManager$createAudioPatch(AudioPatch[] patch, AudioPortConfig[] sources, AudioPortConfig[] sinks) {
        return AudioSystem.createAudioPatch(patch, sources, sinks);
    }

    private final int $$robo$$android_media_AudioManager$releaseAudioPatch(AudioPatch patch) {
        return AudioSystem.releaseAudioPatch(patch);
    }

    private final int $$robo$$android_media_AudioManager$listAudioPatches(ArrayList<AudioPatch> patches) {
        return this.updateAudioPortCache(null, patches);
    }

    private final int $$robo$$android_media_AudioManager$setAudioPortGain(AudioPort port, AudioGainConfig gain) {
        if (port == null || gain == null) {
            return -2;
        }
        AudioPortConfig activeConfig = port.activeConfig();
        AudioPortConfig config = new AudioPortConfig(port, activeConfig.samplingRate(), activeConfig.channelMask(), activeConfig.format(), gain);
        config.mConfigMask = 8;
        return AudioSystem.setAudioPortConfig(config);
    }

    private final void $$robo$$android_media_AudioManager$registerAudioPortUpdateListener(OnAudioPortUpdateListener l) {
        this.mAudioPortEventHandler.registerListener(l);
    }

    private final void $$robo$$android_media_AudioManager$unregisterAudioPortUpdateListener(OnAudioPortUpdateListener l) {
        this.mAudioPortEventHandler.unregisterListener(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_media_AudioManager$resetAudioPortGeneration() {
        int generation;
        Integer n = this.mAudioPortGeneration;
        synchronized (n) {
            generation = this.mAudioPortGeneration;
            this.mAudioPortGeneration = 0;
        }
        return generation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_media_AudioManager$updateAudioPortCache(ArrayList<AudioPort> ports, ArrayList<AudioPatch> patches) {
        Integer n = this.mAudioPortGeneration;
        synchronized (n) {
            if (this.mAudioPortGeneration == 0) {
                int[] patchGeneration = new int[1];
                int[] portGeneration = new int[1];
                ArrayList<AudioPort> newPorts = new ArrayList<AudioPort>();
                ArrayList<AudioPatch> newPatches = new ArrayList<AudioPatch>();
                do {
                    newPorts.clear();
                    int status = AudioSystem.listAudioPorts(newPorts, portGeneration);
                    if (status != 0) {
                        return status;
                    }
                    newPatches.clear();
                    status = AudioSystem.listAudioPatches(newPatches, patchGeneration);
                    if (status == 0) continue;
                    return status;
                } while (patchGeneration[0] != portGeneration[0]);
                for (int i = 0; i < newPatches.size(); ++i) {
                    AudioPortConfig portCfg;
                    int j;
                    for (j = 0; j < newPatches.get(i).sources().length; ++j) {
                        portCfg = this.updatePortConfig(newPatches.get(i).sources()[j], newPorts);
                        if (portCfg == null) {
                            return -1;
                        }
                        newPatches.get((int)i).sources()[j] = portCfg;
                    }
                    for (j = 0; j < newPatches.get(i).sinks().length; ++j) {
                        portCfg = this.updatePortConfig(newPatches.get(i).sinks()[j], newPorts);
                        if (portCfg == null) {
                            return -1;
                        }
                        newPatches.get((int)i).sinks()[j] = portCfg;
                    }
                }
                this.mAudioPortsCached = newPorts;
                this.mAudioPatchesCached = newPatches;
                this.mAudioPortGeneration = portGeneration[0];
            }
            if (ports != null) {
                ports.clear();
                ports.addAll(this.mAudioPortsCached);
            }
            if (patches != null) {
                patches.clear();
                patches.addAll(this.mAudioPatchesCached);
            }
        }
        return 0;
    }

    private final AudioPortConfig $$robo$$android_media_AudioManager$updatePortConfig(AudioPortConfig portCfg, ArrayList<AudioPort> ports) {
        int k;
        AudioPort port = portCfg.port();
        for (k = 0; k < ports.size(); ++k) {
            if (!ports.get(k).handle().equals(port.handle())) continue;
            port = ports.get(k);
            break;
        }
        if (k == ports.size()) {
            Log.e(TAG, "updatePortConfig port not found for handle: " + port.handle().id());
            return null;
        }
        AudioGainConfig gainCfg = portCfg.gain();
        if (gainCfg != null) {
            AudioGain gain = port.gain(gainCfg.index());
            gainCfg = gain.buildConfig(gainCfg.mode(), gainCfg.channelMask(), gainCfg.values(), gainCfg.rampDurationMs());
        }
        return port.buildConfig(portCfg.samplingRate(), portCfg.channelMask(), portCfg.format(), gainCfg);
    }

    static void __staticInitializer__() {
        TAG = "AudioManager";
        DEFAULT_STREAM_VOLUME = new int[]{4, 7, 5, 11, 6, 5, 7, 7, 11, 11};
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_media_AudioManager$__constructor__(context);
    }

    public AudioManager(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioManager$__constructor__(android.content.Context ), 0, this, context);
    }

    private static IAudioService getService() {
        return InvokeDynamicSupport.bootstrapStatic("getService", $$robo$$android_media_AudioManager$getService(), 0);
    }

    public void dispatchMediaKeyEvent(KeyEvent keyEvent) {
        InvokeDynamicSupport.bootstrap("dispatchMediaKeyEvent", $$robo$$android_media_AudioManager$dispatchMediaKeyEvent(android.view.KeyEvent ), 0, this, keyEvent);
    }

    public void preDispatchKeyEvent(KeyEvent keyEvent, int n) {
        InvokeDynamicSupport.bootstrap("preDispatchKeyEvent", $$robo$$android_media_AudioManager$preDispatchKeyEvent(android.view.KeyEvent int ), 0, this, keyEvent, n);
    }

    public void handleKeyDown(KeyEvent keyEvent, int n) {
        InvokeDynamicSupport.bootstrap("handleKeyDown", $$robo$$android_media_AudioManager$handleKeyDown(android.view.KeyEvent int ), 0, this, keyEvent, n);
    }

    public void handleKeyUp(KeyEvent keyEvent, int n) {
        InvokeDynamicSupport.bootstrap("handleKeyUp", $$robo$$android_media_AudioManager$handleKeyUp(android.view.KeyEvent int ), 0, this, keyEvent, n);
    }

    public boolean isVolumeFixed() {
        return (boolean)InvokeDynamicSupport.bootstrap("isVolumeFixed", $$robo$$android_media_AudioManager$isVolumeFixed(), 0, this);
    }

    public void adjustStreamVolume(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("adjustStreamVolume", $$robo$$android_media_AudioManager$adjustStreamVolume(int int int ), 0, this, n, n2, n3);
    }

    public void adjustVolume(int n, int n2) {
        InvokeDynamicSupport.bootstrap("adjustVolume", $$robo$$android_media_AudioManager$adjustVolume(int int ), 0, this, n, n2);
    }

    public void adjustSuggestedStreamVolume(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("adjustSuggestedStreamVolume", $$robo$$android_media_AudioManager$adjustSuggestedStreamVolume(int int int ), 0, this, n, n2, n3);
    }

    public void adjustMasterVolume(int n, int n2) {
        InvokeDynamicSupport.bootstrap("adjustMasterVolume", $$robo$$android_media_AudioManager$adjustMasterVolume(int int ), 0, this, n, n2);
    }

    public int getRingerMode() {
        return (int)InvokeDynamicSupport.bootstrap("getRingerMode", $$robo$$android_media_AudioManager$getRingerMode(), 0, this);
    }

    public static boolean isValidRingerMode(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidRingerMode", $$robo$$android_media_AudioManager$isValidRingerMode(int ), 0, (int)n);
    }

    public int getStreamMaxVolume(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getStreamMaxVolume", $$robo$$android_media_AudioManager$getStreamMaxVolume(int ), 0, this, n);
    }

    public int getStreamVolume(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getStreamVolume", $$robo$$android_media_AudioManager$getStreamVolume(int ), 0, this, n);
    }

    public int getLastAudibleStreamVolume(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getLastAudibleStreamVolume", $$robo$$android_media_AudioManager$getLastAudibleStreamVolume(int ), 0, this, n);
    }

    public int getMasterStreamType() {
        return (int)InvokeDynamicSupport.bootstrap("getMasterStreamType", $$robo$$android_media_AudioManager$getMasterStreamType(), 0, this);
    }

    public void setRingerMode(int n) {
        InvokeDynamicSupport.bootstrap("setRingerMode", $$robo$$android_media_AudioManager$setRingerMode(int ), 0, this, n);
    }

    public void setRingerMode(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("setRingerMode", $$robo$$android_media_AudioManager$setRingerMode(int boolean ), 0, this, n, bl);
    }

    public void setStreamVolume(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("setStreamVolume", $$robo$$android_media_AudioManager$setStreamVolume(int int int ), 0, this, n, n2, n3);
    }

    public int getMasterMaxVolume() {
        return (int)InvokeDynamicSupport.bootstrap("getMasterMaxVolume", $$robo$$android_media_AudioManager$getMasterMaxVolume(), 0, this);
    }

    public int getMasterVolume() {
        return (int)InvokeDynamicSupport.bootstrap("getMasterVolume", $$robo$$android_media_AudioManager$getMasterVolume(), 0, this);
    }

    public int getLastAudibleMasterVolume() {
        return (int)InvokeDynamicSupport.bootstrap("getLastAudibleMasterVolume", $$robo$$android_media_AudioManager$getLastAudibleMasterVolume(), 0, this);
    }

    public void setMasterVolume(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setMasterVolume", $$robo$$android_media_AudioManager$setMasterVolume(int int ), 0, this, n, n2);
    }

    public void setStreamSolo(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("setStreamSolo", $$robo$$android_media_AudioManager$setStreamSolo(int boolean ), 0, this, n, bl);
    }

    public void setStreamMute(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("setStreamMute", $$robo$$android_media_AudioManager$setStreamMute(int boolean ), 0, this, n, bl);
    }

    public boolean isStreamMute(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isStreamMute", $$robo$$android_media_AudioManager$isStreamMute(int ), 0, this, n);
    }

    public void setMasterMute(boolean bl) {
        InvokeDynamicSupport.bootstrap("setMasterMute", $$robo$$android_media_AudioManager$setMasterMute(boolean ), 0, this, bl);
    }

    public void setMasterMute(boolean bl, int n) {
        InvokeDynamicSupport.bootstrap("setMasterMute", $$robo$$android_media_AudioManager$setMasterMute(boolean int ), 0, this, bl, n);
    }

    public boolean isMasterMute() {
        return (boolean)InvokeDynamicSupport.bootstrap("isMasterMute", $$robo$$android_media_AudioManager$isMasterMute(), 0, this);
    }

    public void forceVolumeControlStream(int n) {
        InvokeDynamicSupport.bootstrap("forceVolumeControlStream", $$robo$$android_media_AudioManager$forceVolumeControlStream(int ), 0, this, n);
    }

    public boolean shouldVibrate(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldVibrate", $$robo$$android_media_AudioManager$shouldVibrate(int ), 0, this, n);
    }

    public int getVibrateSetting(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getVibrateSetting", $$robo$$android_media_AudioManager$getVibrateSetting(int ), 0, this, n);
    }

    public void setVibrateSetting(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setVibrateSetting", $$robo$$android_media_AudioManager$setVibrateSetting(int int ), 0, this, n, n2);
    }

    public void setSpeakerphoneOn(boolean bl) {
        InvokeDynamicSupport.bootstrap("setSpeakerphoneOn", $$robo$$android_media_AudioManager$setSpeakerphoneOn(boolean ), 0, this, bl);
    }

    public boolean isSpeakerphoneOn() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSpeakerphoneOn", $$robo$$android_media_AudioManager$isSpeakerphoneOn(), 0, this);
    }

    public boolean isBluetoothScoAvailableOffCall() {
        return (boolean)InvokeDynamicSupport.bootstrap("isBluetoothScoAvailableOffCall", $$robo$$android_media_AudioManager$isBluetoothScoAvailableOffCall(), 0, this);
    }

    public void startBluetoothSco() {
        InvokeDynamicSupport.bootstrap("startBluetoothSco", $$robo$$android_media_AudioManager$startBluetoothSco(), 0, this);
    }

    public void startBluetoothScoVirtualCall() {
        InvokeDynamicSupport.bootstrap("startBluetoothScoVirtualCall", $$robo$$android_media_AudioManager$startBluetoothScoVirtualCall(), 0, this);
    }

    public void stopBluetoothSco() {
        InvokeDynamicSupport.bootstrap("stopBluetoothSco", $$robo$$android_media_AudioManager$stopBluetoothSco(), 0, this);
    }

    public void setBluetoothScoOn(boolean bl) {
        InvokeDynamicSupport.bootstrap("setBluetoothScoOn", $$robo$$android_media_AudioManager$setBluetoothScoOn(boolean ), 0, this, bl);
    }

    public boolean isBluetoothScoOn() {
        return (boolean)InvokeDynamicSupport.bootstrap("isBluetoothScoOn", $$robo$$android_media_AudioManager$isBluetoothScoOn(), 0, this);
    }

    @Deprecated
    public void setBluetoothA2dpOn(boolean bl) {
        InvokeDynamicSupport.bootstrap("setBluetoothA2dpOn", $$robo$$android_media_AudioManager$setBluetoothA2dpOn(boolean ), 0, this, bl);
    }

    public boolean isBluetoothA2dpOn() {
        return (boolean)InvokeDynamicSupport.bootstrap("isBluetoothA2dpOn", $$robo$$android_media_AudioManager$isBluetoothA2dpOn(), 0, this);
    }

    @Deprecated
    public void setWiredHeadsetOn(boolean bl) {
        InvokeDynamicSupport.bootstrap("setWiredHeadsetOn", $$robo$$android_media_AudioManager$setWiredHeadsetOn(boolean ), 0, this, bl);
    }

    public boolean isWiredHeadsetOn() {
        return (boolean)InvokeDynamicSupport.bootstrap("isWiredHeadsetOn", $$robo$$android_media_AudioManager$isWiredHeadsetOn(), 0, this);
    }

    public void setMicrophoneMute(boolean bl) {
        InvokeDynamicSupport.bootstrap("setMicrophoneMute", $$robo$$android_media_AudioManager$setMicrophoneMute(boolean ), 0, this, bl);
    }

    public boolean isMicrophoneMute() {
        return (boolean)InvokeDynamicSupport.bootstrap("isMicrophoneMute", $$robo$$android_media_AudioManager$isMicrophoneMute(), 0, this);
    }

    public void setMode(int n) {
        InvokeDynamicSupport.bootstrap("setMode", $$robo$$android_media_AudioManager$setMode(int ), 0, this, n);
    }

    public int getMode() {
        return (int)InvokeDynamicSupport.bootstrap("getMode", $$robo$$android_media_AudioManager$getMode(), 0, this);
    }

    @Deprecated
    public void setRouting(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("setRouting", $$robo$$android_media_AudioManager$setRouting(int int int ), 0, this, n, n2, n3);
    }

    @Deprecated
    public int getRouting(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getRouting", $$robo$$android_media_AudioManager$getRouting(int ), 0, this, n);
    }

    public boolean isMusicActive() {
        return (boolean)InvokeDynamicSupport.bootstrap("isMusicActive", $$robo$$android_media_AudioManager$isMusicActive(), 0, this);
    }

    public boolean isMusicActiveRemotely() {
        return (boolean)InvokeDynamicSupport.bootstrap("isMusicActiveRemotely", $$robo$$android_media_AudioManager$isMusicActiveRemotely(), 0, this);
    }

    public boolean isAudioFocusExclusive() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAudioFocusExclusive", $$robo$$android_media_AudioManager$isAudioFocusExclusive(), 0, this);
    }

    public int generateAudioSessionId() {
        return (int)InvokeDynamicSupport.bootstrap("generateAudioSessionId", $$robo$$android_media_AudioManager$generateAudioSessionId(), 0, this);
    }

    @Deprecated
    public void setParameter(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("setParameter", $$robo$$android_media_AudioManager$setParameter(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public void setParameters(String string2) {
        InvokeDynamicSupport.bootstrap("setParameters", $$robo$$android_media_AudioManager$setParameters(java.lang.String ), 0, this, string2);
    }

    public String getParameters(String string2) {
        return InvokeDynamicSupport.bootstrap("getParameters", $$robo$$android_media_AudioManager$getParameters(java.lang.String ), 0, this, string2);
    }

    public void playSoundEffect(int n) {
        InvokeDynamicSupport.bootstrap("playSoundEffect", $$robo$$android_media_AudioManager$playSoundEffect(int ), 0, this, n);
    }

    public void playSoundEffect(int n, int n2) {
        InvokeDynamicSupport.bootstrap("playSoundEffect", $$robo$$android_media_AudioManager$playSoundEffect(int int ), 0, this, n, n2);
    }

    public void playSoundEffect(int n, float f) {
        InvokeDynamicSupport.bootstrap("playSoundEffect", $$robo$$android_media_AudioManager$playSoundEffect(int float ), 0, this, n, f);
    }

    private boolean querySoundEffectsEnabled(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("querySoundEffectsEnabled", $$robo$$android_media_AudioManager$querySoundEffectsEnabled(int ), 0, this, n);
    }

    public void loadSoundEffects() {
        InvokeDynamicSupport.bootstrap("loadSoundEffects", $$robo$$android_media_AudioManager$loadSoundEffects(), 0, this);
    }

    public void unloadSoundEffects() {
        InvokeDynamicSupport.bootstrap("unloadSoundEffects", $$robo$$android_media_AudioManager$unloadSoundEffects(), 0, this);
    }

    private OnAudioFocusChangeListener findFocusListener(String string2) {
        return InvokeDynamicSupport.bootstrap("findFocusListener", $$robo$$android_media_AudioManager$findFocusListener(java.lang.String ), 0, this, string2);
    }

    private String getIdForAudioFocusListener(OnAudioFocusChangeListener onAudioFocusChangeListener) {
        return InvokeDynamicSupport.bootstrap("getIdForAudioFocusListener", $$robo$$android_media_AudioManager$getIdForAudioFocusListener(android.media.AudioManager$OnAudioFocusChangeListener ), 0, this, onAudioFocusChangeListener);
    }

    public void registerAudioFocusListener(OnAudioFocusChangeListener onAudioFocusChangeListener) {
        InvokeDynamicSupport.bootstrap("registerAudioFocusListener", $$robo$$android_media_AudioManager$registerAudioFocusListener(android.media.AudioManager$OnAudioFocusChangeListener ), 0, this, onAudioFocusChangeListener);
    }

    public void unregisterAudioFocusListener(OnAudioFocusChangeListener onAudioFocusChangeListener) {
        InvokeDynamicSupport.bootstrap("unregisterAudioFocusListener", $$robo$$android_media_AudioManager$unregisterAudioFocusListener(android.media.AudioManager$OnAudioFocusChangeListener ), 0, this, onAudioFocusChangeListener);
    }

    public int requestAudioFocus(OnAudioFocusChangeListener onAudioFocusChangeListener, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("requestAudioFocus", $$robo$$android_media_AudioManager$requestAudioFocus(android.media.AudioManager$OnAudioFocusChangeListener int int ), 0, this, onAudioFocusChangeListener, n, n2);
    }

    public void requestAudioFocusForCall(int n, int n2) {
        InvokeDynamicSupport.bootstrap("requestAudioFocusForCall", $$robo$$android_media_AudioManager$requestAudioFocusForCall(int int ), 0, this, n, n2);
    }

    public void abandonAudioFocusForCall() {
        InvokeDynamicSupport.bootstrap("abandonAudioFocusForCall", $$robo$$android_media_AudioManager$abandonAudioFocusForCall(), 0, this);
    }

    public int abandonAudioFocus(OnAudioFocusChangeListener onAudioFocusChangeListener) {
        return (int)InvokeDynamicSupport.bootstrap("abandonAudioFocus", $$robo$$android_media_AudioManager$abandonAudioFocus(android.media.AudioManager$OnAudioFocusChangeListener ), 0, this, onAudioFocusChangeListener);
    }

    @Deprecated
    public void registerMediaButtonEventReceiver(ComponentName componentName) {
        InvokeDynamicSupport.bootstrap("registerMediaButtonEventReceiver", $$robo$$android_media_AudioManager$registerMediaButtonEventReceiver(android.content.ComponentName ), 0, this, componentName);
    }

    @Deprecated
    public void registerMediaButtonEventReceiver(PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("registerMediaButtonEventReceiver", $$robo$$android_media_AudioManager$registerMediaButtonEventReceiver(android.app.PendingIntent ), 0, this, pendingIntent);
    }

    public void registerMediaButtonIntent(PendingIntent pendingIntent, ComponentName componentName) {
        InvokeDynamicSupport.bootstrap("registerMediaButtonIntent", $$robo$$android_media_AudioManager$registerMediaButtonIntent(android.app.PendingIntent android.content.ComponentName ), 0, this, pendingIntent, componentName);
    }

    @Deprecated
    public void unregisterMediaButtonEventReceiver(ComponentName componentName) {
        InvokeDynamicSupport.bootstrap("unregisterMediaButtonEventReceiver", $$robo$$android_media_AudioManager$unregisterMediaButtonEventReceiver(android.content.ComponentName ), 0, this, componentName);
    }

    @Deprecated
    public void unregisterMediaButtonEventReceiver(PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("unregisterMediaButtonEventReceiver", $$robo$$android_media_AudioManager$unregisterMediaButtonEventReceiver(android.app.PendingIntent ), 0, this, pendingIntent);
    }

    public void unregisterMediaButtonIntent(PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("unregisterMediaButtonIntent", $$robo$$android_media_AudioManager$unregisterMediaButtonIntent(android.app.PendingIntent ), 0, this, pendingIntent);
    }

    @Deprecated
    public void registerRemoteControlClient(RemoteControlClient remoteControlClient) {
        InvokeDynamicSupport.bootstrap("registerRemoteControlClient", $$robo$$android_media_AudioManager$registerRemoteControlClient(android.media.RemoteControlClient ), 0, this, remoteControlClient);
    }

    @Deprecated
    public void unregisterRemoteControlClient(RemoteControlClient remoteControlClient) {
        InvokeDynamicSupport.bootstrap("unregisterRemoteControlClient", $$robo$$android_media_AudioManager$unregisterRemoteControlClient(android.media.RemoteControlClient ), 0, this, remoteControlClient);
    }

    @Deprecated
    public boolean registerRemoteController(RemoteController remoteController) {
        return (boolean)InvokeDynamicSupport.bootstrap("registerRemoteController", $$robo$$android_media_AudioManager$registerRemoteController(android.media.RemoteController ), 0, this, remoteController);
    }

    @Deprecated
    public void unregisterRemoteController(RemoteController remoteController) {
        InvokeDynamicSupport.bootstrap("unregisterRemoteController", $$robo$$android_media_AudioManager$unregisterRemoteController(android.media.RemoteController ), 0, this, remoteController);
    }

    public void registerRemoteControlDisplay(IRemoteControlDisplay iRemoteControlDisplay) {
        InvokeDynamicSupport.bootstrap("registerRemoteControlDisplay", $$robo$$android_media_AudioManager$registerRemoteControlDisplay(android.media.IRemoteControlDisplay ), 0, this, iRemoteControlDisplay);
    }

    public void registerRemoteControlDisplay(IRemoteControlDisplay iRemoteControlDisplay, int n, int n2) {
        InvokeDynamicSupport.bootstrap("registerRemoteControlDisplay", $$robo$$android_media_AudioManager$registerRemoteControlDisplay(android.media.IRemoteControlDisplay int int ), 0, this, iRemoteControlDisplay, n, n2);
    }

    public void unregisterRemoteControlDisplay(IRemoteControlDisplay iRemoteControlDisplay) {
        InvokeDynamicSupport.bootstrap("unregisterRemoteControlDisplay", $$robo$$android_media_AudioManager$unregisterRemoteControlDisplay(android.media.IRemoteControlDisplay ), 0, this, iRemoteControlDisplay);
    }

    public void remoteControlDisplayUsesBitmapSize(IRemoteControlDisplay iRemoteControlDisplay, int n, int n2) {
        InvokeDynamicSupport.bootstrap("remoteControlDisplayUsesBitmapSize", $$robo$$android_media_AudioManager$remoteControlDisplayUsesBitmapSize(android.media.IRemoteControlDisplay int int ), 0, this, iRemoteControlDisplay, n, n2);
    }

    public void remoteControlDisplayWantsPlaybackPositionSync(IRemoteControlDisplay iRemoteControlDisplay, boolean bl) {
        InvokeDynamicSupport.bootstrap("remoteControlDisplayWantsPlaybackPositionSync", $$robo$$android_media_AudioManager$remoteControlDisplayWantsPlaybackPositionSync(android.media.IRemoteControlDisplay boolean ), 0, this, iRemoteControlDisplay, bl);
    }

    public int registerAudioPolicy(AudioPolicy audioPolicy) {
        return (int)InvokeDynamicSupport.bootstrap("registerAudioPolicy", $$robo$$android_media_AudioManager$registerAudioPolicy(android.media.audiopolicy.AudioPolicy ), 0, this, audioPolicy);
    }

    public void unregisterAudioPolicyAsync(AudioPolicy audioPolicy) {
        InvokeDynamicSupport.bootstrap("unregisterAudioPolicyAsync", $$robo$$android_media_AudioManager$unregisterAudioPolicyAsync(android.media.audiopolicy.AudioPolicy ), 0, this, audioPolicy);
    }

    public void reloadAudioSettings() {
        InvokeDynamicSupport.bootstrap("reloadAudioSettings", $$robo$$android_media_AudioManager$reloadAudioSettings(), 0, this);
    }

    public void avrcpSupportsAbsoluteVolume(String string2, boolean bl) {
        InvokeDynamicSupport.bootstrap("avrcpSupportsAbsoluteVolume", $$robo$$android_media_AudioManager$avrcpSupportsAbsoluteVolume(java.lang.String boolean ), 0, this, string2, bl);
    }

    public boolean isSilentMode() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSilentMode", $$robo$$android_media_AudioManager$isSilentMode(), 0, this);
    }

    public static boolean isOutputDevice(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isOutputDevice", $$robo$$android_media_AudioManager$isOutputDevice(int ), 0, (int)n);
    }

    public static boolean isInputDevice(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isInputDevice", $$robo$$android_media_AudioManager$isInputDevice(int ), 0, (int)n);
    }

    public int getDevicesForStream(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getDevicesForStream", $$robo$$android_media_AudioManager$getDevicesForStream(int ), 0, this, n);
    }

    public void setWiredDeviceConnectionState(int n, int n2, String string2) {
        InvokeDynamicSupport.bootstrap("setWiredDeviceConnectionState", $$robo$$android_media_AudioManager$setWiredDeviceConnectionState(int int java.lang.String ), 0, this, n, n2, string2);
    }

    public int setBluetoothA2dpDeviceConnectionState(BluetoothDevice bluetoothDevice, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("setBluetoothA2dpDeviceConnectionState", $$robo$$android_media_AudioManager$setBluetoothA2dpDeviceConnectionState(android.bluetooth.BluetoothDevice int int ), 0, this, bluetoothDevice, n, n2);
    }

    public IRingtonePlayer getRingtonePlayer() {
        return InvokeDynamicSupport.bootstrap("getRingtonePlayer", $$robo$$android_media_AudioManager$getRingtonePlayer(), 0, this);
    }

    public String getProperty(String string2) {
        return InvokeDynamicSupport.bootstrap("getProperty", $$robo$$android_media_AudioManager$getProperty(java.lang.String ), 0, this, string2);
    }

    public int getOutputLatency(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getOutputLatency", $$robo$$android_media_AudioManager$getOutputLatency(int ), 0, this, n);
    }

    public void setVolumeController(IVolumeController iVolumeController) {
        InvokeDynamicSupport.bootstrap("setVolumeController", $$robo$$android_media_AudioManager$setVolumeController(android.media.IVolumeController ), 0, this, iVolumeController);
    }

    public void notifyVolumeControllerVisible(IVolumeController iVolumeController, boolean bl) {
        InvokeDynamicSupport.bootstrap("notifyVolumeControllerVisible", $$robo$$android_media_AudioManager$notifyVolumeControllerVisible(android.media.IVolumeController boolean ), 0, this, iVolumeController, bl);
    }

    public boolean isStreamAffectedByRingerMode(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isStreamAffectedByRingerMode", $$robo$$android_media_AudioManager$isStreamAffectedByRingerMode(int ), 0, this, n);
    }

    public void disableSafeMediaVolume() {
        InvokeDynamicSupport.bootstrap("disableSafeMediaVolume", $$robo$$android_media_AudioManager$disableSafeMediaVolume(), 0, this);
    }

    public int setHdmiSystemAudioSupported(boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("setHdmiSystemAudioSupported", $$robo$$android_media_AudioManager$setHdmiSystemAudioSupported(boolean ), 0, this, bl);
    }

    public boolean isHdmiSystemAudioSupported() {
        return (boolean)InvokeDynamicSupport.bootstrap("isHdmiSystemAudioSupported", $$robo$$android_media_AudioManager$isHdmiSystemAudioSupported(), 0, this);
    }

    public int listAudioPorts(ArrayList<AudioPort> arrayList) {
        return (int)InvokeDynamicSupport.bootstrap("listAudioPorts", $$robo$$android_media_AudioManager$listAudioPorts(java.util.ArrayList<android.media.AudioPort> ), 0, this, arrayList);
    }

    public int listAudioDevicePorts(ArrayList<AudioPort> arrayList) {
        return (int)InvokeDynamicSupport.bootstrap("listAudioDevicePorts", $$robo$$android_media_AudioManager$listAudioDevicePorts(java.util.ArrayList<android.media.AudioPort> ), 0, this, arrayList);
    }

    public int createAudioPatch(AudioPatch[] audioPatchArray, AudioPortConfig[] audioPortConfigArray, AudioPortConfig[] audioPortConfigArray2) {
        return (int)InvokeDynamicSupport.bootstrap("createAudioPatch", $$robo$$android_media_AudioManager$createAudioPatch(android.media.AudioPatch[] android.media.AudioPortConfig[] android.media.AudioPortConfig[] ), 0, this, audioPatchArray, audioPortConfigArray, audioPortConfigArray2);
    }

    public int releaseAudioPatch(AudioPatch audioPatch) {
        return (int)InvokeDynamicSupport.bootstrap("releaseAudioPatch", $$robo$$android_media_AudioManager$releaseAudioPatch(android.media.AudioPatch ), 0, this, audioPatch);
    }

    public int listAudioPatches(ArrayList<AudioPatch> arrayList) {
        return (int)InvokeDynamicSupport.bootstrap("listAudioPatches", $$robo$$android_media_AudioManager$listAudioPatches(java.util.ArrayList<android.media.AudioPatch> ), 0, this, arrayList);
    }

    public int setAudioPortGain(AudioPort audioPort, AudioGainConfig audioGainConfig) {
        return (int)InvokeDynamicSupport.bootstrap("setAudioPortGain", $$robo$$android_media_AudioManager$setAudioPortGain(android.media.AudioPort android.media.AudioGainConfig ), 0, this, audioPort, audioGainConfig);
    }

    public void registerAudioPortUpdateListener(OnAudioPortUpdateListener onAudioPortUpdateListener) {
        InvokeDynamicSupport.bootstrap("registerAudioPortUpdateListener", $$robo$$android_media_AudioManager$registerAudioPortUpdateListener(android.media.AudioManager$OnAudioPortUpdateListener ), 0, this, onAudioPortUpdateListener);
    }

    public void unregisterAudioPortUpdateListener(OnAudioPortUpdateListener onAudioPortUpdateListener) {
        InvokeDynamicSupport.bootstrap("unregisterAudioPortUpdateListener", $$robo$$android_media_AudioManager$unregisterAudioPortUpdateListener(android.media.AudioManager$OnAudioPortUpdateListener ), 0, this, onAudioPortUpdateListener);
    }

    int resetAudioPortGeneration() {
        return (int)InvokeDynamicSupport.bootstrap("resetAudioPortGeneration", $$robo$$android_media_AudioManager$resetAudioPortGeneration(), 0, this);
    }

    int updateAudioPortCache(ArrayList<AudioPort> arrayList, ArrayList<AudioPatch> arrayList2) {
        return (int)InvokeDynamicSupport.bootstrap("updateAudioPortCache", $$robo$$android_media_AudioManager$updateAudioPortCache(java.util.ArrayList<android.media.AudioPort> java.util.ArrayList<android.media.AudioPatch> ), 0, this, arrayList, arrayList2);
    }

    AudioPortConfig updatePortConfig(AudioPortConfig audioPortConfig, ArrayList<AudioPort> arrayList) {
        return InvokeDynamicSupport.bootstrap("updatePortConfig", $$robo$$android_media_AudioManager$updatePortConfig(android.media.AudioPortConfig java.util.ArrayList<android.media.AudioPort> ), 0, this, audioPortConfig, arrayList);
    }

    static {
        RobolectricInternals.classInitializing(AudioManager.class);
    }

    public /* synthetic */ AudioManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AudioManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface OnAudioPortUpdateListener
    extends InstrumentedInterface {
        public void onAudioPortListUpdate(AudioPort[] var1);

        public void onAudioPatchListUpdate(AudioPatch[] var1);

        public void onServiceDied();
    }

    private class FocusEventHandlerDelegate
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Handler mHandler;
        /* synthetic */ AudioManager this$0;

        private void $$robo$$android_media_AudioManager_FocusEventHandlerDelegate$__constructor__(AudioManager audioManager) {
            Looper looper = Looper.myLooper();
            if (looper == null) {
                looper = Looper.getMainLooper();
            }
            this.mHandler = looper != null ? new ShadowedObject(this, looper, audioManager){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ AudioManager val$this$0;
                /* synthetic */ FocusEventHandlerDelegate this$1;

                private void $$robo$$android_media_AudioManager_FocusEventHandlerDelegate_1$__constructor__(FocusEventHandlerDelegate focusEventHandlerDelegate, Looper x0, AudioManager audioManager) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private final void $$robo$$android_media_AudioManager_FocusEventHandlerDelegate_1$handleMessage(Message msg) {
                    OnAudioFocusChangeListener listener = null;
                    Object object = this.this$1.this$0.mFocusListenerLock;
                    synchronized (object) {
                        listener = this.this$1.this$0.findFocusListener((String)msg.obj);
                    }
                    if (listener != null) {
                        listener.onAudioFocusChange(msg.what);
                    }
                }

                private void __constructor__(FocusEventHandlerDelegate focusEventHandlerDelegate, Looper looper, AudioManager audioManager) {
                    this.$$robo$$android_media_AudioManager_FocusEventHandlerDelegate_1$__constructor__(focusEventHandlerDelegate, looper, audioManager);
                }
                {
                    this.this$1 = focusEventHandlerDelegate;
                    this.val$this$0 = audioManager;
                    super(looper);
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioManager_FocusEventHandlerDelegate_1$__constructor__(android.media.AudioManager$FocusEventHandlerDelegate android.os.Looper android.media.AudioManager ), 0, this, focusEventHandlerDelegate, looper, audioManager);
                }

                @Override
                public void handleMessage(Message message) {
                    InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_media_AudioManager_FocusEventHandlerDelegate_1$handleMessage(android.os.Message ), 0, this, message);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            } : null;
        }

        private final Handler $$robo$$android_media_AudioManager_FocusEventHandlerDelegate$getHandler() {
            return this.mHandler;
        }

        private void __constructor__(AudioManager audioManager) {
            this.$$robo$$android_media_AudioManager_FocusEventHandlerDelegate$__constructor__(audioManager);
        }

        FocusEventHandlerDelegate(AudioManager audioManager) {
            this.this$0 = audioManager;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioManager_FocusEventHandlerDelegate$__constructor__(android.media.AudioManager ), 0, this, audioManager);
        }

        Handler getHandler() {
            return InvokeDynamicSupport.bootstrap("getHandler", $$robo$$android_media_AudioManager_FocusEventHandlerDelegate$getHandler(), 0, this);
        }

        public /* synthetic */ FocusEventHandlerDelegate() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FocusEventHandlerDelegate)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface OnAudioFocusChangeListener
    extends InstrumentedInterface {
        public void onAudioFocusChange(int var1);
    }
}

