/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.AudioAttributes;
import android.media.AudioFormat;
import android.media.AudioSystem;
import android.media.IAudioService;
import android.media.MediaRecorder;
import android.media.MediaSyncEvent;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class AudioRecord
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int STATE_UNINITIALIZED = 0;
    public static int STATE_INITIALIZED = 1;
    public static int RECORDSTATE_STOPPED = 1;
    public static int RECORDSTATE_RECORDING = 3;
    public static int SUCCESS = 0;
    public static int ERROR = -1;
    public static int ERROR_BAD_VALUE = -2;
    public static int ERROR_INVALID_OPERATION = -3;
    private static int AUDIORECORD_ERROR_SETUP_ZEROFRAMECOUNT = -16;
    private static int AUDIORECORD_ERROR_SETUP_INVALIDCHANNELMASK = -17;
    private static int AUDIORECORD_ERROR_SETUP_INVALIDFORMAT = -18;
    private static int AUDIORECORD_ERROR_SETUP_INVALIDSOURCE = -19;
    private static int AUDIORECORD_ERROR_SETUP_NATIVEINITFAILED = -20;
    private static int NATIVE_EVENT_MARKER = 2;
    private static int NATIVE_EVENT_NEW_POS = 3;
    private static String TAG = "android.media.AudioRecord";
    public static String SUBMIX_FIXED_VOLUME = "fixedVolume";
    private long mNativeRecorderInJavaObj;
    private long mNativeCallbackCookie;
    private int mSampleRate;
    private int mChannelCount;
    private int mChannelMask;
    private int mAudioFormat;
    private int mRecordSource;
    private int mState;
    private int mRecordingState;
    private Object mRecordingStateLock;
    private OnRecordPositionUpdateListener mPositionListener;
    private Object mPositionListenerLock;
    private NativeEventHandler mEventHandler;
    private Looper mInitializationLooper;
    private int mNativeBufferSizeInBytes;
    private int mSessionId;
    private AudioAttributes mAudioAttributes;
    private boolean mIsSubmixFullVolume;
    private IBinder mICallBack;

    private void $$robo$$android_media_AudioRecord$__constructor__(int audioSource, int sampleRateInHz, int channelConfig, int audioFormat, int bufferSizeInBytes) throws IllegalArgumentException {
    }

    private void $$robo$$android_media_AudioRecord$__constructor__(AudioAttributes attributes, AudioFormat format, int bufferSizeInBytes, int sessionId) throws IllegalArgumentException {
        this.mState = 0;
        this.mRecordingState = 1;
        this.mRecordingStateLock = new Object();
        this.mPositionListener = null;
        this.mPositionListenerLock = new Object();
        this.mEventHandler = null;
        this.mInitializationLooper = null;
        this.mNativeBufferSizeInBytes = 0;
        this.mSessionId = 0;
        this.mIsSubmixFullVolume = false;
        this.mICallBack = new Binder();
        this.mRecordingState = 1;
        if (attributes == null) {
            throw new IllegalArgumentException("Illegal null AudioAttributes");
        }
        if (format == null) {
            throw new IllegalArgumentException("Illegal null AudioFormat");
        }
        this.mInitializationLooper = Looper.myLooper();
        if (this.mInitializationLooper == null) {
            this.mInitializationLooper = Looper.getMainLooper();
        }
        this.mAudioAttributes = attributes;
        if (this.mAudioAttributes.getCapturePreset() == 8) {
            Iterator<String> tagsIter = this.mAudioAttributes.getTags().iterator();
            while (tagsIter.hasNext()) {
                if (!tagsIter.next().equalsIgnoreCase("fixedVolume")) continue;
                this.mIsSubmixFullVolume = true;
                Log.v("android.media.AudioRecord", "Will record from REMOTE_SUBMIX at full fixed volume");
                break;
            }
        }
        int rate = 0;
        if ((format.getPropertySetMask() & 2) != 0) {
            rate = format.getSampleRate();
        } else {
            rate = AudioSystem.getPrimaryOutputSamplingRate();
            if (rate <= 0) {
                rate = 44100;
            }
        }
        int encoding = 1;
        if ((format.getPropertySetMask() & 1) != 0) {
            encoding = format.getEncoding();
        }
        this.audioParamCheck(attributes.getCapturePreset(), rate, encoding);
        this.mChannelCount = AudioFormat.channelCountFromInChannelMask(format.getChannelMask());
        this.mChannelMask = AudioRecord.getChannelMaskFromLegacyConfig(format.getChannelMask(), false);
        this.audioBuffSizeCheck(bufferSizeInBytes);
        int[] session = new int[]{sessionId};
        int initResult = this.native_setup(new WeakReference<AudioRecord>(this), this.mAudioAttributes, this.mSampleRate, this.mChannelMask, this.mAudioFormat, this.mNativeBufferSizeInBytes, session);
        if (initResult != 0) {
            AudioRecord.loge("Error code " + initResult + " when initializing native AudioRecord object.");
            return;
        }
        this.mSessionId = session[0];
        this.mState = 1;
    }

    private static final int $$robo$$android_media_AudioRecord$getChannelMaskFromLegacyConfig(int inChannelConfig, boolean allowLegacyConfig) {
        int mask;
        switch (inChannelConfig) {
            case 1: 
            case 2: 
            case 16: {
                mask = 16;
                break;
            }
            case 3: 
            case 12: {
                mask = 12;
                break;
            }
            case 48: {
                mask = inChannelConfig;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported channel configuration.");
            }
        }
        if (!(allowLegacyConfig || inChannelConfig != 2 && inChannelConfig != 3)) {
            throw new IllegalArgumentException("Unsupported deprecated configuration.");
        }
        return mask;
    }

    private final void $$robo$$android_media_AudioRecord$audioParamCheck(int audioSource, int sampleRateInHz, int audioFormat) throws IllegalArgumentException {
        if (audioSource < 0 || audioSource > MediaRecorder.getAudioSourceMax() && audioSource != 1999) {
            throw new IllegalArgumentException("Invalid audio source.");
        }
        this.mRecordSource = audioSource;
        if (sampleRateInHz < 4000 || sampleRateInHz > 48000) {
            throw new IllegalArgumentException(sampleRateInHz + "Hz is not a supported sample rate.");
        }
        this.mSampleRate = sampleRateInHz;
        switch (audioFormat) {
            case 1: {
                this.mAudioFormat = 2;
                break;
            }
            case 2: 
            case 3: {
                this.mAudioFormat = audioFormat;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported sample encoding. Should be ENCODING_PCM_8BIT or ENCODING_PCM_16BIT.");
            }
        }
    }

    private final void $$robo$$android_media_AudioRecord$audioBuffSizeCheck(int audioBufferSize) throws IllegalArgumentException {
        int frameSizeInBytes = this.mChannelCount * AudioFormat.getBytesPerSample(this.mAudioFormat);
        if (audioBufferSize % frameSizeInBytes != 0 || audioBufferSize < 1) {
            throw new IllegalArgumentException("Invalid audio buffer size.");
        }
        this.mNativeBufferSizeInBytes = audioBufferSize;
    }

    private final void $$robo$$android_media_AudioRecord$release() {
        try {
            this.stop();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.native_release();
        this.mState = 0;
    }

    private final void $$robo$$android_media_AudioRecord$finalize() {
        this.release();
    }

    private final int $$robo$$android_media_AudioRecord$getSampleRate() {
        return this.mSampleRate;
    }

    private final int $$robo$$android_media_AudioRecord$getAudioSource() {
        return this.mRecordSource;
    }

    private final int $$robo$$android_media_AudioRecord$getAudioFormat() {
        return this.mAudioFormat;
    }

    private final int $$robo$$android_media_AudioRecord$getChannelConfiguration() {
        return this.mChannelMask;
    }

    private final int $$robo$$android_media_AudioRecord$getChannelCount() {
        return this.mChannelCount;
    }

    private final int $$robo$$android_media_AudioRecord$getState() {
        return this.mState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_media_AudioRecord$getRecordingState() {
        Object object = this.mRecordingStateLock;
        synchronized (object) {
            return this.mRecordingState;
        }
    }

    private final int $$robo$$android_media_AudioRecord$getNotificationMarkerPosition() {
        return this.native_get_marker_pos();
    }

    private final int $$robo$$android_media_AudioRecord$getPositionNotificationPeriod() {
        return this.native_get_pos_update_period();
    }

    private static final int $$robo$$android_media_AudioRecord$getMinBufferSize(int sampleRateInHz, int channelConfig, int audioFormat) {
        int channelCount = 0;
        switch (channelConfig) {
            case 1: 
            case 2: 
            case 16: {
                channelCount = 1;
                break;
            }
            case 3: 
            case 12: 
            case 48: {
                channelCount = 2;
                break;
            }
            default: {
                AudioRecord.loge("getMinBufferSize(): Invalid channel configuration.");
                return -2;
            }
        }
        if (audioFormat != 2) {
            AudioRecord.loge("getMinBufferSize(): Invalid audio format.");
            return -2;
        }
        int size = AudioRecord.native_get_min_buff_size(sampleRateInHz, channelCount, audioFormat);
        if (size == 0) {
            return -2;
        }
        if (size == -1) {
            return -1;
        }
        return size;
    }

    private final int $$robo$$android_media_AudioRecord$getAudioSessionId() {
        return this.mSessionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_AudioRecord$startRecording() throws IllegalStateException {
        if (this.mState != 1) {
            throw new IllegalStateException("startRecording() called on an uninitialized AudioRecord.");
        }
        Object object = this.mRecordingStateLock;
        synchronized (object) {
            if (this.native_start(0, 0) == 0) {
                this.handleFullVolumeRec(true);
                this.mRecordingState = 3;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_AudioRecord$startRecording(MediaSyncEvent syncEvent) throws IllegalStateException {
        if (this.mState != 1) {
            throw new IllegalStateException("startRecording() called on an uninitialized AudioRecord.");
        }
        Object object = this.mRecordingStateLock;
        synchronized (object) {
            if (this.native_start(syncEvent.getType(), syncEvent.getAudioSessionId()) == 0) {
                this.handleFullVolumeRec(true);
                this.mRecordingState = 3;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_AudioRecord$stop() throws IllegalStateException {
        if (this.mState != 1) {
            throw new IllegalStateException("stop() called on an uninitialized AudioRecord.");
        }
        Object object = this.mRecordingStateLock;
        synchronized (object) {
            this.handleFullVolumeRec(false);
            this.native_stop();
            this.mRecordingState = 1;
        }
    }

    private final void $$robo$$android_media_AudioRecord$handleFullVolumeRec(boolean starting) {
        if (!this.mIsSubmixFullVolume) {
            return;
        }
        IBinder b = ServiceManager.getService("audio");
        IAudioService ias = IAudioService.Stub.asInterface(b);
        try {
            ias.forceRemoteSubmixFullVolume(starting, this.mICallBack);
        }
        catch (RemoteException e) {
            Log.e("android.media.AudioRecord", "Error talking to AudioService when handling full submix volume", e);
        }
    }

    private final int $$robo$$android_media_AudioRecord$read(byte[] audioData, int offsetInBytes, int sizeInBytes) {
        if (this.mState != 1) {
            return -3;
        }
        if (audioData == null || offsetInBytes < 0 || sizeInBytes < 0 || offsetInBytes + sizeInBytes < 0 || offsetInBytes + sizeInBytes > audioData.length) {
            return -2;
        }
        return this.native_read_in_byte_array(audioData, offsetInBytes, sizeInBytes);
    }

    private final int $$robo$$android_media_AudioRecord$read(short[] audioData, int offsetInShorts, int sizeInShorts) {
        if (this.mState != 1) {
            return -3;
        }
        if (audioData == null || offsetInShorts < 0 || sizeInShorts < 0 || offsetInShorts + sizeInShorts < 0 || offsetInShorts + sizeInShorts > audioData.length) {
            return -2;
        }
        return this.native_read_in_short_array(audioData, offsetInShorts, sizeInShorts);
    }

    private final int $$robo$$android_media_AudioRecord$read(ByteBuffer audioBuffer, int sizeInBytes) {
        if (this.mState != 1) {
            return -3;
        }
        if (audioBuffer == null || sizeInBytes < 0) {
            return -2;
        }
        return this.native_read_in_direct_buffer(audioBuffer, sizeInBytes);
    }

    private final void $$robo$$android_media_AudioRecord$setRecordPositionUpdateListener(OnRecordPositionUpdateListener listener) {
        this.setRecordPositionUpdateListener(listener, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_AudioRecord$setRecordPositionUpdateListener(OnRecordPositionUpdateListener listener, Handler handler) {
        Object object = this.mPositionListenerLock;
        synchronized (object) {
            this.mPositionListener = listener;
            this.mEventHandler = listener != null ? (handler != null ? new NativeEventHandler(this, this, handler.getLooper()) : new NativeEventHandler(this, this, this.mInitializationLooper)) : null;
        }
    }

    private final int $$robo$$android_media_AudioRecord$setNotificationMarkerPosition(int markerInFrames) {
        if (this.mState == 0) {
            return -3;
        }
        return this.native_set_marker_pos(markerInFrames);
    }

    private final int $$robo$$android_media_AudioRecord$setPositionNotificationPeriod(int periodInFrames) {
        if (this.mState == 0) {
            return -3;
        }
        return this.native_set_pos_update_period(periodInFrames);
    }

    private static final void $$robo$$android_media_AudioRecord$postEventFromNative(Object audiorecord_ref, int what, int arg1, int arg2, Object obj) {
        AudioRecord recorder = (AudioRecord)((WeakReference)audiorecord_ref).get();
        if (recorder == null) {
            return;
        }
        if (recorder.mEventHandler != null) {
            Message m = recorder.mEventHandler.obtainMessage(what, arg1, arg2, obj);
            recorder.mEventHandler.sendMessage(m);
        }
    }

    private final int $$robo$$android_media_AudioRecord$native_setup(Object object, Object object2, int n, int n2, int n3, int n4, int[] nArray) {
        return 0;
    }

    private final void $$robo$$android_media_AudioRecord$native_finalize() {
    }

    private final void $$robo$$android_media_AudioRecord$native_release() {
    }

    private final int $$robo$$android_media_AudioRecord$native_start(int n, int n2) {
        return 0;
    }

    private final void $$robo$$android_media_AudioRecord$native_stop() {
    }

    private final int $$robo$$android_media_AudioRecord$native_read_in_byte_array(byte[] byArray, int n, int n2) {
        return 0;
    }

    private final int $$robo$$android_media_AudioRecord$native_read_in_short_array(short[] sArray, int n, int n2) {
        return 0;
    }

    private final int $$robo$$android_media_AudioRecord$native_read_in_direct_buffer(Object object, int n) {
        return 0;
    }

    private final int $$robo$$android_media_AudioRecord$native_set_marker_pos(int n) {
        return 0;
    }

    private final int $$robo$$android_media_AudioRecord$native_get_marker_pos() {
        return 0;
    }

    private final int $$robo$$android_media_AudioRecord$native_set_pos_update_period(int n) {
        return 0;
    }

    private final int $$robo$$android_media_AudioRecord$native_get_pos_update_period() {
        return 0;
    }

    private static final int $$robo$$android_media_AudioRecord$native_get_min_buff_size(int n, int n2, int n3) {
        return 0;
    }

    private static final void $$robo$$android_media_AudioRecord$logd(String msg) {
        Log.d("android.media.AudioRecord", msg);
    }

    private static final void $$robo$$android_media_AudioRecord$loge(String msg) {
        Log.e("android.media.AudioRecord", msg);
    }

    private void __constructor__(int n, int n2, int n3, int n4, int n5) throws IllegalArgumentException {
        this.$$robo$$android_media_AudioRecord$__constructor__(n, n2, n3, n4, n5);
    }

    public AudioRecord(int n, int n2, int n3, int n4, int n5) throws IllegalArgumentException {
        this(new AudioAttributes.Builder().setInternalCapturePreset(n).build(), new AudioFormat.Builder().setChannelMask(AudioRecord.getChannelMaskFromLegacyConfig(n3, true)).setEncoding(n4).setSampleRate(n2).build(), n5, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioRecord$__constructor__(int int int int int ), 0, this, n, n2, n3, n4, n5);
    }

    private void __constructor__(AudioAttributes audioAttributes, AudioFormat audioFormat, int n, int n2) throws IllegalArgumentException {
        this.$$robo$$android_media_AudioRecord$__constructor__(audioAttributes, audioFormat, n, n2);
    }

    public AudioRecord(AudioAttributes audioAttributes, AudioFormat audioFormat, int n, int n2) throws IllegalArgumentException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioRecord$__constructor__(android.media.AudioAttributes android.media.AudioFormat int int ), 0, this, audioAttributes, audioFormat, n, n2);
    }

    private static int getChannelMaskFromLegacyConfig(int n, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getChannelMaskFromLegacyConfig", $$robo$$android_media_AudioRecord$getChannelMaskFromLegacyConfig(int boolean ), 0, (int)n, (boolean)bl);
    }

    private void audioParamCheck(int n, int n2, int n3) throws IllegalArgumentException {
        InvokeDynamicSupport.bootstrap("audioParamCheck", $$robo$$android_media_AudioRecord$audioParamCheck(int int int ), 0, this, n, n2, n3);
    }

    private void audioBuffSizeCheck(int n) throws IllegalArgumentException {
        InvokeDynamicSupport.bootstrap("audioBuffSizeCheck", $$robo$$android_media_AudioRecord$audioBuffSizeCheck(int ), 0, this, n);
    }

    public void release() {
        InvokeDynamicSupport.bootstrap("release", $$robo$$android_media_AudioRecord$release(), 0, this);
    }

    protected void finalize() {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_media_AudioRecord$finalize(), 0, this);
    }

    public int getSampleRate() {
        return (int)InvokeDynamicSupport.bootstrap("getSampleRate", $$robo$$android_media_AudioRecord$getSampleRate(), 0, this);
    }

    public int getAudioSource() {
        return (int)InvokeDynamicSupport.bootstrap("getAudioSource", $$robo$$android_media_AudioRecord$getAudioSource(), 0, this);
    }

    public int getAudioFormat() {
        return (int)InvokeDynamicSupport.bootstrap("getAudioFormat", $$robo$$android_media_AudioRecord$getAudioFormat(), 0, this);
    }

    public int getChannelConfiguration() {
        return (int)InvokeDynamicSupport.bootstrap("getChannelConfiguration", $$robo$$android_media_AudioRecord$getChannelConfiguration(), 0, this);
    }

    public int getChannelCount() {
        return (int)InvokeDynamicSupport.bootstrap("getChannelCount", $$robo$$android_media_AudioRecord$getChannelCount(), 0, this);
    }

    public int getState() {
        return (int)InvokeDynamicSupport.bootstrap("getState", $$robo$$android_media_AudioRecord$getState(), 0, this);
    }

    public int getRecordingState() {
        return (int)InvokeDynamicSupport.bootstrap("getRecordingState", $$robo$$android_media_AudioRecord$getRecordingState(), 0, this);
    }

    public int getNotificationMarkerPosition() {
        return (int)InvokeDynamicSupport.bootstrap("getNotificationMarkerPosition", $$robo$$android_media_AudioRecord$getNotificationMarkerPosition(), 0, this);
    }

    public int getPositionNotificationPeriod() {
        return (int)InvokeDynamicSupport.bootstrap("getPositionNotificationPeriod", $$robo$$android_media_AudioRecord$getPositionNotificationPeriod(), 0, this);
    }

    public static int getMinBufferSize(int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getMinBufferSize", $$robo$$android_media_AudioRecord$getMinBufferSize(int int int ), 0, (int)n, (int)n2, (int)n3);
    }

    public int getAudioSessionId() {
        return (int)InvokeDynamicSupport.bootstrap("getAudioSessionId", $$robo$$android_media_AudioRecord$getAudioSessionId(), 0, this);
    }

    public void startRecording() throws IllegalStateException {
        InvokeDynamicSupport.bootstrap("startRecording", $$robo$$android_media_AudioRecord$startRecording(), 0, this);
    }

    public void startRecording(MediaSyncEvent mediaSyncEvent) throws IllegalStateException {
        InvokeDynamicSupport.bootstrap("startRecording", $$robo$$android_media_AudioRecord$startRecording(android.media.MediaSyncEvent ), 0, this, mediaSyncEvent);
    }

    public void stop() throws IllegalStateException {
        InvokeDynamicSupport.bootstrap("stop", $$robo$$android_media_AudioRecord$stop(), 0, this);
    }

    private void handleFullVolumeRec(boolean bl) {
        InvokeDynamicSupport.bootstrap("handleFullVolumeRec", $$robo$$android_media_AudioRecord$handleFullVolumeRec(boolean ), 0, this, bl);
    }

    public int read(byte[] byArray, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("read", $$robo$$android_media_AudioRecord$read(byte[] int int ), 0, this, byArray, n, n2);
    }

    public int read(short[] sArray, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("read", $$robo$$android_media_AudioRecord$read(short[] int int ), 0, this, sArray, n, n2);
    }

    public int read(ByteBuffer byteBuffer, int n) {
        return (int)InvokeDynamicSupport.bootstrap("read", $$robo$$android_media_AudioRecord$read(java.nio.ByteBuffer int ), 0, this, byteBuffer, n);
    }

    public void setRecordPositionUpdateListener(OnRecordPositionUpdateListener onRecordPositionUpdateListener) {
        InvokeDynamicSupport.bootstrap("setRecordPositionUpdateListener", $$robo$$android_media_AudioRecord$setRecordPositionUpdateListener(android.media.AudioRecord$OnRecordPositionUpdateListener ), 0, this, onRecordPositionUpdateListener);
    }

    public void setRecordPositionUpdateListener(OnRecordPositionUpdateListener onRecordPositionUpdateListener, Handler handler) {
        InvokeDynamicSupport.bootstrap("setRecordPositionUpdateListener", $$robo$$android_media_AudioRecord$setRecordPositionUpdateListener(android.media.AudioRecord$OnRecordPositionUpdateListener android.os.Handler ), 0, this, onRecordPositionUpdateListener, handler);
    }

    public int setNotificationMarkerPosition(int n) {
        return (int)InvokeDynamicSupport.bootstrap("setNotificationMarkerPosition", $$robo$$android_media_AudioRecord$setNotificationMarkerPosition(int ), 0, this, n);
    }

    public int setPositionNotificationPeriod(int n) {
        return (int)InvokeDynamicSupport.bootstrap("setPositionNotificationPeriod", $$robo$$android_media_AudioRecord$setPositionNotificationPeriod(int ), 0, this, n);
    }

    private static void postEventFromNative(Object object, int n, int n2, int n3, Object object2) {
        InvokeDynamicSupport.bootstrapStatic("postEventFromNative", $$robo$$android_media_AudioRecord$postEventFromNative(java.lang.Object int int int java.lang.Object ), 0, (Object)object, (int)n, (int)n2, (int)n3, (Object)object2);
    }

    private final native /* synthetic */ int $$robo$$native_setup$nativeBinding(Object var1, Object var2, int var3, int var4, int var5, int var6, int[] var7);

    private int native_setup(Object object, Object object2, int n, int n2, int n3, int n4, int[] nArray) {
        return (int)InvokeDynamicSupport.bootstrap("native_setup", $$robo$$android_media_AudioRecord$native_setup(java.lang.Object java.lang.Object int int int int int[] ), 1, this, object, object2, n, n2, n3, n4, nArray);
    }

    private final native /* synthetic */ void $$robo$$native_finalize$nativeBinding();

    private void native_finalize() {
        InvokeDynamicSupport.bootstrap("native_finalize", $$robo$$android_media_AudioRecord$native_finalize(), 1, this);
    }

    private final native /* synthetic */ void $$robo$$native_release$nativeBinding();

    private void native_release() {
        InvokeDynamicSupport.bootstrap("native_release", $$robo$$android_media_AudioRecord$native_release(), 1, this);
    }

    private final native /* synthetic */ int $$robo$$native_start$nativeBinding(int var1, int var2);

    private int native_start(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("native_start", $$robo$$android_media_AudioRecord$native_start(int int ), 1, this, n, n2);
    }

    private final native /* synthetic */ void $$robo$$native_stop$nativeBinding();

    private void native_stop() {
        InvokeDynamicSupport.bootstrap("native_stop", $$robo$$android_media_AudioRecord$native_stop(), 1, this);
    }

    private final native /* synthetic */ int $$robo$$native_read_in_byte_array$nativeBinding(byte[] var1, int var2, int var3);

    private int native_read_in_byte_array(byte[] byArray, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("native_read_in_byte_array", $$robo$$android_media_AudioRecord$native_read_in_byte_array(byte[] int int ), 1, this, byArray, n, n2);
    }

    private final native /* synthetic */ int $$robo$$native_read_in_short_array$nativeBinding(short[] var1, int var2, int var3);

    private int native_read_in_short_array(short[] sArray, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("native_read_in_short_array", $$robo$$android_media_AudioRecord$native_read_in_short_array(short[] int int ), 1, this, sArray, n, n2);
    }

    private final native /* synthetic */ int $$robo$$native_read_in_direct_buffer$nativeBinding(Object var1, int var2);

    private int native_read_in_direct_buffer(Object object, int n) {
        return (int)InvokeDynamicSupport.bootstrap("native_read_in_direct_buffer", $$robo$$android_media_AudioRecord$native_read_in_direct_buffer(java.lang.Object int ), 1, this, object, n);
    }

    private final native /* synthetic */ int $$robo$$native_set_marker_pos$nativeBinding(int var1);

    private int native_set_marker_pos(int n) {
        return (int)InvokeDynamicSupport.bootstrap("native_set_marker_pos", $$robo$$android_media_AudioRecord$native_set_marker_pos(int ), 1, this, n);
    }

    private final native /* synthetic */ int $$robo$$native_get_marker_pos$nativeBinding();

    private int native_get_marker_pos() {
        return (int)InvokeDynamicSupport.bootstrap("native_get_marker_pos", $$robo$$android_media_AudioRecord$native_get_marker_pos(), 1, this);
    }

    private final native /* synthetic */ int $$robo$$native_set_pos_update_period$nativeBinding(int var1);

    private int native_set_pos_update_period(int n) {
        return (int)InvokeDynamicSupport.bootstrap("native_set_pos_update_period", $$robo$$android_media_AudioRecord$native_set_pos_update_period(int ), 1, this, n);
    }

    private final native /* synthetic */ int $$robo$$native_get_pos_update_period$nativeBinding();

    private int native_get_pos_update_period() {
        return (int)InvokeDynamicSupport.bootstrap("native_get_pos_update_period", $$robo$$android_media_AudioRecord$native_get_pos_update_period(), 1, this);
    }

    private static final native /* synthetic */ int $$robo$$native_get_min_buff_size$nativeBinding(int var0, int var1, int var2);

    private static int native_get_min_buff_size(int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrapStatic("native_get_min_buff_size", $$robo$$android_media_AudioRecord$native_get_min_buff_size(int int int ), 1, (int)n, (int)n2, (int)n3);
    }

    private static void logd(String string2) {
        InvokeDynamicSupport.bootstrapStatic("logd", $$robo$$android_media_AudioRecord$logd(java.lang.String ), 0, (String)string2);
    }

    private static void loge(String string2) {
        InvokeDynamicSupport.bootstrapStatic("loge", $$robo$$android_media_AudioRecord$loge(java.lang.String ), 0, (String)string2);
    }

    public /* synthetic */ AudioRecord() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AudioRecord)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class NativeEventHandler
    extends Handler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private AudioRecord mAudioRecord;
        /* synthetic */ AudioRecord this$0;

        private void $$robo$$android_media_AudioRecord_NativeEventHandler$__constructor__(AudioRecord audioRecord, AudioRecord recorder, Looper looper) {
            this.mAudioRecord = recorder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_AudioRecord_NativeEventHandler$handleMessage(Message msg) {
            OnRecordPositionUpdateListener listener = null;
            Object object = this.this$0.mPositionListenerLock;
            synchronized (object) {
                listener = this.mAudioRecord.mPositionListener;
            }
            switch (msg.what) {
                case 2: {
                    if (listener == null) break;
                    listener.onMarkerReached(this.mAudioRecord);
                    break;
                }
                case 3: {
                    if (listener == null) break;
                    listener.onPeriodicNotification(this.mAudioRecord);
                    break;
                }
                default: {
                    AudioRecord.loge("Unknown native event type: " + msg.what);
                }
            }
        }

        private void __constructor__(AudioRecord audioRecord, AudioRecord audioRecord2, Looper looper) {
            this.$$robo$$android_media_AudioRecord_NativeEventHandler$__constructor__(audioRecord, audioRecord2, looper);
        }

        NativeEventHandler(AudioRecord audioRecord, AudioRecord audioRecord2, Looper looper) {
            this.this$0 = audioRecord;
            super(looper);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioRecord_NativeEventHandler$__constructor__(android.media.AudioRecord android.media.AudioRecord android.os.Looper ), 0, this, audioRecord, audioRecord2, looper);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_media_AudioRecord_NativeEventHandler$handleMessage(android.os.Message ), 0, this, message);
        }

        public /* synthetic */ NativeEventHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NativeEventHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface OnRecordPositionUpdateListener
    extends InstrumentedInterface {
        public void onMarkerReached(AudioRecord var1);

        public void onPeriodicNotification(AudioRecord var1);
    }
}

