/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.app.ActivityManager;
import android.app.ActivityManagerNative;
import android.app.AppOpsManager;
import android.app.KeyguardManager;
import android.bluetooth.BluetoothA2dp;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothClass;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHeadset;
import android.bluetooth.BluetoothProfile;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.database.ContentObserver;
import android.hardware.hdmi.HdmiControlManager;
import android.hardware.hdmi.HdmiPlaybackClient;
import android.hardware.hdmi.HdmiTvClient;
import android.media.AudioAttributes;
import android.media.AudioDevicePort;
import android.media.AudioFormat;
import android.media.AudioManager;
import android.media.AudioManagerInternal;
import android.media.AudioPort;
import android.media.AudioRoutesInfo;
import android.media.AudioSystem;
import android.media.IAudioFocusDispatcher;
import android.media.IAudioRoutesObserver;
import android.media.IAudioService;
import android.media.IRemoteControlDisplay;
import android.media.IRingtonePlayer;
import android.media.IVolumeController;
import android.media.MediaFocusControl;
import android.media.MediaPlayer;
import android.media.SoundPool;
import android.media.audiopolicy.AudioPolicyConfig;
import android.os.Binder;
import android.os.Environment;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.Vibrator;
import android.provider.Settings;
import android.telecom.TelecomManager;
import android.text.TextUtils;
import android.util.Log;
import android.util.MathUtils;
import android.util.Slog;
import android.view.OrientationEventListener;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityManager;
import com.android.internal.util.XmlUtils;
import com.android.server.LocalServices;
import com.google.errorprone.annotations.DoNotMock;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParserException;

public class AudioService
extends IAudioService.Stub
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "AudioService";
    protected static boolean DEBUG_MODE;
    protected static boolean DEBUG_VOL;
    private static boolean DEBUG_SESSIONS;
    private static boolean VOLUME_SETS_RINGER_MODE_SILENT = false;
    private static boolean PREVENT_VOLUME_ADJUSTMENT_IF_SILENT = true;
    private static int PERSIST_DELAY = 500;
    public static int PLAY_SOUND_DELAY = 300;
    private static int FLAG_ADJUST_VOLUME = 1;
    private Context mContext;
    private ContentResolver mContentResolver;
    private AppOpsManager mAppOps;
    private static int PLATFORM_DEFAULT = 0;
    private static int PLATFORM_VOICE = 1;
    private static int PLATFORM_TELEVISION = 2;
    private int mPlatformType;
    private VolumeController mVolumeController;
    private static int SENDMSG_REPLACE = 0;
    private static int SENDMSG_NOOP = 1;
    private static int SENDMSG_QUEUE = 2;
    private static int MSG_SET_DEVICE_VOLUME = 0;
    private static int MSG_PERSIST_VOLUME = 1;
    private static int MSG_PERSIST_MASTER_VOLUME = 2;
    private static int MSG_PERSIST_RINGER_MODE = 3;
    private static int MSG_MEDIA_SERVER_DIED = 4;
    private static int MSG_PLAY_SOUND_EFFECT = 5;
    private static int MSG_BTA2DP_DOCK_TIMEOUT = 6;
    private static int MSG_LOAD_SOUND_EFFECTS = 7;
    private static int MSG_SET_FORCE_USE = 8;
    private static int MSG_BT_HEADSET_CNCT_FAILED = 9;
    private static int MSG_SET_ALL_VOLUMES = 10;
    private static int MSG_PERSIST_MASTER_VOLUME_MUTE = 11;
    private static int MSG_REPORT_NEW_ROUTES = 12;
    private static int MSG_SET_FORCE_BT_A2DP_USE = 13;
    private static int MSG_CHECK_MUSIC_ACTIVE = 14;
    private static int MSG_BROADCAST_AUDIO_BECOMING_NOISY = 15;
    private static int MSG_CONFIGURE_SAFE_MEDIA_VOLUME = 16;
    private static int MSG_CONFIGURE_SAFE_MEDIA_VOLUME_FORCED = 17;
    private static int MSG_PERSIST_SAFE_VOLUME_STATE = 18;
    private static int MSG_BROADCAST_BT_CONNECTION_STATE = 19;
    private static int MSG_UNLOAD_SOUND_EFFECTS = 20;
    private static int MSG_SYSTEM_READY = 21;
    private static int MSG_PERSIST_MUSIC_ACTIVE_MS = 22;
    private static int MSG_PERSIST_MICROPHONE_MUTE = 23;
    private static int MSG_SET_WIRED_DEVICE_CONNECTION_STATE = 100;
    private static int MSG_SET_A2DP_SRC_CONNECTION_STATE = 101;
    private static int MSG_SET_A2DP_SINK_CONNECTION_STATE = 102;
    private static int BTA2DP_DOCK_TIMEOUT_MILLIS = 8000;
    private static int BT_HEADSET_CNCT_TIMEOUT_MS = 3000;
    private AudioSystemThread mAudioSystemThread;
    private AudioHandler mAudioHandler;
    private VolumeStreamState[] mStreamStates;
    private SettingsObserver mSettingsObserver;
    private int mMode;
    private Object mSettingsLock;
    private SoundPool mSoundPool;
    private Object mSoundEffectsLock;
    private static int NUM_SOUNDPOOL_CHANNELS = 4;
    private static int MAX_MASTER_VOLUME = 100;
    private static int MAX_BATCH_VOLUME_ADJUST_STEPS = 4;
    private static String SOUND_EFFECTS_PATH = "/media/audio/ui/";
    private static List<String> SOUND_EFFECT_FILES;
    private int[][] SOUND_EFFECT_FILES_MAP;
    private static int[] MAX_STREAM_VOLUME;
    private int[] STREAM_VOLUME_ALIAS_VOICE;
    private int[] STREAM_VOLUME_ALIAS_TELEVISION;
    private int[] STREAM_VOLUME_ALIAS_DEFAULT;
    private int[] mStreamVolumeAlias;
    private static int[] STEAM_VOLUME_OPS;
    private boolean mUseFixedVolume;
    private static String[] STREAM_NAMES;
    private AudioSystem.ErrorCallback mAudioSystemCallback;
    private int mRingerMode;
    private int mRingerModeAffectedStreams;
    private int mRingerModeMutedStreams;
    private int mMuteAffectedStreams;
    private int mVibrateSetting;
    private boolean mHasVibrator;
    private BroadcastReceiver mReceiver;
    private HashMap<Integer, String> mConnectedDevices;
    private int mForcedUseForComm;
    private boolean mUseMasterVolume;
    private int[] mMasterVolumeRamp;
    private ArrayList<SetModeDeathHandler> mSetModeDeathHandlers;
    private ArrayList<ScoClient> mScoClients;
    private BluetoothHeadset mBluetoothHeadset;
    private BluetoothDevice mBluetoothHeadsetDevice;
    private int mScoAudioState;
    private static int SCO_STATE_INACTIVE = 0;
    private static int SCO_STATE_ACTIVATE_REQ = 1;
    private static int SCO_STATE_ACTIVE_INTERNAL = 3;
    private static int SCO_STATE_DEACTIVATE_REQ = 5;
    private static int SCO_STATE_ACTIVE_EXTERNAL = 2;
    private static int SCO_STATE_DEACTIVATE_EXT_REQ = 4;
    private int mScoAudioMode;
    private static int SCO_MODE_UNDEFINED = -1;
    private static int SCO_MODE_VIRTUAL_CALL = 0;
    private static int SCO_MODE_RAW = 1;
    private static int SCO_MODE_VR = 2;
    private static int SCO_MODE_MAX = 2;
    private int mScoConnectionState;
    private boolean mSystemReady;
    private SoundPoolCallback mSoundPoolCallBack;
    private SoundPoolListenerThread mSoundPoolListenerThread;
    private Looper mSoundPoolLooper;
    private static int sSoundEffectVolumeDb;
    private int mPrevVolDirection;
    private KeyguardManager mKeyguardManager;
    private int mVolumeControlStream;
    private Object mForceControlStreamLock;
    private ForceControlStreamClient mForceControlStreamClient;
    private volatile IRingtonePlayer mRingtonePlayer;
    private int mDeviceOrientation;
    private int mDeviceRotation;
    private boolean mBluetoothA2dpEnabled;
    private Object mBluetoothA2dpEnabledLock;
    AudioRoutesInfo mCurAudioRoutes;
    RemoteCallbackList<IAudioRoutesObserver> mRoutesObservers;
    int mFixedVolumeDevices;
    int mFullVolumeDevices;
    private boolean mMonitorOrientation;
    private boolean mMonitorRotation;
    private boolean mDockAudioMediaEnabled;
    private int mDockState;
    private StreamVolumeCommand mPendingVolumeCommand;
    private PowerManager.WakeLock mAudioEventWakeLock;
    private MediaFocusControl mMediaFocusControl;
    private BluetoothA2dp mA2dp;
    private Object mA2dpAvrcpLock;
    private boolean mAvrcpAbsVolSupported;
    private AudioOrientationEventListener mOrientationListener;
    private int mRmtSbmxFullVolRefCount;
    private ArrayList<RmtSbmxFullVolDeathHandler> mRmtSbmxFullVolDeathHandlers;
    private static String TAG_AUDIO_ASSETS = "audio_assets";
    private static String ATTR_VERSION = "version";
    private static String TAG_GROUP = "group";
    private static String ATTR_GROUP_NAME = "name";
    private static String TAG_ASSET = "asset";
    private static String ATTR_ASSET_ID = "id";
    private static String ATTR_ASSET_FILE = "file";
    private static String ASSET_FILE_VERSION = "1.0";
    private static String GROUP_TOUCH_SOUNDS = "touch_sounds";
    private static int SOUND_EFFECTS_LOAD_TIMEOUT_MS = 5000;
    private BluetoothProfile.ServiceListener mBluetoothProfileServiceListener;
    int mBecomingNoisyIntentDevices;
    private String mDockAddress;
    private static int SAFE_MEDIA_VOLUME_NOT_CONFIGURED = 0;
    private static int SAFE_MEDIA_VOLUME_DISABLED = 1;
    private static int SAFE_MEDIA_VOLUME_INACTIVE = 2;
    private static int SAFE_MEDIA_VOLUME_ACTIVE = 3;
    private Integer mSafeMediaVolumeState;
    private int mMcc;
    private int mSafeMediaVolumeIndex;
    private int mSafeMediaVolumeDevices = 12;
    private int mMusicActiveMs;
    private static int UNSAFE_VOLUME_MUSIC_ACTIVE_MS_MAX = 72000000;
    private static int MUSIC_ACTIVE_POLL_PERIOD_MS = 60000;
    private static int SAFE_VOLUME_CONFIGURE_TIMEOUT_MS = 30000;
    private boolean mHdmiSystemAudioSupported;
    private HdmiTvClient mHdmiTvClient;
    private HdmiControlManager mHdmiManager;
    private HdmiPlaybackClient mHdmiPlaybackClient;
    private boolean mHdmiCecSink;
    private MyDisplayStatusCallback mHdmiDisplayStatusCallback;
    private Boolean mCameraSoundForced;
    private static String[] RINGER_MODE_NAMES;
    private HashMap<IBinder, AudioPolicyProxy> mAudioPolicies;

    private final boolean $$robo$$android_media_AudioService$isPlatformVoice() {
        return this.mPlatformType == 1;
    }

    private final boolean $$robo$$android_media_AudioService$isPlatformTelevision() {
        return this.mPlatformType == 2;
    }

    private void $$robo$$android_media_AudioService$__constructor__(Context context) {
        this.mVolumeController = new VolumeController();
        this.mMode = 0;
        this.mSettingsLock = new Object();
        this.mSoundEffectsLock = new Object();
        this.SOUND_EFFECT_FILES_MAP = new int[10][2];
        this.STREAM_VOLUME_ALIAS_VOICE = new int[]{0, 2, 2, 3, 4, 2, 6, 2, 2, 3};
        this.STREAM_VOLUME_ALIAS_TELEVISION = new int[]{3, 3, 3, 3, 3, 3, 3, 3, 3, 3};
        this.STREAM_VOLUME_ALIAS_DEFAULT = new int[]{0, 2, 2, 3, 4, 2, 6, 2, 2, 3};
        this.mAudioSystemCallback = new AudioSystem.ErrorCallback(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ AudioService this$0;

            private void $$robo$$android_media_AudioService_1$__constructor__(AudioService audioService) {
            }

            private final void $$robo$$android_media_AudioService_1$onError(int error) {
                switch (error) {
                    case 100: {
                        AudioService.sendMsg(this.this$0.mAudioHandler, 4, 1, 0, 0, null, 0);
                        break;
                    }
                }
            }

            private void __constructor__(AudioService audioService) {
                this.$$robo$$android_media_AudioService_1$__constructor__(audioService);
            }
            {
                this.this$0 = audioService;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioService_1$__constructor__(android.media.AudioService ), 0, this, audioService);
            }

            @Override
            public void onError(int n) {
                InvokeDynamicSupport.bootstrap("onError", $$robo$$android_media_AudioService_1$onError(int ), 0, this, n);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mRingerModeAffectedStreams = 0;
        this.mReceiver = new AudioServiceBroadcastReceiver(this);
        this.mConnectedDevices = new HashMap();
        this.mSetModeDeathHandlers = new ArrayList();
        this.mScoClients = new ArrayList();
        this.mSoundPoolLooper = null;
        this.mPrevVolDirection = 0;
        this.mVolumeControlStream = -1;
        this.mForceControlStreamLock = new Object();
        this.mForceControlStreamClient = null;
        this.mDeviceOrientation = 0;
        this.mDeviceRotation = 0;
        this.mBluetoothA2dpEnabledLock = new Object();
        this.mCurAudioRoutes = new AudioRoutesInfo();
        this.mRoutesObservers = new RemoteCallbackList();
        this.mFixedVolumeDevices = 2890752;
        this.mFullVolumeDevices = 0;
        this.mDockAudioMediaEnabled = true;
        this.mDockState = 0;
        this.mA2dpAvrcpLock = new Object();
        this.mAvrcpAbsVolSupported = false;
        this.mRmtSbmxFullVolRefCount = 0;
        this.mRmtSbmxFullVolDeathHandlers = new ArrayList();
        this.mBluetoothProfileServiceListener = new BluetoothProfile.ServiceListener(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ AudioService this$0;

            private void $$robo$$android_media_AudioService_2$__constructor__(AudioService audioService) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_media_AudioService_2$onServiceConnected(int profile, BluetoothProfile proxy) {
                switch (profile) {
                    case 2: {
                        Object object = this.this$0.mA2dpAvrcpLock;
                        synchronized (object) {
                            this.this$0.mA2dp = (BluetoothA2dp)proxy;
                            List<BluetoothDevice> deviceList = this.this$0.mA2dp.getConnectedDevices();
                            if (deviceList.size() > 0) {
                                BluetoothDevice btDevice = deviceList.get(0);
                                HashMap hashMap = this.this$0.mConnectedDevices;
                                synchronized (hashMap) {
                                    int state = this.this$0.mA2dp.getConnectionState(btDevice);
                                    int delay = this.this$0.checkSendBecomingNoisyIntent(128, state == 2 ? 1 : 0);
                                    this.this$0.queueMsgUnderWakeLock(this.this$0.mAudioHandler, 102, state, 0, btDevice, delay);
                                }
                            }
                            break;
                        }
                    }
                    case 10: {
                        List<BluetoothDevice> deviceList = proxy.getConnectedDevices();
                        if (deviceList.size() <= 0) break;
                        BluetoothDevice btDevice = deviceList.get(0);
                        HashMap hashMap = this.this$0.mConnectedDevices;
                        synchronized (hashMap) {
                            int state = proxy.getConnectionState(btDevice);
                            this.this$0.queueMsgUnderWakeLock(this.this$0.mAudioHandler, 101, state, 0, btDevice, 0);
                            break;
                        }
                    }
                    case 1: {
                        ArrayList arrayList = this.this$0.mScoClients;
                        synchronized (arrayList) {
                            this.this$0.mAudioHandler.removeMessages(9);
                            this.this$0.mBluetoothHeadset = (BluetoothHeadset)proxy;
                            List<BluetoothDevice> deviceList = this.this$0.mBluetoothHeadset.getConnectedDevices();
                            if (deviceList.size() > 0) {
                                this.this$0.mBluetoothHeadsetDevice = deviceList.get(0);
                            } else {
                                this.this$0.mBluetoothHeadsetDevice = null;
                            }
                            this.this$0.checkScoAudioState();
                            if (this.this$0.mScoAudioState == 1 || this.this$0.mScoAudioState == 5 || this.this$0.mScoAudioState == 4) {
                                boolean status = false;
                                if (this.this$0.mBluetoothHeadsetDevice != null) {
                                    switch (this.this$0.mScoAudioState) {
                                        case 1: {
                                            this.this$0.mScoAudioState = 3;
                                            if (this.this$0.mScoAudioMode == 1) {
                                                status = this.this$0.mBluetoothHeadset.connectAudio();
                                                break;
                                            }
                                            if (this.this$0.mScoAudioMode == 0) {
                                                status = this.this$0.mBluetoothHeadset.startScoUsingVirtualVoiceCall(this.this$0.mBluetoothHeadsetDevice);
                                                break;
                                            }
                                            if (this.this$0.mScoAudioMode != 2) break;
                                            status = this.this$0.mBluetoothHeadset.startVoiceRecognition(this.this$0.mBluetoothHeadsetDevice);
                                            break;
                                        }
                                        case 5: {
                                            if (this.this$0.mScoAudioMode == 1) {
                                                status = this.this$0.mBluetoothHeadset.disconnectAudio();
                                                break;
                                            }
                                            if (this.this$0.mScoAudioMode == 0) {
                                                status = this.this$0.mBluetoothHeadset.stopScoUsingVirtualVoiceCall(this.this$0.mBluetoothHeadsetDevice);
                                                break;
                                            }
                                            if (this.this$0.mScoAudioMode != 2) break;
                                            status = this.this$0.mBluetoothHeadset.stopVoiceRecognition(this.this$0.mBluetoothHeadsetDevice);
                                            break;
                                        }
                                        case 4: {
                                            status = this.this$0.mBluetoothHeadset.stopVoiceRecognition(this.this$0.mBluetoothHeadsetDevice);
                                        }
                                    }
                                }
                                if (!status) {
                                    AudioService.sendMsg(this.this$0.mAudioHandler, 9, 0, 0, 0, null, 0);
                                }
                            }
                            break;
                        }
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_media_AudioService_2$onServiceDisconnected(int profile) {
                switch (profile) {
                    case 2: {
                        Object object = this.this$0.mA2dpAvrcpLock;
                        synchronized (object) {
                            this.this$0.mA2dp = null;
                            HashMap hashMap = this.this$0.mConnectedDevices;
                            synchronized (hashMap) {
                                if (this.this$0.mConnectedDevices.containsKey(128)) {
                                    this.this$0.makeA2dpDeviceUnavailableNow((String)this.this$0.mConnectedDevices.get(128));
                                }
                            }
                        }
                    }
                    case 10: {
                        HashMap hashMap = this.this$0.mConnectedDevices;
                        synchronized (hashMap) {
                            if (this.this$0.mConnectedDevices.containsKey(-2147352576)) {
                                this.this$0.makeA2dpSrcUnavailable((String)this.this$0.mConnectedDevices.get(-2147352576));
                            }
                            break;
                        }
                    }
                    case 1: {
                        ArrayList arrayList = this.this$0.mScoClients;
                        synchronized (arrayList) {
                            this.this$0.mBluetoothHeadset = null;
                            break;
                        }
                    }
                }
            }

            private void __constructor__(AudioService audioService) {
                this.$$robo$$android_media_AudioService_2$__constructor__(audioService);
            }
            {
                this.this$0 = audioService;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioService_2$__constructor__(android.media.AudioService ), 0, this, audioService);
            }

            @Override
            public void onServiceConnected(int n, BluetoothProfile bluetoothProfile) {
                InvokeDynamicSupport.bootstrap("onServiceConnected", $$robo$$android_media_AudioService_2$onServiceConnected(int android.bluetooth.BluetoothProfile ), 0, this, n, bluetoothProfile);
            }

            @Override
            public void onServiceDisconnected(int n) {
                InvokeDynamicSupport.bootstrap("onServiceDisconnected", $$robo$$android_media_AudioService_2$onServiceDisconnected(int ), 0, this, n);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mBecomingNoisyIntentDevices = 163724;
        this.mMcc = 0;
        this.mSafeMediaVolumeDevices = 12;
        this.mHdmiSystemAudioSupported = false;
        this.mHdmiDisplayStatusCallback = new MyDisplayStatusCallback(this);
        this.mAudioPolicies = new HashMap();
        this.mContext = context;
        this.mContentResolver = context.getContentResolver();
        this.mAppOps = (AppOpsManager)context.getSystemService("appops");
        this.mPlatformType = this.mContext.getResources().getBoolean(17956931) ? 1 : (context.getPackageManager().hasSystemFeature("android.hardware.type.television") ? 2 : 0);
        PowerManager pm = (PowerManager)context.getSystemService("power");
        this.mAudioEventWakeLock = pm.newWakeLock(1, "handleAudioEvent");
        Vibrator vibrator = (Vibrator)context.getSystemService("vibrator");
        this.mHasVibrator = vibrator == null ? false : vibrator.hasVibrator();
        AudioService.MAX_STREAM_VOLUME[0] = SystemProperties.getInt("ro.config.vc_call_vol_steps", MAX_STREAM_VOLUME[0]);
        AudioService.MAX_STREAM_VOLUME[3] = SystemProperties.getInt("ro.config.media_vol_steps", MAX_STREAM_VOLUME[3]);
        sSoundEffectVolumeDb = context.getResources().getInteger(17694724);
        this.mForcedUseForComm = 0;
        this.createAudioSystemThread();
        this.mMediaFocusControl = new MediaFocusControl(this.mAudioHandler.getLooper(), this.mContext, this.mVolumeController, this);
        AudioSystem.setErrorCallback(this.mAudioSystemCallback);
        boolean cameraSoundForced = this.mContext.getResources().getBoolean(17956963);
        this.mCameraSoundForced = new Boolean(cameraSoundForced);
        AudioService.sendMsg(this.mAudioHandler, 8, 2, 4, cameraSoundForced ? 11 : 0, null, 0);
        this.mSafeMediaVolumeState = new Integer(Settings.Global.getInt(this.mContentResolver, "audio_safe_volume_state", 0));
        this.mSafeMediaVolumeIndex = this.mContext.getResources().getInteger(17694831) * 10;
        this.mUseFixedVolume = this.mContext.getResources().getBoolean(17956968);
        this.updateStreamVolumeAlias(false);
        this.readPersistedSettings();
        this.mSettingsObserver = new SettingsObserver(this);
        this.createStreamStates();
        AudioService.readAndSetLowRamDevice();
        this.mRingerModeMutedStreams = 0;
        this.setRingerModeInt(this.getRingerMode(), false);
        IntentFilter intentFilter = new IntentFilter("android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED");
        intentFilter.addAction("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED");
        intentFilter.addAction("android.intent.action.DOCK_EVENT");
        intentFilter.addAction("android.media.action.USB_AUDIO_ACCESSORY_PLUG");
        intentFilter.addAction("android.media.action.USB_AUDIO_DEVICE_PLUG");
        intentFilter.addAction("android.intent.action.SCREEN_ON");
        intentFilter.addAction("android.intent.action.SCREEN_OFF");
        intentFilter.addAction("android.intent.action.USER_SWITCHED");
        intentFilter.addAction("android.hardware.usb.action.USB_DEVICE_ATTACHED");
        intentFilter.addAction("android.intent.action.CONFIGURATION_CHANGED");
        this.mMonitorOrientation = SystemProperties.getBoolean("ro.audio.monitorOrientation", false);
        if (this.mMonitorOrientation) {
            Log.v("AudioService", "monitoring device orientation");
            this.setOrientationForAudioSystem();
        }
        this.mMonitorRotation = SystemProperties.getBoolean("ro.audio.monitorRotation", false);
        if (this.mMonitorRotation) {
            this.mDeviceRotation = ((WindowManager)this.mContext.getSystemService("window")).getDefaultDisplay().getRotation();
            Log.v("AudioService", "monitoring device rotation, initial=" + this.mDeviceRotation);
            this.mOrientationListener = new AudioOrientationEventListener(this, this.mContext);
            this.mOrientationListener.enable();
            this.setRotationForAudioSystem();
        }
        context.registerReceiver(this.mReceiver, intentFilter);
        this.mUseMasterVolume = context.getResources().getBoolean(0x1120010);
        this.restoreMasterVolume();
        this.mMasterVolumeRamp = context.getResources().getIntArray(17235979);
        LocalServices.addService(AudioManagerInternal.class, new AudioServiceInternal(this));
    }

    private final void $$robo$$android_media_AudioService$systemReady() {
        AudioService.sendMsg(this.mAudioHandler, 21, 2, 0, 0, null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_AudioService$onSystemReady() {
        this.mSystemReady = true;
        AudioService.sendMsg(this.mAudioHandler, 7, 2, 0, 0, null, 0);
        this.mKeyguardManager = (KeyguardManager)this.mContext.getSystemService("keyguard");
        this.mScoConnectionState = -1;
        this.resetBluetoothSco();
        this.getBluetoothHeadset();
        Intent newIntent = new Intent("android.media.SCO_AUDIO_STATE_CHANGED");
        newIntent.putExtra("android.media.extra.SCO_AUDIO_STATE", 0);
        this.sendStickyBroadcastToAll(newIntent);
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (adapter != null) {
            adapter.getProfileProxy(this.mContext, this.mBluetoothProfileServiceListener, 2);
        }
        this.mHdmiManager = (HdmiControlManager)this.mContext.getSystemService("hdmi_control");
        if (this.mHdmiManager != null) {
            HdmiControlManager hdmiControlManager = this.mHdmiManager;
            synchronized (hdmiControlManager) {
                this.mHdmiTvClient = this.mHdmiManager.getTvClient();
                if (this.mHdmiTvClient != null) {
                    this.mFixedVolumeDevices &= 0xFFD3FFFD;
                }
                this.mHdmiPlaybackClient = this.mHdmiManager.getPlaybackClient();
                this.mHdmiCecSink = false;
            }
        }
        AudioService.sendMsg(this.mAudioHandler, 17, 0, 0, 0, null, 30000);
        StreamOverride.init(this.mContext);
    }

    private final void $$robo$$android_media_AudioService$createAudioSystemThread() {
        this.mAudioSystemThread = new AudioSystemThread(this);
        this.mAudioSystemThread.start();
        this.waitForAudioHandlerCreation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_AudioService$waitForAudioHandlerCreation() {
        AudioService audioService = this;
        synchronized (audioService) {
            while (this.mAudioHandler == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Log.e("AudioService", "Interrupted while waiting on volume handler.");
                }
            }
        }
    }

    private final void $$robo$$android_media_AudioService$checkAllAliasStreamVolumes() {
        int numStreamTypes = AudioSystem.getNumStreamTypes();
        for (int streamType = 0; streamType < numStreamTypes; ++streamType) {
            if (streamType != this.mStreamVolumeAlias[streamType]) {
                this.mStreamStates[streamType].setAllIndexes(this.mStreamStates[this.mStreamVolumeAlias[streamType]]);
            }
            if (this.mStreamStates[streamType].isMuted()) continue;
            this.mStreamStates[streamType].applyAllVolumes();
        }
    }

    private final void $$robo$$android_media_AudioService$checkAllFixedVolumeDevices() {
        int numStreamTypes = AudioSystem.getNumStreamTypes();
        for (int streamType = 0; streamType < numStreamTypes; ++streamType) {
            this.mStreamStates[streamType].checkFixedVolumeDevices();
        }
    }

    private final void $$robo$$android_media_AudioService$checkAllFixedVolumeDevices(int streamType) {
        this.mStreamStates[streamType].checkFixedVolumeDevices();
    }

    private final void $$robo$$android_media_AudioService$createStreamStates() {
        int numStreamTypes = AudioSystem.getNumStreamTypes();
        this.mStreamStates = new VolumeStreamState[numStreamTypes];
        VolumeStreamState[] streams = this.mStreamStates;
        for (int i = 0; i < numStreamTypes; ++i) {
            streams[i] = new VolumeStreamState(this, Settings.System.VOLUME_SETTINGS[this.mStreamVolumeAlias[i]], i);
        }
        this.checkAllFixedVolumeDevices();
        this.checkAllAliasStreamVolumes();
    }

    private final void $$robo$$android_media_AudioService$dumpStreamStates(PrintWriter pw) {
        pw.println("\nStream volumes (device: index)");
        int numStreamTypes = AudioSystem.getNumStreamTypes();
        for (int i = 0; i < numStreamTypes; ++i) {
            pw.println("- " + STREAM_NAMES[i] + ":");
            this.mStreamStates[i].dump(pw);
            pw.println("");
        }
        pw.print("\n- mute affected streams = 0x");
        pw.println(Integer.toHexString(this.mMuteAffectedStreams));
    }

    private static final String $$robo$$android_media_AudioService$streamToString(int stream) {
        if (stream >= 0 && stream < STREAM_NAMES.length) {
            return STREAM_NAMES[stream];
        }
        if (stream == Integer.MIN_VALUE) {
            return "USE_DEFAULT_STREAM_TYPE";
        }
        return "UNKNOWN_STREAM_" + stream;
    }

    private final void $$robo$$android_media_AudioService$updateStreamVolumeAlias(boolean updateVolumes) {
        int dtmfStreamAlias;
        switch (this.mPlatformType) {
            case 1: {
                this.mStreamVolumeAlias = this.STREAM_VOLUME_ALIAS_VOICE;
                dtmfStreamAlias = 2;
                break;
            }
            case 2: {
                this.mStreamVolumeAlias = this.STREAM_VOLUME_ALIAS_TELEVISION;
                dtmfStreamAlias = 3;
                break;
            }
            default: {
                this.mStreamVolumeAlias = this.STREAM_VOLUME_ALIAS_DEFAULT;
                dtmfStreamAlias = 3;
            }
        }
        if (this.isPlatformTelevision()) {
            this.mRingerModeAffectedStreams = 0;
        } else if (this.isInCommunication()) {
            dtmfStreamAlias = 0;
            this.mRingerModeAffectedStreams &= 0xFFFFFEFF;
        } else {
            this.mRingerModeAffectedStreams |= 0x100;
        }
        this.mStreamVolumeAlias[8] = dtmfStreamAlias;
        if (updateVolumes) {
            this.mStreamStates[8].setAllIndexes(this.mStreamStates[dtmfStreamAlias]);
            this.setRingerModeInt(this.getRingerMode(), false);
            AudioService.sendMsg(this.mAudioHandler, 10, 2, 0, 0, this.mStreamStates[8], 0);
        }
    }

    private final void $$robo$$android_media_AudioService$readDockAudioSettings(ContentResolver cr) {
        boolean bl = this.mDockAudioMediaEnabled = Settings.Global.getInt(cr, "dock_audio_media_enabled", 0) == 1;
        this.mBecomingNoisyIntentDevices = this.mDockAudioMediaEnabled ? (this.mBecomingNoisyIntentDevices |= 0x800) : (this.mBecomingNoisyIntentDevices &= 0xFFFFF7FF);
        AudioService.sendMsg(this.mAudioHandler, 8, 2, 3, this.mDockAudioMediaEnabled ? 8 : 0, null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_AudioService$readPersistedSettings() {
        boolean masterMute;
        ContentResolver cr = this.mContentResolver;
        int ringerModeFromSettings = Settings.Global.getInt(cr, "mode_ringer", 2);
        int ringerMode = ringerModeFromSettings;
        if (!AudioManager.isValidRingerMode(ringerMode)) {
            ringerMode = 2;
        }
        if (ringerMode == 1 && !this.mHasVibrator) {
            ringerMode = 0;
        }
        if (ringerMode != ringerModeFromSettings) {
            Settings.Global.putInt(cr, "mode_ringer", ringerMode);
        }
        if (this.mUseFixedVolume || this.isPlatformTelevision()) {
            ringerMode = 2;
        }
        Object object = this.mSettingsLock;
        synchronized (object) {
            this.mRingerMode = ringerMode;
            this.mVibrateSetting = AudioService.getValueForVibrateSetting(0, 1, this.mHasVibrator ? 2 : 0);
            this.mVibrateSetting = AudioService.getValueForVibrateSetting(this.mVibrateSetting, 0, this.mHasVibrator ? 2 : 0);
            this.updateRingerModeAffectedStreams();
            this.readDockAudioSettings(cr);
        }
        this.mMuteAffectedStreams = Settings.System.getIntForUser(cr, "mute_streams_affected", 14, -2);
        boolean bl = masterMute = Settings.System.getIntForUser(cr, "volume_master_mute", 0, -2) == 1;
        if (this.mUseFixedVolume) {
            masterMute = false;
            AudioSystem.setMasterVolume(1.0f);
        }
        AudioSystem.setMasterMute(masterMute);
        this.broadcastMasterMuteStatus(masterMute);
        boolean microphoneMute = Settings.System.getIntForUser(cr, "microphone_mute", 0, -2) == 1;
        AudioSystem.muteMicrophone(microphoneMute);
        this.broadcastRingerMode(ringerMode);
        this.broadcastVibrateSetting(0);
        this.broadcastVibrateSetting(1);
        this.mVolumeController.loadSettings(cr);
    }

    private final int $$robo$$android_media_AudioService$rescaleIndex(int index, int srcStream, int dstStream) {
        return (index * this.mStreamStates[dstStream].getMaxIndex() + this.mStreamStates[srcStream].getMaxIndex() / 2) / this.mStreamStates[srcStream].getMaxIndex();
    }

    private final void $$robo$$android_media_AudioService$adjustSuggestedStreamVolume(int direction, int suggestedStreamType, int flags, String callingPackage) {
        this.adjustSuggestedStreamVolume(direction, suggestedStreamType, flags, callingPackage, Binder.getCallingUid());
    }

    private final void $$robo$$android_media_AudioService$adjustSuggestedStreamVolume(int direction, int suggestedStreamType, int flags, String callingPackage, int uid) {
        if (DEBUG_VOL) {
            Log.d("AudioService", "adjustSuggestedStreamVolume() stream=" + suggestedStreamType + ", flags=" + flags);
        }
        int streamType = this.mVolumeControlStream != -1 ? this.mVolumeControlStream : this.getActiveStreamType(suggestedStreamType);
        int resolvedStream = this.mStreamVolumeAlias[streamType];
        if ((flags & 4) != 0 && resolvedStream != 2) {
            flags &= 0xFFFFFFFB;
        }
        if (this.mVolumeController.suppressAdjustment(resolvedStream, flags)) {
            direction = 0;
            flags &= 0xFFFFFFFB;
            flags &= 0xFFFFFFEF;
            if (DEBUG_VOL) {
                Log.d("AudioService", "Volume controller suppressed adjustment");
            }
        }
        this.adjustStreamVolume(streamType, direction, flags, callingPackage, uid);
    }

    private final void $$robo$$android_media_AudioService$adjustStreamVolume(int streamType, int direction, int flags, String callingPackage) {
        this.adjustStreamVolume(streamType, direction, flags, callingPackage, Binder.getCallingUid());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_AudioService$adjustStreamVolume(int streamType, int direction, int flags, String callingPackage, int uid) {
        int step;
        if (this.mUseFixedVolume) {
            return;
        }
        if (DEBUG_VOL) {
            Log.d("AudioService", "adjustStreamVolume() stream=" + streamType + ", dir=" + direction + ", flags=" + flags);
        }
        this.ensureValidDirection(direction);
        this.ensureValidStreamType(streamType);
        int streamTypeAlias = this.mStreamVolumeAlias[streamType];
        VolumeStreamState streamState = this.mStreamStates[streamTypeAlias];
        int device = this.getDeviceForStream(streamTypeAlias);
        int aliasIndex = streamState.getIndex(device);
        boolean adjustVolume = true;
        if ((device & 0x380) == 0 && (flags & 0x40) != 0) {
            return;
        }
        if (this.mAppOps.noteOp(STEAM_VOLUME_OPS[streamTypeAlias], uid, callingPackage) != 0) {
            return;
        }
        Integer n = this.mSafeMediaVolumeState;
        synchronized (n) {
            this.mPendingVolumeCommand = null;
        }
        flags &= 0xFFFFFFDF;
        if (streamTypeAlias == 3 && (device & this.mFixedVolumeDevices) != 0) {
            flags |= 0x20;
            step = this.mSafeMediaVolumeState == 3 && (device & 0xC) != 0 ? this.mSafeMediaVolumeIndex : streamState.getMaxIndex();
            if (aliasIndex != 0) {
                aliasIndex = step;
            }
        } else {
            step = this.rescaleIndex(10, streamType, streamTypeAlias);
        }
        if ((flags & 2) != 0 || streamTypeAlias == this.getMasterStreamType()) {
            int result;
            int ringerMode = this.getRingerMode();
            if (ringerMode == 1) {
                flags &= 0xFFFFFFEF;
            }
            boolean bl = adjustVolume = ((result = this.checkForRingerModeChange(aliasIndex, direction, step)) & 1) != 0;
            if ((result & 0x80) != 0) {
                flags |= 0x80;
            }
        }
        int oldIndex = this.mStreamStates[streamType].getIndex(device);
        if (adjustVolume && direction != 0) {
            if (streamTypeAlias == 3 && (device & 0x380) != 0 && (flags & 0x40) == 0) {
                Object result = this.mA2dpAvrcpLock;
                synchronized (result) {
                    if (this.mA2dp != null && this.mAvrcpAbsVolSupported) {
                        this.mA2dp.adjustAvrcpAbsoluteVolume(direction);
                    }
                }
            }
            if (direction == 1 && !this.checkSafeMediaVolume(streamTypeAlias, aliasIndex + step, device)) {
                Log.e("AudioService", "adjustStreamVolume() safe volume index = " + oldIndex);
                this.mVolumeController.postDisplaySafeVolumeWarning(flags);
            } else if (streamState.adjustIndex(direction * step, device)) {
                AudioService.sendMsg(this.mAudioHandler, 0, 2, device, 0, streamState, 0);
            }
            int newIndex = this.mStreamStates[streamType].getIndex(device);
            if (this.mHdmiManager != null) {
                HdmiControlManager hdmiControlManager = this.mHdmiManager;
                synchronized (hdmiControlManager) {
                    if (this.mHdmiTvClient != null && streamTypeAlias == 3 && (flags & 0x100) == 0 && oldIndex != newIndex) {
                        int maxIndex = this.getStreamMaxVolume(streamType);
                        HdmiTvClient hdmiTvClient = this.mHdmiTvClient;
                        synchronized (hdmiTvClient) {
                            if (this.mHdmiSystemAudioSupported) {
                                this.mHdmiTvClient.setSystemAudioVolume((oldIndex + 5) / 10, (newIndex + 5) / 10, maxIndex);
                            }
                        }
                    }
                    if (this.mHdmiCecSink && streamTypeAlias == 3 && oldIndex != newIndex) {
                        HdmiPlaybackClient hdmiPlaybackClient = this.mHdmiPlaybackClient;
                        synchronized (hdmiPlaybackClient) {
                            int keyCode = direction == -1 ? 25 : 24;
                            this.mHdmiPlaybackClient.sendKeyEvent(keyCode, true);
                            this.mHdmiPlaybackClient.sendKeyEvent(keyCode, false);
                        }
                    }
                }
            }
        }
        int index = this.mStreamStates[streamType].getIndex(device);
        this.sendVolumeUpdate(streamType, oldIndex, index, flags);
    }

    private final void $$robo$$android_media_AudioService$adjustMasterVolume(int steps, int flags, String callingPackage) {
        if (this.mUseFixedVolume) {
            return;
        }
        this.ensureValidSteps(steps);
        int volume = Math.round(AudioSystem.getMasterVolume() * 100.0f);
        int delta = 0;
        int numSteps = Math.abs(steps);
        int direction = steps > 0 ? 1 : -1;
        for (int i = 0; i < numSteps; ++i) {
            delta = this.findVolumeDelta(direction, volume);
            volume += delta;
        }
        this.setMasterVolume(volume, flags, callingPackage);
    }

    private final void $$robo$$android_media_AudioService$onSetStreamVolume(int streamType, int index, int flags, int device) {
        this.setStreamVolumeInt(this.mStreamVolumeAlias[streamType], index, device, false);
        if ((flags & 2) != 0 || this.mStreamVolumeAlias[streamType] == this.getMasterStreamType()) {
            int newRingerMode = index == 0 ? (this.mHasVibrator ? 1 : 2) : 2;
            this.setRingerMode(newRingerMode, false);
        }
    }

    private final void $$robo$$android_media_AudioService$setStreamVolume(int streamType, int index, int flags, String callingPackage) {
        this.setStreamVolume(streamType, index, flags, callingPackage, Binder.getCallingUid());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_AudioService$setStreamVolume(int streamType, int index, int flags, String callingPackage, int uid) {
        int oldIndex;
        if (this.mUseFixedVolume) {
            return;
        }
        this.ensureValidStreamType(streamType);
        int streamTypeAlias = this.mStreamVolumeAlias[streamType];
        VolumeStreamState streamState = this.mStreamStates[streamTypeAlias];
        int device = this.getDeviceForStream(streamType);
        if ((device & 0x380) == 0 && (flags & 0x40) != 0) {
            return;
        }
        if (this.mAppOps.noteOp(STEAM_VOLUME_OPS[streamTypeAlias], uid, callingPackage) != 0) {
            return;
        }
        Integer n = this.mSafeMediaVolumeState;
        synchronized (n) {
            Object object;
            this.mPendingVolumeCommand = null;
            oldIndex = streamState.getIndex(device);
            index = this.rescaleIndex(index * 10, streamType, streamTypeAlias);
            if (streamTypeAlias == 3 && (device & 0x380) != 0 && (flags & 0x40) == 0) {
                object = this.mA2dpAvrcpLock;
                synchronized (object) {
                    if (this.mA2dp != null && this.mAvrcpAbsVolSupported) {
                        this.mA2dp.setAvrcpAbsoluteVolume(index / 10);
                    }
                }
            }
            if (this.mHdmiManager != null) {
                object = this.mHdmiManager;
                synchronized (object) {
                    if (this.mHdmiTvClient != null && streamTypeAlias == 3 && (flags & 0x100) == 0 && oldIndex != index) {
                        int maxIndex = this.getStreamMaxVolume(streamType);
                        HdmiTvClient hdmiTvClient = this.mHdmiTvClient;
                        synchronized (hdmiTvClient) {
                            if (this.mHdmiSystemAudioSupported) {
                                this.mHdmiTvClient.setSystemAudioVolume((oldIndex + 5) / 10, (index + 5) / 10, maxIndex);
                            }
                        }
                    }
                }
            }
            flags &= 0xFFFFFFDF;
            if (streamTypeAlias == 3 && (device & this.mFixedVolumeDevices) != 0) {
                flags |= 0x20;
                if (index != 0) {
                    index = this.mSafeMediaVolumeState == 3 && (device & 0xC) != 0 ? this.mSafeMediaVolumeIndex : streamState.getMaxIndex();
                }
            }
            if (!this.checkSafeMediaVolume(streamTypeAlias, index, device)) {
                this.mVolumeController.postDisplaySafeVolumeWarning(flags);
                this.mPendingVolumeCommand = new StreamVolumeCommand(this, streamType, index, flags, device);
            } else {
                this.onSetStreamVolume(streamType, index, flags, device);
                index = this.mStreamStates[streamType].getIndex(device);
            }
        }
        this.sendVolumeUpdate(streamType, oldIndex, index, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_AudioService$forceVolumeControlStream(int streamType, IBinder cb) {
        Object object = this.mForceControlStreamLock;
        synchronized (object) {
            this.mVolumeControlStream = streamType;
            if (this.mVolumeControlStream == -1) {
                if (this.mForceControlStreamClient != null) {
                    this.mForceControlStreamClient.release();
                    this.mForceControlStreamClient = null;
                }
            } else {
                this.mForceControlStreamClient = new ForceControlStreamClient(this, cb);
            }
        }
    }

    private final int $$robo$$android_media_AudioService$findVolumeDelta(int direction, int volume) {
        int delta;
        block4: {
            block5: {
                delta = 0;
                if (direction != 1) break block5;
                if (volume == 100) {
                    return 0;
                }
                delta = this.mMasterVolumeRamp[1];
                for (int i = this.mMasterVolumeRamp.length - 1; i > 1; i -= 2) {
                    if (volume < this.mMasterVolumeRamp[i - 1]) continue;
                    delta = this.mMasterVolumeRamp[i];
                    break block4;
                }
                break block4;
            }
            if (direction != -1) break block4;
            if (volume == 0) {
                return 0;
            }
            int length = this.mMasterVolumeRamp.length;
            delta = -this.mMasterVolumeRamp[length - 1];
            for (int i = 2; i < length; i += 2) {
                if (volume > this.mMasterVolumeRamp[i]) continue;
                delta = -this.mMasterVolumeRamp[i - 1];
                break;
            }
        }
        return delta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_AudioService$sendBroadcastToAll(Intent intent) {
        long ident = Binder.clearCallingIdentity();
        try {
            this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_AudioService$sendStickyBroadcastToAll(Intent intent) {
        long ident = Binder.clearCallingIdentity();
        try {
            this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_AudioService$sendVolumeUpdate(int streamType, int oldIndex, int index, int flags) {
        if (!this.isPlatformVoice() && streamType == 2) {
            streamType = 5;
        }
        if (this.mHdmiTvClient != null && streamType == 3) {
            HdmiTvClient hdmiTvClient = this.mHdmiTvClient;
            synchronized (hdmiTvClient) {
                if (this.mHdmiSystemAudioSupported && (flags & 0x100) == 0) {
                    flags &= 0xFFFFFFFE;
                }
            }
        }
        this.mVolumeController.postVolumeChanged(streamType, flags);
        if ((flags & 0x20) == 0) {
            oldIndex = (oldIndex + 5) / 10;
            index = (index + 5) / 10;
            Intent intent = new Intent("android.media.VOLUME_CHANGED_ACTION");
            intent.putExtra("android.media.EXTRA_VOLUME_STREAM_TYPE", streamType);
            intent.putExtra("android.media.EXTRA_VOLUME_STREAM_VALUE", index);
            intent.putExtra("android.media.EXTRA_PREV_VOLUME_STREAM_VALUE", oldIndex);
            this.sendBroadcastToAll(intent);
        }
    }

    private final void $$robo$$android_media_AudioService$sendMasterVolumeUpdate(int flags, int oldVolume, int newVolume) {
        this.mVolumeController.postMasterVolumeChanged(flags);
        Intent intent = new Intent("android.media.MASTER_VOLUME_CHANGED_ACTION");
        intent.putExtra("android.media.EXTRA_PREV_MASTER_VOLUME_VALUE", oldVolume);
        intent.putExtra("android.media.EXTRA_MASTER_VOLUME_VALUE", newVolume);
        this.sendBroadcastToAll(intent);
    }

    private final void $$robo$$android_media_AudioService$sendMasterMuteUpdate(boolean muted, int flags) {
        this.mVolumeController.postMasterMuteChanged(flags);
        this.broadcastMasterMuteStatus(muted);
    }

    private final void $$robo$$android_media_AudioService$broadcastMasterMuteStatus(boolean muted) {
        Intent intent = new Intent("android.media.MASTER_MUTE_CHANGED_ACTION");
        intent.putExtra("android.media.EXTRA_MASTER_VOLUME_MUTED", muted);
        intent.addFlags(0x24000000);
        this.sendStickyBroadcastToAll(intent);
    }

    private final void $$robo$$android_media_AudioService$setStreamVolumeInt(int streamType, int index, int device, boolean force) {
        VolumeStreamState streamState = this.mStreamStates[streamType];
        if (streamState.setIndex(index, device) || force) {
            AudioService.sendMsg(this.mAudioHandler, 0, 2, device, 0, streamState, 0);
        }
    }

    private final void $$robo$$android_media_AudioService$setStreamSolo(int streamType, boolean state, IBinder cb) {
        if (this.mUseFixedVolume) {
            return;
        }
        for (int stream = 0; stream < this.mStreamStates.length; ++stream) {
            if (!this.isStreamAffectedByMute(stream) || stream == streamType) continue;
            this.mStreamStates[stream].mute(cb, state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_AudioService$setStreamMute(int streamType, boolean state, IBinder cb) {
        if (this.mUseFixedVolume) {
            return;
        }
        if (this.isStreamAffectedByMute(streamType)) {
            if (this.mHdmiManager != null) {
                HdmiControlManager hdmiControlManager = this.mHdmiManager;
                synchronized (hdmiControlManager) {
                    if (streamType == 3 && this.mHdmiTvClient != null) {
                        HdmiTvClient hdmiTvClient = this.mHdmiTvClient;
                        synchronized (hdmiTvClient) {
                            if (this.mHdmiSystemAudioSupported) {
                                this.mHdmiTvClient.setSystemAudioMute(state);
                            }
                        }
                    }
                }
            }
            this.mStreamStates[streamType].mute(cb, state);
        }
    }

    private final boolean $$robo$$android_media_AudioService$isStreamMute(int streamType) {
        return this.mStreamStates[streamType].isMuted();
    }

    private final boolean $$robo$$android_media_AudioService$discardRmtSbmxFullVolDeathHandlerFor(IBinder cb) {
        for (RmtSbmxFullVolDeathHandler handler : this.mRmtSbmxFullVolDeathHandlers) {
            if (!handler.isHandlerFor(cb)) continue;
            handler.forget();
            this.mRmtSbmxFullVolDeathHandlers.remove(handler);
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_media_AudioService$hasRmtSbmxFullVolDeathHandlerFor(IBinder cb) {
        Iterator<RmtSbmxFullVolDeathHandler> it = this.mRmtSbmxFullVolDeathHandlers.iterator();
        while (it.hasNext()) {
            if (!it.next().isHandlerFor(cb)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_AudioService$forceRemoteSubmixFullVolume(boolean startForcing, IBinder cb) {
        if (cb == null) {
            return;
        }
        if (0 != this.mContext.checkCallingOrSelfPermission("android.permission.CAPTURE_AUDIO_OUTPUT")) {
            Log.w("AudioService", "Trying to call forceRemoteSubmixFullVolume() without CAPTURE_AUDIO_OUTPUT");
            return;
        }
        ArrayList<RmtSbmxFullVolDeathHandler> arrayList = this.mRmtSbmxFullVolDeathHandlers;
        synchronized (arrayList) {
            boolean applyRequired = false;
            if (startForcing) {
                if (!this.hasRmtSbmxFullVolDeathHandlerFor(cb)) {
                    this.mRmtSbmxFullVolDeathHandlers.add(new RmtSbmxFullVolDeathHandler(this, cb));
                    if (this.mRmtSbmxFullVolRefCount == 0) {
                        this.mFullVolumeDevices |= 0x8000;
                        this.mFixedVolumeDevices |= 0x8000;
                        applyRequired = true;
                    }
                    ++this.mRmtSbmxFullVolRefCount;
                }
            } else if (this.discardRmtSbmxFullVolDeathHandlerFor(cb) && this.mRmtSbmxFullVolRefCount > 0) {
                --this.mRmtSbmxFullVolRefCount;
                if (this.mRmtSbmxFullVolRefCount == 0) {
                    this.mFullVolumeDevices &= 0xFFFF7FFF;
                    this.mFixedVolumeDevices &= 0xFFFF7FFF;
                    applyRequired = true;
                }
            }
            if (applyRequired) {
                this.checkAllFixedVolumeDevices(3);
                this.mStreamStates[3].applyAllVolumes();
            }
        }
    }

    private final void $$robo$$android_media_AudioService$setMasterMute(boolean state, int flags, String callingPackage, IBinder cb) {
        if (this.mUseFixedVolume) {
            return;
        }
        if (this.mAppOps.noteOp(33, Binder.getCallingUid(), callingPackage) != 0) {
            return;
        }
        if (state != AudioSystem.getMasterMute()) {
            AudioSystem.setMasterMute(state);
            AudioService.sendMsg(this.mAudioHandler, 11, 0, state ? 1 : 0, UserHandle.getCallingUserId(), null, 500);
            this.sendMasterMuteUpdate(state, flags);
        }
    }

    private final boolean $$robo$$android_media_AudioService$isMasterMute() {
        return AudioSystem.getMasterMute();
    }

    private static final int $$robo$$android_media_AudioService$getMaxStreamVolume(int streamType) {
        return MAX_STREAM_VOLUME[streamType];
    }

    private final int $$robo$$android_media_AudioService$getStreamVolume(int streamType) {
        this.ensureValidStreamType(streamType);
        int device = this.getDeviceForStream(streamType);
        int index = this.mStreamStates[streamType].getIndex(device);
        if (this.mStreamStates[streamType].isMuted()) {
            index = 0;
        }
        if (index != 0 && this.mStreamVolumeAlias[streamType] == 3 && (device & this.mFixedVolumeDevices) != 0) {
            index = this.mStreamStates[streamType].getMaxIndex();
        }
        return (index + 5) / 10;
    }

    private final int $$robo$$android_media_AudioService$getMasterVolume() {
        if (this.isMasterMute()) {
            return 0;
        }
        return this.getLastAudibleMasterVolume();
    }

    private final void $$robo$$android_media_AudioService$setMasterVolume(int volume, int flags, String callingPackage) {
        if (this.mUseFixedVolume) {
            return;
        }
        if (this.mAppOps.noteOp(33, Binder.getCallingUid(), callingPackage) != 0) {
            return;
        }
        if (volume < 0) {
            volume = 0;
        } else if (volume > 100) {
            volume = 100;
        }
        this.doSetMasterVolume((float)volume / 100.0f, flags);
    }

    private final void $$robo$$android_media_AudioService$doSetMasterVolume(float volume, int flags) {
        if (!AudioSystem.getMasterMute()) {
            int oldVolume = this.getMasterVolume();
            AudioSystem.setMasterVolume(volume);
            int newVolume = this.getMasterVolume();
            if (newVolume != oldVolume) {
                AudioService.sendMsg(this.mAudioHandler, 2, 0, Math.round(volume * 1000.0f), 0, null, 500);
            }
            this.sendMasterVolumeUpdate(flags, oldVolume, newVolume);
        }
    }

    private final int $$robo$$android_media_AudioService$getStreamMaxVolume(int streamType) {
        this.ensureValidStreamType(streamType);
        return (this.mStreamStates[streamType].getMaxIndex() + 5) / 10;
    }

    private final int $$robo$$android_media_AudioService$getMasterMaxVolume() {
        return 100;
    }

    private final int $$robo$$android_media_AudioService$getLastAudibleStreamVolume(int streamType) {
        this.ensureValidStreamType(streamType);
        int device = this.getDeviceForStream(streamType);
        return (this.mStreamStates[streamType].getIndex(device) + 5) / 10;
    }

    private final int $$robo$$android_media_AudioService$getLastAudibleMasterVolume() {
        return Math.round(AudioSystem.getMasterVolume() * 100.0f);
    }

    private final int $$robo$$android_media_AudioService$getMasterStreamType() {
        return this.mStreamVolumeAlias[1];
    }

    private final void $$robo$$android_media_AudioService$setMicrophoneMute(boolean on, String callingPackage) {
        if (this.mAppOps.noteOp(44, Binder.getCallingUid(), callingPackage) != 0) {
            return;
        }
        if (!this.checkAudioSettingsPermission("setMicrophoneMute()")) {
            return;
        }
        AudioSystem.muteMicrophone(on);
        AudioService.sendMsg(this.mAudioHandler, 23, 0, on ? 1 : 0, UserHandle.getCallingUserId(), null, 500);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_media_AudioService$getRingerMode() {
        Object object = this.mSettingsLock;
        synchronized (object) {
            return this.mRingerMode;
        }
    }

    private final void $$robo$$android_media_AudioService$ensureValidRingerMode(int ringerMode) {
        if (!AudioManager.isValidRingerMode(ringerMode)) {
            throw new IllegalArgumentException("Bad ringer mode " + ringerMode);
        }
    }

    private final void $$robo$$android_media_AudioService$setRingerMode(int ringerMode, boolean checkZen) {
        if (this.mUseFixedVolume || this.isPlatformTelevision()) {
            return;
        }
        if (ringerMode == 1 && !this.mHasVibrator) {
            ringerMode = 0;
        }
        if (checkZen) {
            this.checkZen(ringerMode);
        }
        if (ringerMode != this.getRingerMode()) {
            this.setRingerModeInt(ringerMode, true);
            this.broadcastRingerMode(ringerMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_AudioService$checkZen(int ringerMode) {
        int zen = Settings.Global.getInt(this.mContentResolver, "zen_mode", 0);
        if (ringerMode != 0 && zen != 0) {
            long ident = Binder.clearCallingIdentity();
            try {
                Settings.Global.putInt(this.mContentResolver, "zen_mode", 0);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_AudioService$setRingerModeInt(int ringerMode, boolean persist) {
        Object object = this.mSettingsLock;
        synchronized (object) {
            this.mRingerMode = ringerMode;
        }
        int numStreamTypes = AudioSystem.getNumStreamTypes();
        for (int streamType = numStreamTypes - 1; streamType >= 0; --streamType) {
            if (this.isStreamMutedByRingerMode(streamType)) {
                if (this.isStreamAffectedByRingerMode(streamType) && ringerMode != 2) continue;
                if (this.isPlatformVoice() && this.mStreamVolumeAlias[streamType] == 2) {
                    VolumeStreamState volumeStreamState = this.mStreamStates[streamType];
                    synchronized (volumeStreamState) {
                        Set set = this.mStreamStates[streamType].mIndex.entrySet();
                        for (Map.Entry entry : set) {
                            if ((Integer)entry.getValue() != 0) continue;
                            entry.setValue(10);
                        }
                    }
                }
                this.mStreamStates[streamType].mute(null, false);
                this.mRingerModeMutedStreams &= ~(1 << streamType);
                continue;
            }
            if (!this.isStreamAffectedByRingerMode(streamType) || ringerMode == 2) continue;
            this.mStreamStates[streamType].mute(null, true);
            this.mRingerModeMutedStreams |= 1 << streamType;
        }
        if (persist) {
            AudioService.sendMsg(this.mAudioHandler, 3, 0, 0, 0, null, 500);
        }
    }

    private final void $$robo$$android_media_AudioService$restoreMasterVolume() {
        float volume;
        if (this.mUseFixedVolume) {
            AudioSystem.setMasterVolume(1.0f);
            return;
        }
        if (this.mUseMasterVolume && (volume = Settings.System.getFloatForUser(this.mContentResolver, "volume_master", -1.0f, -2)) >= 0.0f) {
            AudioSystem.setMasterVolume(volume);
        }
    }

    private final boolean $$robo$$android_media_AudioService$shouldVibrate(int vibrateType) {
        if (!this.mHasVibrator) {
            return false;
        }
        switch (this.getVibrateSetting(vibrateType)) {
            case 1: {
                return this.getRingerMode() != 0;
            }
            case 2: {
                return this.getRingerMode() == 1;
            }
            case 0: {
                return false;
            }
        }
        return false;
    }

    private final int $$robo$$android_media_AudioService$getVibrateSetting(int vibrateType) {
        if (!this.mHasVibrator) {
            return 0;
        }
        return this.mVibrateSetting >> vibrateType * 2 & 3;
    }

    private final void $$robo$$android_media_AudioService$setVibrateSetting(int vibrateType, int vibrateSetting) {
        if (!this.mHasVibrator) {
            return;
        }
        this.mVibrateSetting = AudioService.getValueForVibrateSetting(this.mVibrateSetting, vibrateType, vibrateSetting);
        this.broadcastVibrateSetting(vibrateType);
    }

    private static final int $$robo$$android_media_AudioService$getValueForVibrateSetting(int existingValue, int vibrateType, int vibrateSetting) {
        existingValue &= ~(3 << vibrateType * 2);
        return existingValue |= (vibrateSetting & 3) << vibrateType * 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_AudioService$setMode(int mode, IBinder cb) {
        if (DEBUG_MODE) {
            Log.v("AudioService", "setMode(mode=" + mode + ")");
        }
        if (!this.checkAudioSettingsPermission("setMode()")) {
            return;
        }
        if (mode == 2 && this.mContext.checkCallingOrSelfPermission("android.permission.MODIFY_PHONE_STATE") != 0) {
            Log.w("AudioService", "MODIFY_PHONE_STATE Permission Denial: setMode(MODE_IN_CALL) from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            return;
        }
        if (mode < -1 || mode >= 4) {
            return;
        }
        int newModeOwnerPid = 0;
        ArrayList<SetModeDeathHandler> arrayList = this.mSetModeDeathHandlers;
        synchronized (arrayList) {
            if (mode == -1) {
                mode = this.mMode;
            }
            newModeOwnerPid = this.setModeInt(mode, cb, Binder.getCallingPid());
        }
        if (newModeOwnerPid != 0) {
            this.disconnectBluetoothSco(newModeOwnerPid);
        }
    }

    private final int $$robo$$android_media_AudioService$setModeInt(int mode, IBinder cb, int pid) {
        if (DEBUG_MODE) {
            Log.v("AudioService", "setModeInt(mode=" + mode + ", pid=" + pid + ")");
        }
        int newModeOwnerPid = 0;
        if (cb == null) {
            Log.e("AudioService", "setModeInt() called with null binder");
            return newModeOwnerPid;
        }
        SetModeDeathHandler hdlr = null;
        Iterator<SetModeDeathHandler> iter = this.mSetModeDeathHandlers.iterator();
        while (iter.hasNext()) {
            SetModeDeathHandler h = iter.next();
            if (h.getPid() != pid) continue;
            hdlr = h;
            iter.remove();
            hdlr.getBinder().unlinkToDeath(hdlr, 0);
            break;
        }
        int status = 0;
        do {
            if (mode == 0) {
                if (!this.mSetModeDeathHandlers.isEmpty()) {
                    hdlr = this.mSetModeDeathHandlers.get(0);
                    cb = hdlr.getBinder();
                    mode = hdlr.getMode();
                    if (DEBUG_MODE) {
                        Log.w("AudioService", " using mode=" + mode + " instead due to death hdlr at pid=" + hdlr.mPid);
                    }
                }
            } else {
                if (hdlr == null) {
                    hdlr = new SetModeDeathHandler(this, cb, pid);
                }
                try {
                    cb.linkToDeath(hdlr, 0);
                }
                catch (RemoteException e) {
                    Log.w("AudioService", "setMode() could not link to " + cb + " binder death");
                }
                this.mSetModeDeathHandlers.add(0, hdlr);
                hdlr.setMode(mode);
            }
            if (mode != this.mMode) {
                status = AudioSystem.setPhoneState(mode);
                if (status == 0) {
                    if (DEBUG_MODE) {
                        Log.v("AudioService", " mode successfully set to " + mode);
                    }
                    this.mMode = mode;
                    continue;
                }
                if (hdlr != null) {
                    this.mSetModeDeathHandlers.remove(hdlr);
                    cb.unlinkToDeath(hdlr, 0);
                }
                if (DEBUG_MODE) {
                    Log.w("AudioService", " mode set to MODE_NORMAL after phoneState pb");
                }
                mode = 0;
                continue;
            }
            status = 0;
        } while (status != 0 && !this.mSetModeDeathHandlers.isEmpty());
        if (status == 0) {
            if (mode != 0) {
                if (this.mSetModeDeathHandlers.isEmpty()) {
                    Log.e("AudioService", "setMode() different from MODE_NORMAL with empty mode client stack");
                } else {
                    newModeOwnerPid = this.mSetModeDeathHandlers.get(0).getPid();
                }
            }
            int streamType = this.getActiveStreamType(Integer.MIN_VALUE);
            int device = this.getDeviceForStream(streamType);
            int index = this.mStreamStates[this.mStreamVolumeAlias[streamType]].getIndex(device);
            this.setStreamVolumeInt(this.mStreamVolumeAlias[streamType], index, device, true);
            this.updateStreamVolumeAlias(true);
        }
        return newModeOwnerPid;
    }

    private final int $$robo$$android_media_AudioService$getMode() {
        return this.mMode;
    }

    private final void $$robo$$android_media_AudioService$loadTouchSoundAssetDefaults() {
        SOUND_EFFECT_FILES.add("Effect_Tick.ogg");
        for (int i = 0; i < 10; ++i) {
            this.SOUND_EFFECT_FILES_MAP[i][0] = 0;
            this.SOUND_EFFECT_FILES_MAP[i][1] = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_AudioService$loadTouchSoundAssets() {
        block17: {
            XmlResourceParser parser = null;
            if (!SOUND_EFFECT_FILES.isEmpty()) {
                return;
            }
            this.loadTouchSoundAssetDefaults();
            try {
                String element;
                boolean inTouchSoundsGroup;
                block18: {
                    String name;
                    parser = this.mContext.getResources().getXml(0x1110001);
                    XmlUtils.beginDocument(parser, "audio_assets");
                    String version = parser.getAttributeValue(null, "version");
                    inTouchSoundsGroup = false;
                    if (!"1.0".equals(version)) break block17;
                    do {
                        XmlUtils.nextElement(parser);
                        element = parser.getName();
                        if (element == null) break block18;
                    } while (!element.equals("group") || !"touch_sounds".equals(name = parser.getAttributeValue(null, "name")));
                    inTouchSoundsGroup = true;
                }
                while (inTouchSoundsGroup) {
                    XmlUtils.nextElement(parser);
                    element = parser.getName();
                    if (element == null) {
                        break;
                    }
                    if (!element.equals("asset")) break;
                    String id2 = parser.getAttributeValue(null, "id");
                    String file = parser.getAttributeValue(null, "file");
                    try {
                        Field field = AudioManager.class.getField(id2);
                        int fx = field.getInt(null);
                    }
                    catch (Exception e) {
                        Log.w("AudioService", "Invalid touch sound ID: " + id2);
                        continue;
                    }
                    int i = SOUND_EFFECT_FILES.indexOf(file);
                    if (i == -1) {
                        i = SOUND_EFFECT_FILES.size();
                        SOUND_EFFECT_FILES.add(file);
                    }
                    this.SOUND_EFFECT_FILES_MAP[fx][0] = i;
                }
            }
            catch (Resources.NotFoundException e) {
                Log.w("AudioService", "audio assets file not found", e);
            }
            catch (XmlPullParserException e) {
                Log.w("AudioService", "XML parser exception reading touch sound assets", e);
            }
            catch (IOException e) {
                Log.w("AudioService", "I/O exception reading touch sound assets", e);
            }
            finally {
                if (parser != null) {
                    parser.close();
                }
            }
        }
    }

    private final void $$robo$$android_media_AudioService$playSoundEffect(int effectType) {
        this.playSoundEffectVolume(effectType, -1.0f);
    }

    private final void $$robo$$android_media_AudioService$playSoundEffectVolume(int effectType, float volume) {
        if (effectType >= 10 || effectType < 0) {
            Log.w("AudioService", "AudioService effectType value " + effectType + " out of range");
            return;
        }
        AudioService.sendMsg(this.mAudioHandler, 5, 2, effectType, (int)(volume * 1000.0f), null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_media_AudioService$loadSoundEffects() {
        LoadSoundEffectReply reply;
        int attempts = 3;
        LoadSoundEffectReply loadSoundEffectReply = reply = new LoadSoundEffectReply(this);
        synchronized (loadSoundEffectReply) {
            AudioService.sendMsg(this.mAudioHandler, 7, 2, 0, 0, reply, 0);
            while (reply.mStatus == 1 && attempts-- > 0) {
                try {
                    reply.wait(5000L);
                }
                catch (InterruptedException e) {
                    Log.w("AudioService", "loadSoundEffects Interrupted while waiting sound pool loaded.");
                }
            }
        }
        return reply.mStatus == 0;
    }

    private final void $$robo$$android_media_AudioService$unloadSoundEffects() {
        AudioService.sendMsg(this.mAudioHandler, 20, 2, 0, 0, null, 0);
    }

    private final void $$robo$$android_media_AudioService$reloadAudioSettings() {
        this.readAudioSettings(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_AudioService$readAudioSettings(boolean userSwitch) {
        this.readPersistedSettings();
        int numStreamTypes = AudioSystem.getNumStreamTypes();
        for (int streamType = 0; streamType < numStreamTypes; ++streamType) {
            VolumeStreamState streamState = this.mStreamStates[streamType];
            if (userSwitch && this.mStreamVolumeAlias[streamType] == 3) continue;
            VolumeStreamState volumeStreamState = streamState;
            synchronized (volumeStreamState) {
                streamState.readSettings();
                if (streamState.isMuted() && (!this.isStreamAffectedByMute(streamType) && !this.isStreamMutedByRingerMode(streamType) || this.mUseFixedVolume)) {
                    int size = streamState.mDeathHandlers.size();
                    for (int i = 0; i < size; ++i) {
                        ((VolumeStreamState.VolumeDeathHandler)streamState.mDeathHandlers.get(i)).mMuteCount = 1;
                        ((VolumeStreamState.VolumeDeathHandler)streamState.mDeathHandlers.get(i)).mute(false);
                    }
                }
                continue;
            }
        }
        this.setRingerModeInt(this.getRingerMode(), false);
        this.checkAllFixedVolumeDevices();
        this.checkAllAliasStreamVolumes();
        Integer n = this.mSafeMediaVolumeState;
        synchronized (n) {
            this.mMusicActiveMs = MathUtils.constrain(Settings.Secure.getIntForUser(this.mContentResolver, "unsafe_volume_music_active_ms", 0, -2), 0, 72000000);
            if (this.mSafeMediaVolumeState == 3) {
                this.enforceSafeMediaVolume();
            }
        }
    }

    private final void $$robo$$android_media_AudioService$setSpeakerphoneOn(boolean on) {
        if (!this.checkAudioSettingsPermission("setSpeakerphoneOn()")) {
            return;
        }
        if (on) {
            if (this.mForcedUseForComm == 3) {
                AudioService.sendMsg(this.mAudioHandler, 8, 2, 2, 0, null, 0);
            }
            this.mForcedUseForComm = 1;
        } else if (this.mForcedUseForComm == 1) {
            this.mForcedUseForComm = 0;
        }
        AudioService.sendMsg(this.mAudioHandler, 8, 2, 0, this.mForcedUseForComm, null, 0);
    }

    private final boolean $$robo$$android_media_AudioService$isSpeakerphoneOn() {
        return this.mForcedUseForComm == 1;
    }

    private final void $$robo$$android_media_AudioService$setBluetoothScoOn(boolean on) {
        if (!this.checkAudioSettingsPermission("setBluetoothScoOn()")) {
            return;
        }
        if (on) {
            this.mForcedUseForComm = 3;
        } else if (this.mForcedUseForComm == 3) {
            this.mForcedUseForComm = 0;
        }
        AudioService.sendMsg(this.mAudioHandler, 8, 2, 0, this.mForcedUseForComm, null, 0);
        AudioService.sendMsg(this.mAudioHandler, 8, 2, 2, this.mForcedUseForComm, null, 0);
    }

    private final boolean $$robo$$android_media_AudioService$isBluetoothScoOn() {
        return this.mForcedUseForComm == 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_AudioService$setBluetoothA2dpOn(boolean on) {
        Object object = this.mBluetoothA2dpEnabledLock;
        synchronized (object) {
            this.mBluetoothA2dpEnabled = on;
            AudioService.sendMsg(this.mAudioHandler, 13, 2, 1, this.mBluetoothA2dpEnabled ? 0 : 10, null, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_media_AudioService$isBluetoothA2dpOn() {
        Object object = this.mBluetoothA2dpEnabledLock;
        synchronized (object) {
            return this.mBluetoothA2dpEnabled;
        }
    }

    private final void $$robo$$android_media_AudioService$startBluetoothSco(IBinder cb, int targetSdkVersion) {
        int scoAudioMode = targetSdkVersion < 18 ? 0 : -1;
        this.startBluetoothScoInt(cb, scoAudioMode);
    }

    private final void $$robo$$android_media_AudioService$startBluetoothScoVirtualCall(IBinder cb) {
        this.startBluetoothScoInt(cb, 0);
    }

    private final void $$robo$$android_media_AudioService$startBluetoothScoInt(IBinder cb, int scoAudioMode) {
        if (!this.checkAudioSettingsPermission("startBluetoothSco()") || !this.mSystemReady) {
            return;
        }
        ScoClient client = this.getScoClient(cb, true);
        long ident = Binder.clearCallingIdentity();
        client.incCount(scoAudioMode);
        Binder.restoreCallingIdentity(ident);
    }

    private final void $$robo$$android_media_AudioService$stopBluetoothSco(IBinder cb) {
        if (!this.checkAudioSettingsPermission("stopBluetoothSco()") || !this.mSystemReady) {
            return;
        }
        ScoClient client = this.getScoClient(cb, false);
        long ident = Binder.clearCallingIdentity();
        if (client != null) {
            client.decCount();
        }
        Binder.restoreCallingIdentity(ident);
    }

    private final void $$robo$$android_media_AudioService$checkScoAudioState() {
        if (this.mBluetoothHeadset != null && this.mBluetoothHeadsetDevice != null && this.mScoAudioState == 0 && this.mBluetoothHeadset.getAudioState(this.mBluetoothHeadsetDevice) != 10) {
            this.mScoAudioState = 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ScoClient $$robo$$android_media_AudioService$getScoClient(IBinder cb, boolean create) {
        ArrayList<ScoClient> arrayList = this.mScoClients;
        synchronized (arrayList) {
            ScoClient client = null;
            int size = this.mScoClients.size();
            for (int i = 0; i < size; ++i) {
                client = this.mScoClients.get(i);
                if (client.getBinder() != cb) continue;
                return client;
            }
            if (create) {
                client = new ScoClient(this, cb);
                this.mScoClients.add(client);
            }
            return client;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_AudioService$clearAllScoClients(int exceptPid, boolean stopSco) {
        ArrayList<ScoClient> arrayList = this.mScoClients;
        synchronized (arrayList) {
            ScoClient savedClient = null;
            int size = this.mScoClients.size();
            for (int i = 0; i < size; ++i) {
                ScoClient cl = this.mScoClients.get(i);
                if (cl.getPid() != exceptPid) {
                    cl.clearCount(stopSco);
                    continue;
                }
                savedClient = cl;
            }
            this.mScoClients.clear();
            if (savedClient != null) {
                this.mScoClients.add(savedClient);
            }
        }
    }

    private final boolean $$robo$$android_media_AudioService$getBluetoothHeadset() {
        boolean result = false;
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (adapter != null) {
            result = adapter.getProfileProxy(this.mContext, this.mBluetoothProfileServiceListener, 1);
        }
        AudioService.sendMsg(this.mAudioHandler, 9, 0, 0, 0, null, result ? 3000 : 0);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_AudioService$disconnectBluetoothSco(int exceptPid) {
        ArrayList<ScoClient> arrayList = this.mScoClients;
        synchronized (arrayList) {
            this.checkScoAudioState();
            if (this.mScoAudioState == 2 || this.mScoAudioState == 4) {
                if (this.mBluetoothHeadsetDevice != null) {
                    if (this.mBluetoothHeadset != null) {
                        if (!this.mBluetoothHeadset.stopVoiceRecognition(this.mBluetoothHeadsetDevice)) {
                            AudioService.sendMsg(this.mAudioHandler, 9, 0, 0, 0, null, 0);
                        }
                    } else if (this.mScoAudioState == 2 && this.getBluetoothHeadset()) {
                        this.mScoAudioState = 4;
                    }
                }
            } else {
                this.clearAllScoClients(exceptPid, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_AudioService$resetBluetoothSco() {
        ArrayList<ScoClient> arrayList = this.mScoClients;
        synchronized (arrayList) {
            this.clearAllScoClients(0, false);
            this.mScoAudioState = 0;
            this.broadcastScoConnectionState(0);
        }
    }

    private final void $$robo$$android_media_AudioService$broadcastScoConnectionState(int state) {
        AudioService.sendMsg(this.mAudioHandler, 19, 2, state, 0, null, 0);
    }

    private final void $$robo$$android_media_AudioService$onBroadcastScoConnectionState(int state) {
        if (state != this.mScoConnectionState) {
            Intent newIntent = new Intent("android.media.ACTION_SCO_AUDIO_STATE_UPDATED");
            newIntent.putExtra("android.media.extra.SCO_AUDIO_STATE", state);
            newIntent.putExtra("android.media.extra.SCO_AUDIO_PREVIOUS_STATE", this.mScoConnectionState);
            this.sendStickyBroadcastToAll(newIntent);
            this.mScoConnectionState = state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_AudioService$onCheckMusicActive() {
        Integer n = this.mSafeMediaVolumeState;
        synchronized (n) {
            int device;
            if (this.mSafeMediaVolumeState == 2 && ((device = this.getDeviceForStream(3)) & 0xC) != 0) {
                AudioService.sendMsg(this.mAudioHandler, 14, 0, 0, 0, null, 60000);
                int index = this.mStreamStates[3].getIndex(device);
                if (AudioSystem.isStreamActive(3, 0) && index > this.mSafeMediaVolumeIndex) {
                    this.mMusicActiveMs += 60000;
                    if (this.mMusicActiveMs > 72000000) {
                        this.setSafeMediaVolumeEnabled(true);
                        this.mMusicActiveMs = 0;
                    }
                    this.saveMusicActiveMs();
                }
            }
        }
    }

    private final void $$robo$$android_media_AudioService$saveMusicActiveMs() {
        this.mAudioHandler.obtainMessage(22, this.mMusicActiveMs, 0).sendToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_AudioService$onConfigureSafeVolume(boolean force) {
        Integer n = this.mSafeMediaVolumeState;
        synchronized (n) {
            int mcc = this.mContext.getResources().getConfiguration().mcc;
            if (this.mMcc != mcc || this.mMcc == 0 && force) {
                int persistedState;
                boolean safeMediaVolumeEnabled;
                this.mSafeMediaVolumeIndex = this.mContext.getResources().getInteger(17694831) * 10;
                boolean bl = safeMediaVolumeEnabled = SystemProperties.getBoolean("audio.safemedia.force", false) || this.mContext.getResources().getBoolean(17956961);
                if (safeMediaVolumeEnabled) {
                    persistedState = 3;
                    if (this.mSafeMediaVolumeState != 2) {
                        if (this.mMusicActiveMs == 0) {
                            this.mSafeMediaVolumeState = 3;
                            this.enforceSafeMediaVolume();
                        } else {
                            this.mSafeMediaVolumeState = 2;
                        }
                    }
                } else {
                    persistedState = 1;
                    this.mSafeMediaVolumeState = 1;
                }
                this.mMcc = mcc;
                AudioService.sendMsg(this.mAudioHandler, 18, 2, persistedState, 0, null, 0);
            }
        }
    }

    private final int $$robo$$android_media_AudioService$checkForRingerModeChange(int oldIndex, int direction, int step) {
        int result = 1;
        int ringerMode = this.getRingerMode();
        switch (ringerMode) {
            case 2: {
                if (direction != -1) break;
                if (this.mHasVibrator) {
                    if (step > oldIndex || oldIndex >= 2 * step) break;
                    ringerMode = 1;
                    break;
                }
                if (oldIndex >= step) break;
                break;
            }
            case 1: {
                if (!this.mHasVibrator) {
                    Log.e("AudioService", "checkForRingerModeChange() current ringer mode is vibratebut no vibrator is present");
                    break;
                }
                if (direction != -1 && direction == 1) {
                    ringerMode = 2;
                }
                result &= 0xFFFFFFFE;
                break;
            }
            case 0: {
                if (direction == 1) {
                    result |= 0x80;
                }
                result &= 0xFFFFFFFE;
                break;
            }
            default: {
                Log.e("AudioService", "checkForRingerModeChange() wrong ringer mode: " + ringerMode);
            }
        }
        this.setRingerMode(ringerMode, false);
        this.mPrevVolDirection = direction;
        return result;
    }

    private final boolean $$robo$$android_media_AudioService$isStreamAffectedByRingerMode(int streamType) {
        return (this.mRingerModeAffectedStreams & 1 << streamType) != 0;
    }

    private final boolean $$robo$$android_media_AudioService$isStreamMutedByRingerMode(int streamType) {
        return (this.mRingerModeMutedStreams & 1 << streamType) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_media_AudioService$updateRingerModeAffectedStreams() {
        int ringerModeAffectedStreams = Settings.System.getIntForUser(this.mContentResolver, "mode_ringer_streams_affected", 166, -2);
        ringerModeAffectedStreams |= 0x26;
        switch (this.mPlatformType) {
            case 2: {
                ringerModeAffectedStreams = 0;
                break;
            }
            default: {
                ringerModeAffectedStreams &= 0xFFFFFFF7;
            }
        }
        Boolean bl = this.mCameraSoundForced;
        synchronized (bl) {
            ringerModeAffectedStreams = this.mCameraSoundForced.booleanValue() ? (ringerModeAffectedStreams &= 0xFFFFFF7F) : (ringerModeAffectedStreams |= 0x80);
        }
        ringerModeAffectedStreams = this.mStreamVolumeAlias[8] == 2 ? (ringerModeAffectedStreams |= 0x100) : (ringerModeAffectedStreams &= 0xFFFFFEFF);
        if (ringerModeAffectedStreams != this.mRingerModeAffectedStreams) {
            Settings.System.putIntForUser(this.mContentResolver, "mode_ringer_streams_affected", ringerModeAffectedStreams, -2);
            this.mRingerModeAffectedStreams = ringerModeAffectedStreams;
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_media_AudioService$isStreamAffectedByMute(int streamType) {
        return (this.mMuteAffectedStreams & 1 << streamType) != 0;
    }

    private final void $$robo$$android_media_AudioService$ensureValidDirection(int direction) {
        if (direction < -1 || direction > 1) {
            throw new IllegalArgumentException("Bad direction " + direction);
        }
    }

    private final void $$robo$$android_media_AudioService$ensureValidSteps(int steps) {
        if (Math.abs(steps) > 4) {
            throw new IllegalArgumentException("Bad volume adjust steps " + steps);
        }
    }

    private final void $$robo$$android_media_AudioService$ensureValidStreamType(int streamType) {
        if (streamType < 0 || streamType >= this.mStreamStates.length) {
            throw new IllegalArgumentException("Bad stream type " + streamType);
        }
    }

    private final boolean $$robo$$android_media_AudioService$isInCommunication() {
        boolean IsInCall = false;
        TelecomManager telecomManager = (TelecomManager)this.mContext.getSystemService("telecom");
        IsInCall = telecomManager.isInCall();
        return IsInCall || this.getMode() == 3;
    }

    private final boolean $$robo$$android_media_AudioService$isAfMusicActiveRecently(int delay_ms) {
        return AudioSystem.isStreamActive(3, delay_ms) || AudioSystem.isStreamActiveRemotely(3, delay_ms);
    }

    private final int $$robo$$android_media_AudioService$getActiveStreamType(int suggestedStreamType) {
        switch (this.mPlatformType) {
            case 1: {
                if (this.isInCommunication()) {
                    if (AudioSystem.getForceUse(0) == 3) {
                        return 6;
                    }
                    return 0;
                }
                if (suggestedStreamType == Integer.MIN_VALUE) {
                    if (this.isAfMusicActiveRecently(StreamOverride.sDelayMs)) {
                        if (DEBUG_VOL) {
                            Log.v("AudioService", "getActiveStreamType: Forcing STREAM_MUSIC stream active");
                        }
                        return 3;
                    }
                    if (DEBUG_VOL) {
                        Log.v("AudioService", "getActiveStreamType: Forcing STREAM_RING b/c default");
                    }
                    return 2;
                }
                if (!this.isAfMusicActiveRecently(0)) break;
                if (DEBUG_VOL) {
                    Log.v("AudioService", "getActiveStreamType: Forcing STREAM_MUSIC stream active");
                }
                return 3;
            }
            case 2: {
                if (suggestedStreamType != Integer.MIN_VALUE) break;
                return 3;
            }
            default: {
                if (this.isInCommunication()) {
                    if (AudioSystem.getForceUse(0) == 3) {
                        if (DEBUG_VOL) {
                            Log.v("AudioService", "getActiveStreamType: Forcing STREAM_BLUETOOTH_SCO");
                        }
                        return 6;
                    }
                    if (DEBUG_VOL) {
                        Log.v("AudioService", "getActiveStreamType: Forcing STREAM_VOICE_CALL");
                    }
                    return 0;
                }
                if (AudioSystem.isStreamActive(5, StreamOverride.sDelayMs) || AudioSystem.isStreamActive(2, StreamOverride.sDelayMs)) {
                    if (DEBUG_VOL) {
                        Log.v("AudioService", "getActiveStreamType: Forcing STREAM_NOTIFICATION");
                    }
                    return 5;
                }
                if (suggestedStreamType != Integer.MIN_VALUE) break;
                if (this.isAfMusicActiveRecently(StreamOverride.sDelayMs)) {
                    if (DEBUG_VOL) {
                        Log.v("AudioService", "getActiveStreamType: forcing STREAM_MUSIC");
                    }
                    return 3;
                }
                if (DEBUG_VOL) {
                    Log.v("AudioService", "getActiveStreamType: using STREAM_NOTIFICATION as default");
                }
                return 5;
            }
        }
        if (DEBUG_VOL) {
            Log.v("AudioService", "getActiveStreamType: Returning suggested type " + suggestedStreamType);
        }
        return suggestedStreamType;
    }

    private final void $$robo$$android_media_AudioService$broadcastRingerMode(int ringerMode) {
        Intent broadcast = new Intent("android.media.RINGER_MODE_CHANGED");
        broadcast.putExtra("android.media.EXTRA_RINGER_MODE", ringerMode);
        broadcast.addFlags(0x24000000);
        this.sendStickyBroadcastToAll(broadcast);
    }

    private final void $$robo$$android_media_AudioService$broadcastVibrateSetting(int vibrateType) {
        if (ActivityManagerNative.isSystemReady()) {
            Intent broadcast = new Intent("android.media.VIBRATE_SETTING_CHANGED");
            broadcast.putExtra("android.media.EXTRA_VIBRATE_TYPE", vibrateType);
            broadcast.putExtra("android.media.EXTRA_VIBRATE_SETTING", this.getVibrateSetting(vibrateType));
            this.sendBroadcastToAll(broadcast);
        }
    }

    private final void $$robo$$android_media_AudioService$queueMsgUnderWakeLock(Handler handler, int msg, int arg1, int arg2, Object obj, int delay) {
        long ident = Binder.clearCallingIdentity();
        this.mAudioEventWakeLock.acquire();
        Binder.restoreCallingIdentity(ident);
        AudioService.sendMsg(handler, msg, 2, arg1, arg2, obj, delay);
    }

    private static final void $$robo$$android_media_AudioService$sendMsg(Handler handler, int msg, int existingMsgPolicy, int arg1, int arg2, Object obj, int delay) {
        if (existingMsgPolicy == 0) {
            handler.removeMessages(msg);
        } else if (existingMsgPolicy == 1 && handler.hasMessages(msg)) {
            return;
        }
        handler.sendMessageDelayed(handler.obtainMessage(msg, arg1, arg2, obj), delay);
    }

    private final boolean $$robo$$android_media_AudioService$checkAudioSettingsPermission(String method) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.MODIFY_AUDIO_SETTINGS") == 0) {
            return true;
        }
        String msg = "Audio Settings Permission Denial: " + method + " from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid();
        Log.w("AudioService", msg);
        return false;
    }

    private final int $$robo$$android_media_AudioService$getDeviceForStream(int stream) {
        int device = AudioSystem.getDevicesForStream(stream);
        if ((device & device - 1) != 0) {
            device = (device & 2) != 0 ? 2 : ((device & 0x40000) != 0 ? 262144 : ((device & 0x80000) != 0 ? 524288 : ((device & 0x200000) != 0 ? 0x200000 : (device &= 0x380))));
        }
        return device;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_AudioService$setWiredDeviceConnectionState(int device, int state, String name) {
        HashMap<Integer, String> hashMap = this.mConnectedDevices;
        synchronized (hashMap) {
            int delay = this.checkSendBecomingNoisyIntent(device, state);
            this.queueMsgUnderWakeLock(this.mAudioHandler, 100, device, state, name, delay);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_media_AudioService$setBluetoothA2dpDeviceConnectionState(BluetoothDevice device, int state, int profile) {
        int delay;
        if (profile != 2 && profile != 10) {
            throw new IllegalArgumentException("invalid profile " + profile);
        }
        HashMap<Integer, String> hashMap = this.mConnectedDevices;
        synchronized (hashMap) {
            delay = profile == 2 ? this.checkSendBecomingNoisyIntent(128, state == 2 ? 1 : 0) : 0;
            this.queueMsgUnderWakeLock(this.mAudioHandler, profile == 2 ? 102 : 101, state, 0, device, delay);
        }
        return delay;
    }

    private final void $$robo$$android_media_AudioService$makeA2dpDeviceAvailable(String address) {
        VolumeStreamState streamState = this.mStreamStates[3];
        AudioService.sendMsg(this.mAudioHandler, 0, 2, 128, 0, streamState, 0);
        this.setBluetoothA2dpOnInt(true);
        AudioSystem.setDeviceConnectionState(128, 1, address);
        AudioSystem.setParameters("A2dpSuspended=false");
        this.mConnectedDevices.put(new Integer(128), address);
    }

    private final void $$robo$$android_media_AudioService$onSendBecomingNoisyIntent() {
        this.sendBroadcastToAll(new Intent("android.media.AUDIO_BECOMING_NOISY"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_AudioService$makeA2dpDeviceUnavailableNow(String address) {
        Object object = this.mA2dpAvrcpLock;
        synchronized (object) {
            this.mAvrcpAbsVolSupported = false;
        }
        AudioSystem.setDeviceConnectionState(128, 0, address);
        this.mConnectedDevices.remove(128);
        object = this.mCurAudioRoutes;
        synchronized (object) {
            if (this.mCurAudioRoutes.mBluetoothName != null) {
                this.mCurAudioRoutes.mBluetoothName = null;
                AudioService.sendMsg(this.mAudioHandler, 12, 1, 0, 0, null, 0);
            }
        }
    }

    private final void $$robo$$android_media_AudioService$makeA2dpDeviceUnavailableLater(String address) {
        AudioSystem.setParameters("A2dpSuspended=true");
        this.mConnectedDevices.remove(128);
        Message msg = this.mAudioHandler.obtainMessage(6, address);
        this.mAudioHandler.sendMessageDelayed(msg, 8000L);
    }

    private final void $$robo$$android_media_AudioService$makeA2dpSrcAvailable(String address) {
        AudioSystem.setDeviceConnectionState(-2147352576, 1, address);
        this.mConnectedDevices.put(new Integer(-2147352576), address);
    }

    private final void $$robo$$android_media_AudioService$makeA2dpSrcUnavailable(String address) {
        AudioSystem.setDeviceConnectionState(-2147352576, 0, address);
        this.mConnectedDevices.remove(-2147352576);
    }

    private final void $$robo$$android_media_AudioService$cancelA2dpDeviceTimeout() {
        this.mAudioHandler.removeMessages(6);
    }

    private final boolean $$robo$$android_media_AudioService$hasScheduledA2dpDockTimeout() {
        return this.mAudioHandler.hasMessages(6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_AudioService$onSetA2dpSinkConnectionState(BluetoothDevice btDevice, int state) {
        if (DEBUG_VOL) {
            Log.d("AudioService", "onSetA2dpSinkConnectionState btDevice=" + btDevice + "state=" + state);
        }
        if (btDevice == null) {
            return;
        }
        String address = btDevice.getAddress();
        if (!BluetoothAdapter.checkBluetoothAddress(address)) {
            address = "";
        }
        HashMap<Integer, String> hashMap = this.mConnectedDevices;
        synchronized (hashMap) {
            boolean isConnected;
            boolean bl = isConnected = this.mConnectedDevices.containsKey(128) && this.mConnectedDevices.get(128).equals(address);
            if (isConnected && state != 2) {
                if (btDevice.isBluetoothDock()) {
                    if (state == 0) {
                        this.makeA2dpDeviceUnavailableLater(address);
                    }
                } else {
                    this.makeA2dpDeviceUnavailableNow(address);
                }
                AudioRoutesInfo audioRoutesInfo = this.mCurAudioRoutes;
                synchronized (audioRoutesInfo) {
                    if (this.mCurAudioRoutes.mBluetoothName != null) {
                        this.mCurAudioRoutes.mBluetoothName = null;
                        AudioService.sendMsg(this.mAudioHandler, 12, 1, 0, 0, null, 0);
                    }
                }
            }
            if (!isConnected && state == 2) {
                if (btDevice.isBluetoothDock()) {
                    this.cancelA2dpDeviceTimeout();
                    this.mDockAddress = address;
                } else if (this.hasScheduledA2dpDockTimeout()) {
                    this.cancelA2dpDeviceTimeout();
                    this.makeA2dpDeviceUnavailableNow(this.mDockAddress);
                }
                this.makeA2dpDeviceAvailable(address);
                AudioRoutesInfo audioRoutesInfo = this.mCurAudioRoutes;
                synchronized (audioRoutesInfo) {
                    String name = btDevice.getAliasName();
                    if (!TextUtils.equals(this.mCurAudioRoutes.mBluetoothName, name)) {
                        this.mCurAudioRoutes.mBluetoothName = name;
                        AudioService.sendMsg(this.mAudioHandler, 12, 1, 0, 0, null, 0);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_AudioService$onSetA2dpSourceConnectionState(BluetoothDevice btDevice, int state) {
        if (DEBUG_VOL) {
            Log.d("AudioService", "onSetA2dpSourceConnectionState btDevice=" + btDevice + " state=" + state);
        }
        if (btDevice == null) {
            return;
        }
        String address = btDevice.getAddress();
        if (!BluetoothAdapter.checkBluetoothAddress(address)) {
            address = "";
        }
        HashMap<Integer, String> hashMap = this.mConnectedDevices;
        synchronized (hashMap) {
            boolean isConnected;
            boolean bl = isConnected = this.mConnectedDevices.containsKey(-2147352576) && this.mConnectedDevices.get(-2147352576).equals(address);
            if (isConnected && state != 2) {
                this.makeA2dpSrcUnavailable(address);
            } else if (!isConnected && state == 2) {
                this.makeA2dpSrcAvailable(address);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_AudioService$avrcpSupportsAbsoluteVolume(String address, boolean support) {
        Object object = this.mA2dpAvrcpLock;
        synchronized (object) {
            this.mAvrcpAbsVolSupported = support;
            AudioService.sendMsg(this.mAudioHandler, 0, 2, 128, 0, this.mStreamStates[3], 0);
            AudioService.sendMsg(this.mAudioHandler, 0, 2, 128, 0, this.mStreamStates[2], 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_media_AudioService$handleDeviceConnection(boolean connected, int device, String params) {
        HashMap<Integer, String> hashMap = this.mConnectedDevices;
        synchronized (hashMap) {
            boolean isConnected;
            boolean bl = isConnected = this.mConnectedDevices.containsKey(device) && (params.isEmpty() || this.mConnectedDevices.get(device).equals(params));
            if (isConnected && !connected) {
                AudioSystem.setDeviceConnectionState(device, 0, this.mConnectedDevices.get(device));
                this.mConnectedDevices.remove(device);
                return true;
            }
            if (!isConnected && connected) {
                AudioSystem.setDeviceConnectionState(device, 1, params);
                this.mConnectedDevices.put(new Integer(device), params);
                return true;
            }
        }
        return false;
    }

    private final int $$robo$$android_media_AudioService$checkSendBecomingNoisyIntent(int device, int state) {
        int delay = 0;
        if (state == 0 && (device & this.mBecomingNoisyIntentDevices) != 0) {
            int devices = 0;
            for (int dev : this.mConnectedDevices.keySet()) {
                if ((dev & Integer.MIN_VALUE) != 0 || (dev & this.mBecomingNoisyIntentDevices) == 0) continue;
                devices |= dev;
            }
            if (devices == device) {
                AudioService.sendMsg(this.mAudioHandler, 15, 0, 0, 0, null, 0);
                delay = 1000;
            }
        }
        if (this.mAudioHandler.hasMessages(101) || this.mAudioHandler.hasMessages(102) || this.mAudioHandler.hasMessages(100)) {
            delay = 1000;
        }
        return delay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_AudioService$sendDeviceConnectionIntent(int device, int state, String name) {
        Intent intent = new Intent();
        intent.putExtra("state", state);
        intent.putExtra("name", name);
        intent.addFlags(0x40000000);
        int connType = 0;
        if (device == 4) {
            connType = 1;
            intent.setAction("android.intent.action.HEADSET_PLUG");
            intent.putExtra("microphone", 1);
        } else if (device == 8 || device == 131072) {
            connType = 2;
            intent.setAction("android.intent.action.HEADSET_PLUG");
            intent.putExtra("microphone", 0);
        } else if (device == 2048) {
            connType = 4;
            intent.setAction("android.media.action.ANALOG_AUDIO_DOCK_PLUG");
        } else if (device == 4096) {
            connType = 4;
            intent.setAction("android.media.action.DIGITAL_AUDIO_DOCK_PLUG");
        } else if (device == 1024) {
            connType = 8;
            this.configureHdmiPlugIntent(intent, state);
        }
        AudioRoutesInfo audioRoutesInfo = this.mCurAudioRoutes;
        synchronized (audioRoutesInfo) {
            if (connType != 0) {
                int newConn = this.mCurAudioRoutes.mMainType;
                newConn = state != 0 ? (newConn |= connType) : (newConn &= ~connType);
                if (newConn != this.mCurAudioRoutes.mMainType) {
                    this.mCurAudioRoutes.mMainType = newConn;
                    AudioService.sendMsg(this.mAudioHandler, 12, 1, 0, 0, null, 0);
                }
            }
        }
        long ident = Binder.clearCallingIdentity();
        try {
            ActivityManagerNative.broadcastStickyIntent(intent, null, -1);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_AudioService$onSetWiredDeviceConnectionState(int device, int state, String name) {
        HashMap<Integer, String> hashMap = this.mConnectedDevices;
        synchronized (hashMap) {
            if (state == 0 && (device == 4 || device == 8 || device == 131072)) {
                this.setBluetoothA2dpOnInt(true);
            }
            boolean isUsb = (device & 0xFFFF9FFF) == 0 || (device & Integer.MIN_VALUE) != 0 && (device & 0x7FFFE7FF) == 0;
            this.handleDeviceConnection(state == 1, device, isUsb ? name : "");
            if (state != 0) {
                if (device == 4 || device == 8 || device == 131072) {
                    this.setBluetoothA2dpOnInt(false);
                }
                if ((device & 0xC) != 0) {
                    AudioService.sendMsg(this.mAudioHandler, 14, 0, 0, 0, null, 60000);
                }
                if (this.isPlatformTelevision() && (device & 0x400) != 0) {
                    this.mFixedVolumeDevices |= 0x400;
                    this.checkAllFixedVolumeDevices();
                    if (this.mHdmiManager != null) {
                        HdmiControlManager hdmiControlManager = this.mHdmiManager;
                        synchronized (hdmiControlManager) {
                            if (this.mHdmiPlaybackClient != null) {
                                this.mHdmiCecSink = false;
                                this.mHdmiPlaybackClient.queryDisplayStatus(this.mHdmiDisplayStatusCallback);
                            }
                        }
                    }
                }
            } else if (this.isPlatformTelevision() && (device & 0x400) != 0 && this.mHdmiManager != null) {
                HdmiControlManager hdmiControlManager = this.mHdmiManager;
                synchronized (hdmiControlManager) {
                    this.mHdmiCecSink = false;
                }
            }
            if (!isUsb && device != -2147483632) {
                this.sendDeviceConnectionIntent(device, state, name);
            }
        }
    }

    private final void $$robo$$android_media_AudioService$configureHdmiPlugIntent(Intent intent, int state) {
        int[] portGeneration;
        ArrayList<AudioPort> ports;
        int status;
        intent.setAction("android.media.action.HDMI_AUDIO_PLUG");
        intent.putExtra("android.media.extra.AUDIO_PLUG_STATE", state);
        if (state == 1 && (status = AudioSystem.listAudioPorts(ports = new ArrayList<AudioPort>(), portGeneration = new int[1])) == 0) {
            for (AudioPort port : ports) {
                AudioDevicePort devicePort;
                if (!(port instanceof AudioDevicePort) || (devicePort = (AudioDevicePort)port).type() != 1024) continue;
                int[] formats = devicePort.formats();
                if (formats.length > 0) {
                    ArrayList<Integer> encodingList = new ArrayList<Integer>(1);
                    for (int format : formats) {
                        if (format == 0) continue;
                        encodingList.add(format);
                    }
                    int[] encodingArray = new int[encodingList.size()];
                    for (int i = 0; i < encodingArray.length; ++i) {
                        encodingArray[i] = (Integer)encodingList.get(i);
                    }
                    intent.putExtra("android.media.extra.ENCODINGS", encodingArray);
                }
                int maxChannels = 0;
                for (int mask : devicePort.channelMasks()) {
                    int channelCount = AudioFormat.channelCountFromOutChannelMask(mask);
                    if (channelCount <= maxChannels) continue;
                    maxChannels = channelCount;
                }
                intent.putExtra("android.media.extra.MAX_CHANNEL_COUNT", maxChannels);
            }
        }
    }

    private final boolean $$robo$$android_media_AudioService$registerRemoteController(IRemoteControlDisplay rcd, int w, int h, ComponentName listenerComp) {
        return this.mMediaFocusControl.registerRemoteController(rcd, w, h, listenerComp);
    }

    private final boolean $$robo$$android_media_AudioService$registerRemoteControlDisplay(IRemoteControlDisplay rcd, int w, int h) {
        return this.mMediaFocusControl.registerRemoteControlDisplay(rcd, w, h);
    }

    private final void $$robo$$android_media_AudioService$unregisterRemoteControlDisplay(IRemoteControlDisplay rcd) {
        this.mMediaFocusControl.unregisterRemoteControlDisplay(rcd);
    }

    private final void $$robo$$android_media_AudioService$remoteControlDisplayUsesBitmapSize(IRemoteControlDisplay rcd, int w, int h) {
        this.mMediaFocusControl.remoteControlDisplayUsesBitmapSize(rcd, w, h);
    }

    private final void $$robo$$android_media_AudioService$remoteControlDisplayWantsPlaybackPositionSync(IRemoteControlDisplay rcd, boolean wantsSync) {
        this.mMediaFocusControl.remoteControlDisplayWantsPlaybackPositionSync(rcd, wantsSync);
    }

    private final void $$robo$$android_media_AudioService$setRemoteStreamVolume(int index) {
        this.enforceSelfOrSystemUI("set the remote stream volume");
        this.mMediaFocusControl.setRemoteStreamVolume(index);
    }

    private final int $$robo$$android_media_AudioService$requestAudioFocus(int mainStreamType, int durationHint, IBinder cb, IAudioFocusDispatcher fd, String clientId, String callingPackageName) {
        return this.mMediaFocusControl.requestAudioFocus(mainStreamType, durationHint, cb, fd, clientId, callingPackageName);
    }

    private final int $$robo$$android_media_AudioService$abandonAudioFocus(IAudioFocusDispatcher fd, String clientId) {
        return this.mMediaFocusControl.abandonAudioFocus(fd, clientId);
    }

    private final void $$robo$$android_media_AudioService$unregisterAudioFocusClient(String clientId) {
        this.mMediaFocusControl.unregisterAudioFocusClient(clientId);
    }

    private final int $$robo$$android_media_AudioService$getCurrentAudioFocus() {
        return this.mMediaFocusControl.getCurrentAudioFocus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_AudioService$handleConfigurationChanged(Context context) {
        try {
            int newOrientation;
            Configuration config = context.getResources().getConfiguration();
            if (this.mMonitorOrientation && (newOrientation = config.orientation) != this.mDeviceOrientation) {
                this.mDeviceOrientation = newOrientation;
                this.setOrientationForAudioSystem();
            }
            AudioService.sendMsg(this.mAudioHandler, 16, 0, 0, 0, null, 0);
            boolean cameraSoundForced = this.mContext.getResources().getBoolean(17956963);
            Object object = this.mSettingsLock;
            synchronized (object) {
                Boolean bl = this.mCameraSoundForced;
                synchronized (bl) {
                    if (cameraSoundForced != this.mCameraSoundForced) {
                        this.mCameraSoundForced = cameraSoundForced;
                        if (!this.isPlatformTelevision()) {
                            VolumeStreamState s = this.mStreamStates[7];
                            if (cameraSoundForced) {
                                s.setAllIndexesToMax();
                                this.mRingerModeAffectedStreams &= 0xFFFFFF7F;
                            } else {
                                s.setAllIndexes(this.mStreamStates[1]);
                                this.mRingerModeAffectedStreams |= 0x80;
                            }
                            this.setRingerModeInt(this.getRingerMode(), false);
                        }
                        AudioService.sendMsg(this.mAudioHandler, 8, 2, 4, cameraSoundForced ? 11 : 0, null, 0);
                        AudioService.sendMsg(this.mAudioHandler, 10, 2, 0, 0, this.mStreamStates[7], 0);
                    }
                }
            }
            this.mVolumeController.setLayoutDirection(config.getLayoutDirection());
        }
        catch (Exception e) {
            Log.e("AudioService", "Error handling configuration change: ", e);
        }
    }

    private final void $$robo$$android_media_AudioService$setOrientationForAudioSystem() {
        switch (this.mDeviceOrientation) {
            case 2: {
                AudioSystem.setParameters("orientation=landscape");
                break;
            }
            case 1: {
                AudioSystem.setParameters("orientation=portrait");
                break;
            }
            case 3: {
                AudioSystem.setParameters("orientation=square");
                break;
            }
            case 0: {
                AudioSystem.setParameters("orientation=undefined");
                break;
            }
            default: {
                Log.e("AudioService", "Unknown orientation");
            }
        }
    }

    private final void $$robo$$android_media_AudioService$setRotationForAudioSystem() {
        switch (this.mDeviceRotation) {
            case 0: {
                AudioSystem.setParameters("rotation=0");
                break;
            }
            case 1: {
                AudioSystem.setParameters("rotation=90");
                break;
            }
            case 2: {
                AudioSystem.setParameters("rotation=180");
                break;
            }
            case 3: {
                AudioSystem.setParameters("rotation=270");
                break;
            }
            default: {
                Log.e("AudioService", "Unknown device rotation");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_AudioService$setBluetoothA2dpOnInt(boolean on) {
        Object object = this.mBluetoothA2dpEnabledLock;
        synchronized (object) {
            this.mBluetoothA2dpEnabled = on;
            this.mAudioHandler.removeMessages(13);
            AudioSystem.setForceUse(1, this.mBluetoothA2dpEnabled ? 0 : 10);
        }
    }

    private final void $$robo$$android_media_AudioService$setRingtonePlayer(IRingtonePlayer player) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.REMOTE_AUDIO_PLAYBACK", null);
        this.mRingtonePlayer = player;
    }

    private final IRingtonePlayer $$robo$$android_media_AudioService$getRingtonePlayer() {
        return this.mRingtonePlayer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final AudioRoutesInfo $$robo$$android_media_AudioService$startWatchingRoutes(IAudioRoutesObserver observer) {
        AudioRoutesInfo audioRoutesInfo = this.mCurAudioRoutes;
        synchronized (audioRoutesInfo) {
            AudioRoutesInfo routes = new AudioRoutesInfo(this.mCurAudioRoutes);
            this.mRoutesObservers.register(observer);
            return routes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_AudioService$setSafeMediaVolumeEnabled(boolean on) {
        Integer n = this.mSafeMediaVolumeState;
        synchronized (n) {
            if (this.mSafeMediaVolumeState != 0 && this.mSafeMediaVolumeState != 1) {
                if (on && this.mSafeMediaVolumeState == 2) {
                    this.mSafeMediaVolumeState = 3;
                    this.enforceSafeMediaVolume();
                } else if (!on && this.mSafeMediaVolumeState == 3) {
                    this.mSafeMediaVolumeState = 2;
                    this.mMusicActiveMs = 1;
                    this.saveMusicActiveMs();
                    AudioService.sendMsg(this.mAudioHandler, 14, 0, 0, 0, null, 60000);
                }
            }
        }
    }

    private final void $$robo$$android_media_AudioService$enforceSafeMediaVolume() {
        VolumeStreamState streamState = this.mStreamStates[3];
        int devices = 12;
        int i = 0;
        while (devices != 0) {
            int device;
            if (((device = 1 << i++) & devices) == 0) continue;
            int index = streamState.getIndex(device);
            if (index > this.mSafeMediaVolumeIndex) {
                streamState.setIndex(this.mSafeMediaVolumeIndex, device);
                AudioService.sendMsg(this.mAudioHandler, 0, 2, device, 0, streamState, 0);
            }
            devices &= ~device;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_media_AudioService$checkSafeMediaVolume(int streamType, int index, int device) {
        Integer n = this.mSafeMediaVolumeState;
        synchronized (n) {
            return this.mSafeMediaVolumeState != 3 || this.mStreamVolumeAlias[streamType] != 3 || (device & 0xC) == 0 || index <= this.mSafeMediaVolumeIndex;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_AudioService$disableSafeMediaVolume() {
        this.enforceSelfOrSystemUI("disable the safe media volume");
        Integer n = this.mSafeMediaVolumeState;
        synchronized (n) {
            this.setSafeMediaVolumeEnabled(false);
            if (this.mPendingVolumeCommand != null) {
                this.onSetStreamVolume(this.mPendingVolumeCommand.mStreamType, this.mPendingVolumeCommand.mIndex, this.mPendingVolumeCommand.mFlags, this.mPendingVolumeCommand.mDevice);
                this.mPendingVolumeCommand = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_media_AudioService$setHdmiSystemAudioSupported(boolean on) {
        int device = 0;
        if (this.mHdmiManager != null) {
            HdmiControlManager hdmiControlManager = this.mHdmiManager;
            synchronized (hdmiControlManager) {
                if (this.mHdmiTvClient == null) {
                    Log.w("AudioService", "Only Hdmi-Cec enabled TV device supports system audio mode.");
                    return device;
                }
                HdmiTvClient hdmiTvClient = this.mHdmiTvClient;
                synchronized (hdmiTvClient) {
                    if (this.mHdmiSystemAudioSupported != on) {
                        this.mHdmiSystemAudioSupported = on;
                        AudioSystem.setForceUse(5, on ? 12 : 0);
                    }
                    device = AudioSystem.getDevicesForStream(3);
                }
            }
        }
        return device;
    }

    private final boolean $$robo$$android_media_AudioService$isHdmiSystemAudioSupported() {
        return this.mHdmiSystemAudioSupported;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_media_AudioService$isCameraSoundForced() {
        Boolean bl = this.mCameraSoundForced;
        synchronized (bl) {
            return this.mCameraSoundForced;
        }
    }

    private final void $$robo$$android_media_AudioService$dumpRingerMode(PrintWriter pw) {
        pw.println("\nRinger mode: ");
        pw.println("- mode: " + RINGER_MODE_NAMES[this.mRingerMode]);
        pw.print("- ringer mode affected streams = 0x");
        pw.println(Integer.toHexString(this.mRingerModeAffectedStreams));
        pw.print("- ringer mode muted streams = 0x");
        pw.println(Integer.toHexString(this.mRingerModeMutedStreams));
    }

    private final void $$robo$$android_media_AudioService$dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DUMP", "AudioService");
        this.mMediaFocusControl.dump(pw);
        this.dumpStreamStates(pw);
        this.dumpRingerMode(pw);
        pw.println("\nAudio routes:");
        pw.print("  mMainType=0x");
        pw.println(Integer.toHexString(this.mCurAudioRoutes.mMainType));
        pw.print("  mBluetoothName=");
        pw.println(this.mCurAudioRoutes.mBluetoothName);
        pw.println("\nOther state:");
        pw.print("  mVolumeController=");
        pw.println(this.mVolumeController);
        pw.print("  mSafeMediaVolumeState=");
        pw.println(AudioService.safeMediaVolumeStateToString(this.mSafeMediaVolumeState));
        pw.print("  mSafeMediaVolumeIndex=");
        pw.println(this.mSafeMediaVolumeIndex);
        pw.print("  mPendingVolumeCommand=");
        pw.println(this.mPendingVolumeCommand);
        pw.print("  mMusicActiveMs=");
        pw.println(this.mMusicActiveMs);
        pw.print("  mMcc=");
        pw.println(this.mMcc);
    }

    private static final String $$robo$$android_media_AudioService$safeMediaVolumeStateToString(Integer state) {
        switch (state) {
            case 0: {
                return "SAFE_MEDIA_VOLUME_NOT_CONFIGURED";
            }
            case 1: {
                return "SAFE_MEDIA_VOLUME_DISABLED";
            }
            case 2: {
                return "SAFE_MEDIA_VOLUME_INACTIVE";
            }
            case 3: {
                return "SAFE_MEDIA_VOLUME_ACTIVE";
            }
        }
        return null;
    }

    private static final void $$robo$$android_media_AudioService$readAndSetLowRamDevice() {
        int status = AudioSystem.setLowRamDevice(ActivityManager.isLowRamDeviceStatic());
        if (status != 0) {
            Log.w("AudioService", "AudioFlinger informed of device's low RAM attribute; status " + status);
        }
    }

    private final void $$robo$$android_media_AudioService$enforceSelfOrSystemUI(String action) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.STATUS_BAR_SERVICE", "Only SystemUI can " + action);
    }

    private final void $$robo$$android_media_AudioService$setVolumeController(IVolumeController controller) {
        this.enforceSelfOrSystemUI("set the volume controller");
        if (this.mVolumeController.isSameBinder(controller)) {
            return;
        }
        this.mVolumeController.postDismiss();
        if (controller != null) {
            try {
                controller.asBinder().linkToDeath(new IBinder.DeathRecipient(this, controller){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ IVolumeController val$controller;
                    /* synthetic */ AudioService this$0;

                    private void $$robo$$android_media_AudioService_3$__constructor__(AudioService audioService, IVolumeController iVolumeController) {
                    }

                    private final void $$robo$$android_media_AudioService_3$binderDied() {
                        if (this.this$0.mVolumeController.isSameBinder(this.val$controller)) {
                            Log.w("AudioService", "Current remote volume controller died, unregistering");
                            this.this$0.setVolumeController(null);
                        }
                    }

                    private void __constructor__(AudioService audioService, IVolumeController iVolumeController) {
                        this.$$robo$$android_media_AudioService_3$__constructor__(audioService, iVolumeController);
                    }
                    {
                        this.this$0 = audioService;
                        this.val$controller = iVolumeController;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioService_3$__constructor__(android.media.AudioService android.media.IVolumeController ), 0, this, audioService, iVolumeController);
                    }

                    @Override
                    public void binderDied() {
                        InvokeDynamicSupport.bootstrap("binderDied", $$robo$$android_media_AudioService_3$binderDied(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                }, 0);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        this.mVolumeController.setController(controller);
        if (DEBUG_VOL) {
            Log.d("AudioService", "Volume controller: " + this.mVolumeController);
        }
    }

    private final void $$robo$$android_media_AudioService$notifyVolumeControllerVisible(IVolumeController controller, boolean visible) {
        this.enforceSelfOrSystemUI("notify about volume controller visibility");
        if (!this.mVolumeController.isSameBinder(controller)) {
            return;
        }
        this.mVolumeController.setVisible(visible);
        if (DEBUG_VOL) {
            Log.d("AudioService", "Volume controller visible: " + visible);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_media_AudioService$registerAudioPolicy(AudioPolicyConfig policyConfig, IBinder cb) {
        boolean hasPermissionForPolicy;
        boolean bl = hasPermissionForPolicy = 0 == this.mContext.checkCallingOrSelfPermission("android.permission.MODIFY_AUDIO_ROUTING");
        if (!hasPermissionForPolicy) {
            Slog.w("AudioService", "Can't register audio policy for pid " + Binder.getCallingPid() + " / uid " + Binder.getCallingUid() + ", need MODIFY_AUDIO_ROUTING");
            return false;
        }
        HashMap<IBinder, AudioPolicyProxy> hashMap = this.mAudioPolicies;
        synchronized (hashMap) {
            AudioPolicyProxy app = new AudioPolicyProxy(this, policyConfig, cb);
            try {
                cb.linkToDeath(app, 0);
                this.mAudioPolicies.put(cb, app);
            }
            catch (RemoteException e) {
                Slog.w("AudioService", "Audio policy registration failed, could not link to " + cb + " binder death", e);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_AudioService$unregisterAudioPolicyAsync(IBinder cb) {
        HashMap<IBinder, AudioPolicyProxy> hashMap = this.mAudioPolicies;
        synchronized (hashMap) {
            AudioPolicyProxy app = this.mAudioPolicies.remove(cb);
            if (app == null) {
                Slog.w("AudioService", "Trying to unregister unknown audio policy for pid " + Binder.getCallingPid() + " / uid " + Binder.getCallingUid());
            } else {
                cb.unlinkToDeath(app, 0);
            }
        }
    }

    static void __staticInitializer__() {
        DEBUG_MODE = Log.isLoggable("AudioService.MOD", 3);
        DEBUG_VOL = Log.isLoggable("AudioService.VOL", 3);
        DEBUG_SESSIONS = Log.isLoggable("AudioService.SESSIONS", 3);
        SOUND_EFFECT_FILES = new ArrayList<String>();
        MAX_STREAM_VOLUME = new int[]{5, 7, 7, 15, 7, 7, 15, 7, 15, 15};
        STEAM_VOLUME_OPS = new int[]{34, 36, 35, 36, 37, 38, 39, 36, 36, 36};
        STREAM_NAMES = new String[]{"STREAM_VOICE_CALL", "STREAM_SYSTEM", "STREAM_RING", "STREAM_MUSIC", "STREAM_ALARM", "STREAM_NOTIFICATION", "STREAM_BLUETOOTH_SCO", "STREAM_SYSTEM_ENFORCED", "STREAM_DTMF", "STREAM_TTS"};
        RINGER_MODE_NAMES = new String[]{"SILENT", "VIBRATE", "NORMAL"};
    }

    private boolean isPlatformVoice() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPlatformVoice", $$robo$$android_media_AudioService$isPlatformVoice(), 0, this);
    }

    private boolean isPlatformTelevision() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPlatformTelevision", $$robo$$android_media_AudioService$isPlatformTelevision(), 0, this);
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_media_AudioService$__constructor__(context);
    }

    public AudioService(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioService$__constructor__(android.content.Context ), 0, this, context);
    }

    public void systemReady() {
        InvokeDynamicSupport.bootstrap("systemReady", $$robo$$android_media_AudioService$systemReady(), 0, this);
    }

    public void onSystemReady() {
        InvokeDynamicSupport.bootstrap("onSystemReady", $$robo$$android_media_AudioService$onSystemReady(), 0, this);
    }

    private void createAudioSystemThread() {
        InvokeDynamicSupport.bootstrap("createAudioSystemThread", $$robo$$android_media_AudioService$createAudioSystemThread(), 0, this);
    }

    private void waitForAudioHandlerCreation() {
        InvokeDynamicSupport.bootstrap("waitForAudioHandlerCreation", $$robo$$android_media_AudioService$waitForAudioHandlerCreation(), 0, this);
    }

    private void checkAllAliasStreamVolumes() {
        InvokeDynamicSupport.bootstrap("checkAllAliasStreamVolumes", $$robo$$android_media_AudioService$checkAllAliasStreamVolumes(), 0, this);
    }

    private void checkAllFixedVolumeDevices() {
        InvokeDynamicSupport.bootstrap("checkAllFixedVolumeDevices", $$robo$$android_media_AudioService$checkAllFixedVolumeDevices(), 0, this);
    }

    private void checkAllFixedVolumeDevices(int n) {
        InvokeDynamicSupport.bootstrap("checkAllFixedVolumeDevices", $$robo$$android_media_AudioService$checkAllFixedVolumeDevices(int ), 0, this, n);
    }

    private void createStreamStates() {
        InvokeDynamicSupport.bootstrap("createStreamStates", $$robo$$android_media_AudioService$createStreamStates(), 0, this);
    }

    private void dumpStreamStates(PrintWriter printWriter) {
        InvokeDynamicSupport.bootstrap("dumpStreamStates", $$robo$$android_media_AudioService$dumpStreamStates(java.io.PrintWriter ), 0, this, printWriter);
    }

    public static String streamToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("streamToString", $$robo$$android_media_AudioService$streamToString(int ), 0, (int)n);
    }

    private void updateStreamVolumeAlias(boolean bl) {
        InvokeDynamicSupport.bootstrap("updateStreamVolumeAlias", $$robo$$android_media_AudioService$updateStreamVolumeAlias(boolean ), 0, this, bl);
    }

    private void readDockAudioSettings(ContentResolver contentResolver) {
        InvokeDynamicSupport.bootstrap("readDockAudioSettings", $$robo$$android_media_AudioService$readDockAudioSettings(android.content.ContentResolver ), 0, this, contentResolver);
    }

    private void readPersistedSettings() {
        InvokeDynamicSupport.bootstrap("readPersistedSettings", $$robo$$android_media_AudioService$readPersistedSettings(), 0, this);
    }

    private int rescaleIndex(int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrap("rescaleIndex", $$robo$$android_media_AudioService$rescaleIndex(int int int ), 0, this, n, n2, n3);
    }

    @Override
    public void adjustSuggestedStreamVolume(int n, int n2, int n3, String string2) {
        InvokeDynamicSupport.bootstrap("adjustSuggestedStreamVolume", $$robo$$android_media_AudioService$adjustSuggestedStreamVolume(int int int java.lang.String ), 0, this, n, n2, n3, string2);
    }

    private void adjustSuggestedStreamVolume(int n, int n2, int n3, String string2, int n4) {
        InvokeDynamicSupport.bootstrap("adjustSuggestedStreamVolume", $$robo$$android_media_AudioService$adjustSuggestedStreamVolume(int int int java.lang.String int ), 0, this, n, n2, n3, string2, n4);
    }

    @Override
    public void adjustStreamVolume(int n, int n2, int n3, String string2) {
        InvokeDynamicSupport.bootstrap("adjustStreamVolume", $$robo$$android_media_AudioService$adjustStreamVolume(int int int java.lang.String ), 0, this, n, n2, n3, string2);
    }

    private void adjustStreamVolume(int n, int n2, int n3, String string2, int n4) {
        InvokeDynamicSupport.bootstrap("adjustStreamVolume", $$robo$$android_media_AudioService$adjustStreamVolume(int int int java.lang.String int ), 0, this, n, n2, n3, string2, n4);
    }

    @Override
    public void adjustMasterVolume(int n, int n2, String string2) {
        InvokeDynamicSupport.bootstrap("adjustMasterVolume", $$robo$$android_media_AudioService$adjustMasterVolume(int int java.lang.String ), 0, this, n, n2, string2);
    }

    private void onSetStreamVolume(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onSetStreamVolume", $$robo$$android_media_AudioService$onSetStreamVolume(int int int int ), 0, this, n, n2, n3, n4);
    }

    @Override
    public void setStreamVolume(int n, int n2, int n3, String string2) {
        InvokeDynamicSupport.bootstrap("setStreamVolume", $$robo$$android_media_AudioService$setStreamVolume(int int int java.lang.String ), 0, this, n, n2, n3, string2);
    }

    private void setStreamVolume(int n, int n2, int n3, String string2, int n4) {
        InvokeDynamicSupport.bootstrap("setStreamVolume", $$robo$$android_media_AudioService$setStreamVolume(int int int java.lang.String int ), 0, this, n, n2, n3, string2, n4);
    }

    @Override
    public void forceVolumeControlStream(int n, IBinder iBinder) {
        InvokeDynamicSupport.bootstrap("forceVolumeControlStream", $$robo$$android_media_AudioService$forceVolumeControlStream(int android.os.IBinder ), 0, this, n, iBinder);
    }

    private int findVolumeDelta(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("findVolumeDelta", $$robo$$android_media_AudioService$findVolumeDelta(int int ), 0, this, n, n2);
    }

    private void sendBroadcastToAll(Intent intent) {
        InvokeDynamicSupport.bootstrap("sendBroadcastToAll", $$robo$$android_media_AudioService$sendBroadcastToAll(android.content.Intent ), 0, this, intent);
    }

    private void sendStickyBroadcastToAll(Intent intent) {
        InvokeDynamicSupport.bootstrap("sendStickyBroadcastToAll", $$robo$$android_media_AudioService$sendStickyBroadcastToAll(android.content.Intent ), 0, this, intent);
    }

    private void sendVolumeUpdate(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("sendVolumeUpdate", $$robo$$android_media_AudioService$sendVolumeUpdate(int int int int ), 0, this, n, n2, n3, n4);
    }

    private void sendMasterVolumeUpdate(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("sendMasterVolumeUpdate", $$robo$$android_media_AudioService$sendMasterVolumeUpdate(int int int ), 0, this, n, n2, n3);
    }

    private void sendMasterMuteUpdate(boolean bl, int n) {
        InvokeDynamicSupport.bootstrap("sendMasterMuteUpdate", $$robo$$android_media_AudioService$sendMasterMuteUpdate(boolean int ), 0, this, bl, n);
    }

    private void broadcastMasterMuteStatus(boolean bl) {
        InvokeDynamicSupport.bootstrap("broadcastMasterMuteStatus", $$robo$$android_media_AudioService$broadcastMasterMuteStatus(boolean ), 0, this, bl);
    }

    private void setStreamVolumeInt(int n, int n2, int n3, boolean bl) {
        InvokeDynamicSupport.bootstrap("setStreamVolumeInt", $$robo$$android_media_AudioService$setStreamVolumeInt(int int int boolean ), 0, this, n, n2, n3, bl);
    }

    @Override
    public void setStreamSolo(int n, boolean bl, IBinder iBinder) {
        InvokeDynamicSupport.bootstrap("setStreamSolo", $$robo$$android_media_AudioService$setStreamSolo(int boolean android.os.IBinder ), 0, this, n, bl, iBinder);
    }

    @Override
    public void setStreamMute(int n, boolean bl, IBinder iBinder) {
        InvokeDynamicSupport.bootstrap("setStreamMute", $$robo$$android_media_AudioService$setStreamMute(int boolean android.os.IBinder ), 0, this, n, bl, iBinder);
    }

    @Override
    public boolean isStreamMute(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isStreamMute", $$robo$$android_media_AudioService$isStreamMute(int ), 0, this, n);
    }

    private boolean discardRmtSbmxFullVolDeathHandlerFor(IBinder iBinder) {
        return (boolean)InvokeDynamicSupport.bootstrap("discardRmtSbmxFullVolDeathHandlerFor", $$robo$$android_media_AudioService$discardRmtSbmxFullVolDeathHandlerFor(android.os.IBinder ), 0, this, iBinder);
    }

    private boolean hasRmtSbmxFullVolDeathHandlerFor(IBinder iBinder) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasRmtSbmxFullVolDeathHandlerFor", $$robo$$android_media_AudioService$hasRmtSbmxFullVolDeathHandlerFor(android.os.IBinder ), 0, this, iBinder);
    }

    @Override
    public void forceRemoteSubmixFullVolume(boolean bl, IBinder iBinder) {
        InvokeDynamicSupport.bootstrap("forceRemoteSubmixFullVolume", $$robo$$android_media_AudioService$forceRemoteSubmixFullVolume(boolean android.os.IBinder ), 0, this, bl, iBinder);
    }

    @Override
    public void setMasterMute(boolean bl, int n, String string2, IBinder iBinder) {
        InvokeDynamicSupport.bootstrap("setMasterMute", $$robo$$android_media_AudioService$setMasterMute(boolean int java.lang.String android.os.IBinder ), 0, this, bl, n, string2, iBinder);
    }

    @Override
    public boolean isMasterMute() {
        return (boolean)InvokeDynamicSupport.bootstrap("isMasterMute", $$robo$$android_media_AudioService$isMasterMute(), 0, this);
    }

    protected static int getMaxStreamVolume(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getMaxStreamVolume", $$robo$$android_media_AudioService$getMaxStreamVolume(int ), 0, (int)n);
    }

    @Override
    public int getStreamVolume(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getStreamVolume", $$robo$$android_media_AudioService$getStreamVolume(int ), 0, this, n);
    }

    @Override
    public int getMasterVolume() {
        return (int)InvokeDynamicSupport.bootstrap("getMasterVolume", $$robo$$android_media_AudioService$getMasterVolume(), 0, this);
    }

    @Override
    public void setMasterVolume(int n, int n2, String string2) {
        InvokeDynamicSupport.bootstrap("setMasterVolume", $$robo$$android_media_AudioService$setMasterVolume(int int java.lang.String ), 0, this, n, n2, string2);
    }

    private void doSetMasterVolume(float f, int n) {
        InvokeDynamicSupport.bootstrap("doSetMasterVolume", $$robo$$android_media_AudioService$doSetMasterVolume(float int ), 0, this, f, n);
    }

    @Override
    public int getStreamMaxVolume(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getStreamMaxVolume", $$robo$$android_media_AudioService$getStreamMaxVolume(int ), 0, this, n);
    }

    @Override
    public int getMasterMaxVolume() {
        return (int)InvokeDynamicSupport.bootstrap("getMasterMaxVolume", $$robo$$android_media_AudioService$getMasterMaxVolume(), 0, this);
    }

    @Override
    public int getLastAudibleStreamVolume(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getLastAudibleStreamVolume", $$robo$$android_media_AudioService$getLastAudibleStreamVolume(int ), 0, this, n);
    }

    @Override
    public int getLastAudibleMasterVolume() {
        return (int)InvokeDynamicSupport.bootstrap("getLastAudibleMasterVolume", $$robo$$android_media_AudioService$getLastAudibleMasterVolume(), 0, this);
    }

    @Override
    public int getMasterStreamType() {
        return (int)InvokeDynamicSupport.bootstrap("getMasterStreamType", $$robo$$android_media_AudioService$getMasterStreamType(), 0, this);
    }

    @Override
    public void setMicrophoneMute(boolean bl, String string2) {
        InvokeDynamicSupport.bootstrap("setMicrophoneMute", $$robo$$android_media_AudioService$setMicrophoneMute(boolean java.lang.String ), 0, this, bl, string2);
    }

    @Override
    public int getRingerMode() {
        return (int)InvokeDynamicSupport.bootstrap("getRingerMode", $$robo$$android_media_AudioService$getRingerMode(), 0, this);
    }

    private void ensureValidRingerMode(int n) {
        InvokeDynamicSupport.bootstrap("ensureValidRingerMode", $$robo$$android_media_AudioService$ensureValidRingerMode(int ), 0, this, n);
    }

    @Override
    public void setRingerMode(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("setRingerMode", $$robo$$android_media_AudioService$setRingerMode(int boolean ), 0, this, n, bl);
    }

    private void checkZen(int n) {
        InvokeDynamicSupport.bootstrap("checkZen", $$robo$$android_media_AudioService$checkZen(int ), 0, this, n);
    }

    private void setRingerModeInt(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("setRingerModeInt", $$robo$$android_media_AudioService$setRingerModeInt(int boolean ), 0, this, n, bl);
    }

    private void restoreMasterVolume() {
        InvokeDynamicSupport.bootstrap("restoreMasterVolume", $$robo$$android_media_AudioService$restoreMasterVolume(), 0, this);
    }

    @Override
    public boolean shouldVibrate(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldVibrate", $$robo$$android_media_AudioService$shouldVibrate(int ), 0, this, n);
    }

    @Override
    public int getVibrateSetting(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getVibrateSetting", $$robo$$android_media_AudioService$getVibrateSetting(int ), 0, this, n);
    }

    @Override
    public void setVibrateSetting(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setVibrateSetting", $$robo$$android_media_AudioService$setVibrateSetting(int int ), 0, this, n, n2);
    }

    public static int getValueForVibrateSetting(int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getValueForVibrateSetting", $$robo$$android_media_AudioService$getValueForVibrateSetting(int int int ), 0, (int)n, (int)n2, (int)n3);
    }

    @Override
    public void setMode(int n, IBinder iBinder) {
        InvokeDynamicSupport.bootstrap("setMode", $$robo$$android_media_AudioService$setMode(int android.os.IBinder ), 0, this, n, iBinder);
    }

    private int setModeInt(int n, IBinder iBinder, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("setModeInt", $$robo$$android_media_AudioService$setModeInt(int android.os.IBinder int ), 0, this, n, iBinder, n2);
    }

    @Override
    public int getMode() {
        return (int)InvokeDynamicSupport.bootstrap("getMode", $$robo$$android_media_AudioService$getMode(), 0, this);
    }

    private void loadTouchSoundAssetDefaults() {
        InvokeDynamicSupport.bootstrap("loadTouchSoundAssetDefaults", $$robo$$android_media_AudioService$loadTouchSoundAssetDefaults(), 0, this);
    }

    private void loadTouchSoundAssets() {
        InvokeDynamicSupport.bootstrap("loadTouchSoundAssets", $$robo$$android_media_AudioService$loadTouchSoundAssets(), 0, this);
    }

    @Override
    public void playSoundEffect(int n) {
        InvokeDynamicSupport.bootstrap("playSoundEffect", $$robo$$android_media_AudioService$playSoundEffect(int ), 0, this, n);
    }

    @Override
    public void playSoundEffectVolume(int n, float f) {
        InvokeDynamicSupport.bootstrap("playSoundEffectVolume", $$robo$$android_media_AudioService$playSoundEffectVolume(int float ), 0, this, n, f);
    }

    @Override
    public boolean loadSoundEffects() {
        return (boolean)InvokeDynamicSupport.bootstrap("loadSoundEffects", $$robo$$android_media_AudioService$loadSoundEffects(), 0, this);
    }

    @Override
    public void unloadSoundEffects() {
        InvokeDynamicSupport.bootstrap("unloadSoundEffects", $$robo$$android_media_AudioService$unloadSoundEffects(), 0, this);
    }

    @Override
    public void reloadAudioSettings() {
        InvokeDynamicSupport.bootstrap("reloadAudioSettings", $$robo$$android_media_AudioService$reloadAudioSettings(), 0, this);
    }

    private void readAudioSettings(boolean bl) {
        InvokeDynamicSupport.bootstrap("readAudioSettings", $$robo$$android_media_AudioService$readAudioSettings(boolean ), 0, this, bl);
    }

    @Override
    public void setSpeakerphoneOn(boolean bl) {
        InvokeDynamicSupport.bootstrap("setSpeakerphoneOn", $$robo$$android_media_AudioService$setSpeakerphoneOn(boolean ), 0, this, bl);
    }

    @Override
    public boolean isSpeakerphoneOn() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSpeakerphoneOn", $$robo$$android_media_AudioService$isSpeakerphoneOn(), 0, this);
    }

    @Override
    public void setBluetoothScoOn(boolean bl) {
        InvokeDynamicSupport.bootstrap("setBluetoothScoOn", $$robo$$android_media_AudioService$setBluetoothScoOn(boolean ), 0, this, bl);
    }

    @Override
    public boolean isBluetoothScoOn() {
        return (boolean)InvokeDynamicSupport.bootstrap("isBluetoothScoOn", $$robo$$android_media_AudioService$isBluetoothScoOn(), 0, this);
    }

    @Override
    public void setBluetoothA2dpOn(boolean bl) {
        InvokeDynamicSupport.bootstrap("setBluetoothA2dpOn", $$robo$$android_media_AudioService$setBluetoothA2dpOn(boolean ), 0, this, bl);
    }

    @Override
    public boolean isBluetoothA2dpOn() {
        return (boolean)InvokeDynamicSupport.bootstrap("isBluetoothA2dpOn", $$robo$$android_media_AudioService$isBluetoothA2dpOn(), 0, this);
    }

    @Override
    public void startBluetoothSco(IBinder iBinder, int n) {
        InvokeDynamicSupport.bootstrap("startBluetoothSco", $$robo$$android_media_AudioService$startBluetoothSco(android.os.IBinder int ), 0, this, iBinder, n);
    }

    @Override
    public void startBluetoothScoVirtualCall(IBinder iBinder) {
        InvokeDynamicSupport.bootstrap("startBluetoothScoVirtualCall", $$robo$$android_media_AudioService$startBluetoothScoVirtualCall(android.os.IBinder ), 0, this, iBinder);
    }

    void startBluetoothScoInt(IBinder iBinder, int n) {
        InvokeDynamicSupport.bootstrap("startBluetoothScoInt", $$robo$$android_media_AudioService$startBluetoothScoInt(android.os.IBinder int ), 0, this, iBinder, n);
    }

    @Override
    public void stopBluetoothSco(IBinder iBinder) {
        InvokeDynamicSupport.bootstrap("stopBluetoothSco", $$robo$$android_media_AudioService$stopBluetoothSco(android.os.IBinder ), 0, this, iBinder);
    }

    private void checkScoAudioState() {
        InvokeDynamicSupport.bootstrap("checkScoAudioState", $$robo$$android_media_AudioService$checkScoAudioState(), 0, this);
    }

    private ScoClient getScoClient(IBinder iBinder, boolean bl) {
        return InvokeDynamicSupport.bootstrap("getScoClient", $$robo$$android_media_AudioService$getScoClient(android.os.IBinder boolean ), 0, this, iBinder, bl);
    }

    public void clearAllScoClients(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("clearAllScoClients", $$robo$$android_media_AudioService$clearAllScoClients(int boolean ), 0, this, n, bl);
    }

    private boolean getBluetoothHeadset() {
        return (boolean)InvokeDynamicSupport.bootstrap("getBluetoothHeadset", $$robo$$android_media_AudioService$getBluetoothHeadset(), 0, this);
    }

    private void disconnectBluetoothSco(int n) {
        InvokeDynamicSupport.bootstrap("disconnectBluetoothSco", $$robo$$android_media_AudioService$disconnectBluetoothSco(int ), 0, this, n);
    }

    private void resetBluetoothSco() {
        InvokeDynamicSupport.bootstrap("resetBluetoothSco", $$robo$$android_media_AudioService$resetBluetoothSco(), 0, this);
    }

    private void broadcastScoConnectionState(int n) {
        InvokeDynamicSupport.bootstrap("broadcastScoConnectionState", $$robo$$android_media_AudioService$broadcastScoConnectionState(int ), 0, this, n);
    }

    private void onBroadcastScoConnectionState(int n) {
        InvokeDynamicSupport.bootstrap("onBroadcastScoConnectionState", $$robo$$android_media_AudioService$onBroadcastScoConnectionState(int ), 0, this, n);
    }

    private void onCheckMusicActive() {
        InvokeDynamicSupport.bootstrap("onCheckMusicActive", $$robo$$android_media_AudioService$onCheckMusicActive(), 0, this);
    }

    private void saveMusicActiveMs() {
        InvokeDynamicSupport.bootstrap("saveMusicActiveMs", $$robo$$android_media_AudioService$saveMusicActiveMs(), 0, this);
    }

    private void onConfigureSafeVolume(boolean bl) {
        InvokeDynamicSupport.bootstrap("onConfigureSafeVolume", $$robo$$android_media_AudioService$onConfigureSafeVolume(boolean ), 0, this, bl);
    }

    private int checkForRingerModeChange(int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrap("checkForRingerModeChange", $$robo$$android_media_AudioService$checkForRingerModeChange(int int int ), 0, this, n, n2, n3);
    }

    @Override
    public boolean isStreamAffectedByRingerMode(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isStreamAffectedByRingerMode", $$robo$$android_media_AudioService$isStreamAffectedByRingerMode(int ), 0, this, n);
    }

    private boolean isStreamMutedByRingerMode(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isStreamMutedByRingerMode", $$robo$$android_media_AudioService$isStreamMutedByRingerMode(int ), 0, this, n);
    }

    boolean updateRingerModeAffectedStreams() {
        return (boolean)InvokeDynamicSupport.bootstrap("updateRingerModeAffectedStreams", $$robo$$android_media_AudioService$updateRingerModeAffectedStreams(), 0, this);
    }

    public boolean isStreamAffectedByMute(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isStreamAffectedByMute", $$robo$$android_media_AudioService$isStreamAffectedByMute(int ), 0, this, n);
    }

    private void ensureValidDirection(int n) {
        InvokeDynamicSupport.bootstrap("ensureValidDirection", $$robo$$android_media_AudioService$ensureValidDirection(int ), 0, this, n);
    }

    private void ensureValidSteps(int n) {
        InvokeDynamicSupport.bootstrap("ensureValidSteps", $$robo$$android_media_AudioService$ensureValidSteps(int ), 0, this, n);
    }

    private void ensureValidStreamType(int n) {
        InvokeDynamicSupport.bootstrap("ensureValidStreamType", $$robo$$android_media_AudioService$ensureValidStreamType(int ), 0, this, n);
    }

    private boolean isInCommunication() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInCommunication", $$robo$$android_media_AudioService$isInCommunication(), 0, this);
    }

    private boolean isAfMusicActiveRecently(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isAfMusicActiveRecently", $$robo$$android_media_AudioService$isAfMusicActiveRecently(int ), 0, this, n);
    }

    private int getActiveStreamType(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getActiveStreamType", $$robo$$android_media_AudioService$getActiveStreamType(int ), 0, this, n);
    }

    private void broadcastRingerMode(int n) {
        InvokeDynamicSupport.bootstrap("broadcastRingerMode", $$robo$$android_media_AudioService$broadcastRingerMode(int ), 0, this, n);
    }

    private void broadcastVibrateSetting(int n) {
        InvokeDynamicSupport.bootstrap("broadcastVibrateSetting", $$robo$$android_media_AudioService$broadcastVibrateSetting(int ), 0, this, n);
    }

    private void queueMsgUnderWakeLock(Handler handler, int n, int n2, int n3, Object object, int n4) {
        InvokeDynamicSupport.bootstrap("queueMsgUnderWakeLock", $$robo$$android_media_AudioService$queueMsgUnderWakeLock(android.os.Handler int int int java.lang.Object int ), 0, this, handler, n, n2, n3, object, n4);
    }

    private static void sendMsg(Handler handler, int n, int n2, int n3, int n4, Object object, int n5) {
        InvokeDynamicSupport.bootstrapStatic("sendMsg", $$robo$$android_media_AudioService$sendMsg(android.os.Handler int int int int java.lang.Object int ), 0, (Handler)handler, (int)n, (int)n2, (int)n3, (int)n4, (Object)object, (int)n5);
    }

    boolean checkAudioSettingsPermission(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("checkAudioSettingsPermission", $$robo$$android_media_AudioService$checkAudioSettingsPermission(java.lang.String ), 0, this, string2);
    }

    private int getDeviceForStream(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getDeviceForStream", $$robo$$android_media_AudioService$getDeviceForStream(int ), 0, this, n);
    }

    @Override
    public void setWiredDeviceConnectionState(int n, int n2, String string2) {
        InvokeDynamicSupport.bootstrap("setWiredDeviceConnectionState", $$robo$$android_media_AudioService$setWiredDeviceConnectionState(int int java.lang.String ), 0, this, n, n2, string2);
    }

    @Override
    public int setBluetoothA2dpDeviceConnectionState(BluetoothDevice bluetoothDevice, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("setBluetoothA2dpDeviceConnectionState", $$robo$$android_media_AudioService$setBluetoothA2dpDeviceConnectionState(android.bluetooth.BluetoothDevice int int ), 0, this, bluetoothDevice, n, n2);
    }

    private void makeA2dpDeviceAvailable(String string2) {
        InvokeDynamicSupport.bootstrap("makeA2dpDeviceAvailable", $$robo$$android_media_AudioService$makeA2dpDeviceAvailable(java.lang.String ), 0, this, string2);
    }

    private void onSendBecomingNoisyIntent() {
        InvokeDynamicSupport.bootstrap("onSendBecomingNoisyIntent", $$robo$$android_media_AudioService$onSendBecomingNoisyIntent(), 0, this);
    }

    private void makeA2dpDeviceUnavailableNow(String string2) {
        InvokeDynamicSupport.bootstrap("makeA2dpDeviceUnavailableNow", $$robo$$android_media_AudioService$makeA2dpDeviceUnavailableNow(java.lang.String ), 0, this, string2);
    }

    private void makeA2dpDeviceUnavailableLater(String string2) {
        InvokeDynamicSupport.bootstrap("makeA2dpDeviceUnavailableLater", $$robo$$android_media_AudioService$makeA2dpDeviceUnavailableLater(java.lang.String ), 0, this, string2);
    }

    private void makeA2dpSrcAvailable(String string2) {
        InvokeDynamicSupport.bootstrap("makeA2dpSrcAvailable", $$robo$$android_media_AudioService$makeA2dpSrcAvailable(java.lang.String ), 0, this, string2);
    }

    private void makeA2dpSrcUnavailable(String string2) {
        InvokeDynamicSupport.bootstrap("makeA2dpSrcUnavailable", $$robo$$android_media_AudioService$makeA2dpSrcUnavailable(java.lang.String ), 0, this, string2);
    }

    private void cancelA2dpDeviceTimeout() {
        InvokeDynamicSupport.bootstrap("cancelA2dpDeviceTimeout", $$robo$$android_media_AudioService$cancelA2dpDeviceTimeout(), 0, this);
    }

    private boolean hasScheduledA2dpDockTimeout() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasScheduledA2dpDockTimeout", $$robo$$android_media_AudioService$hasScheduledA2dpDockTimeout(), 0, this);
    }

    private void onSetA2dpSinkConnectionState(BluetoothDevice bluetoothDevice, int n) {
        InvokeDynamicSupport.bootstrap("onSetA2dpSinkConnectionState", $$robo$$android_media_AudioService$onSetA2dpSinkConnectionState(android.bluetooth.BluetoothDevice int ), 0, this, bluetoothDevice, n);
    }

    private void onSetA2dpSourceConnectionState(BluetoothDevice bluetoothDevice, int n) {
        InvokeDynamicSupport.bootstrap("onSetA2dpSourceConnectionState", $$robo$$android_media_AudioService$onSetA2dpSourceConnectionState(android.bluetooth.BluetoothDevice int ), 0, this, bluetoothDevice, n);
    }

    @Override
    public void avrcpSupportsAbsoluteVolume(String string2, boolean bl) {
        InvokeDynamicSupport.bootstrap("avrcpSupportsAbsoluteVolume", $$robo$$android_media_AudioService$avrcpSupportsAbsoluteVolume(java.lang.String boolean ), 0, this, string2, bl);
    }

    private boolean handleDeviceConnection(boolean bl, int n, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("handleDeviceConnection", $$robo$$android_media_AudioService$handleDeviceConnection(boolean int java.lang.String ), 0, this, bl, n, string2);
    }

    private int checkSendBecomingNoisyIntent(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("checkSendBecomingNoisyIntent", $$robo$$android_media_AudioService$checkSendBecomingNoisyIntent(int int ), 0, this, n, n2);
    }

    private void sendDeviceConnectionIntent(int n, int n2, String string2) {
        InvokeDynamicSupport.bootstrap("sendDeviceConnectionIntent", $$robo$$android_media_AudioService$sendDeviceConnectionIntent(int int java.lang.String ), 0, this, n, n2, string2);
    }

    private void onSetWiredDeviceConnectionState(int n, int n2, String string2) {
        InvokeDynamicSupport.bootstrap("onSetWiredDeviceConnectionState", $$robo$$android_media_AudioService$onSetWiredDeviceConnectionState(int int java.lang.String ), 0, this, n, n2, string2);
    }

    private void configureHdmiPlugIntent(Intent intent, int n) {
        InvokeDynamicSupport.bootstrap("configureHdmiPlugIntent", $$robo$$android_media_AudioService$configureHdmiPlugIntent(android.content.Intent int ), 0, this, intent, n);
    }

    @Override
    public boolean registerRemoteController(IRemoteControlDisplay iRemoteControlDisplay, int n, int n2, ComponentName componentName) {
        return (boolean)InvokeDynamicSupport.bootstrap("registerRemoteController", $$robo$$android_media_AudioService$registerRemoteController(android.media.IRemoteControlDisplay int int android.content.ComponentName ), 0, this, iRemoteControlDisplay, n, n2, componentName);
    }

    @Override
    public boolean registerRemoteControlDisplay(IRemoteControlDisplay iRemoteControlDisplay, int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("registerRemoteControlDisplay", $$robo$$android_media_AudioService$registerRemoteControlDisplay(android.media.IRemoteControlDisplay int int ), 0, this, iRemoteControlDisplay, n, n2);
    }

    @Override
    public void unregisterRemoteControlDisplay(IRemoteControlDisplay iRemoteControlDisplay) {
        InvokeDynamicSupport.bootstrap("unregisterRemoteControlDisplay", $$robo$$android_media_AudioService$unregisterRemoteControlDisplay(android.media.IRemoteControlDisplay ), 0, this, iRemoteControlDisplay);
    }

    @Override
    public void remoteControlDisplayUsesBitmapSize(IRemoteControlDisplay iRemoteControlDisplay, int n, int n2) {
        InvokeDynamicSupport.bootstrap("remoteControlDisplayUsesBitmapSize", $$robo$$android_media_AudioService$remoteControlDisplayUsesBitmapSize(android.media.IRemoteControlDisplay int int ), 0, this, iRemoteControlDisplay, n, n2);
    }

    @Override
    public void remoteControlDisplayWantsPlaybackPositionSync(IRemoteControlDisplay iRemoteControlDisplay, boolean bl) {
        InvokeDynamicSupport.bootstrap("remoteControlDisplayWantsPlaybackPositionSync", $$robo$$android_media_AudioService$remoteControlDisplayWantsPlaybackPositionSync(android.media.IRemoteControlDisplay boolean ), 0, this, iRemoteControlDisplay, bl);
    }

    @Override
    public void setRemoteStreamVolume(int n) {
        InvokeDynamicSupport.bootstrap("setRemoteStreamVolume", $$robo$$android_media_AudioService$setRemoteStreamVolume(int ), 0, this, n);
    }

    @Override
    public int requestAudioFocus(int n, int n2, IBinder iBinder, IAudioFocusDispatcher iAudioFocusDispatcher, String string2, String string3) {
        return (int)InvokeDynamicSupport.bootstrap("requestAudioFocus", $$robo$$android_media_AudioService$requestAudioFocus(int int android.os.IBinder android.media.IAudioFocusDispatcher java.lang.String java.lang.String ), 0, this, n, n2, iBinder, iAudioFocusDispatcher, string2, string3);
    }

    @Override
    public int abandonAudioFocus(IAudioFocusDispatcher iAudioFocusDispatcher, String string2) {
        return (int)InvokeDynamicSupport.bootstrap("abandonAudioFocus", $$robo$$android_media_AudioService$abandonAudioFocus(android.media.IAudioFocusDispatcher java.lang.String ), 0, this, iAudioFocusDispatcher, string2);
    }

    @Override
    public void unregisterAudioFocusClient(String string2) {
        InvokeDynamicSupport.bootstrap("unregisterAudioFocusClient", $$robo$$android_media_AudioService$unregisterAudioFocusClient(java.lang.String ), 0, this, string2);
    }

    @Override
    public int getCurrentAudioFocus() {
        return (int)InvokeDynamicSupport.bootstrap("getCurrentAudioFocus", $$robo$$android_media_AudioService$getCurrentAudioFocus(), 0, this);
    }

    private void handleConfigurationChanged(Context context) {
        InvokeDynamicSupport.bootstrap("handleConfigurationChanged", $$robo$$android_media_AudioService$handleConfigurationChanged(android.content.Context ), 0, this, context);
    }

    private void setOrientationForAudioSystem() {
        InvokeDynamicSupport.bootstrap("setOrientationForAudioSystem", $$robo$$android_media_AudioService$setOrientationForAudioSystem(), 0, this);
    }

    private void setRotationForAudioSystem() {
        InvokeDynamicSupport.bootstrap("setRotationForAudioSystem", $$robo$$android_media_AudioService$setRotationForAudioSystem(), 0, this);
    }

    public void setBluetoothA2dpOnInt(boolean bl) {
        InvokeDynamicSupport.bootstrap("setBluetoothA2dpOnInt", $$robo$$android_media_AudioService$setBluetoothA2dpOnInt(boolean ), 0, this, bl);
    }

    @Override
    public void setRingtonePlayer(IRingtonePlayer iRingtonePlayer) {
        InvokeDynamicSupport.bootstrap("setRingtonePlayer", $$robo$$android_media_AudioService$setRingtonePlayer(android.media.IRingtonePlayer ), 0, this, iRingtonePlayer);
    }

    @Override
    public IRingtonePlayer getRingtonePlayer() {
        return InvokeDynamicSupport.bootstrap("getRingtonePlayer", $$robo$$android_media_AudioService$getRingtonePlayer(), 0, this);
    }

    @Override
    public AudioRoutesInfo startWatchingRoutes(IAudioRoutesObserver iAudioRoutesObserver) {
        return InvokeDynamicSupport.bootstrap("startWatchingRoutes", $$robo$$android_media_AudioService$startWatchingRoutes(android.media.IAudioRoutesObserver ), 0, this, iAudioRoutesObserver);
    }

    private void setSafeMediaVolumeEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setSafeMediaVolumeEnabled", $$robo$$android_media_AudioService$setSafeMediaVolumeEnabled(boolean ), 0, this, bl);
    }

    private void enforceSafeMediaVolume() {
        InvokeDynamicSupport.bootstrap("enforceSafeMediaVolume", $$robo$$android_media_AudioService$enforceSafeMediaVolume(), 0, this);
    }

    private boolean checkSafeMediaVolume(int n, int n2, int n3) {
        return (boolean)InvokeDynamicSupport.bootstrap("checkSafeMediaVolume", $$robo$$android_media_AudioService$checkSafeMediaVolume(int int int ), 0, this, n, n2, n3);
    }

    @Override
    public void disableSafeMediaVolume() {
        InvokeDynamicSupport.bootstrap("disableSafeMediaVolume", $$robo$$android_media_AudioService$disableSafeMediaVolume(), 0, this);
    }

    @Override
    public int setHdmiSystemAudioSupported(boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("setHdmiSystemAudioSupported", $$robo$$android_media_AudioService$setHdmiSystemAudioSupported(boolean ), 0, this, bl);
    }

    @Override
    public boolean isHdmiSystemAudioSupported() {
        return (boolean)InvokeDynamicSupport.bootstrap("isHdmiSystemAudioSupported", $$robo$$android_media_AudioService$isHdmiSystemAudioSupported(), 0, this);
    }

    @Override
    public boolean isCameraSoundForced() {
        return (boolean)InvokeDynamicSupport.bootstrap("isCameraSoundForced", $$robo$$android_media_AudioService$isCameraSoundForced(), 0, this);
    }

    private void dumpRingerMode(PrintWriter printWriter) {
        InvokeDynamicSupport.bootstrap("dumpRingerMode", $$robo$$android_media_AudioService$dumpRingerMode(java.io.PrintWriter ), 0, this, printWriter);
    }

    @Override
    protected void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_media_AudioService$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), 0, this, fileDescriptor, printWriter, stringArray);
    }

    private static String safeMediaVolumeStateToString(Integer n) {
        return InvokeDynamicSupport.bootstrapStatic("safeMediaVolumeStateToString", $$robo$$android_media_AudioService$safeMediaVolumeStateToString(java.lang.Integer ), 0, (Integer)n);
    }

    private static void readAndSetLowRamDevice() {
        InvokeDynamicSupport.bootstrapStatic("readAndSetLowRamDevice", $$robo$$android_media_AudioService$readAndSetLowRamDevice(), 0);
    }

    private void enforceSelfOrSystemUI(String string2) {
        InvokeDynamicSupport.bootstrap("enforceSelfOrSystemUI", $$robo$$android_media_AudioService$enforceSelfOrSystemUI(java.lang.String ), 0, this, string2);
    }

    @Override
    public void setVolumeController(IVolumeController iVolumeController) {
        InvokeDynamicSupport.bootstrap("setVolumeController", $$robo$$android_media_AudioService$setVolumeController(android.media.IVolumeController ), 0, this, iVolumeController);
    }

    @Override
    public void notifyVolumeControllerVisible(IVolumeController iVolumeController, boolean bl) {
        InvokeDynamicSupport.bootstrap("notifyVolumeControllerVisible", $$robo$$android_media_AudioService$notifyVolumeControllerVisible(android.media.IVolumeController boolean ), 0, this, iVolumeController, bl);
    }

    @Override
    public boolean registerAudioPolicy(AudioPolicyConfig audioPolicyConfig, IBinder iBinder) {
        return (boolean)InvokeDynamicSupport.bootstrap("registerAudioPolicy", $$robo$$android_media_AudioService$registerAudioPolicy(android.media.audiopolicy.AudioPolicyConfig android.os.IBinder ), 0, this, audioPolicyConfig, iBinder);
    }

    @Override
    public void unregisterAudioPolicyAsync(IBinder iBinder) {
        InvokeDynamicSupport.bootstrap("unregisterAudioPolicyAsync", $$robo$$android_media_AudioService$unregisterAudioPolicyAsync(android.os.IBinder ), 0, this, iBinder);
    }

    static {
        RobolectricInternals.classInitializing(AudioService.class);
    }

    public /* synthetic */ AudioService() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AudioService)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public class AudioPolicyProxy
    implements IBinder.DeathRecipient,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static String TAG = "AudioPolicyProxy";
        AudioPolicyConfig mConfig;
        IBinder mToken;
        /* synthetic */ AudioService this$0;

        private void $$robo$$android_media_AudioService_AudioPolicyProxy$__constructor__(AudioService audioService, AudioPolicyConfig config, IBinder token) {
            this.mConfig = config;
            this.mToken = token;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_AudioService_AudioPolicyProxy$binderDied() {
            HashMap hashMap = this.this$0.mAudioPolicies;
            synchronized (hashMap) {
                Log.v("AudioPolicyProxy", "audio policy " + this.mToken + " died");
                this.this$0.mAudioPolicies.remove(this.mToken);
            }
        }

        private void __constructor__(AudioService audioService, AudioPolicyConfig audioPolicyConfig, IBinder iBinder) {
            this.$$robo$$android_media_AudioService_AudioPolicyProxy$__constructor__(audioService, audioPolicyConfig, iBinder);
        }

        AudioPolicyProxy(AudioService audioService, AudioPolicyConfig audioPolicyConfig, IBinder iBinder) {
            this.this$0 = audioService;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioService_AudioPolicyProxy$__constructor__(android.media.AudioService android.media.audiopolicy.AudioPolicyConfig android.os.IBinder ), 0, this, audioService, audioPolicyConfig, iBinder);
        }

        @Override
        public void binderDied() {
            InvokeDynamicSupport.bootstrap("binderDied", $$robo$$android_media_AudioService_AudioPolicyProxy$binderDied(), 0, this);
        }

        public /* synthetic */ AudioPolicyProxy() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AudioPolicyProxy)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public final class AudioServiceInternal
    extends AudioManagerInternal
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ AudioService this$0;

        private void $$robo$$android_media_AudioService_AudioServiceInternal$__constructor__(AudioService audioService) {
        }

        private final void $$robo$$android_media_AudioService_AudioServiceInternal$adjustSuggestedStreamVolumeForUid(int streamType, int direction, int flags, String callingPackage, int uid) {
            this.this$0.adjustSuggestedStreamVolume(direction, streamType, flags, callingPackage, uid);
        }

        private final void $$robo$$android_media_AudioService_AudioServiceInternal$adjustStreamVolumeForUid(int streamType, int direction, int flags, String callingPackage, int uid) {
            this.this$0.adjustStreamVolume(streamType, direction, flags, callingPackage, uid);
        }

        private final void $$robo$$android_media_AudioService_AudioServiceInternal$setStreamVolumeForUid(int streamType, int direction, int flags, String callingPackage, int uid) {
            this.this$0.setStreamVolume(streamType, direction, flags, callingPackage, uid);
        }

        private void __constructor__(AudioService audioService) {
            this.$$robo$$android_media_AudioService_AudioServiceInternal$__constructor__(audioService);
        }

        AudioServiceInternal(AudioService audioService) {
            this.this$0 = audioService;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioService_AudioServiceInternal$__constructor__(android.media.AudioService ), 0, this, audioService);
        }

        @Override
        public void adjustSuggestedStreamVolumeForUid(int n, int n2, int n3, String string2, int n4) {
            InvokeDynamicSupport.bootstrap("adjustSuggestedStreamVolumeForUid", $$robo$$android_media_AudioService_AudioServiceInternal$adjustSuggestedStreamVolumeForUid(int int int java.lang.String int ), 0, this, n, n2, n3, string2, n4);
        }

        @Override
        public void adjustStreamVolumeForUid(int n, int n2, int n3, String string2, int n4) {
            InvokeDynamicSupport.bootstrap("adjustStreamVolumeForUid", $$robo$$android_media_AudioService_AudioServiceInternal$adjustStreamVolumeForUid(int int int java.lang.String int ), 0, this, n, n2, n3, string2, n4);
        }

        @Override
        public void setStreamVolumeForUid(int n, int n2, int n3, String string2, int n4) {
            InvokeDynamicSupport.bootstrap("setStreamVolumeForUid", $$robo$$android_media_AudioService_AudioServiceInternal$setStreamVolumeForUid(int int int java.lang.String int ), 0, this, n, n2, n3, string2, n4);
        }

        public /* synthetic */ AudioServiceInternal() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AudioServiceInternal)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class VolumeController
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static String TAG = "VolumeController";
        private IVolumeController mController;
        private boolean mVisible;
        private long mNextLongPress;
        private int mLongPressTimeout;

        private void $$robo$$android_media_AudioService_VolumeController$__constructor__() {
        }

        private final void $$robo$$android_media_AudioService_VolumeController$setController(IVolumeController controller) {
            this.mController = controller;
            this.mVisible = false;
        }

        private final void $$robo$$android_media_AudioService_VolumeController$loadSettings(ContentResolver cr) {
            this.mLongPressTimeout = Settings.Secure.getIntForUser(cr, "long_press_timeout", 500, -2);
        }

        private final boolean $$robo$$android_media_AudioService_VolumeController$suppressAdjustment(int resolvedStream, int flags) {
            boolean suppress = false;
            if (resolvedStream == 2 && this.mController != null) {
                long now = SystemClock.uptimeMillis();
                if ((flags & 1) != 0 && !this.mVisible) {
                    if (this.mNextLongPress < now) {
                        this.mNextLongPress = now + (long)this.mLongPressTimeout;
                    }
                    suppress = true;
                } else if (this.mNextLongPress > 0L) {
                    if (now > this.mNextLongPress) {
                        this.mNextLongPress = 0L;
                    } else {
                        suppress = true;
                    }
                }
            }
            return suppress;
        }

        private final void $$robo$$android_media_AudioService_VolumeController$setVisible(boolean visible) {
            this.mVisible = visible;
        }

        private final boolean $$robo$$android_media_AudioService_VolumeController$isSameBinder(IVolumeController controller) {
            return Objects.equals(this.asBinder(), VolumeController.binder(controller));
        }

        private final IBinder $$robo$$android_media_AudioService_VolumeController$asBinder() {
            return VolumeController.binder(this.mController);
        }

        private static final IBinder $$robo$$android_media_AudioService_VolumeController$binder(IVolumeController controller) {
            return controller == null ? null : controller.asBinder();
        }

        private final String $$robo$$android_media_AudioService_VolumeController$toString() {
            return "VolumeController(" + this.asBinder() + ",mVisible=" + this.mVisible + ")";
        }

        private final void $$robo$$android_media_AudioService_VolumeController$postDisplaySafeVolumeWarning(int flags) {
            if (this.mController == null) {
                return;
            }
            try {
                this.mController.displaySafeVolumeWarning(flags);
            }
            catch (RemoteException e) {
                Log.w("VolumeController", "Error calling displaySafeVolumeWarning", e);
            }
        }

        private final void $$robo$$android_media_AudioService_VolumeController$postVolumeChanged(int streamType, int flags) {
            if (this.mController == null) {
                return;
            }
            try {
                this.mController.volumeChanged(streamType, flags);
            }
            catch (RemoteException e) {
                Log.w("VolumeController", "Error calling volumeChanged", e);
            }
        }

        private final void $$robo$$android_media_AudioService_VolumeController$postMasterVolumeChanged(int flags) {
            if (this.mController == null) {
                return;
            }
            try {
                this.mController.masterVolumeChanged(flags);
            }
            catch (RemoteException e) {
                Log.w("VolumeController", "Error calling masterVolumeChanged", e);
            }
        }

        private final void $$robo$$android_media_AudioService_VolumeController$postMasterMuteChanged(int flags) {
            if (this.mController == null) {
                return;
            }
            try {
                this.mController.masterMuteChanged(flags);
            }
            catch (RemoteException e) {
                Log.w("VolumeController", "Error calling masterMuteChanged", e);
            }
        }

        private final void $$robo$$android_media_AudioService_VolumeController$setLayoutDirection(int layoutDirection) {
            if (this.mController == null) {
                return;
            }
            try {
                this.mController.setLayoutDirection(layoutDirection);
            }
            catch (RemoteException e) {
                Log.w("VolumeController", "Error calling setLayoutDirection", e);
            }
        }

        private final void $$robo$$android_media_AudioService_VolumeController$postDismiss() {
            if (this.mController == null) {
                return;
            }
            try {
                this.mController.dismiss();
            }
            catch (RemoteException e) {
                Log.w("VolumeController", "Error calling dismiss", e);
            }
        }

        private void __constructor__() {
            this.$$robo$$android_media_AudioService_VolumeController$__constructor__();
        }

        public VolumeController() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioService_VolumeController$__constructor__(), 0, this);
        }

        public void setController(IVolumeController iVolumeController) {
            InvokeDynamicSupport.bootstrap("setController", $$robo$$android_media_AudioService_VolumeController$setController(android.media.IVolumeController ), 0, this, iVolumeController);
        }

        public void loadSettings(ContentResolver contentResolver) {
            InvokeDynamicSupport.bootstrap("loadSettings", $$robo$$android_media_AudioService_VolumeController$loadSettings(android.content.ContentResolver ), 0, this, contentResolver);
        }

        public boolean suppressAdjustment(int n, int n2) {
            return (boolean)InvokeDynamicSupport.bootstrap("suppressAdjustment", $$robo$$android_media_AudioService_VolumeController$suppressAdjustment(int int ), 0, this, n, n2);
        }

        public void setVisible(boolean bl) {
            InvokeDynamicSupport.bootstrap("setVisible", $$robo$$android_media_AudioService_VolumeController$setVisible(boolean ), 0, this, bl);
        }

        public boolean isSameBinder(IVolumeController iVolumeController) {
            return (boolean)InvokeDynamicSupport.bootstrap("isSameBinder", $$robo$$android_media_AudioService_VolumeController$isSameBinder(android.media.IVolumeController ), 0, this, iVolumeController);
        }

        public IBinder asBinder() {
            return InvokeDynamicSupport.bootstrap("asBinder", $$robo$$android_media_AudioService_VolumeController$asBinder(), 0, this);
        }

        private static IBinder binder(IVolumeController iVolumeController) {
            return InvokeDynamicSupport.bootstrapStatic("binder", $$robo$$android_media_AudioService_VolumeController$binder(android.media.IVolumeController ), 0, (IVolumeController)iVolumeController);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_media_AudioService_VolumeController$toString(), 0, this);
        }

        public void postDisplaySafeVolumeWarning(int n) {
            InvokeDynamicSupport.bootstrap("postDisplaySafeVolumeWarning", $$robo$$android_media_AudioService_VolumeController$postDisplaySafeVolumeWarning(int ), 0, this, n);
        }

        public void postVolumeChanged(int n, int n2) {
            InvokeDynamicSupport.bootstrap("postVolumeChanged", $$robo$$android_media_AudioService_VolumeController$postVolumeChanged(int int ), 0, this, n, n2);
        }

        public void postMasterVolumeChanged(int n) {
            InvokeDynamicSupport.bootstrap("postMasterVolumeChanged", $$robo$$android_media_AudioService_VolumeController$postMasterVolumeChanged(int ), 0, this, n);
        }

        public void postMasterMuteChanged(int n) {
            InvokeDynamicSupport.bootstrap("postMasterMuteChanged", $$robo$$android_media_AudioService_VolumeController$postMasterMuteChanged(int ), 0, this, n);
        }

        public void setLayoutDirection(int n) {
            InvokeDynamicSupport.bootstrap("setLayoutDirection", $$robo$$android_media_AudioService_VolumeController$setLayoutDirection(int ), 0, this, n);
        }

        public void postDismiss() {
            InvokeDynamicSupport.bootstrap("postDismiss", $$robo$$android_media_AudioService_VolumeController$postDismiss(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (VolumeController)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class StreamOverride
    implements AccessibilityManager.TouchExplorationStateChangeListener,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int DEFAULT_STREAM_TYPE_OVERRIDE_DELAY_MS = 5000;
        private static int TOUCH_EXPLORE_STREAM_TYPE_OVERRIDE_DELAY_MS = 1000;
        static int sDelayMs;

        private void $$robo$$android_media_AudioService_StreamOverride$__constructor__() {
        }

        private static final void $$robo$$android_media_AudioService_StreamOverride$init(Context ctxt) {
            AccessibilityManager accessibilityManager = (AccessibilityManager)ctxt.getSystemService("accessibility");
            StreamOverride.updateDefaultStreamOverrideDelay(accessibilityManager.isTouchExplorationEnabled());
            accessibilityManager.addTouchExplorationStateChangeListener(new StreamOverride());
        }

        private final void $$robo$$android_media_AudioService_StreamOverride$onTouchExplorationStateChanged(boolean enabled) {
            StreamOverride.updateDefaultStreamOverrideDelay(enabled);
        }

        private static final void $$robo$$android_media_AudioService_StreamOverride$updateDefaultStreamOverrideDelay(boolean touchExploreEnabled) {
            sDelayMs = touchExploreEnabled ? 1000 : 5000;
            if (DEBUG_VOL) {
                Log.d("AudioService", "Touch exploration enabled=" + touchExploreEnabled + " stream override delay is now " + sDelayMs + " ms");
            }
        }

        private void __constructor__() {
            this.$$robo$$android_media_AudioService_StreamOverride$__constructor__();
        }

        private StreamOverride() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioService_StreamOverride$__constructor__(), 0, this);
        }

        static void init(Context context) {
            InvokeDynamicSupport.bootstrapStatic("init", $$robo$$android_media_AudioService_StreamOverride$init(android.content.Context ), 0, (Context)context);
        }

        @Override
        public void onTouchExplorationStateChanged(boolean bl) {
            InvokeDynamicSupport.bootstrap("onTouchExplorationStateChanged", $$robo$$android_media_AudioService_StreamOverride$onTouchExplorationStateChanged(boolean ), 0, this, bl);
        }

        private static void updateDefaultStreamOverrideDelay(boolean bl) {
            InvokeDynamicSupport.bootstrapStatic("updateDefaultStreamOverrideDelay", $$robo$$android_media_AudioService_StreamOverride$updateDefaultStreamOverrideDelay(boolean ), 0, (boolean)bl);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StreamOverride)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class MyDisplayStatusCallback
    implements HdmiPlaybackClient.DisplayStatusCallback,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ AudioService this$0;

        private void $$robo$$android_media_AudioService_MyDisplayStatusCallback$__constructor__(AudioService audioService) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_AudioService_MyDisplayStatusCallback$onComplete(int status) {
            if (this.this$0.mHdmiManager != null) {
                HdmiControlManager hdmiControlManager = this.this$0.mHdmiManager;
                synchronized (hdmiControlManager) {
                    this.this$0.mHdmiCecSink = status != -1;
                    if (this.this$0.isPlatformTelevision() && !this.this$0.mHdmiCecSink) {
                        this.this$0.mFixedVolumeDevices &= 0xFFFFFBFF;
                    }
                    this.this$0.checkAllFixedVolumeDevices();
                }
            }
        }

        private /* synthetic */ void $$robo$$android_media_AudioService_MyDisplayStatusCallback$__constructor__(AudioService x0, 1 x1) {
        }

        private void __constructor__(AudioService audioService) {
            this.$$robo$$android_media_AudioService_MyDisplayStatusCallback$__constructor__(audioService);
        }

        private MyDisplayStatusCallback(AudioService audioService) {
            this.this$0 = audioService;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioService_MyDisplayStatusCallback$__constructor__(android.media.AudioService ), 0, this, audioService);
        }

        @Override
        public void onComplete(int n) {
            InvokeDynamicSupport.bootstrap("onComplete", $$robo$$android_media_AudioService_MyDisplayStatusCallback$onComplete(int ), 0, this, n);
        }

        private /* synthetic */ void __constructor__(AudioService audioService, 1 var2_2) {
            this.$$robo$$android_media_AudioService_MyDisplayStatusCallback$__constructor__(audioService, var2_2);
        }

        public /* synthetic */ MyDisplayStatusCallback() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MyDisplayStatusCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class AudioServiceBroadcastReceiver
    extends BroadcastReceiver
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ AudioService this$0;

        private void $$robo$$android_media_AudioService_AudioServiceBroadcastReceiver$__constructor__(AudioService audioService) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_AudioService_AudioServiceBroadcastReceiver$onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action.equals("android.intent.action.DOCK_EVENT")) {
                int config;
                int dockState = intent.getIntExtra("android.intent.extra.DOCK_STATE", 0);
                switch (dockState) {
                    case 1: {
                        config = 7;
                        break;
                    }
                    case 2: {
                        config = 6;
                        break;
                    }
                    case 3: {
                        config = 8;
                        break;
                    }
                    case 4: {
                        config = 9;
                        break;
                    }
                    default: {
                        config = 0;
                    }
                }
                if (dockState != 3 && (dockState != 0 || this.this$0.mDockState != 3)) {
                    AudioSystem.setForceUse(3, config);
                }
                this.this$0.mDockState = dockState;
            } else if (action.equals("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED")) {
                boolean success;
                int state = intent.getIntExtra("android.bluetooth.profile.extra.STATE", 0);
                int outDevice = 16;
                int inDevice = -2147483640;
                String address = null;
                BluetoothDevice btDevice = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                if (btDevice == null) {
                    return;
                }
                address = btDevice.getAddress();
                BluetoothClass btClass = btDevice.getBluetoothClass();
                if (btClass != null) {
                    switch (btClass.getDeviceClass()) {
                        case 1028: 
                        case 1032: {
                            outDevice = 32;
                            break;
                        }
                        case 1056: {
                            outDevice = 64;
                        }
                    }
                }
                if (!BluetoothAdapter.checkBluetoothAddress(address)) {
                    address = "";
                }
                boolean connected = state == 2;
                boolean bl = success = this.this$0.handleDeviceConnection(connected, outDevice, address) && this.this$0.handleDeviceConnection(connected, inDevice, address);
                if (success) {
                    ArrayList arrayList = this.this$0.mScoClients;
                    synchronized (arrayList) {
                        if (connected) {
                            this.this$0.mBluetoothHeadsetDevice = btDevice;
                        } else {
                            this.this$0.mBluetoothHeadsetDevice = null;
                            this.this$0.resetBluetoothSco();
                        }
                    }
                }
            } else if (action.equals("android.media.action.USB_AUDIO_ACCESSORY_PLUG")) {
                int state = intent.getIntExtra("state", 0);
                int alsaCard = intent.getIntExtra("card", -1);
                int alsaDevice = intent.getIntExtra("device", -1);
                String params = alsaCard == -1 && alsaDevice == -1 ? "" : "card=" + alsaCard + ";device=" + alsaDevice;
                int outDevice = 8192;
                this.this$0.setWiredDeviceConnectionState(outDevice, state, params);
            } else if (action.equals("android.media.action.USB_AUDIO_DEVICE_PLUG")) {
                String params;
                int isDisabled = Settings.Secure.getInt(this.this$0.mContentResolver, "usb_audio_automatic_routing_disabled", 0);
                if (isDisabled != 0) {
                    return;
                }
                int state = intent.getIntExtra("state", 0);
                int alsaCard = intent.getIntExtra("card", -1);
                int alsaDevice = intent.getIntExtra("device", -1);
                boolean hasPlayback = intent.getBooleanExtra("hasPlayback", false);
                boolean hasCapture = intent.getBooleanExtra("hasCapture", false);
                boolean hasMIDI = intent.getBooleanExtra("hasMIDI", false);
                String string2 = params = alsaCard == -1 && alsaDevice == -1 ? "" : "card=" + alsaCard + ";device=" + alsaDevice;
                if (hasPlayback) {
                    int outDevice = 16384;
                    this.this$0.setWiredDeviceConnectionState(outDevice, state, params);
                }
                if (hasCapture) {
                    int inDevice = -2147479552;
                    this.this$0.setWiredDeviceConnectionState(inDevice, state, params);
                }
            } else if (action.equals("android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED")) {
                boolean broadcast = false;
                int scoAudioState = -1;
                ArrayList alsaDevice = this.this$0.mScoClients;
                synchronized (alsaDevice) {
                    int btState = intent.getIntExtra("android.bluetooth.profile.extra.STATE", -1);
                    if (!(this.this$0.mScoClients.isEmpty() || this.this$0.mScoAudioState != 3 && this.this$0.mScoAudioState != 1 && this.this$0.mScoAudioState != 5)) {
                        broadcast = true;
                    }
                    switch (btState) {
                        case 12: {
                            scoAudioState = 1;
                            if (this.this$0.mScoAudioState == 3 || this.this$0.mScoAudioState == 5 || this.this$0.mScoAudioState == 4) break;
                            this.this$0.mScoAudioState = 2;
                            break;
                        }
                        case 10: {
                            scoAudioState = 0;
                            this.this$0.mScoAudioState = 0;
                            this.this$0.clearAllScoClients(0, false);
                            break;
                        }
                        case 11: {
                            if (this.this$0.mScoAudioState != 3 && this.this$0.mScoAudioState != 5 && this.this$0.mScoAudioState != 4) {
                                this.this$0.mScoAudioState = 2;
                            }
                        }
                        default: {
                            broadcast = false;
                        }
                    }
                }
                if (broadcast) {
                    this.this$0.broadcastScoConnectionState(scoAudioState);
                    Intent newIntent = new Intent("android.media.SCO_AUDIO_STATE_CHANGED");
                    newIntent.putExtra("android.media.extra.SCO_AUDIO_STATE", scoAudioState);
                    this.this$0.sendStickyBroadcastToAll(newIntent);
                }
            } else if (action.equals("android.intent.action.SCREEN_ON")) {
                if (this.this$0.mMonitorRotation) {
                    this.this$0.mOrientationListener.onOrientationChanged(0);
                    this.this$0.mOrientationListener.enable();
                }
                AudioSystem.setParameters("screen_state=on");
            } else if (action.equals("android.intent.action.SCREEN_OFF")) {
                if (this.this$0.mMonitorRotation) {
                    this.this$0.mOrientationListener.disable();
                }
                AudioSystem.setParameters("screen_state=off");
            } else if (action.equals("android.intent.action.CONFIGURATION_CHANGED")) {
                this.this$0.handleConfigurationChanged(context);
            } else if (action.equals("android.intent.action.USER_SWITCHED")) {
                AudioService.sendMsg(this.this$0.mAudioHandler, 15, 0, 0, 0, null, 0);
                this.this$0.mMediaFocusControl.discardAudioFocusOwner();
                this.this$0.readAudioSettings(true);
                AudioService.sendMsg(this.this$0.mAudioHandler, 10, 2, 0, 0, this.this$0.mStreamStates[3], 0);
            }
        }

        private /* synthetic */ void $$robo$$android_media_AudioService_AudioServiceBroadcastReceiver$__constructor__(AudioService x0, 1 x1) {
        }

        private void __constructor__(AudioService audioService) {
            this.$$robo$$android_media_AudioService_AudioServiceBroadcastReceiver$__constructor__(audioService);
        }

        private AudioServiceBroadcastReceiver(AudioService audioService) {
            this.this$0 = audioService;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioService_AudioServiceBroadcastReceiver$__constructor__(android.media.AudioService ), 0, this, audioService);
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            InvokeDynamicSupport.bootstrap("onReceive", $$robo$$android_media_AudioService_AudioServiceBroadcastReceiver$onReceive(android.content.Context android.content.Intent ), 0, this, context, intent);
        }

        private /* synthetic */ void __constructor__(AudioService audioService, 1 var2_2) {
            this.$$robo$$android_media_AudioService_AudioServiceBroadcastReceiver$__constructor__(audioService, var2_2);
        }

        public /* synthetic */ AudioServiceBroadcastReceiver() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AudioServiceBroadcastReceiver)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class SettingsObserver
    extends ContentObserver
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ AudioService this$0;

        private void $$robo$$android_media_AudioService_SettingsObserver$__constructor__(AudioService audioService) {
            audioService.mContentResolver.registerContentObserver(Settings.System.getUriFor("mode_ringer_streams_affected"), false, this);
            audioService.mContentResolver.registerContentObserver(Settings.Global.getUriFor("dock_audio_media_enabled"), false, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_AudioService_SettingsObserver$onChange(boolean selfChange) {
            super.onChange(selfChange);
            Object object = this.this$0.mSettingsLock;
            synchronized (object) {
                if (this.this$0.updateRingerModeAffectedStreams()) {
                    this.this$0.setRingerModeInt(this.this$0.getRingerMode(), false);
                }
                this.this$0.readDockAudioSettings(this.this$0.mContentResolver);
            }
        }

        private void __constructor__(AudioService audioService) {
            this.$$robo$$android_media_AudioService_SettingsObserver$__constructor__(audioService);
        }

        SettingsObserver(AudioService audioService) {
            this.this$0 = audioService;
            super(new Handler());
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioService_SettingsObserver$__constructor__(android.media.AudioService ), 0, this, audioService);
        }

        @Override
        public void onChange(boolean bl) {
            InvokeDynamicSupport.bootstrap("onChange", $$robo$$android_media_AudioService_SettingsObserver$onChange(boolean ), 0, this, bl);
        }

        public /* synthetic */ SettingsObserver() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SettingsObserver)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class AudioHandler
    extends Handler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ AudioService this$0;

        private void $$robo$$android_media_AudioService_AudioHandler$__constructor__(AudioService audioService) {
        }

        private final void $$robo$$android_media_AudioService_AudioHandler$setDeviceVolume(VolumeStreamState streamState, int device) {
            streamState.applyDeviceVolume(device);
            int numStreamTypes = AudioSystem.getNumStreamTypes();
            for (int streamType = numStreamTypes - 1; streamType >= 0; --streamType) {
                if (streamType == streamState.mStreamType || this.this$0.mStreamVolumeAlias[streamType] != streamState.mStreamType) continue;
                int streamDevice = this.this$0.getDeviceForStream(streamType);
                if (device != streamDevice && this.this$0.mAvrcpAbsVolSupported && (device & 0x380) != 0) {
                    this.this$0.mStreamStates[streamType].applyDeviceVolume(device);
                }
                this.this$0.mStreamStates[streamType].applyDeviceVolume(streamDevice);
            }
            AudioService.sendMsg(this.this$0.mAudioHandler, 1, 2, device, 0, streamState, 500);
        }

        private final void $$robo$$android_media_AudioService_AudioHandler$setAllVolumes(VolumeStreamState streamState) {
            streamState.applyAllVolumes();
            int numStreamTypes = AudioSystem.getNumStreamTypes();
            for (int streamType = numStreamTypes - 1; streamType >= 0; --streamType) {
                if (streamType == streamState.mStreamType || this.this$0.mStreamVolumeAlias[streamType] != streamState.mStreamType) continue;
                this.this$0.mStreamStates[streamType].applyAllVolumes();
            }
        }

        private final void $$robo$$android_media_AudioService_AudioHandler$persistVolume(VolumeStreamState streamState, int device) {
            if (this.this$0.mUseFixedVolume) {
                return;
            }
            if (this.this$0.isPlatformTelevision() && streamState.mStreamType != 3) {
                return;
            }
            Settings.System.putIntForUser(this.this$0.mContentResolver, streamState.getSettingNameForDevice(device), (streamState.getIndex(device) + 5) / 10, -2);
        }

        private final void $$robo$$android_media_AudioService_AudioHandler$persistRingerMode(int ringerMode) {
            if (this.this$0.mUseFixedVolume) {
                return;
            }
            Settings.Global.putInt(this.this$0.mContentResolver, "mode_ringer", ringerMode);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean $$robo$$android_media_AudioService_AudioHandler$onLoadSoundEffects() {
            int status;
            Object object = this.this$0.mSoundEffectsLock;
            synchronized (object) {
                int effect;
                if (!this.this$0.mSystemReady) {
                    Log.w("AudioService", "onLoadSoundEffects() called before boot complete");
                    return false;
                }
                if (this.this$0.mSoundPool != null) {
                    return true;
                }
                this.this$0.loadTouchSoundAssets();
                this.this$0.mSoundPool = new SoundPool.Builder().setMaxStreams(4).setAudioAttributes(new AudioAttributes.Builder().setUsage(13).setContentType(4).build()).build();
                this.this$0.mSoundPoolCallBack = null;
                this.this$0.mSoundPoolListenerThread = new SoundPoolListenerThread(this.this$0);
                this.this$0.mSoundPoolListenerThread.start();
                int attempts = 3;
                while (this.this$0.mSoundPoolCallBack == null && attempts-- > 0) {
                    try {
                        this.this$0.mSoundEffectsLock.wait(5000L);
                    }
                    catch (InterruptedException e) {
                        Log.w("AudioService", "Interrupted while waiting sound pool listener thread.");
                    }
                }
                if (this.this$0.mSoundPoolCallBack == null) {
                    Log.w("AudioService", "onLoadSoundEffects() SoundPool listener or thread creation error");
                    if (this.this$0.mSoundPoolLooper != null) {
                        this.this$0.mSoundPoolLooper.quit();
                        this.this$0.mSoundPoolLooper = null;
                    }
                    this.this$0.mSoundPoolListenerThread = null;
                    this.this$0.mSoundPool.release();
                    this.this$0.mSoundPool = null;
                    return false;
                }
                int[] poolId = new int[SOUND_EFFECT_FILES.size()];
                for (int fileIdx = 0; fileIdx < SOUND_EFFECT_FILES.size(); ++fileIdx) {
                    poolId[fileIdx] = -1;
                }
                int numSamples = 0;
                for (effect = 0; effect < 10; ++effect) {
                    if (this.this$0.SOUND_EFFECT_FILES_MAP[effect][1] == 0) continue;
                    if (poolId[this.this$0.SOUND_EFFECT_FILES_MAP[effect][0]] == -1) {
                        String filePath = Environment.getRootDirectory() + "/media/audio/ui/" + (String)SOUND_EFFECT_FILES.get(this.this$0.SOUND_EFFECT_FILES_MAP[effect][0]);
                        int sampleId = this.this$0.mSoundPool.load(filePath, 0);
                        if (sampleId <= 0) {
                            Log.w("AudioService", "Soundpool could not load file: " + filePath);
                            continue;
                        }
                        ((AudioService)this.this$0).SOUND_EFFECT_FILES_MAP[effect][1] = sampleId;
                        poolId[((AudioService)this.this$0).SOUND_EFFECT_FILES_MAP[effect][0]] = sampleId;
                        ++numSamples;
                        continue;
                    }
                    ((AudioService)this.this$0).SOUND_EFFECT_FILES_MAP[effect][1] = poolId[this.this$0.SOUND_EFFECT_FILES_MAP[effect][0]];
                }
                if (numSamples > 0) {
                    this.this$0.mSoundPoolCallBack.setSamples(poolId);
                    attempts = 3;
                    status = 1;
                    while (status == 1 && attempts-- > 0) {
                        try {
                            this.this$0.mSoundEffectsLock.wait(5000L);
                            status = this.this$0.mSoundPoolCallBack.status();
                        }
                        catch (InterruptedException e) {
                            Log.w("AudioService", "Interrupted while waiting sound pool callback.");
                        }
                    }
                } else {
                    status = -1;
                }
                if (this.this$0.mSoundPoolLooper != null) {
                    this.this$0.mSoundPoolLooper.quit();
                    this.this$0.mSoundPoolLooper = null;
                }
                this.this$0.mSoundPoolListenerThread = null;
                if (status != 0) {
                    Log.w("AudioService", "onLoadSoundEffects(), Error " + status + " while loading samples");
                    for (effect = 0; effect < 10; ++effect) {
                        if (this.this$0.SOUND_EFFECT_FILES_MAP[effect][1] <= 0) continue;
                        ((AudioService)this.this$0).SOUND_EFFECT_FILES_MAP[effect][1] = -1;
                    }
                    this.this$0.mSoundPool.release();
                    this.this$0.mSoundPool = null;
                }
            }
            return status == 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_AudioService_AudioHandler$onUnloadSoundEffects() {
            Object object = this.this$0.mSoundEffectsLock;
            synchronized (object) {
                if (this.this$0.mSoundPool == null) {
                    return;
                }
                int[] poolId = new int[SOUND_EFFECT_FILES.size()];
                for (int fileIdx = 0; fileIdx < SOUND_EFFECT_FILES.size(); ++fileIdx) {
                    poolId[fileIdx] = 0;
                }
                for (int effect = 0; effect < 10; ++effect) {
                    if (this.this$0.SOUND_EFFECT_FILES_MAP[effect][1] <= 0 || poolId[this.this$0.SOUND_EFFECT_FILES_MAP[effect][0]] != 0) continue;
                    this.this$0.mSoundPool.unload(this.this$0.SOUND_EFFECT_FILES_MAP[effect][1]);
                    ((AudioService)this.this$0).SOUND_EFFECT_FILES_MAP[effect][1] = -1;
                    poolId[((AudioService)this.this$0).SOUND_EFFECT_FILES_MAP[effect][0]] = -1;
                }
                this.this$0.mSoundPool.release();
                this.this$0.mSoundPool = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_AudioService_AudioHandler$onPlaySoundEffect(int effectType, int volume) {
            Object object = this.this$0.mSoundEffectsLock;
            synchronized (object) {
                this.onLoadSoundEffects();
                if (this.this$0.mSoundPool == null) {
                    return;
                }
                float volFloat = volume < 0 ? (float)Math.pow(10.0, (float)sSoundEffectVolumeDb / 20.0f) : (float)volume / 1000.0f;
                if (this.this$0.SOUND_EFFECT_FILES_MAP[effectType][1] > 0) {
                    this.this$0.mSoundPool.play(this.this$0.SOUND_EFFECT_FILES_MAP[effectType][1], volFloat, volFloat, 0, 0, 1.0f);
                } else {
                    MediaPlayer mediaPlayer = new MediaPlayer();
                    try {
                        String filePath = Environment.getRootDirectory() + "/media/audio/ui/" + (String)SOUND_EFFECT_FILES.get(this.this$0.SOUND_EFFECT_FILES_MAP[effectType][0]);
                        mediaPlayer.setDataSource(filePath);
                        mediaPlayer.setAudioStreamType(1);
                        mediaPlayer.prepare();
                        mediaPlayer.setVolume(volFloat);
                        mediaPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener(this){
                            public transient /* synthetic */ Object __robo_data__;
                            /* synthetic */ AudioHandler this$1;

                            private void $$robo$$android_media_AudioService_AudioHandler_1$__constructor__(AudioHandler audioHandler) {
                            }

                            private final void $$robo$$android_media_AudioService_AudioHandler_1$onCompletion(MediaPlayer mp) {
                                this.this$1.cleanupPlayer(mp);
                            }

                            private void __constructor__(AudioHandler audioHandler) {
                                this.$$robo$$android_media_AudioService_AudioHandler_1$__constructor__(audioHandler);
                            }
                            {
                                this.this$1 = audioHandler;
                                this.$$robo$init();
                                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioService_AudioHandler_1$__constructor__(android.media.AudioService$AudioHandler ), 0, this, audioHandler);
                            }

                            @Override
                            public void onCompletion(MediaPlayer mediaPlayer) {
                                InvokeDynamicSupport.bootstrap("onCompletion", $$robo$$android_media_AudioService_AudioHandler_1$onCompletion(android.media.MediaPlayer ), 0, this, mediaPlayer);
                            }
                            {
                                this.$$robo$init();
                            }

                            protected /* synthetic */ void $$robo$init() {
                                if (this.__robo_data__ == null) {
                                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                                }
                            }

                            public /* synthetic */ Object $$robo$getData() {
                                return this.__robo_data__;
                            }
                        });
                        mediaPlayer.setOnErrorListener(new MediaPlayer.OnErrorListener(this){
                            public transient /* synthetic */ Object __robo_data__;
                            /* synthetic */ AudioHandler this$1;

                            private void $$robo$$android_media_AudioService_AudioHandler_2$__constructor__(AudioHandler audioHandler) {
                            }

                            private final boolean $$robo$$android_media_AudioService_AudioHandler_2$onError(MediaPlayer mp, int what, int extra) {
                                this.this$1.cleanupPlayer(mp);
                                return true;
                            }

                            private void __constructor__(AudioHandler audioHandler) {
                                this.$$robo$$android_media_AudioService_AudioHandler_2$__constructor__(audioHandler);
                            }
                            {
                                this.this$1 = audioHandler;
                                this.$$robo$init();
                                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioService_AudioHandler_2$__constructor__(android.media.AudioService$AudioHandler ), 0, this, audioHandler);
                            }

                            @Override
                            public boolean onError(MediaPlayer mediaPlayer, int n, int n2) {
                                return (boolean)InvokeDynamicSupport.bootstrap("onError", $$robo$$android_media_AudioService_AudioHandler_2$onError(android.media.MediaPlayer int int ), 0, this, mediaPlayer, n, n2);
                            }
                            {
                                this.$$robo$init();
                            }

                            protected /* synthetic */ void $$robo$init() {
                                if (this.__robo_data__ == null) {
                                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                                }
                            }

                            public /* synthetic */ Object $$robo$getData() {
                                return this.__robo_data__;
                            }
                        });
                        mediaPlayer.start();
                    }
                    catch (IOException ex) {
                        Log.w("AudioService", "MediaPlayer IOException: " + ex);
                    }
                    catch (IllegalArgumentException ex) {
                        Log.w("AudioService", "MediaPlayer IllegalArgumentException: " + ex);
                    }
                    catch (IllegalStateException ex) {
                        Log.w("AudioService", "MediaPlayer IllegalStateException: " + ex);
                    }
                }
            }
        }

        private final void $$robo$$android_media_AudioService_AudioHandler$cleanupPlayer(MediaPlayer mp) {
            if (mp != null) {
                try {
                    mp.stop();
                    mp.release();
                }
                catch (IllegalStateException ex) {
                    Log.w("AudioService", "MediaPlayer IllegalStateException: " + ex);
                }
            }
        }

        private final void $$robo$$android_media_AudioService_AudioHandler$setForceUse(int usage, int config) {
            AudioSystem.setForceUse(usage, config);
        }

        private final void $$robo$$android_media_AudioService_AudioHandler$onPersistSafeVolumeState(int state) {
            Settings.Global.putInt(this.this$0.mContentResolver, "audio_safe_volume_state", state);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_AudioService_AudioHandler$handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    this.setDeviceVolume((VolumeStreamState)msg.obj, msg.arg1);
                    break;
                }
                case 10: {
                    this.setAllVolumes((VolumeStreamState)msg.obj);
                    break;
                }
                case 1: {
                    this.persistVolume((VolumeStreamState)msg.obj, msg.arg1);
                    break;
                }
                case 2: {
                    if (this.this$0.mUseFixedVolume) {
                        return;
                    }
                    Settings.System.putFloatForUser(this.this$0.mContentResolver, "volume_master", (float)msg.arg1 / 1000.0f, -2);
                    break;
                }
                case 11: {
                    if (this.this$0.mUseFixedVolume) {
                        return;
                    }
                    Settings.System.putIntForUser(this.this$0.mContentResolver, "volume_master_mute", msg.arg1, msg.arg2);
                    break;
                }
                case 3: {
                    this.persistRingerMode(this.this$0.getRingerMode());
                    break;
                }
                case 4: {
                    if (!this.this$0.mSystemReady || AudioSystem.checkAudioFlinger() != 0) {
                        Log.e("AudioService", "Media server died.");
                        AudioService.sendMsg(this.this$0.mAudioHandler, 4, 1, 0, 0, null, 500);
                        break;
                    }
                    Log.e("AudioService", "Media server started.");
                    AudioSystem.setParameters("restarting=true");
                    AudioService.readAndSetLowRamDevice();
                    HashMap hashMap = this.this$0.mConnectedDevices;
                    synchronized (hashMap) {
                        Set set = this.this$0.mConnectedDevices.entrySet();
                        for (Map.Entry device : set) {
                            AudioSystem.setDeviceConnectionState((Integer)device.getKey(), 1, (String)device.getValue());
                        }
                    }
                    AudioSystem.setPhoneState(this.this$0.mMode);
                    AudioSystem.setForceUse(0, this.this$0.mForcedUseForComm);
                    AudioSystem.setForceUse(2, this.this$0.mForcedUseForComm);
                    AudioSystem.setForceUse(4, this.this$0.mCameraSoundForced != false ? 11 : 0);
                    int numStreamTypes = AudioSystem.getNumStreamTypes();
                    for (int streamType = numStreamTypes - 1; streamType >= 0; --streamType) {
                        VolumeStreamState streamState = this.this$0.mStreamStates[streamType];
                        AudioSystem.initStreamVolume(streamType, 0, (streamState.mIndexMax + 5) / 10);
                        streamState.applyAllVolumes();
                    }
                    this.this$0.setRingerModeInt(this.this$0.getRingerMode(), false);
                    this.this$0.restoreMasterVolume();
                    if (this.this$0.mMonitorOrientation) {
                        this.this$0.setOrientationForAudioSystem();
                    }
                    if (this.this$0.mMonitorRotation) {
                        this.this$0.setRotationForAudioSystem();
                    }
                    Object streamType = this.this$0.mBluetoothA2dpEnabledLock;
                    synchronized (streamType) {
                        AudioSystem.setForceUse(1, this.this$0.mBluetoothA2dpEnabled ? 0 : 10);
                    }
                    streamType = this.this$0.mSettingsLock;
                    synchronized (streamType) {
                        AudioSystem.setForceUse(3, this.this$0.mDockAudioMediaEnabled ? 8 : 0);
                    }
                    if (this.this$0.mHdmiManager != null) {
                        streamType = this.this$0.mHdmiManager;
                        synchronized (streamType) {
                            if (this.this$0.mHdmiTvClient != null) {
                                this.this$0.setHdmiSystemAudioSupported(this.this$0.mHdmiSystemAudioSupported);
                            }
                        }
                    }
                    AudioSystem.setParameters("restarting=false");
                    break;
                }
                case 20: {
                    this.onUnloadSoundEffects();
                    break;
                }
                case 7: {
                    LoadSoundEffectReply reply;
                    boolean loaded = this.onLoadSoundEffects();
                    if (msg.obj == null) break;
                    LoadSoundEffectReply device = reply = (LoadSoundEffectReply)msg.obj;
                    synchronized (device) {
                        reply.mStatus = loaded ? 0 : -1;
                        reply.notify();
                        break;
                    }
                }
                case 5: {
                    this.onPlaySoundEffect(msg.arg1, msg.arg2);
                    break;
                }
                case 6: {
                    HashMap reply = this.this$0.mConnectedDevices;
                    synchronized (reply) {
                        this.this$0.makeA2dpDeviceUnavailableNow((String)msg.obj);
                        break;
                    }
                }
                case 8: 
                case 13: {
                    this.setForceUse(msg.arg1, msg.arg2);
                    break;
                }
                case 9: {
                    this.this$0.resetBluetoothSco();
                    break;
                }
                case 100: {
                    this.this$0.onSetWiredDeviceConnectionState(msg.arg1, msg.arg2, (String)msg.obj);
                    this.this$0.mAudioEventWakeLock.release();
                    break;
                }
                case 101: {
                    this.this$0.onSetA2dpSourceConnectionState((BluetoothDevice)msg.obj, msg.arg1);
                    this.this$0.mAudioEventWakeLock.release();
                    break;
                }
                case 102: {
                    this.this$0.onSetA2dpSinkConnectionState((BluetoothDevice)msg.obj, msg.arg1);
                    this.this$0.mAudioEventWakeLock.release();
                    break;
                }
                case 12: {
                    int N = this.this$0.mRoutesObservers.beginBroadcast();
                    if (N > 0) {
                        AudioRoutesInfo routes;
                        AudioRoutesInfo audioRoutesInfo = this.this$0.mCurAudioRoutes;
                        synchronized (audioRoutesInfo) {
                            routes = new AudioRoutesInfo(this.this$0.mCurAudioRoutes);
                        }
                        while (N > 0) {
                            IAudioRoutesObserver obs = this.this$0.mRoutesObservers.getBroadcastItem(--N);
                            try {
                                obs.dispatchAudioRoutesChanged(routes);
                            }
                            catch (RemoteException remoteException) {}
                        }
                    }
                    this.this$0.mRoutesObservers.finishBroadcast();
                    break;
                }
                case 14: {
                    this.this$0.onCheckMusicActive();
                    break;
                }
                case 15: {
                    this.this$0.onSendBecomingNoisyIntent();
                    break;
                }
                case 16: 
                case 17: {
                    this.this$0.onConfigureSafeVolume(msg.what == 17);
                    break;
                }
                case 18: {
                    this.onPersistSafeVolumeState(msg.arg1);
                    break;
                }
                case 19: {
                    this.this$0.onBroadcastScoConnectionState(msg.arg1);
                    break;
                }
                case 21: {
                    this.this$0.onSystemReady();
                    break;
                }
                case 22: {
                    int musicActiveMs = msg.arg1;
                    Settings.Secure.putIntForUser(this.this$0.mContentResolver, "unsafe_volume_music_active_ms", musicActiveMs, -2);
                    break;
                }
                case 23: {
                    Settings.System.putIntForUser(this.this$0.mContentResolver, "microphone_mute", msg.arg1, msg.arg2);
                }
            }
        }

        private /* synthetic */ void $$robo$$android_media_AudioService_AudioHandler$__constructor__(AudioService x0, 1 x1) {
        }

        private void __constructor__(AudioService audioService) {
            this.$$robo$$android_media_AudioService_AudioHandler$__constructor__(audioService);
        }

        private AudioHandler(AudioService audioService) {
            this.this$0 = audioService;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioService_AudioHandler$__constructor__(android.media.AudioService ), 0, this, audioService);
        }

        private void setDeviceVolume(VolumeStreamState volumeStreamState, int n) {
            InvokeDynamicSupport.bootstrap("setDeviceVolume", $$robo$$android_media_AudioService_AudioHandler$setDeviceVolume(android.media.AudioService$VolumeStreamState int ), 0, this, volumeStreamState, n);
        }

        private void setAllVolumes(VolumeStreamState volumeStreamState) {
            InvokeDynamicSupport.bootstrap("setAllVolumes", $$robo$$android_media_AudioService_AudioHandler$setAllVolumes(android.media.AudioService$VolumeStreamState ), 0, this, volumeStreamState);
        }

        private void persistVolume(VolumeStreamState volumeStreamState, int n) {
            InvokeDynamicSupport.bootstrap("persistVolume", $$robo$$android_media_AudioService_AudioHandler$persistVolume(android.media.AudioService$VolumeStreamState int ), 0, this, volumeStreamState, n);
        }

        private void persistRingerMode(int n) {
            InvokeDynamicSupport.bootstrap("persistRingerMode", $$robo$$android_media_AudioService_AudioHandler$persistRingerMode(int ), 0, this, n);
        }

        private boolean onLoadSoundEffects() {
            return (boolean)InvokeDynamicSupport.bootstrap("onLoadSoundEffects", $$robo$$android_media_AudioService_AudioHandler$onLoadSoundEffects(), 0, this);
        }

        private void onUnloadSoundEffects() {
            InvokeDynamicSupport.bootstrap("onUnloadSoundEffects", $$robo$$android_media_AudioService_AudioHandler$onUnloadSoundEffects(), 0, this);
        }

        private void onPlaySoundEffect(int n, int n2) {
            InvokeDynamicSupport.bootstrap("onPlaySoundEffect", $$robo$$android_media_AudioService_AudioHandler$onPlaySoundEffect(int int ), 0, this, n, n2);
        }

        private void cleanupPlayer(MediaPlayer mediaPlayer) {
            InvokeDynamicSupport.bootstrap("cleanupPlayer", $$robo$$android_media_AudioService_AudioHandler$cleanupPlayer(android.media.MediaPlayer ), 0, this, mediaPlayer);
        }

        private void setForceUse(int n, int n2) {
            InvokeDynamicSupport.bootstrap("setForceUse", $$robo$$android_media_AudioService_AudioHandler$setForceUse(int int ), 0, this, n, n2);
        }

        private void onPersistSafeVolumeState(int n) {
            InvokeDynamicSupport.bootstrap("onPersistSafeVolumeState", $$robo$$android_media_AudioService_AudioHandler$onPersistSafeVolumeState(int ), 0, this, n);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_media_AudioService_AudioHandler$handleMessage(android.os.Message ), 0, this, message);
        }

        private /* synthetic */ void __constructor__(AudioService audioService, 1 var2_2) {
            this.$$robo$$android_media_AudioService_AudioHandler$__constructor__(audioService, var2_2);
        }

        public /* synthetic */ AudioHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AudioHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class AudioSystemThread
    extends Thread
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ AudioService this$0;

        private void $$robo$$android_media_AudioService_AudioSystemThread$__constructor__(AudioService audioService) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_AudioService_AudioSystemThread$run() {
            Looper.prepare();
            AudioService audioService = this.this$0;
            synchronized (audioService) {
                this.this$0.mAudioHandler = new AudioHandler(this.this$0);
                this.this$0.notify();
            }
            Looper.loop();
        }

        private void __constructor__(AudioService audioService) {
            this.$$robo$$android_media_AudioService_AudioSystemThread$__constructor__(audioService);
        }

        AudioSystemThread(AudioService audioService) {
            this.this$0 = audioService;
            super("AudioService");
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioService_AudioSystemThread$__constructor__(android.media.AudioService ), 0, this, audioService);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_AudioService_AudioSystemThread$run(), 0, this);
        }

        public /* synthetic */ AudioSystemThread() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AudioSystemThread)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class VolumeStreamState
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mStreamType;
        private String mVolumeIndexSettingName;
        private int mIndexMax;
        private ConcurrentHashMap<Integer, Integer> mIndex;
        private ArrayList<VolumeDeathHandler> mDeathHandlers;
        /* synthetic */ AudioService this$0;

        private void $$robo$$android_media_AudioService_VolumeStreamState$__constructor__(AudioService audioService, String settingName, int streamType) {
            this.mIndex = new ConcurrentHashMap(8, 0.75f, 4);
            this.mVolumeIndexSettingName = settingName;
            this.mStreamType = streamType;
            this.mIndexMax = MAX_STREAM_VOLUME[streamType];
            AudioSystem.initStreamVolume(streamType, 0, this.mIndexMax);
            this.mIndexMax *= 10;
            this.mDeathHandlers = new ArrayList();
            this.readSettings();
        }

        private final String $$robo$$android_media_AudioService_VolumeStreamState$getSettingNameForDevice(int device) {
            String name = this.mVolumeIndexSettingName;
            String suffix = AudioSystem.getOutputDeviceName(device);
            if (suffix.isEmpty()) {
                return name;
            }
            return name + "_" + suffix;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_AudioService_VolumeStreamState$readSettings() {
            Class<VolumeStreamState> clazz = VolumeStreamState.class;
            synchronized (VolumeStreamState.class) {
                if (this.this$0.mUseFixedVolume) {
                    this.mIndex.put(0x40000000, this.mIndexMax);
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                if (this.mStreamType == 1 || this.mStreamType == 7) {
                    int index = 10 * AudioManager.DEFAULT_STREAM_VOLUME[this.mStreamType];
                    Boolean bl = this.this$0.mCameraSoundForced;
                    synchronized (bl) {
                        if (this.this$0.mCameraSoundForced.booleanValue()) {
                            index = this.mIndexMax;
                        }
                    }
                    this.mIndex.put(0x40000000, index);
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                int remainingDevices = 1077936127;
                int i = 0;
                while (remainingDevices != 0) {
                    int device = 1 << i;
                    if ((device & remainingDevices) != 0) {
                        remainingDevices &= ~device;
                        String name = this.getSettingNameForDevice(device);
                        int defaultIndex = device == 0x40000000 ? AudioManager.DEFAULT_STREAM_VOLUME[this.mStreamType] : -1;
                        int index = Settings.System.getIntForUser(this.this$0.mContentResolver, name, defaultIndex, -2);
                        if (index != -1) {
                            this.mIndex.put(device, this.getValidIndex(10 * index));
                        }
                    }
                    ++i;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        private final void $$robo$$android_media_AudioService_VolumeStreamState$applyDeviceVolume(int device) {
            int index = this.isMuted() ? 0 : ((device & 0x380) != 0 && this.this$0.mAvrcpAbsVolSupported || (device & this.this$0.mFullVolumeDevices) != 0 ? (this.mIndexMax + 5) / 10 : (this.getIndex(device) + 5) / 10);
            AudioSystem.setStreamVolumeIndex(this.mStreamType, index, device);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_AudioService_VolumeStreamState$applyAllVolumes() {
            Class<VolumeStreamState> clazz = VolumeStreamState.class;
            synchronized (VolumeStreamState.class) {
                int index = this.isMuted() ? 0 : (this.getIndex(0x40000000) + 5) / 10;
                AudioSystem.setStreamVolumeIndex(this.mStreamType, index, 0x40000000);
                Set<Map.Entry<Integer, Integer>> set = this.mIndex.entrySet();
                for (Map.Entry<Integer, Integer> entry : set) {
                    int device = entry.getKey();
                    if (device == 0x40000000) continue;
                    index = this.isMuted() ? 0 : ((device & 0x380) != 0 && this.this$0.mAvrcpAbsVolSupported || (device & this.this$0.mFullVolumeDevices) != 0 ? (this.mIndexMax + 5) / 10 : (entry.getValue() + 5) / 10);
                    AudioSystem.setStreamVolumeIndex(this.mStreamType, index, device);
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        private final boolean $$robo$$android_media_AudioService_VolumeStreamState$adjustIndex(int deltaIndex, int device) {
            return this.setIndex(this.getIndex(device) + deltaIndex, device);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean $$robo$$android_media_AudioService_VolumeStreamState$setIndex(int index, int device) {
            Class<VolumeStreamState> clazz = VolumeStreamState.class;
            synchronized (VolumeStreamState.class) {
                int oldIndex = this.getIndex(device);
                index = this.getValidIndex(index);
                Boolean bl = this.this$0.mCameraSoundForced;
                synchronized (bl) {
                    if (this.mStreamType == 7 && this.this$0.mCameraSoundForced.booleanValue()) {
                        index = this.mIndexMax;
                    }
                }
                this.mIndex.put(device, index);
                if (oldIndex != index) {
                    boolean currentDevice = device == this.this$0.getDeviceForStream(this.mStreamType);
                    int numStreamTypes = AudioSystem.getNumStreamTypes();
                    for (int streamType = numStreamTypes - 1; streamType >= 0; --streamType) {
                        if (streamType == this.mStreamType || this.this$0.mStreamVolumeAlias[streamType] != this.mStreamType) continue;
                        int scaledIndex = this.this$0.rescaleIndex(index, this.mStreamType, streamType);
                        this.this$0.mStreamStates[streamType].setIndex(scaledIndex, device);
                        if (!currentDevice) continue;
                        this.this$0.mStreamStates[streamType].setIndex(scaledIndex, this.this$0.getDeviceForStream(streamType));
                    }
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return true;
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final int $$robo$$android_media_AudioService_VolumeStreamState$getIndex(int device) {
            Class<VolumeStreamState> clazz = VolumeStreamState.class;
            synchronized (VolumeStreamState.class) {
                Integer index = this.mIndex.get(device);
                if (index == null) {
                    index = this.mIndex.get(0x40000000);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return index;
            }
        }

        private final int $$robo$$android_media_AudioService_VolumeStreamState$getMaxIndex() {
            return this.mIndexMax;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_AudioService_VolumeStreamState$setAllIndexes(VolumeStreamState srcStream) {
            Class<VolumeStreamState> clazz = VolumeStreamState.class;
            synchronized (VolumeStreamState.class) {
                int srcStreamType = srcStream.getStreamType();
                int index = srcStream.getIndex(0x40000000);
                index = this.this$0.rescaleIndex(index, srcStreamType, this.mStreamType);
                Set<Map.Entry<Integer, Integer>> set = this.mIndex.entrySet();
                for (Map.Entry<Integer, Integer> entry : set) {
                    entry.setValue(index);
                }
                set = srcStream.mIndex.entrySet();
                for (Map.Entry<Integer, Integer> entry : set) {
                    int device = entry.getKey();
                    index = entry.getValue();
                    index = this.this$0.rescaleIndex(index, srcStreamType, this.mStreamType);
                    this.setIndex(index, device);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_AudioService_VolumeStreamState$setAllIndexesToMax() {
            Class<VolumeStreamState> clazz = VolumeStreamState.class;
            synchronized (VolumeStreamState.class) {
                Set<Map.Entry<Integer, Integer>> set = this.mIndex.entrySet();
                for (Map.Entry<Integer, Integer> entry : set) {
                    entry.setValue(this.mIndexMax);
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_AudioService_VolumeStreamState$mute(IBinder cb, boolean state) {
            Class<VolumeStreamState> clazz = VolumeStreamState.class;
            synchronized (VolumeStreamState.class) {
                VolumeDeathHandler handler = this.getDeathHandler(cb, state);
                if (handler == null) {
                    Log.e("AudioService", "Could not get client death handler for stream: " + this.mStreamType);
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return;
                }
                handler.mute(state);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }

        private final int $$robo$$android_media_AudioService_VolumeStreamState$getStreamType() {
            return this.mStreamType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_AudioService_VolumeStreamState$checkFixedVolumeDevices() {
            Class<VolumeStreamState> clazz = VolumeStreamState.class;
            synchronized (VolumeStreamState.class) {
                if (this.this$0.mStreamVolumeAlias[this.mStreamType] == 3) {
                    Set<Map.Entry<Integer, Integer>> set = this.mIndex.entrySet();
                    for (Map.Entry<Integer, Integer> entry : set) {
                        int device = entry.getKey();
                        int index = entry.getValue();
                        if ((device & this.this$0.mFullVolumeDevices) != 0 || (device & this.this$0.mFixedVolumeDevices) != 0 && index != 0) {
                            entry.setValue(this.mIndexMax);
                        }
                        this.applyDeviceVolume(device);
                    }
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        private final int $$robo$$android_media_AudioService_VolumeStreamState$getValidIndex(int index) {
            if (index < 0) {
                return 0;
            }
            if (this.this$0.mUseFixedVolume || index > this.mIndexMax) {
                return this.mIndexMax;
            }
            return index;
        }

        private final synchronized int $$robo$$android_media_AudioService_VolumeStreamState$muteCount() {
            int count = 0;
            int size = this.mDeathHandlers.size();
            for (int i = 0; i < size; ++i) {
                count += this.mDeathHandlers.get(i).mMuteCount;
            }
            return count;
        }

        private final synchronized boolean $$robo$$android_media_AudioService_VolumeStreamState$isMuted() {
            return this.muteCount() != 0;
        }

        private final VolumeDeathHandler $$robo$$android_media_AudioService_VolumeStreamState$getDeathHandler(IBinder cb, boolean state) {
            VolumeDeathHandler handler;
            int size = this.mDeathHandlers.size();
            for (int i = 0; i < size; ++i) {
                handler = this.mDeathHandlers.get(i);
                if (cb != handler.mICallback) continue;
                return handler;
            }
            if (state) {
                handler = new VolumeDeathHandler(this, cb);
            } else {
                Log.w("AudioService", "stream was not muted by this client");
                handler = null;
            }
            return handler;
        }

        private final void $$robo$$android_media_AudioService_VolumeStreamState$dump(PrintWriter pw) {
            pw.print("   Mute count: ");
            pw.println(this.muteCount());
            pw.print("   Max: ");
            pw.println((this.mIndexMax + 5) / 10);
            pw.print("   Current: ");
            Set<Map.Entry<Integer, Integer>> set = this.mIndex.entrySet();
            Iterator<Map.Entry<Integer, Integer>> i = set.iterator();
            while (i.hasNext()) {
                String deviceName;
                Map.Entry<Integer, Integer> entry = i.next();
                int device = entry.getKey();
                pw.print(Integer.toHexString(device));
                String string2 = deviceName = device == 0x40000000 ? "default" : AudioSystem.getOutputDeviceName(device);
                if (!deviceName.isEmpty()) {
                    pw.print(" (");
                    pw.print(deviceName);
                    pw.print(")");
                }
                pw.print(": ");
                int index = (entry.getValue() + 5) / 10;
                pw.print(index);
                if (!i.hasNext()) continue;
                pw.print(", ");
            }
        }

        private /* synthetic */ void $$robo$$android_media_AudioService_VolumeStreamState$__constructor__(AudioService x0, String x1, int x2, 1 x3) {
        }

        private void __constructor__(AudioService audioService, String string2, int n) {
            this.$$robo$$android_media_AudioService_VolumeStreamState$__constructor__(audioService, string2, n);
        }

        private VolumeStreamState(AudioService audioService, String string2, int n) {
            this.this$0 = audioService;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioService_VolumeStreamState$__constructor__(android.media.AudioService java.lang.String int ), 0, this, audioService, string2, n);
        }

        public String getSettingNameForDevice(int n) {
            return InvokeDynamicSupport.bootstrap("getSettingNameForDevice", $$robo$$android_media_AudioService_VolumeStreamState$getSettingNameForDevice(int ), 0, this, n);
        }

        public void readSettings() {
            InvokeDynamicSupport.bootstrap("readSettings", $$robo$$android_media_AudioService_VolumeStreamState$readSettings(), 0, this);
        }

        public void applyDeviceVolume(int n) {
            InvokeDynamicSupport.bootstrap("applyDeviceVolume", $$robo$$android_media_AudioService_VolumeStreamState$applyDeviceVolume(int ), 0, this, n);
        }

        public void applyAllVolumes() {
            InvokeDynamicSupport.bootstrap("applyAllVolumes", $$robo$$android_media_AudioService_VolumeStreamState$applyAllVolumes(), 0, this);
        }

        public boolean adjustIndex(int n, int n2) {
            return (boolean)InvokeDynamicSupport.bootstrap("adjustIndex", $$robo$$android_media_AudioService_VolumeStreamState$adjustIndex(int int ), 0, this, n, n2);
        }

        public boolean setIndex(int n, int n2) {
            return (boolean)InvokeDynamicSupport.bootstrap("setIndex", $$robo$$android_media_AudioService_VolumeStreamState$setIndex(int int ), 0, this, n, n2);
        }

        public int getIndex(int n) {
            return (int)InvokeDynamicSupport.bootstrap("getIndex", $$robo$$android_media_AudioService_VolumeStreamState$getIndex(int ), 0, this, n);
        }

        public int getMaxIndex() {
            return (int)InvokeDynamicSupport.bootstrap("getMaxIndex", $$robo$$android_media_AudioService_VolumeStreamState$getMaxIndex(), 0, this);
        }

        public void setAllIndexes(VolumeStreamState volumeStreamState) {
            InvokeDynamicSupport.bootstrap("setAllIndexes", $$robo$$android_media_AudioService_VolumeStreamState$setAllIndexes(android.media.AudioService$VolumeStreamState ), 0, this, volumeStreamState);
        }

        public void setAllIndexesToMax() {
            InvokeDynamicSupport.bootstrap("setAllIndexesToMax", $$robo$$android_media_AudioService_VolumeStreamState$setAllIndexesToMax(), 0, this);
        }

        public void mute(IBinder iBinder, boolean bl) {
            InvokeDynamicSupport.bootstrap("mute", $$robo$$android_media_AudioService_VolumeStreamState$mute(android.os.IBinder boolean ), 0, this, iBinder, bl);
        }

        public int getStreamType() {
            return (int)InvokeDynamicSupport.bootstrap("getStreamType", $$robo$$android_media_AudioService_VolumeStreamState$getStreamType(), 0, this);
        }

        public void checkFixedVolumeDevices() {
            InvokeDynamicSupport.bootstrap("checkFixedVolumeDevices", $$robo$$android_media_AudioService_VolumeStreamState$checkFixedVolumeDevices(), 0, this);
        }

        private int getValidIndex(int n) {
            return (int)InvokeDynamicSupport.bootstrap("getValidIndex", $$robo$$android_media_AudioService_VolumeStreamState$getValidIndex(int ), 0, this, n);
        }

        private synchronized int muteCount() {
            return (int)InvokeDynamicSupport.bootstrap("muteCount", $$robo$$android_media_AudioService_VolumeStreamState$muteCount(), 0, this);
        }

        private synchronized boolean isMuted() {
            return (boolean)InvokeDynamicSupport.bootstrap("isMuted", $$robo$$android_media_AudioService_VolumeStreamState$isMuted(), 0, this);
        }

        private VolumeDeathHandler getDeathHandler(IBinder iBinder, boolean bl) {
            return InvokeDynamicSupport.bootstrap("getDeathHandler", $$robo$$android_media_AudioService_VolumeStreamState$getDeathHandler(android.os.IBinder boolean ), 0, this, iBinder, bl);
        }

        private void dump(PrintWriter printWriter) {
            InvokeDynamicSupport.bootstrap("dump", $$robo$$android_media_AudioService_VolumeStreamState$dump(java.io.PrintWriter ), 0, this, printWriter);
        }

        private /* synthetic */ void __constructor__(AudioService audioService, String string2, int n, 1 var4_4) {
            this.$$robo$$android_media_AudioService_VolumeStreamState$__constructor__(audioService, string2, n, var4_4);
        }

        public /* synthetic */ VolumeStreamState() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (VolumeStreamState)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        private class VolumeDeathHandler
        implements IBinder.DeathRecipient,
        ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            private IBinder mICallback;
            private int mMuteCount;
            /* synthetic */ VolumeStreamState this$1;

            private void $$robo$$android_media_AudioService_VolumeStreamState_VolumeDeathHandler$__constructor__(VolumeStreamState volumeStreamState, IBinder cb) {
                this.mICallback = cb;
            }

            /*
             * Unable to fully structure code
             */
            private final void $$robo$$android_media_AudioService_VolumeStreamState_VolumeDeathHandler$mute(boolean state) {
                updateVolume = false;
                if (state) {
                    if (this.mMuteCount == 0) {
                        try {
                            if (this.mICallback != null) {
                                this.mICallback.linkToDeath(this, 0);
                            }
                            VolumeStreamState.access$2200(this.this$1).add(this);
                            if (VolumeStreamState.access$300(this.this$1)) ** GOTO lbl17
                            updateVolume = true;
                        }
                        catch (RemoteException e) {
                            this.binderDied();
                            return;
                        }
                    } else {
                        Log.w("AudioService", "stream: " + VolumeStreamState.access$4800(this.this$1) + " was already muted by this client");
                    }
lbl17:
                    // 3 sources

                    ++this.mMuteCount;
                } else if (this.mMuteCount == 0) {
                    Log.e("AudioService", "unexpected unmute for stream: " + VolumeStreamState.access$4800(this.this$1));
                } else {
                    --this.mMuteCount;
                    if (this.mMuteCount == 0) {
                        VolumeStreamState.access$2200(this.this$1).remove(this);
                        if (this.mICallback != null) {
                            this.mICallback.unlinkToDeath(this, 0);
                        }
                        if (!VolumeStreamState.access$300(this.this$1)) {
                            updateVolume = true;
                        }
                    }
                }
                if (updateVolume) {
                    AudioService.access$100(AudioService.access$000(this.this$1.this$0), 10, 2, 0, 0, this.this$1, 0);
                }
            }

            private final void $$robo$$android_media_AudioService_VolumeStreamState_VolumeDeathHandler$binderDied() {
                Log.w("AudioService", "Volume service client died for stream: " + this.this$1.mStreamType);
                if (this.mMuteCount != 0) {
                    this.mMuteCount = 1;
                    this.mute(false);
                }
            }

            private void __constructor__(VolumeStreamState volumeStreamState, IBinder iBinder) {
                this.$$robo$$android_media_AudioService_VolumeStreamState_VolumeDeathHandler$__constructor__(volumeStreamState, iBinder);
            }

            VolumeDeathHandler(VolumeStreamState volumeStreamState, IBinder iBinder) {
                this.this$1 = volumeStreamState;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioService_VolumeStreamState_VolumeDeathHandler$__constructor__(android.media.AudioService$VolumeStreamState android.os.IBinder ), 0, this, volumeStreamState, iBinder);
            }

            public void mute(boolean bl) {
                InvokeDynamicSupport.bootstrap("mute", $$robo$$android_media_AudioService_VolumeStreamState_VolumeDeathHandler$mute(boolean ), 0, this, bl);
            }

            @Override
            public void binderDied() {
                InvokeDynamicSupport.bootstrap("binderDied", $$robo$$android_media_AudioService_VolumeStreamState_VolumeDeathHandler$binderDied(), 0, this);
            }

            public /* synthetic */ VolumeDeathHandler() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (VolumeDeathHandler)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    private class ScoClient
    implements IBinder.DeathRecipient,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private IBinder mCb;
        private int mCreatorPid;
        private int mStartcount;
        /* synthetic */ AudioService this$0;

        private void $$robo$$android_media_AudioService_ScoClient$__constructor__(AudioService audioService, IBinder cb) {
            this.mCb = cb;
            this.mCreatorPid = Binder.getCallingPid();
            this.mStartcount = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_AudioService_ScoClient$binderDied() {
            ArrayList arrayList = this.this$0.mScoClients;
            synchronized (arrayList) {
                Log.w("AudioService", "SCO client died");
                int index = this.this$0.mScoClients.indexOf(this);
                if (index < 0) {
                    Log.w("AudioService", "unregistered SCO client died");
                } else {
                    this.clearCount(true);
                    this.this$0.mScoClients.remove(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_AudioService_ScoClient$incCount(int scoAudioMode) {
            ArrayList arrayList = this.this$0.mScoClients;
            synchronized (arrayList) {
                this.requestScoState(12, scoAudioMode);
                if (this.mStartcount == 0) {
                    try {
                        this.mCb.linkToDeath(this, 0);
                    }
                    catch (RemoteException e) {
                        Log.w("AudioService", "ScoClient  incCount() could not link to " + this.mCb + " binder death");
                    }
                }
                ++this.mStartcount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_AudioService_ScoClient$decCount() {
            ArrayList arrayList = this.this$0.mScoClients;
            synchronized (arrayList) {
                if (this.mStartcount == 0) {
                    Log.w("AudioService", "ScoClient.decCount() already 0");
                } else {
                    --this.mStartcount;
                    if (this.mStartcount == 0) {
                        try {
                            this.mCb.unlinkToDeath(this, 0);
                        }
                        catch (NoSuchElementException e) {
                            Log.w("AudioService", "decCount() going to 0 but not registered to binder");
                        }
                    }
                    this.requestScoState(10, 0);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_AudioService_ScoClient$clearCount(boolean stopSco) {
            ArrayList arrayList = this.this$0.mScoClients;
            synchronized (arrayList) {
                if (this.mStartcount != 0) {
                    try {
                        this.mCb.unlinkToDeath(this, 0);
                    }
                    catch (NoSuchElementException e) {
                        Log.w("AudioService", "clearCount() mStartcount: " + this.mStartcount + " != 0 but not registered to binder");
                    }
                }
                this.mStartcount = 0;
                if (stopSco) {
                    this.requestScoState(10, 0);
                }
            }
        }

        private final int $$robo$$android_media_AudioService_ScoClient$getCount() {
            return this.mStartcount;
        }

        private final IBinder $$robo$$android_media_AudioService_ScoClient$getBinder() {
            return this.mCb;
        }

        private final int $$robo$$android_media_AudioService_ScoClient$getPid() {
            return this.mCreatorPid;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final int $$robo$$android_media_AudioService_ScoClient$totalCount() {
            ArrayList arrayList = this.this$0.mScoClients;
            synchronized (arrayList) {
                int count = 0;
                int size = this.this$0.mScoClients.size();
                for (int i = 0; i < size; ++i) {
                    count += ((ScoClient)this.this$0.mScoClients.get(i)).getCount();
                }
                return count;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_AudioService_ScoClient$requestScoState(int state, int scoAudioMode) {
            this.this$0.checkScoAudioState();
            if (this.totalCount() == 0) {
                if (state == 12) {
                    this.this$0.broadcastScoConnectionState(2);
                    ArrayList arrayList = this.this$0.mSetModeDeathHandlers;
                    synchronized (arrayList) {
                        if (!(!this.this$0.mSetModeDeathHandlers.isEmpty() && ((SetModeDeathHandler)this.this$0.mSetModeDeathHandlers.get(0)).getPid() != this.mCreatorPid || this.this$0.mScoAudioState != 0 && this.this$0.mScoAudioState != 5)) {
                            if (this.this$0.mScoAudioState == 0) {
                                this.this$0.mScoAudioMode = scoAudioMode;
                                if (scoAudioMode == -1) {
                                    this.this$0.mScoAudioMode = new Integer(Settings.Global.getInt(this.this$0.mContentResolver, "bluetooth_sco_channel_" + this.this$0.mBluetoothHeadsetDevice.getAddress(), 0));
                                    if (this.this$0.mScoAudioMode > 2 || this.this$0.mScoAudioMode < 0) {
                                        this.this$0.mScoAudioMode = 0;
                                    }
                                }
                                if (this.this$0.mBluetoothHeadset != null && this.this$0.mBluetoothHeadsetDevice != null) {
                                    boolean status = false;
                                    if (this.this$0.mScoAudioMode == 1) {
                                        status = this.this$0.mBluetoothHeadset.connectAudio();
                                    } else if (this.this$0.mScoAudioMode == 0) {
                                        status = this.this$0.mBluetoothHeadset.startScoUsingVirtualVoiceCall(this.this$0.mBluetoothHeadsetDevice);
                                    } else if (this.this$0.mScoAudioMode == 2) {
                                        status = this.this$0.mBluetoothHeadset.startVoiceRecognition(this.this$0.mBluetoothHeadsetDevice);
                                    }
                                    if (status) {
                                        this.this$0.mScoAudioState = 3;
                                    } else {
                                        this.this$0.broadcastScoConnectionState(0);
                                    }
                                } else if (this.this$0.getBluetoothHeadset()) {
                                    this.this$0.mScoAudioState = 1;
                                }
                            } else {
                                this.this$0.mScoAudioState = 3;
                                this.this$0.broadcastScoConnectionState(1);
                            }
                        } else {
                            this.this$0.broadcastScoConnectionState(0);
                        }
                    }
                } else if (state == 10 && (this.this$0.mScoAudioState == 3 || this.this$0.mScoAudioState == 1)) {
                    if (this.this$0.mScoAudioState == 3) {
                        if (this.this$0.mBluetoothHeadset != null && this.this$0.mBluetoothHeadsetDevice != null) {
                            boolean status = false;
                            if (this.this$0.mScoAudioMode == 1) {
                                status = this.this$0.mBluetoothHeadset.disconnectAudio();
                            } else if (this.this$0.mScoAudioMode == 0) {
                                status = this.this$0.mBluetoothHeadset.stopScoUsingVirtualVoiceCall(this.this$0.mBluetoothHeadsetDevice);
                            } else if (this.this$0.mScoAudioMode == 2) {
                                status = this.this$0.mBluetoothHeadset.stopVoiceRecognition(this.this$0.mBluetoothHeadsetDevice);
                            }
                            if (!status) {
                                this.this$0.mScoAudioState = 0;
                                this.this$0.broadcastScoConnectionState(0);
                            }
                        } else if (this.this$0.getBluetoothHeadset()) {
                            this.this$0.mScoAudioState = 5;
                        }
                    } else {
                        this.this$0.mScoAudioState = 0;
                        this.this$0.broadcastScoConnectionState(0);
                    }
                }
            }
        }

        private void __constructor__(AudioService audioService, IBinder iBinder) {
            this.$$robo$$android_media_AudioService_ScoClient$__constructor__(audioService, iBinder);
        }

        ScoClient(AudioService audioService, IBinder iBinder) {
            this.this$0 = audioService;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioService_ScoClient$__constructor__(android.media.AudioService android.os.IBinder ), 0, this, audioService, iBinder);
        }

        @Override
        public void binderDied() {
            InvokeDynamicSupport.bootstrap("binderDied", $$robo$$android_media_AudioService_ScoClient$binderDied(), 0, this);
        }

        public void incCount(int n) {
            InvokeDynamicSupport.bootstrap("incCount", $$robo$$android_media_AudioService_ScoClient$incCount(int ), 0, this, n);
        }

        public void decCount() {
            InvokeDynamicSupport.bootstrap("decCount", $$robo$$android_media_AudioService_ScoClient$decCount(), 0, this);
        }

        public void clearCount(boolean bl) {
            InvokeDynamicSupport.bootstrap("clearCount", $$robo$$android_media_AudioService_ScoClient$clearCount(boolean ), 0, this, bl);
        }

        public int getCount() {
            return (int)InvokeDynamicSupport.bootstrap("getCount", $$robo$$android_media_AudioService_ScoClient$getCount(), 0, this);
        }

        public IBinder getBinder() {
            return InvokeDynamicSupport.bootstrap("getBinder", $$robo$$android_media_AudioService_ScoClient$getBinder(), 0, this);
        }

        public int getPid() {
            return (int)InvokeDynamicSupport.bootstrap("getPid", $$robo$$android_media_AudioService_ScoClient$getPid(), 0, this);
        }

        public int totalCount() {
            return (int)InvokeDynamicSupport.bootstrap("totalCount", $$robo$$android_media_AudioService_ScoClient$totalCount(), 0, this);
        }

        private void requestScoState(int n, int n2) {
            InvokeDynamicSupport.bootstrap("requestScoState", $$robo$$android_media_AudioService_ScoClient$requestScoState(int int ), 0, this, n, n2);
        }

        public /* synthetic */ ScoClient() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ScoClient)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class SoundPoolCallback
    implements SoundPool.OnLoadCompleteListener,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int mStatus;
        List<Integer> mSamples;
        /* synthetic */ AudioService this$0;

        private void $$robo$$android_media_AudioService_SoundPoolCallback$__constructor__(AudioService audioService) {
            this.mStatus = 1;
            this.mSamples = new ArrayList<Integer>();
        }

        private final int $$robo$$android_media_AudioService_SoundPoolCallback$status() {
            return this.mStatus;
        }

        private final void $$robo$$android_media_AudioService_SoundPoolCallback$setSamples(int[] samples) {
            for (int i = 0; i < samples.length; ++i) {
                if (samples[i] <= 0) continue;
                this.mSamples.add(samples[i]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_AudioService_SoundPoolCallback$onLoadComplete(SoundPool soundPool, int sampleId, int status) {
            Object object = this.this$0.mSoundEffectsLock;
            synchronized (object) {
                int i = this.mSamples.indexOf(sampleId);
                if (i >= 0) {
                    this.mSamples.remove(i);
                }
                if (status != 0 || this.mSamples.isEmpty()) {
                    this.mStatus = status;
                    this.this$0.mSoundEffectsLock.notify();
                }
            }
        }

        private /* synthetic */ void $$robo$$android_media_AudioService_SoundPoolCallback$__constructor__(AudioService x0, 1 x1) {
        }

        private void __constructor__(AudioService audioService) {
            this.$$robo$$android_media_AudioService_SoundPoolCallback$__constructor__(audioService);
        }

        private SoundPoolCallback(AudioService audioService) {
            this.this$0 = audioService;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioService_SoundPoolCallback$__constructor__(android.media.AudioService ), 0, this, audioService);
        }

        public int status() {
            return (int)InvokeDynamicSupport.bootstrap("status", $$robo$$android_media_AudioService_SoundPoolCallback$status(), 0, this);
        }

        public void setSamples(int[] nArray) {
            InvokeDynamicSupport.bootstrap("setSamples", $$robo$$android_media_AudioService_SoundPoolCallback$setSamples(int[] ), 0, this, nArray);
        }

        @Override
        public void onLoadComplete(SoundPool soundPool, int n, int n2) {
            InvokeDynamicSupport.bootstrap("onLoadComplete", $$robo$$android_media_AudioService_SoundPoolCallback$onLoadComplete(android.media.SoundPool int int ), 0, this, soundPool, n, n2);
        }

        private /* synthetic */ void __constructor__(AudioService audioService, 1 var2_2) {
            this.$$robo$$android_media_AudioService_SoundPoolCallback$__constructor__(audioService, var2_2);
        }

        public /* synthetic */ SoundPoolCallback() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SoundPoolCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class SoundPoolListenerThread
    extends Thread
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ AudioService this$0;

        private void $$robo$$android_media_AudioService_SoundPoolListenerThread$__constructor__(AudioService audioService) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_AudioService_SoundPoolListenerThread$run() {
            Looper.prepare();
            this.this$0.mSoundPoolLooper = Looper.myLooper();
            Object object = this.this$0.mSoundEffectsLock;
            synchronized (object) {
                if (this.this$0.mSoundPool != null) {
                    this.this$0.mSoundPoolCallBack = new SoundPoolCallback(this.this$0);
                    this.this$0.mSoundPool.setOnLoadCompleteListener(this.this$0.mSoundPoolCallBack);
                }
                this.this$0.mSoundEffectsLock.notify();
            }
            Looper.loop();
        }

        private void __constructor__(AudioService audioService) {
            this.$$robo$$android_media_AudioService_SoundPoolListenerThread$__constructor__(audioService);
        }

        public SoundPoolListenerThread(AudioService audioService) {
            this.this$0 = audioService;
            super("SoundPoolListenerThread");
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioService_SoundPoolListenerThread$__constructor__(android.media.AudioService ), 0, this, audioService);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_AudioService_SoundPoolListenerThread$run(), 0, this);
        }

        public /* synthetic */ SoundPoolListenerThread() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SoundPoolListenerThread)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class LoadSoundEffectReply
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int mStatus;
        /* synthetic */ AudioService this$0;

        private void $$robo$$android_media_AudioService_LoadSoundEffectReply$__constructor__(AudioService audioService) {
            this.mStatus = 1;
        }

        private void __constructor__(AudioService audioService) {
            this.$$robo$$android_media_AudioService_LoadSoundEffectReply$__constructor__(audioService);
        }

        LoadSoundEffectReply(AudioService audioService) {
            this.this$0 = audioService;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioService_LoadSoundEffectReply$__constructor__(android.media.AudioService ), 0, this, audioService);
        }

        public /* synthetic */ LoadSoundEffectReply() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LoadSoundEffectReply)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class SetModeDeathHandler
    implements IBinder.DeathRecipient,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private IBinder mCb;
        private int mPid;
        private int mMode;
        /* synthetic */ AudioService this$0;

        private void $$robo$$android_media_AudioService_SetModeDeathHandler$__constructor__(AudioService audioService, IBinder cb, int pid) {
            this.mMode = 0;
            this.mCb = cb;
            this.mPid = pid;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_AudioService_SetModeDeathHandler$binderDied() {
            int newModeOwnerPid = 0;
            ArrayList arrayList = this.this$0.mSetModeDeathHandlers;
            synchronized (arrayList) {
                Log.w("AudioService", "setMode() client died");
                int index = this.this$0.mSetModeDeathHandlers.indexOf(this);
                if (index < 0) {
                    Log.w("AudioService", "unregistered setMode() client died");
                } else {
                    newModeOwnerPid = this.this$0.setModeInt(0, this.mCb, this.mPid);
                }
            }
            if (newModeOwnerPid != 0) {
                long ident = Binder.clearCallingIdentity();
                this.this$0.disconnectBluetoothSco(newModeOwnerPid);
                Binder.restoreCallingIdentity(ident);
            }
        }

        private final int $$robo$$android_media_AudioService_SetModeDeathHandler$getPid() {
            return this.mPid;
        }

        private final void $$robo$$android_media_AudioService_SetModeDeathHandler$setMode(int mode) {
            this.mMode = mode;
        }

        private final int $$robo$$android_media_AudioService_SetModeDeathHandler$getMode() {
            return this.mMode;
        }

        private final IBinder $$robo$$android_media_AudioService_SetModeDeathHandler$getBinder() {
            return this.mCb;
        }

        private void __constructor__(AudioService audioService, IBinder iBinder, int n) {
            this.$$robo$$android_media_AudioService_SetModeDeathHandler$__constructor__(audioService, iBinder, n);
        }

        SetModeDeathHandler(AudioService audioService, IBinder iBinder, int n) {
            this.this$0 = audioService;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioService_SetModeDeathHandler$__constructor__(android.media.AudioService android.os.IBinder int ), 0, this, audioService, iBinder, n);
        }

        @Override
        public void binderDied() {
            InvokeDynamicSupport.bootstrap("binderDied", $$robo$$android_media_AudioService_SetModeDeathHandler$binderDied(), 0, this);
        }

        public int getPid() {
            return (int)InvokeDynamicSupport.bootstrap("getPid", $$robo$$android_media_AudioService_SetModeDeathHandler$getPid(), 0, this);
        }

        public void setMode(int n) {
            InvokeDynamicSupport.bootstrap("setMode", $$robo$$android_media_AudioService_SetModeDeathHandler$setMode(int ), 0, this, n);
        }

        public int getMode() {
            return (int)InvokeDynamicSupport.bootstrap("getMode", $$robo$$android_media_AudioService_SetModeDeathHandler$getMode(), 0, this);
        }

        public IBinder getBinder() {
            return InvokeDynamicSupport.bootstrap("getBinder", $$robo$$android_media_AudioService_SetModeDeathHandler$getBinder(), 0, this);
        }

        public /* synthetic */ SetModeDeathHandler() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SetModeDeathHandler)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class RmtSbmxFullVolDeathHandler
    implements IBinder.DeathRecipient,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private IBinder mICallback;
        /* synthetic */ AudioService this$0;

        private void $$robo$$android_media_AudioService_RmtSbmxFullVolDeathHandler$__constructor__(AudioService audioService, IBinder cb) {
            this.mICallback = cb;
            try {
                cb.linkToDeath(this, 0);
            }
            catch (RemoteException e) {
                Log.e("AudioService", "can't link to death", e);
            }
        }

        private final boolean $$robo$$android_media_AudioService_RmtSbmxFullVolDeathHandler$isHandlerFor(IBinder cb) {
            return this.mICallback.equals(cb);
        }

        private final void $$robo$$android_media_AudioService_RmtSbmxFullVolDeathHandler$forget() {
            try {
                this.mICallback.unlinkToDeath(this, 0);
            }
            catch (NoSuchElementException e) {
                Log.e("AudioService", "error unlinking to death", e);
            }
        }

        private final void $$robo$$android_media_AudioService_RmtSbmxFullVolDeathHandler$binderDied() {
            Log.w("AudioService", "Recorder with remote submix at full volume died " + this.mICallback);
            this.this$0.forceRemoteSubmixFullVolume(false, this.mICallback);
        }

        private void __constructor__(AudioService audioService, IBinder iBinder) {
            this.$$robo$$android_media_AudioService_RmtSbmxFullVolDeathHandler$__constructor__(audioService, iBinder);
        }

        RmtSbmxFullVolDeathHandler(AudioService audioService, IBinder iBinder) {
            this.this$0 = audioService;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioService_RmtSbmxFullVolDeathHandler$__constructor__(android.media.AudioService android.os.IBinder ), 0, this, audioService, iBinder);
        }

        boolean isHandlerFor(IBinder iBinder) {
            return (boolean)InvokeDynamicSupport.bootstrap("isHandlerFor", $$robo$$android_media_AudioService_RmtSbmxFullVolDeathHandler$isHandlerFor(android.os.IBinder ), 0, this, iBinder);
        }

        void forget() {
            InvokeDynamicSupport.bootstrap("forget", $$robo$$android_media_AudioService_RmtSbmxFullVolDeathHandler$forget(), 0, this);
        }

        @Override
        public void binderDied() {
            InvokeDynamicSupport.bootstrap("binderDied", $$robo$$android_media_AudioService_RmtSbmxFullVolDeathHandler$binderDied(), 0, this);
        }

        public /* synthetic */ RmtSbmxFullVolDeathHandler() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RmtSbmxFullVolDeathHandler)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class ForceControlStreamClient
    implements IBinder.DeathRecipient,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private IBinder mCb;
        /* synthetic */ AudioService this$0;

        private void $$robo$$android_media_AudioService_ForceControlStreamClient$__constructor__(AudioService audioService, IBinder cb) {
            if (cb != null) {
                try {
                    cb.linkToDeath(this, 0);
                }
                catch (RemoteException e) {
                    Log.w("AudioService", "ForceControlStreamClient() could not link to " + cb + " binder death");
                    cb = null;
                }
            }
            this.mCb = cb;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_AudioService_ForceControlStreamClient$binderDied() {
            Object object = this.this$0.mForceControlStreamLock;
            synchronized (object) {
                Log.w("AudioService", "SCO client died");
                if (this.this$0.mForceControlStreamClient != this) {
                    Log.w("AudioService", "unregistered control stream client died");
                } else {
                    this.this$0.mForceControlStreamClient = null;
                    this.this$0.mVolumeControlStream = -1;
                }
            }
        }

        private final void $$robo$$android_media_AudioService_ForceControlStreamClient$release() {
            if (this.mCb != null) {
                this.mCb.unlinkToDeath(this, 0);
                this.mCb = null;
            }
        }

        private void __constructor__(AudioService audioService, IBinder iBinder) {
            this.$$robo$$android_media_AudioService_ForceControlStreamClient$__constructor__(audioService, iBinder);
        }

        ForceControlStreamClient(AudioService audioService, IBinder iBinder) {
            this.this$0 = audioService;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioService_ForceControlStreamClient$__constructor__(android.media.AudioService android.os.IBinder ), 0, this, audioService, iBinder);
        }

        @Override
        public void binderDied() {
            InvokeDynamicSupport.bootstrap("binderDied", $$robo$$android_media_AudioService_ForceControlStreamClient$binderDied(), 0, this);
        }

        public void release() {
            InvokeDynamicSupport.bootstrap("release", $$robo$$android_media_AudioService_ForceControlStreamClient$release(), 0, this);
        }

        public /* synthetic */ ForceControlStreamClient() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ForceControlStreamClient)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class StreamVolumeCommand
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int mStreamType;
        public int mIndex;
        public int mFlags;
        public int mDevice;
        /* synthetic */ AudioService this$0;

        private void $$robo$$android_media_AudioService_StreamVolumeCommand$__constructor__(AudioService audioService, int streamType, int index, int flags, int device) {
            this.mStreamType = streamType;
            this.mIndex = index;
            this.mFlags = flags;
            this.mDevice = device;
        }

        private final String $$robo$$android_media_AudioService_StreamVolumeCommand$toString() {
            return "{streamType=" + this.mStreamType + ",index=" + this.mIndex + ",flags=" + this.mFlags + ",device=" + this.mDevice + '}';
        }

        private void __constructor__(AudioService audioService, int n, int n2, int n3, int n4) {
            this.$$robo$$android_media_AudioService_StreamVolumeCommand$__constructor__(audioService, n, n2, n3, n4);
        }

        StreamVolumeCommand(AudioService audioService, int n, int n2, int n3, int n4) {
            this.this$0 = audioService;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioService_StreamVolumeCommand$__constructor__(android.media.AudioService int int int int ), 0, this, audioService, n, n2, n3, n4);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_media_AudioService_StreamVolumeCommand$toString(), 0, this);
        }

        public /* synthetic */ StreamVolumeCommand() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StreamVolumeCommand)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class AudioOrientationEventListener
    extends OrientationEventListener
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ AudioService this$0;

        private void $$robo$$android_media_AudioService_AudioOrientationEventListener$__constructor__(AudioService audioService, Context context) {
        }

        private final void $$robo$$android_media_AudioService_AudioOrientationEventListener$onOrientationChanged(int orientation) {
            int newRotation = ((WindowManager)this.this$0.mContext.getSystemService("window")).getDefaultDisplay().getRotation();
            if (newRotation != this.this$0.mDeviceRotation) {
                this.this$0.mDeviceRotation = newRotation;
                this.this$0.setRotationForAudioSystem();
            }
        }

        private void __constructor__(AudioService audioService, Context context) {
            this.$$robo$$android_media_AudioService_AudioOrientationEventListener$__constructor__(audioService, context);
        }

        public AudioOrientationEventListener(AudioService audioService, Context context) {
            this.this$0 = audioService;
            super(context);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioService_AudioOrientationEventListener$__constructor__(android.media.AudioService android.content.Context ), 0, this, audioService, context);
        }

        @Override
        public void onOrientationChanged(int n) {
            InvokeDynamicSupport.bootstrap("onOrientationChanged", $$robo$$android_media_AudioService_AudioOrientationEventListener$onOrientationChanged(int ), 0, this, n);
        }

        public /* synthetic */ AudioOrientationEventListener() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AudioOrientationEventListener)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

