/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.app.ActivityThread;
import android.media.AudioAttributes;
import android.media.AudioFormat;
import android.media.AudioSystem;
import android.media.AudioTimestamp;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import com.android.internal.app.IAppOpsService;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.NioUtils;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class AudioTrack
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static float GAIN_MIN = 0.0f;
    private static float GAIN_MAX = 1.0f;
    private static int SAMPLE_RATE_HZ_MIN = 4000;
    private static int SAMPLE_RATE_HZ_MAX = 96000;
    private static int CHANNEL_COUNT_MAX = 8;
    public static int PLAYSTATE_STOPPED = 1;
    public static int PLAYSTATE_PAUSED = 2;
    public static int PLAYSTATE_PLAYING = 3;
    public static int MODE_STATIC = 0;
    public static int MODE_STREAM = 1;
    public static int STATE_UNINITIALIZED = 0;
    public static int STATE_INITIALIZED = 1;
    public static int STATE_NO_STATIC_DATA = 2;
    public static int SUCCESS = 0;
    public static int ERROR = -1;
    public static int ERROR_BAD_VALUE = -2;
    public static int ERROR_INVALID_OPERATION = -3;
    private static int ERROR_NATIVESETUP_AUDIOSYSTEM = -16;
    private static int ERROR_NATIVESETUP_INVALIDCHANNELMASK = -17;
    private static int ERROR_NATIVESETUP_INVALIDFORMAT = -18;
    private static int ERROR_NATIVESETUP_INVALIDSTREAMTYPE = -19;
    private static int ERROR_NATIVESETUP_NATIVEINITFAILED = -20;
    private static int NATIVE_EVENT_MARKER = 3;
    private static int NATIVE_EVENT_NEW_POS = 4;
    private static String TAG = "android.media.AudioTrack";
    public static int WRITE_BLOCKING = 0;
    public static int WRITE_NON_BLOCKING = 1;
    private int mState;
    private int mPlayState;
    private Object mPlayStateLock;
    private int mNativeBufferSizeInBytes;
    private int mNativeBufferSizeInFrames;
    private NativeEventHandlerDelegate mEventHandlerDelegate;
    private Looper mInitializationLooper;
    private int mSampleRate;
    private int mChannelCount;
    private int mChannels;
    private int mStreamType;
    private AudioAttributes mAttributes;
    private int mDataLoadMode;
    private int mChannelConfiguration;
    private int mAudioFormat;
    private int mSessionId;
    private IAppOpsService mAppOps;
    private long mNativeTrackInJavaObj;
    private long mJniData;
    private static int SUPPORTED_OUT_CHANNELS = 7420;

    private void $$robo$$android_media_AudioTrack$__constructor__(int streamType, int sampleRateInHz, int channelConfig, int audioFormat, int bufferSizeInBytes, int mode) throws IllegalArgumentException {
    }

    private void $$robo$$android_media_AudioTrack$__constructor__(int streamType, int sampleRateInHz, int channelConfig, int audioFormat, int bufferSizeInBytes, int mode, int sessionId) throws IllegalArgumentException {
    }

    private void $$robo$$android_media_AudioTrack$__constructor__(AudioAttributes attributes, AudioFormat format, int bufferSizeInBytes, int mode, int sessionId) throws IllegalArgumentException {
        this.mState = 0;
        this.mPlayState = 1;
        this.mPlayStateLock = new Object();
        this.mNativeBufferSizeInBytes = 0;
        this.mNativeBufferSizeInFrames = 0;
        this.mChannelCount = 1;
        this.mChannels = 4;
        this.mStreamType = 3;
        this.mDataLoadMode = 1;
        this.mChannelConfiguration = 4;
        this.mAudioFormat = 2;
        this.mSessionId = 0;
        if (attributes == null) {
            throw new IllegalArgumentException("Illegal null AudioAttributes");
        }
        if (format == null) {
            throw new IllegalArgumentException("Illegal null AudioFormat");
        }
        Looper looper = Looper.myLooper();
        if (looper == null) {
            looper = Looper.getMainLooper();
        }
        int rate = 0;
        if ((format.getPropertySetMask() & 2) != 0) {
            rate = format.getSampleRate();
        } else {
            rate = AudioSystem.getPrimaryOutputSamplingRate();
            if (rate <= 0) {
                rate = 44100;
            }
        }
        int channelMask = 12;
        if ((format.getPropertySetMask() & 4) != 0) {
            channelMask = format.getChannelMask();
        }
        int encoding = 1;
        if ((format.getPropertySetMask() & 1) != 0) {
            encoding = format.getEncoding();
        }
        this.audioParamCheck(rate, channelMask, encoding, mode);
        this.mStreamType = -1;
        this.audioBuffSizeCheck(bufferSizeInBytes);
        this.mInitializationLooper = looper;
        IBinder b = ServiceManager.getService("appops");
        this.mAppOps = IAppOpsService.Stub.asInterface(b);
        this.mAttributes = new AudioAttributes.Builder(attributes).build();
        if (sessionId < 0) {
            throw new IllegalArgumentException("Invalid audio session ID: " + sessionId);
        }
        int[] session = new int[]{sessionId};
        int initResult = this.native_setup(new WeakReference<AudioTrack>(this), this.mAttributes, this.mSampleRate, this.mChannels, this.mAudioFormat, this.mNativeBufferSizeInBytes, this.mDataLoadMode, session);
        if (initResult != 0) {
            AudioTrack.loge("Error code " + initResult + " when initializing AudioTrack.");
            return;
        }
        this.mSessionId = session[0];
        this.mState = this.mDataLoadMode == 0 ? 2 : 1;
    }

    private final void $$robo$$android_media_AudioTrack$audioParamCheck(int sampleRateInHz, int channelConfig, int audioFormat, int mode) {
        if (sampleRateInHz < 4000 || sampleRateInHz > 96000) {
            throw new IllegalArgumentException(sampleRateInHz + "Hz is not a supported sample rate.");
        }
        this.mSampleRate = sampleRateInHz;
        this.mChannelConfiguration = channelConfig;
        switch (channelConfig) {
            case 1: 
            case 2: 
            case 4: {
                this.mChannelCount = 1;
                this.mChannels = 4;
                break;
            }
            case 3: 
            case 12: {
                this.mChannelCount = 2;
                this.mChannels = 12;
                break;
            }
            default: {
                if (!AudioTrack.isMultichannelConfigSupported(channelConfig)) {
                    throw new IllegalArgumentException("Unsupported channel configuration.");
                }
                this.mChannels = channelConfig;
                this.mChannelCount = Integer.bitCount(channelConfig);
            }
        }
        if (audioFormat == 1) {
            audioFormat = 2;
        }
        if (!AudioFormat.isValidEncoding(audioFormat)) {
            throw new IllegalArgumentException("Unsupported audio encoding.");
        }
        this.mAudioFormat = audioFormat;
        if (mode != 1 && mode != 0 || mode != 1 && !AudioFormat.isEncodingLinearPcm(this.mAudioFormat)) {
            throw new IllegalArgumentException("Invalid mode.");
        }
        this.mDataLoadMode = mode;
    }

    private static final boolean $$robo$$android_media_AudioTrack$isMultichannelConfigSupported(int channelConfig) {
        if ((channelConfig & 0x1CFC) != channelConfig) {
            AudioTrack.loge("Channel configuration features unsupported channels");
            return false;
        }
        int channelCount = Integer.bitCount(channelConfig);
        if (channelCount > 8) {
            AudioTrack.loge("Channel configuration contains too many channels " + channelCount + ">" + 8);
            return false;
        }
        int frontPair = 12;
        if ((channelConfig & 0xC) != 12) {
            AudioTrack.loge("Front channels must be present in multichannel configurations");
            return false;
        }
        int backPair = 192;
        if ((channelConfig & 0xC0) != 0 && (channelConfig & 0xC0) != 192) {
            AudioTrack.loge("Rear channels can't be used independently");
            return false;
        }
        int sidePair = 6144;
        if ((channelConfig & 0x1800) != 0 && (channelConfig & 0x1800) != 6144) {
            AudioTrack.loge("Side channels can't be used independently");
            return false;
        }
        return true;
    }

    private final void $$robo$$android_media_AudioTrack$audioBuffSizeCheck(int audioBufferSize) {
        int frameSizeInBytes = AudioFormat.isEncodingLinearPcm(this.mAudioFormat) ? this.mChannelCount * AudioFormat.getBytesPerSample(this.mAudioFormat) : 1;
        if (audioBufferSize % frameSizeInBytes != 0 || audioBufferSize < 1) {
            throw new IllegalArgumentException("Invalid audio buffer size.");
        }
        this.mNativeBufferSizeInBytes = audioBufferSize;
        this.mNativeBufferSizeInFrames = audioBufferSize / frameSizeInBytes;
    }

    private final void $$robo$$android_media_AudioTrack$release() {
        try {
            this.stop();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.native_release();
        this.mState = 0;
    }

    private final void $$robo$$android_media_AudioTrack$finalize() {
        this.native_finalize();
    }

    private static final float $$robo$$android_media_AudioTrack$getMinVolume() {
        return 0.0f;
    }

    private static final float $$robo$$android_media_AudioTrack$getMaxVolume() {
        return 1.0f;
    }

    private final int $$robo$$android_media_AudioTrack$getSampleRate() {
        return this.mSampleRate;
    }

    private final int $$robo$$android_media_AudioTrack$getPlaybackRate() {
        return this.native_get_playback_rate();
    }

    private final int $$robo$$android_media_AudioTrack$getAudioFormat() {
        return this.mAudioFormat;
    }

    private final int $$robo$$android_media_AudioTrack$getStreamType() {
        return this.mStreamType;
    }

    private final int $$robo$$android_media_AudioTrack$getChannelConfiguration() {
        return this.mChannelConfiguration;
    }

    private final int $$robo$$android_media_AudioTrack$getChannelCount() {
        return this.mChannelCount;
    }

    private final int $$robo$$android_media_AudioTrack$getState() {
        return this.mState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_media_AudioTrack$getPlayState() {
        Object object = this.mPlayStateLock;
        synchronized (object) {
            return this.mPlayState;
        }
    }

    @Deprecated
    private final int $$robo$$android_media_AudioTrack$getNativeFrameCount() {
        return this.native_get_native_frame_count();
    }

    private final int $$robo$$android_media_AudioTrack$getNotificationMarkerPosition() {
        return this.native_get_marker_pos();
    }

    private final int $$robo$$android_media_AudioTrack$getPositionNotificationPeriod() {
        return this.native_get_pos_update_period();
    }

    private final int $$robo$$android_media_AudioTrack$getPlaybackHeadPosition() {
        return this.native_get_position();
    }

    private final int $$robo$$android_media_AudioTrack$getLatency() {
        return this.native_get_latency();
    }

    private static final int $$robo$$android_media_AudioTrack$getNativeOutputSampleRate(int streamType) {
        return AudioTrack.native_get_output_sample_rate(streamType);
    }

    private static final int $$robo$$android_media_AudioTrack$getMinBufferSize(int sampleRateInHz, int channelConfig, int audioFormat) {
        int channelCount = 0;
        switch (channelConfig) {
            case 2: 
            case 4: {
                channelCount = 1;
                break;
            }
            case 3: 
            case 12: {
                channelCount = 2;
                break;
            }
            default: {
                if ((channelConfig & 0x1CFC) != channelConfig) {
                    AudioTrack.loge("getMinBufferSize(): Invalid channel configuration.");
                    return -2;
                }
                channelCount = Integer.bitCount(channelConfig);
            }
        }
        if (!AudioFormat.isValidEncoding(audioFormat)) {
            AudioTrack.loge("getMinBufferSize(): Invalid audio format.");
            return -2;
        }
        if (sampleRateInHz < 4000 || sampleRateInHz > 96000) {
            AudioTrack.loge("getMinBufferSize(): " + sampleRateInHz + " Hz is not a supported sample rate.");
            return -2;
        }
        int size = AudioTrack.native_get_min_buff_size(sampleRateInHz, channelCount, audioFormat);
        if (size <= 0) {
            AudioTrack.loge("getMinBufferSize(): error querying hardware");
            return -1;
        }
        return size;
    }

    private final int $$robo$$android_media_AudioTrack$getAudioSessionId() {
        return this.mSessionId;
    }

    private final boolean $$robo$$android_media_AudioTrack$getTimestamp(AudioTimestamp timestamp) {
        if (timestamp == null) {
            throw new IllegalArgumentException();
        }
        long[] longArray = new long[2];
        int ret = this.native_get_timestamp(longArray);
        if (ret != 0) {
            return false;
        }
        timestamp.framePosition = longArray[0];
        timestamp.nanoTime = longArray[1];
        return true;
    }

    private final void $$robo$$android_media_AudioTrack$setPlaybackPositionUpdateListener(OnPlaybackPositionUpdateListener listener) {
        this.setPlaybackPositionUpdateListener(listener, null);
    }

    private final void $$robo$$android_media_AudioTrack$setPlaybackPositionUpdateListener(OnPlaybackPositionUpdateListener listener, Handler handler) {
        this.mEventHandlerDelegate = listener != null ? new NativeEventHandlerDelegate(this, this, listener, handler) : null;
    }

    private static final float $$robo$$android_media_AudioTrack$clampGainOrLevel(float gainOrLevel) {
        if (Float.isNaN(gainOrLevel)) {
            throw new IllegalArgumentException();
        }
        if (gainOrLevel < 0.0f) {
            gainOrLevel = 0.0f;
        } else if (gainOrLevel > 1.0f) {
            gainOrLevel = 1.0f;
        }
        return gainOrLevel;
    }

    private final int $$robo$$android_media_AudioTrack$setStereoVolume(float leftGain, float rightGain) {
        if (this.isRestricted()) {
            return 0;
        }
        if (this.mState == 0) {
            return -3;
        }
        leftGain = AudioTrack.clampGainOrLevel(leftGain);
        rightGain = AudioTrack.clampGainOrLevel(rightGain);
        this.native_setVolume(leftGain, rightGain);
        return 0;
    }

    private final int $$robo$$android_media_AudioTrack$setVolume(float gain) {
        return this.setStereoVolume(gain, gain);
    }

    private final int $$robo$$android_media_AudioTrack$setPlaybackRate(int sampleRateInHz) {
        if (this.mState != 1) {
            return -3;
        }
        if (sampleRateInHz <= 0) {
            return -2;
        }
        return this.native_set_playback_rate(sampleRateInHz);
    }

    private final int $$robo$$android_media_AudioTrack$setNotificationMarkerPosition(int markerInFrames) {
        if (this.mState == 0) {
            return -3;
        }
        return this.native_set_marker_pos(markerInFrames);
    }

    private final int $$robo$$android_media_AudioTrack$setPositionNotificationPeriod(int periodInFrames) {
        if (this.mState == 0) {
            return -3;
        }
        return this.native_set_pos_update_period(periodInFrames);
    }

    private final int $$robo$$android_media_AudioTrack$setPlaybackHeadPosition(int positionInFrames) {
        if (this.mDataLoadMode == 1 || this.mState != 1 || this.getPlayState() == 3) {
            return -3;
        }
        if (0 > positionInFrames || positionInFrames > this.mNativeBufferSizeInFrames) {
            return -2;
        }
        return this.native_set_position(positionInFrames);
    }

    private final int $$robo$$android_media_AudioTrack$setLoopPoints(int startInFrames, int endInFrames, int loopCount) {
        if (this.mDataLoadMode == 1 || this.mState != 1 || this.getPlayState() == 3) {
            return -3;
        }
        if (loopCount != 0 && (0 > startInFrames || startInFrames >= this.mNativeBufferSizeInFrames || startInFrames >= endInFrames || endInFrames > this.mNativeBufferSizeInFrames)) {
            return -2;
        }
        return this.native_set_loop(startInFrames, endInFrames, loopCount);
    }

    @Deprecated
    private final void $$robo$$android_media_AudioTrack$setState(int state) {
        this.mState = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_AudioTrack$play() throws IllegalStateException {
        if (this.mState != 1) {
            throw new IllegalStateException("play() called on uninitialized AudioTrack.");
        }
        if (this.isRestricted()) {
            this.setVolume(0.0f);
        }
        Object object = this.mPlayStateLock;
        synchronized (object) {
            this.native_start();
            this.mPlayState = 3;
        }
    }

    private final boolean $$robo$$android_media_AudioTrack$isRestricted() {
        try {
            int usage = AudioAttributes.usageForLegacyStreamType(this.mStreamType);
            int mode = this.mAppOps.checkAudioOperation(28, usage, Process.myUid(), ActivityThread.currentPackageName());
            return mode != 0;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_AudioTrack$stop() throws IllegalStateException {
        if (this.mState != 1) {
            throw new IllegalStateException("stop() called on uninitialized AudioTrack.");
        }
        Object object = this.mPlayStateLock;
        synchronized (object) {
            this.native_stop();
            this.mPlayState = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_AudioTrack$pause() throws IllegalStateException {
        if (this.mState != 1) {
            throw new IllegalStateException("pause() called on uninitialized AudioTrack.");
        }
        Object object = this.mPlayStateLock;
        synchronized (object) {
            this.native_pause();
            this.mPlayState = 2;
        }
    }

    private final void $$robo$$android_media_AudioTrack$flush() {
        if (this.mState == 1) {
            this.native_flush();
        }
    }

    private final int $$robo$$android_media_AudioTrack$write(byte[] audioData, int offsetInBytes, int sizeInBytes) {
        if (this.mState == 0 || this.mAudioFormat == 4) {
            return -3;
        }
        if (audioData == null || offsetInBytes < 0 || sizeInBytes < 0 || offsetInBytes + sizeInBytes < 0 || offsetInBytes + sizeInBytes > audioData.length) {
            return -2;
        }
        int ret = this.native_write_byte(audioData, offsetInBytes, sizeInBytes, this.mAudioFormat, true);
        if (this.mDataLoadMode == 0 && this.mState == 2 && ret > 0) {
            this.mState = 1;
        }
        return ret;
    }

    private final int $$robo$$android_media_AudioTrack$write(short[] audioData, int offsetInShorts, int sizeInShorts) {
        if (this.mState == 0 || this.mAudioFormat == 4) {
            return -3;
        }
        if (audioData == null || offsetInShorts < 0 || sizeInShorts < 0 || offsetInShorts + sizeInShorts < 0 || offsetInShorts + sizeInShorts > audioData.length) {
            return -2;
        }
        int ret = this.native_write_short(audioData, offsetInShorts, sizeInShorts, this.mAudioFormat);
        if (this.mDataLoadMode == 0 && this.mState == 2 && ret > 0) {
            this.mState = 1;
        }
        return ret;
    }

    private final int $$robo$$android_media_AudioTrack$write(float[] audioData, int offsetInFloats, int sizeInFloats, int writeMode) {
        if (this.mState == 0) {
            Log.e("android.media.AudioTrack", "AudioTrack.write() called in invalid state STATE_UNINITIALIZED");
            return -3;
        }
        if (this.mAudioFormat != 4) {
            Log.e("android.media.AudioTrack", "AudioTrack.write(float[] ...) requires format ENCODING_PCM_FLOAT");
            return -3;
        }
        if (writeMode != 0 && writeMode != 1) {
            Log.e("android.media.AudioTrack", "AudioTrack.write() called with invalid blocking mode");
            return -2;
        }
        if (audioData == null || offsetInFloats < 0 || sizeInFloats < 0 || offsetInFloats + sizeInFloats < 0 || offsetInFloats + sizeInFloats > audioData.length) {
            Log.e("android.media.AudioTrack", "AudioTrack.write() called with invalid array, offset, or size");
            return -2;
        }
        int ret = this.native_write_float(audioData, offsetInFloats, sizeInFloats, this.mAudioFormat, writeMode == 0);
        if (this.mDataLoadMode == 0 && this.mState == 2 && ret > 0) {
            this.mState = 1;
        }
        return ret;
    }

    private final int $$robo$$android_media_AudioTrack$write(ByteBuffer audioData, int sizeInBytes, int writeMode) {
        if (this.mState == 0) {
            Log.e("android.media.AudioTrack", "AudioTrack.write() called in invalid state STATE_UNINITIALIZED");
            return -3;
        }
        if (writeMode != 0 && writeMode != 1) {
            Log.e("android.media.AudioTrack", "AudioTrack.write() called with invalid blocking mode");
            return -2;
        }
        if (audioData == null || sizeInBytes < 0 || sizeInBytes > audioData.remaining()) {
            Log.e("android.media.AudioTrack", "AudioTrack.write() called with invalid size (" + sizeInBytes + ") value");
            return -2;
        }
        int ret = 0;
        ret = audioData.isDirect() ? this.native_write_native_bytes(audioData, audioData.position(), sizeInBytes, this.mAudioFormat, writeMode == 0) : this.native_write_byte(NioUtils.unsafeArray(audioData), NioUtils.unsafeArrayOffset(audioData) + audioData.position(), sizeInBytes, this.mAudioFormat, writeMode == 0);
        if (this.mDataLoadMode == 0 && this.mState == 2 && ret > 0) {
            this.mState = 1;
        }
        if (ret > 0) {
            audioData.position(audioData.position() + ret);
        }
        return ret;
    }

    private final int $$robo$$android_media_AudioTrack$reloadStaticData() {
        if (this.mDataLoadMode == 1 || this.mState != 1) {
            return -3;
        }
        return this.native_reload_static();
    }

    private final int $$robo$$android_media_AudioTrack$attachAuxEffect(int effectId) {
        if (this.mState == 0) {
            return -3;
        }
        return this.native_attachAuxEffect(effectId);
    }

    private final int $$robo$$android_media_AudioTrack$setAuxEffectSendLevel(float level) {
        if (this.isRestricted()) {
            return 0;
        }
        if (this.mState == 0) {
            return -3;
        }
        int err = this.native_setAuxEffectSendLevel(level = AudioTrack.clampGainOrLevel(level));
        return err == 0 ? 0 : -1;
    }

    private static final void $$robo$$android_media_AudioTrack$postEventFromNative(Object audiotrack_ref, int what, int arg1, int arg2, Object obj) {
        Handler handler;
        AudioTrack track = (AudioTrack)((WeakReference)audiotrack_ref).get();
        if (track == null) {
            return;
        }
        NativeEventHandlerDelegate delegate = track.mEventHandlerDelegate;
        if (delegate != null && (handler = delegate.getHandler()) != null) {
            Message m = handler.obtainMessage(what, arg1, arg2, obj);
            handler.sendMessage(m);
        }
    }

    private final int $$robo$$android_media_AudioTrack$native_setup(Object object, Object object2, int n, int n2, int n3, int n4, int n5, int[] nArray) {
        return 0;
    }

    private final void $$robo$$android_media_AudioTrack$native_finalize() {
    }

    private final void $$robo$$android_media_AudioTrack$native_release() {
    }

    private final void $$robo$$android_media_AudioTrack$native_start() {
    }

    private final void $$robo$$android_media_AudioTrack$native_stop() {
    }

    private final void $$robo$$android_media_AudioTrack$native_pause() {
    }

    private final void $$robo$$android_media_AudioTrack$native_flush() {
    }

    private final int $$robo$$android_media_AudioTrack$native_write_byte(byte[] byArray, int n, int n2, int n3, boolean bl) {
        return 0;
    }

    private final int $$robo$$android_media_AudioTrack$native_write_short(short[] sArray, int n, int n2, int n3) {
        return 0;
    }

    private final int $$robo$$android_media_AudioTrack$native_write_float(float[] fArray, int n, int n2, int n3, boolean bl) {
        return 0;
    }

    private final int $$robo$$android_media_AudioTrack$native_write_native_bytes(Object object, int n, int n2, int n3, boolean bl) {
        return 0;
    }

    private final int $$robo$$android_media_AudioTrack$native_reload_static() {
        return 0;
    }

    private final int $$robo$$android_media_AudioTrack$native_get_native_frame_count() {
        return 0;
    }

    private final void $$robo$$android_media_AudioTrack$native_setVolume(float f, float f2) {
    }

    private final int $$robo$$android_media_AudioTrack$native_set_playback_rate(int n) {
        return 0;
    }

    private final int $$robo$$android_media_AudioTrack$native_get_playback_rate() {
        return 0;
    }

    private final int $$robo$$android_media_AudioTrack$native_set_marker_pos(int n) {
        return 0;
    }

    private final int $$robo$$android_media_AudioTrack$native_get_marker_pos() {
        return 0;
    }

    private final int $$robo$$android_media_AudioTrack$native_set_pos_update_period(int n) {
        return 0;
    }

    private final int $$robo$$android_media_AudioTrack$native_get_pos_update_period() {
        return 0;
    }

    private final int $$robo$$android_media_AudioTrack$native_set_position(int n) {
        return 0;
    }

    private final int $$robo$$android_media_AudioTrack$native_get_position() {
        return 0;
    }

    private final int $$robo$$android_media_AudioTrack$native_get_latency() {
        return 0;
    }

    private final int $$robo$$android_media_AudioTrack$native_get_timestamp(long[] lArray) {
        return 0;
    }

    private final int $$robo$$android_media_AudioTrack$native_set_loop(int n, int n2, int n3) {
        return 0;
    }

    private static final int $$robo$$android_media_AudioTrack$native_get_output_sample_rate(int n) {
        return 0;
    }

    private static final int $$robo$$android_media_AudioTrack$native_get_min_buff_size(int n, int n2, int n3) {
        return 0;
    }

    private final int $$robo$$android_media_AudioTrack$native_attachAuxEffect(int n) {
        return 0;
    }

    private final int $$robo$$android_media_AudioTrack$native_setAuxEffectSendLevel(float f) {
        return 0;
    }

    private static final void $$robo$$android_media_AudioTrack$logd(String msg) {
        Log.d("android.media.AudioTrack", msg);
    }

    private static final void $$robo$$android_media_AudioTrack$loge(String msg) {
        Log.e("android.media.AudioTrack", msg);
    }

    private void __constructor__(int n, int n2, int n3, int n4, int n5, int n6) throws IllegalArgumentException {
        this.$$robo$$android_media_AudioTrack$__constructor__(n, n2, n3, n4, n5, n6);
    }

    public AudioTrack(int n, int n2, int n3, int n4, int n5, int n6) throws IllegalArgumentException {
        this(n, n2, n3, n4, n5, n6, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioTrack$__constructor__(int int int int int int ), 0, this, n, n2, n3, n4, n5, n6);
    }

    private void __constructor__(int n, int n2, int n3, int n4, int n5, int n6, int n7) throws IllegalArgumentException {
        this.$$robo$$android_media_AudioTrack$__constructor__(n, n2, n3, n4, n5, n6, n7);
    }

    public AudioTrack(int n, int n2, int n3, int n4, int n5, int n6, int n7) throws IllegalArgumentException {
        this(new AudioAttributes.Builder().setLegacyStreamType(n).build(), new AudioFormat.Builder().setChannelMask(n3).setEncoding(n4).setSampleRate(n2).build(), n5, n6, n7);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioTrack$__constructor__(int int int int int int int ), 0, this, n, n2, n3, n4, n5, n6, n7);
    }

    private void __constructor__(AudioAttributes audioAttributes, AudioFormat audioFormat, int n, int n2, int n3) throws IllegalArgumentException {
        this.$$robo$$android_media_AudioTrack$__constructor__(audioAttributes, audioFormat, n, n2, n3);
    }

    public AudioTrack(AudioAttributes audioAttributes, AudioFormat audioFormat, int n, int n2, int n3) throws IllegalArgumentException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioTrack$__constructor__(android.media.AudioAttributes android.media.AudioFormat int int int ), 0, this, audioAttributes, audioFormat, n, n2, n3);
    }

    private void audioParamCheck(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("audioParamCheck", $$robo$$android_media_AudioTrack$audioParamCheck(int int int int ), 0, this, n, n2, n3, n4);
    }

    private static boolean isMultichannelConfigSupported(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isMultichannelConfigSupported", $$robo$$android_media_AudioTrack$isMultichannelConfigSupported(int ), 0, (int)n);
    }

    private void audioBuffSizeCheck(int n) {
        InvokeDynamicSupport.bootstrap("audioBuffSizeCheck", $$robo$$android_media_AudioTrack$audioBuffSizeCheck(int ), 0, this, n);
    }

    public void release() {
        InvokeDynamicSupport.bootstrap("release", $$robo$$android_media_AudioTrack$release(), 0, this);
    }

    protected void finalize() {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_media_AudioTrack$finalize(), 0, this);
    }

    public static float getMinVolume() {
        return (float)InvokeDynamicSupport.bootstrapStatic("getMinVolume", $$robo$$android_media_AudioTrack$getMinVolume(), 0);
    }

    public static float getMaxVolume() {
        return (float)InvokeDynamicSupport.bootstrapStatic("getMaxVolume", $$robo$$android_media_AudioTrack$getMaxVolume(), 0);
    }

    public int getSampleRate() {
        return (int)InvokeDynamicSupport.bootstrap("getSampleRate", $$robo$$android_media_AudioTrack$getSampleRate(), 0, this);
    }

    public int getPlaybackRate() {
        return (int)InvokeDynamicSupport.bootstrap("getPlaybackRate", $$robo$$android_media_AudioTrack$getPlaybackRate(), 0, this);
    }

    public int getAudioFormat() {
        return (int)InvokeDynamicSupport.bootstrap("getAudioFormat", $$robo$$android_media_AudioTrack$getAudioFormat(), 0, this);
    }

    public int getStreamType() {
        return (int)InvokeDynamicSupport.bootstrap("getStreamType", $$robo$$android_media_AudioTrack$getStreamType(), 0, this);
    }

    public int getChannelConfiguration() {
        return (int)InvokeDynamicSupport.bootstrap("getChannelConfiguration", $$robo$$android_media_AudioTrack$getChannelConfiguration(), 0, this);
    }

    public int getChannelCount() {
        return (int)InvokeDynamicSupport.bootstrap("getChannelCount", $$robo$$android_media_AudioTrack$getChannelCount(), 0, this);
    }

    public int getState() {
        return (int)InvokeDynamicSupport.bootstrap("getState", $$robo$$android_media_AudioTrack$getState(), 0, this);
    }

    public int getPlayState() {
        return (int)InvokeDynamicSupport.bootstrap("getPlayState", $$robo$$android_media_AudioTrack$getPlayState(), 0, this);
    }

    @Deprecated
    protected int getNativeFrameCount() {
        return (int)InvokeDynamicSupport.bootstrap("getNativeFrameCount", $$robo$$android_media_AudioTrack$getNativeFrameCount(), 0, this);
    }

    public int getNotificationMarkerPosition() {
        return (int)InvokeDynamicSupport.bootstrap("getNotificationMarkerPosition", $$robo$$android_media_AudioTrack$getNotificationMarkerPosition(), 0, this);
    }

    public int getPositionNotificationPeriod() {
        return (int)InvokeDynamicSupport.bootstrap("getPositionNotificationPeriod", $$robo$$android_media_AudioTrack$getPositionNotificationPeriod(), 0, this);
    }

    public int getPlaybackHeadPosition() {
        return (int)InvokeDynamicSupport.bootstrap("getPlaybackHeadPosition", $$robo$$android_media_AudioTrack$getPlaybackHeadPosition(), 0, this);
    }

    public int getLatency() {
        return (int)InvokeDynamicSupport.bootstrap("getLatency", $$robo$$android_media_AudioTrack$getLatency(), 0, this);
    }

    public static int getNativeOutputSampleRate(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getNativeOutputSampleRate", $$robo$$android_media_AudioTrack$getNativeOutputSampleRate(int ), 0, (int)n);
    }

    public static int getMinBufferSize(int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getMinBufferSize", $$robo$$android_media_AudioTrack$getMinBufferSize(int int int ), 0, (int)n, (int)n2, (int)n3);
    }

    public int getAudioSessionId() {
        return (int)InvokeDynamicSupport.bootstrap("getAudioSessionId", $$robo$$android_media_AudioTrack$getAudioSessionId(), 0, this);
    }

    public boolean getTimestamp(AudioTimestamp audioTimestamp) {
        return (boolean)InvokeDynamicSupport.bootstrap("getTimestamp", $$robo$$android_media_AudioTrack$getTimestamp(android.media.AudioTimestamp ), 0, this, audioTimestamp);
    }

    public void setPlaybackPositionUpdateListener(OnPlaybackPositionUpdateListener onPlaybackPositionUpdateListener) {
        InvokeDynamicSupport.bootstrap("setPlaybackPositionUpdateListener", $$robo$$android_media_AudioTrack$setPlaybackPositionUpdateListener(android.media.AudioTrack$OnPlaybackPositionUpdateListener ), 0, this, onPlaybackPositionUpdateListener);
    }

    public void setPlaybackPositionUpdateListener(OnPlaybackPositionUpdateListener onPlaybackPositionUpdateListener, Handler handler) {
        InvokeDynamicSupport.bootstrap("setPlaybackPositionUpdateListener", $$robo$$android_media_AudioTrack$setPlaybackPositionUpdateListener(android.media.AudioTrack$OnPlaybackPositionUpdateListener android.os.Handler ), 0, this, onPlaybackPositionUpdateListener, handler);
    }

    private static float clampGainOrLevel(float f) {
        return (float)InvokeDynamicSupport.bootstrapStatic("clampGainOrLevel", $$robo$$android_media_AudioTrack$clampGainOrLevel(float ), 0, (float)f);
    }

    public int setStereoVolume(float f, float f2) {
        return (int)InvokeDynamicSupport.bootstrap("setStereoVolume", $$robo$$android_media_AudioTrack$setStereoVolume(float float ), 0, this, f, f2);
    }

    public int setVolume(float f) {
        return (int)InvokeDynamicSupport.bootstrap("setVolume", $$robo$$android_media_AudioTrack$setVolume(float ), 0, this, f);
    }

    public int setPlaybackRate(int n) {
        return (int)InvokeDynamicSupport.bootstrap("setPlaybackRate", $$robo$$android_media_AudioTrack$setPlaybackRate(int ), 0, this, n);
    }

    public int setNotificationMarkerPosition(int n) {
        return (int)InvokeDynamicSupport.bootstrap("setNotificationMarkerPosition", $$robo$$android_media_AudioTrack$setNotificationMarkerPosition(int ), 0, this, n);
    }

    public int setPositionNotificationPeriod(int n) {
        return (int)InvokeDynamicSupport.bootstrap("setPositionNotificationPeriod", $$robo$$android_media_AudioTrack$setPositionNotificationPeriod(int ), 0, this, n);
    }

    public int setPlaybackHeadPosition(int n) {
        return (int)InvokeDynamicSupport.bootstrap("setPlaybackHeadPosition", $$robo$$android_media_AudioTrack$setPlaybackHeadPosition(int ), 0, this, n);
    }

    public int setLoopPoints(int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrap("setLoopPoints", $$robo$$android_media_AudioTrack$setLoopPoints(int int int ), 0, this, n, n2, n3);
    }

    @Deprecated
    protected void setState(int n) {
        InvokeDynamicSupport.bootstrap("setState", $$robo$$android_media_AudioTrack$setState(int ), 0, this, n);
    }

    public void play() throws IllegalStateException {
        InvokeDynamicSupport.bootstrap("play", $$robo$$android_media_AudioTrack$play(), 0, this);
    }

    private boolean isRestricted() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRestricted", $$robo$$android_media_AudioTrack$isRestricted(), 0, this);
    }

    public void stop() throws IllegalStateException {
        InvokeDynamicSupport.bootstrap("stop", $$robo$$android_media_AudioTrack$stop(), 0, this);
    }

    public void pause() throws IllegalStateException {
        InvokeDynamicSupport.bootstrap("pause", $$robo$$android_media_AudioTrack$pause(), 0, this);
    }

    public void flush() {
        InvokeDynamicSupport.bootstrap("flush", $$robo$$android_media_AudioTrack$flush(), 0, this);
    }

    public int write(byte[] byArray, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("write", $$robo$$android_media_AudioTrack$write(byte[] int int ), 0, this, byArray, n, n2);
    }

    public int write(short[] sArray, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("write", $$robo$$android_media_AudioTrack$write(short[] int int ), 0, this, sArray, n, n2);
    }

    public int write(float[] fArray, int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrap("write", $$robo$$android_media_AudioTrack$write(float[] int int int ), 0, this, fArray, n, n2, n3);
    }

    public int write(ByteBuffer byteBuffer, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("write", $$robo$$android_media_AudioTrack$write(java.nio.ByteBuffer int int ), 0, this, byteBuffer, n, n2);
    }

    public int reloadStaticData() {
        return (int)InvokeDynamicSupport.bootstrap("reloadStaticData", $$robo$$android_media_AudioTrack$reloadStaticData(), 0, this);
    }

    public int attachAuxEffect(int n) {
        return (int)InvokeDynamicSupport.bootstrap("attachAuxEffect", $$robo$$android_media_AudioTrack$attachAuxEffect(int ), 0, this, n);
    }

    public int setAuxEffectSendLevel(float f) {
        return (int)InvokeDynamicSupport.bootstrap("setAuxEffectSendLevel", $$robo$$android_media_AudioTrack$setAuxEffectSendLevel(float ), 0, this, f);
    }

    private static void postEventFromNative(Object object, int n, int n2, int n3, Object object2) {
        InvokeDynamicSupport.bootstrapStatic("postEventFromNative", $$robo$$android_media_AudioTrack$postEventFromNative(java.lang.Object int int int java.lang.Object ), 0, (Object)object, (int)n, (int)n2, (int)n3, (Object)object2);
    }

    private final native /* synthetic */ int $$robo$$native_setup$nativeBinding(Object var1, Object var2, int var3, int var4, int var5, int var6, int var7, int[] var8);

    private int native_setup(Object object, Object object2, int n, int n2, int n3, int n4, int n5, int[] nArray) {
        return (int)InvokeDynamicSupport.bootstrap("native_setup", $$robo$$android_media_AudioTrack$native_setup(java.lang.Object java.lang.Object int int int int int int[] ), 1, this, object, object2, n, n2, n3, n4, n5, nArray);
    }

    private final native /* synthetic */ void $$robo$$native_finalize$nativeBinding();

    private void native_finalize() {
        InvokeDynamicSupport.bootstrap("native_finalize", $$robo$$android_media_AudioTrack$native_finalize(), 1, this);
    }

    private final native /* synthetic */ void $$robo$$native_release$nativeBinding();

    private void native_release() {
        InvokeDynamicSupport.bootstrap("native_release", $$robo$$android_media_AudioTrack$native_release(), 1, this);
    }

    private final native /* synthetic */ void $$robo$$native_start$nativeBinding();

    private void native_start() {
        InvokeDynamicSupport.bootstrap("native_start", $$robo$$android_media_AudioTrack$native_start(), 1, this);
    }

    private final native /* synthetic */ void $$robo$$native_stop$nativeBinding();

    private void native_stop() {
        InvokeDynamicSupport.bootstrap("native_stop", $$robo$$android_media_AudioTrack$native_stop(), 1, this);
    }

    private final native /* synthetic */ void $$robo$$native_pause$nativeBinding();

    private void native_pause() {
        InvokeDynamicSupport.bootstrap("native_pause", $$robo$$android_media_AudioTrack$native_pause(), 1, this);
    }

    private final native /* synthetic */ void $$robo$$native_flush$nativeBinding();

    private void native_flush() {
        InvokeDynamicSupport.bootstrap("native_flush", $$robo$$android_media_AudioTrack$native_flush(), 1, this);
    }

    private final native /* synthetic */ int $$robo$$native_write_byte$nativeBinding(byte[] var1, int var2, int var3, int var4, boolean var5);

    private int native_write_byte(byte[] byArray, int n, int n2, int n3, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("native_write_byte", $$robo$$android_media_AudioTrack$native_write_byte(byte[] int int int boolean ), 1, this, byArray, n, n2, n3, bl);
    }

    private final native /* synthetic */ int $$robo$$native_write_short$nativeBinding(short[] var1, int var2, int var3, int var4);

    private int native_write_short(short[] sArray, int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrap("native_write_short", $$robo$$android_media_AudioTrack$native_write_short(short[] int int int ), 1, this, sArray, n, n2, n3);
    }

    private final native /* synthetic */ int $$robo$$native_write_float$nativeBinding(float[] var1, int var2, int var3, int var4, boolean var5);

    private int native_write_float(float[] fArray, int n, int n2, int n3, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("native_write_float", $$robo$$android_media_AudioTrack$native_write_float(float[] int int int boolean ), 1, this, fArray, n, n2, n3, bl);
    }

    private final native /* synthetic */ int $$robo$$native_write_native_bytes$nativeBinding(Object var1, int var2, int var3, int var4, boolean var5);

    private int native_write_native_bytes(Object object, int n, int n2, int n3, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("native_write_native_bytes", $$robo$$android_media_AudioTrack$native_write_native_bytes(java.lang.Object int int int boolean ), 1, this, object, n, n2, n3, bl);
    }

    private final native /* synthetic */ int $$robo$$native_reload_static$nativeBinding();

    private int native_reload_static() {
        return (int)InvokeDynamicSupport.bootstrap("native_reload_static", $$robo$$android_media_AudioTrack$native_reload_static(), 1, this);
    }

    private final native /* synthetic */ int $$robo$$native_get_native_frame_count$nativeBinding();

    private int native_get_native_frame_count() {
        return (int)InvokeDynamicSupport.bootstrap("native_get_native_frame_count", $$robo$$android_media_AudioTrack$native_get_native_frame_count(), 1, this);
    }

    private final native /* synthetic */ void $$robo$$native_setVolume$nativeBinding(float var1, float var2);

    private void native_setVolume(float f, float f2) {
        InvokeDynamicSupport.bootstrap("native_setVolume", $$robo$$android_media_AudioTrack$native_setVolume(float float ), 1, this, f, f2);
    }

    private final native /* synthetic */ int $$robo$$native_set_playback_rate$nativeBinding(int var1);

    private int native_set_playback_rate(int n) {
        return (int)InvokeDynamicSupport.bootstrap("native_set_playback_rate", $$robo$$android_media_AudioTrack$native_set_playback_rate(int ), 1, this, n);
    }

    private final native /* synthetic */ int $$robo$$native_get_playback_rate$nativeBinding();

    private int native_get_playback_rate() {
        return (int)InvokeDynamicSupport.bootstrap("native_get_playback_rate", $$robo$$android_media_AudioTrack$native_get_playback_rate(), 1, this);
    }

    private final native /* synthetic */ int $$robo$$native_set_marker_pos$nativeBinding(int var1);

    private int native_set_marker_pos(int n) {
        return (int)InvokeDynamicSupport.bootstrap("native_set_marker_pos", $$robo$$android_media_AudioTrack$native_set_marker_pos(int ), 1, this, n);
    }

    private final native /* synthetic */ int $$robo$$native_get_marker_pos$nativeBinding();

    private int native_get_marker_pos() {
        return (int)InvokeDynamicSupport.bootstrap("native_get_marker_pos", $$robo$$android_media_AudioTrack$native_get_marker_pos(), 1, this);
    }

    private final native /* synthetic */ int $$robo$$native_set_pos_update_period$nativeBinding(int var1);

    private int native_set_pos_update_period(int n) {
        return (int)InvokeDynamicSupport.bootstrap("native_set_pos_update_period", $$robo$$android_media_AudioTrack$native_set_pos_update_period(int ), 1, this, n);
    }

    private final native /* synthetic */ int $$robo$$native_get_pos_update_period$nativeBinding();

    private int native_get_pos_update_period() {
        return (int)InvokeDynamicSupport.bootstrap("native_get_pos_update_period", $$robo$$android_media_AudioTrack$native_get_pos_update_period(), 1, this);
    }

    private final native /* synthetic */ int $$robo$$native_set_position$nativeBinding(int var1);

    private int native_set_position(int n) {
        return (int)InvokeDynamicSupport.bootstrap("native_set_position", $$robo$$android_media_AudioTrack$native_set_position(int ), 1, this, n);
    }

    private final native /* synthetic */ int $$robo$$native_get_position$nativeBinding();

    private int native_get_position() {
        return (int)InvokeDynamicSupport.bootstrap("native_get_position", $$robo$$android_media_AudioTrack$native_get_position(), 1, this);
    }

    private final native /* synthetic */ int $$robo$$native_get_latency$nativeBinding();

    private int native_get_latency() {
        return (int)InvokeDynamicSupport.bootstrap("native_get_latency", $$robo$$android_media_AudioTrack$native_get_latency(), 1, this);
    }

    private final native /* synthetic */ int $$robo$$native_get_timestamp$nativeBinding(long[] var1);

    private int native_get_timestamp(long[] lArray) {
        return (int)InvokeDynamicSupport.bootstrap("native_get_timestamp", $$robo$$android_media_AudioTrack$native_get_timestamp(long[] ), 1, this, lArray);
    }

    private final native /* synthetic */ int $$robo$$native_set_loop$nativeBinding(int var1, int var2, int var3);

    private int native_set_loop(int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrap("native_set_loop", $$robo$$android_media_AudioTrack$native_set_loop(int int int ), 1, this, n, n2, n3);
    }

    private static final native /* synthetic */ int $$robo$$native_get_output_sample_rate$nativeBinding(int var0);

    private static int native_get_output_sample_rate(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("native_get_output_sample_rate", $$robo$$android_media_AudioTrack$native_get_output_sample_rate(int ), 1, (int)n);
    }

    private static final native /* synthetic */ int $$robo$$native_get_min_buff_size$nativeBinding(int var0, int var1, int var2);

    private static int native_get_min_buff_size(int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrapStatic("native_get_min_buff_size", $$robo$$android_media_AudioTrack$native_get_min_buff_size(int int int ), 1, (int)n, (int)n2, (int)n3);
    }

    private final native /* synthetic */ int $$robo$$native_attachAuxEffect$nativeBinding(int var1);

    private int native_attachAuxEffect(int n) {
        return (int)InvokeDynamicSupport.bootstrap("native_attachAuxEffect", $$robo$$android_media_AudioTrack$native_attachAuxEffect(int ), 1, this, n);
    }

    private final native /* synthetic */ int $$robo$$native_setAuxEffectSendLevel$nativeBinding(float var1);

    private int native_setAuxEffectSendLevel(float f) {
        return (int)InvokeDynamicSupport.bootstrap("native_setAuxEffectSendLevel", $$robo$$android_media_AudioTrack$native_setAuxEffectSendLevel(float ), 1, this, f);
    }

    private static void logd(String string2) {
        InvokeDynamicSupport.bootstrapStatic("logd", $$robo$$android_media_AudioTrack$logd(java.lang.String ), 0, (String)string2);
    }

    private static void loge(String string2) {
        InvokeDynamicSupport.bootstrapStatic("loge", $$robo$$android_media_AudioTrack$loge(java.lang.String ), 0, (String)string2);
    }

    public /* synthetic */ AudioTrack() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AudioTrack)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class NativeEventHandlerDelegate
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Handler mHandler;
        /* synthetic */ AudioTrack this$0;

        private void $$robo$$android_media_AudioTrack_NativeEventHandlerDelegate$__constructor__(AudioTrack audioTrack, AudioTrack track, OnPlaybackPositionUpdateListener listener, Handler handler) {
            Looper looper = handler != null ? handler.getLooper() : audioTrack.mInitializationLooper;
            this.mHandler = looper != null ? new ShadowedObject(this, looper, audioTrack, track, listener){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ AudioTrack val$this$0;
                /* synthetic */ AudioTrack val$track;
                /* synthetic */ OnPlaybackPositionUpdateListener val$listener;
                /* synthetic */ NativeEventHandlerDelegate this$1;

                private void $$robo$$android_media_AudioTrack_NativeEventHandlerDelegate_1$__constructor__(NativeEventHandlerDelegate nativeEventHandlerDelegate, Looper x0, AudioTrack audioTrack, AudioTrack audioTrack2, OnPlaybackPositionUpdateListener onPlaybackPositionUpdateListener) {
                }

                private final void $$robo$$android_media_AudioTrack_NativeEventHandlerDelegate_1$handleMessage(Message msg) {
                    if (this.val$track == null) {
                        return;
                    }
                    switch (msg.what) {
                        case 3: {
                            if (this.val$listener == null) break;
                            this.val$listener.onMarkerReached(this.val$track);
                            break;
                        }
                        case 4: {
                            if (this.val$listener == null) break;
                            this.val$listener.onPeriodicNotification(this.val$track);
                            break;
                        }
                        default: {
                            AudioTrack.loge("Unknown native event type: " + msg.what);
                        }
                    }
                }

                private void __constructor__(NativeEventHandlerDelegate nativeEventHandlerDelegate, Looper looper, AudioTrack audioTrack, AudioTrack audioTrack2, OnPlaybackPositionUpdateListener onPlaybackPositionUpdateListener) {
                    this.$$robo$$android_media_AudioTrack_NativeEventHandlerDelegate_1$__constructor__(nativeEventHandlerDelegate, looper, audioTrack, audioTrack2, onPlaybackPositionUpdateListener);
                }
                {
                    this.this$1 = nativeEventHandlerDelegate;
                    this.val$this$0 = audioTrack;
                    this.val$track = audioTrack2;
                    this.val$listener = onPlaybackPositionUpdateListener;
                    super(looper);
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioTrack_NativeEventHandlerDelegate_1$__constructor__(android.media.AudioTrack$NativeEventHandlerDelegate android.os.Looper android.media.AudioTrack android.media.AudioTrack android.media.AudioTrack$OnPlaybackPositionUpdateListener ), 0, this, nativeEventHandlerDelegate, looper, audioTrack, audioTrack2, onPlaybackPositionUpdateListener);
                }

                @Override
                public void handleMessage(Message message) {
                    InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_media_AudioTrack_NativeEventHandlerDelegate_1$handleMessage(android.os.Message ), 0, this, message);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            } : null;
        }

        private final Handler $$robo$$android_media_AudioTrack_NativeEventHandlerDelegate$getHandler() {
            return this.mHandler;
        }

        private void __constructor__(AudioTrack audioTrack, AudioTrack audioTrack2, OnPlaybackPositionUpdateListener onPlaybackPositionUpdateListener, Handler handler) {
            this.$$robo$$android_media_AudioTrack_NativeEventHandlerDelegate$__constructor__(audioTrack, audioTrack2, onPlaybackPositionUpdateListener, handler);
        }

        NativeEventHandlerDelegate(AudioTrack audioTrack, AudioTrack audioTrack2, OnPlaybackPositionUpdateListener onPlaybackPositionUpdateListener, Handler handler) {
            this.this$0 = audioTrack;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioTrack_NativeEventHandlerDelegate$__constructor__(android.media.AudioTrack android.media.AudioTrack android.media.AudioTrack$OnPlaybackPositionUpdateListener android.os.Handler ), 0, this, audioTrack, audioTrack2, onPlaybackPositionUpdateListener, handler);
        }

        Handler getHandler() {
            return InvokeDynamicSupport.bootstrap("getHandler", $$robo$$android_media_AudioTrack_NativeEventHandlerDelegate$getHandler(), 0, this);
        }

        public /* synthetic */ NativeEventHandlerDelegate() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NativeEventHandlerDelegate)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface OnPlaybackPositionUpdateListener
    extends InstrumentedInterface {
        public void onMarkerReached(AudioTrack var1);

        public void onPeriodicNotification(AudioTrack var1);
    }
}

