/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import java.io.IOException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ExifInterface
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static String TAG_ORIENTATION = "Orientation";
    public static String TAG_DATETIME = "DateTime";
    public static String TAG_MAKE = "Make";
    public static String TAG_MODEL = "Model";
    public static String TAG_FLASH = "Flash";
    public static String TAG_IMAGE_WIDTH = "ImageWidth";
    public static String TAG_IMAGE_LENGTH = "ImageLength";
    public static String TAG_GPS_LATITUDE = "GPSLatitude";
    public static String TAG_GPS_LONGITUDE = "GPSLongitude";
    public static String TAG_GPS_LATITUDE_REF = "GPSLatitudeRef";
    public static String TAG_GPS_LONGITUDE_REF = "GPSLongitudeRef";
    public static String TAG_EXPOSURE_TIME = "ExposureTime";
    public static String TAG_APERTURE = "FNumber";
    public static String TAG_ISO = "ISOSpeedRatings";
    public static String TAG_GPS_ALTITUDE = "GPSAltitude";
    public static String TAG_GPS_ALTITUDE_REF = "GPSAltitudeRef";
    public static String TAG_GPS_TIMESTAMP = "GPSTimeStamp";
    public static String TAG_GPS_DATESTAMP = "GPSDateStamp";
    public static String TAG_WHITE_BALANCE = "WhiteBalance";
    public static String TAG_FOCAL_LENGTH = "FocalLength";
    public static String TAG_GPS_PROCESSING_METHOD = "GPSProcessingMethod";
    public static int ORIENTATION_UNDEFINED = 0;
    public static int ORIENTATION_NORMAL = 1;
    public static int ORIENTATION_FLIP_HORIZONTAL = 2;
    public static int ORIENTATION_ROTATE_180 = 3;
    public static int ORIENTATION_FLIP_VERTICAL = 4;
    public static int ORIENTATION_TRANSPOSE = 5;
    public static int ORIENTATION_ROTATE_90 = 6;
    public static int ORIENTATION_TRANSVERSE = 7;
    public static int ORIENTATION_ROTATE_270 = 8;
    public static int WHITEBALANCE_AUTO = 0;
    public static int WHITEBALANCE_MANUAL = 1;
    private static SimpleDateFormat sFormatter;
    private String mFilename;
    private HashMap<String, String> mAttributes;
    private boolean mHasThumbnail;
    private static Object sLock;

    private void $$robo$$android_media_ExifInterface$__constructor__(String filename) throws IOException {
        if (filename == null) {
            throw new IllegalArgumentException("filename cannot be null");
        }
        this.mFilename = filename;
        this.loadAttributes();
    }

    private final String $$robo$$android_media_ExifInterface$getAttribute(String tag) {
        return this.mAttributes.get(tag);
    }

    private final int $$robo$$android_media_ExifInterface$getAttributeInt(String tag, int defaultValue) {
        String value = this.mAttributes.get(tag);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    private final double $$robo$$android_media_ExifInterface$getAttributeDouble(String tag, double defaultValue) {
        String value = this.mAttributes.get(tag);
        if (value == null) {
            return defaultValue;
        }
        try {
            int index = value.indexOf("/");
            if (index == -1) {
                return defaultValue;
            }
            double denom = Double.parseDouble(value.substring(index + 1));
            if (denom == 0.0) {
                return defaultValue;
            }
            double num = Double.parseDouble(value.substring(0, index));
            return num / denom;
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    private final void $$robo$$android_media_ExifInterface$setAttribute(String tag, String value) {
        this.mAttributes.put(tag, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_ExifInterface$loadAttributes() throws IOException {
        String attrStr;
        this.mAttributes = new HashMap();
        Object object = sLock;
        synchronized (object) {
            attrStr = this.getAttributesNative(this.mFilename);
        }
        int ptr = attrStr.indexOf(32);
        int count = Integer.parseInt(attrStr.substring(0, ptr));
        ++ptr;
        for (int i = 0; i < count; ++i) {
            int equalPos = attrStr.indexOf(61, ptr);
            String attrName = attrStr.substring(ptr, equalPos);
            ptr = equalPos + 1;
            int lenPos = attrStr.indexOf(32, ptr);
            int attrLen = Integer.parseInt(attrStr.substring(ptr, lenPos));
            ptr = lenPos + 1;
            String attrValue = attrStr.substring(ptr, ptr + attrLen);
            ptr += attrLen;
            if (attrName.equals("hasThumbnail")) {
                this.mHasThumbnail = attrValue.equalsIgnoreCase("true");
                continue;
            }
            this.mAttributes.put(attrName, attrValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_ExifInterface$saveAttributes() throws IOException {
        StringBuilder sb = new StringBuilder();
        int size = this.mAttributes.size();
        if (this.mAttributes.containsKey("hasThumbnail")) {
            --size;
        }
        sb.append(size + " ");
        for (Map.Entry<String, String> iter : this.mAttributes.entrySet()) {
            String key = iter.getKey();
            if (key.equals("hasThumbnail")) continue;
            String val = iter.getValue();
            sb.append(key + "=");
            sb.append(val.length() + " ");
            sb.append(val);
        }
        String s = sb.toString();
        Object object = sLock;
        synchronized (object) {
            this.saveAttributesNative(this.mFilename, s);
            this.commitChangesNative(this.mFilename);
        }
    }

    private final boolean $$robo$$android_media_ExifInterface$hasThumbnail() {
        return this.mHasThumbnail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final byte[] $$robo$$android_media_ExifInterface$getThumbnail() {
        Object object = sLock;
        synchronized (object) {
            return this.getThumbnailNative(this.mFilename);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long[] $$robo$$android_media_ExifInterface$getThumbnailRange() {
        Object object = sLock;
        synchronized (object) {
            return this.getThumbnailRangeNative(this.mFilename);
        }
    }

    private final boolean $$robo$$android_media_ExifInterface$getLatLong(float[] output) {
        String latValue = this.mAttributes.get("GPSLatitude");
        String latRef = this.mAttributes.get("GPSLatitudeRef");
        String lngValue = this.mAttributes.get("GPSLongitude");
        String lngRef = this.mAttributes.get("GPSLongitudeRef");
        if (latValue != null && latRef != null && lngValue != null && lngRef != null) {
            try {
                output[0] = ExifInterface.convertRationalLatLonToFloat(latValue, latRef);
                output[1] = ExifInterface.convertRationalLatLonToFloat(lngValue, lngRef);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return false;
    }

    private final double $$robo$$android_media_ExifInterface$getAltitude(double defaultValue) {
        double altitude = this.getAttributeDouble("GPSAltitude", -1.0);
        int ref = this.getAttributeInt("GPSAltitudeRef", -1);
        if (altitude >= 0.0 && ref >= 0) {
            return altitude * (double)(ref == 1 ? -1 : 1);
        }
        return defaultValue;
    }

    private final long $$robo$$android_media_ExifInterface$getDateTime() {
        String dateTimeString = this.mAttributes.get("DateTime");
        if (dateTimeString == null) {
            return -1L;
        }
        ParsePosition pos = new ParsePosition(0);
        try {
            Date datetime = sFormatter.parse(dateTimeString, pos);
            if (datetime == null) {
                return -1L;
            }
            return datetime.getTime();
        }
        catch (IllegalArgumentException ex) {
            return -1L;
        }
    }

    private final long $$robo$$android_media_ExifInterface$getGpsDateTime() {
        String date = this.mAttributes.get("GPSDateStamp");
        String time = this.mAttributes.get("GPSTimeStamp");
        if (date == null || time == null) {
            return -1L;
        }
        String dateTimeString = date + ' ' + time;
        if (dateTimeString == null) {
            return -1L;
        }
        ParsePosition pos = new ParsePosition(0);
        try {
            Date datetime = sFormatter.parse(dateTimeString, pos);
            if (datetime == null) {
                return -1L;
            }
            return datetime.getTime();
        }
        catch (IllegalArgumentException ex) {
            return -1L;
        }
    }

    private static final float $$robo$$android_media_ExifInterface$convertRationalLatLonToFloat(String rationalString, String ref) {
        try {
            String[] parts = rationalString.split(",");
            String[] pair = parts[0].split("/");
            double degrees = Double.parseDouble(pair[0].trim()) / Double.parseDouble(pair[1].trim());
            pair = parts[1].split("/");
            double minutes = Double.parseDouble(pair[0].trim()) / Double.parseDouble(pair[1].trim());
            pair = parts[2].split("/");
            double seconds = Double.parseDouble(pair[0].trim()) / Double.parseDouble(pair[1].trim());
            double result = degrees + minutes / 60.0 + seconds / 3600.0;
            if (ref.equals("S") || ref.equals("W")) {
                return (float)(-result);
            }
            return (float)result;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException();
        }
    }

    private final boolean $$robo$$android_media_ExifInterface$appendThumbnailNative(String string2, String string3) {
        return false;
    }

    private final void $$robo$$android_media_ExifInterface$saveAttributesNative(String string2, String string3) {
    }

    private final String $$robo$$android_media_ExifInterface$getAttributesNative(String string2) {
        return null;
    }

    private final void $$robo$$android_media_ExifInterface$commitChangesNative(String string2) {
    }

    private final byte[] $$robo$$android_media_ExifInterface$getThumbnailNative(String string2) {
        return null;
    }

    private final long[] $$robo$$android_media_ExifInterface$getThumbnailRangeNative(String string2) {
        return null;
    }

    static void __staticInitializer__() {
        InvokeDynamicSupport.bootstrapIntrinsic("loadLibrary", "java.lang.System", (String)"jhead_jni");
        sFormatter = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss");
        sFormatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        sLock = new Object();
    }

    private void __constructor__(String string2) throws IOException {
        this.$$robo$$android_media_ExifInterface$__constructor__(string2);
    }

    public ExifInterface(String string2) throws IOException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_ExifInterface$__constructor__(java.lang.String ), 0, this, string2);
    }

    public String getAttribute(String string2) {
        return InvokeDynamicSupport.bootstrap("getAttribute", $$robo$$android_media_ExifInterface$getAttribute(java.lang.String ), 0, this, string2);
    }

    public int getAttributeInt(String string2, int n) {
        return (int)InvokeDynamicSupport.bootstrap("getAttributeInt", $$robo$$android_media_ExifInterface$getAttributeInt(java.lang.String int ), 0, this, string2, n);
    }

    public double getAttributeDouble(String string2, double d) {
        return (double)InvokeDynamicSupport.bootstrap("getAttributeDouble", $$robo$$android_media_ExifInterface$getAttributeDouble(java.lang.String double ), 0, this, string2, d);
    }

    public void setAttribute(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("setAttribute", $$robo$$android_media_ExifInterface$setAttribute(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    private void loadAttributes() throws IOException {
        InvokeDynamicSupport.bootstrap("loadAttributes", $$robo$$android_media_ExifInterface$loadAttributes(), 0, this);
    }

    public void saveAttributes() throws IOException {
        InvokeDynamicSupport.bootstrap("saveAttributes", $$robo$$android_media_ExifInterface$saveAttributes(), 0, this);
    }

    public boolean hasThumbnail() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasThumbnail", $$robo$$android_media_ExifInterface$hasThumbnail(), 0, this);
    }

    public byte[] getThumbnail() {
        return InvokeDynamicSupport.bootstrap("getThumbnail", $$robo$$android_media_ExifInterface$getThumbnail(), 0, this);
    }

    public long[] getThumbnailRange() {
        return InvokeDynamicSupport.bootstrap("getThumbnailRange", $$robo$$android_media_ExifInterface$getThumbnailRange(), 0, this);
    }

    public boolean getLatLong(float[] fArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("getLatLong", $$robo$$android_media_ExifInterface$getLatLong(float[] ), 0, this, fArray);
    }

    public double getAltitude(double d) {
        return (double)InvokeDynamicSupport.bootstrap("getAltitude", $$robo$$android_media_ExifInterface$getAltitude(double ), 0, this, d);
    }

    public long getDateTime() {
        return (long)InvokeDynamicSupport.bootstrap("getDateTime", $$robo$$android_media_ExifInterface$getDateTime(), 0, this);
    }

    public long getGpsDateTime() {
        return (long)InvokeDynamicSupport.bootstrap("getGpsDateTime", $$robo$$android_media_ExifInterface$getGpsDateTime(), 0, this);
    }

    private static float convertRationalLatLonToFloat(String string2, String string3) {
        return (float)InvokeDynamicSupport.bootstrapStatic("convertRationalLatLonToFloat", $$robo$$android_media_ExifInterface$convertRationalLatLonToFloat(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    private final native /* synthetic */ boolean $$robo$$appendThumbnailNative$nativeBinding(String var1, String var2);

    private boolean appendThumbnailNative(String string2, String string3) {
        return (boolean)InvokeDynamicSupport.bootstrap("appendThumbnailNative", $$robo$$android_media_ExifInterface$appendThumbnailNative(java.lang.String java.lang.String ), 1, this, string2, string3);
    }

    private final native /* synthetic */ void $$robo$$saveAttributesNative$nativeBinding(String var1, String var2);

    private void saveAttributesNative(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("saveAttributesNative", $$robo$$android_media_ExifInterface$saveAttributesNative(java.lang.String java.lang.String ), 1, this, string2, string3);
    }

    private final native /* synthetic */ String $$robo$$getAttributesNative$nativeBinding(String var1);

    private String getAttributesNative(String string2) {
        return InvokeDynamicSupport.bootstrap("getAttributesNative", $$robo$$android_media_ExifInterface$getAttributesNative(java.lang.String ), 1, this, string2);
    }

    private final native /* synthetic */ void $$robo$$commitChangesNative$nativeBinding(String var1);

    private void commitChangesNative(String string2) {
        InvokeDynamicSupport.bootstrap("commitChangesNative", $$robo$$android_media_ExifInterface$commitChangesNative(java.lang.String ), 1, this, string2);
    }

    private final native /* synthetic */ byte[] $$robo$$getThumbnailNative$nativeBinding(String var1);

    private byte[] getThumbnailNative(String string2) {
        return InvokeDynamicSupport.bootstrap("getThumbnailNative", $$robo$$android_media_ExifInterface$getThumbnailNative(java.lang.String ), 1, this, string2);
    }

    private final native /* synthetic */ long[] $$robo$$getThumbnailRangeNative$nativeBinding(String var1);

    private long[] getThumbnailRangeNative(String string2) {
        return InvokeDynamicSupport.bootstrap("getThumbnailRangeNative", $$robo$$android_media_ExifInterface$getThumbnailRangeNative(java.lang.String ), 1, this, string2);
    }

    static {
        RobolectricInternals.classInitializing(ExifInterface.class);
    }

    public /* synthetic */ ExifInterface() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ExifInterface)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

