/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.IAudioFocusDispatcher;
import android.media.MediaFocusControl;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import java.io.PrintWriter;
import java.util.NoSuchElementException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class FocusRequester
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "MediaFocusControl";
    private static boolean DEBUG = false;
    private MediaFocusControl.AudioFocusDeathHandler mDeathHandler;
    private IAudioFocusDispatcher mFocusDispatcher;
    private IBinder mSourceRef;
    private String mClientId;
    private String mPackageName;
    private int mCallingUid;
    private int mFocusGainRequest;
    private int mFocusLossReceived;
    private int mStreamType;

    private void $$robo$$android_media_FocusRequester$__constructor__(int streamType, int focusRequest, IAudioFocusDispatcher afl, IBinder source, String id2, MediaFocusControl.AudioFocusDeathHandler hdlr, String pn, int uid) {
        this.mStreamType = streamType;
        this.mFocusDispatcher = afl;
        this.mSourceRef = source;
        this.mClientId = id2;
        this.mDeathHandler = hdlr;
        this.mPackageName = pn;
        this.mCallingUid = uid;
        this.mFocusGainRequest = focusRequest;
        this.mFocusLossReceived = 0;
    }

    private final boolean $$robo$$android_media_FocusRequester$hasSameClient(String otherClient) {
        try {
            return this.mClientId.compareTo(otherClient) == 0;
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    private final boolean $$robo$$android_media_FocusRequester$hasSameBinder(IBinder ib) {
        return this.mSourceRef != null && this.mSourceRef.equals(ib);
    }

    private final boolean $$robo$$android_media_FocusRequester$hasSamePackage(String pack) {
        try {
            return this.mPackageName.compareTo(pack) == 0;
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    private final boolean $$robo$$android_media_FocusRequester$hasSameUid(int uid) {
        return this.mCallingUid == uid;
    }

    private final int $$robo$$android_media_FocusRequester$getGainRequest() {
        return this.mFocusGainRequest;
    }

    private final int $$robo$$android_media_FocusRequester$getStreamType() {
        return this.mStreamType;
    }

    private static final String $$robo$$android_media_FocusRequester$focusChangeToString(int focus) {
        switch (focus) {
            case 0: {
                return "none";
            }
            case 1: {
                return "GAIN";
            }
            case 2: {
                return "GAIN_TRANSIENT";
            }
            case 3: {
                return "GAIN_TRANSIENT_MAY_DUCK";
            }
            case 4: {
                return "GAIN_TRANSIENT_EXCLUSIVE";
            }
            case -1: {
                return "LOSS";
            }
            case -2: {
                return "LOSS_TRANSIENT";
            }
            case -3: {
                return "LOSS_TRANSIENT_CAN_DUCK";
            }
        }
        return "[invalid focus change" + focus + "]";
    }

    private final String $$robo$$android_media_FocusRequester$focusGainToString() {
        return FocusRequester.focusChangeToString(this.mFocusGainRequest);
    }

    private final String $$robo$$android_media_FocusRequester$focusLossToString() {
        return FocusRequester.focusChangeToString(this.mFocusLossReceived);
    }

    private final void $$robo$$android_media_FocusRequester$dump(PrintWriter pw) {
        pw.println("  source:" + this.mSourceRef + " -- pack: " + this.mPackageName + " -- client: " + this.mClientId + " -- gain: " + this.focusGainToString() + " -- loss: " + this.focusLossToString() + " -- uid: " + this.mCallingUid + " -- stream: " + this.mStreamType);
    }

    private final void $$robo$$android_media_FocusRequester$release() {
        try {
            if (this.mSourceRef != null && this.mDeathHandler != null) {
                this.mSourceRef.unlinkToDeath(this.mDeathHandler, 0);
                this.mDeathHandler = null;
            }
        }
        catch (NoSuchElementException e) {
            Log.e("MediaFocusControl", "FocusRequester.release() hit ", e);
        }
    }

    private final void $$robo$$android_media_FocusRequester$finalize() throws Throwable {
        this.release();
        super.finalize();
    }

    private final int $$robo$$android_media_FocusRequester$focusLossForGainRequest(int gainRequest) {
        switch (gainRequest) {
            case 1: {
                switch (this.mFocusLossReceived) {
                    case -3: 
                    case -2: 
                    case -1: 
                    case 0: {
                        return -1;
                    }
                }
            }
            case 2: 
            case 4: {
                switch (this.mFocusLossReceived) {
                    case -3: 
                    case -2: 
                    case 0: {
                        return -2;
                    }
                    case -1: {
                        return -1;
                    }
                }
            }
            case 3: {
                switch (this.mFocusLossReceived) {
                    case -3: 
                    case 0: {
                        return -3;
                    }
                    case -2: {
                        return -2;
                    }
                    case -1: {
                        return -1;
                    }
                }
            }
        }
        Log.e("MediaFocusControl", "focusLossForGainRequest() for invalid focus request " + gainRequest);
        return 0;
    }

    private final void $$robo$$android_media_FocusRequester$handleExternalFocusGain(int focusGain) {
        int focusLoss = this.focusLossForGainRequest(focusGain);
        this.handleFocusLoss(focusLoss);
    }

    private final void $$robo$$android_media_FocusRequester$handleFocusGain(int focusGain) {
        try {
            if (this.mFocusDispatcher != null) {
                this.mFocusDispatcher.dispatchAudioFocusChange(focusGain, this.mClientId);
            }
            this.mFocusLossReceived = 0;
        }
        catch (RemoteException e) {
            Log.e("MediaFocusControl", "Failure to signal gain of audio focus due to: ", e);
        }
    }

    private final void $$robo$$android_media_FocusRequester$handleFocusLoss(int focusLoss) {
        try {
            if (focusLoss != this.mFocusLossReceived) {
                if (this.mFocusDispatcher != null) {
                    this.mFocusDispatcher.dispatchAudioFocusChange(focusLoss, this.mClientId);
                }
                this.mFocusLossReceived = focusLoss;
            }
        }
        catch (RemoteException e) {
            Log.e("MediaFocusControl", "Failure to signal loss of audio focus due to:", e);
        }
    }

    private void __constructor__(int n, int n2, IAudioFocusDispatcher iAudioFocusDispatcher, IBinder iBinder, String string2, MediaFocusControl.AudioFocusDeathHandler audioFocusDeathHandler, String string3, int n3) {
        this.$$robo$$android_media_FocusRequester$__constructor__(n, n2, iAudioFocusDispatcher, iBinder, string2, audioFocusDeathHandler, string3, n3);
    }

    FocusRequester(int n, int n2, IAudioFocusDispatcher iAudioFocusDispatcher, IBinder iBinder, String string2, MediaFocusControl.AudioFocusDeathHandler audioFocusDeathHandler, String string3, int n3) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_FocusRequester$__constructor__(int int android.media.IAudioFocusDispatcher android.os.IBinder java.lang.String android.media.MediaFocusControl$AudioFocusDeathHandler java.lang.String int ), 0, this, n, n2, iAudioFocusDispatcher, iBinder, string2, audioFocusDeathHandler, string3, n3);
    }

    boolean hasSameClient(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasSameClient", $$robo$$android_media_FocusRequester$hasSameClient(java.lang.String ), 0, this, string2);
    }

    boolean hasSameBinder(IBinder iBinder) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasSameBinder", $$robo$$android_media_FocusRequester$hasSameBinder(android.os.IBinder ), 0, this, iBinder);
    }

    boolean hasSamePackage(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasSamePackage", $$robo$$android_media_FocusRequester$hasSamePackage(java.lang.String ), 0, this, string2);
    }

    boolean hasSameUid(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasSameUid", $$robo$$android_media_FocusRequester$hasSameUid(int ), 0, this, n);
    }

    int getGainRequest() {
        return (int)InvokeDynamicSupport.bootstrap("getGainRequest", $$robo$$android_media_FocusRequester$getGainRequest(), 0, this);
    }

    int getStreamType() {
        return (int)InvokeDynamicSupport.bootstrap("getStreamType", $$robo$$android_media_FocusRequester$getStreamType(), 0, this);
    }

    private static String focusChangeToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("focusChangeToString", $$robo$$android_media_FocusRequester$focusChangeToString(int ), 0, (int)n);
    }

    private String focusGainToString() {
        return InvokeDynamicSupport.bootstrap("focusGainToString", $$robo$$android_media_FocusRequester$focusGainToString(), 0, this);
    }

    private String focusLossToString() {
        return InvokeDynamicSupport.bootstrap("focusLossToString", $$robo$$android_media_FocusRequester$focusLossToString(), 0, this);
    }

    void dump(PrintWriter printWriter) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_media_FocusRequester$dump(java.io.PrintWriter ), 0, this, printWriter);
    }

    void release() {
        InvokeDynamicSupport.bootstrap("release", $$robo$$android_media_FocusRequester$release(), 0, this);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_media_FocusRequester$finalize(), 0, this);
    }

    private int focusLossForGainRequest(int n) {
        return (int)InvokeDynamicSupport.bootstrap("focusLossForGainRequest", $$robo$$android_media_FocusRequester$focusLossForGainRequest(int ), 0, this, n);
    }

    void handleExternalFocusGain(int n) {
        InvokeDynamicSupport.bootstrap("handleExternalFocusGain", $$robo$$android_media_FocusRequester$handleExternalFocusGain(int ), 0, this, n);
    }

    void handleFocusGain(int n) {
        InvokeDynamicSupport.bootstrap("handleFocusGain", $$robo$$android_media_FocusRequester$handleFocusGain(int ), 0, this, n);
    }

    void handleFocusLoss(int n) {
        InvokeDynamicSupport.bootstrap("handleFocusLoss", $$robo$$android_media_FocusRequester$handleFocusLoss(int ), 0, this, n);
    }

    public /* synthetic */ FocusRequester() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FocusRequester)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

