/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.Image;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.view.Surface;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ImageReader
implements AutoCloseable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int ACQUIRE_SUCCESS = 0;
    private static int ACQUIRE_NO_BUFS = 1;
    private static int ACQUIRE_MAX_IMAGES = 2;
    private int mWidth;
    private int mHeight;
    private int mFormat;
    private int mMaxImages;
    private int mNumPlanes;
    private Surface mSurface;
    private Object mListenerLock;
    private OnImageAvailableListener mListener;
    private ListenerHandler mListenerHandler;
    private long mNativeContext;

    private static final ImageReader $$robo$$android_media_ImageReader$newInstance(int width, int height, int format, int maxImages) {
        return new ImageReader(width, height, format, maxImages);
    }

    private void $$robo$$android_media_ImageReader$__constructor__(int width, int height, int format, int maxImages) {
        this.mListenerLock = new Object();
        this.mWidth = width;
        this.mHeight = height;
        this.mFormat = format;
        this.mMaxImages = maxImages;
        if (width < 1 || height < 1) {
            throw new IllegalArgumentException("The image dimensions must be positive");
        }
        if (this.mMaxImages < 1) {
            throw new IllegalArgumentException("Maximum outstanding image count must be at least 1");
        }
        if (format == 17) {
            throw new IllegalArgumentException("NV21 format is not supported");
        }
        this.mNumPlanes = this.getNumPlanesFromFormat();
        this.nativeInit(new WeakReference<ImageReader>(this), width, height, format, maxImages);
        this.mSurface = this.nativeGetSurface();
    }

    private final int $$robo$$android_media_ImageReader$getWidth() {
        return this.mWidth;
    }

    private final int $$robo$$android_media_ImageReader$getHeight() {
        return this.mHeight;
    }

    private final int $$robo$$android_media_ImageReader$getImageFormat() {
        return this.mFormat;
    }

    private final int $$robo$$android_media_ImageReader$getMaxImages() {
        return this.mMaxImages;
    }

    private final Surface $$robo$$android_media_ImageReader$getSurface() {
        return this.mSurface;
    }

    private final Image $$robo$$android_media_ImageReader$acquireLatestImage() {
        Image image = this.acquireNextImage();
        if (image == null) {
            return null;
        }
        try {
            while (true) {
                Image next;
                if ((next = this.acquireNextImageNoThrowISE()) == null) {
                    Image result = image;
                    image = null;
                    Image image2 = result;
                    return image2;
                }
                image.close();
                image = next;
            }
        }
        finally {
            if (image != null) {
                image.close();
            }
        }
    }

    private final Image $$robo$$android_media_ImageReader$acquireNextImageNoThrowISE() {
        SurfaceImage si = new SurfaceImage(this);
        return this.acquireNextSurfaceImage(si) == 0 ? si : null;
    }

    private final int $$robo$$android_media_ImageReader$acquireNextSurfaceImage(SurfaceImage si) {
        int status = this.nativeImageSetup(si);
        switch (status) {
            case 0: {
                si.createSurfacePlanes();
                si.setImageValid(true);
            }
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown nativeImageSetup return code " + status));
            }
        }
        return status;
    }

    private final Image $$robo$$android_media_ImageReader$acquireNextImage() {
        SurfaceImage si = new SurfaceImage(this);
        int status = this.acquireNextSurfaceImage(si);
        switch (status) {
            case 0: {
                return si;
            }
            case 1: {
                return null;
            }
            case 2: {
                throw new IllegalStateException(String.format("maxImages (%d) has already been acquired, call #close before acquiring more.", this.mMaxImages));
            }
        }
        throw new AssertionError((Object)("Unknown nativeImageSetup return code " + status));
    }

    private final void $$robo$$android_media_ImageReader$releaseImage(Image i) {
        if (!(i instanceof SurfaceImage)) {
            throw new IllegalArgumentException("This image was not produced by an ImageReader");
        }
        SurfaceImage si = (SurfaceImage)i;
        if (si.getReader() != this) {
            throw new IllegalArgumentException("This image was not produced by this ImageReader");
        }
        si.clearSurfacePlanes();
        this.nativeReleaseImage(i);
        si.setImageValid(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_ImageReader$setOnImageAvailableListener(OnImageAvailableListener listener, Handler handler) {
        Object object = this.mListenerLock;
        synchronized (object) {
            if (listener != null) {
                Looper looper;
                Looper looper2 = looper = handler != null ? handler.getLooper() : Looper.myLooper();
                if (looper == null) {
                    throw new IllegalArgumentException("handler is null but the current thread is not a looper");
                }
                if (this.mListenerHandler == null || this.mListenerHandler.getLooper() != looper) {
                    this.mListenerHandler = new ListenerHandler(this, looper);
                }
                this.mListener = listener;
            } else {
                this.mListener = null;
                this.mListenerHandler = null;
            }
        }
    }

    private final void $$robo$$android_media_ImageReader$close() {
        this.setOnImageAvailableListener(null, null);
        this.nativeClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_ImageReader$finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    private final int $$robo$$android_media_ImageReader$getNumPlanesFromFormat() {
        switch (this.mFormat) {
            case 17: 
            case 35: 
            case 842094169: {
                return 3;
            }
            case 16: {
                return 2;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 20: 
            case 32: 
            case 37: 
            case 256: 
            case 538982489: 
            case 540422489: {
                return 1;
            }
        }
        throw new UnsupportedOperationException(String.format("Invalid format specified %d", this.mFormat));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$android_media_ImageReader$postEventFromNative(Object selfRef) {
        ListenerHandler handler;
        WeakReference weakSelf = (WeakReference)selfRef;
        ImageReader ir = (ImageReader)weakSelf.get();
        if (ir == null) {
            return;
        }
        Object object = ir.mListenerLock;
        synchronized (object) {
            handler = ir.mListenerHandler;
        }
        if (handler != null) {
            handler.sendEmptyMessage(0);
        }
    }

    private final synchronized void $$robo$$android_media_ImageReader$nativeInit(Object object, int n, int n2, int n3, int n4) {
    }

    private final synchronized void $$robo$$android_media_ImageReader$nativeClose() {
    }

    private final synchronized void $$robo$$android_media_ImageReader$nativeReleaseImage(Image image) {
    }

    private final synchronized Surface $$robo$$android_media_ImageReader$nativeGetSurface() {
        return null;
    }

    private final synchronized int $$robo$$android_media_ImageReader$nativeImageSetup(Image image) {
        return 0;
    }

    private static final void $$robo$$android_media_ImageReader$nativeClassInit() {
    }

    static void __staticInitializer__() {
        InvokeDynamicSupport.bootstrapIntrinsic("loadLibrary", "java.lang.System", (String)"media_jni");
        ImageReader.nativeClassInit();
    }

    public static ImageReader newInstance(int n, int n2, int n3, int n4) {
        return InvokeDynamicSupport.bootstrapStatic("newInstance", $$robo$$android_media_ImageReader$newInstance(int int int int ), 0, (int)n, (int)n2, (int)n3, (int)n4);
    }

    private void __constructor__(int n, int n2, int n3, int n4) {
        this.$$robo$$android_media_ImageReader$__constructor__(n, n2, n3, n4);
    }

    protected ImageReader(int n, int n2, int n3, int n4) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_ImageReader$__constructor__(int int int int ), 0, this, n, n2, n3, n4);
    }

    public int getWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getWidth", $$robo$$android_media_ImageReader$getWidth(), 0, this);
    }

    public int getHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getHeight", $$robo$$android_media_ImageReader$getHeight(), 0, this);
    }

    public int getImageFormat() {
        return (int)InvokeDynamicSupport.bootstrap("getImageFormat", $$robo$$android_media_ImageReader$getImageFormat(), 0, this);
    }

    public int getMaxImages() {
        return (int)InvokeDynamicSupport.bootstrap("getMaxImages", $$robo$$android_media_ImageReader$getMaxImages(), 0, this);
    }

    public Surface getSurface() {
        return InvokeDynamicSupport.bootstrap("getSurface", $$robo$$android_media_ImageReader$getSurface(), 0, this);
    }

    public Image acquireLatestImage() {
        return InvokeDynamicSupport.bootstrap("acquireLatestImage", $$robo$$android_media_ImageReader$acquireLatestImage(), 0, this);
    }

    public Image acquireNextImageNoThrowISE() {
        return InvokeDynamicSupport.bootstrap("acquireNextImageNoThrowISE", $$robo$$android_media_ImageReader$acquireNextImageNoThrowISE(), 0, this);
    }

    private int acquireNextSurfaceImage(SurfaceImage surfaceImage) {
        return (int)InvokeDynamicSupport.bootstrap("acquireNextSurfaceImage", $$robo$$android_media_ImageReader$acquireNextSurfaceImage(android.media.ImageReader$SurfaceImage ), 0, this, surfaceImage);
    }

    public Image acquireNextImage() {
        return InvokeDynamicSupport.bootstrap("acquireNextImage", $$robo$$android_media_ImageReader$acquireNextImage(), 0, this);
    }

    private void releaseImage(Image image) {
        InvokeDynamicSupport.bootstrap("releaseImage", $$robo$$android_media_ImageReader$releaseImage(android.media.Image ), 0, this, image);
    }

    public void setOnImageAvailableListener(OnImageAvailableListener onImageAvailableListener, Handler handler) {
        InvokeDynamicSupport.bootstrap("setOnImageAvailableListener", $$robo$$android_media_ImageReader$setOnImageAvailableListener(android.media.ImageReader$OnImageAvailableListener android.os.Handler ), 0, this, onImageAvailableListener, handler);
    }

    @Override
    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_media_ImageReader$close(), 0, this);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_media_ImageReader$finalize(), 0, this);
    }

    private int getNumPlanesFromFormat() {
        return (int)InvokeDynamicSupport.bootstrap("getNumPlanesFromFormat", $$robo$$android_media_ImageReader$getNumPlanesFromFormat(), 0, this);
    }

    private static void postEventFromNative(Object object) {
        InvokeDynamicSupport.bootstrapStatic("postEventFromNative", $$robo$$android_media_ImageReader$postEventFromNative(java.lang.Object ), 0, (Object)object);
    }

    private final synchronized native /* synthetic */ void $$robo$$nativeInit$nativeBinding(Object var1, int var2, int var3, int var4, int var5);

    private synchronized void nativeInit(Object object, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("nativeInit", $$robo$$android_media_ImageReader$nativeInit(java.lang.Object int int int int ), 1, this, object, n, n2, n3, n4);
    }

    private final synchronized native /* synthetic */ void $$robo$$nativeClose$nativeBinding();

    private synchronized void nativeClose() {
        InvokeDynamicSupport.bootstrap("nativeClose", $$robo$$android_media_ImageReader$nativeClose(), 1, this);
    }

    private final synchronized native /* synthetic */ void $$robo$$nativeReleaseImage$nativeBinding(Image var1);

    private synchronized void nativeReleaseImage(Image image) {
        InvokeDynamicSupport.bootstrap("nativeReleaseImage", $$robo$$android_media_ImageReader$nativeReleaseImage(android.media.Image ), 1, this, image);
    }

    private final synchronized native /* synthetic */ Surface $$robo$$nativeGetSurface$nativeBinding();

    private synchronized Surface nativeGetSurface() {
        return InvokeDynamicSupport.bootstrap("nativeGetSurface", $$robo$$android_media_ImageReader$nativeGetSurface(), 1, this);
    }

    private final synchronized native /* synthetic */ int $$robo$$nativeImageSetup$nativeBinding(Image var1);

    private synchronized int nativeImageSetup(Image image) {
        return (int)InvokeDynamicSupport.bootstrap("nativeImageSetup", $$robo$$android_media_ImageReader$nativeImageSetup(android.media.Image ), 1, this, image);
    }

    private static final native /* synthetic */ void $$robo$$nativeClassInit$nativeBinding();

    private static void nativeClassInit() {
        InvokeDynamicSupport.bootstrapStatic("nativeClassInit", $$robo$$android_media_ImageReader$nativeClassInit(), 1);
    }

    static {
        RobolectricInternals.classInitializing(ImageReader.class);
    }

    public /* synthetic */ ImageReader() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ImageReader)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class SurfaceImage
    extends Image
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private long mLockedBuffer;
        private long mTimestamp;
        private SurfacePlane[] mPlanes;
        private boolean mIsImageValid;
        /* synthetic */ ImageReader this$0;

        private void $$robo$$android_media_ImageReader_SurfaceImage$__constructor__(ImageReader imageReader) {
            this.mIsImageValid = false;
        }

        private final void $$robo$$android_media_ImageReader_SurfaceImage$close() {
            if (this.mIsImageValid) {
                this.this$0.releaseImage(this);
            }
        }

        private final ImageReader $$robo$$android_media_ImageReader_SurfaceImage$getReader() {
            return this.this$0;
        }

        private final int $$robo$$android_media_ImageReader_SurfaceImage$getFormat() {
            if (this.mIsImageValid) {
                return this.this$0.mFormat;
            }
            throw new IllegalStateException("Image is already released");
        }

        private final int $$robo$$android_media_ImageReader_SurfaceImage$getWidth() {
            if (this.mIsImageValid) {
                return this.this$0.mWidth;
            }
            throw new IllegalStateException("Image is already released");
        }

        private final int $$robo$$android_media_ImageReader_SurfaceImage$getHeight() {
            if (this.mIsImageValid) {
                return this.this$0.mHeight;
            }
            throw new IllegalStateException("Image is already released");
        }

        private final long $$robo$$android_media_ImageReader_SurfaceImage$getTimestamp() {
            if (this.mIsImageValid) {
                return this.mTimestamp;
            }
            throw new IllegalStateException("Image is already released");
        }

        private final Image.Plane[] $$robo$$android_media_ImageReader_SurfaceImage$getPlanes() {
            if (this.mIsImageValid) {
                return (Image.Plane[])this.mPlanes.clone();
            }
            throw new IllegalStateException("Image is already released");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_ImageReader_SurfaceImage$finalize() throws Throwable {
            try {
                this.close();
            }
            finally {
                super.finalize();
            }
        }

        private final void $$robo$$android_media_ImageReader_SurfaceImage$setImageValid(boolean isValid) {
            this.mIsImageValid = isValid;
        }

        private final boolean $$robo$$android_media_ImageReader_SurfaceImage$isImageValid() {
            return this.mIsImageValid;
        }

        private final void $$robo$$android_media_ImageReader_SurfaceImage$clearSurfacePlanes() {
            if (this.mIsImageValid) {
                for (int i = 0; i < this.mPlanes.length; ++i) {
                    if (this.mPlanes[i] == null) continue;
                    this.mPlanes[i].clearBuffer();
                    this.mPlanes[i] = null;
                }
            }
        }

        private final void $$robo$$android_media_ImageReader_SurfaceImage$createSurfacePlanes() {
            this.mPlanes = new SurfacePlane[this.this$0.mNumPlanes];
            for (int i = 0; i < this.this$0.mNumPlanes; ++i) {
                this.mPlanes[i] = this.nativeCreatePlane(i, this.this$0.mFormat);
            }
        }

        private final synchronized ByteBuffer $$robo$$android_media_ImageReader_SurfaceImage$nativeImageGetBuffer(int n, int n2) {
            return null;
        }

        private final synchronized SurfacePlane $$robo$$android_media_ImageReader_SurfaceImage$nativeCreatePlane(int n, int n2) {
            return null;
        }

        private void __constructor__(ImageReader imageReader) {
            this.$$robo$$android_media_ImageReader_SurfaceImage$__constructor__(imageReader);
        }

        public SurfaceImage(ImageReader imageReader) {
            this.this$0 = imageReader;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_ImageReader_SurfaceImage$__constructor__(android.media.ImageReader ), 0, this, imageReader);
        }

        @Override
        public void close() {
            InvokeDynamicSupport.bootstrap("close", $$robo$$android_media_ImageReader_SurfaceImage$close(), 0, this);
        }

        public ImageReader getReader() {
            return InvokeDynamicSupport.bootstrap("getReader", $$robo$$android_media_ImageReader_SurfaceImage$getReader(), 0, this);
        }

        @Override
        public int getFormat() {
            return (int)InvokeDynamicSupport.bootstrap("getFormat", $$robo$$android_media_ImageReader_SurfaceImage$getFormat(), 0, this);
        }

        @Override
        public int getWidth() {
            return (int)InvokeDynamicSupport.bootstrap("getWidth", $$robo$$android_media_ImageReader_SurfaceImage$getWidth(), 0, this);
        }

        @Override
        public int getHeight() {
            return (int)InvokeDynamicSupport.bootstrap("getHeight", $$robo$$android_media_ImageReader_SurfaceImage$getHeight(), 0, this);
        }

        @Override
        public long getTimestamp() {
            return (long)InvokeDynamicSupport.bootstrap("getTimestamp", $$robo$$android_media_ImageReader_SurfaceImage$getTimestamp(), 0, this);
        }

        @Override
        public Image.Plane[] getPlanes() {
            return InvokeDynamicSupport.bootstrap("getPlanes", $$robo$$android_media_ImageReader_SurfaceImage$getPlanes(), 0, this);
        }

        protected void finalize() throws Throwable {
            InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_media_ImageReader_SurfaceImage$finalize(), 0, this);
        }

        private void setImageValid(boolean bl) {
            InvokeDynamicSupport.bootstrap("setImageValid", $$robo$$android_media_ImageReader_SurfaceImage$setImageValid(boolean ), 0, this, bl);
        }

        private boolean isImageValid() {
            return (boolean)InvokeDynamicSupport.bootstrap("isImageValid", $$robo$$android_media_ImageReader_SurfaceImage$isImageValid(), 0, this);
        }

        private void clearSurfacePlanes() {
            InvokeDynamicSupport.bootstrap("clearSurfacePlanes", $$robo$$android_media_ImageReader_SurfaceImage$clearSurfacePlanes(), 0, this);
        }

        private void createSurfacePlanes() {
            InvokeDynamicSupport.bootstrap("createSurfacePlanes", $$robo$$android_media_ImageReader_SurfaceImage$createSurfacePlanes(), 0, this);
        }

        private final synchronized native /* synthetic */ ByteBuffer $$robo$$nativeImageGetBuffer$nativeBinding(int var1, int var2);

        private synchronized ByteBuffer nativeImageGetBuffer(int n, int n2) {
            return InvokeDynamicSupport.bootstrap("nativeImageGetBuffer", $$robo$$android_media_ImageReader_SurfaceImage$nativeImageGetBuffer(int int ), 1, this, n, n2);
        }

        private final synchronized native /* synthetic */ SurfacePlane $$robo$$nativeCreatePlane$nativeBinding(int var1, int var2);

        private synchronized SurfacePlane nativeCreatePlane(int n, int n2) {
            return InvokeDynamicSupport.bootstrap("nativeCreatePlane", $$robo$$android_media_ImageReader_SurfaceImage$nativeCreatePlane(int int ), 1, this, n, n2);
        }

        public /* synthetic */ SurfaceImage() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SurfaceImage)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        private class SurfacePlane
        extends Image.Plane
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            private int mIndex;
            private int mPixelStride;
            private int mRowStride;
            private ByteBuffer mBuffer;
            /* synthetic */ SurfaceImage this$1;

            private void $$robo$$android_media_ImageReader_SurfaceImage_SurfacePlane$__constructor__(SurfaceImage surfaceImage, int index, int rowStride, int pixelStride) {
                this.mIndex = index;
                this.mRowStride = rowStride;
                this.mPixelStride = pixelStride;
            }

            private final ByteBuffer $$robo$$android_media_ImageReader_SurfaceImage_SurfacePlane$getBuffer() {
                if (!this.this$1.isImageValid()) {
                    throw new IllegalStateException("Image is already released");
                }
                if (this.mBuffer != null) {
                    return this.mBuffer;
                }
                this.mBuffer = this.this$1.nativeImageGetBuffer(this.mIndex, this.this$1.this$0.mFormat);
                return this.mBuffer.order(ByteOrder.nativeOrder());
            }

            private final int $$robo$$android_media_ImageReader_SurfaceImage_SurfacePlane$getPixelStride() {
                if (this.this$1.isImageValid()) {
                    return this.mPixelStride;
                }
                throw new IllegalStateException("Image is already released");
            }

            private final int $$robo$$android_media_ImageReader_SurfaceImage_SurfacePlane$getRowStride() {
                if (this.this$1.isImageValid()) {
                    return this.mRowStride;
                }
                throw new IllegalStateException("Image is already released");
            }

            private final void $$robo$$android_media_ImageReader_SurfaceImage_SurfacePlane$clearBuffer() {
                this.mBuffer = null;
            }

            private void __constructor__(SurfaceImage surfaceImage, int n, int n2, int n3) {
                this.$$robo$$android_media_ImageReader_SurfaceImage_SurfacePlane$__constructor__(surfaceImage, n, n2, n3);
            }

            private SurfacePlane(SurfaceImage surfaceImage, int n, int n2, int n3) {
                this.this$1 = surfaceImage;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_ImageReader_SurfaceImage_SurfacePlane$__constructor__(android.media.ImageReader$SurfaceImage int int int ), 0, this, surfaceImage, n, n2, n3);
            }

            @Override
            public ByteBuffer getBuffer() {
                return InvokeDynamicSupport.bootstrap("getBuffer", $$robo$$android_media_ImageReader_SurfaceImage_SurfacePlane$getBuffer(), 0, this);
            }

            @Override
            public int getPixelStride() {
                return (int)InvokeDynamicSupport.bootstrap("getPixelStride", $$robo$$android_media_ImageReader_SurfaceImage_SurfacePlane$getPixelStride(), 0, this);
            }

            @Override
            public int getRowStride() {
                return (int)InvokeDynamicSupport.bootstrap("getRowStride", $$robo$$android_media_ImageReader_SurfaceImage_SurfacePlane$getRowStride(), 0, this);
            }

            private void clearBuffer() {
                InvokeDynamicSupport.bootstrap("clearBuffer", $$robo$$android_media_ImageReader_SurfaceImage_SurfacePlane$clearBuffer(), 0, this);
            }

            public /* synthetic */ SurfacePlane() {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SurfacePlane)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class ListenerHandler
    extends Handler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ ImageReader this$0;

        private void $$robo$$android_media_ImageReader_ListenerHandler$__constructor__(ImageReader imageReader, Looper looper) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_ImageReader_ListenerHandler$handleMessage(Message msg) {
            OnImageAvailableListener listener;
            Object object = this.this$0.mListenerLock;
            synchronized (object) {
                listener = this.this$0.mListener;
            }
            if (listener != null) {
                listener.onImageAvailable(this.this$0);
            }
        }

        private void __constructor__(ImageReader imageReader, Looper looper) {
            this.$$robo$$android_media_ImageReader_ListenerHandler$__constructor__(imageReader, looper);
        }

        public ListenerHandler(ImageReader imageReader, Looper looper) {
            this.this$0 = imageReader;
            super(looper, null, true);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_ImageReader_ListenerHandler$__constructor__(android.media.ImageReader android.os.Looper ), 0, this, imageReader, looper);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_media_ImageReader_ListenerHandler$handleMessage(android.os.Message ), 0, this, message);
        }

        public /* synthetic */ ListenerHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ListenerHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface OnImageAvailableListener
    extends InstrumentedInterface {
        public void onImageAvailable(ImageReader var1);
    }
}

