/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.MediaFormat;
import android.media.Utils;
import android.util.Log;
import android.util.Pair;
import android.util.Range;
import android.util.Rational;
import android.util.Size;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class MediaCodecInfo
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private boolean mIsEncoder;
    private String mName;
    private Map<String, CodecCapabilities> mCaps;
    private static Range<Integer> POSITIVE_INTEGERS;
    private static Range<Long> POSITIVE_LONGS;
    private static Range<Rational> POSITIVE_RATIONALS;
    private static Range<Integer> SIZE_RANGE;
    private static Range<Integer> FRAME_RATE_RANGE;
    private static int ERROR_UNRECOGNIZED = 1;
    private static int ERROR_UNSUPPORTED = 2;
    private static int ERROR_NONE_SUPPORTED = 4;

    private void $$robo$$android_media_MediaCodecInfo$__constructor__(String name, boolean isEncoder, CodecCapabilities[] caps) {
        this.mName = name;
        this.mIsEncoder = isEncoder;
        this.mCaps = new HashMap<String, CodecCapabilities>();
        for (CodecCapabilities c : caps) {
            this.mCaps.put(c.getMimeType(), c);
        }
    }

    private final String $$robo$$android_media_MediaCodecInfo$getName() {
        return this.mName;
    }

    private final boolean $$robo$$android_media_MediaCodecInfo$isEncoder() {
        return this.mIsEncoder;
    }

    private final String[] $$robo$$android_media_MediaCodecInfo$getSupportedTypes() {
        Set<String> typeSet = this.mCaps.keySet();
        Object[] types = typeSet.toArray(new String[typeSet.size()]);
        Arrays.sort(types);
        return types;
    }

    private static final int $$robo$$android_media_MediaCodecInfo$checkPowerOfTwo(int value, String message) {
        if ((value & value - 1) != 0) {
            throw new IllegalArgumentException(message);
        }
        return value;
    }

    private final CodecCapabilities $$robo$$android_media_MediaCodecInfo$getCapabilitiesForType(String type) {
        CodecCapabilities caps = this.mCaps.get(type);
        if (caps == null) {
            throw new IllegalArgumentException("codec does not support type");
        }
        return caps.dup();
    }

    private final MediaCodecInfo $$robo$$android_media_MediaCodecInfo$makeRegular() {
        ArrayList<CodecCapabilities> caps = new ArrayList<CodecCapabilities>();
        for (CodecCapabilities c : this.mCaps.values()) {
            if (!c.isRegular()) continue;
            caps.add(c);
        }
        if (caps.size() == 0) {
            return null;
        }
        if (caps.size() == this.mCaps.size()) {
            return this;
        }
        return new MediaCodecInfo(this.mName, this.mIsEncoder, caps.toArray(new CodecCapabilities[caps.size()]));
    }

    static void __staticInitializer__() {
        POSITIVE_INTEGERS = Range.create(1, Integer.MAX_VALUE);
        POSITIVE_LONGS = Range.create(1L, Long.MAX_VALUE);
        POSITIVE_RATIONALS = Range.create(new Rational(1, Integer.MAX_VALUE), new Rational(Integer.MAX_VALUE, 1));
        SIZE_RANGE = Range.create(1, 32768);
        FRAME_RATE_RANGE = Range.create(0, 960);
    }

    private void __constructor__(String string2, boolean bl, CodecCapabilities[] codecCapabilitiesArray) {
        this.$$robo$$android_media_MediaCodecInfo$__constructor__(string2, bl, codecCapabilitiesArray);
    }

    MediaCodecInfo(String string2, boolean bl, CodecCapabilities[] codecCapabilitiesArray) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaCodecInfo$__constructor__(java.lang.String boolean android.media.MediaCodecInfo$CodecCapabilities[] ), 0, this, string2, bl, codecCapabilitiesArray);
    }

    public String getName() {
        return InvokeDynamicSupport.bootstrap("getName", $$robo$$android_media_MediaCodecInfo$getName(), 0, this);
    }

    public boolean isEncoder() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEncoder", $$robo$$android_media_MediaCodecInfo$isEncoder(), 0, this);
    }

    public String[] getSupportedTypes() {
        return InvokeDynamicSupport.bootstrap("getSupportedTypes", $$robo$$android_media_MediaCodecInfo$getSupportedTypes(), 0, this);
    }

    private static int checkPowerOfTwo(int n, String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("checkPowerOfTwo", $$robo$$android_media_MediaCodecInfo$checkPowerOfTwo(int java.lang.String ), 0, (int)n, (String)string2);
    }

    public CodecCapabilities getCapabilitiesForType(String string2) {
        return InvokeDynamicSupport.bootstrap("getCapabilitiesForType", $$robo$$android_media_MediaCodecInfo$getCapabilitiesForType(java.lang.String ), 0, this, string2);
    }

    public MediaCodecInfo makeRegular() {
        return InvokeDynamicSupport.bootstrap("makeRegular", $$robo$$android_media_MediaCodecInfo$makeRegular(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(MediaCodecInfo.class);
    }

    public /* synthetic */ MediaCodecInfo() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MediaCodecInfo)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class CodecProfileLevel
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int AVCProfileBaseline = 1;
        public static int AVCProfileMain = 2;
        public static int AVCProfileExtended = 4;
        public static int AVCProfileHigh = 8;
        public static int AVCProfileHigh10 = 16;
        public static int AVCProfileHigh422 = 32;
        public static int AVCProfileHigh444 = 64;
        public static int AVCLevel1 = 1;
        public static int AVCLevel1b = 2;
        public static int AVCLevel11 = 4;
        public static int AVCLevel12 = 8;
        public static int AVCLevel13 = 16;
        public static int AVCLevel2 = 32;
        public static int AVCLevel21 = 64;
        public static int AVCLevel22 = 128;
        public static int AVCLevel3 = 256;
        public static int AVCLevel31 = 512;
        public static int AVCLevel32 = 1024;
        public static int AVCLevel4 = 2048;
        public static int AVCLevel41 = 4096;
        public static int AVCLevel42 = 8192;
        public static int AVCLevel5 = 16384;
        public static int AVCLevel51 = 32768;
        public static int AVCLevel52 = 65536;
        public static int H263ProfileBaseline = 1;
        public static int H263ProfileH320Coding = 2;
        public static int H263ProfileBackwardCompatible = 4;
        public static int H263ProfileISWV2 = 8;
        public static int H263ProfileISWV3 = 16;
        public static int H263ProfileHighCompression = 32;
        public static int H263ProfileInternet = 64;
        public static int H263ProfileInterlace = 128;
        public static int H263ProfileHighLatency = 256;
        public static int H263Level10 = 1;
        public static int H263Level20 = 2;
        public static int H263Level30 = 4;
        public static int H263Level40 = 8;
        public static int H263Level45 = 16;
        public static int H263Level50 = 32;
        public static int H263Level60 = 64;
        public static int H263Level70 = 128;
        public static int MPEG4ProfileSimple = 1;
        public static int MPEG4ProfileSimpleScalable = 2;
        public static int MPEG4ProfileCore = 4;
        public static int MPEG4ProfileMain = 8;
        public static int MPEG4ProfileNbit = 16;
        public static int MPEG4ProfileScalableTexture = 32;
        public static int MPEG4ProfileSimpleFace = 64;
        public static int MPEG4ProfileSimpleFBA = 128;
        public static int MPEG4ProfileBasicAnimated = 256;
        public static int MPEG4ProfileHybrid = 512;
        public static int MPEG4ProfileAdvancedRealTime = 1024;
        public static int MPEG4ProfileCoreScalable = 2048;
        public static int MPEG4ProfileAdvancedCoding = 4096;
        public static int MPEG4ProfileAdvancedCore = 8192;
        public static int MPEG4ProfileAdvancedScalable = 16384;
        public static int MPEG4ProfileAdvancedSimple = 32768;
        public static int MPEG4Level0 = 1;
        public static int MPEG4Level0b = 2;
        public static int MPEG4Level1 = 4;
        public static int MPEG4Level2 = 8;
        public static int MPEG4Level3 = 16;
        public static int MPEG4Level4 = 32;
        public static int MPEG4Level4a = 64;
        public static int MPEG4Level5 = 128;
        public static int AACObjectMain = 1;
        public static int AACObjectLC = 2;
        public static int AACObjectSSR = 3;
        public static int AACObjectLTP = 4;
        public static int AACObjectHE = 5;
        public static int AACObjectScalable = 6;
        public static int AACObjectERLC = 17;
        public static int AACObjectLD = 23;
        public static int AACObjectHE_PS = 29;
        public static int AACObjectELD = 39;
        public static int VP8Level_Version0 = 1;
        public static int VP8Level_Version1 = 2;
        public static int VP8Level_Version2 = 4;
        public static int VP8Level_Version3 = 8;
        public static int VP8ProfileMain = 1;
        public static int HEVCProfileMain = 1;
        public static int HEVCProfileMain10 = 2;
        public static int HEVCMainTierLevel1 = 1;
        public static int HEVCHighTierLevel1 = 2;
        public static int HEVCMainTierLevel2 = 4;
        public static int HEVCHighTierLevel2 = 8;
        public static int HEVCMainTierLevel21 = 16;
        public static int HEVCHighTierLevel21 = 32;
        public static int HEVCMainTierLevel3 = 64;
        public static int HEVCHighTierLevel3 = 128;
        public static int HEVCMainTierLevel31 = 256;
        public static int HEVCHighTierLevel31 = 512;
        public static int HEVCMainTierLevel4 = 1024;
        public static int HEVCHighTierLevel4 = 2048;
        public static int HEVCMainTierLevel41 = 4096;
        public static int HEVCHighTierLevel41 = 8192;
        public static int HEVCMainTierLevel5 = 16384;
        public static int HEVCHighTierLevel5 = 32768;
        public static int HEVCMainTierLevel51 = 65536;
        public static int HEVCHighTierLevel51 = 131072;
        public static int HEVCMainTierLevel52 = 262144;
        public static int HEVCHighTierLevel52 = 524288;
        public static int HEVCMainTierLevel6 = 0x100000;
        public static int HEVCHighTierLevel6 = 0x200000;
        public static int HEVCMainTierLevel61 = 0x400000;
        public static int HEVCHighTierLevel61 = 0x800000;
        public static int HEVCMainTierLevel62 = 0x1000000;
        public static int HEVCHighTierLevel62 = 0x2000000;
        public int profile;
        public int level;

        private void $$robo$$android_media_MediaCodecInfo_CodecProfileLevel$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_media_MediaCodecInfo_CodecProfileLevel$__constructor__();
        }

        public CodecProfileLevel() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaCodecInfo_CodecProfileLevel$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CodecProfileLevel)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class EncoderCapabilities
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int BITRATE_MODE_CQ = 0;
        public static int BITRATE_MODE_VBR = 1;
        public static int BITRATE_MODE_CBR = 2;
        private static Feature[] bitrates;
        private Range<Integer> mQualityRange;
        private Range<Integer> mComplexityRange;
        private CodecCapabilities mParent;
        private int mBitControl;
        private Integer mDefaultComplexity;
        private Integer mDefaultQuality;
        private String mQualityScale;

        private final Range<Integer> $$robo$$android_media_MediaCodecInfo_EncoderCapabilities$getQualityRange() {
            return this.mQualityRange;
        }

        private final Range<Integer> $$robo$$android_media_MediaCodecInfo_EncoderCapabilities$getComplexityRange() {
            return this.mComplexityRange;
        }

        private static final int $$robo$$android_media_MediaCodecInfo_EncoderCapabilities$parseBitrateMode(String mode) {
            for (Feature feat : bitrates) {
                if (!feat.mName.equalsIgnoreCase(mode)) continue;
                return feat.mValue;
            }
            return 0;
        }

        private final boolean $$robo$$android_media_MediaCodecInfo_EncoderCapabilities$isBitrateModeSupported(int mode) {
            for (Feature feat : bitrates) {
                if (mode != feat.mValue) continue;
                return (this.mBitControl & 1 << mode) != 0;
            }
            return false;
        }

        private void $$robo$$android_media_MediaCodecInfo_EncoderCapabilities$__constructor__() {
        }

        private static final EncoderCapabilities $$robo$$android_media_MediaCodecInfo_EncoderCapabilities$create(MediaFormat info, CodecCapabilities parent) {
            EncoderCapabilities caps = new EncoderCapabilities();
            caps.init(info, parent);
            return caps;
        }

        private final void $$robo$$android_media_MediaCodecInfo_EncoderCapabilities$init(MediaFormat info, CodecCapabilities parent) {
            this.mParent = parent;
            this.mComplexityRange = Range.create(0, 0);
            this.mQualityRange = Range.create(0, 0);
            this.mBitControl = 2;
            this.applyLevelLimits();
            this.parseFromInfo(info);
        }

        private final void $$robo$$android_media_MediaCodecInfo_EncoderCapabilities$applyLevelLimits() {
            String mime = this.mParent.getMimeType();
            if (mime.equalsIgnoreCase("audio/flac")) {
                this.mComplexityRange = Range.create(0, 8);
                this.mBitControl = 1;
            } else if (mime.equalsIgnoreCase("audio/3gpp") || mime.equalsIgnoreCase("audio/amr-wb") || mime.equalsIgnoreCase("audio/g711-alaw") || mime.equalsIgnoreCase("audio/g711-mlaw") || mime.equalsIgnoreCase("audio/gsm")) {
                this.mBitControl = 4;
            }
        }

        private final void $$robo$$android_media_MediaCodecInfo_EncoderCapabilities$parseFromInfo(MediaFormat info) {
            Map<String, Object> map = info.getMap();
            if (info.containsKey("complexity-range")) {
                this.mComplexityRange = Utils.parseIntRange(info.getString("complexity-range"), this.mComplexityRange);
            }
            if (info.containsKey("quality-range")) {
                this.mQualityRange = Utils.parseIntRange(info.getString("quality-range"), this.mQualityRange);
            }
            if (info.containsKey("feature-bitrate-control")) {
                for (String mode : info.getString("feature-bitrate-control").split(",")) {
                    this.mBitControl |= EncoderCapabilities.parseBitrateMode(mode);
                }
            }
            try {
                this.mDefaultComplexity = Integer.parseInt((String)map.get("complexity-default"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                this.mDefaultQuality = Integer.parseInt((String)map.get("quality-default"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.mQualityScale = (String)map.get("quality-scale");
        }

        private final boolean $$robo$$android_media_MediaCodecInfo_EncoderCapabilities$supports(Integer complexity, Integer quality, Integer profile) {
            boolean ok = true;
            if (ok && complexity != null) {
                ok = this.mComplexityRange.contains(complexity);
            }
            if (ok && quality != null) {
                ok = this.mQualityRange.contains(quality);
            }
            if (ok && profile != null) {
                for (CodecProfileLevel pl : this.mParent.profileLevels) {
                    if (pl.profile != profile) continue;
                    profile = null;
                    break;
                }
                ok = profile == null;
            }
            return ok;
        }

        private final void $$robo$$android_media_MediaCodecInfo_EncoderCapabilities$setDefaultFormat(MediaFormat format) {
            if (!this.mQualityRange.getUpper().equals(this.mQualityRange.getLower()) && this.mDefaultQuality != null) {
                format.setInteger("quality", this.mDefaultQuality);
            }
            if (!this.mComplexityRange.getUpper().equals(this.mComplexityRange.getLower()) && this.mDefaultComplexity != null) {
                format.setInteger("complexity", this.mDefaultComplexity);
            }
            for (Feature feat : bitrates) {
                if ((this.mBitControl & 1 << feat.mValue) == 0) continue;
                format.setInteger("bitrate-mode", feat.mValue);
                break;
            }
        }

        private final boolean $$robo$$android_media_MediaCodecInfo_EncoderCapabilities$supportsFormat(MediaFormat format) {
            Map<String, Object> map = format.getMap();
            String mime = this.mParent.getMimeType();
            Integer mode = (Integer)map.get("bitrate-mode");
            if (mode != null && !this.isBitrateModeSupported(mode)) {
                return false;
            }
            Integer complexity = (Integer)map.get("complexity");
            if ("audio/flac".equalsIgnoreCase(mime)) {
                Integer flacComplexity = (Integer)map.get("flac-compression-level");
                if (complexity == null) {
                    complexity = flacComplexity;
                } else if (flacComplexity != null && complexity != flacComplexity) {
                    throw new IllegalArgumentException("conflicting values for complexity and flac-compression-level");
                }
            }
            Integer profile = (Integer)map.get("profile");
            if ("audio/mp4a-latm".equalsIgnoreCase(mime)) {
                Integer aacProfile = (Integer)map.get("aac-profile");
                if (profile == null) {
                    profile = aacProfile;
                } else if (aacProfile != null && aacProfile != profile) {
                    throw new IllegalArgumentException("conflicting values for profile and aac-profile");
                }
            }
            Integer quality = (Integer)map.get("quality");
            return this.supports(complexity, quality, profile);
        }

        static void __staticInitializer__() {
            bitrates = new Feature[]{new Feature("VBR", 1, true), new Feature("CBR", 2, false), new Feature("CQ", 0, false)};
        }

        public Range<Integer> getQualityRange() {
            return InvokeDynamicSupport.bootstrap("getQualityRange", $$robo$$android_media_MediaCodecInfo_EncoderCapabilities$getQualityRange(), 0, this);
        }

        public Range<Integer> getComplexityRange() {
            return InvokeDynamicSupport.bootstrap("getComplexityRange", $$robo$$android_media_MediaCodecInfo_EncoderCapabilities$getComplexityRange(), 0, this);
        }

        private static int parseBitrateMode(String string2) {
            return (int)InvokeDynamicSupport.bootstrapStatic("parseBitrateMode", $$robo$$android_media_MediaCodecInfo_EncoderCapabilities$parseBitrateMode(java.lang.String ), 0, (String)string2);
        }

        public boolean isBitrateModeSupported(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("isBitrateModeSupported", $$robo$$android_media_MediaCodecInfo_EncoderCapabilities$isBitrateModeSupported(int ), 0, this, n);
        }

        private void __constructor__() {
            this.$$robo$$android_media_MediaCodecInfo_EncoderCapabilities$__constructor__();
        }

        private EncoderCapabilities() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaCodecInfo_EncoderCapabilities$__constructor__(), 0, this);
        }

        public static EncoderCapabilities create(MediaFormat mediaFormat, CodecCapabilities codecCapabilities) {
            return InvokeDynamicSupport.bootstrapStatic("create", $$robo$$android_media_MediaCodecInfo_EncoderCapabilities$create(android.media.MediaFormat android.media.MediaCodecInfo$CodecCapabilities ), 0, (MediaFormat)mediaFormat, (CodecCapabilities)codecCapabilities);
        }

        public void init(MediaFormat mediaFormat, CodecCapabilities codecCapabilities) {
            InvokeDynamicSupport.bootstrap("init", $$robo$$android_media_MediaCodecInfo_EncoderCapabilities$init(android.media.MediaFormat android.media.MediaCodecInfo$CodecCapabilities ), 0, this, mediaFormat, codecCapabilities);
        }

        private void applyLevelLimits() {
            InvokeDynamicSupport.bootstrap("applyLevelLimits", $$robo$$android_media_MediaCodecInfo_EncoderCapabilities$applyLevelLimits(), 0, this);
        }

        private void parseFromInfo(MediaFormat mediaFormat) {
            InvokeDynamicSupport.bootstrap("parseFromInfo", $$robo$$android_media_MediaCodecInfo_EncoderCapabilities$parseFromInfo(android.media.MediaFormat ), 0, this, mediaFormat);
        }

        private boolean supports(Integer n, Integer n2, Integer n3) {
            return (boolean)InvokeDynamicSupport.bootstrap("supports", $$robo$$android_media_MediaCodecInfo_EncoderCapabilities$supports(java.lang.Integer java.lang.Integer java.lang.Integer ), 0, this, n, n2, n3);
        }

        public void setDefaultFormat(MediaFormat mediaFormat) {
            InvokeDynamicSupport.bootstrap("setDefaultFormat", $$robo$$android_media_MediaCodecInfo_EncoderCapabilities$setDefaultFormat(android.media.MediaFormat ), 0, this, mediaFormat);
        }

        public boolean supportsFormat(MediaFormat mediaFormat) {
            return (boolean)InvokeDynamicSupport.bootstrap("supportsFormat", $$robo$$android_media_MediaCodecInfo_EncoderCapabilities$supportsFormat(android.media.MediaFormat ), 0, this, mediaFormat);
        }

        static {
            RobolectricInternals.classInitializing(EncoderCapabilities.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EncoderCapabilities)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class VideoCapabilities
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static String TAG = "VideoCapabilities";
        private CodecCapabilities mParent;
        private Range<Integer> mBitrateRange;
        private Range<Integer> mHeightRange;
        private Range<Integer> mWidthRange;
        private Range<Integer> mBlockCountRange;
        private Range<Integer> mHorizontalBlockRange;
        private Range<Integer> mVerticalBlockRange;
        private Range<Rational> mAspectRatioRange;
        private Range<Rational> mBlockAspectRatioRange;
        private Range<Long> mBlocksPerSecondRange;
        private Range<Integer> mFrameRateRange;
        private int mBlockWidth;
        private int mBlockHeight;
        private int mWidthAlignment;
        private int mHeightAlignment;
        private int mSmallerDimensionUpperLimit;

        private final Range<Integer> $$robo$$android_media_MediaCodecInfo_VideoCapabilities$getBitrateRange() {
            return this.mBitrateRange;
        }

        private final Range<Integer> $$robo$$android_media_MediaCodecInfo_VideoCapabilities$getSupportedWidths() {
            return this.mWidthRange;
        }

        private final Range<Integer> $$robo$$android_media_MediaCodecInfo_VideoCapabilities$getSupportedHeights() {
            return this.mHeightRange;
        }

        private final int $$robo$$android_media_MediaCodecInfo_VideoCapabilities$getWidthAlignment() {
            return this.mWidthAlignment;
        }

        private final int $$robo$$android_media_MediaCodecInfo_VideoCapabilities$getHeightAlignment() {
            return this.mHeightAlignment;
        }

        private final int $$robo$$android_media_MediaCodecInfo_VideoCapabilities$getSmallerDimensionUpperLimit() {
            return this.mSmallerDimensionUpperLimit;
        }

        private final Range<Integer> $$robo$$android_media_MediaCodecInfo_VideoCapabilities$getSupportedFrameRates() {
            return this.mFrameRateRange;
        }

        private final Range<Integer> $$robo$$android_media_MediaCodecInfo_VideoCapabilities$getSupportedWidthsFor(int height) {
            try {
                Range<Integer> range = this.mWidthRange;
                if (!this.mHeightRange.contains(height) || height % this.mHeightAlignment != 0) {
                    throw new IllegalArgumentException("unsupported height");
                }
                int heightInBlocks = Utils.divUp(height, this.mBlockHeight);
                int minWidthInBlocks = Math.max(Utils.divUp(this.mBlockCountRange.getLower(), heightInBlocks), (int)Math.ceil(this.mBlockAspectRatioRange.getLower().doubleValue() * (double)heightInBlocks));
                int maxWidthInBlocks = Math.min(this.mBlockCountRange.getUpper() / heightInBlocks, (int)(this.mBlockAspectRatioRange.getUpper().doubleValue() * (double)heightInBlocks));
                range = range.intersect((minWidthInBlocks - 1) * this.mBlockWidth + this.mWidthAlignment, maxWidthInBlocks * this.mBlockWidth);
                if (height > this.mSmallerDimensionUpperLimit) {
                    range = range.intersect(1, this.mSmallerDimensionUpperLimit);
                }
                range = range.intersect((int)Math.ceil(this.mAspectRatioRange.getLower().doubleValue() * (double)height), (int)(this.mAspectRatioRange.getUpper().doubleValue() * (double)height));
                return range;
            }
            catch (IllegalArgumentException e) {
                Log.w("VideoCapabilities", "could not get supported widths for " + height, e);
                throw new IllegalArgumentException("unsupported height");
            }
        }

        private final Range<Integer> $$robo$$android_media_MediaCodecInfo_VideoCapabilities$getSupportedHeightsFor(int width) {
            try {
                Range<Integer> range = this.mHeightRange;
                if (!this.mWidthRange.contains(width) || width % this.mWidthAlignment != 0) {
                    throw new IllegalArgumentException("unsupported width");
                }
                int widthInBlocks = Utils.divUp(width, this.mBlockWidth);
                int minHeightInBlocks = Math.max(Utils.divUp(this.mBlockCountRange.getLower(), widthInBlocks), (int)Math.ceil((double)widthInBlocks / this.mBlockAspectRatioRange.getUpper().doubleValue()));
                int maxHeightInBlocks = Math.min(this.mBlockCountRange.getUpper() / widthInBlocks, (int)((double)widthInBlocks / this.mBlockAspectRatioRange.getLower().doubleValue()));
                range = range.intersect((minHeightInBlocks - 1) * this.mBlockHeight + this.mHeightAlignment, maxHeightInBlocks * this.mBlockHeight);
                if (width > this.mSmallerDimensionUpperLimit) {
                    range = range.intersect(1, this.mSmallerDimensionUpperLimit);
                }
                range = range.intersect((int)Math.ceil((double)width / this.mAspectRatioRange.getUpper().doubleValue()), (int)((double)width / this.mAspectRatioRange.getLower().doubleValue()));
                return range;
            }
            catch (IllegalArgumentException e) {
                Log.w("VideoCapabilities", "could not get supported heights for " + width, e);
                throw new IllegalArgumentException("unsupported width");
            }
        }

        private final Range<Double> $$robo$$android_media_MediaCodecInfo_VideoCapabilities$getSupportedFrameRatesFor(int width, int height) {
            Range<Integer> range = this.mHeightRange;
            if (!this.supports(width, height, null)) {
                throw new IllegalArgumentException("unsupported size");
            }
            int blockCount = Utils.divUp(width, this.mBlockWidth) * Utils.divUp(height, this.mBlockHeight);
            return Range.create(Math.max((double)this.mBlocksPerSecondRange.getLower().longValue() / (double)blockCount, (double)this.mFrameRateRange.getLower().intValue()), Math.min((double)this.mBlocksPerSecondRange.getUpper().longValue() / (double)blockCount, (double)this.mFrameRateRange.getUpper().intValue()));
        }

        private final boolean $$robo$$android_media_MediaCodecInfo_VideoCapabilities$areSizeAndRateSupported(int width, int height, double frameRate) {
            return this.supports(width, height, frameRate);
        }

        private final boolean $$robo$$android_media_MediaCodecInfo_VideoCapabilities$isSizeSupported(int width, int height) {
            return this.supports(width, height, null);
        }

        private final boolean $$robo$$android_media_MediaCodecInfo_VideoCapabilities$supports(Integer width, Integer height, Double rate) {
            boolean ok = true;
            if (ok && width != null) {
                boolean bl = ok = this.mWidthRange.contains(width) && width % this.mWidthAlignment == 0;
            }
            if (ok && height != null) {
                boolean bl = ok = this.mHeightRange.contains(height) && height % this.mHeightAlignment == 0;
            }
            if (ok && rate != null) {
                ok = this.mFrameRateRange.contains(Utils.intRangeFor(rate));
            }
            if (ok && height != null && width != null) {
                ok = Math.min(height, width) <= this.mSmallerDimensionUpperLimit;
                int widthInBlocks = Utils.divUp(width, this.mBlockWidth);
                int heightInBlocks = Utils.divUp(height, this.mBlockHeight);
                int blockCount = widthInBlocks * heightInBlocks;
                boolean bl = ok = ok && this.mBlockCountRange.contains(blockCount) && this.mBlockAspectRatioRange.contains(new Rational(widthInBlocks, heightInBlocks)) && this.mAspectRatioRange.contains(new Rational(width, height));
                if (ok && rate != null) {
                    double blocksPerSec = (double)blockCount * rate;
                    ok = this.mBlocksPerSecondRange.contains(Utils.longRangeFor(blocksPerSec));
                }
            }
            return ok;
        }

        private final boolean $$robo$$android_media_MediaCodecInfo_VideoCapabilities$supportsFormat(MediaFormat format) {
            Map<String, Object> map = format.getMap();
            Integer width = (Integer)map.get("width");
            Integer height = (Integer)map.get("height");
            Double rate = (Double)map.get("frame-rate");
            return this.supports(width, height, rate);
        }

        private void $$robo$$android_media_MediaCodecInfo_VideoCapabilities$__constructor__() {
        }

        private static final VideoCapabilities $$robo$$android_media_MediaCodecInfo_VideoCapabilities$create(MediaFormat info, CodecCapabilities parent) {
            VideoCapabilities caps = new VideoCapabilities();
            caps.init(info, parent);
            return caps;
        }

        private final void $$robo$$android_media_MediaCodecInfo_VideoCapabilities$init(MediaFormat info, CodecCapabilities parent) {
            this.mParent = parent;
            this.initWithPlatformLimits();
            this.applyLevelLimits();
            this.parseFromInfo(info);
            this.updateLimits();
        }

        private final Size $$robo$$android_media_MediaCodecInfo_VideoCapabilities$getBlockSize() {
            return new Size(this.mBlockWidth, this.mBlockHeight);
        }

        private final Range<Integer> $$robo$$android_media_MediaCodecInfo_VideoCapabilities$getBlockCountRange() {
            return this.mBlockCountRange;
        }

        private final Range<Long> $$robo$$android_media_MediaCodecInfo_VideoCapabilities$getBlocksPerSecondRange() {
            return this.mBlocksPerSecondRange;
        }

        private final Range<Rational> $$robo$$android_media_MediaCodecInfo_VideoCapabilities$getAspectRatioRange(boolean blocks) {
            return blocks ? this.mBlockAspectRatioRange : this.mAspectRatioRange;
        }

        private final void $$robo$$android_media_MediaCodecInfo_VideoCapabilities$initWithPlatformLimits() {
            this.mBitrateRange = Range.create(0, Integer.MAX_VALUE);
            this.mWidthRange = SIZE_RANGE;
            this.mHeightRange = SIZE_RANGE;
            this.mFrameRateRange = FRAME_RATE_RANGE;
            this.mHorizontalBlockRange = SIZE_RANGE;
            this.mVerticalBlockRange = SIZE_RANGE;
            this.mBlockCountRange = POSITIVE_INTEGERS;
            this.mBlocksPerSecondRange = POSITIVE_LONGS;
            this.mBlockAspectRatioRange = POSITIVE_RATIONALS;
            this.mAspectRatioRange = POSITIVE_RATIONALS;
            this.mWidthAlignment = 2;
            this.mHeightAlignment = 2;
            this.mBlockWidth = 2;
            this.mBlockHeight = 2;
            this.mSmallerDimensionUpperLimit = (Integer)SIZE_RANGE.getUpper();
        }

        private final void $$robo$$android_media_MediaCodecInfo_VideoCapabilities$parseFromInfo(MediaFormat info) {
            Map<String, Object> map = info.getMap();
            Size blockSize = new Size(this.mBlockWidth, this.mBlockHeight);
            Size alignment = new Size(this.mWidthAlignment, this.mHeightAlignment);
            Range<Integer> counts = null;
            Range<Integer> widths = null;
            Range<Integer> heights = null;
            Range<Integer> frameRates = null;
            Range<Long> blockRates = null;
            Range<Rational> ratios = null;
            Range<Rational> blockRatios = null;
            blockSize = Utils.parseSize(map.get("block-size"), blockSize);
            alignment = Utils.parseSize(map.get("alignment"), alignment);
            counts = Utils.parseIntRange(map.get("block-count-range"), null);
            blockRates = Utils.parseLongRange(map.get("blocks-per-second-range"), null);
            Object o = map.get("size-range");
            Pair<Size, Size> sizeRange = Utils.parseSizeRange(o);
            if (sizeRange != null) {
                try {
                    widths = Range.create(((Size)sizeRange.first).getWidth(), ((Size)sizeRange.second).getWidth());
                    heights = Range.create(((Size)sizeRange.first).getHeight(), ((Size)sizeRange.second).getHeight());
                }
                catch (IllegalArgumentException e) {
                    Log.w("VideoCapabilities", "could not parse size range '" + o + "'");
                    widths = null;
                    heights = null;
                }
            }
            if (Integer.valueOf(1).equals(map.get("feature-can-swap-width-height"))) {
                if (widths != null) {
                    this.mSmallerDimensionUpperLimit = Math.min((Integer)widths.getUpper(), (Integer)heights.getUpper());
                    heights = widths.extend((Integer)((Object)heights));
                    widths = heights;
                } else {
                    Log.w("VideoCapabilities", "feature can-swap-width-height is best used with size-range");
                    this.mSmallerDimensionUpperLimit = Math.min(this.mWidthRange.getUpper(), this.mHeightRange.getUpper());
                    this.mHeightRange = this.mWidthRange.extend((Integer)((Object)this.mHeightRange));
                    this.mWidthRange = this.mHeightRange;
                }
            }
            ratios = Utils.parseRationalRange(map.get("block-aspect-ratio-range"), null);
            blockRatios = Utils.parseRationalRange(map.get("pixel-aspect-ratio-range"), null);
            frameRates = Utils.parseIntRange(map.get("frame-rate-range"), null);
            if (frameRates != null) {
                try {
                    frameRates = frameRates.intersect(FRAME_RATE_RANGE);
                }
                catch (IllegalArgumentException e) {
                    Log.w("VideoCapabilities", "frame rate range (" + frameRates + ") is out of limits: " + FRAME_RATE_RANGE);
                    frameRates = null;
                }
            }
            MediaCodecInfo.checkPowerOfTwo(blockSize.getWidth(), "block-size width must be power of two");
            MediaCodecInfo.checkPowerOfTwo(blockSize.getHeight(), "block-size height must be power of two");
            MediaCodecInfo.checkPowerOfTwo(alignment.getWidth(), "alignment width must be power of two");
            MediaCodecInfo.checkPowerOfTwo(alignment.getHeight(), "alignment height must be power of two");
            this.applyMacroBlockLimits(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Long.MAX_VALUE, blockSize.getWidth(), blockSize.getHeight(), alignment.getWidth(), alignment.getHeight());
            if ((this.mParent.mError & 2) != 0) {
                if (widths != null) {
                    this.mWidthRange = SIZE_RANGE.intersect(widths);
                }
                if (heights != null) {
                    this.mHeightRange = SIZE_RANGE.intersect(heights);
                }
                if (counts != null) {
                    this.mBlockCountRange = POSITIVE_INTEGERS.intersect(Utils.factorRange(counts, this.mBlockWidth * this.mBlockHeight / blockSize.getWidth() / blockSize.getHeight()));
                }
                if (blockRates != null) {
                    this.mBlocksPerSecondRange = POSITIVE_LONGS.intersect(Utils.factorRange(blockRates, (long)(this.mBlockWidth * this.mBlockHeight / blockSize.getWidth() / blockSize.getHeight())));
                }
                if (blockRatios != null) {
                    this.mBlockAspectRatioRange = POSITIVE_RATIONALS.intersect(Utils.scaleRange(blockRatios, this.mBlockHeight / blockSize.getHeight(), this.mBlockWidth / blockSize.getWidth()));
                }
                if (ratios != null) {
                    this.mAspectRatioRange = POSITIVE_RATIONALS.intersect(ratios);
                }
                if (frameRates != null) {
                    this.mFrameRateRange = FRAME_RATE_RANGE.intersect(frameRates);
                }
            } else {
                if (widths != null) {
                    this.mWidthRange = this.mWidthRange.intersect(widths);
                }
                if (heights != null) {
                    this.mHeightRange = this.mHeightRange.intersect(heights);
                }
                if (counts != null) {
                    this.mBlockCountRange = this.mBlockCountRange.intersect(Utils.factorRange(counts, this.mBlockWidth * this.mBlockHeight / blockSize.getWidth() / blockSize.getHeight()));
                }
                if (blockRates != null) {
                    this.mBlocksPerSecondRange = this.mBlocksPerSecondRange.intersect(Utils.factorRange(blockRates, (long)(this.mBlockWidth * this.mBlockHeight / blockSize.getWidth() / blockSize.getHeight())));
                }
                if (blockRatios != null) {
                    this.mBlockAspectRatioRange = this.mBlockAspectRatioRange.intersect(Utils.scaleRange(blockRatios, this.mBlockHeight / blockSize.getHeight(), this.mBlockWidth / blockSize.getWidth()));
                }
                if (ratios != null) {
                    this.mAspectRatioRange = this.mAspectRatioRange.intersect(ratios);
                }
                if (frameRates != null) {
                    this.mFrameRateRange = this.mFrameRateRange.intersect(frameRates);
                }
            }
            this.updateLimits();
        }

        private final void $$robo$$android_media_MediaCodecInfo_VideoCapabilities$applyBlockLimits(int blockWidth, int blockHeight, Range<Integer> counts, Range<Long> rates, Range<Rational> ratios) {
            MediaCodecInfo.checkPowerOfTwo(blockWidth, "blockWidth must be a power of two");
            MediaCodecInfo.checkPowerOfTwo(blockHeight, "blockHeight must be a power of two");
            int newBlockWidth = Math.max(blockWidth, this.mBlockWidth);
            int newBlockHeight = Math.max(blockHeight, this.mBlockHeight);
            int factor = newBlockWidth * newBlockHeight / this.mBlockWidth / this.mBlockHeight;
            if (factor != 1) {
                this.mBlockCountRange = Utils.factorRange(this.mBlockCountRange, factor);
                this.mBlocksPerSecondRange = Utils.factorRange(this.mBlocksPerSecondRange, (long)factor);
                this.mBlockAspectRatioRange = Utils.scaleRange(this.mBlockAspectRatioRange, newBlockHeight / this.mBlockHeight, newBlockWidth / this.mBlockWidth);
                this.mHorizontalBlockRange = Utils.factorRange(this.mHorizontalBlockRange, newBlockWidth / this.mBlockWidth);
                this.mVerticalBlockRange = Utils.factorRange(this.mVerticalBlockRange, newBlockHeight / this.mBlockHeight);
            }
            if ((factor = newBlockWidth * newBlockHeight / blockWidth / blockHeight) != 1) {
                counts = Utils.factorRange(counts, factor);
                rates = Utils.factorRange(rates, (long)factor);
                ratios = Utils.scaleRange(ratios, newBlockHeight / blockHeight, newBlockWidth / blockWidth);
            }
            this.mBlockCountRange = this.mBlockCountRange.intersect(counts);
            this.mBlocksPerSecondRange = this.mBlocksPerSecondRange.intersect(rates);
            this.mBlockAspectRatioRange = this.mBlockAspectRatioRange.intersect(ratios);
            this.mBlockWidth = newBlockWidth;
            this.mBlockHeight = newBlockHeight;
        }

        private final void $$robo$$android_media_MediaCodecInfo_VideoCapabilities$applyAlignment(int widthAlignment, int heightAlignment) {
            MediaCodecInfo.checkPowerOfTwo(widthAlignment, "widthAlignment must be a power of two");
            MediaCodecInfo.checkPowerOfTwo(heightAlignment, "heightAlignment must be a power of two");
            if (widthAlignment > this.mBlockWidth || heightAlignment > this.mBlockHeight) {
                this.applyBlockLimits(Math.max(widthAlignment, this.mBlockWidth), Math.max(heightAlignment, this.mBlockHeight), POSITIVE_INTEGERS, POSITIVE_LONGS, POSITIVE_RATIONALS);
            }
            this.mWidthAlignment = Math.max(widthAlignment, this.mWidthAlignment);
            this.mHeightAlignment = Math.max(heightAlignment, this.mHeightAlignment);
            this.mWidthRange = Utils.alignRange(this.mWidthRange, this.mWidthAlignment);
            this.mHeightRange = Utils.alignRange(this.mHeightRange, this.mHeightAlignment);
        }

        private final void $$robo$$android_media_MediaCodecInfo_VideoCapabilities$updateLimits() {
            this.mHorizontalBlockRange = this.mHorizontalBlockRange.intersect(Utils.factorRange(this.mWidthRange, this.mBlockWidth));
            this.mHorizontalBlockRange = this.mHorizontalBlockRange.intersect(Range.create(this.mBlockCountRange.getLower() / this.mVerticalBlockRange.getUpper(), this.mBlockCountRange.getUpper() / this.mVerticalBlockRange.getLower()));
            this.mVerticalBlockRange = this.mVerticalBlockRange.intersect(Utils.factorRange(this.mHeightRange, this.mBlockHeight));
            this.mVerticalBlockRange = this.mVerticalBlockRange.intersect(Range.create(this.mBlockCountRange.getLower() / this.mHorizontalBlockRange.getUpper(), this.mBlockCountRange.getUpper() / this.mHorizontalBlockRange.getLower()));
            this.mBlockCountRange = this.mBlockCountRange.intersect(Range.create(this.mHorizontalBlockRange.getLower() * this.mVerticalBlockRange.getLower(), this.mHorizontalBlockRange.getUpper() * this.mVerticalBlockRange.getUpper()));
            this.mBlockAspectRatioRange = this.mBlockAspectRatioRange.intersect(new Rational(this.mHorizontalBlockRange.getLower(), this.mVerticalBlockRange.getUpper()), new Rational(this.mHorizontalBlockRange.getUpper(), this.mVerticalBlockRange.getLower()));
            this.mWidthRange = this.mWidthRange.intersect((this.mHorizontalBlockRange.getLower() - 1) * this.mBlockWidth + this.mWidthAlignment, this.mHorizontalBlockRange.getUpper() * this.mBlockWidth);
            this.mHeightRange = this.mHeightRange.intersect((this.mVerticalBlockRange.getLower() - 1) * this.mBlockHeight + this.mHeightAlignment, this.mVerticalBlockRange.getUpper() * this.mBlockHeight);
            this.mAspectRatioRange = this.mAspectRatioRange.intersect(new Rational(this.mWidthRange.getLower(), this.mHeightRange.getUpper()), new Rational(this.mWidthRange.getUpper(), this.mHeightRange.getLower()));
            this.mSmallerDimensionUpperLimit = Math.min(this.mSmallerDimensionUpperLimit, Math.min(this.mWidthRange.getUpper(), this.mHeightRange.getUpper()));
            this.mBlocksPerSecondRange = this.mBlocksPerSecondRange.intersect((long)this.mBlockCountRange.getLower().intValue() * (long)this.mFrameRateRange.getLower().intValue(), (long)this.mBlockCountRange.getUpper().intValue() * (long)this.mFrameRateRange.getUpper().intValue());
            this.mFrameRateRange = this.mFrameRateRange.intersect((int)(this.mBlocksPerSecondRange.getLower() / (long)this.mBlockCountRange.getUpper().intValue()), (int)((double)this.mBlocksPerSecondRange.getUpper().longValue() / (double)this.mBlockCountRange.getLower().intValue()));
        }

        private final void $$robo$$android_media_MediaCodecInfo_VideoCapabilities$applyMacroBlockLimits(int maxHorizontalBlocks, int maxVerticalBlocks, int maxBlocks, long maxBlocksPerSecond, int blockWidth, int blockHeight, int widthAlignment, int heightAlignment) {
            this.applyAlignment(widthAlignment, heightAlignment);
            this.applyBlockLimits(blockWidth, blockHeight, Range.create(1, maxBlocks), Range.create(1L, maxBlocksPerSecond), Range.create(new Rational(1, maxVerticalBlocks), new Rational(maxHorizontalBlocks, 1)));
            this.mHorizontalBlockRange = this.mHorizontalBlockRange.intersect(1, maxHorizontalBlocks / (this.mBlockWidth / blockWidth));
            this.mVerticalBlockRange = this.mVerticalBlockRange.intersect(1, maxVerticalBlocks / (this.mBlockHeight / blockHeight));
        }

        private final void $$robo$$android_media_MediaCodecInfo_VideoCapabilities$applyLevelLimits() {
            int maxBlocksPerSecond = 0;
            int maxBlocks = 0;
            int maxBps = 0;
            int maxDPBBlocks = 0;
            int errors = 4;
            CodecProfileLevel[] profileLevels = this.mParent.profileLevels;
            String mime = this.mParent.getMimeType();
            if (mime.equalsIgnoreCase("video/avc")) {
                maxBlocks = 99;
                maxBlocksPerSecond = 1485;
                maxBps = 64000;
                maxDPBBlocks = 396;
                for (CodecProfileLevel profileLevel : profileLevels) {
                    int MBPS = 0;
                    int FS = 0;
                    int BR = 0;
                    int DPB = 0;
                    boolean supported = true;
                    switch (profileLevel.level) {
                        case 1: {
                            MBPS = 1485;
                            FS = 99;
                            BR = 64;
                            DPB = 396;
                            break;
                        }
                        case 2: {
                            MBPS = 1485;
                            FS = 99;
                            BR = 128;
                            DPB = 396;
                            break;
                        }
                        case 4: {
                            MBPS = 3000;
                            FS = 396;
                            BR = 192;
                            DPB = 900;
                            break;
                        }
                        case 8: {
                            MBPS = 6000;
                            FS = 396;
                            BR = 384;
                            DPB = 2376;
                            break;
                        }
                        case 16: {
                            MBPS = 11880;
                            FS = 396;
                            BR = 768;
                            DPB = 2376;
                            break;
                        }
                        case 32: {
                            MBPS = 11880;
                            FS = 396;
                            BR = 2000;
                            DPB = 2376;
                            break;
                        }
                        case 64: {
                            MBPS = 19800;
                            FS = 792;
                            BR = 4000;
                            DPB = 4752;
                            break;
                        }
                        case 128: {
                            MBPS = 20250;
                            FS = 1620;
                            BR = 4000;
                            DPB = 8100;
                            break;
                        }
                        case 256: {
                            MBPS = 40500;
                            FS = 1620;
                            BR = 10000;
                            DPB = 8100;
                            break;
                        }
                        case 512: {
                            MBPS = 108000;
                            FS = 3600;
                            BR = 14000;
                            DPB = 18000;
                            break;
                        }
                        case 1024: {
                            MBPS = 216000;
                            FS = 5120;
                            BR = 20000;
                            DPB = 20480;
                            break;
                        }
                        case 2048: {
                            MBPS = 245760;
                            FS = 8192;
                            BR = 20000;
                            DPB = 32768;
                            break;
                        }
                        case 4096: {
                            MBPS = 245760;
                            FS = 8192;
                            BR = 50000;
                            DPB = 32768;
                            break;
                        }
                        case 8192: {
                            MBPS = 522240;
                            FS = 8704;
                            BR = 50000;
                            DPB = 34816;
                            break;
                        }
                        case 16384: {
                            MBPS = 589824;
                            FS = 22080;
                            BR = 135000;
                            DPB = 110400;
                            break;
                        }
                        case 32768: {
                            MBPS = 983040;
                            FS = 36864;
                            BR = 240000;
                            DPB = 184320;
                            break;
                        }
                        case 65536: {
                            MBPS = 2073600;
                            FS = 36864;
                            BR = 240000;
                            DPB = 184320;
                            break;
                        }
                        default: {
                            Log.w("VideoCapabilities", "Unrecognized level " + profileLevel.level + " for " + mime);
                            errors |= 1;
                        }
                    }
                    switch (profileLevel.profile) {
                        case 8: {
                            BR *= 1250;
                            break;
                        }
                        case 16: {
                            BR *= 3000;
                            break;
                        }
                        case 4: 
                        case 32: 
                        case 64: {
                            Log.w("VideoCapabilities", "Unsupported profile " + profileLevel.profile + " for " + mime);
                            errors |= 2;
                            supported = false;
                        }
                        case 1: 
                        case 2: {
                            BR *= 1000;
                            break;
                        }
                        default: {
                            Log.w("VideoCapabilities", "Unrecognized profile " + profileLevel.profile + " for " + mime);
                            errors |= 1;
                            BR *= 1000;
                        }
                    }
                    if (supported) {
                        errors &= 0xFFFFFFFB;
                    }
                    maxBlocksPerSecond = Math.max(MBPS, maxBlocksPerSecond);
                    maxBlocks = Math.max(FS, maxBlocks);
                    maxBps = Math.max(BR, maxBps);
                    maxDPBBlocks = Math.max(maxDPBBlocks, DPB);
                }
                int maxLengthInBlocks = (int)Math.sqrt(maxBlocks * 8);
                this.applyMacroBlockLimits(maxLengthInBlocks, maxLengthInBlocks, maxBlocks, maxBlocksPerSecond, 16, 16, 1, 1);
            } else if (mime.equalsIgnoreCase("video/mp4v-es")) {
                int maxWidth = 11;
                int maxHeight = 9;
                int maxRate = 15;
                maxBlocks = 99;
                maxBlocksPerSecond = 1485;
                maxBps = 64000;
                for (CodecProfileLevel profileLevel : profileLevels) {
                    int MBPS = 0;
                    int FS = 0;
                    int BR = 0;
                    int FR = 0;
                    int W2 = 0;
                    int H2 = 0;
                    boolean supported = true;
                    block25 : switch (profileLevel.profile) {
                        case 1: {
                            switch (profileLevel.level) {
                                case 1: {
                                    FR = 15;
                                    W2 = 11;
                                    H2 = 9;
                                    MBPS = 1485;
                                    FS = 99;
                                    BR = 64;
                                    break block25;
                                }
                                case 4: {
                                    FR = 30;
                                    W2 = 11;
                                    H2 = 9;
                                    MBPS = 1485;
                                    FS = 99;
                                    BR = 64;
                                    break block25;
                                }
                                case 2: {
                                    FR = 30;
                                    W2 = 11;
                                    H2 = 9;
                                    MBPS = 1485;
                                    FS = 99;
                                    BR = 128;
                                    break block25;
                                }
                                case 8: {
                                    FR = 30;
                                    W2 = 22;
                                    H2 = 18;
                                    MBPS = 5940;
                                    FS = 396;
                                    BR = 128;
                                    break block25;
                                }
                                case 16: {
                                    FR = 30;
                                    W2 = 22;
                                    H2 = 18;
                                    MBPS = 11880;
                                    FS = 396;
                                    BR = 384;
                                    break block25;
                                }
                                case 32: 
                                case 64: 
                                case 128: {
                                    FR = 30;
                                    W2 = 22;
                                    H2 = 18;
                                    MBPS = 11880;
                                    FS = 396;
                                    BR = 384;
                                    supported = false;
                                    break block25;
                                }
                            }
                            Log.w("VideoCapabilities", "Unrecognized profile/level " + profileLevel.profile + "/" + profileLevel.level + " for " + mime);
                            errors |= 1;
                            break;
                        }
                        case 32768: {
                            switch (profileLevel.level) {
                                case 1: 
                                case 4: {
                                    FR = 30;
                                    W2 = 11;
                                    H2 = 9;
                                    MBPS = 2970;
                                    FS = 99;
                                    BR = 128;
                                    break block25;
                                }
                                case 8: {
                                    FR = 30;
                                    W2 = 22;
                                    H2 = 18;
                                    MBPS = 5940;
                                    FS = 396;
                                    BR = 384;
                                    break block25;
                                }
                                case 16: {
                                    FR = 30;
                                    W2 = 22;
                                    H2 = 18;
                                    MBPS = 11880;
                                    FS = 396;
                                    BR = 768;
                                    break block25;
                                }
                                case 32: 
                                case 64: {
                                    FR = 30;
                                    W2 = 44;
                                    H2 = 36;
                                    MBPS = 23760;
                                    FS = 792;
                                    BR = 3000;
                                    break block25;
                                }
                                case 128: {
                                    FR = 30;
                                    W2 = 45;
                                    H2 = 36;
                                    MBPS = 48600;
                                    FS = 1620;
                                    BR = 8000;
                                    break block25;
                                }
                            }
                            Log.w("VideoCapabilities", "Unrecognized profile/level " + profileLevel.profile + "/" + profileLevel.level + " for " + mime);
                            errors |= 1;
                            break;
                        }
                        case 2: 
                        case 4: 
                        case 8: 
                        case 16: 
                        case 32: 
                        case 64: 
                        case 128: 
                        case 256: 
                        case 512: 
                        case 1024: 
                        case 2048: 
                        case 4096: 
                        case 8192: 
                        case 16384: {
                            Log.i("VideoCapabilities", "Unsupported profile " + profileLevel.profile + " for " + mime);
                            errors |= 2;
                            supported = false;
                            break;
                        }
                        default: {
                            Log.w("VideoCapabilities", "Unrecognized profile " + profileLevel.profile + " for " + mime);
                            errors |= 1;
                        }
                    }
                    if (supported) {
                        errors &= 0xFFFFFFFB;
                    }
                    maxBlocksPerSecond = Math.max(MBPS, maxBlocksPerSecond);
                    maxBlocks = Math.max(FS, maxBlocks);
                    maxBps = Math.max(BR * 1000, maxBps);
                    maxWidth = Math.max(W2, maxWidth);
                    maxHeight = Math.max(H2, maxHeight);
                    maxRate = Math.max(FR, maxRate);
                }
                this.applyMacroBlockLimits(maxWidth, maxHeight, maxBlocks, maxBlocksPerSecond, 16, 16, 1, 1);
                this.mFrameRateRange = this.mFrameRateRange.intersect(12, maxRate);
            } else if (mime.equalsIgnoreCase("video/3gpp")) {
                int maxWidth = 11;
                int maxHeight = 9;
                int maxRate = 15;
                maxBlocks = 99;
                maxBlocksPerSecond = 1485;
                maxBps = 64000;
                for (CodecProfileLevel profileLevel : profileLevels) {
                    int MBPS = 0;
                    int BR = 0;
                    int FR = 0;
                    int W3 = 0;
                    int H3 = 0;
                    switch (profileLevel.level) {
                        case 1: {
                            FR = 15;
                            W3 = 11;
                            H3 = 9;
                            BR = 1;
                            MBPS = W3 * H3 * FR;
                            break;
                        }
                        case 2: {
                            FR = 30;
                            W3 = 22;
                            H3 = 18;
                            BR = 2;
                            MBPS = W3 * H3 * FR;
                            break;
                        }
                        case 4: {
                            FR = 30;
                            W3 = 22;
                            H3 = 18;
                            BR = 6;
                            MBPS = W3 * H3 * FR;
                            break;
                        }
                        case 8: {
                            FR = 30;
                            W3 = 22;
                            H3 = 18;
                            BR = 32;
                            MBPS = W3 * H3 * FR;
                            break;
                        }
                        case 16: {
                            FR = 30;
                            W3 = 11;
                            H3 = 9;
                            BR = 2;
                            MBPS = W3 * H3 * FR;
                            break;
                        }
                        case 32: {
                            FR = 60;
                            W3 = 22;
                            H3 = 18;
                            BR = 64;
                            MBPS = W3 * H3 * 50;
                            break;
                        }
                        case 64: {
                            FR = 60;
                            W3 = 45;
                            H3 = 18;
                            BR = 128;
                            MBPS = W3 * H3 * 50;
                            break;
                        }
                        case 128: {
                            FR = 60;
                            W3 = 45;
                            H3 = 36;
                            BR = 256;
                            MBPS = W3 * H3 * 50;
                            break;
                        }
                        default: {
                            Log.w("VideoCapabilities", "Unrecognized profile/level " + profileLevel.profile + "/" + profileLevel.level + " for " + mime);
                            errors |= 1;
                        }
                    }
                    switch (profileLevel.profile) {
                        case 1: 
                        case 2: 
                        case 4: 
                        case 8: 
                        case 16: 
                        case 32: 
                        case 64: 
                        case 128: 
                        case 256: {
                            break;
                        }
                        default: {
                            Log.w("VideoCapabilities", "Unrecognized profile " + profileLevel.profile + " for " + mime);
                            errors |= 1;
                        }
                    }
                    errors &= 0xFFFFFFFB;
                    maxBlocksPerSecond = Math.max(MBPS, maxBlocksPerSecond);
                    maxBlocks = Math.max(W3 * H3, maxBlocks);
                    maxBps = Math.max(BR * 64000, maxBps);
                    maxWidth = Math.max(W3, maxWidth);
                    maxHeight = Math.max(H3, maxHeight);
                    maxRate = Math.max(FR, maxRate);
                }
                this.applyMacroBlockLimits(maxWidth, maxHeight, maxBlocks, maxBlocksPerSecond, 16, 16, 1, 1);
                this.mFrameRateRange = Range.create(1, maxRate);
            } else if (mime.equalsIgnoreCase("video/x-vnd.on2.vp8") || mime.equalsIgnoreCase("video/x-vnd.on2.vp9")) {
                maxBlocksPerSecond = Integer.MAX_VALUE;
                maxBlocks = Integer.MAX_VALUE;
                maxBps = 100000000;
                for (CodecProfileLevel profileLevel : profileLevels) {
                    switch (profileLevel.level) {
                        case 1: 
                        case 2: 
                        case 4: 
                        case 8: {
                            break;
                        }
                        default: {
                            Log.w("VideoCapabilities", "Unrecognized level " + profileLevel.level + " for " + mime);
                            errors |= 1;
                        }
                    }
                    switch (profileLevel.profile) {
                        case 1: {
                            break;
                        }
                        default: {
                            Log.w("VideoCapabilities", "Unrecognized profile " + profileLevel.profile + " for " + mime);
                            errors |= 1;
                        }
                    }
                    errors &= 0xFFFFFFFB;
                }
                int blockSize = mime.equalsIgnoreCase("video/x-vnd.on2.vp8") ? 16 : 8;
                this.applyMacroBlockLimits(Short.MAX_VALUE, Short.MAX_VALUE, maxBlocks, maxBlocksPerSecond, blockSize, blockSize, 1, 1);
            } else if (mime.equalsIgnoreCase("video/hevc")) {
                maxBlocks = 36864;
                maxBlocksPerSecond = maxBlocks * 15;
                maxBps = 128000;
                for (CodecProfileLevel profileLevel : profileLevels) {
                    double FR = 0.0;
                    int FS = 0;
                    int BR = 0;
                    switch (profileLevel.level) {
                        case 1: 
                        case 2: {
                            FR = 15.0;
                            FS = 36864;
                            BR = 128;
                            break;
                        }
                        case 4: 
                        case 8: {
                            FR = 30.0;
                            FS = 122880;
                            BR = 1500;
                            break;
                        }
                        case 16: 
                        case 32: {
                            FR = 30.0;
                            FS = 245760;
                            BR = 3000;
                            break;
                        }
                        case 64: 
                        case 128: {
                            FR = 30.0;
                            FS = 552960;
                            BR = 6000;
                            break;
                        }
                        case 256: 
                        case 512: {
                            FR = 33.75;
                            FS = 983040;
                            BR = 10000;
                            break;
                        }
                        case 1024: {
                            FR = 30.0;
                            FS = 0x220000;
                            BR = 12000;
                            break;
                        }
                        case 2048: {
                            FR = 30.0;
                            FS = 0x220000;
                            BR = 30000;
                            break;
                        }
                        case 4096: {
                            FR = 60.0;
                            FS = 0x220000;
                            BR = 20000;
                            break;
                        }
                        case 8192: {
                            FR = 60.0;
                            FS = 0x220000;
                            BR = 50000;
                            break;
                        }
                        case 16384: {
                            FR = 30.0;
                            FS = 0x880000;
                            BR = 25000;
                            break;
                        }
                        case 32768: {
                            FR = 30.0;
                            FS = 0x880000;
                            BR = 100000;
                            break;
                        }
                        case 65536: {
                            FR = 60.0;
                            FS = 0x880000;
                            BR = 40000;
                            break;
                        }
                        case 131072: {
                            FR = 60.0;
                            FS = 0x880000;
                            BR = 160000;
                            break;
                        }
                        case 262144: {
                            FR = 120.0;
                            FS = 0x880000;
                            BR = 60000;
                            break;
                        }
                        case 524288: {
                            FR = 120.0;
                            FS = 0x880000;
                            BR = 240000;
                            break;
                        }
                        case 0x100000: {
                            FR = 30.0;
                            FS = 0x2200000;
                            BR = 60000;
                            break;
                        }
                        case 0x200000: {
                            FR = 30.0;
                            FS = 0x2200000;
                            BR = 240000;
                            break;
                        }
                        case 0x400000: {
                            FR = 60.0;
                            FS = 0x2200000;
                            BR = 120000;
                            break;
                        }
                        case 0x800000: {
                            FR = 60.0;
                            FS = 0x2200000;
                            BR = 480000;
                            break;
                        }
                        case 0x1000000: {
                            FR = 120.0;
                            FS = 0x2200000;
                            BR = 240000;
                            break;
                        }
                        case 0x2000000: {
                            FR = 120.0;
                            FS = 0x2200000;
                            BR = 800000;
                            break;
                        }
                        default: {
                            Log.w("VideoCapabilities", "Unrecognized level " + profileLevel.level + " for " + mime);
                            errors |= 1;
                        }
                    }
                    switch (profileLevel.profile) {
                        case 1: 
                        case 2: {
                            break;
                        }
                        default: {
                            Log.w("VideoCapabilities", "Unrecognized profile " + profileLevel.profile + " for " + mime);
                            errors |= 1;
                        }
                    }
                    errors &= 0xFFFFFFFB;
                    maxBlocksPerSecond = Math.max((int)(FR * (double)FS), maxBlocksPerSecond);
                    maxBlocks = Math.max(FS, maxBlocks);
                    maxBps = Math.max(BR * 1000, maxBps);
                }
                int maxLengthInBlocks = (int)Math.sqrt(maxBlocks * 8);
                maxBlocks = Utils.divUp(maxBlocks, 64);
                maxBlocksPerSecond = Utils.divUp(maxBlocksPerSecond, 64);
                maxLengthInBlocks = Utils.divUp(maxLengthInBlocks, 8);
                this.applyMacroBlockLimits(maxLengthInBlocks, maxLengthInBlocks, maxBlocks, maxBlocksPerSecond, 8, 8, 1, 1);
            } else {
                Log.w("VideoCapabilities", "Unsupported mime " + mime);
                maxBps = 64000;
                errors |= 2;
            }
            this.mBitrateRange = Range.create(1, maxBps);
            this.mParent.mError |= errors;
        }

        public Range<Integer> getBitrateRange() {
            return InvokeDynamicSupport.bootstrap("getBitrateRange", $$robo$$android_media_MediaCodecInfo_VideoCapabilities$getBitrateRange(), 0, this);
        }

        public Range<Integer> getSupportedWidths() {
            return InvokeDynamicSupport.bootstrap("getSupportedWidths", $$robo$$android_media_MediaCodecInfo_VideoCapabilities$getSupportedWidths(), 0, this);
        }

        public Range<Integer> getSupportedHeights() {
            return InvokeDynamicSupport.bootstrap("getSupportedHeights", $$robo$$android_media_MediaCodecInfo_VideoCapabilities$getSupportedHeights(), 0, this);
        }

        public int getWidthAlignment() {
            return (int)InvokeDynamicSupport.bootstrap("getWidthAlignment", $$robo$$android_media_MediaCodecInfo_VideoCapabilities$getWidthAlignment(), 0, this);
        }

        public int getHeightAlignment() {
            return (int)InvokeDynamicSupport.bootstrap("getHeightAlignment", $$robo$$android_media_MediaCodecInfo_VideoCapabilities$getHeightAlignment(), 0, this);
        }

        public int getSmallerDimensionUpperLimit() {
            return (int)InvokeDynamicSupport.bootstrap("getSmallerDimensionUpperLimit", $$robo$$android_media_MediaCodecInfo_VideoCapabilities$getSmallerDimensionUpperLimit(), 0, this);
        }

        public Range<Integer> getSupportedFrameRates() {
            return InvokeDynamicSupport.bootstrap("getSupportedFrameRates", $$robo$$android_media_MediaCodecInfo_VideoCapabilities$getSupportedFrameRates(), 0, this);
        }

        public Range<Integer> getSupportedWidthsFor(int n) {
            return InvokeDynamicSupport.bootstrap("getSupportedWidthsFor", $$robo$$android_media_MediaCodecInfo_VideoCapabilities$getSupportedWidthsFor(int ), 0, this, n);
        }

        public Range<Integer> getSupportedHeightsFor(int n) {
            return InvokeDynamicSupport.bootstrap("getSupportedHeightsFor", $$robo$$android_media_MediaCodecInfo_VideoCapabilities$getSupportedHeightsFor(int ), 0, this, n);
        }

        public Range<Double> getSupportedFrameRatesFor(int n, int n2) {
            return InvokeDynamicSupport.bootstrap("getSupportedFrameRatesFor", $$robo$$android_media_MediaCodecInfo_VideoCapabilities$getSupportedFrameRatesFor(int int ), 0, this, n, n2);
        }

        public boolean areSizeAndRateSupported(int n, int n2, double d) {
            return (boolean)InvokeDynamicSupport.bootstrap("areSizeAndRateSupported", $$robo$$android_media_MediaCodecInfo_VideoCapabilities$areSizeAndRateSupported(int int double ), 0, this, n, n2, d);
        }

        public boolean isSizeSupported(int n, int n2) {
            return (boolean)InvokeDynamicSupport.bootstrap("isSizeSupported", $$robo$$android_media_MediaCodecInfo_VideoCapabilities$isSizeSupported(int int ), 0, this, n, n2);
        }

        private boolean supports(Integer n, Integer n2, Double d) {
            return (boolean)InvokeDynamicSupport.bootstrap("supports", $$robo$$android_media_MediaCodecInfo_VideoCapabilities$supports(java.lang.Integer java.lang.Integer java.lang.Double ), 0, this, n, n2, d);
        }

        public boolean supportsFormat(MediaFormat mediaFormat) {
            return (boolean)InvokeDynamicSupport.bootstrap("supportsFormat", $$robo$$android_media_MediaCodecInfo_VideoCapabilities$supportsFormat(android.media.MediaFormat ), 0, this, mediaFormat);
        }

        private void __constructor__() {
            this.$$robo$$android_media_MediaCodecInfo_VideoCapabilities$__constructor__();
        }

        private VideoCapabilities() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaCodecInfo_VideoCapabilities$__constructor__(), 0, this);
        }

        public static VideoCapabilities create(MediaFormat mediaFormat, CodecCapabilities codecCapabilities) {
            return InvokeDynamicSupport.bootstrapStatic("create", $$robo$$android_media_MediaCodecInfo_VideoCapabilities$create(android.media.MediaFormat android.media.MediaCodecInfo$CodecCapabilities ), 0, (MediaFormat)mediaFormat, (CodecCapabilities)codecCapabilities);
        }

        public void init(MediaFormat mediaFormat, CodecCapabilities codecCapabilities) {
            InvokeDynamicSupport.bootstrap("init", $$robo$$android_media_MediaCodecInfo_VideoCapabilities$init(android.media.MediaFormat android.media.MediaCodecInfo$CodecCapabilities ), 0, this, mediaFormat, codecCapabilities);
        }

        public Size getBlockSize() {
            return InvokeDynamicSupport.bootstrap("getBlockSize", $$robo$$android_media_MediaCodecInfo_VideoCapabilities$getBlockSize(), 0, this);
        }

        public Range<Integer> getBlockCountRange() {
            return InvokeDynamicSupport.bootstrap("getBlockCountRange", $$robo$$android_media_MediaCodecInfo_VideoCapabilities$getBlockCountRange(), 0, this);
        }

        public Range<Long> getBlocksPerSecondRange() {
            return InvokeDynamicSupport.bootstrap("getBlocksPerSecondRange", $$robo$$android_media_MediaCodecInfo_VideoCapabilities$getBlocksPerSecondRange(), 0, this);
        }

        public Range<Rational> getAspectRatioRange(boolean bl) {
            return InvokeDynamicSupport.bootstrap("getAspectRatioRange", $$robo$$android_media_MediaCodecInfo_VideoCapabilities$getAspectRatioRange(boolean ), 0, this, bl);
        }

        private void initWithPlatformLimits() {
            InvokeDynamicSupport.bootstrap("initWithPlatformLimits", $$robo$$android_media_MediaCodecInfo_VideoCapabilities$initWithPlatformLimits(), 0, this);
        }

        private void parseFromInfo(MediaFormat mediaFormat) {
            InvokeDynamicSupport.bootstrap("parseFromInfo", $$robo$$android_media_MediaCodecInfo_VideoCapabilities$parseFromInfo(android.media.MediaFormat ), 0, this, mediaFormat);
        }

        private void applyBlockLimits(int n, int n2, Range<Integer> range, Range<Long> range2, Range<Rational> range3) {
            InvokeDynamicSupport.bootstrap("applyBlockLimits", $$robo$$android_media_MediaCodecInfo_VideoCapabilities$applyBlockLimits(int int android.util.Range<java.lang.Integer> android.util.Range<java.lang.Long> android.util.Range<android.util.Rational> ), 0, this, n, n2, range, range2, range3);
        }

        private void applyAlignment(int n, int n2) {
            InvokeDynamicSupport.bootstrap("applyAlignment", $$robo$$android_media_MediaCodecInfo_VideoCapabilities$applyAlignment(int int ), 0, this, n, n2);
        }

        private void updateLimits() {
            InvokeDynamicSupport.bootstrap("updateLimits", $$robo$$android_media_MediaCodecInfo_VideoCapabilities$updateLimits(), 0, this);
        }

        private void applyMacroBlockLimits(int n, int n2, int n3, long l, int n4, int n5, int n6, int n7) {
            InvokeDynamicSupport.bootstrap("applyMacroBlockLimits", $$robo$$android_media_MediaCodecInfo_VideoCapabilities$applyMacroBlockLimits(int int int long int int int int ), 0, this, n, n2, n3, l, n4, n5, n6, n7);
        }

        private void applyLevelLimits() {
            InvokeDynamicSupport.bootstrap("applyLevelLimits", $$robo$$android_media_MediaCodecInfo_VideoCapabilities$applyLevelLimits(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (VideoCapabilities)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class AudioCapabilities
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static String TAG = "AudioCapabilities";
        private CodecCapabilities mParent;
        private Range<Integer> mBitrateRange;
        private int[] mSampleRates;
        private Range<Integer>[] mSampleRateRanges;
        private int mMaxInputChannelCount;
        private static int MAX_INPUT_CHANNEL_COUNT = 30;

        private final Range<Integer> $$robo$$android_media_MediaCodecInfo_AudioCapabilities$getBitrateRange() {
            return this.mBitrateRange;
        }

        private final int[] $$robo$$android_media_MediaCodecInfo_AudioCapabilities$getSupportedSampleRates() {
            return Arrays.copyOf(this.mSampleRates, this.mSampleRates.length);
        }

        private final Range<Integer>[] $$robo$$android_media_MediaCodecInfo_AudioCapabilities$getSupportedSampleRateRanges() {
            return Arrays.copyOf(this.mSampleRateRanges, this.mSampleRateRanges.length);
        }

        private final int $$robo$$android_media_MediaCodecInfo_AudioCapabilities$getMaxInputChannelCount() {
            return this.mMaxInputChannelCount;
        }

        private void $$robo$$android_media_MediaCodecInfo_AudioCapabilities$__constructor__() {
        }

        private static final AudioCapabilities $$robo$$android_media_MediaCodecInfo_AudioCapabilities$create(MediaFormat info, CodecCapabilities parent) {
            AudioCapabilities caps = new AudioCapabilities();
            caps.init(info, parent);
            return caps;
        }

        private final void $$robo$$android_media_MediaCodecInfo_AudioCapabilities$init(MediaFormat info, CodecCapabilities parent) {
            this.mParent = parent;
            this.initWithPlatformLimits();
            this.applyLevelLimits();
            this.parseFromInfo(info);
        }

        private final void $$robo$$android_media_MediaCodecInfo_AudioCapabilities$initWithPlatformLimits() {
            this.mBitrateRange = Range.create(0, Integer.MAX_VALUE);
            this.mMaxInputChannelCount = 30;
            this.mSampleRateRanges = new Range[]{Range.create(8000, 96000)};
            this.mSampleRates = null;
        }

        private final boolean $$robo$$android_media_MediaCodecInfo_AudioCapabilities$supports(Integer sampleRate, Integer inputChannels) {
            int ix;
            if (inputChannels != null && (inputChannels < 1 || inputChannels > this.mMaxInputChannelCount)) {
                return false;
            }
            return sampleRate == null || (ix = Utils.binarySearchDistinctRanges(this.mSampleRateRanges, sampleRate)) >= 0;
        }

        private final boolean $$robo$$android_media_MediaCodecInfo_AudioCapabilities$isSampleRateSupported(int sampleRate) {
            return this.supports(sampleRate, null);
        }

        private final void $$robo$$android_media_MediaCodecInfo_AudioCapabilities$limitSampleRates(int[] rates) {
            Arrays.sort(rates);
            ArrayList<Range<Integer>> ranges = new ArrayList<Range<Integer>>();
            for (int rate : rates) {
                if (!this.supports(rate, null)) continue;
                ranges.add(Range.create(rate, rate));
            }
            this.mSampleRateRanges = ranges.toArray(new Range[ranges.size()]);
            this.createDiscreteSampleRates();
        }

        private final void $$robo$$android_media_MediaCodecInfo_AudioCapabilities$createDiscreteSampleRates() {
            this.mSampleRates = new int[this.mSampleRateRanges.length];
            for (int i = 0; i < this.mSampleRateRanges.length; ++i) {
                this.mSampleRates[i] = this.mSampleRateRanges[i].getLower();
            }
        }

        private final void $$robo$$android_media_MediaCodecInfo_AudioCapabilities$limitSampleRates(Range<Integer>[] rateRanges) {
            Utils.sortDistinctRanges(rateRanges);
            for (Range<Integer> range : this.mSampleRateRanges = Utils.intersectSortedDistinctRanges(this.mSampleRateRanges, rateRanges)) {
                if (range.getLower().equals(range.getUpper())) continue;
                this.mSampleRates = null;
                return;
            }
            this.createDiscreteSampleRates();
        }

        private final void $$robo$$android_media_MediaCodecInfo_AudioCapabilities$applyLevelLimits() {
            int[] sampleRates = null;
            Range<Integer> sampleRateRange = null;
            Range<Integer> bitRates = null;
            int maxChannels = 0;
            String mime = this.mParent.getMimeType();
            if (mime.equalsIgnoreCase("audio/mpeg")) {
                sampleRates = new int[]{8000, 11025, 12000, 16000, 22050, 24000, 32000, 44100, 48000};
                bitRates = Range.create(8000, 320000);
                maxChannels = 2;
            } else if (mime.equalsIgnoreCase("audio/3gpp")) {
                sampleRates = new int[]{8000};
                bitRates = Range.create(4750, 12200);
                maxChannels = 1;
            } else if (mime.equalsIgnoreCase("audio/amr-wb")) {
                sampleRates = new int[]{16000};
                bitRates = Range.create(6600, 23850);
                maxChannels = 1;
            } else if (mime.equalsIgnoreCase("audio/mp4a-latm")) {
                sampleRates = new int[]{7350, 8000, 11025, 12000, 16000, 22050, 24000, 32000, 44100, 48000, 64000, 88200, 96000};
                bitRates = Range.create(8000, 510000);
                maxChannels = 48;
            } else if (mime.equalsIgnoreCase("audio/vorbis")) {
                bitRates = Range.create(32000, 500000);
                sampleRates = new int[]{8000, 12000, 16000, 24000, 48000, 192000};
                maxChannels = 255;
            } else if (mime.equalsIgnoreCase("audio/opus")) {
                bitRates = Range.create(6000, 510000);
                sampleRates = new int[]{8000, 12000, 16000, 24000, 48000};
                maxChannels = 255;
            } else if (mime.equalsIgnoreCase("audio/raw")) {
                sampleRateRange = Range.create(1, 96000);
                bitRates = Range.create(1, 10000000);
                maxChannels = 8;
            } else if (mime.equalsIgnoreCase("audio/flac")) {
                sampleRateRange = Range.create(1, 655350);
                maxChannels = 255;
            } else if (mime.equalsIgnoreCase("audio/g711-alaw") || mime.equalsIgnoreCase("audio/g711-mlaw")) {
                sampleRates = new int[]{8000};
                bitRates = Range.create(64000, 64000);
            } else if (mime.equalsIgnoreCase("audio/gsm")) {
                sampleRates = new int[]{8000};
                bitRates = Range.create(13000, 13000);
                maxChannels = 1;
            } else {
                Log.w("AudioCapabilities", "Unsupported mime " + mime);
                this.mParent.mError |= 2;
            }
            if (sampleRates != null) {
                this.limitSampleRates(sampleRates);
            } else if (sampleRateRange != null) {
                this.limitSampleRates(new Range[]{sampleRateRange});
            }
            this.applyLimits(maxChannels, bitRates);
        }

        private final void $$robo$$android_media_MediaCodecInfo_AudioCapabilities$applyLimits(int maxInputChannels, Range<Integer> bitRates) {
            this.mMaxInputChannelCount = Range.create(1, this.mMaxInputChannelCount).clamp(maxInputChannels);
            if (bitRates != null) {
                this.mBitrateRange = this.mBitrateRange.intersect(bitRates);
            }
        }

        private final void $$robo$$android_media_MediaCodecInfo_AudioCapabilities$parseFromInfo(MediaFormat info) {
            int maxInputChannels = 30;
            Range<Integer> bitRates = POSITIVE_INTEGERS;
            if (info.containsKey("sample-rate-ranges")) {
                String[] rateStrings = info.getString("sample-rate-ranges").split(",");
                Range[] rateRanges = new Range[rateStrings.length];
                for (int i = 0; i < rateStrings.length; ++i) {
                    rateRanges[i] = Utils.parseIntRange(rateStrings[i], null);
                }
                this.limitSampleRates(rateRanges);
            }
            if (info.containsKey("max-channel-count")) {
                maxInputChannels = Utils.parseIntSafely(info.getString("max-channel-count"), maxInputChannels);
            }
            if (info.containsKey("bitrate-range")) {
                bitRates = bitRates.intersect(Utils.parseIntRange(info.getString("bitrate"), bitRates));
            }
            this.applyLimits(maxInputChannels, bitRates);
        }

        private final void $$robo$$android_media_MediaCodecInfo_AudioCapabilities$setDefaultFormat(MediaFormat format) {
            if (this.mBitrateRange.getLower().equals(this.mBitrateRange.getUpper())) {
                format.setInteger("bitrate", this.mBitrateRange.getLower());
            }
            if (this.mMaxInputChannelCount == 1) {
                format.setInteger("channel-count", 1);
            }
            if (this.mSampleRates != null && this.mSampleRates.length == 1) {
                format.setInteger("sample-rate", this.mSampleRates[0]);
            }
        }

        private final boolean $$robo$$android_media_MediaCodecInfo_AudioCapabilities$supportsFormat(MediaFormat format) {
            Integer channels;
            Map<String, Object> map = format.getMap();
            Integer sampleRate = (Integer)map.get("sample-rate");
            return this.supports(sampleRate, channels = (Integer)map.get("channel-count"));
        }

        public Range<Integer> getBitrateRange() {
            return InvokeDynamicSupport.bootstrap("getBitrateRange", $$robo$$android_media_MediaCodecInfo_AudioCapabilities$getBitrateRange(), 0, this);
        }

        public int[] getSupportedSampleRates() {
            return InvokeDynamicSupport.bootstrap("getSupportedSampleRates", $$robo$$android_media_MediaCodecInfo_AudioCapabilities$getSupportedSampleRates(), 0, this);
        }

        public Range<Integer>[] getSupportedSampleRateRanges() {
            return InvokeDynamicSupport.bootstrap("getSupportedSampleRateRanges", $$robo$$android_media_MediaCodecInfo_AudioCapabilities$getSupportedSampleRateRanges(), 0, this);
        }

        public int getMaxInputChannelCount() {
            return (int)InvokeDynamicSupport.bootstrap("getMaxInputChannelCount", $$robo$$android_media_MediaCodecInfo_AudioCapabilities$getMaxInputChannelCount(), 0, this);
        }

        private void __constructor__() {
            this.$$robo$$android_media_MediaCodecInfo_AudioCapabilities$__constructor__();
        }

        private AudioCapabilities() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaCodecInfo_AudioCapabilities$__constructor__(), 0, this);
        }

        public static AudioCapabilities create(MediaFormat mediaFormat, CodecCapabilities codecCapabilities) {
            return InvokeDynamicSupport.bootstrapStatic("create", $$robo$$android_media_MediaCodecInfo_AudioCapabilities$create(android.media.MediaFormat android.media.MediaCodecInfo$CodecCapabilities ), 0, (MediaFormat)mediaFormat, (CodecCapabilities)codecCapabilities);
        }

        public void init(MediaFormat mediaFormat, CodecCapabilities codecCapabilities) {
            InvokeDynamicSupport.bootstrap("init", $$robo$$android_media_MediaCodecInfo_AudioCapabilities$init(android.media.MediaFormat android.media.MediaCodecInfo$CodecCapabilities ), 0, this, mediaFormat, codecCapabilities);
        }

        private void initWithPlatformLimits() {
            InvokeDynamicSupport.bootstrap("initWithPlatformLimits", $$robo$$android_media_MediaCodecInfo_AudioCapabilities$initWithPlatformLimits(), 0, this);
        }

        private boolean supports(Integer n, Integer n2) {
            return (boolean)InvokeDynamicSupport.bootstrap("supports", $$robo$$android_media_MediaCodecInfo_AudioCapabilities$supports(java.lang.Integer java.lang.Integer ), 0, this, n, n2);
        }

        public boolean isSampleRateSupported(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("isSampleRateSupported", $$robo$$android_media_MediaCodecInfo_AudioCapabilities$isSampleRateSupported(int ), 0, this, n);
        }

        private void limitSampleRates(int[] nArray) {
            InvokeDynamicSupport.bootstrap("limitSampleRates", $$robo$$android_media_MediaCodecInfo_AudioCapabilities$limitSampleRates(int[] ), 0, this, nArray);
        }

        private void createDiscreteSampleRates() {
            InvokeDynamicSupport.bootstrap("createDiscreteSampleRates", $$robo$$android_media_MediaCodecInfo_AudioCapabilities$createDiscreteSampleRates(), 0, this);
        }

        private void limitSampleRates(Range<Integer>[] rangeArray) {
            InvokeDynamicSupport.bootstrap("limitSampleRates", $$robo$$android_media_MediaCodecInfo_AudioCapabilities$limitSampleRates(android.util.Range<java.lang.Integer>[] ), 0, this, rangeArray);
        }

        private void applyLevelLimits() {
            InvokeDynamicSupport.bootstrap("applyLevelLimits", $$robo$$android_media_MediaCodecInfo_AudioCapabilities$applyLevelLimits(), 0, this);
        }

        private void applyLimits(int n, Range<Integer> range) {
            InvokeDynamicSupport.bootstrap("applyLimits", $$robo$$android_media_MediaCodecInfo_AudioCapabilities$applyLimits(int android.util.Range<java.lang.Integer> ), 0, this, n, range);
        }

        private void parseFromInfo(MediaFormat mediaFormat) {
            InvokeDynamicSupport.bootstrap("parseFromInfo", $$robo$$android_media_MediaCodecInfo_AudioCapabilities$parseFromInfo(android.media.MediaFormat ), 0, this, mediaFormat);
        }

        public void setDefaultFormat(MediaFormat mediaFormat) {
            InvokeDynamicSupport.bootstrap("setDefaultFormat", $$robo$$android_media_MediaCodecInfo_AudioCapabilities$setDefaultFormat(android.media.MediaFormat ), 0, this, mediaFormat);
        }

        public boolean supportsFormat(MediaFormat mediaFormat) {
            return (boolean)InvokeDynamicSupport.bootstrap("supportsFormat", $$robo$$android_media_MediaCodecInfo_AudioCapabilities$supportsFormat(android.media.MediaFormat ), 0, this, mediaFormat);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AudioCapabilities)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class CodecCapabilities
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private String mMime;
        public CodecProfileLevel[] profileLevels;
        public static int COLOR_FormatMonochrome = 1;
        public static int COLOR_Format8bitRGB332 = 2;
        public static int COLOR_Format12bitRGB444 = 3;
        public static int COLOR_Format16bitARGB4444 = 4;
        public static int COLOR_Format16bitARGB1555 = 5;
        public static int COLOR_Format16bitRGB565 = 6;
        public static int COLOR_Format16bitBGR565 = 7;
        public static int COLOR_Format18bitRGB666 = 8;
        public static int COLOR_Format18bitARGB1665 = 9;
        public static int COLOR_Format19bitARGB1666 = 10;
        public static int COLOR_Format24bitRGB888 = 11;
        public static int COLOR_Format24bitBGR888 = 12;
        public static int COLOR_Format24bitARGB1887 = 13;
        public static int COLOR_Format25bitARGB1888 = 14;
        public static int COLOR_Format32bitBGRA8888 = 15;
        public static int COLOR_Format32bitARGB8888 = 16;
        public static int COLOR_FormatYUV411Planar = 17;
        public static int COLOR_FormatYUV411PackedPlanar = 18;
        public static int COLOR_FormatYUV420Planar = 19;
        public static int COLOR_FormatYUV420PackedPlanar = 20;
        public static int COLOR_FormatYUV420SemiPlanar = 21;
        public static int COLOR_FormatYUV422Planar = 22;
        public static int COLOR_FormatYUV422PackedPlanar = 23;
        public static int COLOR_FormatYUV422SemiPlanar = 24;
        public static int COLOR_FormatYCbYCr = 25;
        public static int COLOR_FormatYCrYCb = 26;
        public static int COLOR_FormatCbYCrY = 27;
        public static int COLOR_FormatCrYCbY = 28;
        public static int COLOR_FormatYUV444Interleaved = 29;
        public static int COLOR_FormatRawBayer8bit = 30;
        public static int COLOR_FormatRawBayer10bit = 31;
        public static int COLOR_FormatRawBayer8bitcompressed = 32;
        public static int COLOR_FormatL2 = 33;
        public static int COLOR_FormatL4 = 34;
        public static int COLOR_FormatL8 = 35;
        public static int COLOR_FormatL16 = 36;
        public static int COLOR_FormatL24 = 37;
        public static int COLOR_FormatL32 = 38;
        public static int COLOR_FormatYUV420PackedSemiPlanar = 39;
        public static int COLOR_FormatYUV422PackedSemiPlanar = 40;
        public static int COLOR_Format18BitBGR666 = 41;
        public static int COLOR_Format24BitARGB6666 = 42;
        public static int COLOR_Format24BitABGR6666 = 43;
        public static int COLOR_TI_FormatYUV420PackedSemiPlanar = 2130706688;
        public static int COLOR_FormatSurface = 2130708361;
        public static int COLOR_FormatYUV420Flexible = 2135033992;
        public static int COLOR_QCOM_FormatYUV420SemiPlanar = 2141391872;
        public int[] colorFormats;
        private int mFlagsSupported;
        private int mFlagsRequired;
        private int mFlagsVerified;
        public static String FEATURE_AdaptivePlayback = "adaptive-playback";
        public static String FEATURE_SecurePlayback = "secure-playback";
        public static String FEATURE_TunneledPlayback = "tunneled-playback";
        private static Feature[] decoderFeatures;
        int mError;
        private static String TAG = "CodecCapabilities";
        private AudioCapabilities mAudioCaps;
        private VideoCapabilities mVideoCaps;
        private EncoderCapabilities mEncoderCaps;
        private MediaFormat mDefaultFormat;
        private MediaFormat mCapabilitiesInfo;

        private void $$robo$$android_media_MediaCodecInfo_CodecCapabilities$__constructor__() {
        }

        private final boolean $$robo$$android_media_MediaCodecInfo_CodecCapabilities$isFeatureSupported(String name) {
            return this.checkFeature(name, this.mFlagsSupported);
        }

        private final boolean $$robo$$android_media_MediaCodecInfo_CodecCapabilities$isFeatureRequired(String name) {
            return this.checkFeature(name, this.mFlagsRequired);
        }

        private final String[] $$robo$$android_media_MediaCodecInfo_CodecCapabilities$validFeatures() {
            Feature[] features = this.getValidFeatures();
            String[] res = new String[features.length];
            for (int i = 0; i < res.length; ++i) {
                res[i] = features[i].mName;
            }
            return res;
        }

        private final Feature[] $$robo$$android_media_MediaCodecInfo_CodecCapabilities$getValidFeatures() {
            if (!this.isEncoder()) {
                return decoderFeatures;
            }
            return new Feature[0];
        }

        private final boolean $$robo$$android_media_MediaCodecInfo_CodecCapabilities$checkFeature(String name, int flags) {
            for (Feature feat : this.getValidFeatures()) {
                if (!feat.mName.equals(name)) continue;
                return (flags & feat.mValue) != 0;
            }
            return false;
        }

        private final boolean $$robo$$android_media_MediaCodecInfo_CodecCapabilities$isRegular() {
            for (Feature feat : this.getValidFeatures()) {
                if (feat.mDefault || !this.isFeatureRequired(feat.mName)) continue;
                return false;
            }
            return true;
        }

        private final boolean $$robo$$android_media_MediaCodecInfo_CodecCapabilities$isFormatSupported(MediaFormat format) {
            Map<String, Object> map = format.getMap();
            String mime = (String)map.get("mime");
            if (mime != null && !this.mMime.equalsIgnoreCase(mime)) {
                return false;
            }
            for (Feature feat : this.getValidFeatures()) {
                Integer yesNo = (Integer)map.get("feature-" + feat.mName);
                if (yesNo == null || (yesNo != 1 || this.isFeatureSupported(feat.mName)) && (yesNo != 0 || !this.isFeatureRequired(feat.mName))) continue;
                return false;
            }
            if (this.mAudioCaps != null && !this.mAudioCaps.supportsFormat(format)) {
                return false;
            }
            if (this.mVideoCaps != null && !this.mVideoCaps.supportsFormat(format)) {
                return false;
            }
            return this.mEncoderCaps == null || this.mEncoderCaps.supportsFormat(format);
        }

        private final MediaFormat $$robo$$android_media_MediaCodecInfo_CodecCapabilities$getDefaultFormat() {
            return this.mDefaultFormat;
        }

        private final String $$robo$$android_media_MediaCodecInfo_CodecCapabilities$getMimeType() {
            return this.mMime;
        }

        private final boolean $$robo$$android_media_MediaCodecInfo_CodecCapabilities$isAudio() {
            return this.mAudioCaps != null;
        }

        private final AudioCapabilities $$robo$$android_media_MediaCodecInfo_CodecCapabilities$getAudioCapabilities() {
            return this.mAudioCaps;
        }

        private final boolean $$robo$$android_media_MediaCodecInfo_CodecCapabilities$isEncoder() {
            return this.mEncoderCaps != null;
        }

        private final EncoderCapabilities $$robo$$android_media_MediaCodecInfo_CodecCapabilities$getEncoderCapabilities() {
            return this.mEncoderCaps;
        }

        private final boolean $$robo$$android_media_MediaCodecInfo_CodecCapabilities$isVideo() {
            return this.mVideoCaps != null;
        }

        private final VideoCapabilities $$robo$$android_media_MediaCodecInfo_CodecCapabilities$getVideoCapabilities() {
            return this.mVideoCaps;
        }

        private final CodecCapabilities $$robo$$android_media_MediaCodecInfo_CodecCapabilities$dup() {
            return new CodecCapabilities(Arrays.copyOf(this.profileLevels, this.profileLevels.length), Arrays.copyOf(this.colorFormats, this.colorFormats.length), this.isEncoder(), this.mFlagsVerified, this.mDefaultFormat, this.mCapabilitiesInfo);
        }

        private static final CodecCapabilities $$robo$$android_media_MediaCodecInfo_CodecCapabilities$createFromProfileLevel(String mime, int profile, int level) {
            CodecProfileLevel pl = new CodecProfileLevel();
            pl.profile = profile;
            pl.level = level;
            MediaFormat defaultFormat = new MediaFormat();
            defaultFormat.setString("mime", mime);
            CodecCapabilities ret = new CodecCapabilities(new CodecProfileLevel[]{pl}, new int[0], true, 0, defaultFormat, new MediaFormat());
            if (ret.mError != 0) {
                return null;
            }
            return ret;
        }

        private void $$robo$$android_media_MediaCodecInfo_CodecCapabilities$__constructor__(CodecProfileLevel[] profLevs, int[] colFmts, boolean encoder, int flags, Map<String, Object> defaultFormatMap, Map<String, Object> capabilitiesMap) {
        }

        private void $$robo$$android_media_MediaCodecInfo_CodecCapabilities$__constructor__(CodecProfileLevel[] profLevs, int[] colFmts, boolean encoder, int flags, MediaFormat defaultFormat, MediaFormat info) {
            Map<String, Object> map = info.getMap();
            this.profileLevels = profLevs;
            this.colorFormats = colFmts;
            this.mFlagsVerified = flags;
            this.mDefaultFormat = defaultFormat;
            this.mCapabilitiesInfo = info;
            this.mMime = this.mDefaultFormat.getString("mime");
            if (this.mMime.toLowerCase().startsWith("audio/")) {
                this.mAudioCaps = AudioCapabilities.create(info, this);
                this.mAudioCaps.setDefaultFormat(this.mDefaultFormat);
            } else if (this.mMime.toLowerCase().startsWith("video/")) {
                this.mVideoCaps = VideoCapabilities.create(info, this);
            }
            if (encoder) {
                this.mEncoderCaps = EncoderCapabilities.create(info, this);
                this.mEncoderCaps.setDefaultFormat(this.mDefaultFormat);
            }
            for (Feature feat : this.getValidFeatures()) {
                String key = "feature-" + feat.mName;
                Integer yesNo = (Integer)map.get(key);
                if (yesNo == null) continue;
                if (yesNo > 0) {
                    this.mFlagsRequired |= feat.mValue;
                }
                this.mFlagsSupported |= feat.mValue;
                this.mDefaultFormat.setInteger(key, 1);
            }
        }

        static void __staticInitializer__() {
            decoderFeatures = new Feature[]{new Feature("adaptive-playback", 1, true), new Feature("secure-playback", 2, false), new Feature("tunneled-playback", 4, false)};
        }

        private void __constructor__() {
            this.$$robo$$android_media_MediaCodecInfo_CodecCapabilities$__constructor__();
        }

        public CodecCapabilities() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaCodecInfo_CodecCapabilities$__constructor__(), 0, this);
        }

        public boolean isFeatureSupported(String string2) {
            return (boolean)InvokeDynamicSupport.bootstrap("isFeatureSupported", $$robo$$android_media_MediaCodecInfo_CodecCapabilities$isFeatureSupported(java.lang.String ), 0, this, string2);
        }

        public boolean isFeatureRequired(String string2) {
            return (boolean)InvokeDynamicSupport.bootstrap("isFeatureRequired", $$robo$$android_media_MediaCodecInfo_CodecCapabilities$isFeatureRequired(java.lang.String ), 0, this, string2);
        }

        public String[] validFeatures() {
            return InvokeDynamicSupport.bootstrap("validFeatures", $$robo$$android_media_MediaCodecInfo_CodecCapabilities$validFeatures(), 0, this);
        }

        private Feature[] getValidFeatures() {
            return InvokeDynamicSupport.bootstrap("getValidFeatures", $$robo$$android_media_MediaCodecInfo_CodecCapabilities$getValidFeatures(), 0, this);
        }

        private boolean checkFeature(String string2, int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("checkFeature", $$robo$$android_media_MediaCodecInfo_CodecCapabilities$checkFeature(java.lang.String int ), 0, this, string2, n);
        }

        public boolean isRegular() {
            return (boolean)InvokeDynamicSupport.bootstrap("isRegular", $$robo$$android_media_MediaCodecInfo_CodecCapabilities$isRegular(), 0, this);
        }

        public boolean isFormatSupported(MediaFormat mediaFormat) {
            return (boolean)InvokeDynamicSupport.bootstrap("isFormatSupported", $$robo$$android_media_MediaCodecInfo_CodecCapabilities$isFormatSupported(android.media.MediaFormat ), 0, this, mediaFormat);
        }

        public MediaFormat getDefaultFormat() {
            return InvokeDynamicSupport.bootstrap("getDefaultFormat", $$robo$$android_media_MediaCodecInfo_CodecCapabilities$getDefaultFormat(), 0, this);
        }

        public String getMimeType() {
            return InvokeDynamicSupport.bootstrap("getMimeType", $$robo$$android_media_MediaCodecInfo_CodecCapabilities$getMimeType(), 0, this);
        }

        private boolean isAudio() {
            return (boolean)InvokeDynamicSupport.bootstrap("isAudio", $$robo$$android_media_MediaCodecInfo_CodecCapabilities$isAudio(), 0, this);
        }

        public AudioCapabilities getAudioCapabilities() {
            return InvokeDynamicSupport.bootstrap("getAudioCapabilities", $$robo$$android_media_MediaCodecInfo_CodecCapabilities$getAudioCapabilities(), 0, this);
        }

        private boolean isEncoder() {
            return (boolean)InvokeDynamicSupport.bootstrap("isEncoder", $$robo$$android_media_MediaCodecInfo_CodecCapabilities$isEncoder(), 0, this);
        }

        public EncoderCapabilities getEncoderCapabilities() {
            return InvokeDynamicSupport.bootstrap("getEncoderCapabilities", $$robo$$android_media_MediaCodecInfo_CodecCapabilities$getEncoderCapabilities(), 0, this);
        }

        private boolean isVideo() {
            return (boolean)InvokeDynamicSupport.bootstrap("isVideo", $$robo$$android_media_MediaCodecInfo_CodecCapabilities$isVideo(), 0, this);
        }

        public VideoCapabilities getVideoCapabilities() {
            return InvokeDynamicSupport.bootstrap("getVideoCapabilities", $$robo$$android_media_MediaCodecInfo_CodecCapabilities$getVideoCapabilities(), 0, this);
        }

        public CodecCapabilities dup() {
            return InvokeDynamicSupport.bootstrap("dup", $$robo$$android_media_MediaCodecInfo_CodecCapabilities$dup(), 0, this);
        }

        public static CodecCapabilities createFromProfileLevel(String string2, int n, int n2) {
            return InvokeDynamicSupport.bootstrapStatic("createFromProfileLevel", $$robo$$android_media_MediaCodecInfo_CodecCapabilities$createFromProfileLevel(java.lang.String int int ), 0, (String)string2, (int)n, (int)n2);
        }

        private void __constructor__(CodecProfileLevel[] codecProfileLevelArray, int[] nArray, boolean bl, int n, Map<String, Object> map, Map<String, Object> map2) {
            this.$$robo$$android_media_MediaCodecInfo_CodecCapabilities$__constructor__(codecProfileLevelArray, nArray, bl, n, map, map2);
        }

        CodecCapabilities(CodecProfileLevel[] codecProfileLevelArray, int[] nArray, boolean bl, int n, Map<String, Object> map, Map<String, Object> map2) {
            this(codecProfileLevelArray, nArray, bl, n, new MediaFormat(map), new MediaFormat(map2));
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaCodecInfo_CodecCapabilities$__constructor__(android.media.MediaCodecInfo$CodecProfileLevel[] int[] boolean int java.util.Map<java.lang.String, java.lang.Object> java.util.Map<java.lang.String, java.lang.Object> ), 0, this, codecProfileLevelArray, nArray, bl, n, map, map2);
        }

        private void __constructor__(CodecProfileLevel[] codecProfileLevelArray, int[] nArray, boolean bl, int n, MediaFormat mediaFormat, MediaFormat mediaFormat2) {
            this.$$robo$$android_media_MediaCodecInfo_CodecCapabilities$__constructor__(codecProfileLevelArray, nArray, bl, n, mediaFormat, mediaFormat2);
        }

        CodecCapabilities(CodecProfileLevel[] codecProfileLevelArray, int[] nArray, boolean bl, int n, MediaFormat mediaFormat, MediaFormat mediaFormat2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaCodecInfo_CodecCapabilities$__constructor__(android.media.MediaCodecInfo$CodecProfileLevel[] int[] boolean int android.media.MediaFormat android.media.MediaFormat ), 0, this, codecProfileLevelArray, nArray, bl, n, mediaFormat, mediaFormat2);
        }

        static {
            RobolectricInternals.classInitializing(CodecCapabilities.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CodecCapabilities)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class Feature
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public String mName;
        public int mValue;
        public boolean mDefault;

        private void $$robo$$android_media_MediaCodecInfo_Feature$__constructor__(String name, int value, boolean def) {
            this.mName = name;
            this.mValue = value;
            this.mDefault = def;
        }

        private void __constructor__(String string2, int n, boolean bl) {
            this.$$robo$$android_media_MediaCodecInfo_Feature$__constructor__(string2, n, bl);
        }

        public Feature(String string2, int n, boolean bl) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaCodecInfo_Feature$__constructor__(java.lang.String int boolean ), 0, this, string2, n, bl);
        }

        public /* synthetic */ Feature() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Feature)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

