/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.DeniedByServerException;
import android.media.NotProvisionedException;
import android.media.ResourceBusyException;
import android.media.UnsupportedSchemeException;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class MediaDrm
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "MediaDrm";
    private static String PERMISSION = "android.permission.ACCESS_DRM_CERTIFICATES";
    private EventHandler mEventHandler;
    private OnEventListener mOnEventListener;
    private long mNativeContext;
    public static int CERTIFICATE_TYPE_NONE = 0;
    public static int CERTIFICATE_TYPE_X509 = 1;
    public static int EVENT_PROVISION_REQUIRED = 1;
    public static int EVENT_KEY_REQUIRED = 2;
    public static int EVENT_KEY_EXPIRED = 3;
    public static int EVENT_VENDOR_DEFINED = 4;
    private static int DRM_EVENT = 200;
    public static int KEY_TYPE_STREAMING = 1;
    public static int KEY_TYPE_OFFLINE = 2;
    public static int KEY_TYPE_RELEASE = 3;
    public static String PROPERTY_VENDOR = "vendor";
    public static String PROPERTY_VERSION = "version";
    public static String PROPERTY_DESCRIPTION = "description";
    public static String PROPERTY_ALGORITHMS = "algorithms";
    public static String PROPERTY_DEVICE_UNIQUE_ID = "deviceUniqueId";

    private static final boolean $$robo$$android_media_MediaDrm$isCryptoSchemeSupported(UUID uuid) {
        return MediaDrm.isCryptoSchemeSupportedNative(MediaDrm.getByteArrayFromUUID(uuid), null);
    }

    private static final boolean $$robo$$android_media_MediaDrm$isCryptoSchemeSupported(UUID uuid, String mimeType) {
        return MediaDrm.isCryptoSchemeSupportedNative(MediaDrm.getByteArrayFromUUID(uuid), mimeType);
    }

    private static final byte[] $$robo$$android_media_MediaDrm$getByteArrayFromUUID(UUID uuid) {
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        byte[] uuidBytes = new byte[16];
        for (int i = 0; i < 8; ++i) {
            uuidBytes[i] = (byte)(msb >>> 8 * (7 - i));
            uuidBytes[8 + i] = (byte)(lsb >>> 8 * (7 - i));
        }
        return uuidBytes;
    }

    private static final boolean $$robo$$android_media_MediaDrm$isCryptoSchemeSupportedNative(byte[] byArray, String string2) {
        return false;
    }

    private void $$robo$$android_media_MediaDrm$__constructor__(UUID uuid) throws UnsupportedSchemeException {
        Looper looper = Looper.myLooper();
        this.mEventHandler = looper != null ? new EventHandler(this, this, looper) : ((looper = Looper.getMainLooper()) != null ? new EventHandler(this, this, looper) : null);
        this.native_setup(new WeakReference<MediaDrm>(this), MediaDrm.getByteArrayFromUUID(uuid));
    }

    private final void $$robo$$android_media_MediaDrm$setOnEventListener(OnEventListener listener) {
        this.mOnEventListener = listener;
    }

    private static final void $$robo$$android_media_MediaDrm$postEventFromNative(Object mediadrm_ref, int eventType, int extra, Object obj) {
        MediaDrm md = (MediaDrm)((WeakReference)mediadrm_ref).get();
        if (md == null) {
            return;
        }
        if (md.mEventHandler != null) {
            Message m = md.mEventHandler.obtainMessage(200, eventType, extra, obj);
            md.mEventHandler.sendMessage(m);
        }
    }

    private final byte[] $$robo$$android_media_MediaDrm$openSession() throws NotProvisionedException, ResourceBusyException {
        return null;
    }

    private final void $$robo$$android_media_MediaDrm$closeSession(byte[] byArray) {
    }

    private final KeyRequest $$robo$$android_media_MediaDrm$getKeyRequest(byte[] byArray, byte[] byArray2, String string2, int n, HashMap<String, String> hashMap) throws NotProvisionedException {
        return null;
    }

    private final byte[] $$robo$$android_media_MediaDrm$provideKeyResponse(byte[] byArray, byte[] byArray2) throws NotProvisionedException, DeniedByServerException {
        return null;
    }

    private final void $$robo$$android_media_MediaDrm$restoreKeys(byte[] byArray, byte[] byArray2) {
    }

    private final void $$robo$$android_media_MediaDrm$removeKeys(byte[] byArray) {
    }

    private final HashMap<String, String> $$robo$$android_media_MediaDrm$queryKeyStatus(byte[] byArray) {
        return null;
    }

    private final ProvisionRequest $$robo$$android_media_MediaDrm$getProvisionRequest() {
        return this.getProvisionRequestNative(0, "");
    }

    private final ProvisionRequest $$robo$$android_media_MediaDrm$getProvisionRequestNative(int n, String string2) {
        return null;
    }

    private final void $$robo$$android_media_MediaDrm$provideProvisionResponse(byte[] response) throws DeniedByServerException {
        this.provideProvisionResponseNative(response);
    }

    private final Certificate $$robo$$android_media_MediaDrm$provideProvisionResponseNative(byte[] byArray) throws DeniedByServerException {
        return null;
    }

    private final void $$robo$$android_media_MediaDrm$unprovisionDevice() {
    }

    private final List<byte[]> $$robo$$android_media_MediaDrm$getSecureStops() {
        return null;
    }

    private final void $$robo$$android_media_MediaDrm$releaseSecureStops(byte[] byArray) {
    }

    private final String $$robo$$android_media_MediaDrm$getPropertyString(String string2) {
        return null;
    }

    private final byte[] $$robo$$android_media_MediaDrm$getPropertyByteArray(String string2) {
        return null;
    }

    private final void $$robo$$android_media_MediaDrm$setPropertyString(String string2, String string3) {
    }

    private final void $$robo$$android_media_MediaDrm$setPropertyByteArray(String string2, byte[] byArray) {
    }

    private static final void $$robo$$android_media_MediaDrm$setCipherAlgorithmNative(MediaDrm mediaDrm, byte[] byArray, String string2) {
    }

    private static final void $$robo$$android_media_MediaDrm$setMacAlgorithmNative(MediaDrm mediaDrm, byte[] byArray, String string2) {
    }

    private static final byte[] $$robo$$android_media_MediaDrm$encryptNative(MediaDrm mediaDrm, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        return null;
    }

    private static final byte[] $$robo$$android_media_MediaDrm$decryptNative(MediaDrm mediaDrm, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        return null;
    }

    private static final byte[] $$robo$$android_media_MediaDrm$signNative(MediaDrm mediaDrm, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return null;
    }

    private static final boolean $$robo$$android_media_MediaDrm$verifyNative(MediaDrm mediaDrm, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        return false;
    }

    private final CryptoSession $$robo$$android_media_MediaDrm$getCryptoSession(byte[] sessionId, String cipherAlgorithm, String macAlgorithm) {
        return new CryptoSession(this, this, sessionId, cipherAlgorithm, macAlgorithm);
    }

    private final CertificateRequest $$robo$$android_media_MediaDrm$getCertificateRequest(int certType, String certAuthority) {
        ProvisionRequest provisionRequest = this.getProvisionRequestNative(certType, certAuthority);
        return new CertificateRequest(provisionRequest.getData(), provisionRequest.getDefaultUrl());
    }

    private final Certificate $$robo$$android_media_MediaDrm$provideCertificateResponse(byte[] response) throws DeniedByServerException {
        return this.provideProvisionResponseNative(response);
    }

    private static final byte[] $$robo$$android_media_MediaDrm$signRSANative(MediaDrm mediaDrm, byte[] byArray, String string2, byte[] byArray2, byte[] byArray3) {
        return null;
    }

    private final byte[] $$robo$$android_media_MediaDrm$signRSA(byte[] sessionId, String algorithm, byte[] wrappedKey, byte[] message) {
        return MediaDrm.signRSANative(this, sessionId, algorithm, wrappedKey, message);
    }

    private final void $$robo$$android_media_MediaDrm$finalize() {
        this.native_finalize();
    }

    private final void $$robo$$android_media_MediaDrm$release() {
    }

    private static final void $$robo$$android_media_MediaDrm$native_init() {
    }

    private final void $$robo$$android_media_MediaDrm$native_setup(Object object, byte[] byArray) {
    }

    private final void $$robo$$android_media_MediaDrm$native_finalize() {
    }

    static void __staticInitializer__() {
        InvokeDynamicSupport.bootstrapIntrinsic("loadLibrary", "java.lang.System", (String)"media_jni");
        MediaDrm.native_init();
    }

    public static boolean isCryptoSchemeSupported(UUID uUID) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isCryptoSchemeSupported", $$robo$$android_media_MediaDrm$isCryptoSchemeSupported(java.util.UUID ), 0, (UUID)uUID);
    }

    public static boolean isCryptoSchemeSupported(UUID uUID, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isCryptoSchemeSupported", $$robo$$android_media_MediaDrm$isCryptoSchemeSupported(java.util.UUID java.lang.String ), 0, (UUID)uUID, (String)string2);
    }

    private static byte[] getByteArrayFromUUID(UUID uUID) {
        return InvokeDynamicSupport.bootstrapStatic("getByteArrayFromUUID", $$robo$$android_media_MediaDrm$getByteArrayFromUUID(java.util.UUID ), 0, (UUID)uUID);
    }

    private static final native /* synthetic */ boolean $$robo$$isCryptoSchemeSupportedNative$nativeBinding(byte[] var0, String var1);

    private static boolean isCryptoSchemeSupportedNative(byte[] byArray, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isCryptoSchemeSupportedNative", $$robo$$android_media_MediaDrm$isCryptoSchemeSupportedNative(byte[] java.lang.String ), 1, (byte[])byArray, (String)string2);
    }

    private void __constructor__(UUID uUID) throws UnsupportedSchemeException {
        this.$$robo$$android_media_MediaDrm$__constructor__(uUID);
    }

    public MediaDrm(UUID uUID) throws UnsupportedSchemeException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaDrm$__constructor__(java.util.UUID ), 0, this, uUID);
    }

    public void setOnEventListener(OnEventListener onEventListener) {
        InvokeDynamicSupport.bootstrap("setOnEventListener", $$robo$$android_media_MediaDrm$setOnEventListener(android.media.MediaDrm$OnEventListener ), 0, this, onEventListener);
    }

    private static void postEventFromNative(Object object, int n, int n2, Object object2) {
        InvokeDynamicSupport.bootstrapStatic("postEventFromNative", $$robo$$android_media_MediaDrm$postEventFromNative(java.lang.Object int int java.lang.Object ), 0, (Object)object, (int)n, (int)n2, (Object)object2);
    }

    private final native /* synthetic */ byte[] $$robo$$openSession$nativeBinding() throws NotProvisionedException, ResourceBusyException;

    public byte[] openSession() throws NotProvisionedException, ResourceBusyException {
        return InvokeDynamicSupport.bootstrap("openSession", $$robo$$android_media_MediaDrm$openSession(), 1, this);
    }

    private final native /* synthetic */ void $$robo$$closeSession$nativeBinding(byte[] var1);

    public void closeSession(byte[] byArray) {
        InvokeDynamicSupport.bootstrap("closeSession", $$robo$$android_media_MediaDrm$closeSession(byte[] ), 1, this, byArray);
    }

    private final native /* synthetic */ KeyRequest $$robo$$getKeyRequest$nativeBinding(byte[] var1, byte[] var2, String var3, int var4, HashMap<String, String> var5) throws NotProvisionedException;

    public KeyRequest getKeyRequest(byte[] byArray, byte[] byArray2, String string2, int n, HashMap<String, String> hashMap) throws NotProvisionedException {
        return InvokeDynamicSupport.bootstrap("getKeyRequest", $$robo$$android_media_MediaDrm$getKeyRequest(byte[] byte[] java.lang.String int java.util.HashMap<java.lang.String, java.lang.String> ), 1, this, byArray, byArray2, string2, n, hashMap);
    }

    private final native /* synthetic */ byte[] $$robo$$provideKeyResponse$nativeBinding(byte[] var1, byte[] var2) throws NotProvisionedException, DeniedByServerException;

    public byte[] provideKeyResponse(byte[] byArray, byte[] byArray2) throws NotProvisionedException, DeniedByServerException {
        return InvokeDynamicSupport.bootstrap("provideKeyResponse", $$robo$$android_media_MediaDrm$provideKeyResponse(byte[] byte[] ), 1, this, byArray, byArray2);
    }

    private final native /* synthetic */ void $$robo$$restoreKeys$nativeBinding(byte[] var1, byte[] var2);

    public void restoreKeys(byte[] byArray, byte[] byArray2) {
        InvokeDynamicSupport.bootstrap("restoreKeys", $$robo$$android_media_MediaDrm$restoreKeys(byte[] byte[] ), 1, this, byArray, byArray2);
    }

    private final native /* synthetic */ void $$robo$$removeKeys$nativeBinding(byte[] var1);

    public void removeKeys(byte[] byArray) {
        InvokeDynamicSupport.bootstrap("removeKeys", $$robo$$android_media_MediaDrm$removeKeys(byte[] ), 1, this, byArray);
    }

    private final native /* synthetic */ HashMap<String, String> $$robo$$queryKeyStatus$nativeBinding(byte[] var1);

    public HashMap<String, String> queryKeyStatus(byte[] byArray) {
        return InvokeDynamicSupport.bootstrap("queryKeyStatus", $$robo$$android_media_MediaDrm$queryKeyStatus(byte[] ), 1, this, byArray);
    }

    public ProvisionRequest getProvisionRequest() {
        return InvokeDynamicSupport.bootstrap("getProvisionRequest", $$robo$$android_media_MediaDrm$getProvisionRequest(), 0, this);
    }

    private final native /* synthetic */ ProvisionRequest $$robo$$getProvisionRequestNative$nativeBinding(int var1, String var2);

    private ProvisionRequest getProvisionRequestNative(int n, String string2) {
        return InvokeDynamicSupport.bootstrap("getProvisionRequestNative", $$robo$$android_media_MediaDrm$getProvisionRequestNative(int java.lang.String ), 1, this, n, string2);
    }

    public void provideProvisionResponse(byte[] byArray) throws DeniedByServerException {
        InvokeDynamicSupport.bootstrap("provideProvisionResponse", $$robo$$android_media_MediaDrm$provideProvisionResponse(byte[] ), 0, this, byArray);
    }

    private final native /* synthetic */ Certificate $$robo$$provideProvisionResponseNative$nativeBinding(byte[] var1) throws DeniedByServerException;

    private Certificate provideProvisionResponseNative(byte[] byArray) throws DeniedByServerException {
        return InvokeDynamicSupport.bootstrap("provideProvisionResponseNative", $$robo$$android_media_MediaDrm$provideProvisionResponseNative(byte[] ), 1, this, byArray);
    }

    private final native /* synthetic */ void $$robo$$unprovisionDevice$nativeBinding();

    public void unprovisionDevice() {
        InvokeDynamicSupport.bootstrap("unprovisionDevice", $$robo$$android_media_MediaDrm$unprovisionDevice(), 1, this);
    }

    private final native /* synthetic */ List<byte[]> $$robo$$getSecureStops$nativeBinding();

    public List<byte[]> getSecureStops() {
        return InvokeDynamicSupport.bootstrap("getSecureStops", $$robo$$android_media_MediaDrm$getSecureStops(), 1, this);
    }

    private final native /* synthetic */ void $$robo$$releaseSecureStops$nativeBinding(byte[] var1);

    public void releaseSecureStops(byte[] byArray) {
        InvokeDynamicSupport.bootstrap("releaseSecureStops", $$robo$$android_media_MediaDrm$releaseSecureStops(byte[] ), 1, this, byArray);
    }

    private final native /* synthetic */ String $$robo$$getPropertyString$nativeBinding(String var1);

    public String getPropertyString(String string2) {
        return InvokeDynamicSupport.bootstrap("getPropertyString", $$robo$$android_media_MediaDrm$getPropertyString(java.lang.String ), 1, this, string2);
    }

    private final native /* synthetic */ byte[] $$robo$$getPropertyByteArray$nativeBinding(String var1);

    public byte[] getPropertyByteArray(String string2) {
        return InvokeDynamicSupport.bootstrap("getPropertyByteArray", $$robo$$android_media_MediaDrm$getPropertyByteArray(java.lang.String ), 1, this, string2);
    }

    private final native /* synthetic */ void $$robo$$setPropertyString$nativeBinding(String var1, String var2);

    public void setPropertyString(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("setPropertyString", $$robo$$android_media_MediaDrm$setPropertyString(java.lang.String java.lang.String ), 1, this, string2, string3);
    }

    private final native /* synthetic */ void $$robo$$setPropertyByteArray$nativeBinding(String var1, byte[] var2);

    public void setPropertyByteArray(String string2, byte[] byArray) {
        InvokeDynamicSupport.bootstrap("setPropertyByteArray", $$robo$$android_media_MediaDrm$setPropertyByteArray(java.lang.String byte[] ), 1, this, string2, byArray);
    }

    private static final native /* synthetic */ void $$robo$$setCipherAlgorithmNative$nativeBinding(MediaDrm var0, byte[] var1, String var2);

    private static void setCipherAlgorithmNative(MediaDrm mediaDrm, byte[] byArray, String string2) {
        InvokeDynamicSupport.bootstrapStatic("setCipherAlgorithmNative", $$robo$$android_media_MediaDrm$setCipherAlgorithmNative(android.media.MediaDrm byte[] java.lang.String ), 1, (MediaDrm)mediaDrm, (byte[])byArray, (String)string2);
    }

    private static final native /* synthetic */ void $$robo$$setMacAlgorithmNative$nativeBinding(MediaDrm var0, byte[] var1, String var2);

    private static void setMacAlgorithmNative(MediaDrm mediaDrm, byte[] byArray, String string2) {
        InvokeDynamicSupport.bootstrapStatic("setMacAlgorithmNative", $$robo$$android_media_MediaDrm$setMacAlgorithmNative(android.media.MediaDrm byte[] java.lang.String ), 1, (MediaDrm)mediaDrm, (byte[])byArray, (String)string2);
    }

    private static final native /* synthetic */ byte[] $$robo$$encryptNative$nativeBinding(MediaDrm var0, byte[] var1, byte[] var2, byte[] var3, byte[] var4);

    private static byte[] encryptNative(MediaDrm mediaDrm, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        return InvokeDynamicSupport.bootstrapStatic("encryptNative", $$robo$$android_media_MediaDrm$encryptNative(android.media.MediaDrm byte[] byte[] byte[] byte[] ), 1, (MediaDrm)mediaDrm, (byte[])byArray, (byte[])byArray2, (byte[])byArray3, (byte[])byArray4);
    }

    private static final native /* synthetic */ byte[] $$robo$$decryptNative$nativeBinding(MediaDrm var0, byte[] var1, byte[] var2, byte[] var3, byte[] var4);

    private static byte[] decryptNative(MediaDrm mediaDrm, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        return InvokeDynamicSupport.bootstrapStatic("decryptNative", $$robo$$android_media_MediaDrm$decryptNative(android.media.MediaDrm byte[] byte[] byte[] byte[] ), 1, (MediaDrm)mediaDrm, (byte[])byArray, (byte[])byArray2, (byte[])byArray3, (byte[])byArray4);
    }

    private static final native /* synthetic */ byte[] $$robo$$signNative$nativeBinding(MediaDrm var0, byte[] var1, byte[] var2, byte[] var3);

    private static byte[] signNative(MediaDrm mediaDrm, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return InvokeDynamicSupport.bootstrapStatic("signNative", $$robo$$android_media_MediaDrm$signNative(android.media.MediaDrm byte[] byte[] byte[] ), 1, (MediaDrm)mediaDrm, (byte[])byArray, (byte[])byArray2, (byte[])byArray3);
    }

    private static final native /* synthetic */ boolean $$robo$$verifyNative$nativeBinding(MediaDrm var0, byte[] var1, byte[] var2, byte[] var3, byte[] var4);

    private static boolean verifyNative(MediaDrm mediaDrm, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("verifyNative", $$robo$$android_media_MediaDrm$verifyNative(android.media.MediaDrm byte[] byte[] byte[] byte[] ), 1, (MediaDrm)mediaDrm, (byte[])byArray, (byte[])byArray2, (byte[])byArray3, (byte[])byArray4);
    }

    public CryptoSession getCryptoSession(byte[] byArray, String string2, String string3) {
        return InvokeDynamicSupport.bootstrap("getCryptoSession", $$robo$$android_media_MediaDrm$getCryptoSession(byte[] java.lang.String java.lang.String ), 0, this, byArray, string2, string3);
    }

    public CertificateRequest getCertificateRequest(int n, String string2) {
        return InvokeDynamicSupport.bootstrap("getCertificateRequest", $$robo$$android_media_MediaDrm$getCertificateRequest(int java.lang.String ), 0, this, n, string2);
    }

    public Certificate provideCertificateResponse(byte[] byArray) throws DeniedByServerException {
        return InvokeDynamicSupport.bootstrap("provideCertificateResponse", $$robo$$android_media_MediaDrm$provideCertificateResponse(byte[] ), 0, this, byArray);
    }

    private static final native /* synthetic */ byte[] $$robo$$signRSANative$nativeBinding(MediaDrm var0, byte[] var1, String var2, byte[] var3, byte[] var4);

    private static byte[] signRSANative(MediaDrm mediaDrm, byte[] byArray, String string2, byte[] byArray2, byte[] byArray3) {
        return InvokeDynamicSupport.bootstrapStatic("signRSANative", $$robo$$android_media_MediaDrm$signRSANative(android.media.MediaDrm byte[] java.lang.String byte[] byte[] ), 1, (MediaDrm)mediaDrm, (byte[])byArray, (String)string2, (byte[])byArray2, (byte[])byArray3);
    }

    public byte[] signRSA(byte[] byArray, String string2, byte[] byArray2, byte[] byArray3) {
        return InvokeDynamicSupport.bootstrap("signRSA", $$robo$$android_media_MediaDrm$signRSA(byte[] java.lang.String byte[] byte[] ), 0, this, byArray, string2, byArray2, byArray3);
    }

    protected void finalize() {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_media_MediaDrm$finalize(), 0, this);
    }

    private final native /* synthetic */ void $$robo$$release$nativeBinding();

    public void release() {
        InvokeDynamicSupport.bootstrap("release", $$robo$$android_media_MediaDrm$release(), 1, this);
    }

    private static final native /* synthetic */ void $$robo$$native_init$nativeBinding();

    private static void native_init() {
        InvokeDynamicSupport.bootstrapStatic("native_init", $$robo$$android_media_MediaDrm$native_init(), 1);
    }

    private final native /* synthetic */ void $$robo$$native_setup$nativeBinding(Object var1, byte[] var2);

    private void native_setup(Object object, byte[] byArray) {
        InvokeDynamicSupport.bootstrap("native_setup", $$robo$$android_media_MediaDrm$native_setup(java.lang.Object byte[] ), 1, this, object, byArray);
    }

    private final native /* synthetic */ void $$robo$$native_finalize$nativeBinding();

    private void native_finalize() {
        InvokeDynamicSupport.bootstrap("native_finalize", $$robo$$android_media_MediaDrm$native_finalize(), 1, this);
    }

    static {
        RobolectricInternals.classInitializing(MediaDrm.class);
    }

    public /* synthetic */ MediaDrm() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MediaDrm)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Certificate
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private byte[] mWrappedKey;
        private byte[] mCertificateData;

        private void $$robo$$android_media_MediaDrm_Certificate$__constructor__() {
        }

        private final byte[] $$robo$$android_media_MediaDrm_Certificate$getWrappedPrivateKey() {
            return this.mWrappedKey;
        }

        private final byte[] $$robo$$android_media_MediaDrm_Certificate$getContent() {
            return this.mCertificateData;
        }

        private void __constructor__() {
            this.$$robo$$android_media_MediaDrm_Certificate$__constructor__();
        }

        Certificate() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaDrm_Certificate$__constructor__(), 0, this);
        }

        public byte[] getWrappedPrivateKey() {
            return InvokeDynamicSupport.bootstrap("getWrappedPrivateKey", $$robo$$android_media_MediaDrm_Certificate$getWrappedPrivateKey(), 0, this);
        }

        public byte[] getContent() {
            return InvokeDynamicSupport.bootstrap("getContent", $$robo$$android_media_MediaDrm_Certificate$getContent(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Certificate)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class CertificateRequest
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private byte[] mData;
        private String mDefaultUrl;

        private void $$robo$$android_media_MediaDrm_CertificateRequest$__constructor__(byte[] data, String defaultUrl) {
            this.mData = data;
            this.mDefaultUrl = defaultUrl;
        }

        private final byte[] $$robo$$android_media_MediaDrm_CertificateRequest$getData() {
            return this.mData;
        }

        private final String $$robo$$android_media_MediaDrm_CertificateRequest$getDefaultUrl() {
            return this.mDefaultUrl;
        }

        private void __constructor__(byte[] byArray, String string2) {
            this.$$robo$$android_media_MediaDrm_CertificateRequest$__constructor__(byArray, string2);
        }

        CertificateRequest(byte[] byArray, String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaDrm_CertificateRequest$__constructor__(byte[] java.lang.String ), 0, this, byArray, string2);
        }

        public byte[] getData() {
            return InvokeDynamicSupport.bootstrap("getData", $$robo$$android_media_MediaDrm_CertificateRequest$getData(), 0, this);
        }

        public String getDefaultUrl() {
            return InvokeDynamicSupport.bootstrap("getDefaultUrl", $$robo$$android_media_MediaDrm_CertificateRequest$getDefaultUrl(), 0, this);
        }

        public /* synthetic */ CertificateRequest() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CertificateRequest)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public final class CryptoSession
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private MediaDrm mDrm;
        private byte[] mSessionId;
        /* synthetic */ MediaDrm this$0;

        private void $$robo$$android_media_MediaDrm_CryptoSession$__constructor__(MediaDrm mediaDrm, MediaDrm drm, byte[] sessionId, String cipherAlgorithm, String macAlgorithm) {
            this.mSessionId = sessionId;
            this.mDrm = drm;
            MediaDrm.setCipherAlgorithmNative(drm, sessionId, cipherAlgorithm);
            MediaDrm.setMacAlgorithmNative(drm, sessionId, macAlgorithm);
        }

        private final byte[] $$robo$$android_media_MediaDrm_CryptoSession$encrypt(byte[] keyid, byte[] input, byte[] iv) {
            return MediaDrm.encryptNative(this.mDrm, this.mSessionId, keyid, input, iv);
        }

        private final byte[] $$robo$$android_media_MediaDrm_CryptoSession$decrypt(byte[] keyid, byte[] input, byte[] iv) {
            return MediaDrm.decryptNative(this.mDrm, this.mSessionId, keyid, input, iv);
        }

        private final byte[] $$robo$$android_media_MediaDrm_CryptoSession$sign(byte[] keyid, byte[] message) {
            return MediaDrm.signNative(this.mDrm, this.mSessionId, keyid, message);
        }

        private final boolean $$robo$$android_media_MediaDrm_CryptoSession$verify(byte[] keyid, byte[] message, byte[] signature) {
            return MediaDrm.verifyNative(this.mDrm, this.mSessionId, keyid, message, signature);
        }

        private void __constructor__(MediaDrm mediaDrm, MediaDrm mediaDrm2, byte[] byArray, String string2, String string3) {
            this.$$robo$$android_media_MediaDrm_CryptoSession$__constructor__(mediaDrm, mediaDrm2, byArray, string2, string3);
        }

        CryptoSession(MediaDrm mediaDrm, MediaDrm mediaDrm2, byte[] byArray, String string2, String string3) {
            this.this$0 = mediaDrm;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaDrm_CryptoSession$__constructor__(android.media.MediaDrm android.media.MediaDrm byte[] java.lang.String java.lang.String ), 0, this, mediaDrm, mediaDrm2, byArray, string2, string3);
        }

        public byte[] encrypt(byte[] byArray, byte[] byArray2, byte[] byArray3) {
            return InvokeDynamicSupport.bootstrap("encrypt", $$robo$$android_media_MediaDrm_CryptoSession$encrypt(byte[] byte[] byte[] ), 0, this, byArray, byArray2, byArray3);
        }

        public byte[] decrypt(byte[] byArray, byte[] byArray2, byte[] byArray3) {
            return InvokeDynamicSupport.bootstrap("decrypt", $$robo$$android_media_MediaDrm_CryptoSession$decrypt(byte[] byte[] byte[] ), 0, this, byArray, byArray2, byArray3);
        }

        public byte[] sign(byte[] byArray, byte[] byArray2) {
            return InvokeDynamicSupport.bootstrap("sign", $$robo$$android_media_MediaDrm_CryptoSession$sign(byte[] byte[] ), 0, this, byArray, byArray2);
        }

        public boolean verify(byte[] byArray, byte[] byArray2, byte[] byArray3) {
            return (boolean)InvokeDynamicSupport.bootstrap("verify", $$robo$$android_media_MediaDrm_CryptoSession$verify(byte[] byte[] byte[] ), 0, this, byArray, byArray2, byArray3);
        }

        public /* synthetic */ CryptoSession() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CryptoSession)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class ProvisionRequest
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private byte[] mData;
        private String mDefaultUrl;

        private void $$robo$$android_media_MediaDrm_ProvisionRequest$__constructor__() {
        }

        private final byte[] $$robo$$android_media_MediaDrm_ProvisionRequest$getData() {
            return this.mData;
        }

        private final String $$robo$$android_media_MediaDrm_ProvisionRequest$getDefaultUrl() {
            return this.mDefaultUrl;
        }

        private void __constructor__() {
            this.$$robo$$android_media_MediaDrm_ProvisionRequest$__constructor__();
        }

        ProvisionRequest() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaDrm_ProvisionRequest$__constructor__(), 0, this);
        }

        public byte[] getData() {
            return InvokeDynamicSupport.bootstrap("getData", $$robo$$android_media_MediaDrm_ProvisionRequest$getData(), 0, this);
        }

        public String getDefaultUrl() {
            return InvokeDynamicSupport.bootstrap("getDefaultUrl", $$robo$$android_media_MediaDrm_ProvisionRequest$getDefaultUrl(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ProvisionRequest)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class KeyRequest
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private byte[] mData;
        private String mDefaultUrl;

        private void $$robo$$android_media_MediaDrm_KeyRequest$__constructor__() {
        }

        private final byte[] $$robo$$android_media_MediaDrm_KeyRequest$getData() {
            return this.mData;
        }

        private final String $$robo$$android_media_MediaDrm_KeyRequest$getDefaultUrl() {
            return this.mDefaultUrl;
        }

        private void __constructor__() {
            this.$$robo$$android_media_MediaDrm_KeyRequest$__constructor__();
        }

        KeyRequest() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaDrm_KeyRequest$__constructor__(), 0, this);
        }

        public byte[] getData() {
            return InvokeDynamicSupport.bootstrap("getData", $$robo$$android_media_MediaDrm_KeyRequest$getData(), 0, this);
        }

        public String getDefaultUrl() {
            return InvokeDynamicSupport.bootstrap("getDefaultUrl", $$robo$$android_media_MediaDrm_KeyRequest$getDefaultUrl(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (KeyRequest)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class EventHandler
    extends Handler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private MediaDrm mMediaDrm;
        /* synthetic */ MediaDrm this$0;

        private void $$robo$$android_media_MediaDrm_EventHandler$__constructor__(MediaDrm mediaDrm, MediaDrm md, Looper looper) {
            this.mMediaDrm = md;
        }

        private final void $$robo$$android_media_MediaDrm_EventHandler$handleMessage(Message msg) {
            if (this.mMediaDrm.mNativeContext == 0L) {
                Log.w("MediaDrm", "MediaDrm went away with unhandled events");
                return;
            }
            switch (msg.what) {
                case 200: {
                    Log.i("MediaDrm", "Drm event (" + msg.arg1 + "," + msg.arg2 + ")");
                    if (this.this$0.mOnEventListener != null && msg.obj != null && msg.obj instanceof Parcel) {
                        byte[] data;
                        Parcel parcel = (Parcel)msg.obj;
                        byte[] sessionId = parcel.createByteArray();
                        if (sessionId.length == 0) {
                            sessionId = null;
                        }
                        if ((data = parcel.createByteArray()).length == 0) {
                            data = null;
                        }
                        this.this$0.mOnEventListener.onEvent(this.mMediaDrm, sessionId, msg.arg1, msg.arg2, data);
                    }
                    return;
                }
            }
            Log.e("MediaDrm", "Unknown message type " + msg.what);
        }

        private void __constructor__(MediaDrm mediaDrm, MediaDrm mediaDrm2, Looper looper) {
            this.$$robo$$android_media_MediaDrm_EventHandler$__constructor__(mediaDrm, mediaDrm2, looper);
        }

        public EventHandler(MediaDrm mediaDrm, MediaDrm mediaDrm2, Looper looper) {
            this.this$0 = mediaDrm;
            super(looper);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaDrm_EventHandler$__constructor__(android.media.MediaDrm android.media.MediaDrm android.os.Looper ), 0, this, mediaDrm, mediaDrm2, looper);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_media_MediaDrm_EventHandler$handleMessage(android.os.Message ), 0, this, message);
        }

        public /* synthetic */ EventHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EventHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface OnEventListener
    extends InstrumentedInterface {
        public void onEvent(MediaDrm var1, byte[] var2, int var3, int var4, byte[] var5);
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class MediaDrmStateException
    extends IllegalStateException
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mErrorCode;
        private String mDiagnosticInfo;

        private void $$robo$$android_media_MediaDrm_MediaDrmStateException$__constructor__(int errorCode, String detailMessage) {
            this.mErrorCode = errorCode;
            String sign = errorCode < 0 ? "neg_" : "";
            this.mDiagnosticInfo = "android.media.MediaDrm.error_" + sign + Math.abs(errorCode);
        }

        private final int $$robo$$android_media_MediaDrm_MediaDrmStateException$getErrorCode() {
            return this.mErrorCode;
        }

        private final String $$robo$$android_media_MediaDrm_MediaDrmStateException$getDiagnosticInfo() {
            return this.mDiagnosticInfo;
        }

        private void __constructor__(int n, String string2) {
            this.$$robo$$android_media_MediaDrm_MediaDrmStateException$__constructor__(n, string2);
        }

        public MediaDrmStateException(int n, String string2) {
            super(string2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaDrm_MediaDrmStateException$__constructor__(int java.lang.String ), 0, this, n, string2);
        }

        public int getErrorCode() {
            return (int)InvokeDynamicSupport.bootstrap("getErrorCode", $$robo$$android_media_MediaDrm_MediaDrmStateException$getErrorCode(), 0, this);
        }

        public String getDiagnosticInfo() {
            return InvokeDynamicSupport.bootstrap("getDiagnosticInfo", $$robo$$android_media_MediaDrm_MediaDrmStateException$getDiagnosticInfo(), 0, this);
        }

        public /* synthetic */ MediaDrmStateException() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MediaDrmStateException)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

