/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.media.DataSource;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.media.MediaHTTPService;
import android.net.Uri;
import android.os.IBinder;
import com.google.errorprone.annotations.DoNotMock;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class MediaExtractor
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int SEEK_TO_PREVIOUS_SYNC = 0;
    public static int SEEK_TO_NEXT_SYNC = 1;
    public static int SEEK_TO_CLOSEST_SYNC = 2;
    public static int SAMPLE_FLAG_SYNC = 1;
    public static int SAMPLE_FLAG_ENCRYPTED = 2;
    private long mNativeContext;

    private void $$robo$$android_media_MediaExtractor$__constructor__() {
        this.native_setup();
    }

    private final void $$robo$$android_media_MediaExtractor$setDataSource(DataSource dataSource) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaExtractor$setDataSource(Context context, Uri uri, Map<String, String> headers) throws IOException {
        String scheme = uri.getScheme();
        if (scheme == null || scheme.equals("file")) {
            this.setDataSource(uri.getPath());
            return;
        }
        try (AssetFileDescriptor fd = null;){
            ContentResolver resolver = context.getContentResolver();
            fd = resolver.openAssetFileDescriptor(uri, "r");
            if (fd == null) {
                return;
            }
            if (fd.getDeclaredLength() < 0L) {
                this.setDataSource(fd.getFileDescriptor());
            } else {
                this.setDataSource(fd.getFileDescriptor(), fd.getStartOffset(), fd.getDeclaredLength());
            }
            return;
        }
        this.setDataSource(uri.toString(), headers);
    }

    private final void $$robo$$android_media_MediaExtractor$setDataSource(String path, Map<String, String> headers) throws IOException {
        String[] keys = null;
        String[] values = null;
        if (headers != null) {
            keys = new String[headers.size()];
            values = new String[headers.size()];
            int i = 0;
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                keys[i] = entry.getKey();
                values[i] = entry.getValue();
                ++i;
            }
        }
        this.nativeSetDataSource(MediaHTTPService.createHttpServiceBinderIfNecessary(path), path, keys, values);
    }

    private final void $$robo$$android_media_MediaExtractor$nativeSetDataSource(IBinder iBinder, String string2, String[] stringArray, String[] stringArray2) throws IOException {
    }

    private final void $$robo$$android_media_MediaExtractor$setDataSource(String path) throws IOException {
        this.nativeSetDataSource(MediaHTTPService.createHttpServiceBinderIfNecessary(path), path, null, null);
    }

    private final void $$robo$$android_media_MediaExtractor$setDataSource(FileDescriptor fd) throws IOException {
        this.setDataSource(fd, 0L, 0x7FFFFFFFFFFFFFFL);
    }

    private final void $$robo$$android_media_MediaExtractor$setDataSource(FileDescriptor fileDescriptor, long l, long l2) throws IOException {
    }

    private final void $$robo$$android_media_MediaExtractor$finalize() {
        this.native_finalize();
    }

    private final void $$robo$$android_media_MediaExtractor$release() {
    }

    private final int $$robo$$android_media_MediaExtractor$getTrackCount() {
        return 0;
    }

    private final Map<UUID, byte[]> $$robo$$android_media_MediaExtractor$getPsshInfo() {
        HashMap<UUID, byte[]> psshMap = null;
        Map<String, Object> formatMap = this.getFileFormatNative();
        if (formatMap != null && formatMap.containsKey("pssh")) {
            ByteBuffer rawpssh = (ByteBuffer)formatMap.get("pssh");
            rawpssh.order(ByteOrder.nativeOrder());
            rawpssh.rewind();
            formatMap.remove("pssh");
            psshMap = new HashMap<UUID, byte[]>();
            while (rawpssh.remaining() > 0) {
                rawpssh.order(ByteOrder.BIG_ENDIAN);
                long msb = rawpssh.getLong();
                long lsb = rawpssh.getLong();
                UUID uuid = new UUID(msb, lsb);
                rawpssh.order(ByteOrder.nativeOrder());
                int datalen = rawpssh.getInt();
                byte[] psshdata = new byte[datalen];
                rawpssh.get(psshdata);
                psshMap.put(uuid, psshdata);
            }
        }
        return psshMap;
    }

    private final Map<String, Object> $$robo$$android_media_MediaExtractor$getFileFormatNative() {
        return null;
    }

    private final MediaFormat $$robo$$android_media_MediaExtractor$getTrackFormat(int index) {
        return new MediaFormat(this.getTrackFormatNative(index));
    }

    private final Map<String, Object> $$robo$$android_media_MediaExtractor$getTrackFormatNative(int n) {
        return null;
    }

    private final void $$robo$$android_media_MediaExtractor$selectTrack(int n) {
    }

    private final void $$robo$$android_media_MediaExtractor$unselectTrack(int n) {
    }

    private final void $$robo$$android_media_MediaExtractor$seekTo(long l, int n) {
    }

    private final boolean $$robo$$android_media_MediaExtractor$advance() {
        return false;
    }

    private final int $$robo$$android_media_MediaExtractor$readSampleData(ByteBuffer byteBuffer, int n) {
        return 0;
    }

    private final int $$robo$$android_media_MediaExtractor$getSampleTrackIndex() {
        return 0;
    }

    private final long $$robo$$android_media_MediaExtractor$getSampleTime() {
        return 0L;
    }

    private final int $$robo$$android_media_MediaExtractor$getSampleFlags() {
        return 0;
    }

    private final boolean $$robo$$android_media_MediaExtractor$getSampleCryptoInfo(MediaCodec.CryptoInfo cryptoInfo) {
        return false;
    }

    private final long $$robo$$android_media_MediaExtractor$getCachedDuration() {
        return 0L;
    }

    private final boolean $$robo$$android_media_MediaExtractor$hasCacheReachedEndOfStream() {
        return false;
    }

    private static final void $$robo$$android_media_MediaExtractor$native_init() {
    }

    private final void $$robo$$android_media_MediaExtractor$native_setup() {
    }

    private final void $$robo$$android_media_MediaExtractor$native_finalize() {
    }

    static void __staticInitializer__() {
        InvokeDynamicSupport.bootstrapIntrinsic("loadLibrary", "java.lang.System", (String)"media_jni");
        MediaExtractor.native_init();
    }

    private void __constructor__() {
        this.$$robo$$android_media_MediaExtractor$__constructor__();
    }

    public MediaExtractor() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaExtractor$__constructor__(), 0, this);
    }

    private final native /* synthetic */ void $$robo$$setDataSource$nativeBinding(DataSource var1) throws IOException;

    public void setDataSource(DataSource dataSource) throws IOException {
        InvokeDynamicSupport.bootstrap("setDataSource", $$robo$$android_media_MediaExtractor$setDataSource(android.media.DataSource ), 1, this, dataSource);
    }

    public void setDataSource(Context context, Uri uri, Map<String, String> map) throws IOException {
        InvokeDynamicSupport.bootstrap("setDataSource", $$robo$$android_media_MediaExtractor$setDataSource(android.content.Context android.net.Uri java.util.Map<java.lang.String, java.lang.String> ), 0, this, context, uri, map);
    }

    public void setDataSource(String string2, Map<String, String> map) throws IOException {
        InvokeDynamicSupport.bootstrap("setDataSource", $$robo$$android_media_MediaExtractor$setDataSource(java.lang.String java.util.Map<java.lang.String, java.lang.String> ), 0, this, string2, map);
    }

    private final native /* synthetic */ void $$robo$$nativeSetDataSource$nativeBinding(IBinder var1, String var2, String[] var3, String[] var4) throws IOException;

    private void nativeSetDataSource(IBinder iBinder, String string2, String[] stringArray, String[] stringArray2) throws IOException {
        InvokeDynamicSupport.bootstrap("nativeSetDataSource", $$robo$$android_media_MediaExtractor$nativeSetDataSource(android.os.IBinder java.lang.String java.lang.String[] java.lang.String[] ), 1, this, iBinder, string2, stringArray, stringArray2);
    }

    public void setDataSource(String string2) throws IOException {
        InvokeDynamicSupport.bootstrap("setDataSource", $$robo$$android_media_MediaExtractor$setDataSource(java.lang.String ), 0, this, string2);
    }

    public void setDataSource(FileDescriptor fileDescriptor) throws IOException {
        InvokeDynamicSupport.bootstrap("setDataSource", $$robo$$android_media_MediaExtractor$setDataSource(java.io.FileDescriptor ), 0, this, fileDescriptor);
    }

    private final native /* synthetic */ void $$robo$$setDataSource$nativeBinding(FileDescriptor var1, long var2, long var4) throws IOException;

    public void setDataSource(FileDescriptor fileDescriptor, long l, long l2) throws IOException {
        InvokeDynamicSupport.bootstrap("setDataSource", $$robo$$android_media_MediaExtractor$setDataSource(java.io.FileDescriptor long long ), 1, this, fileDescriptor, l, l2);
    }

    protected void finalize() {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_media_MediaExtractor$finalize(), 0, this);
    }

    private final native /* synthetic */ void $$robo$$release$nativeBinding();

    public void release() {
        InvokeDynamicSupport.bootstrap("release", $$robo$$android_media_MediaExtractor$release(), 1, this);
    }

    private final native /* synthetic */ int $$robo$$getTrackCount$nativeBinding();

    public int getTrackCount() {
        return (int)InvokeDynamicSupport.bootstrap("getTrackCount", $$robo$$android_media_MediaExtractor$getTrackCount(), 1, this);
    }

    public Map<UUID, byte[]> getPsshInfo() {
        return InvokeDynamicSupport.bootstrap("getPsshInfo", $$robo$$android_media_MediaExtractor$getPsshInfo(), 0, this);
    }

    private final native /* synthetic */ Map<String, Object> $$robo$$getFileFormatNative$nativeBinding();

    private Map<String, Object> getFileFormatNative() {
        return InvokeDynamicSupport.bootstrap("getFileFormatNative", $$robo$$android_media_MediaExtractor$getFileFormatNative(), 1, this);
    }

    public MediaFormat getTrackFormat(int n) {
        return InvokeDynamicSupport.bootstrap("getTrackFormat", $$robo$$android_media_MediaExtractor$getTrackFormat(int ), 0, this, n);
    }

    private final native /* synthetic */ Map<String, Object> $$robo$$getTrackFormatNative$nativeBinding(int var1);

    private Map<String, Object> getTrackFormatNative(int n) {
        return InvokeDynamicSupport.bootstrap("getTrackFormatNative", $$robo$$android_media_MediaExtractor$getTrackFormatNative(int ), 1, this, n);
    }

    private final native /* synthetic */ void $$robo$$selectTrack$nativeBinding(int var1);

    public void selectTrack(int n) {
        InvokeDynamicSupport.bootstrap("selectTrack", $$robo$$android_media_MediaExtractor$selectTrack(int ), 1, this, n);
    }

    private final native /* synthetic */ void $$robo$$unselectTrack$nativeBinding(int var1);

    public void unselectTrack(int n) {
        InvokeDynamicSupport.bootstrap("unselectTrack", $$robo$$android_media_MediaExtractor$unselectTrack(int ), 1, this, n);
    }

    private final native /* synthetic */ void $$robo$$seekTo$nativeBinding(long var1, int var3);

    public void seekTo(long l, int n) {
        InvokeDynamicSupport.bootstrap("seekTo", $$robo$$android_media_MediaExtractor$seekTo(long int ), 1, this, l, n);
    }

    private final native /* synthetic */ boolean $$robo$$advance$nativeBinding();

    public boolean advance() {
        return (boolean)InvokeDynamicSupport.bootstrap("advance", $$robo$$android_media_MediaExtractor$advance(), 1, this);
    }

    private final native /* synthetic */ int $$robo$$readSampleData$nativeBinding(ByteBuffer var1, int var2);

    public int readSampleData(ByteBuffer byteBuffer, int n) {
        return (int)InvokeDynamicSupport.bootstrap("readSampleData", $$robo$$android_media_MediaExtractor$readSampleData(java.nio.ByteBuffer int ), 1, this, byteBuffer, n);
    }

    private final native /* synthetic */ int $$robo$$getSampleTrackIndex$nativeBinding();

    public int getSampleTrackIndex() {
        return (int)InvokeDynamicSupport.bootstrap("getSampleTrackIndex", $$robo$$android_media_MediaExtractor$getSampleTrackIndex(), 1, this);
    }

    private final native /* synthetic */ long $$robo$$getSampleTime$nativeBinding();

    public long getSampleTime() {
        return (long)InvokeDynamicSupport.bootstrap("getSampleTime", $$robo$$android_media_MediaExtractor$getSampleTime(), 1, this);
    }

    private final native /* synthetic */ int $$robo$$getSampleFlags$nativeBinding();

    public int getSampleFlags() {
        return (int)InvokeDynamicSupport.bootstrap("getSampleFlags", $$robo$$android_media_MediaExtractor$getSampleFlags(), 1, this);
    }

    private final native /* synthetic */ boolean $$robo$$getSampleCryptoInfo$nativeBinding(MediaCodec.CryptoInfo var1);

    public boolean getSampleCryptoInfo(MediaCodec.CryptoInfo cryptoInfo) {
        return (boolean)InvokeDynamicSupport.bootstrap("getSampleCryptoInfo", $$robo$$android_media_MediaExtractor$getSampleCryptoInfo(android.media.MediaCodec$CryptoInfo ), 1, this, cryptoInfo);
    }

    private final native /* synthetic */ long $$robo$$getCachedDuration$nativeBinding();

    public long getCachedDuration() {
        return (long)InvokeDynamicSupport.bootstrap("getCachedDuration", $$robo$$android_media_MediaExtractor$getCachedDuration(), 1, this);
    }

    private final native /* synthetic */ boolean $$robo$$hasCacheReachedEndOfStream$nativeBinding();

    public boolean hasCacheReachedEndOfStream() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasCacheReachedEndOfStream", $$robo$$android_media_MediaExtractor$hasCacheReachedEndOfStream(), 1, this);
    }

    private static final native /* synthetic */ void $$robo$$native_init$nativeBinding();

    private static void native_init() {
        InvokeDynamicSupport.bootstrapStatic("native_init", $$robo$$android_media_MediaExtractor$native_init(), 1);
    }

    private final native /* synthetic */ void $$robo$$native_setup$nativeBinding();

    private void native_setup() {
        InvokeDynamicSupport.bootstrap("native_setup", $$robo$$android_media_MediaExtractor$native_setup(), 1, this);
    }

    private final native /* synthetic */ void $$robo$$native_finalize$nativeBinding();

    private void native_finalize() {
        InvokeDynamicSupport.bootstrap("native_finalize", $$robo$$android_media_MediaExtractor$native_finalize(), 1, this);
    }

    static {
        RobolectricInternals.classInitializing(MediaExtractor.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MediaExtractor)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

