/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.app.ActivityManager;
import android.app.AppOpsManager;
import android.app.KeyguardManager;
import android.app.PendingIntent;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.database.ContentObserver;
import android.media.AudioService;
import android.media.FocusRequester;
import android.media.IAudioFocusDispatcher;
import android.media.IRemoteControlClient;
import android.media.IRemoteControlDisplay;
import android.media.IRemoteVolumeObserver;
import android.media.PlayerRecord;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.UserHandle;
import android.provider.Settings;
import android.telephony.PhoneStateListener;
import android.telephony.TelephonyManager;
import android.util.Log;
import android.util.Slog;
import android.view.KeyEvent;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class MediaFocusControl
implements PendingIntent.OnFinished,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "MediaFocusControl";
    protected static boolean DEBUG_RC = false;
    protected static boolean DEBUG_VOL = false;
    private boolean mIsRinging;
    private PowerManager.WakeLock mMediaEventWakeLock;
    private MediaEventHandler mEventHandler;
    private Context mContext;
    private ContentResolver mContentResolver;
    private AudioService.VolumeController mVolumeController;
    private AppOpsManager mAppOps;
    private KeyguardManager mKeyguardManager;
    private AudioService mAudioService;
    private NotificationListenerObserver mNotifListenerObserver;
    private static Uri ENABLED_NOTIFICATION_LISTENERS_URI;
    private static int RCD_REG_FAILURE = 0;
    private static int RCD_REG_SUCCESS_PERMISSION = 1;
    private static int RCD_REG_SUCCESS_ENABLED_NOTIF = 2;
    private static int MSG_RCDISPLAY_CLEAR = 1;
    private static int MSG_RCDISPLAY_UPDATE = 2;
    private static int MSG_REEVALUATE_REMOTE = 3;
    private static int MSG_RCC_NEW_PLAYBACK_INFO = 4;
    private static int MSG_RCC_NEW_VOLUME_OBS = 5;
    private static int MSG_RCC_NEW_PLAYBACK_STATE = 6;
    private static int MSG_RCC_SEEK_REQUEST = 7;
    private static int MSG_RCC_UPDATE_METADATA = 8;
    private static int MSG_RCDISPLAY_INIT_INFO = 9;
    private static int MSG_REEVALUATE_RCD = 10;
    private static int MSG_UNREGISTER_MEDIABUTTONINTENT = 11;
    private static int SENDMSG_REPLACE = 0;
    private static int SENDMSG_NOOP = 1;
    private static int SENDMSG_QUEUE = 2;
    protected static String IN_VOICE_COMM_FOCUS_ID = "AudioFocus_For_Phone_Ring_And_Calls";
    private static Object mAudioFocusLock;
    private static Object mRingingLock;
    private PhoneStateListener mPhoneStateListener;
    private Stack<FocusRequester> mFocusStack;
    private static int VOICEBUTTON_ACTION_DISCARD_CURRENT_KEY_PRESS = 1;
    private static int VOICEBUTTON_ACTION_START_VOICE_INPUT = 2;
    private static int VOICEBUTTON_ACTION_SIMULATE_KEY_PRESS = 3;
    private Object mVoiceEventLock;
    private boolean mVoiceButtonDown;
    private boolean mVoiceButtonHandled;
    private static int WAKELOCK_RELEASE_ON_FINISHED = 1980;
    private static String EXTRA_WAKELOCK_ACQUIRED = "android.media.AudioService.WAKELOCK_ACQUIRED";
    BroadcastReceiver mKeyEventDone;
    private Object mCurrentRcLock;
    private IRemoteControlClient mCurrentRcClient;
    private PendingIntent mCurrentRcClientIntent;
    private static int RC_INFO_NONE = 0;
    private static int RC_INFO_ALL = 15;
    private int mCurrentRcClientGen;
    private PlayerRecord.RemotePlaybackState mMainRemote;
    private boolean mMainRemoteIsActive;
    private boolean mHasRemotePlayback;
    private Stack<PlayerRecord> mPRStack;
    private ComponentName mMediaReceiverForCalls;
    private ArrayList<DisplayInfoForServer> mRcDisplays;

    private void $$robo$$android_media_MediaFocusControl$__constructor__(Looper looper, Context cntxt, AudioService.VolumeController volumeCtrl, AudioService as) {
        this.mIsRinging = false;
        this.mPhoneStateListener = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ MediaFocusControl this$0;

            private void $$robo$$android_media_MediaFocusControl_1$__constructor__(MediaFocusControl mediaFocusControl) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_media_MediaFocusControl_1$onCallStateChanged(int state, String incomingNumber) {
                if (state == 1) {
                    Object object = mRingingLock;
                    synchronized (object) {
                        this.this$0.mIsRinging = true;
                    }
                }
                if (state == 2 || state == 0) {
                    Object object = mRingingLock;
                    synchronized (object) {
                        this.this$0.mIsRinging = false;
                    }
                }
            }

            private void __constructor__(MediaFocusControl mediaFocusControl) {
                this.$$robo$$android_media_MediaFocusControl_1$__constructor__(mediaFocusControl);
            }
            {
                this.this$0 = mediaFocusControl;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaFocusControl_1$__constructor__(android.media.MediaFocusControl ), 0, this, mediaFocusControl);
            }

            @Override
            public void onCallStateChanged(int n, String string2) {
                InvokeDynamicSupport.bootstrap("onCallStateChanged", $$robo$$android_media_MediaFocusControl_1$onCallStateChanged(int java.lang.String ), 0, this, n, string2);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mFocusStack = new Stack();
        this.mVoiceEventLock = new Object();
        this.mKeyEventDone = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ MediaFocusControl this$0;

            private void $$robo$$android_media_MediaFocusControl_2$__constructor__(MediaFocusControl mediaFocusControl) {
            }

            private final void $$robo$$android_media_MediaFocusControl_2$onReceive(Context context, Intent intent) {
                if (intent == null) {
                    return;
                }
                Bundle extras = intent.getExtras();
                if (extras == null) {
                    return;
                }
                if (extras.containsKey("android.media.AudioService.WAKELOCK_ACQUIRED")) {
                    this.this$0.mMediaEventWakeLock.release();
                }
            }

            private void __constructor__(MediaFocusControl mediaFocusControl) {
                this.$$robo$$android_media_MediaFocusControl_2$__constructor__(mediaFocusControl);
            }
            {
                this.this$0 = mediaFocusControl;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaFocusControl_2$__constructor__(android.media.MediaFocusControl ), 0, this, mediaFocusControl);
            }

            @Override
            public void onReceive(Context context, Intent intent) {
                InvokeDynamicSupport.bootstrap("onReceive", $$robo$$android_media_MediaFocusControl_2$onReceive(android.content.Context android.content.Intent ), 0, this, context, intent);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mCurrentRcLock = new Object();
        this.mCurrentRcClient = null;
        this.mCurrentRcClientIntent = null;
        this.mCurrentRcClientGen = 0;
        this.mPRStack = new Stack();
        this.mMediaReceiverForCalls = null;
        this.mRcDisplays = new ArrayList(1);
        this.mEventHandler = new MediaEventHandler(this, looper);
        this.mContext = cntxt;
        this.mContentResolver = this.mContext.getContentResolver();
        this.mVolumeController = volumeCtrl;
        this.mAudioService = as;
        PowerManager pm = (PowerManager)this.mContext.getSystemService("power");
        this.mMediaEventWakeLock = pm.newWakeLock(1, "handleMediaEvent");
        this.mMainRemote = new PlayerRecord.RemotePlaybackState(-1, AudioService.getMaxStreamVolume(3), AudioService.getMaxStreamVolume(3));
        TelephonyManager tmgr = (TelephonyManager)this.mContext.getSystemService("phone");
        tmgr.listen(this.mPhoneStateListener, 32);
        this.mAppOps = (AppOpsManager)this.mContext.getSystemService("appops");
        this.mKeyguardManager = (KeyguardManager)this.mContext.getSystemService("keyguard");
        this.mNotifListenerObserver = new NotificationListenerObserver(this);
        this.mHasRemotePlayback = false;
        this.mMainRemoteIsActive = false;
        PlayerRecord.setMediaFocusControl(this);
        this.postReevaluateRemote();
    }

    private final void $$robo$$android_media_MediaFocusControl$dump(PrintWriter pw) {
        this.dumpFocusStack(pw);
        this.dumpRCStack(pw);
        this.dumpRCCStack(pw);
        this.dumpRCDList(pw);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_media_MediaFocusControl$checkRcdRegistrationAuthorization(ComponentName listenerComp) {
        if (0 == this.mContext.checkCallingOrSelfPermission("android.permission.MEDIA_CONTENT_CONTROL")) {
            return 1;
        }
        if (listenerComp != null) {
            long ident = Binder.clearCallingIdentity();
            try {
                int currentUser = ActivityManager.getCurrentUser();
                String enabledNotifListeners = Settings.Secure.getStringForUser(this.mContext.getContentResolver(), "enabled_notification_listeners", currentUser);
                if (enabledNotifListeners != null) {
                    String[] components = enabledNotifListeners.split(":");
                    for (int i = 0; i < components.length; ++i) {
                        ComponentName component = ComponentName.unflattenFromString(components[i]);
                        if (component == null || !listenerComp.equals(component)) continue;
                        int n = 2;
                        return n;
                    }
                }
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
        return 0;
    }

    private final boolean $$robo$$android_media_MediaFocusControl$registerRemoteController(IRemoteControlDisplay rcd, int w, int h, ComponentName listenerComp) {
        int reg = this.checkRcdRegistrationAuthorization(listenerComp);
        if (reg != 0) {
            this.registerRemoteControlDisplay_int(rcd, w, h, listenerComp);
            return true;
        }
        Slog.w("MediaFocusControl", "Access denied to process: " + Binder.getCallingPid() + ", must have permission " + "android.permission.MEDIA_CONTENT_CONTROL" + " or be an enabled NotificationListenerService for registerRemoteController");
        return false;
    }

    private final boolean $$robo$$android_media_MediaFocusControl$registerRemoteControlDisplay(IRemoteControlDisplay rcd, int w, int h) {
        int reg = this.checkRcdRegistrationAuthorization(null);
        if (reg != 0) {
            this.registerRemoteControlDisplay_int(rcd, w, h, null);
            return true;
        }
        Slog.w("MediaFocusControl", "Access denied to process: " + Binder.getCallingPid() + ", must have permission " + "android.permission.MEDIA_CONTENT_CONTROL" + " to register IRemoteControlDisplay");
        return false;
    }

    private final void $$robo$$android_media_MediaFocusControl$postReevaluateRemoteControlDisplays() {
        MediaFocusControl.sendMsg(this.mEventHandler, 10, 2, 0, 0, null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaFocusControl$onReevaluateRemoteControlDisplays() {
        int currentUser = ActivityManager.getCurrentUser();
        String enabledNotifListeners = Settings.Secure.getStringForUser(this.mContext.getContentResolver(), "enabled_notification_listeners", currentUser);
        Object object = mAudioFocusLock;
        synchronized (object) {
            Stack<PlayerRecord> stack = this.mPRStack;
            synchronized (stack) {
                String[] enabledComponents = enabledNotifListeners == null ? null : enabledNotifListeners.split(":");
                for (DisplayInfoForServer di : this.mRcDisplays) {
                    if (di.mClientNotifListComp == null) continue;
                    boolean wasEnabled = di.mEnabled;
                    di.mEnabled = this.isComponentInStringArray(di.mClientNotifListComp, enabledComponents);
                    if (wasEnabled == di.mEnabled) continue;
                    try {
                        di.mRcDisplay.setEnabled(di.mEnabled);
                        this.enableRemoteControlDisplayForClient_syncRcStack(di.mRcDisplay, di.mEnabled);
                        if (!di.mEnabled) continue;
                        MediaFocusControl.sendMsg(this.mEventHandler, 9, 2, di.mArtworkExpectedWidth, di.mArtworkExpectedHeight, di.mRcDisplay, 0);
                    }
                    catch (RemoteException e) {
                        Log.e("MediaFocusControl", "Error en/disabling RCD: ", e);
                    }
                }
            }
        }
    }

    private final boolean $$robo$$android_media_MediaFocusControl$isComponentInStringArray(ComponentName comp, String[] enabledArray) {
        if (enabledArray == null || enabledArray.length == 0) {
            return false;
        }
        String compString = comp.flattenToString();
        for (int i = 0; i < enabledArray.length; ++i) {
            if (!compString.equals(enabledArray[i])) continue;
            return true;
        }
        return false;
    }

    private static final void $$robo$$android_media_MediaFocusControl$sendMsg(Handler handler, int msg, int existingMsgPolicy, int arg1, int arg2, Object obj, int delay) {
        if (existingMsgPolicy == 0) {
            handler.removeMessages(msg);
        } else if (existingMsgPolicy == 1 && handler.hasMessages(msg)) {
            return;
        }
        handler.sendMessageDelayed(handler.obtainMessage(msg, arg1, arg2, obj), delay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaFocusControl$discardAudioFocusOwner() {
        Object object = mAudioFocusLock;
        synchronized (object) {
            if (!this.mFocusStack.empty()) {
                FocusRequester exFocusOwner = this.mFocusStack.pop();
                exFocusOwner.handleFocusLoss(-1);
                exFocusOwner.release();
            }
        }
    }

    private final void $$robo$$android_media_MediaFocusControl$notifyTopOfAudioFocusStack() {
        if (!this.mFocusStack.empty() && this.canReassignAudioFocus()) {
            this.mFocusStack.peek().handleFocusGain(1);
        }
    }

    private final void $$robo$$android_media_MediaFocusControl$propagateFocusLossFromGain_syncAf(int focusGain) {
        Iterator stackIterator = this.mFocusStack.iterator();
        while (stackIterator.hasNext()) {
            ((FocusRequester)stackIterator.next()).handleExternalFocusGain(focusGain);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaFocusControl$dumpFocusStack(PrintWriter pw) {
        pw.println("\nAudio Focus stack entries (last is top of stack):");
        Object object = mAudioFocusLock;
        synchronized (object) {
            Iterator stackIterator = this.mFocusStack.iterator();
            while (stackIterator.hasNext()) {
                ((FocusRequester)stackIterator.next()).dump(pw);
            }
        }
    }

    private final void $$robo$$android_media_MediaFocusControl$removeFocusStackEntry(String clientToRemove, boolean signal) {
        if (!this.mFocusStack.empty() && this.mFocusStack.peek().hasSameClient(clientToRemove)) {
            FocusRequester fr = this.mFocusStack.pop();
            fr.release();
            if (signal) {
                this.notifyTopOfAudioFocusStack();
            }
        } else {
            Iterator stackIterator = this.mFocusStack.iterator();
            while (stackIterator.hasNext()) {
                FocusRequester fr = (FocusRequester)stackIterator.next();
                if (!fr.hasSameClient(clientToRemove)) continue;
                Log.i("MediaFocusControl", "AudioFocus  removeFocusStackEntry(): removing entry for " + clientToRemove);
                stackIterator.remove();
                fr.release();
            }
        }
    }

    private final void $$robo$$android_media_MediaFocusControl$removeFocusStackEntryForClient(IBinder cb) {
        boolean isTopOfStackForClientToRemove = !this.mFocusStack.isEmpty() && this.mFocusStack.peek().hasSameBinder(cb);
        Iterator stackIterator = this.mFocusStack.iterator();
        while (stackIterator.hasNext()) {
            FocusRequester fr = (FocusRequester)stackIterator.next();
            if (!fr.hasSameBinder(cb)) continue;
            Log.i("MediaFocusControl", "AudioFocus  removeFocusStackEntry(): removing entry for " + cb);
            stackIterator.remove();
        }
        if (isTopOfStackForClientToRemove) {
            this.notifyTopOfAudioFocusStack();
        }
    }

    private final boolean $$robo$$android_media_MediaFocusControl$canReassignAudioFocus() {
        return this.mFocusStack.isEmpty() || !this.mFocusStack.peek().hasSameClient("AudioFocus_For_Phone_Ring_And_Calls");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_media_MediaFocusControl$getCurrentAudioFocus() {
        Object object = mAudioFocusLock;
        synchronized (object) {
            if (this.mFocusStack.empty()) {
                return 0;
            }
            return this.mFocusStack.peek().getGainRequest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_media_MediaFocusControl$requestAudioFocus(int mainStreamType, int focusChangeHint, IBinder cb, IAudioFocusDispatcher fd, String clientId, String callingPackageName) {
        Log.i("MediaFocusControl", " AudioFocus  requestAudioFocus() from " + clientId);
        if (!cb.pingBinder()) {
            Log.e("MediaFocusControl", " AudioFocus DOA client for requestAudioFocus(), aborting.");
            return 0;
        }
        if (this.mAppOps.noteOp(32, Binder.getCallingUid(), callingPackageName) != 0) {
            return 0;
        }
        Object object = mAudioFocusLock;
        synchronized (object) {
            if (!this.canReassignAudioFocus()) {
                return 0;
            }
            AudioFocusDeathHandler afdh = new AudioFocusDeathHandler(this, cb);
            try {
                cb.linkToDeath(afdh, 0);
            }
            catch (RemoteException e) {
                Log.w("MediaFocusControl", "AudioFocus  requestAudioFocus() could not link to " + cb + " binder death");
                return 0;
            }
            if (!this.mFocusStack.empty() && this.mFocusStack.peek().hasSameClient(clientId)) {
                if (this.mFocusStack.peek().getGainRequest() == focusChangeHint) {
                    cb.unlinkToDeath(afdh, 0);
                    return 1;
                }
                FocusRequester fr = this.mFocusStack.pop();
                fr.release();
            }
            this.removeFocusStackEntry(clientId, false);
            if (!this.mFocusStack.empty()) {
                this.propagateFocusLossFromGain_syncAf(focusChangeHint);
            }
            this.mFocusStack.push(new FocusRequester(mainStreamType, focusChangeHint, fd, cb, clientId, afdh, callingPackageName, Binder.getCallingUid()));
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_media_MediaFocusControl$abandonAudioFocus(IAudioFocusDispatcher fl, String clientId) {
        Log.i("MediaFocusControl", " AudioFocus  abandonAudioFocus() from " + clientId);
        try {
            Object object = mAudioFocusLock;
            synchronized (object) {
                this.removeFocusStackEntry(clientId, true);
            }
        }
        catch (ConcurrentModificationException cme) {
            Log.e("MediaFocusControl", "FATAL EXCEPTION AudioFocus  abandonAudioFocus() caused " + cme);
            cme.printStackTrace();
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaFocusControl$unregisterAudioFocusClient(String clientId) {
        Object object = mAudioFocusLock;
        synchronized (object) {
            this.removeFocusStackEntry(clientId, false);
        }
    }

    private final void $$robo$$android_media_MediaFocusControl$dispatchMediaKeyEvent(KeyEvent keyEvent) {
        this.filterMediaKeyEvent(keyEvent, false);
    }

    private final void $$robo$$android_media_MediaFocusControl$dispatchMediaKeyEventUnderWakelock(KeyEvent keyEvent) {
        this.filterMediaKeyEvent(keyEvent, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaFocusControl$filterMediaKeyEvent(KeyEvent keyEvent, boolean needWakeLock) {
        if (!MediaFocusControl.isValidMediaKeyEvent(keyEvent)) {
            Log.e("MediaFocusControl", "not dispatching invalid media key event " + keyEvent);
            return;
        }
        Object object = mRingingLock;
        synchronized (object) {
            Stack<PlayerRecord> stack = this.mPRStack;
            synchronized (stack) {
                if (this.mMediaReceiverForCalls != null && (this.mIsRinging || this.mAudioService.getMode() == 2)) {
                    this.dispatchMediaKeyEventForCalls(keyEvent, needWakeLock);
                    return;
                }
            }
        }
        if (MediaFocusControl.isValidVoiceInputKeyCode(keyEvent.getKeyCode())) {
            this.filterVoiceInputKeyEvent(keyEvent, needWakeLock);
        } else {
            this.dispatchMediaKeyEvent(keyEvent, needWakeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaFocusControl$dispatchMediaKeyEventForCalls(KeyEvent keyEvent, boolean needWakeLock) {
        Intent keyIntent = new Intent("android.intent.action.MEDIA_BUTTON", null);
        keyIntent.putExtra("android.intent.extra.KEY_EVENT", keyEvent);
        keyIntent.setPackage(this.mMediaReceiverForCalls.getPackageName());
        if (needWakeLock) {
            this.mMediaEventWakeLock.acquire();
            keyIntent.putExtra("android.media.AudioService.WAKELOCK_ACQUIRED", 1980);
        }
        long ident = Binder.clearCallingIdentity();
        try {
            this.mContext.sendOrderedBroadcastAsUser(keyIntent, UserHandle.ALL, null, this.mKeyEventDone, this.mEventHandler, -1, null, null);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaFocusControl$dispatchMediaKeyEvent(KeyEvent keyEvent, boolean needWakeLock) {
        if (needWakeLock) {
            this.mMediaEventWakeLock.acquire();
        }
        Intent keyIntent = new Intent("android.intent.action.MEDIA_BUTTON", null);
        keyIntent.putExtra("android.intent.extra.KEY_EVENT", keyEvent);
        Stack<PlayerRecord> stack = this.mPRStack;
        synchronized (stack) {
            if (!this.mPRStack.empty()) {
                try {
                    this.mPRStack.peek().getMediaButtonIntent().send(this.mContext, needWakeLock ? 1980 : 0, keyIntent, this, this.mEventHandler);
                }
                catch (PendingIntent.CanceledException e) {
                    Log.e("MediaFocusControl", "Error sending pending intent " + this.mPRStack.peek());
                    e.printStackTrace();
                }
            } else {
                if (needWakeLock) {
                    keyIntent.putExtra("android.media.AudioService.WAKELOCK_ACQUIRED", 1980);
                }
                long ident = Binder.clearCallingIdentity();
                try {
                    this.mContext.sendOrderedBroadcastAsUser(keyIntent, UserHandle.ALL, null, this.mKeyEventDone, this.mEventHandler, -1, null, null);
                }
                finally {
                    Binder.restoreCallingIdentity(ident);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaFocusControl$filterVoiceInputKeyEvent(KeyEvent keyEvent, boolean needWakeLock) {
        int voiceButtonAction = 1;
        int keyAction = keyEvent.getAction();
        Object object = this.mVoiceEventLock;
        synchronized (object) {
            if (keyAction == 0) {
                if (keyEvent.getRepeatCount() == 0) {
                    this.mVoiceButtonDown = true;
                    this.mVoiceButtonHandled = false;
                } else if (this.mVoiceButtonDown && !this.mVoiceButtonHandled && (keyEvent.getFlags() & 0x80) != 0) {
                    this.mVoiceButtonHandled = true;
                    voiceButtonAction = 2;
                }
            } else if (keyAction == 1 && this.mVoiceButtonDown) {
                this.mVoiceButtonDown = false;
                if (!this.mVoiceButtonHandled && !keyEvent.isCanceled()) {
                    voiceButtonAction = 3;
                }
            }
        }
        switch (voiceButtonAction) {
            case 1: {
                break;
            }
            case 2: {
                this.startVoiceBasedInteractions(needWakeLock);
                break;
            }
            case 3: {
                this.sendSimulatedMediaButtonEvent(keyEvent, needWakeLock);
            }
        }
    }

    private final void $$robo$$android_media_MediaFocusControl$sendSimulatedMediaButtonEvent(KeyEvent originalKeyEvent, boolean needWakeLock) {
        KeyEvent keyEvent = KeyEvent.changeAction(originalKeyEvent, 0);
        this.dispatchMediaKeyEvent(keyEvent, needWakeLock);
        keyEvent = KeyEvent.changeAction(originalKeyEvent, 1);
        this.dispatchMediaKeyEvent(keyEvent, needWakeLock);
    }

    private static final boolean $$robo$$android_media_MediaFocusControl$isValidMediaKeyEvent(KeyEvent keyEvent) {
        if (keyEvent == null) {
            return false;
        }
        return KeyEvent.isMediaKey(keyEvent.getKeyCode());
    }

    private static final boolean $$robo$$android_media_MediaFocusControl$isValidVoiceInputKeyCode(int keyCode) {
        return keyCode == 79;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaFocusControl$startVoiceBasedInteractions(boolean needWakeLock) {
        boolean isLocked;
        Intent voiceIntent = null;
        PowerManager pm = (PowerManager)this.mContext.getSystemService("power");
        boolean bl = isLocked = this.mKeyguardManager != null && this.mKeyguardManager.isKeyguardLocked();
        if (!isLocked && pm.isScreenOn()) {
            voiceIntent = new Intent("android.speech.action.WEB_SEARCH");
            Log.i("MediaFocusControl", "voice-based interactions: about to use ACTION_WEB_SEARCH");
        } else {
            voiceIntent = new Intent("android.speech.action.VOICE_SEARCH_HANDS_FREE");
            voiceIntent.putExtra("android.speech.extras.EXTRA_SECURE", isLocked && this.mKeyguardManager.isKeyguardSecure());
            Log.i("MediaFocusControl", "voice-based interactions: about to use ACTION_VOICE_SEARCH_HANDS_FREE");
        }
        if (needWakeLock) {
            this.mMediaEventWakeLock.acquire();
        }
        long identity = Binder.clearCallingIdentity();
        try {
            if (voiceIntent != null) {
                voiceIntent.setFlags(0x10800000);
                this.mContext.startActivityAsUser(voiceIntent, UserHandle.CURRENT);
            }
        }
        catch (ActivityNotFoundException e) {
            Log.w("MediaFocusControl", "No activity for search: " + e);
        }
        finally {
            Binder.restoreCallingIdentity(identity);
            if (needWakeLock) {
                this.mMediaEventWakeLock.release();
            }
        }
    }

    private final void $$robo$$android_media_MediaFocusControl$onSendFinished(PendingIntent pendingIntent, Intent intent, int resultCode, String resultData, Bundle resultExtras) {
        if (resultCode == 1980) {
            this.mMediaEventWakeLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaFocusControl$dumpRCStack(PrintWriter pw) {
        pw.println("\nRemote Control stack entries (last is top of stack):");
        Stack<PlayerRecord> stack = this.mPRStack;
        synchronized (stack) {
            Iterator stackIterator = this.mPRStack.iterator();
            while (stackIterator.hasNext()) {
                ((PlayerRecord)stackIterator.next()).dump(pw, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaFocusControl$dumpRCCStack(PrintWriter pw) {
        pw.println("\nRemote Control Client stack entries (last is top of stack):");
        Object object = this.mPRStack;
        synchronized (object) {
            Iterator stackIterator = this.mPRStack.iterator();
            while (stackIterator.hasNext()) {
                ((PlayerRecord)stackIterator.next()).dump(pw, false);
            }
            Object object2 = this.mCurrentRcLock;
            synchronized (object2) {
                pw.println("\nCurrent remote control generation ID = " + this.mCurrentRcClientGen);
            }
        }
        object = this.mMainRemote;
        synchronized (object) {
            pw.println("\nRemote Volume State:");
            pw.println("  has remote: " + this.mHasRemotePlayback);
            pw.println("  is remote active: " + this.mMainRemoteIsActive);
            pw.println("  rccId: " + this.mMainRemote.mRccId);
            pw.println("  volume handling: " + (this.mMainRemote.mVolumeHandling == 0 ? "PLAYBACK_VOLUME_FIXED(0)" : "PLAYBACK_VOLUME_VARIABLE(1)"));
            pw.println("  volume: " + this.mMainRemote.mVolume);
            pw.println("  volume steps: " + this.mMainRemote.mVolumeMax);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaFocusControl$dumpRCDList(PrintWriter pw) {
        pw.println("\nRemote Control Display list entries:");
        Stack<PlayerRecord> stack = this.mPRStack;
        synchronized (stack) {
            for (DisplayInfoForServer di : this.mRcDisplays) {
                pw.println("  IRCD: " + di.mRcDisplay + "  -- w:" + di.mArtworkExpectedWidth + "  -- h:" + di.mArtworkExpectedHeight + "  -- wantsPosSync:" + di.mWantsPositionSync + "  -- " + (di.mEnabled ? "enabled" : "disabled"));
            }
        }
    }

    private final boolean $$robo$$android_media_MediaFocusControl$pushMediaButtonReceiver_syncPrs(PendingIntent mediaIntent, ComponentName target, IBinder token) {
        if (this.mPRStack.empty()) {
            this.mPRStack.push(new PlayerRecord(mediaIntent, target, token));
            return true;
        }
        if (this.mPRStack.peek().hasMatchingMediaButtonIntent(mediaIntent)) {
            return false;
        }
        if (this.mAppOps.noteOp(31, Binder.getCallingUid(), mediaIntent.getCreatorPackage()) != 0) {
            return false;
        }
        PlayerRecord oldTopPrse = (PlayerRecord)this.mPRStack.lastElement();
        boolean topChanged = false;
        PlayerRecord prse = null;
        int lastPlayingIndex = this.mPRStack.size();
        int inStackIndex = -1;
        try {
            for (int index = this.mPRStack.size() - 1; index >= 0; --index) {
                prse = (PlayerRecord)this.mPRStack.elementAt(index);
                if (prse.isPlaybackActive()) {
                    lastPlayingIndex = index;
                }
                if (!prse.hasMatchingMediaButtonIntent(mediaIntent)) continue;
                inStackIndex = index;
            }
            if (inStackIndex == -1) {
                prse = new PlayerRecord(mediaIntent, target, token);
                this.mPRStack.add(lastPlayingIndex, prse);
            } else if (this.mPRStack.size() > 1) {
                prse = (PlayerRecord)this.mPRStack.elementAt(inStackIndex);
                this.mPRStack.removeElementAt(inStackIndex);
                if (prse.isPlaybackActive()) {
                    this.mPRStack.push(prse);
                } else if (inStackIndex > lastPlayingIndex) {
                    this.mPRStack.add(lastPlayingIndex, prse);
                } else {
                    this.mPRStack.add(lastPlayingIndex - 1, prse);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Log.e("MediaFocusControl", "Wrong index (inStack=" + inStackIndex + " lastPlaying=" + lastPlayingIndex + " size=" + this.mPRStack.size() + " accessing media button stack", e);
        }
        return topChanged;
    }

    private final void $$robo$$android_media_MediaFocusControl$removeMediaButtonReceiver_syncPrs(PendingIntent pi) {
        try {
            for (int index = this.mPRStack.size() - 1; index >= 0; --index) {
                PlayerRecord prse = (PlayerRecord)this.mPRStack.elementAt(index);
                if (!prse.hasMatchingMediaButtonIntent(pi)) continue;
                prse.destroy();
                this.mPRStack.removeElementAt(index);
                break;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Log.e("MediaFocusControl", "Wrong index accessing media button stack, lock error? ", e);
        }
    }

    private final boolean $$robo$$android_media_MediaFocusControl$isCurrentRcController(PendingIntent pi) {
        return !this.mPRStack.empty() && this.mPRStack.peek().hasMatchingMediaButtonIntent(pi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaFocusControl$setNewRcClientOnDisplays_syncRcsCurrc(int newClientGeneration, PendingIntent newMediaIntent, boolean clearing) {
        Stack<PlayerRecord> stack = this.mPRStack;
        synchronized (stack) {
            if (this.mRcDisplays.size() > 0) {
                Iterator<DisplayInfoForServer> displayIterator = this.mRcDisplays.iterator();
                while (displayIterator.hasNext()) {
                    DisplayInfoForServer di = displayIterator.next();
                    try {
                        di.mRcDisplay.setCurrentClientId(newClientGeneration, newMediaIntent, clearing);
                    }
                    catch (RemoteException e) {
                        Log.e("MediaFocusControl", "Dead display in setNewRcClientOnDisplays_syncRcsCurrc()", e);
                        di.release();
                        displayIterator.remove();
                    }
                }
            }
        }
    }

    private final void $$robo$$android_media_MediaFocusControl$setNewRcClientGenerationOnClients_syncRcsCurrc(int newClientGeneration) {
        Iterator stackIterator = this.mPRStack.iterator();
        while (stackIterator.hasNext()) {
            PlayerRecord se = (PlayerRecord)stackIterator.next();
            if (se == null || se.getRcc() == null) continue;
            try {
                se.getRcc().setCurrentClientGenerationId(newClientGeneration);
            }
            catch (RemoteException e) {
                Log.w("MediaFocusControl", "Dead client in setNewRcClientGenerationOnClients_syncRcsCurrc()", e);
                stackIterator.remove();
                se.unlinkToRcClientDeath();
            }
        }
    }

    private final void $$robo$$android_media_MediaFocusControl$setNewRcClient_syncRcsCurrc(int newClientGeneration, PendingIntent newMediaIntent, boolean clearing) {
        this.setNewRcClientOnDisplays_syncRcsCurrc(newClientGeneration, newMediaIntent, clearing);
        this.setNewRcClientGenerationOnClients_syncRcsCurrc(newClientGeneration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaFocusControl$onRcDisplayClear() {
        Stack<PlayerRecord> stack = this.mPRStack;
        synchronized (stack) {
            Object object = this.mCurrentRcLock;
            synchronized (object) {
                ++this.mCurrentRcClientGen;
                this.setNewRcClient_syncRcsCurrc(this.mCurrentRcClientGen, null, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaFocusControl$onRcDisplayUpdate(PlayerRecord prse, int flags) {
        Stack<PlayerRecord> stack = this.mPRStack;
        synchronized (stack) {
            Object object = this.mCurrentRcLock;
            synchronized (object) {
                if (this.mCurrentRcClient != null && this.mCurrentRcClient.equals(prse.getRcc())) {
                    ++this.mCurrentRcClientGen;
                    this.setNewRcClient_syncRcsCurrc(this.mCurrentRcClientGen, prse.getMediaButtonIntent(), false);
                    try {
                        this.mCurrentRcClient.onInformationRequested(this.mCurrentRcClientGen, flags);
                    }
                    catch (RemoteException e) {
                        Log.e("MediaFocusControl", "Current valid remote client is dead: " + e);
                        this.mCurrentRcClient = null;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaFocusControl$onRcDisplayInitInfo(IRemoteControlDisplay newRcd, int w, int h) {
        Stack<PlayerRecord> stack = this.mPRStack;
        synchronized (stack) {
            Object object = this.mCurrentRcLock;
            synchronized (object) {
                if (this.mCurrentRcClient != null) {
                    try {
                        newRcd.setCurrentClientId(this.mCurrentRcClientGen, this.mCurrentRcClientIntent, false);
                        try {
                            this.mCurrentRcClient.informationRequestForDisplay(newRcd, w, h);
                        }
                        catch (RemoteException e) {
                            Log.e("MediaFocusControl", "Current valid remote client is dead: ", e);
                            this.mCurrentRcClient = null;
                        }
                    }
                    catch (RemoteException e) {
                        Log.e("MediaFocusControl", "Dead display in onRcDisplayInitInfo()", e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaFocusControl$clearRemoteControlDisplay_syncPrs() {
        Object object = this.mCurrentRcLock;
        synchronized (object) {
            this.mCurrentRcClient = null;
        }
        this.mEventHandler.sendMessage(this.mEventHandler.obtainMessage(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaFocusControl$updateRemoteControlDisplay_syncPrs(int infoChangedFlags) {
        PlayerRecord prse = this.mPRStack.peek();
        int infoFlagsAboutToBeUsed = infoChangedFlags;
        if (prse.getRcc() == null) {
            this.clearRemoteControlDisplay_syncPrs();
            return;
        }
        Object object = this.mCurrentRcLock;
        synchronized (object) {
            if (!prse.getRcc().equals(this.mCurrentRcClient)) {
                infoFlagsAboutToBeUsed = 15;
            }
            this.mCurrentRcClient = prse.getRcc();
            this.mCurrentRcClientIntent = prse.getMediaButtonIntent();
        }
        this.mEventHandler.sendMessage(this.mEventHandler.obtainMessage(2, infoFlagsAboutToBeUsed, 0, prse));
    }

    private final void $$robo$$android_media_MediaFocusControl$checkUpdateRemoteControlDisplay_syncPrs(int infoChangedFlags) {
        if (this.mPRStack.isEmpty()) {
            this.clearRemoteControlDisplay_syncPrs();
            return;
        }
        this.updateRemoteControlDisplay_syncPrs(infoChangedFlags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaFocusControl$registerMediaButtonIntent(PendingIntent mediaIntent, ComponentName eventReceiver, IBinder token) {
        Log.i("MediaFocusControl", "  Remote Control   registerMediaButtonIntent() for " + mediaIntent);
        Stack<PlayerRecord> stack = this.mPRStack;
        synchronized (stack) {
            if (this.pushMediaButtonReceiver_syncPrs(mediaIntent, eventReceiver, token)) {
                this.checkUpdateRemoteControlDisplay_syncPrs(15);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaFocusControl$unregisterMediaButtonIntent(PendingIntent mediaIntent) {
        Log.i("MediaFocusControl", "  Remote Control   unregisterMediaButtonIntent() for " + mediaIntent);
        Stack<PlayerRecord> stack = this.mPRStack;
        synchronized (stack) {
            boolean topOfStackWillChange = this.isCurrentRcController(mediaIntent);
            this.removeMediaButtonReceiver_syncPrs(mediaIntent);
            if (topOfStackWillChange) {
                this.checkUpdateRemoteControlDisplay_syncPrs(15);
            }
        }
    }

    private final void $$robo$$android_media_MediaFocusControl$unregisterMediaButtonIntentAsync(PendingIntent mediaIntent) {
        this.mEventHandler.sendMessage(this.mEventHandler.obtainMessage(11, 0, 0, mediaIntent));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaFocusControl$registerMediaButtonEventReceiverForCalls(ComponentName c) {
        if (this.mContext.checkCallingPermission("android.permission.MODIFY_PHONE_STATE") != 0) {
            Log.e("MediaFocusControl", "Invalid permissions to register media button receiver for calls");
            return;
        }
        Stack<PlayerRecord> stack = this.mPRStack;
        synchronized (stack) {
            this.mMediaReceiverForCalls = c;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaFocusControl$unregisterMediaButtonEventReceiverForCalls() {
        if (this.mContext.checkCallingPermission("android.permission.MODIFY_PHONE_STATE") != 0) {
            Log.e("MediaFocusControl", "Invalid permissions to unregister media button receiver for calls");
            return;
        }
        Stack<PlayerRecord> stack = this.mPRStack;
        synchronized (stack) {
            this.mMediaReceiverForCalls = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_media_MediaFocusControl$registerRemoteControlClient(PendingIntent mediaIntent, IRemoteControlClient rcClient, String callingPackageName) {
        int rccId = -1;
        Stack<PlayerRecord> stack = this.mPRStack;
        synchronized (stack) {
            try {
                for (int index = this.mPRStack.size() - 1; index >= 0; --index) {
                    PlayerRecord prse = (PlayerRecord)this.mPRStack.elementAt(index);
                    if (!prse.hasMatchingMediaButtonIntent(mediaIntent)) continue;
                    prse.resetControllerInfoForRcc(rcClient, callingPackageName, Binder.getCallingUid());
                    if (rcClient != null) {
                        rccId = prse.getRccId();
                        if (this.mRcDisplays.size() > 0) {
                            this.plugRemoteControlDisplaysIntoClient_syncPrs(prse.getRcc());
                        }
                    }
                    break;
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                Log.e("MediaFocusControl", "Wrong index accessing RC stack, lock error? ", e);
            }
            if (this.isCurrentRcController(mediaIntent)) {
                this.checkUpdateRemoteControlDisplay_syncPrs(15);
            }
        }
        return rccId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaFocusControl$unregisterRemoteControlClient(PendingIntent mediaIntent, IRemoteControlClient rcClient) {
        Stack<PlayerRecord> stack = this.mPRStack;
        synchronized (stack) {
            boolean topRccChange = false;
            try {
                for (int index = this.mPRStack.size() - 1; index >= 0; --index) {
                    PlayerRecord prse = (PlayerRecord)this.mPRStack.elementAt(index);
                    if (!prse.hasMatchingMediaButtonIntent(mediaIntent) || !rcClient.equals(prse.getRcc())) continue;
                    prse.resetControllerInfoForNoRcc();
                    topRccChange = index == this.mPRStack.size() - 1;
                    break;
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                Log.e("MediaFocusControl", "Wrong index accessing RC stack, lock error? ", e);
            }
            if (topRccChange) {
                this.checkUpdateRemoteControlDisplay_syncPrs(15);
            }
        }
    }

    private final void $$robo$$android_media_MediaFocusControl$plugRemoteControlDisplaysIntoClient_syncPrs(IRemoteControlClient rcc) {
        for (DisplayInfoForServer di : this.mRcDisplays) {
            try {
                rcc.plugRemoteControlDisplay(di.mRcDisplay, di.mArtworkExpectedWidth, di.mArtworkExpectedHeight);
                if (!di.mWantsPositionSync) continue;
                rcc.setWantsSyncForDisplay(di.mRcDisplay, true);
            }
            catch (RemoteException e) {
                Log.e("MediaFocusControl", "Error connecting RCD to RCC in RCC registration", e);
            }
        }
    }

    private final void $$robo$$android_media_MediaFocusControl$enableRemoteControlDisplayForClient_syncRcStack(IRemoteControlDisplay rcd, boolean enabled) {
        for (PlayerRecord prse : this.mPRStack) {
            if (prse.getRcc() == null) continue;
            try {
                prse.getRcc().enableRemoteControlDisplay(rcd, enabled);
            }
            catch (RemoteException e) {
                Log.e("MediaFocusControl", "Error connecting RCD to client: ", e);
            }
        }
    }

    private final boolean $$robo$$android_media_MediaFocusControl$rcDisplayIsPluggedIn_syncRcStack(IRemoteControlDisplay rcd) {
        for (DisplayInfoForServer di : this.mRcDisplays) {
            if (!di.mRcDisplay.asBinder().equals(rcd.asBinder())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaFocusControl$registerRemoteControlDisplay_int(IRemoteControlDisplay rcd, int w, int h, ComponentName listenerComp) {
        Object object = mAudioFocusLock;
        synchronized (object) {
            Stack<PlayerRecord> stack = this.mPRStack;
            synchronized (stack) {
                if (rcd == null || this.rcDisplayIsPluggedIn_syncRcStack(rcd)) {
                    return;
                }
                DisplayInfoForServer di = new DisplayInfoForServer(this, rcd, w, h);
                di.mEnabled = true;
                di.mClientNotifListComp = listenerComp;
                if (!di.init()) {
                    return;
                }
                this.mRcDisplays.add(di);
                for (PlayerRecord prse : this.mPRStack) {
                    if (prse.getRcc() == null) continue;
                    try {
                        prse.getRcc().plugRemoteControlDisplay(rcd, w, h);
                    }
                    catch (RemoteException e) {
                        Log.e("MediaFocusControl", "Error connecting RCD to client: ", e);
                    }
                }
                MediaFocusControl.sendMsg(this.mEventHandler, 9, 2, w, h, rcd, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaFocusControl$unregisterRemoteControlDisplay(IRemoteControlDisplay rcd) {
        Stack<PlayerRecord> stack = this.mPRStack;
        synchronized (stack) {
            if (rcd == null) {
                return;
            }
            boolean displayWasPluggedIn = false;
            Iterator<DisplayInfoForServer> displayIterator = this.mRcDisplays.iterator();
            while (displayIterator.hasNext() && !displayWasPluggedIn) {
                DisplayInfoForServer di = displayIterator.next();
                if (!di.mRcDisplay.asBinder().equals(rcd.asBinder())) continue;
                displayWasPluggedIn = true;
                di.release();
                displayIterator.remove();
            }
            if (displayWasPluggedIn) {
                for (PlayerRecord prse : this.mPRStack) {
                    if (prse.getRcc() == null) continue;
                    try {
                        prse.getRcc().unplugRemoteControlDisplay(rcd);
                    }
                    catch (RemoteException e) {
                        Log.e("MediaFocusControl", "Error disconnecting remote control display to client: ", e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaFocusControl$remoteControlDisplayUsesBitmapSize(IRemoteControlDisplay rcd, int w, int h) {
        Stack<PlayerRecord> stack = this.mPRStack;
        synchronized (stack) {
            Iterator<DisplayInfoForServer> displayIterator = this.mRcDisplays.iterator();
            boolean artworkSizeUpdate = false;
            while (displayIterator.hasNext() && !artworkSizeUpdate) {
                DisplayInfoForServer di = displayIterator.next();
                if (!di.mRcDisplay.asBinder().equals(rcd.asBinder()) || di.mArtworkExpectedWidth == w && di.mArtworkExpectedHeight == h) continue;
                di.mArtworkExpectedWidth = w;
                di.mArtworkExpectedHeight = h;
                artworkSizeUpdate = true;
            }
            if (artworkSizeUpdate) {
                for (PlayerRecord prse : this.mPRStack) {
                    if (prse.getRcc() == null) continue;
                    try {
                        prse.getRcc().setBitmapSizeForDisplay(rcd, w, h);
                    }
                    catch (RemoteException e) {
                        Log.e("MediaFocusControl", "Error setting bitmap size for RCD on RCC: ", e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaFocusControl$remoteControlDisplayWantsPlaybackPositionSync(IRemoteControlDisplay rcd, boolean wantsSync) {
        Stack<PlayerRecord> stack = this.mPRStack;
        synchronized (stack) {
            boolean rcdRegistered = false;
            for (DisplayInfoForServer di : this.mRcDisplays) {
                if (!di.mRcDisplay.asBinder().equals(rcd.asBinder())) continue;
                di.mWantsPositionSync = wantsSync;
                rcdRegistered = true;
                break;
            }
            if (!rcdRegistered) {
                return;
            }
            for (PlayerRecord prse : this.mPRStack) {
                if (prse.getRcc() == null) continue;
                try {
                    prse.getRcc().setWantsSyncForDisplay(rcd, wantsSync);
                }
                catch (RemoteException e) {
                    Log.e("MediaFocusControl", "Error setting position sync flag for RCD on RCC: ", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaFocusControl$onRegisterVolumeObserverForRcc(int rccId, IRemoteVolumeObserver rvo) {
        Stack<PlayerRecord> stack = this.mPRStack;
        synchronized (stack) {
            try {
                for (int index = this.mPRStack.size() - 1; index >= 0; --index) {
                    PlayerRecord prse = (PlayerRecord)this.mPRStack.elementAt(index);
                    if (prse.getRccId() != rccId) continue;
                    prse.mRemoteVolumeObs = rvo;
                    break;
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                Log.e("MediaFocusControl", "Wrong index accessing media button stack, lock error? ", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_media_MediaFocusControl$checkUpdateRemoteStateIfActive(int streamType) {
        Object object = this.mPRStack;
        synchronized (object) {
            try {
                for (int index = this.mPRStack.size() - 1; index >= 0; --index) {
                    PlayerRecord prse = (PlayerRecord)this.mPRStack.elementAt(index);
                    if (prse.mPlaybackType != 1 || !MediaFocusControl.isPlaystateActive(prse.mPlaybackState.mState) || prse.mPlaybackStream != streamType) continue;
                    PlayerRecord.RemotePlaybackState remotePlaybackState = this.mMainRemote;
                    synchronized (remotePlaybackState) {
                        this.mMainRemote.mRccId = prse.getRccId();
                        this.mMainRemote.mVolume = prse.mPlaybackVolume;
                        this.mMainRemote.mVolumeMax = prse.mPlaybackVolumeMax;
                        this.mMainRemote.mVolumeHandling = prse.mPlaybackVolumeHandling;
                        this.mMainRemoteIsActive = true;
                    }
                    return true;
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                Log.e("MediaFocusControl", "Wrong index accessing RC stack, lock error? ", e);
            }
        }
        object = this.mMainRemote;
        synchronized (object) {
            this.mMainRemoteIsActive = false;
        }
        return false;
    }

    private static final boolean $$robo$$android_media_MediaFocusControl$isPlaystateActive(int playState) {
        switch (playState) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaFocusControl$sendVolumeUpdateToRemote(int rccId, int direction) {
        if (direction == 0) {
            return;
        }
        IRemoteVolumeObserver rvo = null;
        Stack<PlayerRecord> stack = this.mPRStack;
        synchronized (stack) {
            try {
                for (int index = this.mPRStack.size() - 1; index >= 0; --index) {
                    PlayerRecord prse = (PlayerRecord)this.mPRStack.elementAt(index);
                    if (prse.getRccId() != rccId) continue;
                    rvo = prse.mRemoteVolumeObs;
                    break;
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                Log.e("MediaFocusControl", "Wrong index accessing media button stack, lock error? ", e);
            }
        }
        if (rvo != null) {
            try {
                rvo.dispatchRemoteVolumeUpdate(direction, -1);
            }
            catch (RemoteException e) {
                Log.e("MediaFocusControl", "Error dispatching relative volume update", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_media_MediaFocusControl$getRemoteStreamMaxVolume() {
        PlayerRecord.RemotePlaybackState remotePlaybackState = this.mMainRemote;
        synchronized (remotePlaybackState) {
            if (this.mMainRemote.mRccId == -1) {
                return 0;
            }
            return this.mMainRemote.mVolumeMax;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_media_MediaFocusControl$getRemoteStreamVolume() {
        PlayerRecord.RemotePlaybackState remotePlaybackState = this.mMainRemote;
        synchronized (remotePlaybackState) {
            if (this.mMainRemote.mRccId == -1) {
                return 0;
            }
            return this.mMainRemote.mVolume;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaFocusControl$setRemoteStreamVolume(int vol) {
        int rccId = -1;
        PlayerRecord.RemotePlaybackState remotePlaybackState = this.mMainRemote;
        synchronized (remotePlaybackState) {
            if (this.mMainRemote.mRccId == -1) {
                return;
            }
            rccId = this.mMainRemote.mRccId;
        }
        IRemoteVolumeObserver rvo = null;
        Stack<PlayerRecord> stack = this.mPRStack;
        synchronized (stack) {
            try {
                for (int index = this.mPRStack.size() - 1; index >= 0; --index) {
                    PlayerRecord prse = (PlayerRecord)this.mPRStack.elementAt(index);
                    if (prse.getRccId() != rccId) continue;
                    rvo = prse.mRemoteVolumeObs;
                    break;
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                Log.e("MediaFocusControl", "Wrong index accessing media button stack, lock error? ", e);
            }
        }
        if (rvo != null) {
            try {
                rvo.dispatchRemoteVolumeUpdate(0, vol);
            }
            catch (RemoteException e) {
                Log.e("MediaFocusControl", "Error dispatching absolute volume update", e);
            }
        }
    }

    private final void $$robo$$android_media_MediaFocusControl$postReevaluateRemote() {
        MediaFocusControl.sendMsg(this.mEventHandler, 3, 2, 0, 0, null, 0);
    }

    private final void $$robo$$android_media_MediaFocusControl$onReevaluateRemote() {
    }

    static void __staticInitializer__() {
        ENABLED_NOTIFICATION_LISTENERS_URI = Settings.Secure.getUriFor("enabled_notification_listeners");
        mAudioFocusLock = new Object();
        mRingingLock = new Object();
    }

    private void __constructor__(Looper looper, Context context, AudioService.VolumeController volumeController, AudioService audioService) {
        this.$$robo$$android_media_MediaFocusControl$__constructor__(looper, context, volumeController, audioService);
    }

    protected MediaFocusControl(Looper looper, Context context, AudioService.VolumeController volumeController, AudioService audioService) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaFocusControl$__constructor__(android.os.Looper android.content.Context android.media.AudioService$VolumeController android.media.AudioService ), 0, this, looper, context, volumeController, audioService);
    }

    protected void dump(PrintWriter printWriter) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_media_MediaFocusControl$dump(java.io.PrintWriter ), 0, this, printWriter);
    }

    private int checkRcdRegistrationAuthorization(ComponentName componentName) {
        return (int)InvokeDynamicSupport.bootstrap("checkRcdRegistrationAuthorization", $$robo$$android_media_MediaFocusControl$checkRcdRegistrationAuthorization(android.content.ComponentName ), 0, this, componentName);
    }

    protected boolean registerRemoteController(IRemoteControlDisplay iRemoteControlDisplay, int n, int n2, ComponentName componentName) {
        return (boolean)InvokeDynamicSupport.bootstrap("registerRemoteController", $$robo$$android_media_MediaFocusControl$registerRemoteController(android.media.IRemoteControlDisplay int int android.content.ComponentName ), 0, this, iRemoteControlDisplay, n, n2, componentName);
    }

    protected boolean registerRemoteControlDisplay(IRemoteControlDisplay iRemoteControlDisplay, int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("registerRemoteControlDisplay", $$robo$$android_media_MediaFocusControl$registerRemoteControlDisplay(android.media.IRemoteControlDisplay int int ), 0, this, iRemoteControlDisplay, n, n2);
    }

    private void postReevaluateRemoteControlDisplays() {
        InvokeDynamicSupport.bootstrap("postReevaluateRemoteControlDisplays", $$robo$$android_media_MediaFocusControl$postReevaluateRemoteControlDisplays(), 0, this);
    }

    private void onReevaluateRemoteControlDisplays() {
        InvokeDynamicSupport.bootstrap("onReevaluateRemoteControlDisplays", $$robo$$android_media_MediaFocusControl$onReevaluateRemoteControlDisplays(), 0, this);
    }

    private boolean isComponentInStringArray(ComponentName componentName, String[] stringArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("isComponentInStringArray", $$robo$$android_media_MediaFocusControl$isComponentInStringArray(android.content.ComponentName java.lang.String[] ), 0, this, componentName, stringArray);
    }

    private static void sendMsg(Handler handler, int n, int n2, int n3, int n4, Object object, int n5) {
        InvokeDynamicSupport.bootstrapStatic("sendMsg", $$robo$$android_media_MediaFocusControl$sendMsg(android.os.Handler int int int int java.lang.Object int ), 0, (Handler)handler, (int)n, (int)n2, (int)n3, (int)n4, (Object)object, (int)n5);
    }

    protected void discardAudioFocusOwner() {
        InvokeDynamicSupport.bootstrap("discardAudioFocusOwner", $$robo$$android_media_MediaFocusControl$discardAudioFocusOwner(), 0, this);
    }

    private void notifyTopOfAudioFocusStack() {
        InvokeDynamicSupport.bootstrap("notifyTopOfAudioFocusStack", $$robo$$android_media_MediaFocusControl$notifyTopOfAudioFocusStack(), 0, this);
    }

    private void propagateFocusLossFromGain_syncAf(int n) {
        InvokeDynamicSupport.bootstrap("propagateFocusLossFromGain_syncAf", $$robo$$android_media_MediaFocusControl$propagateFocusLossFromGain_syncAf(int ), 0, this, n);
    }

    private void dumpFocusStack(PrintWriter printWriter) {
        InvokeDynamicSupport.bootstrap("dumpFocusStack", $$robo$$android_media_MediaFocusControl$dumpFocusStack(java.io.PrintWriter ), 0, this, printWriter);
    }

    private void removeFocusStackEntry(String string2, boolean bl) {
        InvokeDynamicSupport.bootstrap("removeFocusStackEntry", $$robo$$android_media_MediaFocusControl$removeFocusStackEntry(java.lang.String boolean ), 0, this, string2, bl);
    }

    private void removeFocusStackEntryForClient(IBinder iBinder) {
        InvokeDynamicSupport.bootstrap("removeFocusStackEntryForClient", $$robo$$android_media_MediaFocusControl$removeFocusStackEntryForClient(android.os.IBinder ), 0, this, iBinder);
    }

    private boolean canReassignAudioFocus() {
        return (boolean)InvokeDynamicSupport.bootstrap("canReassignAudioFocus", $$robo$$android_media_MediaFocusControl$canReassignAudioFocus(), 0, this);
    }

    protected int getCurrentAudioFocus() {
        return (int)InvokeDynamicSupport.bootstrap("getCurrentAudioFocus", $$robo$$android_media_MediaFocusControl$getCurrentAudioFocus(), 0, this);
    }

    protected int requestAudioFocus(int n, int n2, IBinder iBinder, IAudioFocusDispatcher iAudioFocusDispatcher, String string2, String string3) {
        return (int)InvokeDynamicSupport.bootstrap("requestAudioFocus", $$robo$$android_media_MediaFocusControl$requestAudioFocus(int int android.os.IBinder android.media.IAudioFocusDispatcher java.lang.String java.lang.String ), 0, this, n, n2, iBinder, iAudioFocusDispatcher, string2, string3);
    }

    protected int abandonAudioFocus(IAudioFocusDispatcher iAudioFocusDispatcher, String string2) {
        return (int)InvokeDynamicSupport.bootstrap("abandonAudioFocus", $$robo$$android_media_MediaFocusControl$abandonAudioFocus(android.media.IAudioFocusDispatcher java.lang.String ), 0, this, iAudioFocusDispatcher, string2);
    }

    protected void unregisterAudioFocusClient(String string2) {
        InvokeDynamicSupport.bootstrap("unregisterAudioFocusClient", $$robo$$android_media_MediaFocusControl$unregisterAudioFocusClient(java.lang.String ), 0, this, string2);
    }

    protected void dispatchMediaKeyEvent(KeyEvent keyEvent) {
        InvokeDynamicSupport.bootstrap("dispatchMediaKeyEvent", $$robo$$android_media_MediaFocusControl$dispatchMediaKeyEvent(android.view.KeyEvent ), 0, this, keyEvent);
    }

    protected void dispatchMediaKeyEventUnderWakelock(KeyEvent keyEvent) {
        InvokeDynamicSupport.bootstrap("dispatchMediaKeyEventUnderWakelock", $$robo$$android_media_MediaFocusControl$dispatchMediaKeyEventUnderWakelock(android.view.KeyEvent ), 0, this, keyEvent);
    }

    private void filterMediaKeyEvent(KeyEvent keyEvent, boolean bl) {
        InvokeDynamicSupport.bootstrap("filterMediaKeyEvent", $$robo$$android_media_MediaFocusControl$filterMediaKeyEvent(android.view.KeyEvent boolean ), 0, this, keyEvent, bl);
    }

    private void dispatchMediaKeyEventForCalls(KeyEvent keyEvent, boolean bl) {
        InvokeDynamicSupport.bootstrap("dispatchMediaKeyEventForCalls", $$robo$$android_media_MediaFocusControl$dispatchMediaKeyEventForCalls(android.view.KeyEvent boolean ), 0, this, keyEvent, bl);
    }

    private void dispatchMediaKeyEvent(KeyEvent keyEvent, boolean bl) {
        InvokeDynamicSupport.bootstrap("dispatchMediaKeyEvent", $$robo$$android_media_MediaFocusControl$dispatchMediaKeyEvent(android.view.KeyEvent boolean ), 0, this, keyEvent, bl);
    }

    private void filterVoiceInputKeyEvent(KeyEvent keyEvent, boolean bl) {
        InvokeDynamicSupport.bootstrap("filterVoiceInputKeyEvent", $$robo$$android_media_MediaFocusControl$filterVoiceInputKeyEvent(android.view.KeyEvent boolean ), 0, this, keyEvent, bl);
    }

    private void sendSimulatedMediaButtonEvent(KeyEvent keyEvent, boolean bl) {
        InvokeDynamicSupport.bootstrap("sendSimulatedMediaButtonEvent", $$robo$$android_media_MediaFocusControl$sendSimulatedMediaButtonEvent(android.view.KeyEvent boolean ), 0, this, keyEvent, bl);
    }

    private static boolean isValidMediaKeyEvent(KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidMediaKeyEvent", $$robo$$android_media_MediaFocusControl$isValidMediaKeyEvent(android.view.KeyEvent ), 0, (KeyEvent)keyEvent);
    }

    private static boolean isValidVoiceInputKeyCode(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidVoiceInputKeyCode", $$robo$$android_media_MediaFocusControl$isValidVoiceInputKeyCode(int ), 0, (int)n);
    }

    private void startVoiceBasedInteractions(boolean bl) {
        InvokeDynamicSupport.bootstrap("startVoiceBasedInteractions", $$robo$$android_media_MediaFocusControl$startVoiceBasedInteractions(boolean ), 0, this, bl);
    }

    @Override
    public void onSendFinished(PendingIntent pendingIntent, Intent intent, int n, String string2, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("onSendFinished", $$robo$$android_media_MediaFocusControl$onSendFinished(android.app.PendingIntent android.content.Intent int java.lang.String android.os.Bundle ), 0, this, pendingIntent, intent, n, string2, bundle);
    }

    private void dumpRCStack(PrintWriter printWriter) {
        InvokeDynamicSupport.bootstrap("dumpRCStack", $$robo$$android_media_MediaFocusControl$dumpRCStack(java.io.PrintWriter ), 0, this, printWriter);
    }

    private void dumpRCCStack(PrintWriter printWriter) {
        InvokeDynamicSupport.bootstrap("dumpRCCStack", $$robo$$android_media_MediaFocusControl$dumpRCCStack(java.io.PrintWriter ), 0, this, printWriter);
    }

    private void dumpRCDList(PrintWriter printWriter) {
        InvokeDynamicSupport.bootstrap("dumpRCDList", $$robo$$android_media_MediaFocusControl$dumpRCDList(java.io.PrintWriter ), 0, this, printWriter);
    }

    private boolean pushMediaButtonReceiver_syncPrs(PendingIntent pendingIntent, ComponentName componentName, IBinder iBinder) {
        return (boolean)InvokeDynamicSupport.bootstrap("pushMediaButtonReceiver_syncPrs", $$robo$$android_media_MediaFocusControl$pushMediaButtonReceiver_syncPrs(android.app.PendingIntent android.content.ComponentName android.os.IBinder ), 0, this, pendingIntent, componentName, iBinder);
    }

    private void removeMediaButtonReceiver_syncPrs(PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("removeMediaButtonReceiver_syncPrs", $$robo$$android_media_MediaFocusControl$removeMediaButtonReceiver_syncPrs(android.app.PendingIntent ), 0, this, pendingIntent);
    }

    private boolean isCurrentRcController(PendingIntent pendingIntent) {
        return (boolean)InvokeDynamicSupport.bootstrap("isCurrentRcController", $$robo$$android_media_MediaFocusControl$isCurrentRcController(android.app.PendingIntent ), 0, this, pendingIntent);
    }

    private void setNewRcClientOnDisplays_syncRcsCurrc(int n, PendingIntent pendingIntent, boolean bl) {
        InvokeDynamicSupport.bootstrap("setNewRcClientOnDisplays_syncRcsCurrc", $$robo$$android_media_MediaFocusControl$setNewRcClientOnDisplays_syncRcsCurrc(int android.app.PendingIntent boolean ), 0, this, n, pendingIntent, bl);
    }

    private void setNewRcClientGenerationOnClients_syncRcsCurrc(int n) {
        InvokeDynamicSupport.bootstrap("setNewRcClientGenerationOnClients_syncRcsCurrc", $$robo$$android_media_MediaFocusControl$setNewRcClientGenerationOnClients_syncRcsCurrc(int ), 0, this, n);
    }

    private void setNewRcClient_syncRcsCurrc(int n, PendingIntent pendingIntent, boolean bl) {
        InvokeDynamicSupport.bootstrap("setNewRcClient_syncRcsCurrc", $$robo$$android_media_MediaFocusControl$setNewRcClient_syncRcsCurrc(int android.app.PendingIntent boolean ), 0, this, n, pendingIntent, bl);
    }

    private void onRcDisplayClear() {
        InvokeDynamicSupport.bootstrap("onRcDisplayClear", $$robo$$android_media_MediaFocusControl$onRcDisplayClear(), 0, this);
    }

    private void onRcDisplayUpdate(PlayerRecord playerRecord, int n) {
        InvokeDynamicSupport.bootstrap("onRcDisplayUpdate", $$robo$$android_media_MediaFocusControl$onRcDisplayUpdate(android.media.PlayerRecord int ), 0, this, playerRecord, n);
    }

    private void onRcDisplayInitInfo(IRemoteControlDisplay iRemoteControlDisplay, int n, int n2) {
        InvokeDynamicSupport.bootstrap("onRcDisplayInitInfo", $$robo$$android_media_MediaFocusControl$onRcDisplayInitInfo(android.media.IRemoteControlDisplay int int ), 0, this, iRemoteControlDisplay, n, n2);
    }

    private void clearRemoteControlDisplay_syncPrs() {
        InvokeDynamicSupport.bootstrap("clearRemoteControlDisplay_syncPrs", $$robo$$android_media_MediaFocusControl$clearRemoteControlDisplay_syncPrs(), 0, this);
    }

    private void updateRemoteControlDisplay_syncPrs(int n) {
        InvokeDynamicSupport.bootstrap("updateRemoteControlDisplay_syncPrs", $$robo$$android_media_MediaFocusControl$updateRemoteControlDisplay_syncPrs(int ), 0, this, n);
    }

    private void checkUpdateRemoteControlDisplay_syncPrs(int n) {
        InvokeDynamicSupport.bootstrap("checkUpdateRemoteControlDisplay_syncPrs", $$robo$$android_media_MediaFocusControl$checkUpdateRemoteControlDisplay_syncPrs(int ), 0, this, n);
    }

    protected void registerMediaButtonIntent(PendingIntent pendingIntent, ComponentName componentName, IBinder iBinder) {
        InvokeDynamicSupport.bootstrap("registerMediaButtonIntent", $$robo$$android_media_MediaFocusControl$registerMediaButtonIntent(android.app.PendingIntent android.content.ComponentName android.os.IBinder ), 0, this, pendingIntent, componentName, iBinder);
    }

    protected void unregisterMediaButtonIntent(PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("unregisterMediaButtonIntent", $$robo$$android_media_MediaFocusControl$unregisterMediaButtonIntent(android.app.PendingIntent ), 0, this, pendingIntent);
    }

    protected void unregisterMediaButtonIntentAsync(PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("unregisterMediaButtonIntentAsync", $$robo$$android_media_MediaFocusControl$unregisterMediaButtonIntentAsync(android.app.PendingIntent ), 0, this, pendingIntent);
    }

    protected void registerMediaButtonEventReceiverForCalls(ComponentName componentName) {
        InvokeDynamicSupport.bootstrap("registerMediaButtonEventReceiverForCalls", $$robo$$android_media_MediaFocusControl$registerMediaButtonEventReceiverForCalls(android.content.ComponentName ), 0, this, componentName);
    }

    protected void unregisterMediaButtonEventReceiverForCalls() {
        InvokeDynamicSupport.bootstrap("unregisterMediaButtonEventReceiverForCalls", $$robo$$android_media_MediaFocusControl$unregisterMediaButtonEventReceiverForCalls(), 0, this);
    }

    protected int registerRemoteControlClient(PendingIntent pendingIntent, IRemoteControlClient iRemoteControlClient, String string2) {
        return (int)InvokeDynamicSupport.bootstrap("registerRemoteControlClient", $$robo$$android_media_MediaFocusControl$registerRemoteControlClient(android.app.PendingIntent android.media.IRemoteControlClient java.lang.String ), 0, this, pendingIntent, iRemoteControlClient, string2);
    }

    protected void unregisterRemoteControlClient(PendingIntent pendingIntent, IRemoteControlClient iRemoteControlClient) {
        InvokeDynamicSupport.bootstrap("unregisterRemoteControlClient", $$robo$$android_media_MediaFocusControl$unregisterRemoteControlClient(android.app.PendingIntent android.media.IRemoteControlClient ), 0, this, pendingIntent, iRemoteControlClient);
    }

    private void plugRemoteControlDisplaysIntoClient_syncPrs(IRemoteControlClient iRemoteControlClient) {
        InvokeDynamicSupport.bootstrap("plugRemoteControlDisplaysIntoClient_syncPrs", $$robo$$android_media_MediaFocusControl$plugRemoteControlDisplaysIntoClient_syncPrs(android.media.IRemoteControlClient ), 0, this, iRemoteControlClient);
    }

    private void enableRemoteControlDisplayForClient_syncRcStack(IRemoteControlDisplay iRemoteControlDisplay, boolean bl) {
        InvokeDynamicSupport.bootstrap("enableRemoteControlDisplayForClient_syncRcStack", $$robo$$android_media_MediaFocusControl$enableRemoteControlDisplayForClient_syncRcStack(android.media.IRemoteControlDisplay boolean ), 0, this, iRemoteControlDisplay, bl);
    }

    private boolean rcDisplayIsPluggedIn_syncRcStack(IRemoteControlDisplay iRemoteControlDisplay) {
        return (boolean)InvokeDynamicSupport.bootstrap("rcDisplayIsPluggedIn_syncRcStack", $$robo$$android_media_MediaFocusControl$rcDisplayIsPluggedIn_syncRcStack(android.media.IRemoteControlDisplay ), 0, this, iRemoteControlDisplay);
    }

    private void registerRemoteControlDisplay_int(IRemoteControlDisplay iRemoteControlDisplay, int n, int n2, ComponentName componentName) {
        InvokeDynamicSupport.bootstrap("registerRemoteControlDisplay_int", $$robo$$android_media_MediaFocusControl$registerRemoteControlDisplay_int(android.media.IRemoteControlDisplay int int android.content.ComponentName ), 0, this, iRemoteControlDisplay, n, n2, componentName);
    }

    protected void unregisterRemoteControlDisplay(IRemoteControlDisplay iRemoteControlDisplay) {
        InvokeDynamicSupport.bootstrap("unregisterRemoteControlDisplay", $$robo$$android_media_MediaFocusControl$unregisterRemoteControlDisplay(android.media.IRemoteControlDisplay ), 0, this, iRemoteControlDisplay);
    }

    protected void remoteControlDisplayUsesBitmapSize(IRemoteControlDisplay iRemoteControlDisplay, int n, int n2) {
        InvokeDynamicSupport.bootstrap("remoteControlDisplayUsesBitmapSize", $$robo$$android_media_MediaFocusControl$remoteControlDisplayUsesBitmapSize(android.media.IRemoteControlDisplay int int ), 0, this, iRemoteControlDisplay, n, n2);
    }

    protected void remoteControlDisplayWantsPlaybackPositionSync(IRemoteControlDisplay iRemoteControlDisplay, boolean bl) {
        InvokeDynamicSupport.bootstrap("remoteControlDisplayWantsPlaybackPositionSync", $$robo$$android_media_MediaFocusControl$remoteControlDisplayWantsPlaybackPositionSync(android.media.IRemoteControlDisplay boolean ), 0, this, iRemoteControlDisplay, bl);
    }

    private void onRegisterVolumeObserverForRcc(int n, IRemoteVolumeObserver iRemoteVolumeObserver) {
        InvokeDynamicSupport.bootstrap("onRegisterVolumeObserverForRcc", $$robo$$android_media_MediaFocusControl$onRegisterVolumeObserverForRcc(int android.media.IRemoteVolumeObserver ), 0, this, n, iRemoteVolumeObserver);
    }

    protected boolean checkUpdateRemoteStateIfActive(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("checkUpdateRemoteStateIfActive", $$robo$$android_media_MediaFocusControl$checkUpdateRemoteStateIfActive(int ), 0, this, n);
    }

    protected static boolean isPlaystateActive(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isPlaystateActive", $$robo$$android_media_MediaFocusControl$isPlaystateActive(int ), 0, (int)n);
    }

    private void sendVolumeUpdateToRemote(int n, int n2) {
        InvokeDynamicSupport.bootstrap("sendVolumeUpdateToRemote", $$robo$$android_media_MediaFocusControl$sendVolumeUpdateToRemote(int int ), 0, this, n, n2);
    }

    protected int getRemoteStreamMaxVolume() {
        return (int)InvokeDynamicSupport.bootstrap("getRemoteStreamMaxVolume", $$robo$$android_media_MediaFocusControl$getRemoteStreamMaxVolume(), 0, this);
    }

    protected int getRemoteStreamVolume() {
        return (int)InvokeDynamicSupport.bootstrap("getRemoteStreamVolume", $$robo$$android_media_MediaFocusControl$getRemoteStreamVolume(), 0, this);
    }

    protected void setRemoteStreamVolume(int n) {
        InvokeDynamicSupport.bootstrap("setRemoteStreamVolume", $$robo$$android_media_MediaFocusControl$setRemoteStreamVolume(int ), 0, this, n);
    }

    protected void postReevaluateRemote() {
        InvokeDynamicSupport.bootstrap("postReevaluateRemote", $$robo$$android_media_MediaFocusControl$postReevaluateRemote(), 0, this);
    }

    private void onReevaluateRemote() {
        InvokeDynamicSupport.bootstrap("onReevaluateRemote", $$robo$$android_media_MediaFocusControl$onReevaluateRemote(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(MediaFocusControl.class);
    }

    public /* synthetic */ MediaFocusControl() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MediaFocusControl)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class DisplayInfoForServer
    implements IBinder.DeathRecipient,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private IRemoteControlDisplay mRcDisplay;
        private IBinder mRcDisplayBinder;
        private int mArtworkExpectedWidth;
        private int mArtworkExpectedHeight;
        private boolean mWantsPositionSync;
        private ComponentName mClientNotifListComp;
        private boolean mEnabled;
        /* synthetic */ MediaFocusControl this$0;

        private void $$robo$$android_media_MediaFocusControl_DisplayInfoForServer$__constructor__(MediaFocusControl mediaFocusControl, IRemoteControlDisplay rcd, int w, int h) {
            this.mArtworkExpectedWidth = -1;
            this.mArtworkExpectedHeight = -1;
            this.mWantsPositionSync = false;
            this.mEnabled = true;
            this.mRcDisplay = rcd;
            this.mRcDisplayBinder = rcd.asBinder();
            this.mArtworkExpectedWidth = w;
            this.mArtworkExpectedHeight = h;
        }

        private final boolean $$robo$$android_media_MediaFocusControl_DisplayInfoForServer$init() {
            try {
                this.mRcDisplayBinder.linkToDeath(this, 0);
            }
            catch (RemoteException e) {
                Log.w("MediaFocusControl", "registerRemoteControlDisplay() has a dead client " + this.mRcDisplayBinder);
                return false;
            }
            return true;
        }

        private final void $$robo$$android_media_MediaFocusControl_DisplayInfoForServer$release() {
            try {
                this.mRcDisplayBinder.unlinkToDeath(this, 0);
            }
            catch (NoSuchElementException e) {
                Log.e("MediaFocusControl", "Error in DisplaInfoForServer.relase()", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_MediaFocusControl_DisplayInfoForServer$binderDied() {
            Stack stack = this.this$0.mPRStack;
            synchronized (stack) {
                Log.w("MediaFocusControl", "RemoteControl: display " + this.mRcDisplay + " died");
                Iterator displayIterator = this.this$0.mRcDisplays.iterator();
                while (displayIterator.hasNext()) {
                    DisplayInfoForServer di = (DisplayInfoForServer)displayIterator.next();
                    if (di.mRcDisplay != this.mRcDisplay) continue;
                    displayIterator.remove();
                    return;
                }
            }
        }

        private void __constructor__(MediaFocusControl mediaFocusControl, IRemoteControlDisplay iRemoteControlDisplay, int n, int n2) {
            this.$$robo$$android_media_MediaFocusControl_DisplayInfoForServer$__constructor__(mediaFocusControl, iRemoteControlDisplay, n, n2);
        }

        public DisplayInfoForServer(MediaFocusControl mediaFocusControl, IRemoteControlDisplay iRemoteControlDisplay, int n, int n2) {
            this.this$0 = mediaFocusControl;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaFocusControl_DisplayInfoForServer$__constructor__(android.media.MediaFocusControl android.media.IRemoteControlDisplay int int ), 0, this, mediaFocusControl, iRemoteControlDisplay, n, n2);
        }

        public boolean init() {
            return (boolean)InvokeDynamicSupport.bootstrap("init", $$robo$$android_media_MediaFocusControl_DisplayInfoForServer$init(), 0, this);
        }

        public void release() {
            InvokeDynamicSupport.bootstrap("release", $$robo$$android_media_MediaFocusControl_DisplayInfoForServer$release(), 0, this);
        }

        @Override
        public void binderDied() {
            InvokeDynamicSupport.bootstrap("binderDied", $$robo$$android_media_MediaFocusControl_DisplayInfoForServer$binderDied(), 0, this);
        }

        public /* synthetic */ DisplayInfoForServer() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DisplayInfoForServer)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    protected class AudioFocusDeathHandler
    implements IBinder.DeathRecipient,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private IBinder mCb;
        /* synthetic */ MediaFocusControl this$0;

        private void $$robo$$android_media_MediaFocusControl_AudioFocusDeathHandler$__constructor__(MediaFocusControl mediaFocusControl, IBinder cb) {
            this.mCb = cb;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_MediaFocusControl_AudioFocusDeathHandler$binderDied() {
            Object object = mAudioFocusLock;
            synchronized (object) {
                Log.w("MediaFocusControl", "  AudioFocus   audio focus client died");
                this.this$0.removeFocusStackEntryForClient(this.mCb);
            }
        }

        private final IBinder $$robo$$android_media_MediaFocusControl_AudioFocusDeathHandler$getBinder() {
            return this.mCb;
        }

        private void __constructor__(MediaFocusControl mediaFocusControl, IBinder iBinder) {
            this.$$robo$$android_media_MediaFocusControl_AudioFocusDeathHandler$__constructor__(mediaFocusControl, iBinder);
        }

        AudioFocusDeathHandler(MediaFocusControl mediaFocusControl, IBinder iBinder) {
            this.this$0 = mediaFocusControl;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaFocusControl_AudioFocusDeathHandler$__constructor__(android.media.MediaFocusControl android.os.IBinder ), 0, this, mediaFocusControl, iBinder);
        }

        @Override
        public void binderDied() {
            InvokeDynamicSupport.bootstrap("binderDied", $$robo$$android_media_MediaFocusControl_AudioFocusDeathHandler$binderDied(), 0, this);
        }

        public IBinder getBinder() {
            return InvokeDynamicSupport.bootstrap("getBinder", $$robo$$android_media_MediaFocusControl_AudioFocusDeathHandler$getBinder(), 0, this);
        }

        public /* synthetic */ AudioFocusDeathHandler() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AudioFocusDeathHandler)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class MediaEventHandler
    extends Handler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ MediaFocusControl this$0;

        private void $$robo$$android_media_MediaFocusControl_MediaEventHandler$__constructor__(MediaFocusControl mediaFocusControl, Looper looper) {
        }

        private final void $$robo$$android_media_MediaFocusControl_MediaEventHandler$handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    this.this$0.onRcDisplayClear();
                    break;
                }
                case 2: {
                    this.this$0.onRcDisplayUpdate((PlayerRecord)msg.obj, msg.arg1);
                    break;
                }
                case 3: {
                    this.this$0.onReevaluateRemote();
                    break;
                }
                case 5: {
                    this.this$0.onRegisterVolumeObserverForRcc(msg.arg1, (IRemoteVolumeObserver)msg.obj);
                    break;
                }
                case 9: {
                    this.this$0.onRcDisplayInitInfo((IRemoteControlDisplay)msg.obj, msg.arg1, msg.arg2);
                    break;
                }
                case 10: {
                    this.this$0.onReevaluateRemoteControlDisplays();
                    break;
                }
                case 11: {
                    this.this$0.unregisterMediaButtonIntent((PendingIntent)msg.obj);
                }
            }
        }

        private void __constructor__(MediaFocusControl mediaFocusControl, Looper looper) {
            this.$$robo$$android_media_MediaFocusControl_MediaEventHandler$__constructor__(mediaFocusControl, looper);
        }

        MediaEventHandler(MediaFocusControl mediaFocusControl, Looper looper) {
            this.this$0 = mediaFocusControl;
            super(looper);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaFocusControl_MediaEventHandler$__constructor__(android.media.MediaFocusControl android.os.Looper ), 0, this, mediaFocusControl, looper);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_media_MediaFocusControl_MediaEventHandler$handleMessage(android.os.Message ), 0, this, message);
        }

        public /* synthetic */ MediaEventHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MediaEventHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class NotificationListenerObserver
    extends ContentObserver
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ MediaFocusControl this$0;

        private void $$robo$$android_media_MediaFocusControl_NotificationListenerObserver$__constructor__(MediaFocusControl mediaFocusControl) {
            mediaFocusControl.mContentResolver.registerContentObserver(Settings.Secure.getUriFor("enabled_notification_listeners"), false, this);
        }

        private final void $$robo$$android_media_MediaFocusControl_NotificationListenerObserver$onChange(boolean selfChange, Uri uri) {
            if (!ENABLED_NOTIFICATION_LISTENERS_URI.equals(uri) || selfChange) {
                return;
            }
            this.this$0.postReevaluateRemoteControlDisplays();
        }

        private void __constructor__(MediaFocusControl mediaFocusControl) {
            this.$$robo$$android_media_MediaFocusControl_NotificationListenerObserver$__constructor__(mediaFocusControl);
        }

        NotificationListenerObserver(MediaFocusControl mediaFocusControl) {
            this.this$0 = mediaFocusControl;
            super(mediaFocusControl.mEventHandler);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaFocusControl_NotificationListenerObserver$__constructor__(android.media.MediaFocusControl ), 0, this, mediaFocusControl);
        }

        @Override
        public void onChange(boolean bl, Uri uri) {
            InvokeDynamicSupport.bootstrap("onChange", $$robo$$android_media_MediaFocusControl_NotificationListenerObserver$onChange(boolean android.net.Uri ), 0, this, bl, uri);
        }

        public /* synthetic */ NotificationListenerObserver() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NotificationListenerObserver)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

