/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.graphics.Bitmap;
import android.media.MediaDescription;
import android.media.Rating;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.Log;
import android.util.SparseArray;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Set;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class MediaMetadata
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "MediaMetadata";
    public static String METADATA_KEY_TITLE = "android.media.metadata.TITLE";
    public static String METADATA_KEY_ARTIST = "android.media.metadata.ARTIST";
    public static String METADATA_KEY_DURATION = "android.media.metadata.DURATION";
    public static String METADATA_KEY_ALBUM = "android.media.metadata.ALBUM";
    public static String METADATA_KEY_AUTHOR = "android.media.metadata.AUTHOR";
    public static String METADATA_KEY_WRITER = "android.media.metadata.WRITER";
    public static String METADATA_KEY_COMPOSER = "android.media.metadata.COMPOSER";
    public static String METADATA_KEY_COMPILATION = "android.media.metadata.COMPILATION";
    public static String METADATA_KEY_DATE = "android.media.metadata.DATE";
    public static String METADATA_KEY_YEAR = "android.media.metadata.YEAR";
    public static String METADATA_KEY_GENRE = "android.media.metadata.GENRE";
    public static String METADATA_KEY_TRACK_NUMBER = "android.media.metadata.TRACK_NUMBER";
    public static String METADATA_KEY_NUM_TRACKS = "android.media.metadata.NUM_TRACKS";
    public static String METADATA_KEY_DISC_NUMBER = "android.media.metadata.DISC_NUMBER";
    public static String METADATA_KEY_ALBUM_ARTIST = "android.media.metadata.ALBUM_ARTIST";
    public static String METADATA_KEY_ART = "android.media.metadata.ART";
    public static String METADATA_KEY_ART_URI = "android.media.metadata.ART_URI";
    public static String METADATA_KEY_ALBUM_ART = "android.media.metadata.ALBUM_ART";
    public static String METADATA_KEY_ALBUM_ART_URI = "android.media.metadata.ALBUM_ART_URI";
    public static String METADATA_KEY_USER_RATING = "android.media.metadata.USER_RATING";
    public static String METADATA_KEY_RATING = "android.media.metadata.RATING";
    public static String METADATA_KEY_DISPLAY_TITLE = "android.media.metadata.DISPLAY_TITLE";
    public static String METADATA_KEY_DISPLAY_SUBTITLE = "android.media.metadata.DISPLAY_SUBTITLE";
    public static String METADATA_KEY_DISPLAY_DESCRIPTION = "android.media.metadata.DISPLAY_DESCRIPTION";
    public static String METADATA_KEY_DISPLAY_ICON = "android.media.metadata.DISPLAY_ICON";
    public static String METADATA_KEY_DISPLAY_ICON_URI = "android.media.metadata.DISPLAY_ICON_URI";
    public static String METADATA_KEY_MEDIA_ID = "android.media.metadata.MEDIA_ID";
    private static String[] PREFERRED_DESCRIPTION_ORDER;
    private static String[] PREFERRED_BITMAP_ORDER;
    private static String[] PREFERRED_URI_ORDER;
    private static int METADATA_TYPE_INVALID = -1;
    private static int METADATA_TYPE_LONG = 0;
    private static int METADATA_TYPE_TEXT = 1;
    private static int METADATA_TYPE_BITMAP = 2;
    private static int METADATA_TYPE_RATING = 3;
    private static ArrayMap<String, Integer> METADATA_KEYS_TYPE;
    private static SparseArray<String> EDITOR_KEY_MAPPING;
    private Bundle mBundle;
    private MediaDescription mDescription;
    public static Parcelable.Creator<MediaMetadata> CREATOR;

    private void $$robo$$android_media_MediaMetadata$__constructor__(Bundle bundle) {
        this.mBundle = new Bundle(bundle);
    }

    private void $$robo$$android_media_MediaMetadata$__constructor__(Parcel in) {
        this.mBundle = in.readBundle();
    }

    private final boolean $$robo$$android_media_MediaMetadata$containsKey(String key) {
        return this.mBundle.containsKey(key);
    }

    private final CharSequence $$robo$$android_media_MediaMetadata$getText(String key) {
        return this.mBundle.getCharSequence(key);
    }

    private final String $$robo$$android_media_MediaMetadata$getString(String key) {
        CharSequence text = this.getText(key);
        if (text != null) {
            return text.toString();
        }
        return null;
    }

    private final long $$robo$$android_media_MediaMetadata$getLong(String key) {
        return this.mBundle.getLong(key, 0L);
    }

    private final Rating $$robo$$android_media_MediaMetadata$getRating(String key) {
        Rating rating = null;
        try {
            rating = (Rating)this.mBundle.getParcelable(key);
        }
        catch (Exception e) {
            Log.w("MediaMetadata", "Failed to retrieve a key as Rating.", e);
        }
        return rating;
    }

    private final Bitmap $$robo$$android_media_MediaMetadata$getBitmap(String key) {
        Bitmap bmp = null;
        try {
            bmp = (Bitmap)this.mBundle.getParcelable(key);
        }
        catch (Exception e) {
            Log.w("MediaMetadata", "Failed to retrieve a key as Bitmap.", e);
        }
        return bmp;
    }

    private final int $$robo$$android_media_MediaMetadata$describeContents() {
        return 0;
    }

    private final void $$robo$$android_media_MediaMetadata$writeToParcel(Parcel dest, int flags) {
        dest.writeBundle(this.mBundle);
    }

    private final int $$robo$$android_media_MediaMetadata$size() {
        return this.mBundle.size();
    }

    private final Set<String> $$robo$$android_media_MediaMetadata$keySet() {
        return this.mBundle.keySet();
    }

    private final MediaDescription $$robo$$android_media_MediaMetadata$getDescription() {
        int i;
        if (this.mDescription != null) {
            return this.mDescription;
        }
        String mediaId = this.getString("android.media.metadata.MEDIA_ID");
        CharSequence[] text = new CharSequence[3];
        Bitmap icon = null;
        Uri iconUri = null;
        CharSequence displayText = this.getText("android.media.metadata.DISPLAY_TITLE");
        if (!TextUtils.isEmpty(displayText)) {
            text[0] = displayText;
            text[1] = this.getText("android.media.metadata.DISPLAY_SUBTITLE");
            text[2] = this.getText("android.media.metadata.DISPLAY_DESCRIPTION");
        } else {
            int textIndex = 0;
            int keyIndex = 0;
            while (textIndex < text.length && keyIndex < PREFERRED_DESCRIPTION_ORDER.length) {
                CharSequence next;
                if (TextUtils.isEmpty(next = this.getText(PREFERRED_DESCRIPTION_ORDER[keyIndex++]))) continue;
                text[textIndex++] = next;
            }
        }
        for (i = 0; i < PREFERRED_BITMAP_ORDER.length; ++i) {
            Bitmap next = this.getBitmap(PREFERRED_BITMAP_ORDER[i]);
            if (next == null) continue;
            icon = next;
            break;
        }
        for (i = 0; i < PREFERRED_URI_ORDER.length; ++i) {
            String next = this.getString(PREFERRED_URI_ORDER[i]);
            if (TextUtils.isEmpty(next)) continue;
            iconUri = Uri.parse(next);
            break;
        }
        MediaDescription.Builder bob = new MediaDescription.Builder();
        bob.setMediaId(mediaId);
        bob.setTitle(text[0]);
        bob.setSubtitle(text[1]);
        bob.setDescription(text[2]);
        bob.setIconBitmap(icon);
        bob.setIconUri(iconUri);
        this.mDescription = bob.build();
        return this.mDescription;
    }

    private static final String $$robo$$android_media_MediaMetadata$getKeyFromMetadataEditorKey(int editorKey) {
        return EDITOR_KEY_MAPPING.get(editorKey, null);
    }

    private /* synthetic */ void $$robo$$android_media_MediaMetadata$__constructor__(Parcel x0, 1 x1) {
    }

    private /* synthetic */ void $$robo$$android_media_MediaMetadata$__constructor__(Bundle x0, 1 x1) {
    }

    static void __staticInitializer__() {
        PREFERRED_DESCRIPTION_ORDER = new String[]{"android.media.metadata.TITLE", "android.media.metadata.ARTIST", "android.media.metadata.ALBUM", "android.media.metadata.ALBUM_ARTIST", "android.media.metadata.WRITER", "android.media.metadata.AUTHOR", "android.media.metadata.COMPOSER"};
        PREFERRED_BITMAP_ORDER = new String[]{"android.media.metadata.DISPLAY_ICON", "android.media.metadata.ART", "android.media.metadata.ALBUM_ART"};
        PREFERRED_URI_ORDER = new String[]{"android.media.metadata.DISPLAY_ICON_URI", "android.media.metadata.ART_URI", "android.media.metadata.ALBUM_ART_URI"};
        METADATA_KEYS_TYPE = new ArrayMap();
        METADATA_KEYS_TYPE.put("android.media.metadata.TITLE", 1);
        METADATA_KEYS_TYPE.put("android.media.metadata.ARTIST", 1);
        METADATA_KEYS_TYPE.put("android.media.metadata.DURATION", 0);
        METADATA_KEYS_TYPE.put("android.media.metadata.ALBUM", 1);
        METADATA_KEYS_TYPE.put("android.media.metadata.AUTHOR", 1);
        METADATA_KEYS_TYPE.put("android.media.metadata.WRITER", 1);
        METADATA_KEYS_TYPE.put("android.media.metadata.COMPOSER", 1);
        METADATA_KEYS_TYPE.put("android.media.metadata.COMPILATION", 1);
        METADATA_KEYS_TYPE.put("android.media.metadata.DATE", 1);
        METADATA_KEYS_TYPE.put("android.media.metadata.YEAR", 0);
        METADATA_KEYS_TYPE.put("android.media.metadata.GENRE", 1);
        METADATA_KEYS_TYPE.put("android.media.metadata.TRACK_NUMBER", 0);
        METADATA_KEYS_TYPE.put("android.media.metadata.NUM_TRACKS", 0);
        METADATA_KEYS_TYPE.put("android.media.metadata.DISC_NUMBER", 0);
        METADATA_KEYS_TYPE.put("android.media.metadata.ALBUM_ARTIST", 1);
        METADATA_KEYS_TYPE.put("android.media.metadata.ART", 2);
        METADATA_KEYS_TYPE.put("android.media.metadata.ART_URI", 1);
        METADATA_KEYS_TYPE.put("android.media.metadata.ALBUM_ART", 2);
        METADATA_KEYS_TYPE.put("android.media.metadata.ALBUM_ART_URI", 1);
        METADATA_KEYS_TYPE.put("android.media.metadata.USER_RATING", 3);
        METADATA_KEYS_TYPE.put("android.media.metadata.RATING", 3);
        METADATA_KEYS_TYPE.put("android.media.metadata.DISPLAY_TITLE", 1);
        METADATA_KEYS_TYPE.put("android.media.metadata.DISPLAY_SUBTITLE", 1);
        METADATA_KEYS_TYPE.put("android.media.metadata.DISPLAY_DESCRIPTION", 1);
        METADATA_KEYS_TYPE.put("android.media.metadata.DISPLAY_ICON", 2);
        METADATA_KEYS_TYPE.put("android.media.metadata.DISPLAY_ICON_URI", 1);
        EDITOR_KEY_MAPPING = new SparseArray();
        EDITOR_KEY_MAPPING.put(100, "android.media.metadata.ART");
        EDITOR_KEY_MAPPING.put(101, "android.media.metadata.RATING");
        EDITOR_KEY_MAPPING.put(0x10000001, "android.media.metadata.USER_RATING");
        EDITOR_KEY_MAPPING.put(1, "android.media.metadata.ALBUM");
        EDITOR_KEY_MAPPING.put(13, "android.media.metadata.ALBUM_ARTIST");
        EDITOR_KEY_MAPPING.put(2, "android.media.metadata.ARTIST");
        EDITOR_KEY_MAPPING.put(3, "android.media.metadata.AUTHOR");
        EDITOR_KEY_MAPPING.put(0, "android.media.metadata.TRACK_NUMBER");
        EDITOR_KEY_MAPPING.put(4, "android.media.metadata.COMPOSER");
        EDITOR_KEY_MAPPING.put(15, "android.media.metadata.COMPILATION");
        EDITOR_KEY_MAPPING.put(5, "android.media.metadata.DATE");
        EDITOR_KEY_MAPPING.put(14, "android.media.metadata.DISC_NUMBER");
        EDITOR_KEY_MAPPING.put(9, "android.media.metadata.DURATION");
        EDITOR_KEY_MAPPING.put(6, "android.media.metadata.GENRE");
        EDITOR_KEY_MAPPING.put(10, "android.media.metadata.NUM_TRACKS");
        EDITOR_KEY_MAPPING.put(7, "android.media.metadata.TITLE");
        EDITOR_KEY_MAPPING.put(11, "android.media.metadata.WRITER");
        EDITOR_KEY_MAPPING.put(8, "android.media.metadata.YEAR");
        CREATOR = new Parcelable.Creator<MediaMetadata>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_media_MediaMetadata_1$__constructor__() {
            }

            private final MediaMetadata $$robo$$android_media_MediaMetadata_1$createFromParcel(Parcel in) {
                return new MediaMetadata(in);
            }

            private final MediaMetadata[] $$robo$$android_media_MediaMetadata_1$newArray(int size) {
                return new MediaMetadata[size];
            }

            private void __constructor__() {
                this.$$robo$$android_media_MediaMetadata_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaMetadata_1$__constructor__(), 0, this);
            }

            @Override
            public MediaMetadata createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_media_MediaMetadata_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public MediaMetadata[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_media_MediaMetadata_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(Bundle bundle) {
        this.$$robo$$android_media_MediaMetadata$__constructor__(bundle);
    }

    private MediaMetadata(Bundle bundle) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaMetadata$__constructor__(android.os.Bundle ), 0, this, bundle);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_media_MediaMetadata$__constructor__(parcel);
    }

    private MediaMetadata(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaMetadata$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    public boolean containsKey(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("containsKey", $$robo$$android_media_MediaMetadata$containsKey(java.lang.String ), 0, this, string2);
    }

    public CharSequence getText(String string2) {
        return InvokeDynamicSupport.bootstrap("getText", $$robo$$android_media_MediaMetadata$getText(java.lang.String ), 0, this, string2);
    }

    public String getString(String string2) {
        return InvokeDynamicSupport.bootstrap("getString", $$robo$$android_media_MediaMetadata$getString(java.lang.String ), 0, this, string2);
    }

    public long getLong(String string2) {
        return (long)InvokeDynamicSupport.bootstrap("getLong", $$robo$$android_media_MediaMetadata$getLong(java.lang.String ), 0, this, string2);
    }

    public Rating getRating(String string2) {
        return InvokeDynamicSupport.bootstrap("getRating", $$robo$$android_media_MediaMetadata$getRating(java.lang.String ), 0, this, string2);
    }

    public Bitmap getBitmap(String string2) {
        return InvokeDynamicSupport.bootstrap("getBitmap", $$robo$$android_media_MediaMetadata$getBitmap(java.lang.String ), 0, this, string2);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_media_MediaMetadata$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_media_MediaMetadata$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    public int size() {
        return (int)InvokeDynamicSupport.bootstrap("size", $$robo$$android_media_MediaMetadata$size(), 0, this);
    }

    public Set<String> keySet() {
        return InvokeDynamicSupport.bootstrap("keySet", $$robo$$android_media_MediaMetadata$keySet(), 0, this);
    }

    public MediaDescription getDescription() {
        return InvokeDynamicSupport.bootstrap("getDescription", $$robo$$android_media_MediaMetadata$getDescription(), 0, this);
    }

    public static String getKeyFromMetadataEditorKey(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getKeyFromMetadataEditorKey", $$robo$$android_media_MediaMetadata$getKeyFromMetadataEditorKey(int ), 0, (int)n);
    }

    private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
        this.$$robo$$android_media_MediaMetadata$__constructor__(parcel, var2_2);
    }

    private /* synthetic */ void __constructor__(Bundle bundle, 1 var2_2) {
        this.$$robo$$android_media_MediaMetadata$__constructor__(bundle, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(MediaMetadata.class);
    }

    public /* synthetic */ MediaMetadata() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MediaMetadata)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Builder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Bundle mBundle;

        private void $$robo$$android_media_MediaMetadata_Builder$__constructor__() {
            this.mBundle = new Bundle();
        }

        private void $$robo$$android_media_MediaMetadata_Builder$__constructor__(MediaMetadata source) {
            this.mBundle = new Bundle(source.mBundle);
        }

        private final Builder $$robo$$android_media_MediaMetadata_Builder$putText(String key, CharSequence value) {
            if (METADATA_KEYS_TYPE.containsKey(key) && (Integer)METADATA_KEYS_TYPE.get(key) != 1) {
                throw new IllegalArgumentException("The " + key + " key cannot be used to put a CharSequence");
            }
            this.mBundle.putCharSequence(key, value);
            return this;
        }

        private final Builder $$robo$$android_media_MediaMetadata_Builder$putString(String key, String value) {
            if (METADATA_KEYS_TYPE.containsKey(key) && (Integer)METADATA_KEYS_TYPE.get(key) != 1) {
                throw new IllegalArgumentException("The " + key + " key cannot be used to put a String");
            }
            this.mBundle.putCharSequence(key, value);
            return this;
        }

        private final Builder $$robo$$android_media_MediaMetadata_Builder$putLong(String key, long value) {
            if (METADATA_KEYS_TYPE.containsKey(key) && (Integer)METADATA_KEYS_TYPE.get(key) != 0) {
                throw new IllegalArgumentException("The " + key + " key cannot be used to put a long");
            }
            this.mBundle.putLong(key, value);
            return this;
        }

        private final Builder $$robo$$android_media_MediaMetadata_Builder$putRating(String key, Rating value) {
            if (METADATA_KEYS_TYPE.containsKey(key) && (Integer)METADATA_KEYS_TYPE.get(key) != 3) {
                throw new IllegalArgumentException("The " + key + " key cannot be used to put a Rating");
            }
            this.mBundle.putParcelable(key, value);
            return this;
        }

        private final Builder $$robo$$android_media_MediaMetadata_Builder$putBitmap(String key, Bitmap value) {
            if (METADATA_KEYS_TYPE.containsKey(key) && (Integer)METADATA_KEYS_TYPE.get(key) != 2) {
                throw new IllegalArgumentException("The " + key + " key cannot be used to put a Bitmap");
            }
            this.mBundle.putParcelable(key, value);
            return this;
        }

        private final MediaMetadata $$robo$$android_media_MediaMetadata_Builder$build() {
            return new MediaMetadata(this.mBundle);
        }

        private void __constructor__() {
            this.$$robo$$android_media_MediaMetadata_Builder$__constructor__();
        }

        public Builder() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaMetadata_Builder$__constructor__(), 0, this);
        }

        private void __constructor__(MediaMetadata mediaMetadata) {
            this.$$robo$$android_media_MediaMetadata_Builder$__constructor__(mediaMetadata);
        }

        public Builder(MediaMetadata mediaMetadata) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaMetadata_Builder$__constructor__(android.media.MediaMetadata ), 0, this, mediaMetadata);
        }

        public Builder putText(String string2, CharSequence charSequence) {
            return InvokeDynamicSupport.bootstrap("putText", $$robo$$android_media_MediaMetadata_Builder$putText(java.lang.String java.lang.CharSequence ), 0, this, string2, charSequence);
        }

        public Builder putString(String string2, String string3) {
            return InvokeDynamicSupport.bootstrap("putString", $$robo$$android_media_MediaMetadata_Builder$putString(java.lang.String java.lang.String ), 0, this, string2, string3);
        }

        public Builder putLong(String string2, long l) {
            return InvokeDynamicSupport.bootstrap("putLong", $$robo$$android_media_MediaMetadata_Builder$putLong(java.lang.String long ), 0, this, string2, l);
        }

        public Builder putRating(String string2, Rating rating) {
            return InvokeDynamicSupport.bootstrap("putRating", $$robo$$android_media_MediaMetadata_Builder$putRating(java.lang.String android.media.Rating ), 0, this, string2, rating);
        }

        public Builder putBitmap(String string2, Bitmap bitmap) {
            return InvokeDynamicSupport.bootstrap("putBitmap", $$robo$$android_media_MediaMetadata_Builder$putBitmap(java.lang.String android.graphics.Bitmap ), 0, this, string2, bitmap);
        }

        public MediaMetadata build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_media_MediaMetadata_Builder$build(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

