/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.MediaCodec;
import android.media.MediaFormat;
import com.google.errorprone.annotations.DoNotMock;
import dalvik.system.CloseGuard;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class MediaMuxer
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int MUXER_STATE_UNINITIALIZED = -1;
    private static int MUXER_STATE_INITIALIZED = 0;
    private static int MUXER_STATE_STARTED = 1;
    private static int MUXER_STATE_STOPPED = 2;
    private int mState;
    private CloseGuard mCloseGuard;
    private int mLastTrackIndex;
    private long mNativeObject;

    private static final long $$robo$$android_media_MediaMuxer$nativeSetup(FileDescriptor fileDescriptor, int n) {
        return 0L;
    }

    private static final void $$robo$$android_media_MediaMuxer$nativeRelease(long l) {
    }

    private static final void $$robo$$android_media_MediaMuxer$nativeStart(long l) {
    }

    private static final void $$robo$$android_media_MediaMuxer$nativeStop(long l) {
    }

    private static final int $$robo$$android_media_MediaMuxer$nativeAddTrack(long l, String[] stringArray, Object[] objectArray) {
        return 0;
    }

    private static final void $$robo$$android_media_MediaMuxer$nativeSetOrientationHint(long l, int n) {
    }

    private static final void $$robo$$android_media_MediaMuxer$nativeSetLocation(long l, int n, int n2) {
    }

    private static final void $$robo$$android_media_MediaMuxer$nativeWriteSampleData(long l, int n, ByteBuffer byteBuffer, int n2, int n3, long l2, int n4) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void $$robo$$android_media_MediaMuxer$__constructor__(String path, int format) throws IOException {
        this.mState = -1;
        this.mCloseGuard = CloseGuard.get();
        this.mLastTrackIndex = -1;
        if (path == null) {
            throw new IllegalArgumentException("path must not be null");
        }
        if (format != 0 && format != 1) {
            throw new IllegalArgumentException("format is invalid");
        }
        try (RandomAccessFile file = null;){
            file = new RandomAccessFile(path, "rws");
            FileDescriptor fd = file.getFD();
            this.mNativeObject = MediaMuxer.nativeSetup(fd, format);
            this.mState = 0;
            this.mCloseGuard.open("release");
        }
    }

    private final void $$robo$$android_media_MediaMuxer$setOrientationHint(int degrees) {
        if (degrees != 0 && degrees != 90 && degrees != 180 && degrees != 270) {
            throw new IllegalArgumentException("Unsupported angle: " + degrees);
        }
        if (this.mState != 0) {
            throw new IllegalStateException("Can't set rotation degrees due to wrong state.");
        }
        MediaMuxer.nativeSetOrientationHint(this.mNativeObject, degrees);
    }

    private final void $$robo$$android_media_MediaMuxer$setLocation(float latitude, float longitude) {
        int latitudex10000 = (int)((double)(latitude * 10000.0f) + 0.5);
        int longitudex10000 = (int)((double)(longitude * 10000.0f) + 0.5);
        if (latitudex10000 > 900000 || latitudex10000 < -900000) {
            String msg = "Latitude: " + latitude + " out of range.";
            throw new IllegalArgumentException(msg);
        }
        if (longitudex10000 > 1800000 || longitudex10000 < -1800000) {
            String msg = "Longitude: " + longitude + " out of range";
            throw new IllegalArgumentException(msg);
        }
        if (this.mState != 0 || this.mNativeObject == 0L) {
            throw new IllegalStateException("Can't set location due to wrong state.");
        }
        MediaMuxer.nativeSetLocation(this.mNativeObject, latitudex10000, longitudex10000);
    }

    private final void $$robo$$android_media_MediaMuxer$start() {
        if (this.mNativeObject == 0L) {
            throw new IllegalStateException("Muxer has been released!");
        }
        if (this.mState != 0) {
            throw new IllegalStateException("Can't start due to wrong state.");
        }
        MediaMuxer.nativeStart(this.mNativeObject);
        this.mState = 1;
    }

    private final void $$robo$$android_media_MediaMuxer$stop() {
        if (this.mState != 1) {
            throw new IllegalStateException("Can't stop due to wrong state.");
        }
        MediaMuxer.nativeStop(this.mNativeObject);
        this.mState = 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaMuxer$finalize() throws Throwable {
        try {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            if (this.mNativeObject != 0L) {
                MediaMuxer.nativeRelease(this.mNativeObject);
                this.mNativeObject = 0L;
            }
        }
        finally {
            super.finalize();
        }
    }

    private final int $$robo$$android_media_MediaMuxer$addTrack(MediaFormat format) {
        if (format == null) {
            throw new IllegalArgumentException("format must not be null.");
        }
        if (this.mState != 0) {
            throw new IllegalStateException("Muxer is not initialized.");
        }
        if (this.mNativeObject == 0L) {
            throw new IllegalStateException("Muxer has been released!");
        }
        int trackIndex = -1;
        Map<String, Object> formatMap = format.getMap();
        String[] keys = null;
        Object[] values = null;
        int mapSize = formatMap.size();
        if (mapSize > 0) {
            keys = new String[mapSize];
            values = new Object[mapSize];
            int i = 0;
            for (Map.Entry<String, Object> entry : formatMap.entrySet()) {
                keys[i] = entry.getKey();
                values[i] = entry.getValue();
                ++i;
            }
        } else {
            throw new IllegalArgumentException("format must not be empty.");
        }
        trackIndex = MediaMuxer.nativeAddTrack(this.mNativeObject, keys, values);
        if (this.mLastTrackIndex >= trackIndex) {
            throw new IllegalArgumentException("Invalid format.");
        }
        this.mLastTrackIndex = trackIndex;
        return trackIndex;
    }

    private final void $$robo$$android_media_MediaMuxer$writeSampleData(int trackIndex, ByteBuffer byteBuf, MediaCodec.BufferInfo bufferInfo) {
        if (trackIndex < 0 || trackIndex > this.mLastTrackIndex) {
            throw new IllegalArgumentException("trackIndex is invalid");
        }
        if (byteBuf == null) {
            throw new IllegalArgumentException("byteBuffer must not be null");
        }
        if (bufferInfo == null) {
            throw new IllegalArgumentException("bufferInfo must not be null");
        }
        if (bufferInfo.size < 0 || bufferInfo.offset < 0 || bufferInfo.offset + bufferInfo.size > byteBuf.capacity() || bufferInfo.presentationTimeUs < 0L) {
            throw new IllegalArgumentException("bufferInfo must specify a valid buffer offset, size and presentation time");
        }
        if (this.mNativeObject == 0L) {
            throw new IllegalStateException("Muxer has been released!");
        }
        if (this.mState != 1) {
            throw new IllegalStateException("Can't write, muxer is not started");
        }
        MediaMuxer.nativeWriteSampleData(this.mNativeObject, trackIndex, byteBuf, bufferInfo.offset, bufferInfo.size, bufferInfo.presentationTimeUs, bufferInfo.flags);
    }

    private final void $$robo$$android_media_MediaMuxer$release() {
        if (this.mState == 1) {
            this.stop();
        }
        if (this.mNativeObject != 0L) {
            MediaMuxer.nativeRelease(this.mNativeObject);
            this.mNativeObject = 0L;
            this.mCloseGuard.close();
        }
        this.mState = -1;
    }

    static void __staticInitializer__() {
        InvokeDynamicSupport.bootstrapIntrinsic("loadLibrary", "java.lang.System", (String)"media_jni");
    }

    private static final native /* synthetic */ long $$robo$$nativeSetup$nativeBinding(FileDescriptor var0, int var1);

    private static long nativeSetup(FileDescriptor fileDescriptor, int n) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeSetup", $$robo$$android_media_MediaMuxer$nativeSetup(java.io.FileDescriptor int ), 1, (FileDescriptor)fileDescriptor, (int)n);
    }

    private static final native /* synthetic */ void $$robo$$nativeRelease$nativeBinding(long var0);

    private static void nativeRelease(long l) {
        InvokeDynamicSupport.bootstrapStatic("nativeRelease", $$robo$$android_media_MediaMuxer$nativeRelease(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$nativeStart$nativeBinding(long var0);

    private static void nativeStart(long l) {
        InvokeDynamicSupport.bootstrapStatic("nativeStart", $$robo$$android_media_MediaMuxer$nativeStart(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$nativeStop$nativeBinding(long var0);

    private static void nativeStop(long l) {
        InvokeDynamicSupport.bootstrapStatic("nativeStop", $$robo$$android_media_MediaMuxer$nativeStop(long ), 1, (long)l);
    }

    private static final native /* synthetic */ int $$robo$$nativeAddTrack$nativeBinding(long var0, String[] var2, Object[] var3);

    private static int nativeAddTrack(long l, String[] stringArray, Object[] objectArray) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeAddTrack", $$robo$$android_media_MediaMuxer$nativeAddTrack(long java.lang.String[] java.lang.Object[] ), 1, (long)l, (String[])stringArray, (Object[])objectArray);
    }

    private static final native /* synthetic */ void $$robo$$nativeSetOrientationHint$nativeBinding(long var0, int var2);

    private static void nativeSetOrientationHint(long l, int n) {
        InvokeDynamicSupport.bootstrapStatic("nativeSetOrientationHint", $$robo$$android_media_MediaMuxer$nativeSetOrientationHint(long int ), 1, (long)l, (int)n);
    }

    private static final native /* synthetic */ void $$robo$$nativeSetLocation$nativeBinding(long var0, int var2, int var3);

    private static void nativeSetLocation(long l, int n, int n2) {
        InvokeDynamicSupport.bootstrapStatic("nativeSetLocation", $$robo$$android_media_MediaMuxer$nativeSetLocation(long int int ), 1, (long)l, (int)n, (int)n2);
    }

    private static final native /* synthetic */ void $$robo$$nativeWriteSampleData$nativeBinding(long var0, int var2, ByteBuffer var3, int var4, int var5, long var6, int var8);

    private static void nativeWriteSampleData(long l, int n, ByteBuffer byteBuffer, int n2, int n3, long l2, int n4) {
        InvokeDynamicSupport.bootstrapStatic("nativeWriteSampleData", $$robo$$android_media_MediaMuxer$nativeWriteSampleData(long int java.nio.ByteBuffer int int long int ), 1, (long)l, (int)n, (ByteBuffer)byteBuffer, (int)n2, (int)n3, (long)l2, (int)n4);
    }

    private void __constructor__(String string2, int n) throws IOException {
        this.$$robo$$android_media_MediaMuxer$__constructor__(string2, n);
    }

    public MediaMuxer(String string2, int n) throws IOException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaMuxer$__constructor__(java.lang.String int ), 0, this, string2, n);
    }

    public void setOrientationHint(int n) {
        InvokeDynamicSupport.bootstrap("setOrientationHint", $$robo$$android_media_MediaMuxer$setOrientationHint(int ), 0, this, n);
    }

    public void setLocation(float f, float f2) {
        InvokeDynamicSupport.bootstrap("setLocation", $$robo$$android_media_MediaMuxer$setLocation(float float ), 0, this, f, f2);
    }

    public void start() {
        InvokeDynamicSupport.bootstrap("start", $$robo$$android_media_MediaMuxer$start(), 0, this);
    }

    public void stop() {
        InvokeDynamicSupport.bootstrap("stop", $$robo$$android_media_MediaMuxer$stop(), 0, this);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_media_MediaMuxer$finalize(), 0, this);
    }

    public int addTrack(MediaFormat mediaFormat) {
        return (int)InvokeDynamicSupport.bootstrap("addTrack", $$robo$$android_media_MediaMuxer$addTrack(android.media.MediaFormat ), 0, this, mediaFormat);
    }

    public void writeSampleData(int n, ByteBuffer byteBuffer, MediaCodec.BufferInfo bufferInfo) {
        InvokeDynamicSupport.bootstrap("writeSampleData", $$robo$$android_media_MediaMuxer$writeSampleData(int java.nio.ByteBuffer android.media.MediaCodec$BufferInfo ), 0, this, n, byteBuffer, bufferInfo);
    }

    public void release() {
        InvokeDynamicSupport.bootstrap("release", $$robo$$android_media_MediaMuxer$release(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(MediaMuxer.class);
    }

    public /* synthetic */ MediaMuxer() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MediaMuxer)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class OutputFormat
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int MUXER_OUTPUT_MPEG_4 = 0;
        public static int MUXER_OUTPUT_WEBM = 1;

        private void $$robo$$android_media_MediaMuxer_OutputFormat$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_media_MediaMuxer_OutputFormat$__constructor__();
        }

        private OutputFormat() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaMuxer_OutputFormat$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (OutputFormat)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

