/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.IContentProvider;
import android.database.Cursor;
import android.database.SQLException;
import android.drm.DrmManagerClient;
import android.graphics.BitmapFactory;
import android.media.ExifInterface;
import android.media.MediaFile;
import android.media.MediaInserter;
import android.media.MediaScannerClient;
import android.mtp.MtpConstants;
import android.net.Uri;
import android.os.Environment;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.provider.MediaStore;
import android.provider.Settings;
import android.sax.Element;
import android.sax.ElementListener;
import android.sax.RootElement;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.text.TextUtils;
import android.util.Log;
import android.util.Xml;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class MediaScanner
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "MediaScanner";
    private static String[] FILES_PRESCAN_PROJECTION;
    private static String[] ID_PROJECTION;
    private static int FILES_PRESCAN_ID_COLUMN_INDEX = 0;
    private static int FILES_PRESCAN_PATH_COLUMN_INDEX = 1;
    private static int FILES_PRESCAN_FORMAT_COLUMN_INDEX = 2;
    private static int FILES_PRESCAN_DATE_MODIFIED_COLUMN_INDEX = 3;
    private static String[] PLAYLIST_MEMBERS_PROJECTION;
    private static int ID_PLAYLISTS_COLUMN_INDEX = 0;
    private static int PATH_PLAYLISTS_COLUMN_INDEX = 1;
    private static int DATE_MODIFIED_PLAYLISTS_COLUMN_INDEX = 2;
    private static String RINGTONES_DIR = "/ringtones/";
    private static String NOTIFICATIONS_DIR = "/notifications/";
    private static String ALARMS_DIR = "/alarms/";
    private static String MUSIC_DIR = "/music/";
    private static String PODCAST_DIR = "/podcasts/";
    private static String[] ID3_GENRES;
    private long mNativeContext;
    private Context mContext;
    private String mPackageName;
    private IContentProvider mMediaProvider;
    private Uri mAudioUri;
    private Uri mVideoUri;
    private Uri mImagesUri;
    private Uri mThumbsUri;
    private Uri mPlaylistsUri;
    private Uri mFilesUri;
    private Uri mFilesUriNoNotify;
    private boolean mProcessPlaylists;
    private boolean mProcessGenres;
    private int mMtpObjectHandle;
    private String mExternalStoragePath;
    private boolean mExternalIsEmulated;
    private static boolean ENABLE_BULK_INSERTS = true;
    private int mOriginalCount;
    private boolean mWasEmptyPriorToScan;
    private boolean mDefaultRingtoneSet;
    private boolean mDefaultNotificationSet;
    private boolean mDefaultAlarmSet;
    private String mDefaultRingtoneFilename;
    private String mDefaultNotificationFilename;
    private String mDefaultAlarmAlertFilename;
    private static String DEFAULT_RINGTONE_PROPERTY_PREFIX = "ro.config.";
    private boolean mCaseInsensitivePaths;
    private BitmapFactory.Options mBitmapOptions;
    private ArrayList<PlaylistEntry> mPlaylistEntries;
    private MediaInserter mMediaInserter;
    private ArrayList<FileEntry> mPlayLists;
    private DrmManagerClient mDrmManagerClient;
    private MyMediaScannerClient mClient;
    private static HashMap<String, String> mNoMediaPaths;
    private static HashMap<String, String> mMediaPaths;

    private void $$robo$$android_media_MediaScanner$__constructor__(Context c) {
        this.mWasEmptyPriorToScan = false;
        this.mBitmapOptions = new BitmapFactory.Options();
        this.mPlaylistEntries = new ArrayList();
        this.mDrmManagerClient = null;
        this.mClient = new MyMediaScannerClient(this);
        this.native_setup();
        this.mContext = c;
        this.mPackageName = c.getPackageName();
        this.mBitmapOptions.inSampleSize = 1;
        this.mBitmapOptions.inJustDecodeBounds = true;
        this.setDefaultRingtoneFileNames();
        this.mExternalStoragePath = Environment.getExternalStorageDirectory().getAbsolutePath();
        this.mExternalIsEmulated = Environment.isExternalStorageEmulated();
    }

    private final void $$robo$$android_media_MediaScanner$setDefaultRingtoneFileNames() {
        this.mDefaultRingtoneFilename = SystemProperties.get("ro.config.ringtone");
        this.mDefaultNotificationFilename = SystemProperties.get("ro.config.notification_sound");
        this.mDefaultAlarmAlertFilename = SystemProperties.get("ro.config.alarm_alert");
    }

    private final boolean $$robo$$android_media_MediaScanner$isDrmEnabled() {
        String prop = SystemProperties.get("drm.service.enabled");
        return prop != null && prop.equals("true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaScanner$prescan(String filePath, boolean prescanFiles) throws RemoteException {
        Cursor c;
        block16: {
            c = null;
            String where = null;
            String[] selectionArgs = null;
            if (this.mPlayLists == null) {
                this.mPlayLists = new ArrayList();
            } else {
                this.mPlayLists.clear();
            }
            if (filePath != null) {
                where = "_id>? AND _data=?";
                selectionArgs = new String[]{"", filePath};
            } else {
                where = "_id>?";
                selectionArgs = new String[]{""};
            }
            Uri.Builder builder = this.mFilesUri.buildUpon();
            builder.appendQueryParameter("deletedata", "false");
            MediaBulkDeleter deleter = new MediaBulkDeleter(this.mMediaProvider, this.mPackageName, builder.build());
            try {
                if (!prescanFiles) break block16;
                long lastId = Long.MIN_VALUE;
                Uri limitUri = this.mFilesUri.buildUpon().appendQueryParameter("limit", "1000").build();
                this.mWasEmptyPriorToScan = true;
                block5: while (true) {
                    selectionArgs[0] = "" + lastId;
                    if (c != null) {
                        c.close();
                        c = null;
                    }
                    if ((c = this.mMediaProvider.query(this.mPackageName, limitUri, FILES_PRESCAN_PROJECTION, where, selectionArgs, "_id", null)) == null) {
                        break;
                    }
                    int num = c.getCount();
                    if (num == 0) {
                        break;
                    }
                    this.mWasEmptyPriorToScan = false;
                    while (true) {
                        MediaFile.MediaFileType mediaFileType;
                        int fileType;
                        if (!c.moveToNext()) continue block5;
                        long rowId = c.getLong(0);
                        String path = c.getString(1);
                        int format = c.getInt(2);
                        long lastModified = c.getLong(3);
                        lastId = rowId;
                        if (path == null || !path.startsWith("/")) continue;
                        boolean exists = false;
                        try {
                            exists = Os.access(path, OsConstants.F_OK);
                        }
                        catch (ErrnoException errnoException) {
                            // empty catch block
                        }
                        if (exists || MtpConstants.isAbstractObject(format) || MediaFile.isPlayListFileType(fileType = (mediaFileType = MediaFile.getFileType(path)) == null ? 0 : mediaFileType.fileType)) continue;
                        deleter.delete(rowId);
                        if (!path.toLowerCase(Locale.US).endsWith("/.nomedia")) continue;
                        deleter.flush();
                        String parent = new File(path).getParent();
                        this.mMediaProvider.call(this.mPackageName, "unhide", parent, null);
                    }
                    break;
                }
            }
            finally {
                if (c != null) {
                    c.close();
                }
                deleter.flush();
            }
        }
        this.mOriginalCount = 0;
        c = this.mMediaProvider.query(this.mPackageName, this.mImagesUri, ID_PROJECTION, null, null, null, null);
        if (c != null) {
            this.mOriginalCount = c.getCount();
            c.close();
        }
    }

    private final boolean $$robo$$android_media_MediaScanner$inScanDirectory(String path, String[] directories) {
        for (int i = 0; i < directories.length; ++i) {
            String directory = directories[i];
            if (!path.startsWith(directory)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaScanner$pruneDeadThumbnailFiles() {
        HashSet<String> existingFiles = new HashSet<String>();
        String directory = "/sdcard/DCIM/.thumbnails";
        String[] files = new File(directory).list();
        Cursor c = null;
        if (files == null) {
            files = new String[]{};
        }
        for (int i = 0; i < files.length; ++i) {
            String fullPathString = directory + "/" + files[i];
            existingFiles.add(fullPathString);
        }
        try {
            c = this.mMediaProvider.query(this.mPackageName, this.mThumbsUri, new String[]{"_data"}, null, null, null, null);
            Log.v("MediaScanner", "pruneDeadThumbnailFiles... " + c);
            if (c != null && c.moveToFirst()) {
                do {
                    String fullPathString = c.getString(0);
                    existingFiles.remove(fullPathString);
                } while (c.moveToNext());
            }
            for (String fileToDelete : existingFiles) {
                try {
                    new File(fileToDelete).delete();
                }
                catch (SecurityException securityException) {}
            }
            Log.v("MediaScanner", "/pruneDeadThumbnailFiles... " + c);
        }
        catch (RemoteException remoteException) {
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
    }

    private final void $$robo$$android_media_MediaScanner$postscan(String[] directories) throws RemoteException {
        if (this.mProcessPlaylists) {
            this.processPlayLists();
        }
        if (this.mOriginalCount == 0 && this.mImagesUri.equals(MediaStore.Images.Media.getContentUri("external"))) {
            this.pruneDeadThumbnailFiles();
        }
        this.mPlayLists = null;
        this.mMediaProvider = null;
    }

    private final void $$robo$$android_media_MediaScanner$releaseResources() {
        if (this.mDrmManagerClient != null) {
            this.mDrmManagerClient.release();
            this.mDrmManagerClient = null;
        }
    }

    private final void $$robo$$android_media_MediaScanner$initialize(String volumeName) {
        this.mMediaProvider = this.mContext.getContentResolver().acquireProvider("media");
        this.mAudioUri = MediaStore.Audio.Media.getContentUri(volumeName);
        this.mVideoUri = MediaStore.Video.Media.getContentUri(volumeName);
        this.mImagesUri = MediaStore.Images.Media.getContentUri(volumeName);
        this.mThumbsUri = MediaStore.Images.Thumbnails.getContentUri(volumeName);
        this.mFilesUri = MediaStore.Files.getContentUri(volumeName);
        this.mFilesUriNoNotify = this.mFilesUri.buildUpon().appendQueryParameter("nonotify", "1").build();
        if (!volumeName.equals("internal")) {
            this.mProcessPlaylists = true;
            this.mProcessGenres = true;
            this.mPlaylistsUri = MediaStore.Audio.Playlists.getContentUri(volumeName);
            this.mCaseInsensitivePaths = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaScanner$scanDirectories(String[] directories, String volumeName) {
        try {
            CallSite start = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
            this.initialize(volumeName);
            this.prescan(null, true);
            CallSite prescan = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
            this.mMediaInserter = new MediaInserter(this.mMediaProvider, this.mPackageName, 500);
            for (int i = 0; i < directories.length; ++i) {
                this.processDirectory(directories[i], this.mClient);
            }
            this.mMediaInserter.flushAll();
            this.mMediaInserter = null;
            CallSite scan = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
            this.postscan(directories);
            CallSite callSite = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        }
        catch (SQLException e) {
            Log.e("MediaScanner", "SQLException in MediaScanner.scan()", e);
        }
        catch (UnsupportedOperationException e) {
            Log.e("MediaScanner", "UnsupportedOperationException in MediaScanner.scan()", e);
        }
        catch (RemoteException e) {
            Log.e("MediaScanner", "RemoteException in MediaScanner.scan()", e);
        }
        finally {
            this.releaseResources();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Uri $$robo$$android_media_MediaScanner$scanSingleFile(String path, String volumeName, String mimeType) {
        try {
            this.initialize(volumeName);
            this.prescan(path, true);
            File file = new File(path);
            if (!file.exists()) {
                Uri uri = null;
                return uri;
            }
            long lastModifiedSeconds = file.lastModified() / 1000L;
            Uri uri = this.mClient.doScanFile(path, mimeType, lastModifiedSeconds, file.length(), false, true, MediaScanner.isNoMediaPath(path));
            return uri;
        }
        catch (RemoteException e) {
            Log.e("MediaScanner", "RemoteException in MediaScanner.scanFile()", e);
            Uri uri = null;
            return uri;
        }
        finally {
            this.releaseResources();
        }
    }

    private static final boolean $$robo$$android_media_MediaScanner$isNoMediaFile(String path) {
        File file = new File(path);
        if (file.isDirectory()) {
            return false;
        }
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash >= 0 && lastSlash + 2 < path.length()) {
            if (path.regionMatches(lastSlash + 1, "._", 0, 2)) {
                return true;
            }
            if (path.regionMatches(true, path.length() - 4, ".jpg", 0, 4)) {
                if (path.regionMatches(true, lastSlash + 1, "AlbumArt_{", 0, 10) || path.regionMatches(true, lastSlash + 1, "AlbumArt.", 0, 9)) {
                    return true;
                }
                int length = path.length() - lastSlash - 1;
                if (length == 17 && path.regionMatches(true, lastSlash + 1, "AlbumArtSmall", 0, 13) || length == 10 && path.regionMatches(true, lastSlash + 1, "Folder", 0, 6)) {
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$android_media_MediaScanner$clearMediaPathCache(boolean clearMediaPaths, boolean clearNoMediaPaths) {
        Class<MediaScanner> clazz = MediaScanner.class;
        synchronized (MediaScanner.class) {
            if (clearMediaPaths) {
                mMediaPaths.clear();
            }
            if (clearNoMediaPaths) {
                mNoMediaPaths.clear();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean $$robo$$android_media_MediaScanner$isNoMediaPath(String path) {
        if (path == null) {
            return false;
        }
        if (path.indexOf("/.") >= 0) {
            return true;
        }
        int firstSlash = path.lastIndexOf(47);
        if (firstSlash <= 0) {
            return false;
        }
        String parent = path.substring(0, firstSlash);
        Class<MediaScanner> clazz = MediaScanner.class;
        synchronized (MediaScanner.class) {
            if (mNoMediaPaths.containsKey(parent)) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return true;
            }
            if (!mMediaPaths.containsKey(parent)) {
                int offset = 1;
                while (offset >= 0) {
                    File file;
                    int slashIndex = path.indexOf(47, offset);
                    if (slashIndex > offset && (file = new File(path.substring(0, ++slashIndex) + ".nomedia")).exists()) {
                        mNoMediaPaths.put(parent, "");
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return true;
                    }
                    offset = slashIndex;
                }
                mMediaPaths.put(parent, "");
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return MediaScanner.isNoMediaFile(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaScanner$scanMtpFile(String path, String volumeName, int objectHandle, int format) {
        this.initialize(volumeName);
        MediaFile.MediaFileType mediaFileType = MediaFile.getFileType(path);
        int fileType = mediaFileType == null ? 0 : mediaFileType.fileType;
        File file = new File(path);
        long lastModifiedSeconds = file.lastModified() / 1000L;
        if (!(MediaFile.isAudioFileType(fileType) || MediaFile.isVideoFileType(fileType) || MediaFile.isImageFileType(fileType) || MediaFile.isPlayListFileType(fileType) || MediaFile.isDrmFileType(fileType))) {
            ContentValues values = new ContentValues();
            values.put("_size", file.length());
            values.put("date_modified", lastModifiedSeconds);
            try {
                String[] whereArgs = new String[]{Integer.toString(objectHandle)};
                this.mMediaProvider.update(this.mPackageName, MediaStore.Files.getMtpObjectsUri(volumeName), values, "_id=?", whereArgs);
            }
            catch (RemoteException e) {
                Log.e("MediaScanner", "RemoteException in scanMtpFile", e);
            }
            return;
        }
        this.mMtpObjectHandle = objectHandle;
        Cursor fileList = null;
        try {
            if (MediaFile.isPlayListFileType(fileType)) {
                this.prescan(null, true);
                FileEntry entry = this.makeEntryFor(path);
                if (entry != null) {
                    fileList = this.mMediaProvider.query(this.mPackageName, this.mFilesUri, FILES_PRESCAN_PROJECTION, null, null, null, null);
                    this.processPlayList(entry, fileList);
                }
            } else {
                this.prescan(path, false);
                this.mClient.doScanFile(path, mediaFileType.mimeType, lastModifiedSeconds, file.length(), format == 12289, true, MediaScanner.isNoMediaPath(path));
            }
        }
        catch (RemoteException e) {
            Log.e("MediaScanner", "RemoteException in MediaScanner.scanFile()", e);
        }
        finally {
            this.mMtpObjectHandle = 0;
            if (fileList != null) {
                fileList.close();
            }
            this.releaseResources();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final FileEntry $$robo$$android_media_MediaScanner$makeEntryFor(String path) {
        try (Cursor c = null;){
            String where = "_data=?";
            String[] selectionArgs = new String[]{path};
            c = this.mMediaProvider.query(this.mPackageName, this.mFilesUriNoNotify, FILES_PRESCAN_PROJECTION, where, selectionArgs, null, null);
            if (c.moveToFirst()) {
                long rowId = c.getLong(0);
                int format = c.getInt(2);
                long lastModified = c.getLong(3);
                FileEntry fileEntry = new FileEntry(rowId, path, lastModified, format);
                return fileEntry;
            }
        }
        return null;
    }

    private final int $$robo$$android_media_MediaScanner$matchPaths(String path1, String path2) {
        int result = 0;
        int end1 = path1.length();
        int end2 = path2.length();
        while (end1 > 0 && end2 > 0) {
            int start2;
            int slash1 = path1.lastIndexOf(47, end1 - 1);
            int slash2 = path2.lastIndexOf(47, end2 - 1);
            int backSlash1 = path1.lastIndexOf(92, end1 - 1);
            int backSlash2 = path2.lastIndexOf(92, end2 - 1);
            int start1 = slash1 > backSlash1 ? slash1 : backSlash1;
            int n = start2 = slash2 > backSlash2 ? slash2 : backSlash2;
            start1 = start1 < 0 ? 0 : ++start1;
            start2 = start2 < 0 ? 0 : ++start2;
            int length = end1 - start1;
            if (end2 - start2 != length || !path1.regionMatches(true, start1, path2, start2, length)) break;
            ++result;
            end1 = start1 - 1;
            end2 = start2 - 1;
        }
        return result;
    }

    private final boolean $$robo$$android_media_MediaScanner$matchEntries(long rowId, String data) {
        int len = this.mPlaylistEntries.size();
        boolean done = true;
        for (int i = 0; i < len; ++i) {
            PlaylistEntry entry = this.mPlaylistEntries.get(i);
            if (entry.bestmatchlevel == Integer.MAX_VALUE) continue;
            done = false;
            if (data.equalsIgnoreCase(entry.path)) {
                entry.bestmatchid = rowId;
                entry.bestmatchlevel = Integer.MAX_VALUE;
                continue;
            }
            int matchLength = this.matchPaths(data, entry.path);
            if (matchLength <= entry.bestmatchlevel) continue;
            entry.bestmatchid = rowId;
            entry.bestmatchlevel = matchLength;
        }
        return done;
    }

    private final void $$robo$$android_media_MediaScanner$cachePlaylistEntry(String line, String playListDirectory) {
        char ch1;
        boolean fullPath;
        int entryLength;
        PlaylistEntry entry = new PlaylistEntry();
        for (entryLength = line.length(); entryLength > 0 && Character.isWhitespace(line.charAt(entryLength - 1)); --entryLength) {
        }
        if (entryLength < 3) {
            return;
        }
        if (entryLength < line.length()) {
            line = line.substring(0, entryLength);
        }
        boolean bl = fullPath = (ch1 = line.charAt(0)) == '/' || Character.isLetter(ch1) && line.charAt(1) == ':' && line.charAt(2) == '\\';
        if (!fullPath) {
            line = playListDirectory + line;
        }
        entry.path = line;
        this.mPlaylistEntries.add(entry);
    }

    private final void $$robo$$android_media_MediaScanner$processCachedPlaylist(Cursor fileList, ContentValues values, Uri playlistUri) {
        String data;
        long rowId;
        fileList.moveToPosition(-1);
        while (fileList.moveToNext() && !this.matchEntries(rowId = fileList.getLong(0), data = fileList.getString(1))) {
        }
        int len = this.mPlaylistEntries.size();
        int index = 0;
        for (int i = 0; i < len; ++i) {
            PlaylistEntry entry = this.mPlaylistEntries.get(i);
            if (entry.bestmatchlevel <= 0) continue;
            try {
                values.clear();
                values.put("play_order", index);
                values.put("audio_id", entry.bestmatchid);
                this.mMediaProvider.insert(this.mPackageName, playlistUri, values);
                ++index;
                continue;
            }
            catch (RemoteException e) {
                Log.e("MediaScanner", "RemoteException in MediaScanner.processCachedPlaylist()", e);
                return;
            }
        }
        this.mPlaylistEntries.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaScanner$processM3uPlayList(String path, String playListDirectory, Uri uri, ContentValues values, Cursor fileList) {
        BufferedReader reader = null;
        try {
            File f = new File(path);
            if (f.exists()) {
                reader = new BufferedReader(new InputStreamReader(new FileInputStream(f)), 8192);
                String line = reader.readLine();
                this.mPlaylistEntries.clear();
                while (line != null) {
                    if (line.length() > 0 && line.charAt(0) != '#') {
                        this.cachePlaylistEntry(line, playListDirectory);
                    }
                    line = reader.readLine();
                }
                this.processCachedPlaylist(fileList, values, uri);
            }
        }
        catch (IOException e) {
            Log.e("MediaScanner", "IOException in MediaScanner.processM3uPlayList()", e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                Log.e("MediaScanner", "IOException in MediaScanner.processM3uPlayList()", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaScanner$processPlsPlayList(String path, String playListDirectory, Uri uri, ContentValues values, Cursor fileList) {
        BufferedReader reader = null;
        try {
            File f = new File(path);
            if (f.exists()) {
                reader = new BufferedReader(new InputStreamReader(new FileInputStream(f)), 8192);
                String line = reader.readLine();
                this.mPlaylistEntries.clear();
                while (line != null) {
                    int equals;
                    if (line.startsWith("File") && (equals = line.indexOf(61)) > 0) {
                        this.cachePlaylistEntry(line.substring(equals + 1), playListDirectory);
                    }
                    line = reader.readLine();
                }
                this.processCachedPlaylist(fileList, values, uri);
            }
        }
        catch (IOException e) {
            Log.e("MediaScanner", "IOException in MediaScanner.processPlsPlayList()", e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                Log.e("MediaScanner", "IOException in MediaScanner.processPlsPlayList()", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaScanner$processWplPlayList(String path, String playListDirectory, Uri uri, ContentValues values, Cursor fileList) {
        FileInputStream fis = null;
        try {
            File f = new File(path);
            if (f.exists()) {
                fis = new FileInputStream(f);
                this.mPlaylistEntries.clear();
                Xml.parse(fis, Xml.findEncodingByName("UTF-8"), new WplHandler(this, playListDirectory, uri, fileList).getContentHandler());
                this.processCachedPlaylist(fileList, values, uri);
            }
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                Log.e("MediaScanner", "IOException in MediaScanner.processWplPlayList()", e);
            }
        }
    }

    private final void $$robo$$android_media_MediaScanner$processPlayList(FileEntry entry, Cursor fileList) throws RemoteException {
        int fileType;
        Uri membersUri;
        String path = entry.mPath;
        ContentValues values = new ContentValues();
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash < 0) {
            throw new IllegalArgumentException("bad path " + path);
        }
        long rowId = entry.mRowId;
        String name = values.getAsString("name");
        if (name == null && (name = values.getAsString("title")) == null) {
            int lastDot = path.lastIndexOf(46);
            name = lastDot < 0 ? path.substring(lastSlash + 1) : path.substring(lastSlash + 1, lastDot);
        }
        values.put("name", name);
        values.put("date_modified", entry.mLastModified);
        if (rowId == 0L) {
            values.put("_data", path);
            Uri uri = this.mMediaProvider.insert(this.mPackageName, this.mPlaylistsUri, values);
            rowId = ContentUris.parseId(uri);
            membersUri = Uri.withAppendedPath(uri, "members");
        } else {
            Uri uri = ContentUris.withAppendedId(this.mPlaylistsUri, rowId);
            this.mMediaProvider.update(this.mPackageName, uri, values, null, null);
            membersUri = Uri.withAppendedPath(uri, "members");
            this.mMediaProvider.delete(this.mPackageName, membersUri, null, null);
        }
        String playListDirectory = path.substring(0, lastSlash + 1);
        MediaFile.MediaFileType mediaFileType = MediaFile.getFileType(path);
        int n = fileType = mediaFileType == null ? 0 : mediaFileType.fileType;
        if (fileType == 41) {
            this.processM3uPlayList(path, playListDirectory, membersUri, values, fileList);
        } else if (fileType == 42) {
            this.processPlsPlayList(path, playListDirectory, membersUri, values, fileList);
        } else if (fileType == 43) {
            this.processWplPlayList(path, playListDirectory, membersUri, values, fileList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaScanner$processPlayLists() throws RemoteException {
        Iterator<FileEntry> iterator = this.mPlayLists.iterator();
        try (Cursor fileList = null;){
            fileList = this.mMediaProvider.query(this.mPackageName, this.mFilesUri, FILES_PRESCAN_PROJECTION, "media_type=2", null, null, null);
            while (iterator.hasNext()) {
                FileEntry entry = iterator.next();
                if (!entry.mLastModifiedChanged) continue;
                this.processPlayList(entry, fileList);
            }
        }
    }

    private final void $$robo$$android_media_MediaScanner$processDirectory(String string2, MediaScannerClient mediaScannerClient) {
    }

    private final void $$robo$$android_media_MediaScanner$processFile(String string2, String string3, MediaScannerClient mediaScannerClient) {
    }

    private final void $$robo$$android_media_MediaScanner$setLocale(String string2) {
    }

    private final byte[] $$robo$$android_media_MediaScanner$extractAlbumArt(FileDescriptor fileDescriptor) {
        return null;
    }

    private static final void $$robo$$android_media_MediaScanner$native_init() {
    }

    private final void $$robo$$android_media_MediaScanner$native_setup() {
    }

    private final void $$robo$$android_media_MediaScanner$native_finalize() {
    }

    private final void $$robo$$android_media_MediaScanner$release() {
        this.native_finalize();
    }

    private final void $$robo$$android_media_MediaScanner$finalize() {
        this.mContext.getContentResolver().releaseProvider(this.mMediaProvider);
        this.native_finalize();
    }

    static void __staticInitializer__() {
        InvokeDynamicSupport.bootstrapIntrinsic("loadLibrary", "java.lang.System", (String)"media_jni");
        MediaScanner.native_init();
        FILES_PRESCAN_PROJECTION = new String[]{"_id", "_data", "format", "date_modified"};
        ID_PROJECTION = new String[]{"_id"};
        PLAYLIST_MEMBERS_PROJECTION = new String[]{"playlist_id"};
        ID3_GENRES = new String[]{"Blues", "Classic Rock", "Country", "Dance", "Disco", "Funk", "Grunge", "Hip-Hop", "Jazz", "Metal", "New Age", "Oldies", "Other", "Pop", "R&B", "Rap", "Reggae", "Rock", "Techno", "Industrial", "Alternative", "Ska", "Death Metal", "Pranks", "Soundtrack", "Euro-Techno", "Ambient", "Trip-Hop", "Vocal", "Jazz+Funk", "Fusion", "Trance", "Classical", "Instrumental", "Acid", "House", "Game", "Sound Clip", "Gospel", "Noise", "AlternRock", "Bass", "Soul", "Punk", "Space", "Meditative", "Instrumental Pop", "Instrumental Rock", "Ethnic", "Gothic", "Darkwave", "Techno-Industrial", "Electronic", "Pop-Folk", "Eurodance", "Dream", "Southern Rock", "Comedy", "Cult", "Gangsta", "Top 40", "Christian Rap", "Pop/Funk", "Jungle", "Native American", "Cabaret", "New Wave", "Psychadelic", "Rave", "Showtunes", "Trailer", "Lo-Fi", "Tribal", "Acid Punk", "Acid Jazz", "Polka", "Retro", "Musical", "Rock & Roll", "Hard Rock", "Folk", "Folk-Rock", "National Folk", "Swing", "Fast Fusion", "Bebob", "Latin", "Revival", "Celtic", "Bluegrass", "Avantgarde", "Gothic Rock", "Progressive Rock", "Psychedelic Rock", "Symphonic Rock", "Slow Rock", "Big Band", "Chorus", "Easy Listening", "Acoustic", "Humour", "Speech", "Chanson", "Opera", "Chamber Music", "Sonata", "Symphony", "Booty Bass", "Primus", "Porn Groove", "Satire", "Slow Jam", "Club", "Tango", "Samba", "Folklore", "Ballad", "Power Ballad", "Rhythmic Soul", "Freestyle", "Duet", "Punk Rock", "Drum Solo", "A capella", "Euro-House", "Dance Hall", "Goa", "Drum & Bass", "Club-House", "Hardcore", "Terror", "Indie", "Britpop", null, "Polsk Punk", "Beat", "Christian Gangsta", "Heavy Metal", "Black Metal", "Crossover", "Contemporary Christian", "Christian Rock", "Merengue", "Salsa", "Thrash Metal", "Anime", "JPop", "Synthpop"};
        mNoMediaPaths = new HashMap();
        mMediaPaths = new HashMap();
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_media_MediaScanner$__constructor__(context);
    }

    public MediaScanner(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaScanner$__constructor__(android.content.Context ), 0, this, context);
    }

    private void setDefaultRingtoneFileNames() {
        InvokeDynamicSupport.bootstrap("setDefaultRingtoneFileNames", $$robo$$android_media_MediaScanner$setDefaultRingtoneFileNames(), 0, this);
    }

    private boolean isDrmEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDrmEnabled", $$robo$$android_media_MediaScanner$isDrmEnabled(), 0, this);
    }

    private void prescan(String string2, boolean bl) throws RemoteException {
        InvokeDynamicSupport.bootstrap("prescan", $$robo$$android_media_MediaScanner$prescan(java.lang.String boolean ), 0, this, string2, bl);
    }

    private boolean inScanDirectory(String string2, String[] stringArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("inScanDirectory", $$robo$$android_media_MediaScanner$inScanDirectory(java.lang.String java.lang.String[] ), 0, this, string2, stringArray);
    }

    private void pruneDeadThumbnailFiles() {
        InvokeDynamicSupport.bootstrap("pruneDeadThumbnailFiles", $$robo$$android_media_MediaScanner$pruneDeadThumbnailFiles(), 0, this);
    }

    private void postscan(String[] stringArray) throws RemoteException {
        InvokeDynamicSupport.bootstrap("postscan", $$robo$$android_media_MediaScanner$postscan(java.lang.String[] ), 0, this, stringArray);
    }

    private void releaseResources() {
        InvokeDynamicSupport.bootstrap("releaseResources", $$robo$$android_media_MediaScanner$releaseResources(), 0, this);
    }

    private void initialize(String string2) {
        InvokeDynamicSupport.bootstrap("initialize", $$robo$$android_media_MediaScanner$initialize(java.lang.String ), 0, this, string2);
    }

    public void scanDirectories(String[] stringArray, String string2) {
        InvokeDynamicSupport.bootstrap("scanDirectories", $$robo$$android_media_MediaScanner$scanDirectories(java.lang.String[] java.lang.String ), 0, this, stringArray, string2);
    }

    public Uri scanSingleFile(String string2, String string3, String string4) {
        return InvokeDynamicSupport.bootstrap("scanSingleFile", $$robo$$android_media_MediaScanner$scanSingleFile(java.lang.String java.lang.String java.lang.String ), 0, this, string2, string3, string4);
    }

    private static boolean isNoMediaFile(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isNoMediaFile", $$robo$$android_media_MediaScanner$isNoMediaFile(java.lang.String ), 0, (String)string2);
    }

    public static void clearMediaPathCache(boolean bl, boolean bl2) {
        InvokeDynamicSupport.bootstrapStatic("clearMediaPathCache", $$robo$$android_media_MediaScanner$clearMediaPathCache(boolean boolean ), 0, (boolean)bl, (boolean)bl2);
    }

    public static boolean isNoMediaPath(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isNoMediaPath", $$robo$$android_media_MediaScanner$isNoMediaPath(java.lang.String ), 0, (String)string2);
    }

    public void scanMtpFile(String string2, String string3, int n, int n2) {
        InvokeDynamicSupport.bootstrap("scanMtpFile", $$robo$$android_media_MediaScanner$scanMtpFile(java.lang.String java.lang.String int int ), 0, this, string2, string3, n, n2);
    }

    FileEntry makeEntryFor(String string2) {
        return InvokeDynamicSupport.bootstrap("makeEntryFor", $$robo$$android_media_MediaScanner$makeEntryFor(java.lang.String ), 0, this, string2);
    }

    private int matchPaths(String string2, String string3) {
        return (int)InvokeDynamicSupport.bootstrap("matchPaths", $$robo$$android_media_MediaScanner$matchPaths(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    private boolean matchEntries(long l, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("matchEntries", $$robo$$android_media_MediaScanner$matchEntries(long java.lang.String ), 0, this, l, string2);
    }

    private void cachePlaylistEntry(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("cachePlaylistEntry", $$robo$$android_media_MediaScanner$cachePlaylistEntry(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    private void processCachedPlaylist(Cursor cursor, ContentValues contentValues, Uri uri) {
        InvokeDynamicSupport.bootstrap("processCachedPlaylist", $$robo$$android_media_MediaScanner$processCachedPlaylist(android.database.Cursor android.content.ContentValues android.net.Uri ), 0, this, cursor, contentValues, uri);
    }

    private void processM3uPlayList(String string2, String string3, Uri uri, ContentValues contentValues, Cursor cursor) {
        InvokeDynamicSupport.bootstrap("processM3uPlayList", $$robo$$android_media_MediaScanner$processM3uPlayList(java.lang.String java.lang.String android.net.Uri android.content.ContentValues android.database.Cursor ), 0, this, string2, string3, uri, contentValues, cursor);
    }

    private void processPlsPlayList(String string2, String string3, Uri uri, ContentValues contentValues, Cursor cursor) {
        InvokeDynamicSupport.bootstrap("processPlsPlayList", $$robo$$android_media_MediaScanner$processPlsPlayList(java.lang.String java.lang.String android.net.Uri android.content.ContentValues android.database.Cursor ), 0, this, string2, string3, uri, contentValues, cursor);
    }

    private void processWplPlayList(String string2, String string3, Uri uri, ContentValues contentValues, Cursor cursor) {
        InvokeDynamicSupport.bootstrap("processWplPlayList", $$robo$$android_media_MediaScanner$processWplPlayList(java.lang.String java.lang.String android.net.Uri android.content.ContentValues android.database.Cursor ), 0, this, string2, string3, uri, contentValues, cursor);
    }

    private void processPlayList(FileEntry fileEntry, Cursor cursor) throws RemoteException {
        InvokeDynamicSupport.bootstrap("processPlayList", $$robo$$android_media_MediaScanner$processPlayList(android.media.MediaScanner$FileEntry android.database.Cursor ), 0, this, fileEntry, cursor);
    }

    private void processPlayLists() throws RemoteException {
        InvokeDynamicSupport.bootstrap("processPlayLists", $$robo$$android_media_MediaScanner$processPlayLists(), 0, this);
    }

    private final native /* synthetic */ void $$robo$$processDirectory$nativeBinding(String var1, MediaScannerClient var2);

    private void processDirectory(String string2, MediaScannerClient mediaScannerClient) {
        InvokeDynamicSupport.bootstrap("processDirectory", $$robo$$android_media_MediaScanner$processDirectory(java.lang.String android.media.MediaScannerClient ), 1, this, string2, mediaScannerClient);
    }

    private final native /* synthetic */ void $$robo$$processFile$nativeBinding(String var1, String var2, MediaScannerClient var3);

    private void processFile(String string2, String string3, MediaScannerClient mediaScannerClient) {
        InvokeDynamicSupport.bootstrap("processFile", $$robo$$android_media_MediaScanner$processFile(java.lang.String java.lang.String android.media.MediaScannerClient ), 1, this, string2, string3, mediaScannerClient);
    }

    private final native /* synthetic */ void $$robo$$setLocale$nativeBinding(String var1);

    public void setLocale(String string2) {
        InvokeDynamicSupport.bootstrap("setLocale", $$robo$$android_media_MediaScanner$setLocale(java.lang.String ), 1, this, string2);
    }

    private final native /* synthetic */ byte[] $$robo$$extractAlbumArt$nativeBinding(FileDescriptor var1);

    public byte[] extractAlbumArt(FileDescriptor fileDescriptor) {
        return InvokeDynamicSupport.bootstrap("extractAlbumArt", $$robo$$android_media_MediaScanner$extractAlbumArt(java.io.FileDescriptor ), 1, this, fileDescriptor);
    }

    private static final native /* synthetic */ void $$robo$$native_init$nativeBinding();

    private static void native_init() {
        InvokeDynamicSupport.bootstrapStatic("native_init", $$robo$$android_media_MediaScanner$native_init(), 1);
    }

    private final native /* synthetic */ void $$robo$$native_setup$nativeBinding();

    private void native_setup() {
        InvokeDynamicSupport.bootstrap("native_setup", $$robo$$android_media_MediaScanner$native_setup(), 1, this);
    }

    private final native /* synthetic */ void $$robo$$native_finalize$nativeBinding();

    private void native_finalize() {
        InvokeDynamicSupport.bootstrap("native_finalize", $$robo$$android_media_MediaScanner$native_finalize(), 1, this);
    }

    public void release() {
        InvokeDynamicSupport.bootstrap("release", $$robo$$android_media_MediaScanner$release(), 0, this);
    }

    protected void finalize() {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_media_MediaScanner$finalize(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(MediaScanner.class);
    }

    public /* synthetic */ MediaScanner() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MediaScanner)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public class WplHandler
    implements ElementListener,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        ContentHandler handler;
        String playListDirectory;
        /* synthetic */ MediaScanner this$0;

        private void $$robo$$android_media_MediaScanner_WplHandler$__constructor__(MediaScanner mediaScanner, String playListDirectory, Uri uri, Cursor fileList) {
            this.playListDirectory = playListDirectory;
            RootElement root = new RootElement("smil");
            Element body = root.getChild("body");
            Element seq = body.getChild("seq");
            Element media = seq.getChild("media");
            media.setElementListener(this);
            this.handler = root.getContentHandler();
        }

        private final void $$robo$$android_media_MediaScanner_WplHandler$start(Attributes attributes) {
            String path = attributes.getValue("", "src");
            if (path != null) {
                this.this$0.cachePlaylistEntry(path, this.playListDirectory);
            }
        }

        private final void $$robo$$android_media_MediaScanner_WplHandler$end() {
        }

        private final ContentHandler $$robo$$android_media_MediaScanner_WplHandler$getContentHandler() {
            return this.handler;
        }

        private void __constructor__(MediaScanner mediaScanner, String string2, Uri uri, Cursor cursor) {
            this.$$robo$$android_media_MediaScanner_WplHandler$__constructor__(mediaScanner, string2, uri, cursor);
        }

        public WplHandler(MediaScanner mediaScanner, String string2, Uri uri, Cursor cursor) {
            this.this$0 = mediaScanner;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaScanner_WplHandler$__constructor__(android.media.MediaScanner java.lang.String android.net.Uri android.database.Cursor ), 0, this, mediaScanner, string2, uri, cursor);
        }

        @Override
        public void start(Attributes attributes) {
            InvokeDynamicSupport.bootstrap("start", $$robo$$android_media_MediaScanner_WplHandler$start(org.xml.sax.Attributes ), 0, this, attributes);
        }

        @Override
        public void end() {
            InvokeDynamicSupport.bootstrap("end", $$robo$$android_media_MediaScanner_WplHandler$end(), 0, this);
        }

        ContentHandler getContentHandler() {
            return InvokeDynamicSupport.bootstrap("getContentHandler", $$robo$$android_media_MediaScanner_WplHandler$getContentHandler(), 0, this);
        }

        public /* synthetic */ WplHandler() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WplHandler)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class MediaBulkDeleter
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        StringBuilder whereClause;
        ArrayList<String> whereArgs;
        IContentProvider mProvider;
        String mPackageName;
        Uri mBaseUri;

        private void $$robo$$android_media_MediaScanner_MediaBulkDeleter$__constructor__(IContentProvider provider, String packageName, Uri baseUri) {
            this.whereClause = new StringBuilder();
            this.whereArgs = new ArrayList(100);
            this.mProvider = provider;
            this.mPackageName = packageName;
            this.mBaseUri = baseUri;
        }

        private final void $$robo$$android_media_MediaScanner_MediaBulkDeleter$delete(long id2) throws RemoteException {
            if (this.whereClause.length() != 0) {
                this.whereClause.append(",");
            }
            this.whereClause.append("?");
            this.whereArgs.add("" + id2);
            if (this.whereArgs.size() > 100) {
                this.flush();
            }
        }

        private final void $$robo$$android_media_MediaScanner_MediaBulkDeleter$flush() throws RemoteException {
            int size = this.whereArgs.size();
            if (size > 0) {
                String[] foo = new String[size];
                foo = this.whereArgs.toArray(foo);
                int numrows = this.mProvider.delete(this.mPackageName, this.mBaseUri, "_id IN (" + this.whereClause.toString() + ")", foo);
                this.whereClause.setLength(0);
                this.whereArgs.clear();
            }
        }

        private void __constructor__(IContentProvider iContentProvider, String string2, Uri uri) {
            this.$$robo$$android_media_MediaScanner_MediaBulkDeleter$__constructor__(iContentProvider, string2, uri);
        }

        public MediaBulkDeleter(IContentProvider iContentProvider, String string2, Uri uri) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaScanner_MediaBulkDeleter$__constructor__(android.content.IContentProvider java.lang.String android.net.Uri ), 0, this, iContentProvider, string2, uri);
        }

        public void delete(long l) throws RemoteException {
            InvokeDynamicSupport.bootstrap("delete", $$robo$$android_media_MediaScanner_MediaBulkDeleter$delete(long ), 0, this, l);
        }

        public void flush() throws RemoteException {
            InvokeDynamicSupport.bootstrap("flush", $$robo$$android_media_MediaScanner_MediaBulkDeleter$flush(), 0, this);
        }

        public /* synthetic */ MediaBulkDeleter() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MediaBulkDeleter)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class MyMediaScannerClient
    implements MediaScannerClient,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private String mArtist;
        private String mAlbumArtist;
        private String mAlbum;
        private String mTitle;
        private String mComposer;
        private String mGenre;
        private String mMimeType;
        private int mFileType;
        private int mTrack;
        private int mYear;
        private int mDuration;
        private String mPath;
        private long mLastModified;
        private long mFileSize;
        private String mWriter;
        private int mCompilation;
        private boolean mIsDrm;
        private boolean mNoMedia;
        private int mWidth;
        private int mHeight;
        /* synthetic */ MediaScanner this$0;

        private void $$robo$$android_media_MediaScanner_MyMediaScannerClient$__constructor__(MediaScanner mediaScanner) {
        }

        private final FileEntry $$robo$$android_media_MediaScanner_MyMediaScannerClient$beginFile(String path, String mimeType, long lastModified, long fileSize, boolean isDirectory, boolean noMedia) {
            boolean wasModified;
            FileEntry entry;
            this.mMimeType = mimeType;
            this.mFileType = 0;
            this.mFileSize = fileSize;
            this.mIsDrm = false;
            if (!isDirectory) {
                MediaFile.MediaFileType mediaFileType;
                if (!noMedia && MediaScanner.isNoMediaFile(path)) {
                    noMedia = true;
                }
                this.mNoMedia = noMedia;
                if (mimeType != null) {
                    this.mFileType = MediaFile.getFileTypeForMimeType(mimeType);
                }
                if (this.mFileType == 0 && (mediaFileType = MediaFile.getFileType(path)) != null) {
                    this.mFileType = mediaFileType.fileType;
                    if (this.mMimeType == null) {
                        this.mMimeType = mediaFileType.mimeType;
                    }
                }
                if (this.this$0.isDrmEnabled() && MediaFile.isDrmFileType(this.mFileType)) {
                    this.mFileType = this.getFileTypeFromDrm(path);
                }
            }
            long delta = (entry = this.this$0.makeEntryFor(path)) != null ? lastModified - entry.mLastModified : 0L;
            boolean bl = wasModified = delta > 1L || delta < -1L;
            if (entry == null || wasModified) {
                if (wasModified) {
                    entry.mLastModified = lastModified;
                } else {
                    entry = new FileEntry(0L, path, lastModified, isDirectory ? 12289 : 0);
                }
                entry.mLastModifiedChanged = true;
            }
            if (this.this$0.mProcessPlaylists && MediaFile.isPlayListFileType(this.mFileType)) {
                this.this$0.mPlayLists.add(entry);
                return null;
            }
            this.mArtist = null;
            this.mAlbumArtist = null;
            this.mAlbum = null;
            this.mTitle = null;
            this.mComposer = null;
            this.mGenre = null;
            this.mTrack = 0;
            this.mYear = 0;
            this.mDuration = 0;
            this.mPath = path;
            this.mLastModified = lastModified;
            this.mWriter = null;
            this.mCompilation = 0;
            this.mWidth = 0;
            this.mHeight = 0;
            return entry;
        }

        private final void $$robo$$android_media_MediaScanner_MyMediaScannerClient$scanFile(String path, long lastModified, long fileSize, boolean isDirectory, boolean noMedia) {
            this.doScanFile(path, null, lastModified, fileSize, isDirectory, false, noMedia);
        }

        private final Uri $$robo$$android_media_MediaScanner_MyMediaScannerClient$doScanFile(String path, String mimeType, long lastModified, long fileSize, boolean isDirectory, boolean scanAlways, boolean noMedia) {
            Uri result = null;
            try {
                FileEntry entry = this.beginFile(path, mimeType, lastModified, fileSize, isDirectory, noMedia);
                if (this.this$0.mMtpObjectHandle != 0) {
                    entry.mRowId = 0L;
                }
                if (entry != null && (entry.mLastModifiedChanged || scanAlways)) {
                    if (noMedia) {
                        result = this.endFile(entry, false, false, false, false, false);
                    } else {
                        String directPath;
                        File f;
                        String lowpath = path.toLowerCase(Locale.ROOT);
                        boolean ringtones = lowpath.indexOf("/ringtones/") > 0;
                        boolean notifications = lowpath.indexOf("/notifications/") > 0;
                        boolean alarms = lowpath.indexOf("/alarms/") > 0;
                        boolean podcasts = lowpath.indexOf("/podcasts/") > 0;
                        boolean music = lowpath.indexOf("/music/") > 0 || !ringtones && !notifications && !alarms && !podcasts;
                        boolean isaudio = MediaFile.isAudioFileType(this.mFileType);
                        boolean isvideo = MediaFile.isVideoFileType(this.mFileType);
                        boolean isimage = MediaFile.isImageFileType(this.mFileType);
                        if ((isaudio || isvideo || isimage) && this.this$0.mExternalIsEmulated && path.startsWith(this.this$0.mExternalStoragePath) && (f = new File(directPath = Environment.getMediaStorageDirectory() + path.substring(this.this$0.mExternalStoragePath.length()))).exists()) {
                            path = directPath;
                        }
                        if (isaudio || isvideo) {
                            this.this$0.processFile(path, mimeType, this);
                        }
                        if (isimage) {
                            this.processImageFile(path);
                        }
                        result = this.endFile(entry, ringtones, notifications, alarms, music, podcasts);
                    }
                }
            }
            catch (RemoteException e) {
                Log.e("MediaScanner", "RemoteException in MediaScanner.scanFile()", e);
            }
            return result;
        }

        private final int $$robo$$android_media_MediaScanner_MyMediaScannerClient$parseSubstring(String s, int start, int defaultValue) {
            char ch;
            int length = s.length();
            if (start == length) {
                return defaultValue;
            }
            if ((ch = s.charAt(start++)) < '0' || ch > '9') {
                return defaultValue;
            }
            int result = ch - 48;
            while (start < length) {
                if ((ch = s.charAt(start++)) < '0' || ch > '9') {
                    return result;
                }
                result = result * 10 + (ch - 48);
            }
            return result;
        }

        private final void $$robo$$android_media_MediaScanner_MyMediaScannerClient$handleStringTag(String name, String value) {
            if (name.equalsIgnoreCase("title") || name.startsWith("title;")) {
                this.mTitle = value;
            } else if (name.equalsIgnoreCase("artist") || name.startsWith("artist;")) {
                this.mArtist = value.trim();
            } else if (name.equalsIgnoreCase("albumartist") || name.startsWith("albumartist;") || name.equalsIgnoreCase("band") || name.startsWith("band;")) {
                this.mAlbumArtist = value.trim();
            } else if (name.equalsIgnoreCase("album") || name.startsWith("album;")) {
                this.mAlbum = value.trim();
            } else if (name.equalsIgnoreCase("composer") || name.startsWith("composer;")) {
                this.mComposer = value.trim();
            } else if (this.this$0.mProcessGenres && (name.equalsIgnoreCase("genre") || name.startsWith("genre;"))) {
                this.mGenre = this.getGenreName(value);
            } else if (name.equalsIgnoreCase("year") || name.startsWith("year;")) {
                this.mYear = this.parseSubstring(value, 0, 0);
            } else if (name.equalsIgnoreCase("tracknumber") || name.startsWith("tracknumber;")) {
                int num = this.parseSubstring(value, 0, 0);
                this.mTrack = this.mTrack / 1000 * 1000 + num;
            } else if (name.equalsIgnoreCase("discnumber") || name.equals("set") || name.startsWith("set;")) {
                int num = this.parseSubstring(value, 0, 0);
                this.mTrack = num * 1000 + this.mTrack % 1000;
            } else if (name.equalsIgnoreCase("duration")) {
                this.mDuration = this.parseSubstring(value, 0, 0);
            } else if (name.equalsIgnoreCase("writer") || name.startsWith("writer;")) {
                this.mWriter = value.trim();
            } else if (name.equalsIgnoreCase("compilation")) {
                this.mCompilation = this.parseSubstring(value, 0, 0);
            } else if (name.equalsIgnoreCase("isdrm")) {
                this.mIsDrm = this.parseSubstring(value, 0, 0) == 1;
            } else if (name.equalsIgnoreCase("width")) {
                this.mWidth = this.parseSubstring(value, 0, 0);
            } else if (name.equalsIgnoreCase("height")) {
                this.mHeight = this.parseSubstring(value, 0, 0);
            }
        }

        private final boolean $$robo$$android_media_MediaScanner_MyMediaScannerClient$convertGenreCode(String input, String expected) {
            String output = this.getGenreName(input);
            if (output.equals(expected)) {
                return true;
            }
            Log.d("MediaScanner", "'" + input + "' -> '" + output + "', expected '" + expected + "'");
            return false;
        }

        private final void $$robo$$android_media_MediaScanner_MyMediaScannerClient$testGenreNameConverter() {
            this.convertGenreCode("2", "Country");
            this.convertGenreCode("(2)", "Country");
            this.convertGenreCode("(2", "(2");
            this.convertGenreCode("2 Foo", "Country");
            this.convertGenreCode("(2) Foo", "Country");
            this.convertGenreCode("(2 Foo", "(2 Foo");
            this.convertGenreCode("2Foo", "2Foo");
            this.convertGenreCode("(2)Foo", "Country");
            this.convertGenreCode("200 Foo", "Foo");
            this.convertGenreCode("(200) Foo", "Foo");
            this.convertGenreCode("200Foo", "200Foo");
            this.convertGenreCode("(200)Foo", "Foo");
            this.convertGenreCode("200)Foo", "200)Foo");
            this.convertGenreCode("200) Foo", "200) Foo");
        }

        private final String $$robo$$android_media_MediaScanner_MyMediaScannerClient$getGenreName(String genreTagValue) {
            block12: {
                if (genreTagValue == null) {
                    return null;
                }
                int length = genreTagValue.length();
                if (length > 0) {
                    char charAfterNumber;
                    int i;
                    boolean parenthesized = false;
                    StringBuffer number = new StringBuffer();
                    for (i = 0; i < length; ++i) {
                        char c = genreTagValue.charAt(i);
                        if (i == 0 && c == '(') {
                            parenthesized = true;
                            continue;
                        }
                        if (!Character.isDigit(c)) break;
                        number.append(c);
                    }
                    char c = charAfterNumber = i < length ? (char)genreTagValue.charAt(i) : (char)' ';
                    if (parenthesized && charAfterNumber == ')' || !parenthesized && Character.isWhitespace(charAfterNumber)) {
                        try {
                            short genreIndex = Short.parseShort(number.toString());
                            if (genreIndex < 0) break block12;
                            if (genreIndex < ID3_GENRES.length && ID3_GENRES[genreIndex] != null) {
                                return ID3_GENRES[genreIndex];
                            }
                            if (genreIndex == 255) {
                                return null;
                            }
                            if (genreIndex < 255 && i + 1 < length) {
                                String ret;
                                if (parenthesized && charAfterNumber == ')') {
                                    ++i;
                                }
                                if ((ret = genreTagValue.substring(i).trim()).length() != 0) {
                                    return ret;
                                }
                                break block12;
                            }
                            return number.toString();
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
            }
            return genreTagValue;
        }

        private final void $$robo$$android_media_MediaScanner_MyMediaScannerClient$processImageFile(String path) {
            try {
                ((MediaScanner)this.this$0).mBitmapOptions.outWidth = 0;
                ((MediaScanner)this.this$0).mBitmapOptions.outHeight = 0;
                BitmapFactory.decodeFile(path, this.this$0.mBitmapOptions);
                this.mWidth = ((MediaScanner)this.this$0).mBitmapOptions.outWidth;
                this.mHeight = ((MediaScanner)this.this$0).mBitmapOptions.outHeight;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        private final void $$robo$$android_media_MediaScanner_MyMediaScannerClient$setMimeType(String mimeType) {
            if ("audio/mp4".equals(this.mMimeType) && mimeType.startsWith("video")) {
                return;
            }
            this.mMimeType = mimeType;
            this.mFileType = MediaFile.getFileTypeForMimeType(mimeType);
        }

        private final ContentValues $$robo$$android_media_MediaScanner_MyMediaScannerClient$toValues() {
            ContentValues map = new ContentValues();
            map.put("_data", this.mPath);
            map.put("title", this.mTitle);
            map.put("date_modified", this.mLastModified);
            map.put("_size", this.mFileSize);
            map.put("mime_type", this.mMimeType);
            map.put("is_drm", this.mIsDrm);
            String resolution = null;
            if (this.mWidth > 0 && this.mHeight > 0) {
                map.put("width", this.mWidth);
                map.put("height", this.mHeight);
                resolution = this.mWidth + "x" + this.mHeight;
            }
            if (!this.mNoMedia) {
                if (MediaFile.isVideoFileType(this.mFileType)) {
                    map.put("artist", this.mArtist != null && this.mArtist.length() > 0 ? this.mArtist : "<unknown>");
                    map.put("album", this.mAlbum != null && this.mAlbum.length() > 0 ? this.mAlbum : "<unknown>");
                    map.put("duration", this.mDuration);
                    if (resolution != null) {
                        map.put("resolution", resolution);
                    }
                } else if (!MediaFile.isImageFileType(this.mFileType) && MediaFile.isAudioFileType(this.mFileType)) {
                    map.put("artist", this.mArtist != null && this.mArtist.length() > 0 ? this.mArtist : "<unknown>");
                    map.put("album_artist", this.mAlbumArtist != null && this.mAlbumArtist.length() > 0 ? this.mAlbumArtist : null);
                    map.put("album", this.mAlbum != null && this.mAlbum.length() > 0 ? this.mAlbum : "<unknown>");
                    map.put("composer", this.mComposer);
                    map.put("genre", this.mGenre);
                    if (this.mYear != 0) {
                        map.put("year", this.mYear);
                    }
                    map.put("track", this.mTrack);
                    map.put("duration", this.mDuration);
                    map.put("compilation", this.mCompilation);
                }
            }
            return map;
        }

        private final Uri $$robo$$android_media_MediaScanner_MyMediaScannerClient$endFile(FileEntry entry, boolean ringtones, boolean notifications, boolean alarms, boolean music, boolean podcasts) throws RemoteException {
            int lastSlash;
            String album;
            ContentValues values;
            String title;
            if (this.mArtist == null || this.mArtist.length() == 0) {
                this.mArtist = this.mAlbumArtist;
            }
            if ((title = (values = this.toValues()).getAsString("title")) == null || TextUtils.isEmpty(title.trim())) {
                title = MediaFile.getFileTitle(values.getAsString("_data"));
                values.put("title", title);
            }
            if ("<unknown>".equals(album = values.getAsString("album")) && (lastSlash = (album = values.getAsString("_data")).lastIndexOf(47)) >= 0) {
                int idx;
                int previousSlash = 0;
                while ((idx = album.indexOf(47, previousSlash + 1)) >= 0 && idx < lastSlash) {
                    previousSlash = idx;
                }
                if (previousSlash != 0) {
                    album = album.substring(previousSlash + 1, lastSlash);
                    values.put("album", album);
                }
            }
            long rowId = entry.mRowId;
            if (MediaFile.isAudioFileType(this.mFileType) && (rowId == 0L || this.this$0.mMtpObjectHandle != 0)) {
                values.put("is_ringtone", ringtones);
                values.put("is_notification", notifications);
                values.put("is_alarm", alarms);
                values.put("is_music", music);
                values.put("is_podcast", podcasts);
            } else if (this.mFileType == 31 && !this.mNoMedia) {
                ExifInterface exif = null;
                try {
                    exif = new ExifInterface(entry.mPath);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (exif != null) {
                    long time;
                    float[] latlng = new float[2];
                    if (exif.getLatLong(latlng)) {
                        values.put("latitude", Float.valueOf(latlng[0]));
                        values.put("longitude", Float.valueOf(latlng[1]));
                    }
                    if ((time = exif.getGpsDateTime()) != -1L) {
                        values.put("datetaken", time);
                    } else {
                        time = exif.getDateTime();
                        if (time != -1L && Math.abs(this.mLastModified * 1000L - time) >= 86400000L) {
                            values.put("datetaken", time);
                        }
                    }
                    int orientation = exif.getAttributeInt("Orientation", -1);
                    if (orientation != -1) {
                        int degree;
                        switch (orientation) {
                            case 6: {
                                degree = 90;
                                break;
                            }
                            case 3: {
                                degree = 180;
                                break;
                            }
                            case 8: {
                                degree = 270;
                                break;
                            }
                            default: {
                                degree = 0;
                            }
                        }
                        values.put("orientation", degree);
                    }
                }
            }
            Uri tableUri = this.this$0.mFilesUri;
            MediaInserter inserter = this.this$0.mMediaInserter;
            if (!this.mNoMedia) {
                if (MediaFile.isVideoFileType(this.mFileType)) {
                    tableUri = this.this$0.mVideoUri;
                } else if (MediaFile.isImageFileType(this.mFileType)) {
                    tableUri = this.this$0.mImagesUri;
                } else if (MediaFile.isAudioFileType(this.mFileType)) {
                    tableUri = this.this$0.mAudioUri;
                }
            }
            Uri result = null;
            boolean needToSetSettings = false;
            if (rowId == 0L) {
                if (this.this$0.mMtpObjectHandle != 0) {
                    values.put("media_scanner_new_object_id", this.this$0.mMtpObjectHandle);
                }
                if (tableUri == this.this$0.mFilesUri) {
                    int format = entry.mFormat;
                    if (format == 0) {
                        format = MediaFile.getFormatCode(entry.mPath, this.mMimeType);
                    }
                    values.put("format", format);
                }
                if (this.this$0.mWasEmptyPriorToScan) {
                    if (notifications && !this.this$0.mDefaultNotificationSet) {
                        if (TextUtils.isEmpty(this.this$0.mDefaultNotificationFilename) || this.doesPathHaveFilename(entry.mPath, this.this$0.mDefaultNotificationFilename)) {
                            needToSetSettings = true;
                        }
                    } else if (ringtones && !this.this$0.mDefaultRingtoneSet) {
                        if (TextUtils.isEmpty(this.this$0.mDefaultRingtoneFilename) || this.doesPathHaveFilename(entry.mPath, this.this$0.mDefaultRingtoneFilename)) {
                            needToSetSettings = true;
                        }
                    } else if (alarms && !this.this$0.mDefaultAlarmSet && (TextUtils.isEmpty(this.this$0.mDefaultAlarmAlertFilename) || this.doesPathHaveFilename(entry.mPath, this.this$0.mDefaultAlarmAlertFilename))) {
                        needToSetSettings = true;
                    }
                }
                if (inserter == null || needToSetSettings) {
                    if (inserter != null) {
                        inserter.flushAll();
                    }
                    result = this.this$0.mMediaProvider.insert(this.this$0.mPackageName, tableUri, values);
                } else if (entry.mFormat == 12289) {
                    inserter.insertwithPriority(tableUri, values);
                } else {
                    inserter.insert(tableUri, values);
                }
                if (result != null) {
                    entry.mRowId = rowId = ContentUris.parseId(result);
                }
            } else {
                result = ContentUris.withAppendedId(tableUri, rowId);
                values.remove("_data");
                int mediaType = 0;
                if (!MediaScanner.isNoMediaPath(entry.mPath)) {
                    int fileType = MediaFile.getFileTypeForMimeType(this.mMimeType);
                    if (MediaFile.isAudioFileType(fileType)) {
                        mediaType = 2;
                    } else if (MediaFile.isVideoFileType(fileType)) {
                        mediaType = 3;
                    } else if (MediaFile.isImageFileType(fileType)) {
                        mediaType = 1;
                    } else if (MediaFile.isPlayListFileType(fileType)) {
                        mediaType = 4;
                    }
                    values.put("media_type", mediaType);
                }
                this.this$0.mMediaProvider.update(this.this$0.mPackageName, result, values, null, null);
            }
            if (needToSetSettings) {
                if (notifications) {
                    this.setSettingIfNotSet("notification_sound", tableUri, rowId);
                    this.this$0.mDefaultNotificationSet = true;
                } else if (ringtones) {
                    this.setSettingIfNotSet("ringtone", tableUri, rowId);
                    this.this$0.mDefaultRingtoneSet = true;
                } else if (alarms) {
                    this.setSettingIfNotSet("alarm_alert", tableUri, rowId);
                    this.this$0.mDefaultAlarmSet = true;
                }
            }
            return result;
        }

        private final boolean $$robo$$android_media_MediaScanner_MyMediaScannerClient$doesPathHaveFilename(String path, String filename) {
            int filenameLength;
            int pathFilenameStart = path.lastIndexOf(File.separatorChar) + 1;
            return path.regionMatches(pathFilenameStart, filename, 0, filenameLength = filename.length()) && pathFilenameStart + filenameLength == path.length();
        }

        private final void $$robo$$android_media_MediaScanner_MyMediaScannerClient$setSettingIfNotSet(String settingName, Uri uri, long rowId) {
            String existingSettingValue = Settings.System.getString(this.this$0.mContext.getContentResolver(), settingName);
            if (TextUtils.isEmpty(existingSettingValue)) {
                Settings.System.putString(this.this$0.mContext.getContentResolver(), settingName, ContentUris.withAppendedId(uri, rowId).toString());
            }
        }

        private final int $$robo$$android_media_MediaScanner_MyMediaScannerClient$getFileTypeFromDrm(String path) {
            if (!this.this$0.isDrmEnabled()) {
                return 0;
            }
            int resultFileType = 0;
            if (this.this$0.mDrmManagerClient == null) {
                this.this$0.mDrmManagerClient = new DrmManagerClient(this.this$0.mContext);
            }
            if (this.this$0.mDrmManagerClient.canHandle(path, null)) {
                this.mIsDrm = true;
                String drmMimetype = this.this$0.mDrmManagerClient.getOriginalMimeType(path);
                if (drmMimetype != null) {
                    this.mMimeType = drmMimetype;
                    resultFileType = MediaFile.getFileTypeForMimeType(drmMimetype);
                }
            }
            return resultFileType;
        }

        private /* synthetic */ void $$robo$$android_media_MediaScanner_MyMediaScannerClient$__constructor__(MediaScanner x0, 1 x1) {
        }

        private void __constructor__(MediaScanner mediaScanner) {
            this.$$robo$$android_media_MediaScanner_MyMediaScannerClient$__constructor__(mediaScanner);
        }

        private MyMediaScannerClient(MediaScanner mediaScanner) {
            this.this$0 = mediaScanner;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaScanner_MyMediaScannerClient$__constructor__(android.media.MediaScanner ), 0, this, mediaScanner);
        }

        public FileEntry beginFile(String string2, String string3, long l, long l2, boolean bl, boolean bl2) {
            return InvokeDynamicSupport.bootstrap("beginFile", $$robo$$android_media_MediaScanner_MyMediaScannerClient$beginFile(java.lang.String java.lang.String long long boolean boolean ), 0, this, string2, string3, l, l2, bl, bl2);
        }

        @Override
        public void scanFile(String string2, long l, long l2, boolean bl, boolean bl2) {
            InvokeDynamicSupport.bootstrap("scanFile", $$robo$$android_media_MediaScanner_MyMediaScannerClient$scanFile(java.lang.String long long boolean boolean ), 0, this, string2, l, l2, bl, bl2);
        }

        public Uri doScanFile(String string2, String string3, long l, long l2, boolean bl, boolean bl2, boolean bl3) {
            return InvokeDynamicSupport.bootstrap("doScanFile", $$robo$$android_media_MediaScanner_MyMediaScannerClient$doScanFile(java.lang.String java.lang.String long long boolean boolean boolean ), 0, this, string2, string3, l, l2, bl, bl2, bl3);
        }

        private int parseSubstring(String string2, int n, int n2) {
            return (int)InvokeDynamicSupport.bootstrap("parseSubstring", $$robo$$android_media_MediaScanner_MyMediaScannerClient$parseSubstring(java.lang.String int int ), 0, this, string2, n, n2);
        }

        @Override
        public void handleStringTag(String string2, String string3) {
            InvokeDynamicSupport.bootstrap("handleStringTag", $$robo$$android_media_MediaScanner_MyMediaScannerClient$handleStringTag(java.lang.String java.lang.String ), 0, this, string2, string3);
        }

        private boolean convertGenreCode(String string2, String string3) {
            return (boolean)InvokeDynamicSupport.bootstrap("convertGenreCode", $$robo$$android_media_MediaScanner_MyMediaScannerClient$convertGenreCode(java.lang.String java.lang.String ), 0, this, string2, string3);
        }

        private void testGenreNameConverter() {
            InvokeDynamicSupport.bootstrap("testGenreNameConverter", $$robo$$android_media_MediaScanner_MyMediaScannerClient$testGenreNameConverter(), 0, this);
        }

        public String getGenreName(String string2) {
            return InvokeDynamicSupport.bootstrap("getGenreName", $$robo$$android_media_MediaScanner_MyMediaScannerClient$getGenreName(java.lang.String ), 0, this, string2);
        }

        private void processImageFile(String string2) {
            InvokeDynamicSupport.bootstrap("processImageFile", $$robo$$android_media_MediaScanner_MyMediaScannerClient$processImageFile(java.lang.String ), 0, this, string2);
        }

        @Override
        public void setMimeType(String string2) {
            InvokeDynamicSupport.bootstrap("setMimeType", $$robo$$android_media_MediaScanner_MyMediaScannerClient$setMimeType(java.lang.String ), 0, this, string2);
        }

        private ContentValues toValues() {
            return InvokeDynamicSupport.bootstrap("toValues", $$robo$$android_media_MediaScanner_MyMediaScannerClient$toValues(), 0, this);
        }

        private Uri endFile(FileEntry fileEntry, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) throws RemoteException {
            return InvokeDynamicSupport.bootstrap("endFile", $$robo$$android_media_MediaScanner_MyMediaScannerClient$endFile(android.media.MediaScanner$FileEntry boolean boolean boolean boolean boolean ), 0, this, fileEntry, bl, bl2, bl3, bl4, bl5);
        }

        private boolean doesPathHaveFilename(String string2, String string3) {
            return (boolean)InvokeDynamicSupport.bootstrap("doesPathHaveFilename", $$robo$$android_media_MediaScanner_MyMediaScannerClient$doesPathHaveFilename(java.lang.String java.lang.String ), 0, this, string2, string3);
        }

        private void setSettingIfNotSet(String string2, Uri uri, long l) {
            InvokeDynamicSupport.bootstrap("setSettingIfNotSet", $$robo$$android_media_MediaScanner_MyMediaScannerClient$setSettingIfNotSet(java.lang.String android.net.Uri long ), 0, this, string2, uri, l);
        }

        private int getFileTypeFromDrm(String string2) {
            return (int)InvokeDynamicSupport.bootstrap("getFileTypeFromDrm", $$robo$$android_media_MediaScanner_MyMediaScannerClient$getFileTypeFromDrm(java.lang.String ), 0, this, string2);
        }

        private /* synthetic */ void __constructor__(MediaScanner mediaScanner, 1 var2_2) {
            this.$$robo$$android_media_MediaScanner_MyMediaScannerClient$__constructor__(mediaScanner, var2_2);
        }

        public /* synthetic */ MyMediaScannerClient() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MyMediaScannerClient)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class PlaylistEntry
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        String path;
        long bestmatchid;
        int bestmatchlevel;

        private void $$robo$$android_media_MediaScanner_PlaylistEntry$__constructor__() {
        }

        private /* synthetic */ void $$robo$$android_media_MediaScanner_PlaylistEntry$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_media_MediaScanner_PlaylistEntry$__constructor__();
        }

        private PlaylistEntry() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaScanner_PlaylistEntry$__constructor__(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_media_MediaScanner_PlaylistEntry$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PlaylistEntry)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class FileEntry
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        long mRowId;
        String mPath;
        long mLastModified;
        int mFormat;
        boolean mLastModifiedChanged;

        private void $$robo$$android_media_MediaScanner_FileEntry$__constructor__(long rowId, String path, long lastModified, int format) {
            this.mRowId = rowId;
            this.mPath = path;
            this.mLastModified = lastModified;
            this.mFormat = format;
            this.mLastModifiedChanged = false;
        }

        private final String $$robo$$android_media_MediaScanner_FileEntry$toString() {
            return this.mPath + " mRowId: " + this.mRowId;
        }

        private void __constructor__(long l, String string2, long l2, int n) {
            this.$$robo$$android_media_MediaScanner_FileEntry$__constructor__(l, string2, l2, n);
        }

        FileEntry(long l, String string2, long l2, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaScanner_FileEntry$__constructor__(long java.lang.String long int ), 0, this, l, string2, l2, n);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_media_MediaScanner_FileEntry$toString(), 0, this);
        }

        public /* synthetic */ FileEntry() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FileEntry)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

