/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.os.Parcel;
import android.util.Log;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import java.util.TimeZone;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@Deprecated
public class Metadata
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int ANY = 0;
    public static int PAUSE_AVAILABLE = 1;
    public static int SEEK_BACKWARD_AVAILABLE = 2;
    public static int SEEK_FORWARD_AVAILABLE = 3;
    public static int SEEK_AVAILABLE = 4;
    public static int TITLE = 5;
    public static int COMMENT = 6;
    public static int COPYRIGHT = 7;
    public static int ALBUM = 8;
    public static int ARTIST = 9;
    public static int AUTHOR = 10;
    public static int COMPOSER = 11;
    public static int GENRE = 12;
    public static int DATE = 13;
    public static int DURATION = 14;
    public static int CD_TRACK_NUM = 15;
    public static int CD_TRACK_MAX = 16;
    public static int RATING = 17;
    public static int ALBUM_ART = 18;
    public static int VIDEO_FRAME = 19;
    public static int BIT_RATE = 20;
    public static int AUDIO_BIT_RATE = 21;
    public static int VIDEO_BIT_RATE = 22;
    public static int AUDIO_SAMPLE_RATE = 23;
    public static int VIDEO_FRAME_RATE = 24;
    public static int MIME_TYPE = 25;
    public static int AUDIO_CODEC = 26;
    public static int VIDEO_CODEC = 27;
    public static int VIDEO_HEIGHT = 28;
    public static int VIDEO_WIDTH = 29;
    public static int NUM_TRACKS = 30;
    public static int DRM_CRIPPLED = 31;
    private static int LAST_SYSTEM = 31;
    private static int FIRST_CUSTOM = 8192;
    public static Set<Integer> MATCH_NONE;
    public static Set<Integer> MATCH_ALL;
    public static int STRING_VAL = 1;
    public static int INTEGER_VAL = 2;
    public static int BOOLEAN_VAL = 3;
    public static int LONG_VAL = 4;
    public static int DOUBLE_VAL = 5;
    public static int DATE_VAL = 6;
    public static int BYTE_ARRAY_VAL = 7;
    private static int LAST_TYPE = 7;
    private static String TAG = "media.Metadata";
    private static int kInt32Size = 4;
    private static int kMetaHeaderSize = 8;
    private static int kRecordHeaderSize = 12;
    private static int kMetaMarker = 1296389185;
    private Parcel mParcel;
    private HashMap<Integer, Integer> mKeyToPosMap;

    private void $$robo$$android_media_Metadata$__constructor__() {
        this.mKeyToPosMap = new HashMap();
    }

    private final boolean $$robo$$android_media_Metadata$scanAllRecords(Parcel parcel, int bytesLeft) {
        int recCount = 0;
        boolean error = false;
        this.mKeyToPosMap.clear();
        while (bytesLeft > 12) {
            int start = parcel.dataPosition();
            int size = parcel.readInt();
            if (size <= 12) {
                Log.e("media.Metadata", "Record is too short");
                error = true;
                break;
            }
            int metadataId = parcel.readInt();
            if (!this.checkMetadataId(metadataId)) {
                error = true;
                break;
            }
            if (this.mKeyToPosMap.containsKey(metadataId)) {
                Log.e("media.Metadata", "Duplicate metadata ID found");
                error = true;
                break;
            }
            this.mKeyToPosMap.put(metadataId, parcel.dataPosition());
            int metadataType = parcel.readInt();
            if (metadataType <= 0 || metadataType > 7) {
                Log.e("media.Metadata", "Invalid metadata type " + metadataType);
                error = true;
                break;
            }
            parcel.setDataPosition(start + size);
            bytesLeft -= size;
            ++recCount;
        }
        if (0 != bytesLeft || error) {
            Log.e("media.Metadata", "Ran out of data or error on record " + recCount);
            this.mKeyToPosMap.clear();
            return false;
        }
        return true;
    }

    private final boolean $$robo$$android_media_Metadata$parse(Parcel parcel) {
        if (parcel.dataAvail() < 8) {
            Log.e("media.Metadata", "Not enough data " + parcel.dataAvail());
            return false;
        }
        int pin = parcel.dataPosition();
        int size = parcel.readInt();
        if (parcel.dataAvail() + 4 < size || size < 8) {
            Log.e("media.Metadata", "Bad size " + size + " avail " + parcel.dataAvail() + " position " + pin);
            parcel.setDataPosition(pin);
            return false;
        }
        int kShouldBeMetaMarker = parcel.readInt();
        if (kShouldBeMetaMarker != 1296389185) {
            Log.e("media.Metadata", "Marker missing " + Integer.toHexString(kShouldBeMetaMarker));
            parcel.setDataPosition(pin);
            return false;
        }
        if (!this.scanAllRecords(parcel, size - 8)) {
            parcel.setDataPosition(pin);
            return false;
        }
        this.mParcel = parcel;
        return true;
    }

    private final Set<Integer> $$robo$$android_media_Metadata$keySet() {
        return this.mKeyToPosMap.keySet();
    }

    private final boolean $$robo$$android_media_Metadata$has(int metadataId) {
        if (!this.checkMetadataId(metadataId)) {
            throw new IllegalArgumentException("Invalid key: " + metadataId);
        }
        return this.mKeyToPosMap.containsKey(metadataId);
    }

    private final String $$robo$$android_media_Metadata$getString(int key) {
        this.checkType(key, 1);
        return this.mParcel.readString();
    }

    private final int $$robo$$android_media_Metadata$getInt(int key) {
        this.checkType(key, 2);
        return this.mParcel.readInt();
    }

    private final boolean $$robo$$android_media_Metadata$getBoolean(int key) {
        this.checkType(key, 3);
        return this.mParcel.readInt() == 1;
    }

    private final long $$robo$$android_media_Metadata$getLong(int key) {
        this.checkType(key, 4);
        return this.mParcel.readLong();
    }

    private final double $$robo$$android_media_Metadata$getDouble(int key) {
        this.checkType(key, 5);
        return this.mParcel.readDouble();
    }

    private final byte[] $$robo$$android_media_Metadata$getByteArray(int key) {
        this.checkType(key, 7);
        return this.mParcel.createByteArray();
    }

    private final Date $$robo$$android_media_Metadata$getDate(int key) {
        this.checkType(key, 6);
        long timeSinceEpoch = this.mParcel.readLong();
        String timeZone = this.mParcel.readString();
        if (timeZone.length() == 0) {
            return new Date(timeSinceEpoch);
        }
        TimeZone tz = TimeZone.getTimeZone(timeZone);
        Calendar cal = Calendar.getInstance(tz);
        cal.setTimeInMillis(timeSinceEpoch);
        return cal.getTime();
    }

    private static final int $$robo$$android_media_Metadata$lastSytemId() {
        return 31;
    }

    private static final int $$robo$$android_media_Metadata$firstCustomId() {
        return 8192;
    }

    private static final int $$robo$$android_media_Metadata$lastType() {
        return 7;
    }

    private final boolean $$robo$$android_media_Metadata$checkMetadataId(int val) {
        if (val <= 0 || 31 < val && val < 8192) {
            Log.e("media.Metadata", "Invalid metadata ID " + val);
            return false;
        }
        return true;
    }

    private final void $$robo$$android_media_Metadata$checkType(int key, int expectedType) {
        int pos = this.mKeyToPosMap.get(key);
        this.mParcel.setDataPosition(pos);
        int type = this.mParcel.readInt();
        if (type != expectedType) {
            throw new IllegalStateException("Wrong type " + expectedType + " but got " + type);
        }
    }

    static void __staticInitializer__() {
        MATCH_NONE = Collections.EMPTY_SET;
        MATCH_ALL = Collections.singleton(0);
    }

    private void __constructor__() {
        this.$$robo$$android_media_Metadata$__constructor__();
    }

    public Metadata() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_Metadata$__constructor__(), 0, this);
    }

    private boolean scanAllRecords(Parcel parcel, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("scanAllRecords", $$robo$$android_media_Metadata$scanAllRecords(android.os.Parcel int ), 0, this, parcel, n);
    }

    public boolean parse(Parcel parcel) {
        return (boolean)InvokeDynamicSupport.bootstrap("parse", $$robo$$android_media_Metadata$parse(android.os.Parcel ), 0, this, parcel);
    }

    public Set<Integer> keySet() {
        return InvokeDynamicSupport.bootstrap("keySet", $$robo$$android_media_Metadata$keySet(), 0, this);
    }

    public boolean has(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("has", $$robo$$android_media_Metadata$has(int ), 0, this, n);
    }

    public String getString(int n) {
        return InvokeDynamicSupport.bootstrap("getString", $$robo$$android_media_Metadata$getString(int ), 0, this, n);
    }

    public int getInt(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getInt", $$robo$$android_media_Metadata$getInt(int ), 0, this, n);
    }

    public boolean getBoolean(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("getBoolean", $$robo$$android_media_Metadata$getBoolean(int ), 0, this, n);
    }

    public long getLong(int n) {
        return (long)InvokeDynamicSupport.bootstrap("getLong", $$robo$$android_media_Metadata$getLong(int ), 0, this, n);
    }

    public double getDouble(int n) {
        return (double)InvokeDynamicSupport.bootstrap("getDouble", $$robo$$android_media_Metadata$getDouble(int ), 0, this, n);
    }

    public byte[] getByteArray(int n) {
        return InvokeDynamicSupport.bootstrap("getByteArray", $$robo$$android_media_Metadata$getByteArray(int ), 0, this, n);
    }

    public Date getDate(int n) {
        return InvokeDynamicSupport.bootstrap("getDate", $$robo$$android_media_Metadata$getDate(int ), 0, this, n);
    }

    public static int lastSytemId() {
        return (int)InvokeDynamicSupport.bootstrapStatic("lastSytemId", $$robo$$android_media_Metadata$lastSytemId(), 0);
    }

    public static int firstCustomId() {
        return (int)InvokeDynamicSupport.bootstrapStatic("firstCustomId", $$robo$$android_media_Metadata$firstCustomId(), 0);
    }

    public static int lastType() {
        return (int)InvokeDynamicSupport.bootstrapStatic("lastType", $$robo$$android_media_Metadata$lastType(), 0);
    }

    private boolean checkMetadataId(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("checkMetadataId", $$robo$$android_media_Metadata$checkMetadataId(int ), 0, this, n);
    }

    private void checkType(int n, int n2) {
        InvokeDynamicSupport.bootstrap("checkType", $$robo$$android_media_Metadata$checkType(int int ), 0, this, n, n2);
    }

    static {
        RobolectricInternals.classInitializing(Metadata.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Metadata)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

