/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.media.IRemoteControlClient;
import android.media.IRemoteVolumeObserver;
import android.media.MediaFocusControl;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import java.io.PrintWriter;
import java.util.NoSuchElementException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class PlayerRecord
implements IBinder.DeathRecipient,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "MediaFocusControl";
    private static boolean DEBUG = false;
    private static int sLastRccId;
    public static MediaFocusControl sController;
    private PendingIntent mMediaIntent;
    private ComponentName mReceiverComponent;
    private int mRccId;
    private IBinder mToken;
    private String mCallingPackageName;
    private int mCallingUid;
    private IRemoteControlClient mRcClient;
    private RcClientDeathHandler mRcClientDeathHandler;
    public int mPlaybackType;
    public int mPlaybackVolume;
    public int mPlaybackVolumeMax;
    public int mPlaybackVolumeHandling;
    public int mPlaybackStream;
    public RccPlaybackState mPlaybackState;
    public IRemoteVolumeObserver mRemoteVolumeObs;

    private final void $$robo$$android_media_PlayerRecord$dump(PrintWriter pw, boolean registrationInfo) {
        if (registrationInfo) {
            pw.println("  pi: " + this.mMediaIntent + " -- pack: " + this.mCallingPackageName + "  -- ercvr: " + this.mReceiverComponent + "  -- client: " + this.mRcClient + "  -- uid: " + this.mCallingUid + "  -- type: " + this.mPlaybackType + "  state: " + this.mPlaybackState);
        } else {
            pw.println("  uid: " + this.mCallingUid + "  -- id: " + this.mRccId + "  -- type: " + this.mPlaybackType + "  -- state: " + this.mPlaybackState + "  -- vol handling: " + this.mPlaybackVolumeHandling + "  -- vol: " + this.mPlaybackVolume + "  -- volMax: " + this.mPlaybackVolumeMax + "  -- volObs: " + this.mRemoteVolumeObs);
        }
    }

    private static final void $$robo$$android_media_PlayerRecord$setMediaFocusControl(MediaFocusControl mfc) {
        sController = mfc;
    }

    private void $$robo$$android_media_PlayerRecord$__constructor__(PendingIntent mediaIntent, ComponentName eventReceiver, IBinder token) {
        this.mRccId = -1;
        this.mMediaIntent = mediaIntent;
        this.mReceiverComponent = eventReceiver;
        this.mToken = token;
        this.mCallingUid = -1;
        this.mRcClient = null;
        this.mRccId = ++sLastRccId;
        this.mPlaybackState = new RccPlaybackState(1, -1L, 1.0f);
        this.resetPlaybackInfo();
        if (this.mToken != null) {
            try {
                this.mToken.linkToDeath(this, 0);
            }
            catch (RemoteException e) {
                sController.unregisterMediaButtonIntentAsync(this.mMediaIntent);
            }
        }
    }

    private final int $$robo$$android_media_PlayerRecord$getRccId() {
        return this.mRccId;
    }

    private final IRemoteControlClient $$robo$$android_media_PlayerRecord$getRcc() {
        return this.mRcClient;
    }

    private final ComponentName $$robo$$android_media_PlayerRecord$getMediaButtonReceiver() {
        return this.mReceiverComponent;
    }

    private final PendingIntent $$robo$$android_media_PlayerRecord$getMediaButtonIntent() {
        return this.mMediaIntent;
    }

    private final boolean $$robo$$android_media_PlayerRecord$hasMatchingMediaButtonIntent(PendingIntent pi) {
        if (this.mToken != null) {
            return this.mMediaIntent.equals(pi);
        }
        if (this.mReceiverComponent != null) {
            return this.mReceiverComponent.equals(pi.getIntent().getComponent());
        }
        return false;
    }

    private final boolean $$robo$$android_media_PlayerRecord$isPlaybackActive() {
        return MediaFocusControl.isPlaystateActive(this.mPlaybackState.mState);
    }

    private final void $$robo$$android_media_PlayerRecord$resetControllerInfoForRcc(IRemoteControlClient rcClient, String callingPackageName, int uid) {
        if (this.mRcClientDeathHandler != null) {
            this.unlinkToRcClientDeath();
        }
        this.mRcClient = rcClient;
        this.mCallingPackageName = callingPackageName;
        this.mCallingUid = uid;
        if (rcClient == null) {
            this.resetPlaybackInfo();
        } else {
            IBinder b = this.mRcClient.asBinder();
            RcClientDeathHandler rcdh = new RcClientDeathHandler(this, b, this.mMediaIntent);
            try {
                b.linkToDeath(rcdh, 0);
            }
            catch (RemoteException e) {
                Log.w("MediaFocusControl", "registerRemoteControlClient() has a dead client " + b);
                this.mRcClient = null;
            }
            this.mRcClientDeathHandler = rcdh;
        }
    }

    private final void $$robo$$android_media_PlayerRecord$resetControllerInfoForNoRcc() {
        this.unlinkToRcClientDeath();
        this.mRcClient = null;
        this.mCallingPackageName = null;
    }

    private final void $$robo$$android_media_PlayerRecord$resetPlaybackInfo() {
        this.mPlaybackType = 0;
        this.mPlaybackVolume = 15;
        this.mPlaybackVolumeMax = 15;
        this.mPlaybackVolumeHandling = 1;
        this.mPlaybackStream = 3;
        this.mPlaybackState.reset();
        this.mRemoteVolumeObs = null;
    }

    private final void $$robo$$android_media_PlayerRecord$unlinkToRcClientDeath() {
        if (this.mRcClientDeathHandler != null && this.mRcClientDeathHandler.mCb != null) {
            try {
                this.mRcClientDeathHandler.mCb.unlinkToDeath(this.mRcClientDeathHandler, 0);
                this.mRcClientDeathHandler = null;
            }
            catch (NoSuchElementException e) {
                Log.e("MediaFocusControl", "Error in unlinkToRcClientDeath()", e);
            }
        }
    }

    private final void $$robo$$android_media_PlayerRecord$destroy() {
        this.unlinkToRcClientDeath();
        if (this.mToken != null) {
            this.mToken.unlinkToDeath(this, 0);
            this.mToken = null;
        }
    }

    private final void $$robo$$android_media_PlayerRecord$binderDied() {
        sController.unregisterMediaButtonIntentAsync(this.mMediaIntent);
    }

    private final void $$robo$$android_media_PlayerRecord$finalize() throws Throwable {
        this.destroy();
        super.finalize();
    }

    static void __staticInitializer__() {
        sLastRccId = 0;
    }

    void dump(PrintWriter printWriter, boolean bl) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_media_PlayerRecord$dump(java.io.PrintWriter boolean ), 0, this, printWriter, bl);
    }

    protected static void setMediaFocusControl(MediaFocusControl mediaFocusControl) {
        InvokeDynamicSupport.bootstrapStatic("setMediaFocusControl", $$robo$$android_media_PlayerRecord$setMediaFocusControl(android.media.MediaFocusControl ), 0, (MediaFocusControl)mediaFocusControl);
    }

    private void __constructor__(PendingIntent pendingIntent, ComponentName componentName, IBinder iBinder) {
        this.$$robo$$android_media_PlayerRecord$__constructor__(pendingIntent, componentName, iBinder);
    }

    protected PlayerRecord(PendingIntent pendingIntent, ComponentName componentName, IBinder iBinder) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_PlayerRecord$__constructor__(android.app.PendingIntent android.content.ComponentName android.os.IBinder ), 0, this, pendingIntent, componentName, iBinder);
    }

    protected int getRccId() {
        return (int)InvokeDynamicSupport.bootstrap("getRccId", $$robo$$android_media_PlayerRecord$getRccId(), 0, this);
    }

    protected IRemoteControlClient getRcc() {
        return InvokeDynamicSupport.bootstrap("getRcc", $$robo$$android_media_PlayerRecord$getRcc(), 0, this);
    }

    protected ComponentName getMediaButtonReceiver() {
        return InvokeDynamicSupport.bootstrap("getMediaButtonReceiver", $$robo$$android_media_PlayerRecord$getMediaButtonReceiver(), 0, this);
    }

    protected PendingIntent getMediaButtonIntent() {
        return InvokeDynamicSupport.bootstrap("getMediaButtonIntent", $$robo$$android_media_PlayerRecord$getMediaButtonIntent(), 0, this);
    }

    protected boolean hasMatchingMediaButtonIntent(PendingIntent pendingIntent) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasMatchingMediaButtonIntent", $$robo$$android_media_PlayerRecord$hasMatchingMediaButtonIntent(android.app.PendingIntent ), 0, this, pendingIntent);
    }

    protected boolean isPlaybackActive() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPlaybackActive", $$robo$$android_media_PlayerRecord$isPlaybackActive(), 0, this);
    }

    protected void resetControllerInfoForRcc(IRemoteControlClient iRemoteControlClient, String string2, int n) {
        InvokeDynamicSupport.bootstrap("resetControllerInfoForRcc", $$robo$$android_media_PlayerRecord$resetControllerInfoForRcc(android.media.IRemoteControlClient java.lang.String int ), 0, this, iRemoteControlClient, string2, n);
    }

    protected void resetControllerInfoForNoRcc() {
        InvokeDynamicSupport.bootstrap("resetControllerInfoForNoRcc", $$robo$$android_media_PlayerRecord$resetControllerInfoForNoRcc(), 0, this);
    }

    public void resetPlaybackInfo() {
        InvokeDynamicSupport.bootstrap("resetPlaybackInfo", $$robo$$android_media_PlayerRecord$resetPlaybackInfo(), 0, this);
    }

    public void unlinkToRcClientDeath() {
        InvokeDynamicSupport.bootstrap("unlinkToRcClientDeath", $$robo$$android_media_PlayerRecord$unlinkToRcClientDeath(), 0, this);
    }

    public void destroy() {
        InvokeDynamicSupport.bootstrap("destroy", $$robo$$android_media_PlayerRecord$destroy(), 0, this);
    }

    @Override
    public void binderDied() {
        InvokeDynamicSupport.bootstrap("binderDied", $$robo$$android_media_PlayerRecord$binderDied(), 0, this);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_media_PlayerRecord$finalize(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(PlayerRecord.class);
    }

    public /* synthetic */ PlayerRecord() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PlayerRecord)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    protected static class RemotePlaybackState
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int mRccId;
        int mVolume;
        int mVolumeMax;
        int mVolumeHandling;

        private void $$robo$$android_media_PlayerRecord_RemotePlaybackState$__constructor__(int id2, int vol, int volMax) {
            this.mRccId = id2;
            this.mVolume = vol;
            this.mVolumeMax = volMax;
            this.mVolumeHandling = 1;
        }

        private void __constructor__(int n, int n2, int n3) {
            this.$$robo$$android_media_PlayerRecord_RemotePlaybackState$__constructor__(n, n2, n3);
        }

        protected RemotePlaybackState(int n, int n2, int n3) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_PlayerRecord_RemotePlaybackState$__constructor__(int int int ), 0, this, n, n2, n3);
        }

        public /* synthetic */ RemotePlaybackState() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RemotePlaybackState)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class RcClientDeathHandler
    implements IBinder.DeathRecipient,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private IBinder mCb;
        private PendingIntent mMediaIntent;
        /* synthetic */ PlayerRecord this$0;

        private void $$robo$$android_media_PlayerRecord_RcClientDeathHandler$__constructor__(PlayerRecord playerRecord, IBinder cb, PendingIntent pi) {
            this.mCb = cb;
            this.mMediaIntent = pi;
        }

        private final void $$robo$$android_media_PlayerRecord_RcClientDeathHandler$binderDied() {
            Log.w("MediaFocusControl", "  RemoteControlClient died");
            sController.registerRemoteControlClient(this.mMediaIntent, null, null);
            sController.postReevaluateRemote();
        }

        private final IBinder $$robo$$android_media_PlayerRecord_RcClientDeathHandler$getBinder() {
            return this.mCb;
        }

        private void __constructor__(PlayerRecord playerRecord, IBinder iBinder, PendingIntent pendingIntent) {
            this.$$robo$$android_media_PlayerRecord_RcClientDeathHandler$__constructor__(playerRecord, iBinder, pendingIntent);
        }

        RcClientDeathHandler(PlayerRecord playerRecord, IBinder iBinder, PendingIntent pendingIntent) {
            this.this$0 = playerRecord;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_PlayerRecord_RcClientDeathHandler$__constructor__(android.media.PlayerRecord android.os.IBinder android.app.PendingIntent ), 0, this, playerRecord, iBinder, pendingIntent);
        }

        @Override
        public void binderDied() {
            InvokeDynamicSupport.bootstrap("binderDied", $$robo$$android_media_PlayerRecord_RcClientDeathHandler$binderDied(), 0, this);
        }

        public IBinder getBinder() {
            return InvokeDynamicSupport.bootstrap("getBinder", $$robo$$android_media_PlayerRecord_RcClientDeathHandler$getBinder(), 0, this);
        }

        public /* synthetic */ RcClientDeathHandler() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RcClientDeathHandler)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    protected static class RccPlaybackState
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int mState;
        public long mPositionMs;
        public float mSpeed;

        private void $$robo$$android_media_PlayerRecord_RccPlaybackState$__constructor__(int state, long positionMs, float speed) {
            this.mState = state;
            this.mPositionMs = positionMs;
            this.mSpeed = speed;
        }

        private final void $$robo$$android_media_PlayerRecord_RccPlaybackState$reset() {
            this.mState = 1;
            this.mPositionMs = -1L;
            this.mSpeed = 1.0f;
        }

        private final String $$robo$$android_media_PlayerRecord_RccPlaybackState$toString() {
            return this.stateToString() + ", " + this.posToString() + ", " + this.mSpeed + "X";
        }

        private final String $$robo$$android_media_PlayerRecord_RccPlaybackState$posToString() {
            if (this.mPositionMs == -1L) {
                return "PLAYBACK_POSITION_INVALID";
            }
            if (this.mPositionMs == -9216204211029966080L) {
                return "PLAYBACK_POSITION_ALWAYS_UNKNOWN";
            }
            return String.valueOf(this.mPositionMs) + "ms";
        }

        private final String $$robo$$android_media_PlayerRecord_RccPlaybackState$stateToString() {
            switch (this.mState) {
                case 0: {
                    return "PLAYSTATE_NONE";
                }
                case 1: {
                    return "PLAYSTATE_STOPPED";
                }
                case 2: {
                    return "PLAYSTATE_PAUSED";
                }
                case 3: {
                    return "PLAYSTATE_PLAYING";
                }
                case 4: {
                    return "PLAYSTATE_FAST_FORWARDING";
                }
                case 5: {
                    return "PLAYSTATE_REWINDING";
                }
                case 6: {
                    return "PLAYSTATE_SKIPPING_FORWARDS";
                }
                case 7: {
                    return "PLAYSTATE_SKIPPING_BACKWARDS";
                }
                case 8: {
                    return "PLAYSTATE_BUFFERING";
                }
                case 9: {
                    return "PLAYSTATE_ERROR";
                }
            }
            return "[invalid playstate]";
        }

        private void __constructor__(int n, long l, float f) {
            this.$$robo$$android_media_PlayerRecord_RccPlaybackState$__constructor__(n, l, f);
        }

        public RccPlaybackState(int n, long l, float f) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_PlayerRecord_RccPlaybackState$__constructor__(int long float ), 0, this, n, l, f);
        }

        public void reset() {
            InvokeDynamicSupport.bootstrap("reset", $$robo$$android_media_PlayerRecord_RccPlaybackState$reset(), 0, this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_media_PlayerRecord_RccPlaybackState$toString(), 0, this);
        }

        private String posToString() {
            return InvokeDynamicSupport.bootstrap("posToString", $$robo$$android_media_PlayerRecord_RccPlaybackState$posToString(), 0, this);
        }

        private String stateToString() {
            return InvokeDynamicSupport.bootstrap("stateToString", $$robo$$android_media_PlayerRecord_RccPlaybackState$stateToString(), 0, this);
        }

        public /* synthetic */ RccPlaybackState() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RccPlaybackState)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

