/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.app.ActivityManager;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.graphics.Bitmap;
import android.media.AudioManager;
import android.media.IRemoteControlDisplay;
import android.media.MediaMetadata;
import android.media.MediaMetadataEditor;
import android.media.Rating;
import android.media.session.MediaController;
import android.media.session.MediaSessionLegacyHelper;
import android.media.session.MediaSessionManager;
import android.media.session.PlaybackState;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.os.UserHandle;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.KeyEvent;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.ref.WeakReference;
import java.util.List;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@Deprecated
@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class RemoteController
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int MAX_BITMAP_DIMENSION = 512;
    private static int TRANSPORT_UNKNOWN = 0;
    private static String TAG = "RemoteController";
    private static boolean DEBUG = false;
    private static boolean USE_SESSIONS = true;
    private static Object mGenLock;
    private static Object mInfoLock;
    private RcDisplay mRcd;
    private Context mContext;
    private AudioManager mAudioManager;
    private int mMaxBitmapDimension;
    private MetadataEditor mMetadataEditor;
    private MediaSessionManager mSessionManager;
    private MediaSessionManager.OnActiveSessionsChangedListener mSessionListener;
    private MediaController.Callback mSessionCb;
    private int mClientGenerationIdCurrent;
    private boolean mIsRegistered;
    private PendingIntent mClientPendingIntentCurrent;
    private OnClientUpdateListener mOnClientUpdateListener;
    private PlaybackInfo mLastPlaybackInfo;
    private int mArtworkWidth;
    private int mArtworkHeight;
    private boolean mEnabled;
    private MediaController mCurrentSession;
    public static int POSITION_SYNCHRONIZATION_NONE = 0;
    public static int POSITION_SYNCHRONIZATION_CHECK = 1;
    private EventHandler mEventHandler;
    private static int MSG_NEW_PENDING_INTENT = 0;
    private static int MSG_NEW_PLAYBACK_INFO = 1;
    private static int MSG_NEW_TRANSPORT_INFO = 2;
    private static int MSG_NEW_METADATA = 3;
    private static int MSG_CLIENT_CHANGE = 4;
    private static int MSG_DISPLAY_ENABLE = 5;
    private static int MSG_NEW_PLAYBACK_STATE = 6;
    private static int MSG_NEW_MEDIA_METADATA = 7;
    private static int SENDMSG_REPLACE = 0;
    private static int SENDMSG_NOOP = 1;
    private static int SENDMSG_QUEUE = 2;

    private void $$robo$$android_media_RemoteController$__constructor__(Context context, OnClientUpdateListener updateListener) throws IllegalArgumentException {
    }

    private void $$robo$$android_media_RemoteController$__constructor__(Context context, OnClientUpdateListener updateListener, Looper looper) throws IllegalArgumentException {
        this.mSessionCb = new MediaControllerCallback(this);
        this.mClientGenerationIdCurrent = 0;
        this.mIsRegistered = false;
        this.mArtworkWidth = -1;
        this.mArtworkHeight = -1;
        this.mEnabled = true;
        if (context == null) {
            throw new IllegalArgumentException("Invalid null Context");
        }
        if (updateListener == null) {
            throw new IllegalArgumentException("Invalid null OnClientUpdateListener");
        }
        if (looper != null) {
            this.mEventHandler = new EventHandler(this, this, looper);
        } else {
            Looper l = Looper.myLooper();
            if (l != null) {
                this.mEventHandler = new EventHandler(this, this, l);
            } else {
                throw new IllegalArgumentException("Calling thread not associated with a looper");
            }
        }
        this.mOnClientUpdateListener = updateListener;
        this.mContext = context;
        this.mRcd = new RcDisplay(this);
        this.mAudioManager = (AudioManager)context.getSystemService("audio");
        this.mSessionManager = (MediaSessionManager)context.getSystemService("media_session");
        this.mSessionListener = new TopTransportSessionListener(this);
        if (ActivityManager.isLowRamDeviceStatic()) {
            this.mMaxBitmapDimension = 512;
        } else {
            DisplayMetrics dm = context.getResources().getDisplayMetrics();
            this.mMaxBitmapDimension = Math.max(dm.widthPixels, dm.heightPixels);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String $$robo$$android_media_RemoteController$getRemoteControlClientPackageName() {
        Object object = mInfoLock;
        synchronized (object) {
            return this.mCurrentSession != null ? this.mCurrentSession.getPackageName() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long $$robo$$android_media_RemoteController$getEstimatedMediaPosition() {
        Object object = mInfoLock;
        synchronized (object) {
            PlaybackState state;
            if (this.mCurrentSession != null && (state = this.mCurrentSession.getPlaybackState()) != null) {
                return state.getPosition();
            }
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_media_RemoteController$sendMediaKeyEvent(KeyEvent keyEvent) throws IllegalArgumentException {
        if (!KeyEvent.isMediaKey(keyEvent.getKeyCode())) {
            throw new IllegalArgumentException("not a media key event");
        }
        Object object = mInfoLock;
        synchronized (object) {
            if (this.mCurrentSession != null) {
                return this.mCurrentSession.dispatchMediaButtonEvent(keyEvent);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_media_RemoteController$seekTo(long timeMs) throws IllegalArgumentException {
        if (!this.mEnabled) {
            Log.e("RemoteController", "Cannot use seekTo() from a disabled RemoteController");
            return false;
        }
        if (timeMs < 0L) {
            throw new IllegalArgumentException("illegal negative time value");
        }
        Object object = mInfoLock;
        synchronized (object) {
            if (this.mCurrentSession != null) {
                this.mCurrentSession.getTransportControls().seekTo(timeMs);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean $$robo$$android_media_RemoteController$setArtworkConfiguration(boolean wantBitmap, int width, int height) throws IllegalArgumentException {
        Object object = mInfoLock;
        synchronized (object) {
            if (wantBitmap) {
                if (width <= 0 || height <= 0) throw new IllegalArgumentException("Invalid dimensions");
                if (width > this.mMaxBitmapDimension) {
                    width = this.mMaxBitmapDimension;
                }
                if (height > this.mMaxBitmapDimension) {
                    height = this.mMaxBitmapDimension;
                }
                this.mArtworkWidth = width;
                this.mArtworkHeight = height;
            } else {
                this.mArtworkWidth = -1;
                this.mArtworkHeight = -1;
            }
            return true;
        }
    }

    private final boolean $$robo$$android_media_RemoteController$setArtworkConfiguration(int width, int height) throws IllegalArgumentException {
        return this.setArtworkConfiguration(true, width, height);
    }

    private final boolean $$robo$$android_media_RemoteController$clearArtworkConfiguration() {
        return this.setArtworkConfiguration(false, -1, -1);
    }

    private final boolean $$robo$$android_media_RemoteController$setSynchronizationMode(int sync) throws IllegalArgumentException {
        if (sync != 0 && sync != 1) {
            throw new IllegalArgumentException("Unknown synchronization mode " + sync);
        }
        if (!this.mIsRegistered) {
            Log.e("RemoteController", "Cannot set synchronization mode on an unregistered RemoteController");
            return false;
        }
        this.mAudioManager.remoteControlDisplayWantsPlaybackPositionSync(this.mRcd, 1 == sync);
        return true;
    }

    private final MetadataEditor $$robo$$android_media_RemoteController$editMetadata() {
        MetadataEditor editor = new MetadataEditor(this);
        editor.mEditorMetadata = new Bundle();
        editor.mEditorArtwork = null;
        editor.mMetadataChanged = true;
        editor.mArtworkChanged = true;
        editor.mEditableKeys = 0L;
        return editor;
    }

    private final void $$robo$$android_media_RemoteController$startListeningToSessions() {
        ComponentName listenerComponent = new ComponentName(this.mContext, this.mOnClientUpdateListener.getClass());
        Handler handler = null;
        if (Looper.myLooper() == null) {
            handler = new Handler(Looper.getMainLooper());
        }
        this.mSessionManager.addOnActiveSessionsChangedListener(this.mSessionListener, listenerComponent, UserHandle.myUserId(), handler);
        this.mSessionListener.onActiveSessionsChanged(this.mSessionManager.getActiveSessions(listenerComponent));
    }

    private final void $$robo$$android_media_RemoteController$stopListeningToSessions() {
        this.mSessionManager.removeOnActiveSessionsChangedListener(this.mSessionListener);
    }

    private static final void $$robo$$android_media_RemoteController$sendMsg(Handler handler, int msg, int existingMsgPolicy, int arg1, int arg2, Object obj, int delayMs) {
        if (handler == null) {
            Log.e("RemoteController", "null event handler, will not deliver message " + msg);
            return;
        }
        if (existingMsgPolicy == 0) {
            handler.removeMessages(msg);
        } else if (existingMsgPolicy == 1 && handler.hasMessages(msg)) {
            return;
        }
        handler.sendMessageDelayed(handler.obtainMessage(msg, arg1, arg2, obj), delayMs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_RemoteController$onNewPendingIntent(int genId, PendingIntent pi) {
        Object object = mGenLock;
        synchronized (object) {
            if (this.mClientGenerationIdCurrent != genId) {
                return;
            }
        }
        object = mInfoLock;
        synchronized (object) {
            this.mClientPendingIntentCurrent = pi;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_RemoteController$onNewPlaybackInfo(int genId, PlaybackInfo pi) {
        OnClientUpdateListener l;
        Object object = mGenLock;
        synchronized (object) {
            if (this.mClientGenerationIdCurrent != genId) {
                return;
            }
        }
        Object object2 = mInfoLock;
        synchronized (object2) {
            l = this.mOnClientUpdateListener;
            this.mLastPlaybackInfo = pi;
        }
        if (l != null) {
            if (pi.mCurrentPosMs == -9216204211029966080L) {
                l.onClientPlaybackStateUpdate(pi.mState);
            } else {
                l.onClientPlaybackStateUpdate(pi.mState, pi.mStateChangeTimeMs, pi.mCurrentPosMs, pi.mSpeed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_RemoteController$onNewTransportInfo(int genId, int transportControlFlags) {
        OnClientUpdateListener l;
        Object object = mGenLock;
        synchronized (object) {
            if (this.mClientGenerationIdCurrent != genId) {
                return;
            }
        }
        Object object2 = mInfoLock;
        synchronized (object2) {
            l = this.mOnClientUpdateListener;
        }
        if (l != null) {
            l.onClientTransportControlUpdate(transportControlFlags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_RemoteController$onNewMetadata(int genId, Bundle metadata) {
        MetadataEditor metadataEditor;
        OnClientUpdateListener l;
        Object object = mGenLock;
        synchronized (object) {
            if (this.mClientGenerationIdCurrent != genId) {
                return;
            }
        }
        long editableKeys = metadata.getLong(String.valueOf(0x1FFFFFFF), 0L);
        if (editableKeys != 0L) {
            metadata.remove(String.valueOf(0x1FFFFFFF));
        }
        Object object2 = mInfoLock;
        synchronized (object2) {
            l = this.mOnClientUpdateListener;
            if (this.mMetadataEditor != null && this.mMetadataEditor.mEditorMetadata != null) {
                if (this.mMetadataEditor.mEditorMetadata != metadata) {
                    this.mMetadataEditor.mEditorMetadata.putAll(metadata);
                }
                this.mMetadataEditor.putBitmap(100, (Bitmap)metadata.getParcelable(String.valueOf(100)));
                this.mMetadataEditor.cleanupBitmapFromBundle(100);
            } else {
                this.mMetadataEditor = new MetadataEditor(this, metadata, editableKeys);
            }
            metadataEditor = this.mMetadataEditor;
        }
        if (l != null) {
            l.onClientMetadataUpdate(metadataEditor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_RemoteController$onClientChange(int genId, boolean clearing) {
        OnClientUpdateListener l;
        Object object = mGenLock;
        synchronized (object) {
            if (this.mClientGenerationIdCurrent != genId) {
                return;
            }
        }
        Object object2 = mInfoLock;
        synchronized (object2) {
            l = this.mOnClientUpdateListener;
            this.mMetadataEditor = null;
        }
        if (l != null) {
            l.onClientChange(clearing);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_RemoteController$onDisplayEnable(boolean enabled) {
        Object object = mInfoLock;
        synchronized (object) {
            this.mEnabled = enabled;
            OnClientUpdateListener l = this.mOnClientUpdateListener;
        }
        if (!enabled) {
            int genId;
            Object object2 = mGenLock;
            synchronized (object2) {
                genId = this.mClientGenerationIdCurrent;
            }
            PlaybackInfo pi = new PlaybackInfo(1, SystemClock.elapsedRealtime(), 0L, 0.0f);
            RemoteController.sendMsg(this.mEventHandler, 1, 0, genId, 0, pi, 0);
            RemoteController.sendMsg(this.mEventHandler, 2, 0, genId, 0, null, 0);
            Bundle metadata = new Bundle(3);
            metadata.putString(String.valueOf(7), "");
            metadata.putString(String.valueOf(2), "");
            metadata.putLong(String.valueOf(9), 0L);
            RemoteController.sendMsg(this.mEventHandler, 3, 2, genId, 0, metadata, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_RemoteController$updateController(MediaController controller) {
        Object object = mInfoLock;
        synchronized (object) {
            if (controller == null) {
                if (this.mCurrentSession != null) {
                    this.mCurrentSession.unregisterCallback(this.mSessionCb);
                    this.mCurrentSession = null;
                    RemoteController.sendMsg(this.mEventHandler, 4, 0, 0, 1, null, 0);
                }
            } else if (this.mCurrentSession == null || !controller.getSessionToken().equals(this.mCurrentSession.getSessionToken())) {
                if (this.mCurrentSession != null) {
                    this.mCurrentSession.unregisterCallback(this.mSessionCb);
                }
                RemoteController.sendMsg(this.mEventHandler, 4, 0, 0, 0, null, 0);
                this.mCurrentSession = controller;
                this.mCurrentSession.registerCallback(this.mSessionCb, this.mEventHandler);
                PlaybackState state = controller.getPlaybackState();
                RemoteController.sendMsg(this.mEventHandler, 6, 0, 0, 0, state, 0);
                MediaMetadata metadata = controller.getMetadata();
                RemoteController.sendMsg(this.mEventHandler, 7, 0, 0, 0, metadata, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_RemoteController$onNewPlaybackState(PlaybackState state) {
        OnClientUpdateListener l;
        Object object = mInfoLock;
        synchronized (object) {
            l = this.mOnClientUpdateListener;
        }
        if (l != null) {
            int playstate;
            int n = playstate = state == null ? 0 : PlaybackState.getRccStateFromState(state.getState());
            if (state == null || state.getPosition() == -1L) {
                l.onClientPlaybackStateUpdate(playstate);
            } else {
                l.onClientPlaybackStateUpdate(playstate, state.getLastPositionUpdateTime(), state.getPosition(), state.getPlaybackSpeed());
            }
            if (state != null) {
                l.onClientTransportControlUpdate(PlaybackState.getRccControlFlagsFromActions(state.getActions()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_RemoteController$onNewMediaMetadata(MediaMetadata metadata) {
        MetadataEditor metadataEditor;
        OnClientUpdateListener l;
        if (metadata == null) {
            return;
        }
        Object object = mInfoLock;
        synchronized (object) {
            l = this.mOnClientUpdateListener;
            boolean canRate = this.mCurrentSession != null && this.mCurrentSession.getRatingType() != 0;
            long editableKeys = canRate ? 0x10000001L : 0L;
            Bundle legacyMetadata = MediaSessionLegacyHelper.getOldMetadata(metadata, this.mArtworkWidth, this.mArtworkHeight);
            metadataEditor = this.mMetadataEditor = new MetadataEditor(this, legacyMetadata, editableKeys);
        }
        if (l != null) {
            l.onClientMetadataUpdate(metadataEditor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_RemoteController$setIsRegistered(boolean registered) {
        Object object = mInfoLock;
        synchronized (object) {
            this.mIsRegistered = registered;
        }
    }

    private final RcDisplay $$robo$$android_media_RemoteController$getRcDisplay() {
        return this.mRcd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int[] $$robo$$android_media_RemoteController$getArtworkSize() {
        Object object = mInfoLock;
        synchronized (object) {
            int[] size = new int[]{this.mArtworkWidth, this.mArtworkHeight};
            return size;
        }
    }

    private final OnClientUpdateListener $$robo$$android_media_RemoteController$getUpdateListener() {
        return this.mOnClientUpdateListener;
    }

    static void __staticInitializer__() {
        mGenLock = new Object();
        mInfoLock = new Object();
    }

    private void __constructor__(Context context, OnClientUpdateListener onClientUpdateListener) throws IllegalArgumentException {
        this.$$robo$$android_media_RemoteController$__constructor__(context, onClientUpdateListener);
    }

    public RemoteController(Context context, OnClientUpdateListener onClientUpdateListener) throws IllegalArgumentException {
        this(context, onClientUpdateListener, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_RemoteController$__constructor__(android.content.Context android.media.RemoteController$OnClientUpdateListener ), 0, this, context, onClientUpdateListener);
    }

    private void __constructor__(Context context, OnClientUpdateListener onClientUpdateListener, Looper looper) throws IllegalArgumentException {
        this.$$robo$$android_media_RemoteController$__constructor__(context, onClientUpdateListener, looper);
    }

    public RemoteController(Context context, OnClientUpdateListener onClientUpdateListener, Looper looper) throws IllegalArgumentException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_RemoteController$__constructor__(android.content.Context android.media.RemoteController$OnClientUpdateListener android.os.Looper ), 0, this, context, onClientUpdateListener, looper);
    }

    public String getRemoteControlClientPackageName() {
        return InvokeDynamicSupport.bootstrap("getRemoteControlClientPackageName", $$robo$$android_media_RemoteController$getRemoteControlClientPackageName(), 0, this);
    }

    public long getEstimatedMediaPosition() {
        return (long)InvokeDynamicSupport.bootstrap("getEstimatedMediaPosition", $$robo$$android_media_RemoteController$getEstimatedMediaPosition(), 0, this);
    }

    public boolean sendMediaKeyEvent(KeyEvent keyEvent) throws IllegalArgumentException {
        return (boolean)InvokeDynamicSupport.bootstrap("sendMediaKeyEvent", $$robo$$android_media_RemoteController$sendMediaKeyEvent(android.view.KeyEvent ), 0, this, keyEvent);
    }

    public boolean seekTo(long l) throws IllegalArgumentException {
        return (boolean)InvokeDynamicSupport.bootstrap("seekTo", $$robo$$android_media_RemoteController$seekTo(long ), 0, this, l);
    }

    public boolean setArtworkConfiguration(boolean bl, int n, int n2) throws IllegalArgumentException {
        return (boolean)InvokeDynamicSupport.bootstrap("setArtworkConfiguration", $$robo$$android_media_RemoteController$setArtworkConfiguration(boolean int int ), 0, this, bl, n, n2);
    }

    public boolean setArtworkConfiguration(int n, int n2) throws IllegalArgumentException {
        return (boolean)InvokeDynamicSupport.bootstrap("setArtworkConfiguration", $$robo$$android_media_RemoteController$setArtworkConfiguration(int int ), 0, this, n, n2);
    }

    public boolean clearArtworkConfiguration() {
        return (boolean)InvokeDynamicSupport.bootstrap("clearArtworkConfiguration", $$robo$$android_media_RemoteController$clearArtworkConfiguration(), 0, this);
    }

    public boolean setSynchronizationMode(int n) throws IllegalArgumentException {
        return (boolean)InvokeDynamicSupport.bootstrap("setSynchronizationMode", $$robo$$android_media_RemoteController$setSynchronizationMode(int ), 0, this, n);
    }

    public MetadataEditor editMetadata() {
        return InvokeDynamicSupport.bootstrap("editMetadata", $$robo$$android_media_RemoteController$editMetadata(), 0, this);
    }

    void startListeningToSessions() {
        InvokeDynamicSupport.bootstrap("startListeningToSessions", $$robo$$android_media_RemoteController$startListeningToSessions(), 0, this);
    }

    void stopListeningToSessions() {
        InvokeDynamicSupport.bootstrap("stopListeningToSessions", $$robo$$android_media_RemoteController$stopListeningToSessions(), 0, this);
    }

    private static void sendMsg(Handler handler, int n, int n2, int n3, int n4, Object object, int n5) {
        InvokeDynamicSupport.bootstrapStatic("sendMsg", $$robo$$android_media_RemoteController$sendMsg(android.os.Handler int int int int java.lang.Object int ), 0, (Handler)handler, (int)n, (int)n2, (int)n3, (int)n4, (Object)object, (int)n5);
    }

    private void onNewPendingIntent(int n, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("onNewPendingIntent", $$robo$$android_media_RemoteController$onNewPendingIntent(int android.app.PendingIntent ), 0, this, n, pendingIntent);
    }

    private void onNewPlaybackInfo(int n, PlaybackInfo playbackInfo) {
        InvokeDynamicSupport.bootstrap("onNewPlaybackInfo", $$robo$$android_media_RemoteController$onNewPlaybackInfo(int android.media.RemoteController$PlaybackInfo ), 0, this, n, playbackInfo);
    }

    private void onNewTransportInfo(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onNewTransportInfo", $$robo$$android_media_RemoteController$onNewTransportInfo(int int ), 0, this, n, n2);
    }

    private void onNewMetadata(int n, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("onNewMetadata", $$robo$$android_media_RemoteController$onNewMetadata(int android.os.Bundle ), 0, this, n, bundle);
    }

    private void onClientChange(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("onClientChange", $$robo$$android_media_RemoteController$onClientChange(int boolean ), 0, this, n, bl);
    }

    private void onDisplayEnable(boolean bl) {
        InvokeDynamicSupport.bootstrap("onDisplayEnable", $$robo$$android_media_RemoteController$onDisplayEnable(boolean ), 0, this, bl);
    }

    private void updateController(MediaController mediaController) {
        InvokeDynamicSupport.bootstrap("updateController", $$robo$$android_media_RemoteController$updateController(android.media.session.MediaController ), 0, this, mediaController);
    }

    private void onNewPlaybackState(PlaybackState playbackState) {
        InvokeDynamicSupport.bootstrap("onNewPlaybackState", $$robo$$android_media_RemoteController$onNewPlaybackState(android.media.session.PlaybackState ), 0, this, playbackState);
    }

    private void onNewMediaMetadata(MediaMetadata mediaMetadata) {
        InvokeDynamicSupport.bootstrap("onNewMediaMetadata", $$robo$$android_media_RemoteController$onNewMediaMetadata(android.media.MediaMetadata ), 0, this, mediaMetadata);
    }

    void setIsRegistered(boolean bl) {
        InvokeDynamicSupport.bootstrap("setIsRegistered", $$robo$$android_media_RemoteController$setIsRegistered(boolean ), 0, this, bl);
    }

    RcDisplay getRcDisplay() {
        return InvokeDynamicSupport.bootstrap("getRcDisplay", $$robo$$android_media_RemoteController$getRcDisplay(), 0, this);
    }

    int[] getArtworkSize() {
        return InvokeDynamicSupport.bootstrap("getArtworkSize", $$robo$$android_media_RemoteController$getArtworkSize(), 0, this);
    }

    OnClientUpdateListener getUpdateListener() {
        return InvokeDynamicSupport.bootstrap("getUpdateListener", $$robo$$android_media_RemoteController$getUpdateListener(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(RemoteController.class);
    }

    public /* synthetic */ RemoteController() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RemoteController)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class PlaybackInfo
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int mState;
        long mStateChangeTimeMs;
        long mCurrentPosMs;
        float mSpeed;

        private void $$robo$$android_media_RemoteController_PlaybackInfo$__constructor__(int state, long stateChangeTimeMs, long currentPosMs, float speed) {
            this.mState = state;
            this.mStateChangeTimeMs = stateChangeTimeMs;
            this.mCurrentPosMs = currentPosMs;
            this.mSpeed = speed;
        }

        private void __constructor__(int n, long l, long l2, float f) {
            this.$$robo$$android_media_RemoteController_PlaybackInfo$__constructor__(n, l, l2, f);
        }

        PlaybackInfo(int n, long l, long l2, float f) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_RemoteController_PlaybackInfo$__constructor__(int long long float ), 0, this, n, l, l2, f);
        }

        public /* synthetic */ PlaybackInfo() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PlaybackInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class EventHandler
    extends Handler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ RemoteController this$0;

        private void $$robo$$android_media_RemoteController_EventHandler$__constructor__(RemoteController remoteController, RemoteController rc, Looper looper) {
        }

        private final void $$robo$$android_media_RemoteController_EventHandler$handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    this.this$0.onNewPendingIntent(msg.arg1, (PendingIntent)msg.obj);
                    break;
                }
                case 1: {
                    this.this$0.onNewPlaybackInfo(msg.arg1, (PlaybackInfo)msg.obj);
                    break;
                }
                case 2: {
                    this.this$0.onNewTransportInfo(msg.arg1, msg.arg2);
                    break;
                }
                case 3: {
                    this.this$0.onNewMetadata(msg.arg1, (Bundle)msg.obj);
                    break;
                }
                case 4: {
                    this.this$0.onClientChange(msg.arg1, msg.arg2 == 1);
                    break;
                }
                case 5: {
                    this.this$0.onDisplayEnable(msg.arg1 == 1);
                    break;
                }
                case 6: {
                    this.this$0.onNewPlaybackState((PlaybackState)msg.obj);
                    break;
                }
                case 7: {
                    this.this$0.onNewMediaMetadata((MediaMetadata)msg.obj);
                    break;
                }
                default: {
                    Log.e("RemoteController", "unknown event " + msg.what);
                }
            }
        }

        private void __constructor__(RemoteController remoteController, RemoteController remoteController2, Looper looper) {
            this.$$robo$$android_media_RemoteController_EventHandler$__constructor__(remoteController, remoteController2, looper);
        }

        public EventHandler(RemoteController remoteController, RemoteController remoteController2, Looper looper) {
            this.this$0 = remoteController;
            super(looper);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_RemoteController_EventHandler$__constructor__(android.media.RemoteController android.media.RemoteController android.os.Looper ), 0, this, remoteController, remoteController2, looper);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_media_RemoteController_EventHandler$handleMessage(android.os.Message ), 0, this, message);
        }

        public /* synthetic */ EventHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EventHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class TopTransportSessionListener
    implements MediaSessionManager.OnActiveSessionsChangedListener,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ RemoteController this$0;

        private void $$robo$$android_media_RemoteController_TopTransportSessionListener$__constructor__(RemoteController remoteController) {
        }

        private final void $$robo$$android_media_RemoteController_TopTransportSessionListener$onActiveSessionsChanged(List<MediaController> controllers) {
            int size = controllers.size();
            for (int i = 0; i < size; ++i) {
                MediaController controller = controllers.get(i);
                long flags = controller.getFlags();
                if ((flags & 2L) == 0L) continue;
                this.this$0.updateController(controller);
                return;
            }
            this.this$0.updateController(null);
        }

        private /* synthetic */ void $$robo$$android_media_RemoteController_TopTransportSessionListener$__constructor__(RemoteController x0, 1 x1) {
        }

        private void __constructor__(RemoteController remoteController) {
            this.$$robo$$android_media_RemoteController_TopTransportSessionListener$__constructor__(remoteController);
        }

        private TopTransportSessionListener(RemoteController remoteController) {
            this.this$0 = remoteController;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_RemoteController_TopTransportSessionListener$__constructor__(android.media.RemoteController ), 0, this, remoteController);
        }

        @Override
        public void onActiveSessionsChanged(List<MediaController> list) {
            InvokeDynamicSupport.bootstrap("onActiveSessionsChanged", $$robo$$android_media_RemoteController_TopTransportSessionListener$onActiveSessionsChanged(java.util.List<android.media.session.MediaController> ), 0, this, list);
        }

        private /* synthetic */ void __constructor__(RemoteController remoteController, 1 var2_2) {
            this.$$robo$$android_media_RemoteController_TopTransportSessionListener$__constructor__(remoteController, var2_2);
        }

        public /* synthetic */ TopTransportSessionListener() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TopTransportSessionListener)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class MediaControllerCallback
    extends MediaController.Callback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ RemoteController this$0;

        private void $$robo$$android_media_RemoteController_MediaControllerCallback$__constructor__(RemoteController remoteController) {
        }

        private final void $$robo$$android_media_RemoteController_MediaControllerCallback$onPlaybackStateChanged(PlaybackState state) {
            this.this$0.onNewPlaybackState(state);
        }

        private final void $$robo$$android_media_RemoteController_MediaControllerCallback$onMetadataChanged(MediaMetadata metadata) {
            this.this$0.onNewMediaMetadata(metadata);
        }

        private /* synthetic */ void $$robo$$android_media_RemoteController_MediaControllerCallback$__constructor__(RemoteController x0, 1 x1) {
        }

        private void __constructor__(RemoteController remoteController) {
            this.$$robo$$android_media_RemoteController_MediaControllerCallback$__constructor__(remoteController);
        }

        private MediaControllerCallback(RemoteController remoteController) {
            this.this$0 = remoteController;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_RemoteController_MediaControllerCallback$__constructor__(android.media.RemoteController ), 0, this, remoteController);
        }

        @Override
        public void onPlaybackStateChanged(PlaybackState playbackState) {
            InvokeDynamicSupport.bootstrap("onPlaybackStateChanged", $$robo$$android_media_RemoteController_MediaControllerCallback$onPlaybackStateChanged(android.media.session.PlaybackState ), 0, this, playbackState);
        }

        @Override
        public void onMetadataChanged(MediaMetadata mediaMetadata) {
            InvokeDynamicSupport.bootstrap("onMetadataChanged", $$robo$$android_media_RemoteController_MediaControllerCallback$onMetadataChanged(android.media.MediaMetadata ), 0, this, mediaMetadata);
        }

        private /* synthetic */ void __constructor__(RemoteController remoteController, 1 var2_2) {
            this.$$robo$$android_media_RemoteController_MediaControllerCallback$__constructor__(remoteController, var2_2);
        }

        public /* synthetic */ MediaControllerCallback() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MediaControllerCallback)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class RcDisplay
    extends IRemoteControlDisplay.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private WeakReference<RemoteController> mController;

        private void $$robo$$android_media_RemoteController_RcDisplay$__constructor__(RemoteController rc) {
            this.mController = new WeakReference<RemoteController>(rc);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_RemoteController_RcDisplay$setCurrentClientId(int genId, PendingIntent clientMediaIntent, boolean clearing) {
            RemoteController rc = (RemoteController)this.mController.get();
            if (rc == null) {
                return;
            }
            boolean isNew = false;
            Object object = mGenLock;
            synchronized (object) {
                if (rc.mClientGenerationIdCurrent != genId) {
                    rc.mClientGenerationIdCurrent = genId;
                    isNew = true;
                }
            }
            if (clientMediaIntent != null) {
                RemoteController.sendMsg(rc.mEventHandler, 0, 0, genId, 0, clientMediaIntent, 0);
            }
            if (isNew || clearing) {
                RemoteController.sendMsg(rc.mEventHandler, 4, 0, genId, clearing ? 1 : 0, null, 0);
            }
        }

        private final void $$robo$$android_media_RemoteController_RcDisplay$setEnabled(boolean enabled) {
            RemoteController rc = (RemoteController)this.mController.get();
            if (rc == null) {
                return;
            }
            RemoteController.sendMsg(rc.mEventHandler, 5, 0, enabled ? 1 : 0, 0, null, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_RemoteController_RcDisplay$setPlaybackState(int genId, int state, long stateChangeTimeMs, long currentPosMs, float speed) {
            RemoteController rc = (RemoteController)this.mController.get();
            if (rc == null) {
                return;
            }
            Object object = mGenLock;
            synchronized (object) {
                if (rc.mClientGenerationIdCurrent != genId) {
                    return;
                }
            }
            PlaybackInfo playbackInfo = new PlaybackInfo(state, stateChangeTimeMs, currentPosMs, speed);
            RemoteController.sendMsg(rc.mEventHandler, 1, 0, genId, 0, playbackInfo, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_RemoteController_RcDisplay$setTransportControlInfo(int genId, int transportControlFlags, int posCapabilities) {
            RemoteController rc = (RemoteController)this.mController.get();
            if (rc == null) {
                return;
            }
            Object object = mGenLock;
            synchronized (object) {
                if (rc.mClientGenerationIdCurrent != genId) {
                    return;
                }
            }
            RemoteController.sendMsg(rc.mEventHandler, 2, 0, genId, transportControlFlags, null, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_RemoteController_RcDisplay$setMetadata(int genId, Bundle metadata) {
            RemoteController rc = (RemoteController)this.mController.get();
            if (rc == null) {
                return;
            }
            if (metadata == null) {
                return;
            }
            Object object = mGenLock;
            synchronized (object) {
                if (rc.mClientGenerationIdCurrent != genId) {
                    return;
                }
            }
            RemoteController.sendMsg(rc.mEventHandler, 3, 2, genId, 0, metadata, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_RemoteController_RcDisplay$setArtwork(int genId, Bitmap artwork) {
            RemoteController rc = (RemoteController)this.mController.get();
            if (rc == null) {
                return;
            }
            Object object = mGenLock;
            synchronized (object) {
                if (rc.mClientGenerationIdCurrent != genId) {
                    return;
                }
            }
            Bundle metadata = new Bundle(1);
            metadata.putParcelable(String.valueOf(100), artwork);
            RemoteController.sendMsg(rc.mEventHandler, 3, 2, genId, 0, metadata, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_RemoteController_RcDisplay$setAllMetadata(int genId, Bundle metadata, Bitmap artwork) {
            RemoteController rc = (RemoteController)this.mController.get();
            if (rc == null) {
                return;
            }
            if (metadata == null && artwork == null) {
                return;
            }
            Object object = mGenLock;
            synchronized (object) {
                if (rc.mClientGenerationIdCurrent != genId) {
                    return;
                }
            }
            if (metadata == null) {
                metadata = new Bundle(1);
            }
            if (artwork != null) {
                metadata.putParcelable(String.valueOf(100), artwork);
            }
            RemoteController.sendMsg(rc.mEventHandler, 3, 2, genId, 0, metadata, 0);
        }

        private void __constructor__(RemoteController remoteController) {
            this.$$robo$$android_media_RemoteController_RcDisplay$__constructor__(remoteController);
        }

        RcDisplay(RemoteController remoteController) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_RemoteController_RcDisplay$__constructor__(android.media.RemoteController ), 0, this, remoteController);
        }

        @Override
        public void setCurrentClientId(int n, PendingIntent pendingIntent, boolean bl) {
            InvokeDynamicSupport.bootstrap("setCurrentClientId", $$robo$$android_media_RemoteController_RcDisplay$setCurrentClientId(int android.app.PendingIntent boolean ), 0, this, n, pendingIntent, bl);
        }

        @Override
        public void setEnabled(boolean bl) {
            InvokeDynamicSupport.bootstrap("setEnabled", $$robo$$android_media_RemoteController_RcDisplay$setEnabled(boolean ), 0, this, bl);
        }

        @Override
        public void setPlaybackState(int n, int n2, long l, long l2, float f) {
            InvokeDynamicSupport.bootstrap("setPlaybackState", $$robo$$android_media_RemoteController_RcDisplay$setPlaybackState(int int long long float ), 0, this, n, n2, l, l2, f);
        }

        @Override
        public void setTransportControlInfo(int n, int n2, int n3) {
            InvokeDynamicSupport.bootstrap("setTransportControlInfo", $$robo$$android_media_RemoteController_RcDisplay$setTransportControlInfo(int int int ), 0, this, n, n2, n3);
        }

        @Override
        public void setMetadata(int n, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("setMetadata", $$robo$$android_media_RemoteController_RcDisplay$setMetadata(int android.os.Bundle ), 0, this, n, bundle);
        }

        @Override
        public void setArtwork(int n, Bitmap bitmap) {
            InvokeDynamicSupport.bootstrap("setArtwork", $$robo$$android_media_RemoteController_RcDisplay$setArtwork(int android.graphics.Bitmap ), 0, this, n, bitmap);
        }

        @Override
        public void setAllMetadata(int n, Bundle bundle, Bitmap bitmap) {
            InvokeDynamicSupport.bootstrap("setAllMetadata", $$robo$$android_media_RemoteController_RcDisplay$setAllMetadata(int android.os.Bundle android.graphics.Bitmap ), 0, this, n, bundle, bitmap);
        }

        public /* synthetic */ RcDisplay() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RcDisplay)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class MetadataEditor
    extends MediaMetadataEditor
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ RemoteController this$0;

        private void $$robo$$android_media_RemoteController_MetadataEditor$__constructor__(RemoteController remoteController) {
        }

        private void $$robo$$android_media_RemoteController_MetadataEditor$__constructor__(RemoteController remoteController, Bundle metadata, long editableKeys) {
            this.mEditorMetadata = metadata;
            this.mEditableKeys = editableKeys;
            this.mEditorArtwork = (Bitmap)metadata.getParcelable(String.valueOf(100));
            if (this.mEditorArtwork != null) {
                this.cleanupBitmapFromBundle(100);
            }
            this.mMetadataChanged = true;
            this.mArtworkChanged = true;
            this.mApplied = false;
        }

        private final void $$robo$$android_media_RemoteController_MetadataEditor$cleanupBitmapFromBundle(int key) {
            if (METADATA_KEYS_TYPE.get(key, -1) == 2) {
                this.mEditorMetadata.remove(String.valueOf(key));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final synchronized void $$robo$$android_media_RemoteController_MetadataEditor$apply() {
            if (!this.mMetadataChanged) {
                return;
            }
            Object object = mInfoLock;
            synchronized (object) {
                Rating rating;
                if (this.this$0.mCurrentSession != null && this.mEditorMetadata.containsKey(String.valueOf(0x10000001)) && (rating = (Rating)this.getObject(0x10000001, null)) != null) {
                    this.this$0.mCurrentSession.getTransportControls().setRating(rating);
                }
            }
            this.mApplied = false;
        }

        private void __constructor__(RemoteController remoteController) {
            this.$$robo$$android_media_RemoteController_MetadataEditor$__constructor__(remoteController);
        }

        protected MetadataEditor(RemoteController remoteController) {
            this.this$0 = remoteController;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_RemoteController_MetadataEditor$__constructor__(android.media.RemoteController ), 0, this, remoteController);
        }

        private void __constructor__(RemoteController remoteController, Bundle bundle, long l) {
            this.$$robo$$android_media_RemoteController_MetadataEditor$__constructor__(remoteController, bundle, l);
        }

        protected MetadataEditor(RemoteController remoteController, Bundle bundle, long l) {
            this.this$0 = remoteController;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_RemoteController_MetadataEditor$__constructor__(android.media.RemoteController android.os.Bundle long ), 0, this, remoteController, bundle, l);
        }

        private void cleanupBitmapFromBundle(int n) {
            InvokeDynamicSupport.bootstrap("cleanupBitmapFromBundle", $$robo$$android_media_RemoteController_MetadataEditor$cleanupBitmapFromBundle(int ), 0, this, n);
        }

        @Override
        public synchronized void apply() {
            InvokeDynamicSupport.bootstrap("apply", $$robo$$android_media_RemoteController_MetadataEditor$apply(), 0, this);
        }

        public /* synthetic */ MetadataEditor() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MetadataEditor)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface OnClientUpdateListener
    extends InstrumentedInterface {
        public void onClientChange(boolean var1);

        public void onClientPlaybackStateUpdate(int var1);

        public void onClientPlaybackStateUpdate(int var1, long var2, long var4, float var6);

        public void onClientTransportControlUpdate(int var1);

        public void onClientMetadataUpdate(MetadataEditor var1);
    }
}

