/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.content.res.Resources;
import android.database.Cursor;
import android.media.AudioAttributes;
import android.media.AudioManager;
import android.media.IRingtonePlayer;
import android.media.MediaPlayer;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Binder;
import android.os.RemoteException;
import android.util.Log;
import java.io.IOException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class Ringtone
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "Ringtone";
    private static boolean LOGD = true;
    private static String[] MEDIA_COLUMNS;
    private Context mContext;
    private AudioManager mAudioManager;
    private boolean mAllowRemote;
    private IRingtonePlayer mRemotePlayer;
    private Binder mRemoteToken;
    private MediaPlayer mLocalPlayer;
    private Uri mUri;
    private String mTitle;
    private AudioAttributes mAudioAttributes;

    private void $$robo$$android_media_Ringtone$__constructor__(Context context, boolean allowRemote) {
        this.mAudioAttributes = new AudioAttributes.Builder().setUsage(6).setContentType(4).build();
        this.mContext = context;
        this.mAudioManager = (AudioManager)this.mContext.getSystemService("audio");
        this.mAllowRemote = allowRemote;
        this.mRemotePlayer = allowRemote ? this.mAudioManager.getRingtonePlayer() : null;
        this.mRemoteToken = allowRemote ? new Binder() : null;
    }

    @Deprecated
    private final void $$robo$$android_media_Ringtone$setStreamType(int streamType) {
        this.setAudioAttributes(new AudioAttributes.Builder().setInternalLegacyStreamType(streamType).build());
    }

    @Deprecated
    private final int $$robo$$android_media_Ringtone$getStreamType() {
        return AudioAttributes.toLegacyStreamType(this.mAudioAttributes);
    }

    private final void $$robo$$android_media_Ringtone$setAudioAttributes(AudioAttributes attributes) throws IllegalArgumentException {
        if (attributes == null) {
            throw new IllegalArgumentException("Invalid null AudioAttributes for Ringtone");
        }
        this.mAudioAttributes = attributes;
        this.setUri(this.mUri);
    }

    private final AudioAttributes $$robo$$android_media_Ringtone$getAudioAttributes() {
        return this.mAudioAttributes;
    }

    private final String $$robo$$android_media_Ringtone$getTitle(Context context) {
        if (this.mTitle != null) {
            return this.mTitle;
        }
        this.mTitle = Ringtone.getTitle(context, this.mUri, true);
        return this.mTitle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String $$robo$$android_media_Ringtone$getTitle(Context context, Uri uri, boolean followSettingsUri) {
        Cursor cursor = null;
        ContentResolver res = context.getContentResolver();
        String title = null;
        if (uri != null) {
            String authority = uri.getAuthority();
            if ("settings".equals(authority)) {
                if (followSettingsUri) {
                    Uri actualUri = RingtoneManager.getActualDefaultRingtoneUri(context, RingtoneManager.getDefaultType(uri));
                    String actualTitle = Ringtone.getTitle(context, actualUri, false);
                    title = context.getString(17040545, actualTitle);
                }
            } else {
                try {
                    if ("media".equals(authority)) {
                        cursor = res.query(uri, MEDIA_COLUMNS, null, null, null);
                    }
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                try {
                    if (cursor != null && cursor.getCount() == 1) {
                        cursor.moveToFirst();
                        String string2 = cursor.getString(2);
                        return string2;
                    }
                    title = uri.getLastPathSegment();
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
            }
        }
        if (title == null && (title = context.getString(17040548)) == null) {
            title = "";
        }
        return title;
    }

    private final void $$robo$$android_media_Ringtone$setUri(Uri uri) {
        block7: {
            this.destroyLocalPlayer();
            this.mUri = uri;
            if (this.mUri == null) {
                return;
            }
            this.mLocalPlayer = new MediaPlayer();
            try {
                this.mLocalPlayer.setDataSource(this.mContext, this.mUri);
                this.mLocalPlayer.setAudioAttributes(this.mAudioAttributes);
                this.mLocalPlayer.prepare();
            }
            catch (SecurityException e) {
                this.destroyLocalPlayer();
                if (!this.mAllowRemote) {
                    Log.w("Ringtone", "Remote playback not allowed: " + e);
                }
            }
            catch (IOException e) {
                this.destroyLocalPlayer();
                if (this.mAllowRemote) break block7;
                Log.w("Ringtone", "Remote playback not allowed: " + e);
            }
        }
        if (this.mLocalPlayer != null) {
            Log.d("Ringtone", "Successfully created local player");
        } else {
            Log.d("Ringtone", "Problem opening; delegating to remote player");
        }
    }

    private final Uri $$robo$$android_media_Ringtone$getUri() {
        return this.mUri;
    }

    private final void $$robo$$android_media_Ringtone$play() {
        if (this.mLocalPlayer != null) {
            if (this.mAudioManager.getStreamVolume(AudioAttributes.toLegacyStreamType(this.mAudioAttributes)) != 0) {
                this.mLocalPlayer.start();
            }
        } else if (this.mAllowRemote && this.mRemotePlayer != null) {
            Uri canonicalUri = this.mUri.getCanonicalUri();
            try {
                this.mRemotePlayer.play(this.mRemoteToken, canonicalUri, this.mAudioAttributes);
            }
            catch (RemoteException e) {
                if (!this.playFallbackRingtone()) {
                    Log.w("Ringtone", "Problem playing ringtone: " + e);
                }
            }
        } else if (!this.playFallbackRingtone()) {
            Log.w("Ringtone", "Neither local nor remote playback available");
        }
    }

    private final void $$robo$$android_media_Ringtone$stop() {
        if (this.mLocalPlayer != null) {
            this.destroyLocalPlayer();
        } else if (this.mAllowRemote && this.mRemotePlayer != null) {
            try {
                this.mRemotePlayer.stop(this.mRemoteToken);
            }
            catch (RemoteException e) {
                Log.w("Ringtone", "Problem stopping ringtone: " + e);
            }
        }
    }

    private final void $$robo$$android_media_Ringtone$destroyLocalPlayer() {
        if (this.mLocalPlayer != null) {
            this.mLocalPlayer.reset();
            this.mLocalPlayer.release();
            this.mLocalPlayer = null;
        }
    }

    private final boolean $$robo$$android_media_Ringtone$isPlaying() {
        if (this.mLocalPlayer != null) {
            return this.mLocalPlayer.isPlaying();
        }
        if (this.mAllowRemote && this.mRemotePlayer != null) {
            try {
                return this.mRemotePlayer.isPlaying(this.mRemoteToken);
            }
            catch (RemoteException e) {
                Log.w("Ringtone", "Problem checking ringtone: " + e);
                return false;
            }
        }
        Log.w("Ringtone", "Neither local nor remote playback available");
        return false;
    }

    private final boolean $$robo$$android_media_Ringtone$playFallbackRingtone() {
        if (this.mAudioManager.getStreamVolume(AudioAttributes.toLegacyStreamType(this.mAudioAttributes)) != 0) {
            int ringtoneType = RingtoneManager.getDefaultType(this.mUri);
            if (ringtoneType == -1 || RingtoneManager.getActualDefaultRingtoneUri(this.mContext, ringtoneType) != null) {
                try {
                    AssetFileDescriptor afd = this.mContext.getResources().openRawResourceFd(0x1100005);
                    if (afd != null) {
                        this.mLocalPlayer = new MediaPlayer();
                        if (afd.getDeclaredLength() < 0L) {
                            this.mLocalPlayer.setDataSource(afd.getFileDescriptor());
                        } else {
                            this.mLocalPlayer.setDataSource(afd.getFileDescriptor(), afd.getStartOffset(), afd.getDeclaredLength());
                        }
                        this.mLocalPlayer.setAudioAttributes(this.mAudioAttributes);
                        this.mLocalPlayer.prepare();
                        this.mLocalPlayer.start();
                        afd.close();
                        return true;
                    }
                    Log.e("Ringtone", "Could not load fallback ringtone");
                }
                catch (IOException ioe) {
                    this.destroyLocalPlayer();
                    Log.e("Ringtone", "Failed to open fallback ringtone");
                }
                catch (Resources.NotFoundException nfe) {
                    Log.e("Ringtone", "Fallback ringtone does not exist");
                }
            } else {
                Log.w("Ringtone", "not playing fallback for " + this.mUri);
            }
        }
        return false;
    }

    private final void $$robo$$android_media_Ringtone$setTitle(String title) {
        this.mTitle = title;
    }

    static void __staticInitializer__() {
        MEDIA_COLUMNS = new String[]{"_id", "_data", "title"};
    }

    private void __constructor__(Context context, boolean bl) {
        this.$$robo$$android_media_Ringtone$__constructor__(context, bl);
    }

    public Ringtone(Context context, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_Ringtone$__constructor__(android.content.Context boolean ), 0, this, context, bl);
    }

    @Deprecated
    public void setStreamType(int n) {
        InvokeDynamicSupport.bootstrap("setStreamType", $$robo$$android_media_Ringtone$setStreamType(int ), 0, this, n);
    }

    @Deprecated
    public int getStreamType() {
        return (int)InvokeDynamicSupport.bootstrap("getStreamType", $$robo$$android_media_Ringtone$getStreamType(), 0, this);
    }

    public void setAudioAttributes(AudioAttributes audioAttributes) throws IllegalArgumentException {
        InvokeDynamicSupport.bootstrap("setAudioAttributes", $$robo$$android_media_Ringtone$setAudioAttributes(android.media.AudioAttributes ), 0, this, audioAttributes);
    }

    public AudioAttributes getAudioAttributes() {
        return InvokeDynamicSupport.bootstrap("getAudioAttributes", $$robo$$android_media_Ringtone$getAudioAttributes(), 0, this);
    }

    public String getTitle(Context context) {
        return InvokeDynamicSupport.bootstrap("getTitle", $$robo$$android_media_Ringtone$getTitle(android.content.Context ), 0, this, context);
    }

    private static String getTitle(Context context, Uri uri, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("getTitle", $$robo$$android_media_Ringtone$getTitle(android.content.Context android.net.Uri boolean ), 0, (Context)context, (Uri)uri, (boolean)bl);
    }

    public void setUri(Uri uri) {
        InvokeDynamicSupport.bootstrap("setUri", $$robo$$android_media_Ringtone$setUri(android.net.Uri ), 0, this, uri);
    }

    public Uri getUri() {
        return InvokeDynamicSupport.bootstrap("getUri", $$robo$$android_media_Ringtone$getUri(), 0, this);
    }

    public void play() {
        InvokeDynamicSupport.bootstrap("play", $$robo$$android_media_Ringtone$play(), 0, this);
    }

    public void stop() {
        InvokeDynamicSupport.bootstrap("stop", $$robo$$android_media_Ringtone$stop(), 0, this);
    }

    private void destroyLocalPlayer() {
        InvokeDynamicSupport.bootstrap("destroyLocalPlayer", $$robo$$android_media_Ringtone$destroyLocalPlayer(), 0, this);
    }

    public boolean isPlaying() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPlaying", $$robo$$android_media_Ringtone$isPlaying(), 0, this);
    }

    private boolean playFallbackRingtone() {
        return (boolean)InvokeDynamicSupport.bootstrap("playFallbackRingtone", $$robo$$android_media_Ringtone$playFallbackRingtone(), 0, this);
    }

    void setTitle(String string2) {
        InvokeDynamicSupport.bootstrap("setTitle", $$robo$$android_media_Ringtone$setTitle(java.lang.String ), 0, this, string2);
    }

    static {
        RobolectricInternals.classInitializing(Ringtone.class);
    }

    public /* synthetic */ Ringtone() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Ringtone)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

