/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.app.Activity;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.media.Ringtone;
import android.net.Uri;
import android.os.Environment;
import android.provider.MediaStore;
import android.provider.Settings;
import android.util.Log;
import com.android.internal.database.SortCursor;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class RingtoneManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "RingtoneManager";
    public static int TYPE_RINGTONE = 1;
    public static int TYPE_NOTIFICATION = 2;
    public static int TYPE_ALARM = 4;
    public static int TYPE_ALL = 7;
    public static String ACTION_RINGTONE_PICKER = "android.intent.action.RINGTONE_PICKER";
    public static String EXTRA_RINGTONE_SHOW_DEFAULT = "android.intent.extra.ringtone.SHOW_DEFAULT";
    public static String EXTRA_RINGTONE_SHOW_SILENT = "android.intent.extra.ringtone.SHOW_SILENT";
    @Deprecated
    public static String EXTRA_RINGTONE_INCLUDE_DRM = "android.intent.extra.ringtone.INCLUDE_DRM";
    public static String EXTRA_RINGTONE_EXISTING_URI = "android.intent.extra.ringtone.EXISTING_URI";
    public static String EXTRA_RINGTONE_DEFAULT_URI = "android.intent.extra.ringtone.DEFAULT_URI";
    public static String EXTRA_RINGTONE_TYPE = "android.intent.extra.ringtone.TYPE";
    public static String EXTRA_RINGTONE_TITLE = "android.intent.extra.ringtone.TITLE";
    public static String EXTRA_RINGTONE_PICKED_URI = "android.intent.extra.ringtone.PICKED_URI";
    private static String[] INTERNAL_COLUMNS;
    private static String[] MEDIA_COLUMNS;
    public static int ID_COLUMN_INDEX = 0;
    public static int TITLE_COLUMN_INDEX = 1;
    public static int URI_COLUMN_INDEX = 2;
    private Activity mActivity;
    private Context mContext;
    private Cursor mCursor;
    private int mType;
    private List<String> mFilterColumns;
    private boolean mStopPreviousRingtone;
    private Ringtone mPreviousRingtone;

    private void $$robo$$android_media_RingtoneManager$__constructor__(Activity activity) {
        this.mType = 1;
        this.mFilterColumns = new ArrayList<String>();
        this.mStopPreviousRingtone = true;
        this.mActivity = activity;
        this.mContext = this.mActivity;
        this.setType(this.mType);
    }

    private void $$robo$$android_media_RingtoneManager$__constructor__(Context context) {
        this.mType = 1;
        this.mFilterColumns = new ArrayList<String>();
        this.mStopPreviousRingtone = true;
        this.mContext = context;
        this.setType(this.mType);
    }

    private final void $$robo$$android_media_RingtoneManager$setType(int type) {
        if (this.mCursor != null) {
            throw new IllegalStateException("Setting filter columns should be done before querying for ringtones.");
        }
        this.mType = type;
        this.setFilterColumnsList(type);
    }

    private final int $$robo$$android_media_RingtoneManager$inferStreamType() {
        switch (this.mType) {
            case 4: {
                return 4;
            }
            case 2: {
                return 5;
            }
        }
        return 2;
    }

    private final void $$robo$$android_media_RingtoneManager$setStopPreviousRingtone(boolean stopPreviousRingtone) {
        this.mStopPreviousRingtone = stopPreviousRingtone;
    }

    private final boolean $$robo$$android_media_RingtoneManager$getStopPreviousRingtone() {
        return this.mStopPreviousRingtone;
    }

    private final void $$robo$$android_media_RingtoneManager$stopPreviousRingtone() {
        if (this.mPreviousRingtone != null) {
            this.mPreviousRingtone.stop();
        }
    }

    @Deprecated
    private final boolean $$robo$$android_media_RingtoneManager$getIncludeDrm() {
        return false;
    }

    @Deprecated
    private final void $$robo$$android_media_RingtoneManager$setIncludeDrm(boolean includeDrm) {
        if (includeDrm) {
            Log.w("RingtoneManager", "setIncludeDrm no longer supported");
        }
    }

    private final Cursor $$robo$$android_media_RingtoneManager$getCursor() {
        if (this.mCursor != null && this.mCursor.requery()) {
            return this.mCursor;
        }
        Cursor internalCursor = this.getInternalRingtones();
        Cursor mediaCursor = this.getMediaRingtones();
        this.mCursor = new SortCursor(new Cursor[]{internalCursor, mediaCursor}, "title_key");
        return this.mCursor;
    }

    private final Ringtone $$robo$$android_media_RingtoneManager$getRingtone(int position) {
        if (this.mStopPreviousRingtone && this.mPreviousRingtone != null) {
            this.mPreviousRingtone.stop();
        }
        this.mPreviousRingtone = RingtoneManager.getRingtone(this.mContext, this.getRingtoneUri(position), this.inferStreamType());
        return this.mPreviousRingtone;
    }

    private final Uri $$robo$$android_media_RingtoneManager$getRingtoneUri(int position) {
        if (this.mCursor == null || !this.mCursor.moveToPosition(position)) {
            return null;
        }
        return RingtoneManager.getUriFromCursor(this.mCursor);
    }

    private static final Uri $$robo$$android_media_RingtoneManager$getUriFromCursor(Cursor cursor) {
        return ContentUris.withAppendedId(Uri.parse(cursor.getString(2)), cursor.getLong(0));
    }

    private final int $$robo$$android_media_RingtoneManager$getRingtonePosition(Uri ringtoneUri) {
        if (ringtoneUri == null) {
            return -1;
        }
        Cursor cursor = this.getCursor();
        int cursorCount = cursor.getCount();
        if (!cursor.moveToFirst()) {
            return -1;
        }
        Uri currentUri = null;
        String previousUriString = null;
        for (int i = 0; i < cursorCount; ++i) {
            String uriString = cursor.getString(2);
            if (currentUri == null || !uriString.equals(previousUriString)) {
                currentUri = Uri.parse(uriString);
            }
            if (ringtoneUri.equals(ContentUris.withAppendedId(currentUri, cursor.getLong(0)))) {
                return i;
            }
            cursor.move(1);
            previousUriString = uriString;
        }
        return -1;
    }

    private static final Uri $$robo$$android_media_RingtoneManager$getValidRingtoneUri(Context context) {
        RingtoneManager rm = new RingtoneManager(context);
        Uri uri = RingtoneManager.getValidRingtoneUriFromCursorAndClose(context, rm.getInternalRingtones());
        if (uri == null) {
            uri = RingtoneManager.getValidRingtoneUriFromCursorAndClose(context, rm.getMediaRingtones());
        }
        return uri;
    }

    private static final Uri $$robo$$android_media_RingtoneManager$getValidRingtoneUriFromCursorAndClose(Context context, Cursor cursor) {
        if (cursor != null) {
            Uri uri = null;
            if (cursor.moveToFirst()) {
                uri = RingtoneManager.getUriFromCursor(cursor);
            }
            cursor.close();
            return uri;
        }
        return null;
    }

    private final Cursor $$robo$$android_media_RingtoneManager$getInternalRingtones() {
        return this.query(MediaStore.Audio.Media.INTERNAL_CONTENT_URI, INTERNAL_COLUMNS, RingtoneManager.constructBooleanTrueWhereClause(this.mFilterColumns), null, "title_key");
    }

    private final Cursor $$robo$$android_media_RingtoneManager$getMediaRingtones() {
        String status = Environment.getExternalStorageState();
        return status.equals("mounted") || status.equals("mounted_ro") ? this.query(MediaStore.Audio.Media.EXTERNAL_CONTENT_URI, MEDIA_COLUMNS, RingtoneManager.constructBooleanTrueWhereClause(this.mFilterColumns), null, "title_key") : null;
    }

    private final void $$robo$$android_media_RingtoneManager$setFilterColumnsList(int type) {
        List<String> columns = this.mFilterColumns;
        columns.clear();
        if ((type & 1) != 0) {
            columns.add("is_ringtone");
        }
        if ((type & 2) != 0) {
            columns.add("is_notification");
        }
        if ((type & 4) != 0) {
            columns.add("is_alarm");
        }
    }

    private static final String $$robo$$android_media_RingtoneManager$constructBooleanTrueWhereClause(List<String> columns) {
        if (columns == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (int i = columns.size() - 1; i >= 0; --i) {
            sb.append(columns.get(i)).append("=1 or ");
        }
        if (columns.size() > 0) {
            sb.setLength(sb.length() - 4);
        }
        sb.append(")");
        return sb.toString();
    }

    private final Cursor $$robo$$android_media_RingtoneManager$query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        if (this.mActivity != null) {
            return this.mActivity.managedQuery(uri, projection, selection, selectionArgs, sortOrder);
        }
        return this.mContext.getContentResolver().query(uri, projection, selection, selectionArgs, sortOrder);
    }

    private static final Ringtone $$robo$$android_media_RingtoneManager$getRingtone(Context context, Uri ringtoneUri) {
        return RingtoneManager.getRingtone(context, ringtoneUri, -1);
    }

    private static final Ringtone $$robo$$android_media_RingtoneManager$getRingtone(Context context, Uri ringtoneUri, int streamType) {
        try {
            Ringtone r = new Ringtone(context, true);
            if (streamType >= 0) {
                r.setStreamType(streamType);
            }
            r.setUri(ringtoneUri);
            return r;
        }
        catch (Exception ex) {
            Log.e("RingtoneManager", "Failed to open ringtone " + ringtoneUri + ": " + ex);
            return null;
        }
    }

    private static final Uri $$robo$$android_media_RingtoneManager$getActualDefaultRingtoneUri(Context context, int type) {
        String setting = RingtoneManager.getSettingForType(type);
        if (setting == null) {
            return null;
        }
        String uriString = Settings.System.getString(context.getContentResolver(), setting);
        return uriString != null ? Uri.parse(uriString) : null;
    }

    private static final void $$robo$$android_media_RingtoneManager$setActualDefaultRingtoneUri(Context context, int type, Uri ringtoneUri) {
        String setting = RingtoneManager.getSettingForType(type);
        if (setting == null) {
            return;
        }
        Settings.System.putString(context.getContentResolver(), setting, ringtoneUri != null ? ringtoneUri.toString() : null);
    }

    private static final String $$robo$$android_media_RingtoneManager$getSettingForType(int type) {
        if ((type & 1) != 0) {
            return "ringtone";
        }
        if ((type & 2) != 0) {
            return "notification_sound";
        }
        if ((type & 4) != 0) {
            return "alarm_alert";
        }
        return null;
    }

    private static final boolean $$robo$$android_media_RingtoneManager$isDefault(Uri ringtoneUri) {
        return RingtoneManager.getDefaultType(ringtoneUri) != -1;
    }

    private static final int $$robo$$android_media_RingtoneManager$getDefaultType(Uri defaultRingtoneUri) {
        if (defaultRingtoneUri == null) {
            return -1;
        }
        if (defaultRingtoneUri.equals(Settings.System.DEFAULT_RINGTONE_URI)) {
            return 1;
        }
        if (defaultRingtoneUri.equals(Settings.System.DEFAULT_NOTIFICATION_URI)) {
            return 2;
        }
        if (defaultRingtoneUri.equals(Settings.System.DEFAULT_ALARM_ALERT_URI)) {
            return 4;
        }
        return -1;
    }

    private static final Uri $$robo$$android_media_RingtoneManager$getDefaultUri(int type) {
        if ((type & 1) != 0) {
            return Settings.System.DEFAULT_RINGTONE_URI;
        }
        if ((type & 2) != 0) {
            return Settings.System.DEFAULT_NOTIFICATION_URI;
        }
        if ((type & 4) != 0) {
            return Settings.System.DEFAULT_ALARM_ALERT_URI;
        }
        return null;
    }

    static void __staticInitializer__() {
        INTERNAL_COLUMNS = new String[]{"_id", "title", "\"" + MediaStore.Audio.Media.INTERNAL_CONTENT_URI + "\"", "title_key"};
        MEDIA_COLUMNS = new String[]{"_id", "title", "\"" + MediaStore.Audio.Media.EXTERNAL_CONTENT_URI + "\"", "title_key"};
    }

    private void __constructor__(Activity activity) {
        this.$$robo$$android_media_RingtoneManager$__constructor__(activity);
    }

    public RingtoneManager(Activity activity) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_RingtoneManager$__constructor__(android.app.Activity ), 0, this, activity);
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_media_RingtoneManager$__constructor__(context);
    }

    public RingtoneManager(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_RingtoneManager$__constructor__(android.content.Context ), 0, this, context);
    }

    public void setType(int n) {
        InvokeDynamicSupport.bootstrap("setType", $$robo$$android_media_RingtoneManager$setType(int ), 0, this, n);
    }

    public int inferStreamType() {
        return (int)InvokeDynamicSupport.bootstrap("inferStreamType", $$robo$$android_media_RingtoneManager$inferStreamType(), 0, this);
    }

    public void setStopPreviousRingtone(boolean bl) {
        InvokeDynamicSupport.bootstrap("setStopPreviousRingtone", $$robo$$android_media_RingtoneManager$setStopPreviousRingtone(boolean ), 0, this, bl);
    }

    public boolean getStopPreviousRingtone() {
        return (boolean)InvokeDynamicSupport.bootstrap("getStopPreviousRingtone", $$robo$$android_media_RingtoneManager$getStopPreviousRingtone(), 0, this);
    }

    public void stopPreviousRingtone() {
        InvokeDynamicSupport.bootstrap("stopPreviousRingtone", $$robo$$android_media_RingtoneManager$stopPreviousRingtone(), 0, this);
    }

    @Deprecated
    public boolean getIncludeDrm() {
        return (boolean)InvokeDynamicSupport.bootstrap("getIncludeDrm", $$robo$$android_media_RingtoneManager$getIncludeDrm(), 0, this);
    }

    @Deprecated
    public void setIncludeDrm(boolean bl) {
        InvokeDynamicSupport.bootstrap("setIncludeDrm", $$robo$$android_media_RingtoneManager$setIncludeDrm(boolean ), 0, this, bl);
    }

    public Cursor getCursor() {
        return InvokeDynamicSupport.bootstrap("getCursor", $$robo$$android_media_RingtoneManager$getCursor(), 0, this);
    }

    public Ringtone getRingtone(int n) {
        return InvokeDynamicSupport.bootstrap("getRingtone", $$robo$$android_media_RingtoneManager$getRingtone(int ), 0, this, n);
    }

    public Uri getRingtoneUri(int n) {
        return InvokeDynamicSupport.bootstrap("getRingtoneUri", $$robo$$android_media_RingtoneManager$getRingtoneUri(int ), 0, this, n);
    }

    private static Uri getUriFromCursor(Cursor cursor) {
        return InvokeDynamicSupport.bootstrapStatic("getUriFromCursor", $$robo$$android_media_RingtoneManager$getUriFromCursor(android.database.Cursor ), 0, (Cursor)cursor);
    }

    public int getRingtonePosition(Uri uri) {
        return (int)InvokeDynamicSupport.bootstrap("getRingtonePosition", $$robo$$android_media_RingtoneManager$getRingtonePosition(android.net.Uri ), 0, this, uri);
    }

    public static Uri getValidRingtoneUri(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getValidRingtoneUri", $$robo$$android_media_RingtoneManager$getValidRingtoneUri(android.content.Context ), 0, (Context)context);
    }

    private static Uri getValidRingtoneUriFromCursorAndClose(Context context, Cursor cursor) {
        return InvokeDynamicSupport.bootstrapStatic("getValidRingtoneUriFromCursorAndClose", $$robo$$android_media_RingtoneManager$getValidRingtoneUriFromCursorAndClose(android.content.Context android.database.Cursor ), 0, (Context)context, (Cursor)cursor);
    }

    private Cursor getInternalRingtones() {
        return InvokeDynamicSupport.bootstrap("getInternalRingtones", $$robo$$android_media_RingtoneManager$getInternalRingtones(), 0, this);
    }

    private Cursor getMediaRingtones() {
        return InvokeDynamicSupport.bootstrap("getMediaRingtones", $$robo$$android_media_RingtoneManager$getMediaRingtones(), 0, this);
    }

    private void setFilterColumnsList(int n) {
        InvokeDynamicSupport.bootstrap("setFilterColumnsList", $$robo$$android_media_RingtoneManager$setFilterColumnsList(int ), 0, this, n);
    }

    private static String constructBooleanTrueWhereClause(List<String> list) {
        return InvokeDynamicSupport.bootstrapStatic("constructBooleanTrueWhereClause", $$robo$$android_media_RingtoneManager$constructBooleanTrueWhereClause(java.util.List<java.lang.String> ), 0, list);
    }

    private Cursor query(Uri uri, String[] stringArray, String string2, String[] stringArray2, String string3) {
        return InvokeDynamicSupport.bootstrap("query", $$robo$$android_media_RingtoneManager$query(android.net.Uri java.lang.String[] java.lang.String java.lang.String[] java.lang.String ), 0, this, uri, stringArray, string2, stringArray2, string3);
    }

    public static Ringtone getRingtone(Context context, Uri uri) {
        return InvokeDynamicSupport.bootstrapStatic("getRingtone", $$robo$$android_media_RingtoneManager$getRingtone(android.content.Context android.net.Uri ), 0, (Context)context, (Uri)uri);
    }

    private static Ringtone getRingtone(Context context, Uri uri, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getRingtone", $$robo$$android_media_RingtoneManager$getRingtone(android.content.Context android.net.Uri int ), 0, (Context)context, (Uri)uri, (int)n);
    }

    public static Uri getActualDefaultRingtoneUri(Context context, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getActualDefaultRingtoneUri", $$robo$$android_media_RingtoneManager$getActualDefaultRingtoneUri(android.content.Context int ), 0, (Context)context, (int)n);
    }

    public static void setActualDefaultRingtoneUri(Context context, int n, Uri uri) {
        InvokeDynamicSupport.bootstrapStatic("setActualDefaultRingtoneUri", $$robo$$android_media_RingtoneManager$setActualDefaultRingtoneUri(android.content.Context int android.net.Uri ), 0, (Context)context, (int)n, (Uri)uri);
    }

    private static String getSettingForType(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getSettingForType", $$robo$$android_media_RingtoneManager$getSettingForType(int ), 0, (int)n);
    }

    public static boolean isDefault(Uri uri) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isDefault", $$robo$$android_media_RingtoneManager$isDefault(android.net.Uri ), 0, (Uri)uri);
    }

    public static int getDefaultType(Uri uri) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getDefaultType", $$robo$$android_media_RingtoneManager$getDefaultType(android.net.Uri ), 0, (Uri)uri);
    }

    public static Uri getDefaultUri(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getDefaultUri", $$robo$$android_media_RingtoneManager$getDefaultUri(int ), 0, (int)n);
    }

    static {
        RobolectricInternals.classInitializing(RingtoneManager.class);
    }

    public /* synthetic */ RingtoneManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RingtoneManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

