/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.app.ActivityThread;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.media.AudioAttributes;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.util.AndroidRuntimeException;
import android.util.Log;
import com.android.internal.app.IAppOpsService;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.ref.WeakReference;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SoundPool
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private SoundPoolDelegate mImpl;

    private void $$robo$$android_media_SoundPool$__constructor__(int maxStreams, int streamType, int srcQuality) {
    }

    private void $$robo$$android_media_SoundPool$__constructor__(int maxStreams, AudioAttributes attributes) {
        this.mImpl = SystemProperties.getBoolean("config.disable_media", false) ? new SoundPoolStub() : new SoundPoolImpl(this, maxStreams, attributes);
    }

    private final int $$robo$$android_media_SoundPool$load(String path, int priority) {
        return this.mImpl.load(path, priority);
    }

    private final int $$robo$$android_media_SoundPool$load(Context context, int resId, int priority) {
        return this.mImpl.load(context, resId, priority);
    }

    private final int $$robo$$android_media_SoundPool$load(AssetFileDescriptor afd, int priority) {
        return this.mImpl.load(afd, priority);
    }

    private final int $$robo$$android_media_SoundPool$load(FileDescriptor fd, long offset, long length, int priority) {
        return this.mImpl.load(fd, offset, length, priority);
    }

    private final boolean $$robo$$android_media_SoundPool$unload(int soundID) {
        return this.mImpl.unload(soundID);
    }

    private final int $$robo$$android_media_SoundPool$play(int soundID, float leftVolume, float rightVolume, int priority, int loop, float rate) {
        return this.mImpl.play(soundID, leftVolume, rightVolume, priority, loop, rate);
    }

    private final void $$robo$$android_media_SoundPool$pause(int streamID) {
        this.mImpl.pause(streamID);
    }

    private final void $$robo$$android_media_SoundPool$resume(int streamID) {
        this.mImpl.resume(streamID);
    }

    private final void $$robo$$android_media_SoundPool$autoPause() {
        this.mImpl.autoPause();
    }

    private final void $$robo$$android_media_SoundPool$autoResume() {
        this.mImpl.autoResume();
    }

    private final void $$robo$$android_media_SoundPool$stop(int streamID) {
        this.mImpl.stop(streamID);
    }

    private final void $$robo$$android_media_SoundPool$setVolume(int streamID, float leftVolume, float rightVolume) {
        this.mImpl.setVolume(streamID, leftVolume, rightVolume);
    }

    private final void $$robo$$android_media_SoundPool$setVolume(int streamID, float volume) {
        this.setVolume(streamID, volume, volume);
    }

    private final void $$robo$$android_media_SoundPool$setPriority(int streamID, int priority) {
        this.mImpl.setPriority(streamID, priority);
    }

    private final void $$robo$$android_media_SoundPool$setLoop(int streamID, int loop) {
        this.mImpl.setLoop(streamID, loop);
    }

    private final void $$robo$$android_media_SoundPool$setRate(int streamID, float rate) {
        this.mImpl.setRate(streamID, rate);
    }

    private final void $$robo$$android_media_SoundPool$setOnLoadCompleteListener(OnLoadCompleteListener listener) {
        this.mImpl.setOnLoadCompleteListener(listener);
    }

    private final void $$robo$$android_media_SoundPool$release() {
        this.mImpl.release();
    }

    private /* synthetic */ void $$robo$$android_media_SoundPool$__constructor__(int x0, AudioAttributes x1, 1 x2) {
    }

    private void __constructor__(int n, int n2, int n3) {
        this.$$robo$$android_media_SoundPool$__constructor__(n, n2, n3);
    }

    public SoundPool(int n, int n2, int n3) {
        this(n, new AudioAttributes.Builder().setInternalLegacyStreamType(n2).build());
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_SoundPool$__constructor__(int int int ), 0, this, n, n2, n3);
    }

    private void __constructor__(int n, AudioAttributes audioAttributes) {
        this.$$robo$$android_media_SoundPool$__constructor__(n, audioAttributes);
    }

    private SoundPool(int n, AudioAttributes audioAttributes) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_SoundPool$__constructor__(int android.media.AudioAttributes ), 0, this, n, audioAttributes);
    }

    public int load(String string2, int n) {
        return (int)InvokeDynamicSupport.bootstrap("load", $$robo$$android_media_SoundPool$load(java.lang.String int ), 0, this, string2, n);
    }

    public int load(Context context, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("load", $$robo$$android_media_SoundPool$load(android.content.Context int int ), 0, this, context, n, n2);
    }

    public int load(AssetFileDescriptor assetFileDescriptor, int n) {
        return (int)InvokeDynamicSupport.bootstrap("load", $$robo$$android_media_SoundPool$load(android.content.res.AssetFileDescriptor int ), 0, this, assetFileDescriptor, n);
    }

    public int load(FileDescriptor fileDescriptor, long l, long l2, int n) {
        return (int)InvokeDynamicSupport.bootstrap("load", $$robo$$android_media_SoundPool$load(java.io.FileDescriptor long long int ), 0, this, fileDescriptor, l, l2, n);
    }

    public boolean unload(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("unload", $$robo$$android_media_SoundPool$unload(int ), 0, this, n);
    }

    public int play(int n, float f, float f2, int n2, int n3, float f3) {
        return (int)InvokeDynamicSupport.bootstrap("play", $$robo$$android_media_SoundPool$play(int float float int int float ), 0, this, n, f, f2, n2, n3, f3);
    }

    public void pause(int n) {
        InvokeDynamicSupport.bootstrap("pause", $$robo$$android_media_SoundPool$pause(int ), 0, this, n);
    }

    public void resume(int n) {
        InvokeDynamicSupport.bootstrap("resume", $$robo$$android_media_SoundPool$resume(int ), 0, this, n);
    }

    public void autoPause() {
        InvokeDynamicSupport.bootstrap("autoPause", $$robo$$android_media_SoundPool$autoPause(), 0, this);
    }

    public void autoResume() {
        InvokeDynamicSupport.bootstrap("autoResume", $$robo$$android_media_SoundPool$autoResume(), 0, this);
    }

    public void stop(int n) {
        InvokeDynamicSupport.bootstrap("stop", $$robo$$android_media_SoundPool$stop(int ), 0, this, n);
    }

    public void setVolume(int n, float f, float f2) {
        InvokeDynamicSupport.bootstrap("setVolume", $$robo$$android_media_SoundPool$setVolume(int float float ), 0, this, n, f, f2);
    }

    public void setVolume(int n, float f) {
        InvokeDynamicSupport.bootstrap("setVolume", $$robo$$android_media_SoundPool$setVolume(int float ), 0, this, n, f);
    }

    public void setPriority(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setPriority", $$robo$$android_media_SoundPool$setPriority(int int ), 0, this, n, n2);
    }

    public void setLoop(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setLoop", $$robo$$android_media_SoundPool$setLoop(int int ), 0, this, n, n2);
    }

    public void setRate(int n, float f) {
        InvokeDynamicSupport.bootstrap("setRate", $$robo$$android_media_SoundPool$setRate(int float ), 0, this, n, f);
    }

    public void setOnLoadCompleteListener(OnLoadCompleteListener onLoadCompleteListener) {
        InvokeDynamicSupport.bootstrap("setOnLoadCompleteListener", $$robo$$android_media_SoundPool$setOnLoadCompleteListener(android.media.SoundPool$OnLoadCompleteListener ), 0, this, onLoadCompleteListener);
    }

    public void release() {
        InvokeDynamicSupport.bootstrap("release", $$robo$$android_media_SoundPool$release(), 0, this);
    }

    private /* synthetic */ void __constructor__(int n, AudioAttributes audioAttributes, 1 var3_3) {
        this.$$robo$$android_media_SoundPool$__constructor__(n, audioAttributes, var3_3);
    }

    public /* synthetic */ SoundPool() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SoundPool)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class SoundPoolStub
    implements SoundPoolDelegate,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_media_SoundPool_SoundPoolStub$__constructor__() {
        }

        private final int $$robo$$android_media_SoundPool_SoundPoolStub$load(String path, int priority) {
            return 0;
        }

        private final int $$robo$$android_media_SoundPool_SoundPoolStub$load(Context context, int resId, int priority) {
            return 0;
        }

        private final int $$robo$$android_media_SoundPool_SoundPoolStub$load(AssetFileDescriptor afd, int priority) {
            return 0;
        }

        private final int $$robo$$android_media_SoundPool_SoundPoolStub$load(FileDescriptor fd, long offset, long length, int priority) {
            return 0;
        }

        private final boolean $$robo$$android_media_SoundPool_SoundPoolStub$unload(int soundID) {
            return true;
        }

        private final int $$robo$$android_media_SoundPool_SoundPoolStub$play(int soundID, float leftVolume, float rightVolume, int priority, int loop, float rate) {
            return 0;
        }

        private final void $$robo$$android_media_SoundPool_SoundPoolStub$pause(int streamID) {
        }

        private final void $$robo$$android_media_SoundPool_SoundPoolStub$resume(int streamID) {
        }

        private final void $$robo$$android_media_SoundPool_SoundPoolStub$autoPause() {
        }

        private final void $$robo$$android_media_SoundPool_SoundPoolStub$autoResume() {
        }

        private final void $$robo$$android_media_SoundPool_SoundPoolStub$stop(int streamID) {
        }

        private final void $$robo$$android_media_SoundPool_SoundPoolStub$setVolume(int streamID, float leftVolume, float rightVolume) {
        }

        private final void $$robo$$android_media_SoundPool_SoundPoolStub$setVolume(int streamID, float volume) {
        }

        private final void $$robo$$android_media_SoundPool_SoundPoolStub$setPriority(int streamID, int priority) {
        }

        private final void $$robo$$android_media_SoundPool_SoundPoolStub$setLoop(int streamID, int loop) {
        }

        private final void $$robo$$android_media_SoundPool_SoundPoolStub$setRate(int streamID, float rate) {
        }

        private final void $$robo$$android_media_SoundPool_SoundPoolStub$setOnLoadCompleteListener(OnLoadCompleteListener listener) {
        }

        private final void $$robo$$android_media_SoundPool_SoundPoolStub$release() {
        }

        private void __constructor__() {
            this.$$robo$$android_media_SoundPool_SoundPoolStub$__constructor__();
        }

        public SoundPoolStub() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_SoundPool_SoundPoolStub$__constructor__(), 0, this);
        }

        @Override
        public int load(String string2, int n) {
            return (int)InvokeDynamicSupport.bootstrap("load", $$robo$$android_media_SoundPool_SoundPoolStub$load(java.lang.String int ), 0, this, string2, n);
        }

        @Override
        public int load(Context context, int n, int n2) {
            return (int)InvokeDynamicSupport.bootstrap("load", $$robo$$android_media_SoundPool_SoundPoolStub$load(android.content.Context int int ), 0, this, context, n, n2);
        }

        @Override
        public int load(AssetFileDescriptor assetFileDescriptor, int n) {
            return (int)InvokeDynamicSupport.bootstrap("load", $$robo$$android_media_SoundPool_SoundPoolStub$load(android.content.res.AssetFileDescriptor int ), 0, this, assetFileDescriptor, n);
        }

        @Override
        public int load(FileDescriptor fileDescriptor, long l, long l2, int n) {
            return (int)InvokeDynamicSupport.bootstrap("load", $$robo$$android_media_SoundPool_SoundPoolStub$load(java.io.FileDescriptor long long int ), 0, this, fileDescriptor, l, l2, n);
        }

        @Override
        public boolean unload(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("unload", $$robo$$android_media_SoundPool_SoundPoolStub$unload(int ), 0, this, n);
        }

        @Override
        public int play(int n, float f, float f2, int n2, int n3, float f3) {
            return (int)InvokeDynamicSupport.bootstrap("play", $$robo$$android_media_SoundPool_SoundPoolStub$play(int float float int int float ), 0, this, n, f, f2, n2, n3, f3);
        }

        @Override
        public void pause(int n) {
            InvokeDynamicSupport.bootstrap("pause", $$robo$$android_media_SoundPool_SoundPoolStub$pause(int ), 0, this, n);
        }

        @Override
        public void resume(int n) {
            InvokeDynamicSupport.bootstrap("resume", $$robo$$android_media_SoundPool_SoundPoolStub$resume(int ), 0, this, n);
        }

        @Override
        public void autoPause() {
            InvokeDynamicSupport.bootstrap("autoPause", $$robo$$android_media_SoundPool_SoundPoolStub$autoPause(), 0, this);
        }

        @Override
        public void autoResume() {
            InvokeDynamicSupport.bootstrap("autoResume", $$robo$$android_media_SoundPool_SoundPoolStub$autoResume(), 0, this);
        }

        @Override
        public void stop(int n) {
            InvokeDynamicSupport.bootstrap("stop", $$robo$$android_media_SoundPool_SoundPoolStub$stop(int ), 0, this, n);
        }

        @Override
        public void setVolume(int n, float f, float f2) {
            InvokeDynamicSupport.bootstrap("setVolume", $$robo$$android_media_SoundPool_SoundPoolStub$setVolume(int float float ), 0, this, n, f, f2);
        }

        @Override
        public void setVolume(int n, float f) {
            InvokeDynamicSupport.bootstrap("setVolume", $$robo$$android_media_SoundPool_SoundPoolStub$setVolume(int float ), 0, this, n, f);
        }

        @Override
        public void setPriority(int n, int n2) {
            InvokeDynamicSupport.bootstrap("setPriority", $$robo$$android_media_SoundPool_SoundPoolStub$setPriority(int int ), 0, this, n, n2);
        }

        @Override
        public void setLoop(int n, int n2) {
            InvokeDynamicSupport.bootstrap("setLoop", $$robo$$android_media_SoundPool_SoundPoolStub$setLoop(int int ), 0, this, n, n2);
        }

        @Override
        public void setRate(int n, float f) {
            InvokeDynamicSupport.bootstrap("setRate", $$robo$$android_media_SoundPool_SoundPoolStub$setRate(int float ), 0, this, n, f);
        }

        @Override
        public void setOnLoadCompleteListener(OnLoadCompleteListener onLoadCompleteListener) {
            InvokeDynamicSupport.bootstrap("setOnLoadCompleteListener", $$robo$$android_media_SoundPool_SoundPoolStub$setOnLoadCompleteListener(android.media.SoundPool$OnLoadCompleteListener ), 0, this, onLoadCompleteListener);
        }

        @Override
        public void release() {
            InvokeDynamicSupport.bootstrap("release", $$robo$$android_media_SoundPool_SoundPoolStub$release(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SoundPoolStub)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class SoundPoolImpl
    implements SoundPoolDelegate,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static String TAG = "SoundPool";
        private static boolean DEBUG = false;
        private long mNativeContext;
        private EventHandler mEventHandler;
        private OnLoadCompleteListener mOnLoadCompleteListener;
        private SoundPool mProxy;
        private Object mLock;
        private AudioAttributes mAttributes;
        private IAppOpsService mAppOps;
        private static int SAMPLE_LOADED = 1;

        private void $$robo$$android_media_SoundPool_SoundPoolImpl$__constructor__(SoundPool proxy, int maxStreams, AudioAttributes attr2) {
            if (this.native_setup(new WeakReference<SoundPoolImpl>(this), maxStreams, attr2) != 0) {
                throw new RuntimeException("Native setup failed");
            }
            this.mLock = new Object();
            this.mProxy = proxy;
            this.mAttributes = attr2;
            IBinder b = ServiceManager.getService("appops");
            this.mAppOps = IAppOpsService.Stub.asInterface(b);
        }

        private final int $$robo$$android_media_SoundPool_SoundPoolImpl$load(String path, int priority) {
            if (path.startsWith("http:")) {
                return this._load(path, priority);
            }
            int id2 = 0;
            try {
                File f = new File(path);
                ParcelFileDescriptor fd = ParcelFileDescriptor.open(f, 0x10000000);
                if (fd != null) {
                    id2 = this._load(fd.getFileDescriptor(), 0L, f.length(), priority);
                    fd.close();
                }
            }
            catch (IOException e) {
                Log.e("SoundPool", "error loading " + path);
            }
            return id2;
        }

        private final int $$robo$$android_media_SoundPool_SoundPoolImpl$load(Context context, int resId, int priority) {
            AssetFileDescriptor afd = context.getResources().openRawResourceFd(resId);
            int id2 = 0;
            if (afd != null) {
                id2 = this._load(afd.getFileDescriptor(), afd.getStartOffset(), afd.getLength(), priority);
                try {
                    afd.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return id2;
        }

        private final int $$robo$$android_media_SoundPool_SoundPoolImpl$load(AssetFileDescriptor afd, int priority) {
            if (afd != null) {
                long len = afd.getLength();
                if (len < 0L) {
                    throw new AndroidRuntimeException("no length for fd");
                }
                return this._load(afd.getFileDescriptor(), afd.getStartOffset(), len, priority);
            }
            return 0;
        }

        private final int $$robo$$android_media_SoundPool_SoundPoolImpl$load(FileDescriptor fd, long offset, long length, int priority) {
            return this._load(fd, offset, length, priority);
        }

        private final int $$robo$$android_media_SoundPool_SoundPoolImpl$_load(String string2, int n) {
            return 0;
        }

        private final int $$robo$$android_media_SoundPool_SoundPoolImpl$_load(FileDescriptor fileDescriptor, long l, long l2, int n) {
            return 0;
        }

        private final boolean $$robo$$android_media_SoundPool_SoundPoolImpl$unload(int n) {
            return false;
        }

        private final int $$robo$$android_media_SoundPool_SoundPoolImpl$play(int soundID, float leftVolume, float rightVolume, int priority, int loop, float rate) {
            if (this.isRestricted()) {
                rightVolume = 0.0f;
                leftVolume = 0.0f;
            }
            return this._play(soundID, leftVolume, rightVolume, priority, loop, rate);
        }

        private final int $$robo$$android_media_SoundPool_SoundPoolImpl$_play(int n, float f, float f2, int n2, int n3, float f3) {
            return 0;
        }

        private final boolean $$robo$$android_media_SoundPool_SoundPoolImpl$isRestricted() {
            try {
                int mode = this.mAppOps.checkAudioOperation(28, this.mAttributes.getUsage(), Process.myUid(), ActivityThread.currentPackageName());
                return mode != 0;
            }
            catch (RemoteException e) {
                return false;
            }
        }

        private final void $$robo$$android_media_SoundPool_SoundPoolImpl$pause(int n) {
        }

        private final void $$robo$$android_media_SoundPool_SoundPoolImpl$resume(int n) {
        }

        private final void $$robo$$android_media_SoundPool_SoundPoolImpl$autoPause() {
        }

        private final void $$robo$$android_media_SoundPool_SoundPoolImpl$autoResume() {
        }

        private final void $$robo$$android_media_SoundPool_SoundPoolImpl$stop(int n) {
        }

        private final void $$robo$$android_media_SoundPool_SoundPoolImpl$setVolume(int streamID, float leftVolume, float rightVolume) {
            if (this.isRestricted()) {
                return;
            }
            this._setVolume(streamID, leftVolume, rightVolume);
        }

        private final void $$robo$$android_media_SoundPool_SoundPoolImpl$_setVolume(int n, float f, float f2) {
        }

        private final void $$robo$$android_media_SoundPool_SoundPoolImpl$setVolume(int streamID, float volume) {
            this.setVolume(streamID, volume, volume);
        }

        private final void $$robo$$android_media_SoundPool_SoundPoolImpl$setPriority(int n, int n2) {
        }

        private final void $$robo$$android_media_SoundPool_SoundPoolImpl$setLoop(int n, int n2) {
        }

        private final void $$robo$$android_media_SoundPool_SoundPoolImpl$setRate(int n, float f) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_SoundPool_SoundPoolImpl$setOnLoadCompleteListener(OnLoadCompleteListener listener) {
            Object object = this.mLock;
            synchronized (object) {
                Looper looper;
                this.mEventHandler = listener != null ? ((looper = Looper.myLooper()) != null ? new EventHandler(this, this.mProxy, looper) : ((looper = Looper.getMainLooper()) != null ? new EventHandler(this, this.mProxy, looper) : null)) : null;
                this.mOnLoadCompleteListener = listener;
            }
        }

        private static final void $$robo$$android_media_SoundPool_SoundPoolImpl$postEventFromNative(Object weakRef, int msg, int arg1, int arg2, Object obj) {
            SoundPoolImpl soundPoolImpl = (SoundPoolImpl)((WeakReference)weakRef).get();
            if (soundPoolImpl == null) {
                return;
            }
            if (soundPoolImpl.mEventHandler != null) {
                Message m = soundPoolImpl.mEventHandler.obtainMessage(msg, arg1, arg2, obj);
                soundPoolImpl.mEventHandler.sendMessage(m);
            }
        }

        private final void $$robo$$android_media_SoundPool_SoundPoolImpl$release() {
        }

        private final int $$robo$$android_media_SoundPool_SoundPoolImpl$native_setup(Object object, int n, Object object2) {
            return 0;
        }

        private final void $$robo$$android_media_SoundPool_SoundPoolImpl$finalize() {
            this.release();
        }

        static void __staticInitializer__() {
            InvokeDynamicSupport.bootstrapIntrinsic("loadLibrary", "java.lang.System", (String)"soundpool");
        }

        private void __constructor__(SoundPool soundPool, int n, AudioAttributes audioAttributes) {
            this.$$robo$$android_media_SoundPool_SoundPoolImpl$__constructor__(soundPool, n, audioAttributes);
        }

        public SoundPoolImpl(SoundPool soundPool, int n, AudioAttributes audioAttributes) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_SoundPool_SoundPoolImpl$__constructor__(android.media.SoundPool int android.media.AudioAttributes ), 0, this, soundPool, n, audioAttributes);
        }

        @Override
        public int load(String string2, int n) {
            return (int)InvokeDynamicSupport.bootstrap("load", $$robo$$android_media_SoundPool_SoundPoolImpl$load(java.lang.String int ), 0, this, string2, n);
        }

        @Override
        public int load(Context context, int n, int n2) {
            return (int)InvokeDynamicSupport.bootstrap("load", $$robo$$android_media_SoundPool_SoundPoolImpl$load(android.content.Context int int ), 0, this, context, n, n2);
        }

        @Override
        public int load(AssetFileDescriptor assetFileDescriptor, int n) {
            return (int)InvokeDynamicSupport.bootstrap("load", $$robo$$android_media_SoundPool_SoundPoolImpl$load(android.content.res.AssetFileDescriptor int ), 0, this, assetFileDescriptor, n);
        }

        @Override
        public int load(FileDescriptor fileDescriptor, long l, long l2, int n) {
            return (int)InvokeDynamicSupport.bootstrap("load", $$robo$$android_media_SoundPool_SoundPoolImpl$load(java.io.FileDescriptor long long int ), 0, this, fileDescriptor, l, l2, n);
        }

        private final native /* synthetic */ int $$robo$$_load$nativeBinding(String var1, int var2);

        private int _load(String string2, int n) {
            return (int)InvokeDynamicSupport.bootstrap("_load", $$robo$$android_media_SoundPool_SoundPoolImpl$_load(java.lang.String int ), 1, this, string2, n);
        }

        private final native /* synthetic */ int $$robo$$_load$nativeBinding(FileDescriptor var1, long var2, long var4, int var6);

        private int _load(FileDescriptor fileDescriptor, long l, long l2, int n) {
            return (int)InvokeDynamicSupport.bootstrap("_load", $$robo$$android_media_SoundPool_SoundPoolImpl$_load(java.io.FileDescriptor long long int ), 1, this, fileDescriptor, l, l2, n);
        }

        private final native /* synthetic */ boolean $$robo$$unload$nativeBinding(int var1);

        @Override
        public boolean unload(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("unload", $$robo$$android_media_SoundPool_SoundPoolImpl$unload(int ), 1, this, n);
        }

        @Override
        public int play(int n, float f, float f2, int n2, int n3, float f3) {
            return (int)InvokeDynamicSupport.bootstrap("play", $$robo$$android_media_SoundPool_SoundPoolImpl$play(int float float int int float ), 0, this, n, f, f2, n2, n3, f3);
        }

        private final native /* synthetic */ int $$robo$$_play$nativeBinding(int var1, float var2, float var3, int var4, int var5, float var6);

        public int _play(int n, float f, float f2, int n2, int n3, float f3) {
            return (int)InvokeDynamicSupport.bootstrap("_play", $$robo$$android_media_SoundPool_SoundPoolImpl$_play(int float float int int float ), 1, this, n, f, f2, n2, n3, f3);
        }

        private boolean isRestricted() {
            return (boolean)InvokeDynamicSupport.bootstrap("isRestricted", $$robo$$android_media_SoundPool_SoundPoolImpl$isRestricted(), 0, this);
        }

        private final native /* synthetic */ void $$robo$$pause$nativeBinding(int var1);

        @Override
        public void pause(int n) {
            InvokeDynamicSupport.bootstrap("pause", $$robo$$android_media_SoundPool_SoundPoolImpl$pause(int ), 1, this, n);
        }

        private final native /* synthetic */ void $$robo$$resume$nativeBinding(int var1);

        @Override
        public void resume(int n) {
            InvokeDynamicSupport.bootstrap("resume", $$robo$$android_media_SoundPool_SoundPoolImpl$resume(int ), 1, this, n);
        }

        private final native /* synthetic */ void $$robo$$autoPause$nativeBinding();

        @Override
        public void autoPause() {
            InvokeDynamicSupport.bootstrap("autoPause", $$robo$$android_media_SoundPool_SoundPoolImpl$autoPause(), 1, this);
        }

        private final native /* synthetic */ void $$robo$$autoResume$nativeBinding();

        @Override
        public void autoResume() {
            InvokeDynamicSupport.bootstrap("autoResume", $$robo$$android_media_SoundPool_SoundPoolImpl$autoResume(), 1, this);
        }

        private final native /* synthetic */ void $$robo$$stop$nativeBinding(int var1);

        @Override
        public void stop(int n) {
            InvokeDynamicSupport.bootstrap("stop", $$robo$$android_media_SoundPool_SoundPoolImpl$stop(int ), 1, this, n);
        }

        @Override
        public void setVolume(int n, float f, float f2) {
            InvokeDynamicSupport.bootstrap("setVolume", $$robo$$android_media_SoundPool_SoundPoolImpl$setVolume(int float float ), 0, this, n, f, f2);
        }

        private final native /* synthetic */ void $$robo$$_setVolume$nativeBinding(int var1, float var2, float var3);

        private void _setVolume(int n, float f, float f2) {
            InvokeDynamicSupport.bootstrap("_setVolume", $$robo$$android_media_SoundPool_SoundPoolImpl$_setVolume(int float float ), 1, this, n, f, f2);
        }

        @Override
        public void setVolume(int n, float f) {
            InvokeDynamicSupport.bootstrap("setVolume", $$robo$$android_media_SoundPool_SoundPoolImpl$setVolume(int float ), 0, this, n, f);
        }

        private final native /* synthetic */ void $$robo$$setPriority$nativeBinding(int var1, int var2);

        @Override
        public void setPriority(int n, int n2) {
            InvokeDynamicSupport.bootstrap("setPriority", $$robo$$android_media_SoundPool_SoundPoolImpl$setPriority(int int ), 1, this, n, n2);
        }

        private final native /* synthetic */ void $$robo$$setLoop$nativeBinding(int var1, int var2);

        @Override
        public void setLoop(int n, int n2) {
            InvokeDynamicSupport.bootstrap("setLoop", $$robo$$android_media_SoundPool_SoundPoolImpl$setLoop(int int ), 1, this, n, n2);
        }

        private final native /* synthetic */ void $$robo$$setRate$nativeBinding(int var1, float var2);

        @Override
        public void setRate(int n, float f) {
            InvokeDynamicSupport.bootstrap("setRate", $$robo$$android_media_SoundPool_SoundPoolImpl$setRate(int float ), 1, this, n, f);
        }

        @Override
        public void setOnLoadCompleteListener(OnLoadCompleteListener onLoadCompleteListener) {
            InvokeDynamicSupport.bootstrap("setOnLoadCompleteListener", $$robo$$android_media_SoundPool_SoundPoolImpl$setOnLoadCompleteListener(android.media.SoundPool$OnLoadCompleteListener ), 0, this, onLoadCompleteListener);
        }

        private static void postEventFromNative(Object object, int n, int n2, int n3, Object object2) {
            InvokeDynamicSupport.bootstrapStatic("postEventFromNative", $$robo$$android_media_SoundPool_SoundPoolImpl$postEventFromNative(java.lang.Object int int int java.lang.Object ), 0, (Object)object, (int)n, (int)n2, (int)n3, (Object)object2);
        }

        private final native /* synthetic */ void $$robo$$release$nativeBinding();

        @Override
        public void release() {
            InvokeDynamicSupport.bootstrap("release", $$robo$$android_media_SoundPool_SoundPoolImpl$release(), 1, this);
        }

        private final native /* synthetic */ int $$robo$$native_setup$nativeBinding(Object var1, int var2, Object var3);

        private int native_setup(Object object, int n, Object object2) {
            return (int)InvokeDynamicSupport.bootstrap("native_setup", $$robo$$android_media_SoundPool_SoundPoolImpl$native_setup(java.lang.Object int java.lang.Object ), 1, this, object, n, object2);
        }

        protected void finalize() {
            InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_media_SoundPool_SoundPoolImpl$finalize(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(SoundPoolImpl.class);
        }

        public /* synthetic */ SoundPoolImpl() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SoundPoolImpl)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        private class EventHandler
        extends Handler
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            private SoundPool mSoundPool;
            /* synthetic */ SoundPoolImpl this$0;

            private void $$robo$$android_media_SoundPool_SoundPoolImpl_EventHandler$__constructor__(SoundPoolImpl soundPoolImpl, SoundPool soundPool, Looper looper) {
                this.mSoundPool = soundPool;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_media_SoundPool_SoundPoolImpl_EventHandler$handleMessage(Message msg) {
                switch (msg.what) {
                    case 1: {
                        Object object = this.this$0.mLock;
                        synchronized (object) {
                            if (this.this$0.mOnLoadCompleteListener != null) {
                                this.this$0.mOnLoadCompleteListener.onLoadComplete(this.mSoundPool, msg.arg1, msg.arg2);
                            }
                            break;
                        }
                    }
                    default: {
                        Log.e("SoundPool", "Unknown message type " + msg.what);
                        return;
                    }
                }
            }

            private void __constructor__(SoundPoolImpl soundPoolImpl, SoundPool soundPool, Looper looper) {
                this.$$robo$$android_media_SoundPool_SoundPoolImpl_EventHandler$__constructor__(soundPoolImpl, soundPool, looper);
            }

            public EventHandler(SoundPoolImpl soundPoolImpl, SoundPool soundPool, Looper looper) {
                this.this$0 = soundPoolImpl;
                super(looper);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_SoundPool_SoundPoolImpl_EventHandler$__constructor__(android.media.SoundPool$SoundPoolImpl android.media.SoundPool android.os.Looper ), 0, this, soundPoolImpl, soundPool, looper);
            }

            @Override
            public void handleMessage(Message message) {
                InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_media_SoundPool_SoundPoolImpl_EventHandler$handleMessage(android.os.Message ), 0, this, message);
            }

            public /* synthetic */ EventHandler() {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EventHandler)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    static interface SoundPoolDelegate
    extends InstrumentedInterface {
        public int load(String var1, int var2);

        public int load(Context var1, int var2, int var3);

        public int load(AssetFileDescriptor var1, int var2);

        public int load(FileDescriptor var1, long var2, long var4, int var6);

        public boolean unload(int var1);

        public int play(int var1, float var2, float var3, int var4, int var5, float var6);

        public void pause(int var1);

        public void resume(int var1);

        public void autoPause();

        public void autoResume();

        public void stop(int var1);

        public void setVolume(int var1, float var2, float var3);

        public void setVolume(int var1, float var2);

        public void setPriority(int var1, int var2);

        public void setLoop(int var1, int var2);

        public void setRate(int var1, float var2);

        public void setOnLoadCompleteListener(OnLoadCompleteListener var1);

        public void release();
    }

    public static interface OnLoadCompleteListener
    extends InstrumentedInterface {
        public void onLoadComplete(SoundPool var1, int var2, int var3);
    }

    public static class Builder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mMaxStreams;
        private AudioAttributes mAudioAttributes;

        private void $$robo$$android_media_SoundPool_Builder$__constructor__() {
            this.mMaxStreams = 1;
        }

        private final Builder $$robo$$android_media_SoundPool_Builder$setMaxStreams(int maxStreams) throws IllegalArgumentException {
            if (maxStreams <= 0) {
                throw new IllegalArgumentException("Strictly positive value required for the maximum number of streams");
            }
            this.mMaxStreams = maxStreams;
            return this;
        }

        private final Builder $$robo$$android_media_SoundPool_Builder$setAudioAttributes(AudioAttributes attributes) throws IllegalArgumentException {
            if (attributes == null) {
                throw new IllegalArgumentException("Invalid null AudioAttributes");
            }
            this.mAudioAttributes = attributes;
            return this;
        }

        private final SoundPool $$robo$$android_media_SoundPool_Builder$build() {
            if (this.mAudioAttributes == null) {
                this.mAudioAttributes = new AudioAttributes.Builder().setUsage(1).build();
            }
            return new SoundPool(this.mMaxStreams, this.mAudioAttributes);
        }

        private void __constructor__() {
            this.$$robo$$android_media_SoundPool_Builder$__constructor__();
        }

        public Builder() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_SoundPool_Builder$__constructor__(), 0, this);
        }

        public Builder setMaxStreams(int n) throws IllegalArgumentException {
            return InvokeDynamicSupport.bootstrap("setMaxStreams", $$robo$$android_media_SoundPool_Builder$setMaxStreams(int ), 0, this, n);
        }

        public Builder setAudioAttributes(AudioAttributes audioAttributes) throws IllegalArgumentException {
            return InvokeDynamicSupport.bootstrap("setAudioAttributes", $$robo$$android_media_SoundPool_Builder$setAudioAttributes(android.media.AudioAttributes ), 0, this, audioAttributes);
        }

        public SoundPool build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_media_SoundPool_Builder$build(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

