/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.content.Context;
import android.media.MediaFormat;
import android.media.MediaTimeProvider;
import android.media.SubtitleTrack;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.view.accessibility.CaptioningManager;
import java.util.Locale;
import java.util.Vector;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SubtitleController
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private MediaTimeProvider mTimeProvider;
    private Vector<Renderer> mRenderers;
    private Vector<SubtitleTrack> mTracks;
    private SubtitleTrack mSelectedTrack;
    private boolean mShowing;
    private CaptioningManager mCaptioningManager;
    private Handler mHandler;
    private static int WHAT_SHOW = 1;
    private static int WHAT_HIDE = 2;
    private static int WHAT_SELECT_TRACK = 3;
    private static int WHAT_SELECT_DEFAULT_TRACK = 4;
    private Handler.Callback mCallback;
    private CaptioningManager.CaptioningChangeListener mCaptioningChangeListener;
    private boolean mTrackIsExplicit;
    private boolean mVisibilityIsExplicit;
    private Anchor mAnchor;
    private Listener mListener;
    static /* synthetic */ boolean $assertionsDisabled;

    private void $$robo$$android_media_SubtitleController$__constructor__(Context context, MediaTimeProvider timeProvider, Listener listener) {
        this.mCallback = new Handler.Callback(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ SubtitleController this$0;

            private void $$robo$$android_media_SubtitleController_1$__constructor__(SubtitleController subtitleController) {
            }

            private final boolean $$robo$$android_media_SubtitleController_1$handleMessage(Message msg) {
                switch (msg.what) {
                    case 1: {
                        this.this$0.doShow();
                        return true;
                    }
                    case 2: {
                        this.this$0.doHide();
                        return true;
                    }
                    case 3: {
                        this.this$0.doSelectTrack((SubtitleTrack)msg.obj);
                        return true;
                    }
                    case 4: {
                        this.this$0.doSelectDefaultTrack();
                        return true;
                    }
                }
                return false;
            }

            private void __constructor__(SubtitleController subtitleController) {
                this.$$robo$$android_media_SubtitleController_1$__constructor__(subtitleController);
            }
            {
                this.this$0 = subtitleController;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_SubtitleController_1$__constructor__(android.media.SubtitleController ), 0, this, subtitleController);
            }

            @Override
            public boolean handleMessage(Message message) {
                return (boolean)InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_media_SubtitleController_1$handleMessage(android.os.Message ), 0, this, message);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mCaptioningChangeListener = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ SubtitleController this$0;

            private void $$robo$$android_media_SubtitleController_2$__constructor__(SubtitleController subtitleController) {
            }

            private final void $$robo$$android_media_SubtitleController_2$onEnabledChanged(boolean enabled) {
                this.this$0.selectDefaultTrack();
            }

            private final void $$robo$$android_media_SubtitleController_2$onLocaleChanged(Locale locale) {
                this.this$0.selectDefaultTrack();
            }

            private void __constructor__(SubtitleController subtitleController) {
                this.$$robo$$android_media_SubtitleController_2$__constructor__(subtitleController);
            }
            {
                this.this$0 = subtitleController;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_SubtitleController_2$__constructor__(android.media.SubtitleController ), 0, this, subtitleController);
            }

            @Override
            public void onEnabledChanged(boolean bl) {
                InvokeDynamicSupport.bootstrap("onEnabledChanged", $$robo$$android_media_SubtitleController_2$onEnabledChanged(boolean ), 0, this, bl);
            }

            @Override
            public void onLocaleChanged(Locale locale) {
                InvokeDynamicSupport.bootstrap("onLocaleChanged", $$robo$$android_media_SubtitleController_2$onLocaleChanged(java.util.Locale ), 0, this, locale);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mTrackIsExplicit = false;
        this.mVisibilityIsExplicit = false;
        this.mTimeProvider = timeProvider;
        this.mListener = listener;
        this.mRenderers = new Vector();
        this.mShowing = false;
        this.mTracks = new Vector();
        this.mCaptioningManager = (CaptioningManager)context.getSystemService("captioning");
    }

    private final void $$robo$$android_media_SubtitleController$finalize() throws Throwable {
        this.mCaptioningManager.removeCaptioningChangeListener(this.mCaptioningChangeListener);
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SubtitleTrack[] $$robo$$android_media_SubtitleController$getTracks() {
        Vector<SubtitleTrack> vector = this.mTracks;
        synchronized (vector) {
            SubtitleTrack[] tracks = new SubtitleTrack[this.mTracks.size()];
            this.mTracks.toArray(tracks);
            return tracks;
        }
    }

    private final SubtitleTrack $$robo$$android_media_SubtitleController$getSelectedTrack() {
        return this.mSelectedTrack;
    }

    private final SubtitleTrack.RenderingWidget $$robo$$android_media_SubtitleController$getRenderingWidget() {
        if (this.mSelectedTrack == null) {
            return null;
        }
        return this.mSelectedTrack.getRenderingWidget();
    }

    private final boolean $$robo$$android_media_SubtitleController$selectTrack(SubtitleTrack track) {
        if (track != null && !this.mTracks.contains(track)) {
            return false;
        }
        this.processOnAnchor(this.mHandler.obtainMessage(3, track));
        return true;
    }

    private final void $$robo$$android_media_SubtitleController$doSelectTrack(SubtitleTrack track) {
        this.mTrackIsExplicit = true;
        if (this.mSelectedTrack == track) {
            return;
        }
        if (this.mSelectedTrack != null) {
            this.mSelectedTrack.hide();
            this.mSelectedTrack.setTimeProvider(null);
        }
        this.mSelectedTrack = track;
        if (this.mAnchor != null) {
            this.mAnchor.setSubtitleWidget(this.getRenderingWidget());
        }
        if (this.mSelectedTrack != null) {
            this.mSelectedTrack.setTimeProvider(this.mTimeProvider);
            this.mSelectedTrack.show();
        }
        if (this.mListener != null) {
            this.mListener.onSubtitleTrackSelected(track);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SubtitleTrack $$robo$$android_media_SubtitleController$getDefaultTrack() {
        SubtitleTrack bestTrack = null;
        int bestScore = -1;
        Locale selectedLocale = this.mCaptioningManager.getLocale();
        Locale locale = selectedLocale;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        boolean selectForced = !this.mCaptioningManager.isEnabled();
        Vector<SubtitleTrack> vector = this.mTracks;
        synchronized (vector) {
            for (SubtitleTrack track : this.mTracks) {
                MediaFormat format = track.getFormat();
                String language = format.getString("language");
                boolean forced = format.getInteger("is-forced-subtitle", 0) != 0;
                boolean autoselect = format.getInteger("is-autoselect", 1) != 0;
                boolean is_default = format.getInteger("is-default", 0) != 0;
                boolean languageMatches = locale == null || locale.getLanguage().equals("") || locale.getISO3Language().equals(language) || locale.getLanguage().equals(language);
                int score = (forced ? 0 : 8) + (selectedLocale == null && is_default ? 4 : 0) + (autoselect ? 0 : 2) + (languageMatches ? 1 : 0);
                if (selectForced && !forced || (selectedLocale != null || !is_default) && (!languageMatches || !autoselect && !forced && selectedLocale == null) || score <= bestScore) continue;
                bestScore = score;
                bestTrack = track;
            }
        }
        return bestTrack;
    }

    private final void $$robo$$android_media_SubtitleController$selectDefaultTrack() {
        this.processOnAnchor(this.mHandler.obtainMessage(4));
    }

    private final void $$robo$$android_media_SubtitleController$doSelectDefaultTrack() {
        if (this.mTrackIsExplicit) {
            if (!this.mVisibilityIsExplicit) {
                if (this.mCaptioningManager.isEnabled() || this.mSelectedTrack != null && this.mSelectedTrack.getFormat().getInteger("is-forced-subtitle", 0) != 0) {
                    this.show();
                } else if (this.mSelectedTrack != null && !this.mSelectedTrack.isTimedText()) {
                    this.hide();
                }
                this.mVisibilityIsExplicit = false;
            }
            return;
        }
        SubtitleTrack track = this.getDefaultTrack();
        if (track != null) {
            this.selectTrack(track);
            this.mTrackIsExplicit = false;
            if (!this.mVisibilityIsExplicit) {
                this.show();
                this.mVisibilityIsExplicit = false;
            }
        }
    }

    private final void $$robo$$android_media_SubtitleController$reset() {
        this.checkAnchorLooper();
        this.hide();
        this.selectTrack(null);
        this.mTracks.clear();
        this.mTrackIsExplicit = false;
        this.mVisibilityIsExplicit = false;
        this.mCaptioningManager.removeCaptioningChangeListener(this.mCaptioningChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SubtitleTrack $$robo$$android_media_SubtitleController$addTrack(MediaFormat format) {
        Vector<Renderer> vector = this.mRenderers;
        synchronized (vector) {
            for (Renderer renderer : this.mRenderers) {
                SubtitleTrack track;
                if (!renderer.supports(format) || (track = renderer.createTrack(format)) == null) continue;
                Vector<SubtitleTrack> vector2 = this.mTracks;
                synchronized (vector2) {
                    if (this.mTracks.size() == 0) {
                        this.mCaptioningManager.addCaptioningChangeListener(this.mCaptioningChangeListener);
                    }
                    this.mTracks.add(track);
                }
                return track;
            }
        }
        return null;
    }

    private final void $$robo$$android_media_SubtitleController$show() {
        this.processOnAnchor(this.mHandler.obtainMessage(1));
    }

    private final void $$robo$$android_media_SubtitleController$doShow() {
        this.mShowing = true;
        this.mVisibilityIsExplicit = true;
        if (this.mSelectedTrack != null) {
            this.mSelectedTrack.show();
        }
    }

    private final void $$robo$$android_media_SubtitleController$hide() {
        this.processOnAnchor(this.mHandler.obtainMessage(2));
    }

    private final void $$robo$$android_media_SubtitleController$doHide() {
        this.mVisibilityIsExplicit = true;
        if (this.mSelectedTrack != null) {
            this.mSelectedTrack.hide();
        }
        this.mShowing = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_SubtitleController$registerRenderer(Renderer renderer) {
        Vector<Renderer> vector = this.mRenderers;
        synchronized (vector) {
            if (!this.mRenderers.contains(renderer)) {
                this.mRenderers.add(renderer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_media_SubtitleController$hasRendererFor(MediaFormat format) {
        Vector<Renderer> vector = this.mRenderers;
        synchronized (vector) {
            for (Renderer renderer : this.mRenderers) {
                if (!renderer.supports(format)) continue;
                return true;
            }
            return false;
        }
    }

    private final void $$robo$$android_media_SubtitleController$setAnchor(Anchor anchor) {
        if (this.mAnchor == anchor) {
            return;
        }
        if (this.mAnchor != null) {
            this.checkAnchorLooper();
            this.mAnchor.setSubtitleWidget(null);
        }
        this.mAnchor = anchor;
        this.mHandler = null;
        if (this.mAnchor != null) {
            this.mHandler = new Handler(this.mAnchor.getSubtitleLooper(), this.mCallback);
            this.checkAnchorLooper();
            this.mAnchor.setSubtitleWidget(this.getRenderingWidget());
        }
    }

    private final void $$robo$$android_media_SubtitleController$checkAnchorLooper() {
        if (!$assertionsDisabled && this.mHandler == null) {
            throw new AssertionError((Object)"Should have a looper already");
        }
        if (!$assertionsDisabled && Looper.myLooper() != this.mHandler.getLooper()) {
            throw new AssertionError((Object)"Must be called from the anchor's looper");
        }
    }

    private final void $$robo$$android_media_SubtitleController$processOnAnchor(Message m) {
        if (!$assertionsDisabled && this.mHandler == null) {
            throw new AssertionError((Object)"Should have a looper already");
        }
        if (Looper.myLooper() == this.mHandler.getLooper()) {
            this.mHandler.dispatchMessage(m);
        } else {
            this.mHandler.sendMessage(m);
        }
    }

    static void __staticInitializer__() {
        $assertionsDisabled = !SubtitleController.class.desiredAssertionStatus();
    }

    private void __constructor__(Context context, MediaTimeProvider mediaTimeProvider, Listener listener) {
        this.$$robo$$android_media_SubtitleController$__constructor__(context, mediaTimeProvider, listener);
    }

    public SubtitleController(Context context, MediaTimeProvider mediaTimeProvider, Listener listener) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_SubtitleController$__constructor__(android.content.Context android.media.MediaTimeProvider android.media.SubtitleController$Listener ), 0, this, context, mediaTimeProvider, listener);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_media_SubtitleController$finalize(), 0, this);
    }

    public SubtitleTrack[] getTracks() {
        return InvokeDynamicSupport.bootstrap("getTracks", $$robo$$android_media_SubtitleController$getTracks(), 0, this);
    }

    public SubtitleTrack getSelectedTrack() {
        return InvokeDynamicSupport.bootstrap("getSelectedTrack", $$robo$$android_media_SubtitleController$getSelectedTrack(), 0, this);
    }

    private SubtitleTrack.RenderingWidget getRenderingWidget() {
        return InvokeDynamicSupport.bootstrap("getRenderingWidget", $$robo$$android_media_SubtitleController$getRenderingWidget(), 0, this);
    }

    public boolean selectTrack(SubtitleTrack subtitleTrack) {
        return (boolean)InvokeDynamicSupport.bootstrap("selectTrack", $$robo$$android_media_SubtitleController$selectTrack(android.media.SubtitleTrack ), 0, this, subtitleTrack);
    }

    private void doSelectTrack(SubtitleTrack subtitleTrack) {
        InvokeDynamicSupport.bootstrap("doSelectTrack", $$robo$$android_media_SubtitleController$doSelectTrack(android.media.SubtitleTrack ), 0, this, subtitleTrack);
    }

    public SubtitleTrack getDefaultTrack() {
        return InvokeDynamicSupport.bootstrap("getDefaultTrack", $$robo$$android_media_SubtitleController$getDefaultTrack(), 0, this);
    }

    public void selectDefaultTrack() {
        InvokeDynamicSupport.bootstrap("selectDefaultTrack", $$robo$$android_media_SubtitleController$selectDefaultTrack(), 0, this);
    }

    private void doSelectDefaultTrack() {
        InvokeDynamicSupport.bootstrap("doSelectDefaultTrack", $$robo$$android_media_SubtitleController$doSelectDefaultTrack(), 0, this);
    }

    public void reset() {
        InvokeDynamicSupport.bootstrap("reset", $$robo$$android_media_SubtitleController$reset(), 0, this);
    }

    public SubtitleTrack addTrack(MediaFormat mediaFormat) {
        return InvokeDynamicSupport.bootstrap("addTrack", $$robo$$android_media_SubtitleController$addTrack(android.media.MediaFormat ), 0, this, mediaFormat);
    }

    public void show() {
        InvokeDynamicSupport.bootstrap("show", $$robo$$android_media_SubtitleController$show(), 0, this);
    }

    private void doShow() {
        InvokeDynamicSupport.bootstrap("doShow", $$robo$$android_media_SubtitleController$doShow(), 0, this);
    }

    public void hide() {
        InvokeDynamicSupport.bootstrap("hide", $$robo$$android_media_SubtitleController$hide(), 0, this);
    }

    private void doHide() {
        InvokeDynamicSupport.bootstrap("doHide", $$robo$$android_media_SubtitleController$doHide(), 0, this);
    }

    public void registerRenderer(Renderer renderer) {
        InvokeDynamicSupport.bootstrap("registerRenderer", $$robo$$android_media_SubtitleController$registerRenderer(android.media.SubtitleController$Renderer ), 0, this, renderer);
    }

    public boolean hasRendererFor(MediaFormat mediaFormat) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasRendererFor", $$robo$$android_media_SubtitleController$hasRendererFor(android.media.MediaFormat ), 0, this, mediaFormat);
    }

    public void setAnchor(Anchor anchor) {
        InvokeDynamicSupport.bootstrap("setAnchor", $$robo$$android_media_SubtitleController$setAnchor(android.media.SubtitleController$Anchor ), 0, this, anchor);
    }

    private void checkAnchorLooper() {
        InvokeDynamicSupport.bootstrap("checkAnchorLooper", $$robo$$android_media_SubtitleController$checkAnchorLooper(), 0, this);
    }

    private void processOnAnchor(Message message) {
        InvokeDynamicSupport.bootstrap("processOnAnchor", $$robo$$android_media_SubtitleController$processOnAnchor(android.os.Message ), 0, this, message);
    }

    static {
        RobolectricInternals.classInitializing(SubtitleController.class);
    }

    public /* synthetic */ SubtitleController() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SubtitleController)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface Listener
    extends InstrumentedInterface {
        public void onSubtitleTrackSelected(SubtitleTrack var1);
    }

    public static interface Anchor
    extends InstrumentedInterface {
        public void setSubtitleWidget(SubtitleTrack.RenderingWidget var1);

        public Looper getSubtitleLooper();
    }

    public static abstract class Renderer
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_media_SubtitleController_Renderer$__constructor__() {
        }

        public abstract boolean supports(MediaFormat var1);

        public abstract SubtitleTrack createTrack(MediaFormat var1);

        private void __constructor__() {
            this.$$robo$$android_media_SubtitleController_Renderer$__constructor__();
        }

        public Renderer() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_SubtitleController_Renderer$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Renderer)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

