/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.SubtitleTrack;
import android.media.TextTrackCueSpan;
import android.media.TextTrackRegion;
import android.media.WebVttParser;
import java.util.Arrays;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class TextTrackCue
extends SubtitleTrack.Cue
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static int WRITING_DIRECTION_HORIZONTAL = 100;
    static int WRITING_DIRECTION_VERTICAL_RL = 101;
    static int WRITING_DIRECTION_VERTICAL_LR = 102;
    static int ALIGNMENT_MIDDLE = 200;
    static int ALIGNMENT_START = 201;
    static int ALIGNMENT_END = 202;
    static int ALIGNMENT_LEFT = 203;
    static int ALIGNMENT_RIGHT = 204;
    private static String TAG = "TTCue";
    String mId;
    boolean mPauseOnExit;
    int mWritingDirection;
    String mRegionId;
    boolean mSnapToLines;
    Integer mLinePosition;
    boolean mAutoLinePosition;
    int mTextPosition;
    int mSize;
    int mAlignment;
    String[] mStrings;
    TextTrackCueSpan[][] mLines;
    TextTrackRegion mRegion;

    private void $$robo$$android_media_TextTrackCue$__constructor__() {
        this.mId = "";
        this.mPauseOnExit = false;
        this.mWritingDirection = 100;
        this.mRegionId = "";
        this.mSnapToLines = true;
        this.mLinePosition = null;
        this.mTextPosition = 50;
        this.mSize = 100;
        this.mAlignment = 200;
        this.mLines = null;
        this.mRegion = null;
    }

    private final boolean $$robo$$android_media_TextTrackCue$equals(Object o) {
        if (!(o instanceof TextTrackCue)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        try {
            boolean res;
            TextTrackCue cue = (TextTrackCue)o;
            boolean bl = res = this.mId.equals(cue.mId) && this.mPauseOnExit == cue.mPauseOnExit && this.mWritingDirection == cue.mWritingDirection && this.mRegionId.equals(cue.mRegionId) && this.mSnapToLines == cue.mSnapToLines && this.mAutoLinePosition == cue.mAutoLinePosition && (this.mAutoLinePosition || this.mLinePosition == cue.mLinePosition) && this.mTextPosition == cue.mTextPosition && this.mSize == cue.mSize && this.mAlignment == cue.mAlignment && this.mLines.length == cue.mLines.length;
            if (res) {
                for (int line = 0; line < this.mLines.length; ++line) {
                    if (Arrays.equals(this.mLines[line], cue.mLines[line])) continue;
                    return false;
                }
            }
            return res;
        }
        catch (IncompatibleClassChangeError e) {
            return false;
        }
    }

    private final StringBuilder $$robo$$android_media_TextTrackCue$appendStringsToBuilder(StringBuilder builder) {
        if (this.mStrings == null) {
            builder.append("null");
        } else {
            builder.append("[");
            boolean first = true;
            for (String s : this.mStrings) {
                if (!first) {
                    builder.append(", ");
                }
                if (s == null) {
                    builder.append("null");
                } else {
                    builder.append("\"");
                    builder.append(s);
                    builder.append("\"");
                }
                first = false;
            }
            builder.append("]");
        }
        return builder;
    }

    private final StringBuilder $$robo$$android_media_TextTrackCue$appendLinesToBuilder(StringBuilder builder) {
        if (this.mLines == null) {
            builder.append("null");
        } else {
            builder.append("[");
            boolean first = true;
            for (TextTrackCueSpan[] spans : this.mLines) {
                if (!first) {
                    builder.append(", ");
                }
                if (spans == null) {
                    builder.append("null");
                } else {
                    builder.append("\"");
                    boolean innerFirst = true;
                    long lastTimestamp = -1L;
                    for (TextTrackCueSpan span : spans) {
                        if (!innerFirst) {
                            builder.append(" ");
                        }
                        if (span.mTimestampMs != lastTimestamp) {
                            builder.append("<").append(WebVttParser.timeToString(span.mTimestampMs)).append(">");
                            lastTimestamp = span.mTimestampMs;
                        }
                        builder.append(span.mText);
                        innerFirst = false;
                    }
                    builder.append("\"");
                }
                first = false;
            }
            builder.append("]");
        }
        return builder;
    }

    private final String $$robo$$android_media_TextTrackCue$toString() {
        StringBuilder res = new StringBuilder();
        res.append(WebVttParser.timeToString(this.mStartTimeMs)).append(" --> ").append(WebVttParser.timeToString(this.mEndTimeMs)).append(" {id:\"").append(this.mId).append("\", pauseOnExit:").append(this.mPauseOnExit).append(", direction:").append(this.mWritingDirection == 100 ? "horizontal" : (this.mWritingDirection == 102 ? "vertical_lr" : (this.mWritingDirection == 101 ? "vertical_rl" : "INVALID"))).append(", regionId:\"").append(this.mRegionId).append("\", snapToLines:").append(this.mSnapToLines).append(", linePosition:").append(this.mAutoLinePosition ? "auto" : this.mLinePosition).append(", textPosition:").append(this.mTextPosition).append(", size:").append(this.mSize).append(", alignment:").append(this.mAlignment == 202 ? "end" : (this.mAlignment == 203 ? "left" : (this.mAlignment == 200 ? "middle" : (this.mAlignment == 204 ? "right" : (this.mAlignment == 201 ? "start" : "INVALID"))))).append(", text:");
        this.appendStringsToBuilder(res).append("}");
        return res.toString();
    }

    private final int $$robo$$android_media_TextTrackCue$hashCode() {
        return this.toString().hashCode();
    }

    private final void $$robo$$android_media_TextTrackCue$onTime(long timeMs) {
        TextTrackCueSpan[][] arr$ = this.mLines;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            TextTrackCueSpan[] line;
            for (TextTrackCueSpan span : line = arr$[i$]) {
                span.mEnabled = timeMs >= span.mTimestampMs;
            }
        }
    }

    private void __constructor__() {
        this.$$robo$$android_media_TextTrackCue$__constructor__();
    }

    TextTrackCue() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_TextTrackCue$__constructor__(), 0, this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_media_TextTrackCue$equals(java.lang.Object ), 0, this, object);
    }

    public StringBuilder appendStringsToBuilder(StringBuilder stringBuilder) {
        return InvokeDynamicSupport.bootstrap("appendStringsToBuilder", $$robo$$android_media_TextTrackCue$appendStringsToBuilder(java.lang.StringBuilder ), 0, this, stringBuilder);
    }

    public StringBuilder appendLinesToBuilder(StringBuilder stringBuilder) {
        return InvokeDynamicSupport.bootstrap("appendLinesToBuilder", $$robo$$android_media_TextTrackCue$appendLinesToBuilder(java.lang.StringBuilder ), 0, this, stringBuilder);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_media_TextTrackCue$toString(), 0, this);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_media_TextTrackCue$hashCode(), 0, this);
    }

    @Override
    public void onTime(long l) {
        InvokeDynamicSupport.bootstrap("onTime", $$robo$$android_media_TextTrackCue$onTime(long ), 0, this, l);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TextTrackCue)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

