/*
 * Decompiled with CFR 0.152.
 */
package android.media.audiopolicy;

import android.media.AudioAttributes;
import android.media.AudioFormat;
import android.media.audiopolicy.AudioMix;
import android.media.audiopolicy.AudioMixingRule;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class AudioPolicyConfig
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "AudioPolicyConfig";
    ArrayList<AudioMix> mMixes;
    public static Parcelable.Creator<AudioPolicyConfig> CREATOR;

    private void $$robo$$android_media_audiopolicy_AudioPolicyConfig$__constructor__(ArrayList<AudioMix> mixes) {
        this.mMixes = mixes;
    }

    private final void $$robo$$android_media_audiopolicy_AudioPolicyConfig$addMix(AudioMix mix) throws IllegalArgumentException {
        if (mix == null) {
            throw new IllegalArgumentException("Illegal null AudioMix argument");
        }
        this.mMixes.add(mix);
    }

    private final int $$robo$$android_media_audiopolicy_AudioPolicyConfig$describeContents() {
        return 0;
    }

    private final void $$robo$$android_media_audiopolicy_AudioPolicyConfig$writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mMixes.size());
        for (AudioMix mix : this.mMixes) {
            dest.writeInt(mix.getRouteFlags());
            dest.writeInt(mix.getFormat().getSampleRate());
            dest.writeInt(mix.getFormat().getEncoding());
            dest.writeInt(mix.getFormat().getChannelMask());
            ArrayList<AudioMixingRule.AttributeMatchCriterion> criteria = mix.getRule().getCriteria();
            dest.writeInt(criteria.size());
            for (AudioMixingRule.AttributeMatchCriterion criterion : criteria) {
                dest.writeInt(criterion.mRule);
                dest.writeInt(criterion.mAttr.getUsage());
            }
        }
    }

    private void $$robo$$android_media_audiopolicy_AudioPolicyConfig$__constructor__(Parcel in) {
        this.mMixes = new ArrayList();
        int nbMixes = in.readInt();
        for (int i = 0; i < nbMixes; ++i) {
            AudioMix.Builder mixBuilder = new AudioMix.Builder();
            int routeFlags = in.readInt();
            mixBuilder.setRouteFlags(routeFlags);
            int sampleRate = in.readInt();
            int encoding = in.readInt();
            int channelMask = in.readInt();
            AudioFormat format = new AudioFormat.Builder().setSampleRate(sampleRate).setChannelMask(channelMask).setEncoding(encoding).build();
            mixBuilder.setFormat(format);
            int nbRules = in.readInt();
            AudioMixingRule.Builder ruleBuilder = new AudioMixingRule.Builder();
            for (int j = 0; j < nbRules; ++j) {
                int matchRule = in.readInt();
                if (matchRule == 2 || matchRule == 1) {
                    int usage = in.readInt();
                    AudioAttributes attr2 = new AudioAttributes.Builder().setUsage(usage).build();
                    ruleBuilder.addRule(attr2, matchRule);
                    continue;
                }
                Log.w("AudioPolicyConfig", "Encountered unsupported rule, skipping");
                in.readInt();
            }
            mixBuilder.setMixingRule(ruleBuilder.build());
            this.mMixes.add(mixBuilder.build());
        }
    }

    private final String $$robo$$android_media_audiopolicy_AudioPolicyConfig$toString() {
        String textDump = new String("android.media.audiopolicy.AudioPolicyConfig:\n");
        textDump = textDump + this.mMixes.size() + " AudioMix:\n";
        for (AudioMix mix : this.mMixes) {
            textDump = textDump + "* route flags=0x" + Integer.toHexString(mix.getRouteFlags()) + "\n";
            textDump = textDump + "  rate=" + mix.getFormat().getSampleRate() + "Hz\n";
            textDump = textDump + "  encoding=" + mix.getFormat().getEncoding() + "\n";
            textDump = textDump + "  channels=0x";
            textDump = textDump + Integer.toHexString(mix.getFormat().getChannelMask()).toUpperCase() + "\n";
            ArrayList<AudioMixingRule.AttributeMatchCriterion> criteria = mix.getRule().getCriteria();
            for (AudioMixingRule.AttributeMatchCriterion criterion : criteria) {
                switch (criterion.mRule) {
                    case 2: {
                        textDump = textDump + "  exclude usage ";
                        textDump = textDump + criterion.mAttr.usageToString();
                        break;
                    }
                    case 1: {
                        textDump = textDump + "  match usage ";
                        textDump = textDump + criterion.mAttr.usageToString();
                        break;
                    }
                    default: {
                        textDump = textDump + "invalid rule!";
                    }
                }
                textDump = textDump + "\n";
            }
        }
        return textDump;
    }

    private /* synthetic */ void $$robo$$android_media_audiopolicy_AudioPolicyConfig$__constructor__(Parcel x0, 1 x1) {
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<AudioPolicyConfig>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_media_audiopolicy_AudioPolicyConfig_1$__constructor__() {
            }

            private final AudioPolicyConfig $$robo$$android_media_audiopolicy_AudioPolicyConfig_1$createFromParcel(Parcel p) {
                return new AudioPolicyConfig(p);
            }

            private final AudioPolicyConfig[] $$robo$$android_media_audiopolicy_AudioPolicyConfig_1$newArray(int size) {
                return new AudioPolicyConfig[size];
            }

            private void __constructor__() {
                this.$$robo$$android_media_audiopolicy_AudioPolicyConfig_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_audiopolicy_AudioPolicyConfig_1$__constructor__(), 0, this);
            }

            @Override
            public AudioPolicyConfig createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_media_audiopolicy_AudioPolicyConfig_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public AudioPolicyConfig[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_media_audiopolicy_AudioPolicyConfig_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(ArrayList<AudioMix> arrayList) {
        this.$$robo$$android_media_audiopolicy_AudioPolicyConfig$__constructor__(arrayList);
    }

    AudioPolicyConfig(ArrayList<AudioMix> arrayList) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_audiopolicy_AudioPolicyConfig$__constructor__(java.util.ArrayList<android.media.audiopolicy.AudioMix> ), 0, this, arrayList);
    }

    public void addMix(AudioMix audioMix) throws IllegalArgumentException {
        InvokeDynamicSupport.bootstrap("addMix", $$robo$$android_media_audiopolicy_AudioPolicyConfig$addMix(android.media.audiopolicy.AudioMix ), 0, this, audioMix);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_media_audiopolicy_AudioPolicyConfig$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_media_audiopolicy_AudioPolicyConfig$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_media_audiopolicy_AudioPolicyConfig$__constructor__(parcel);
    }

    private AudioPolicyConfig(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_audiopolicy_AudioPolicyConfig$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_media_audiopolicy_AudioPolicyConfig$toString(), 0, this);
    }

    private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
        this.$$robo$$android_media_audiopolicy_AudioPolicyConfig$__constructor__(parcel, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(AudioPolicyConfig.class);
    }

    public /* synthetic */ AudioPolicyConfig() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AudioPolicyConfig)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

