/*
 * Decompiled with CFR 0.152.
 */
package android.media.browse;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ParceledListSlice;
import android.media.MediaDescription;
import android.media.session.MediaSession;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.service.media.IMediaBrowserService;
import android.service.media.IMediaBrowserServiceCallbacks;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class MediaBrowser
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "MediaBrowser";
    private static boolean DBG = false;
    private static int CONNECT_STATE_DISCONNECTED = 0;
    private static int CONNECT_STATE_CONNECTING = 1;
    private static int CONNECT_STATE_CONNECTED = 2;
    private static int CONNECT_STATE_SUSPENDED = 3;
    private Context mContext;
    private ComponentName mServiceComponent;
    private ConnectionCallback mCallback;
    private Bundle mRootHints;
    private Handler mHandler;
    private ArrayMap<String, Subscription> mSubscriptions;
    private int mState;
    private MediaServiceConnection mServiceConnection;
    private IMediaBrowserService mServiceBinder;
    private IMediaBrowserServiceCallbacks mServiceCallbacks;
    private String mRootId;
    private MediaSession.Token mMediaSessionToken;
    private Bundle mExtras;

    private void $$robo$$android_media_browse_MediaBrowser$__constructor__(Context context, ComponentName serviceComponent, ConnectionCallback callback, Bundle rootHints) {
        this.mHandler = new Handler();
        this.mSubscriptions = new ArrayMap();
        this.mState = 0;
        if (context == null) {
            throw new IllegalArgumentException("context must not be null");
        }
        if (serviceComponent == null) {
            throw new IllegalArgumentException("service component must not be null");
        }
        if (callback == null) {
            throw new IllegalArgumentException("connection callback must not be null");
        }
        this.mContext = context;
        this.mServiceComponent = serviceComponent;
        this.mCallback = callback;
        this.mRootHints = rootHints;
    }

    private final void $$robo$$android_media_browse_MediaBrowser$connect() {
        if (this.mState != 0) {
            throw new IllegalStateException("connect() called while not disconnected (state=" + MediaBrowser.getStateLabel(this.mState) + ")");
        }
        if (this.mServiceBinder != null) {
            throw new RuntimeException("mServiceBinder should be null. Instead it is " + this.mServiceBinder);
        }
        if (this.mServiceCallbacks != null) {
            throw new RuntimeException("mServiceCallbacks should be null. Instead it is " + this.mServiceCallbacks);
        }
        this.mState = 1;
        Intent intent = new Intent("android.media.browse.MediaBrowserService");
        intent.setComponent(this.mServiceComponent);
        MediaServiceConnection thisConnection = this.mServiceConnection = new MediaServiceConnection(this);
        boolean bound = false;
        try {
            bound = this.mContext.bindService(intent, this.mServiceConnection, 1);
        }
        catch (Exception ex) {
            Log.e("MediaBrowser", "Failed binding to service " + this.mServiceComponent);
        }
        if (!bound) {
            this.mHandler.post(new Runnable(this, thisConnection){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ ServiceConnection val$thisConnection;
                /* synthetic */ MediaBrowser this$0;

                private void $$robo$$android_media_browse_MediaBrowser_1$__constructor__(MediaBrowser mediaBrowser, ServiceConnection serviceConnection) {
                }

                private final void $$robo$$android_media_browse_MediaBrowser_1$run() {
                    if (this.val$thisConnection == this.this$0.mServiceConnection) {
                        this.this$0.forceCloseConnection();
                        this.this$0.mCallback.onConnectionFailed();
                    }
                }

                private void __constructor__(MediaBrowser mediaBrowser, ServiceConnection serviceConnection) {
                    this.$$robo$$android_media_browse_MediaBrowser_1$__constructor__(mediaBrowser, serviceConnection);
                }
                {
                    this.this$0 = mediaBrowser;
                    this.val$thisConnection = serviceConnection;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_browse_MediaBrowser_1$__constructor__(android.media.browse.MediaBrowser android.content.ServiceConnection ), 0, this, mediaBrowser, serviceConnection);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_browse_MediaBrowser_1$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }
    }

    private final void $$robo$$android_media_browse_MediaBrowser$disconnect() {
        if (this.mServiceCallbacks != null) {
            try {
                this.mServiceBinder.disconnect(this.mServiceCallbacks);
            }
            catch (RemoteException ex) {
                Log.w("MediaBrowser", "RemoteException during connect for " + this.mServiceComponent);
            }
        }
        this.forceCloseConnection();
    }

    private final void $$robo$$android_media_browse_MediaBrowser$forceCloseConnection() {
        if (this.mServiceConnection != null) {
            this.mContext.unbindService(this.mServiceConnection);
        }
        this.mState = 0;
        this.mServiceConnection = null;
        this.mServiceBinder = null;
        this.mServiceCallbacks = null;
        this.mRootId = null;
        this.mMediaSessionToken = null;
    }

    private final boolean $$robo$$android_media_browse_MediaBrowser$isConnected() {
        return this.mState == 2;
    }

    private final ComponentName $$robo$$android_media_browse_MediaBrowser$getServiceComponent() {
        if (!this.isConnected()) {
            throw new IllegalStateException("getServiceComponent() called while not connected (state=" + this.mState + ")");
        }
        return this.mServiceComponent;
    }

    private final String $$robo$$android_media_browse_MediaBrowser$getRoot() {
        if (!this.isConnected()) {
            throw new IllegalStateException("getSessionToken() called while not connected (state=" + MediaBrowser.getStateLabel(this.mState) + ")");
        }
        return this.mRootId;
    }

    private final Bundle $$robo$$android_media_browse_MediaBrowser$getExtras() {
        if (!this.isConnected()) {
            throw new IllegalStateException("getExtras() called while not connected (state=" + MediaBrowser.getStateLabel(this.mState) + ")");
        }
        return this.mExtras;
    }

    private final MediaSession.Token $$robo$$android_media_browse_MediaBrowser$getSessionToken() {
        if (!this.isConnected()) {
            throw new IllegalStateException("getSessionToken() called while not connected (state=" + this.mState + ")");
        }
        return this.mMediaSessionToken;
    }

    private final void $$robo$$android_media_browse_MediaBrowser$subscribe(String parentId, SubscriptionCallback callback) {
        boolean newSubscription;
        if (parentId == null) {
            throw new IllegalArgumentException("parentId is null");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback is null");
        }
        Subscription sub = this.mSubscriptions.get(parentId);
        boolean bl = newSubscription = sub == null;
        if (newSubscription) {
            sub = new Subscription(parentId);
            this.mSubscriptions.put(parentId, sub);
        }
        sub.callback = callback;
        if (this.mState == 2 && newSubscription) {
            try {
                this.mServiceBinder.addSubscription(parentId, this.mServiceCallbacks);
            }
            catch (RemoteException ex) {
                Log.d("MediaBrowser", "addSubscription failed with RemoteException parentId=" + parentId);
            }
        }
    }

    private final void $$robo$$android_media_browse_MediaBrowser$unsubscribe(String parentId) {
        if (parentId == null) {
            throw new IllegalArgumentException("parentId is null");
        }
        Subscription sub = this.mSubscriptions.remove(parentId);
        if (this.mState == 2 && sub != null) {
            try {
                this.mServiceBinder.removeSubscription(parentId, this.mServiceCallbacks);
            }
            catch (RemoteException ex) {
                Log.d("MediaBrowser", "removeSubscription failed with RemoteException parentId=" + parentId);
            }
        }
    }

    private static final String $$robo$$android_media_browse_MediaBrowser$getStateLabel(int state) {
        switch (state) {
            case 0: {
                return "CONNECT_STATE_DISCONNECTED";
            }
            case 1: {
                return "CONNECT_STATE_CONNECTING";
            }
            case 2: {
                return "CONNECT_STATE_CONNECTED";
            }
            case 3: {
                return "CONNECT_STATE_SUSPENDED";
            }
        }
        return "UNKNOWN/" + state;
    }

    private final void $$robo$$android_media_browse_MediaBrowser$onServiceConnected(IMediaBrowserServiceCallbacks callback, String root, MediaSession.Token session, Bundle extra) {
        this.mHandler.post(new Runnable(this, callback, root, session, extra){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ IMediaBrowserServiceCallbacks val$callback;
            /* synthetic */ String val$root;
            /* synthetic */ MediaSession.Token val$session;
            /* synthetic */ Bundle val$extra;
            /* synthetic */ MediaBrowser this$0;

            private void $$robo$$android_media_browse_MediaBrowser_2$__constructor__(MediaBrowser mediaBrowser, IMediaBrowserServiceCallbacks iMediaBrowserServiceCallbacks, String string2, MediaSession.Token token, Bundle bundle) {
            }

            private final void $$robo$$android_media_browse_MediaBrowser_2$run() {
                if (!this.this$0.isCurrent(this.val$callback, "onConnect")) {
                    return;
                }
                if (this.this$0.mState != 1) {
                    Log.w("MediaBrowser", "onConnect from service while mState=" + MediaBrowser.getStateLabel(this.this$0.mState) + "... ignoring");
                    return;
                }
                this.this$0.mRootId = this.val$root;
                this.this$0.mMediaSessionToken = this.val$session;
                this.this$0.mExtras = this.val$extra;
                this.this$0.mState = 2;
                this.this$0.mCallback.onConnected();
                for (String id2 : this.this$0.mSubscriptions.keySet()) {
                    try {
                        this.this$0.mServiceBinder.addSubscription(id2, this.this$0.mServiceCallbacks);
                    }
                    catch (RemoteException ex) {
                        Log.d("MediaBrowser", "addSubscription failed with RemoteException parentId=" + id2);
                    }
                }
            }

            private void __constructor__(MediaBrowser mediaBrowser, IMediaBrowserServiceCallbacks iMediaBrowserServiceCallbacks, String string2, MediaSession.Token token, Bundle bundle) {
                this.$$robo$$android_media_browse_MediaBrowser_2$__constructor__(mediaBrowser, iMediaBrowserServiceCallbacks, string2, token, bundle);
            }
            {
                this.this$0 = mediaBrowser;
                this.val$callback = iMediaBrowserServiceCallbacks;
                this.val$root = string2;
                this.val$session = token;
                this.val$extra = bundle;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_browse_MediaBrowser_2$__constructor__(android.media.browse.MediaBrowser android.service.media.IMediaBrowserServiceCallbacks java.lang.String android.media.session.MediaSession$Token android.os.Bundle ), 0, this, mediaBrowser, iMediaBrowserServiceCallbacks, string2, token, bundle);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_browse_MediaBrowser_2$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final void $$robo$$android_media_browse_MediaBrowser$onConnectionFailed(IMediaBrowserServiceCallbacks callback) {
        this.mHandler.post(new Runnable(this, callback){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ IMediaBrowserServiceCallbacks val$callback;
            /* synthetic */ MediaBrowser this$0;

            private void $$robo$$android_media_browse_MediaBrowser_3$__constructor__(MediaBrowser mediaBrowser, IMediaBrowserServiceCallbacks iMediaBrowserServiceCallbacks) {
            }

            private final void $$robo$$android_media_browse_MediaBrowser_3$run() {
                Log.e("MediaBrowser", "onConnectFailed for " + this.this$0.mServiceComponent);
                if (!this.this$0.isCurrent(this.val$callback, "onConnectFailed")) {
                    return;
                }
                if (this.this$0.mState != 1) {
                    Log.w("MediaBrowser", "onConnect from service while mState=" + MediaBrowser.getStateLabel(this.this$0.mState) + "... ignoring");
                    return;
                }
                this.this$0.forceCloseConnection();
                this.this$0.mCallback.onConnectionFailed();
            }

            private void __constructor__(MediaBrowser mediaBrowser, IMediaBrowserServiceCallbacks iMediaBrowserServiceCallbacks) {
                this.$$robo$$android_media_browse_MediaBrowser_3$__constructor__(mediaBrowser, iMediaBrowserServiceCallbacks);
            }
            {
                this.this$0 = mediaBrowser;
                this.val$callback = iMediaBrowserServiceCallbacks;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_browse_MediaBrowser_3$__constructor__(android.media.browse.MediaBrowser android.service.media.IMediaBrowserServiceCallbacks ), 0, this, mediaBrowser, iMediaBrowserServiceCallbacks);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_browse_MediaBrowser_3$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final void $$robo$$android_media_browse_MediaBrowser$onLoadChildren(IMediaBrowserServiceCallbacks callback, String parentId, ParceledListSlice list) {
        this.mHandler.post(new Runnable(this, callback, list, parentId){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ IMediaBrowserServiceCallbacks val$callback;
            /* synthetic */ ParceledListSlice val$list;
            /* synthetic */ String val$parentId;
            /* synthetic */ MediaBrowser this$0;

            private void $$robo$$android_media_browse_MediaBrowser_4$__constructor__(MediaBrowser mediaBrowser, IMediaBrowserServiceCallbacks iMediaBrowserServiceCallbacks, ParceledListSlice parceledListSlice, String string2) {
            }

            private final void $$robo$$android_media_browse_MediaBrowser_4$run() {
                Subscription subscription;
                if (!this.this$0.isCurrent(this.val$callback, "onLoadChildren")) {
                    return;
                }
                List<MediaItem> data = this.val$list.getList();
                if (data == null) {
                    data = Collections.emptyList();
                }
                if ((subscription = (Subscription)this.this$0.mSubscriptions.get(this.val$parentId)) == null) {
                    return;
                }
                subscription.callback.onChildrenLoaded(this.val$parentId, data);
            }

            private void __constructor__(MediaBrowser mediaBrowser, IMediaBrowserServiceCallbacks iMediaBrowserServiceCallbacks, ParceledListSlice parceledListSlice, String string2) {
                this.$$robo$$android_media_browse_MediaBrowser_4$__constructor__(mediaBrowser, iMediaBrowserServiceCallbacks, parceledListSlice, string2);
            }
            {
                this.this$0 = mediaBrowser;
                this.val$callback = iMediaBrowserServiceCallbacks;
                this.val$list = parceledListSlice;
                this.val$parentId = string2;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_browse_MediaBrowser_4$__constructor__(android.media.browse.MediaBrowser android.service.media.IMediaBrowserServiceCallbacks android.content.pm.ParceledListSlice java.lang.String ), 0, this, mediaBrowser, iMediaBrowserServiceCallbacks, parceledListSlice, string2);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_browse_MediaBrowser_4$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final boolean $$robo$$android_media_browse_MediaBrowser$isCurrent(IMediaBrowserServiceCallbacks callback, String funcName) {
        if (this.mServiceCallbacks != callback) {
            if (this.mState != 0) {
                Log.i("MediaBrowser", funcName + " for " + this.mServiceComponent + " with mServiceConnection=" + this.mServiceCallbacks + " this=" + this);
            }
            return false;
        }
        return true;
    }

    private final ServiceCallbacks $$robo$$android_media_browse_MediaBrowser$getNewServiceCallbacks() {
        return new ServiceCallbacks(this);
    }

    private final void $$robo$$android_media_browse_MediaBrowser$dump() {
        Log.d("MediaBrowser", "MediaBrowser...");
        Log.d("MediaBrowser", "  mServiceComponent=" + this.mServiceComponent);
        Log.d("MediaBrowser", "  mCallback=" + this.mCallback);
        Log.d("MediaBrowser", "  mRootHints=" + this.mRootHints);
        Log.d("MediaBrowser", "  mState=" + MediaBrowser.getStateLabel(this.mState));
        Log.d("MediaBrowser", "  mServiceConnection=" + this.mServiceConnection);
        Log.d("MediaBrowser", "  mServiceBinder=" + this.mServiceBinder);
        Log.d("MediaBrowser", "  mServiceCallbacks=" + this.mServiceCallbacks);
        Log.d("MediaBrowser", "  mRootId=" + this.mRootId);
        Log.d("MediaBrowser", "  mMediaSessionToken=" + this.mMediaSessionToken);
    }

    private void __constructor__(Context context, ComponentName componentName, ConnectionCallback connectionCallback, Bundle bundle) {
        this.$$robo$$android_media_browse_MediaBrowser$__constructor__(context, componentName, connectionCallback, bundle);
    }

    public MediaBrowser(Context context, ComponentName componentName, ConnectionCallback connectionCallback, Bundle bundle) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_browse_MediaBrowser$__constructor__(android.content.Context android.content.ComponentName android.media.browse.MediaBrowser$ConnectionCallback android.os.Bundle ), 0, this, context, componentName, connectionCallback, bundle);
    }

    public void connect() {
        InvokeDynamicSupport.bootstrap("connect", $$robo$$android_media_browse_MediaBrowser$connect(), 0, this);
    }

    public void disconnect() {
        InvokeDynamicSupport.bootstrap("disconnect", $$robo$$android_media_browse_MediaBrowser$disconnect(), 0, this);
    }

    private void forceCloseConnection() {
        InvokeDynamicSupport.bootstrap("forceCloseConnection", $$robo$$android_media_browse_MediaBrowser$forceCloseConnection(), 0, this);
    }

    public boolean isConnected() {
        return (boolean)InvokeDynamicSupport.bootstrap("isConnected", $$robo$$android_media_browse_MediaBrowser$isConnected(), 0, this);
    }

    public ComponentName getServiceComponent() {
        return InvokeDynamicSupport.bootstrap("getServiceComponent", $$robo$$android_media_browse_MediaBrowser$getServiceComponent(), 0, this);
    }

    public String getRoot() {
        return InvokeDynamicSupport.bootstrap("getRoot", $$robo$$android_media_browse_MediaBrowser$getRoot(), 0, this);
    }

    public Bundle getExtras() {
        return InvokeDynamicSupport.bootstrap("getExtras", $$robo$$android_media_browse_MediaBrowser$getExtras(), 0, this);
    }

    public MediaSession.Token getSessionToken() {
        return InvokeDynamicSupport.bootstrap("getSessionToken", $$robo$$android_media_browse_MediaBrowser$getSessionToken(), 0, this);
    }

    public void subscribe(String string2, SubscriptionCallback subscriptionCallback) {
        InvokeDynamicSupport.bootstrap("subscribe", $$robo$$android_media_browse_MediaBrowser$subscribe(java.lang.String android.media.browse.MediaBrowser$SubscriptionCallback ), 0, this, string2, subscriptionCallback);
    }

    public void unsubscribe(String string2) {
        InvokeDynamicSupport.bootstrap("unsubscribe", $$robo$$android_media_browse_MediaBrowser$unsubscribe(java.lang.String ), 0, this, string2);
    }

    private static String getStateLabel(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getStateLabel", $$robo$$android_media_browse_MediaBrowser$getStateLabel(int ), 0, (int)n);
    }

    private void onServiceConnected(IMediaBrowserServiceCallbacks iMediaBrowserServiceCallbacks, String string2, MediaSession.Token token, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("onServiceConnected", $$robo$$android_media_browse_MediaBrowser$onServiceConnected(android.service.media.IMediaBrowserServiceCallbacks java.lang.String android.media.session.MediaSession$Token android.os.Bundle ), 0, this, iMediaBrowserServiceCallbacks, string2, token, bundle);
    }

    private void onConnectionFailed(IMediaBrowserServiceCallbacks iMediaBrowserServiceCallbacks) {
        InvokeDynamicSupport.bootstrap("onConnectionFailed", $$robo$$android_media_browse_MediaBrowser$onConnectionFailed(android.service.media.IMediaBrowserServiceCallbacks ), 0, this, iMediaBrowserServiceCallbacks);
    }

    private void onLoadChildren(IMediaBrowserServiceCallbacks iMediaBrowserServiceCallbacks, String string2, ParceledListSlice parceledListSlice) {
        InvokeDynamicSupport.bootstrap("onLoadChildren", $$robo$$android_media_browse_MediaBrowser$onLoadChildren(android.service.media.IMediaBrowserServiceCallbacks java.lang.String android.content.pm.ParceledListSlice ), 0, this, iMediaBrowserServiceCallbacks, string2, parceledListSlice);
    }

    private boolean isCurrent(IMediaBrowserServiceCallbacks iMediaBrowserServiceCallbacks, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isCurrent", $$robo$$android_media_browse_MediaBrowser$isCurrent(android.service.media.IMediaBrowserServiceCallbacks java.lang.String ), 0, this, iMediaBrowserServiceCallbacks, string2);
    }

    private ServiceCallbacks getNewServiceCallbacks() {
        return InvokeDynamicSupport.bootstrap("getNewServiceCallbacks", $$robo$$android_media_browse_MediaBrowser$getNewServiceCallbacks(), 0, this);
    }

    void dump() {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_media_browse_MediaBrowser$dump(), 0, this);
    }

    public /* synthetic */ MediaBrowser() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MediaBrowser)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class Subscription
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        String id;
        SubscriptionCallback callback;

        private void $$robo$$android_media_browse_MediaBrowser_Subscription$__constructor__(String id2) {
            this.id = id2;
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_media_browse_MediaBrowser_Subscription$__constructor__(string2);
        }

        Subscription(String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_browse_MediaBrowser_Subscription$__constructor__(java.lang.String ), 0, this, string2);
        }

        public /* synthetic */ Subscription() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Subscription)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class ServiceCallbacks
    extends IMediaBrowserServiceCallbacks.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private WeakReference<MediaBrowser> mMediaBrowser;

        private void $$robo$$android_media_browse_MediaBrowser_ServiceCallbacks$__constructor__(MediaBrowser mediaBrowser) {
            this.mMediaBrowser = new WeakReference<MediaBrowser>(mediaBrowser);
        }

        private final void $$robo$$android_media_browse_MediaBrowser_ServiceCallbacks$onConnect(String root, MediaSession.Token session, Bundle extras) {
            MediaBrowser mediaBrowser = (MediaBrowser)this.mMediaBrowser.get();
            if (mediaBrowser != null) {
                mediaBrowser.onServiceConnected(this, root, session, extras);
            }
        }

        private final void $$robo$$android_media_browse_MediaBrowser_ServiceCallbacks$onConnectFailed() {
            MediaBrowser mediaBrowser = (MediaBrowser)this.mMediaBrowser.get();
            if (mediaBrowser != null) {
                mediaBrowser.onConnectionFailed(this);
            }
        }

        private final void $$robo$$android_media_browse_MediaBrowser_ServiceCallbacks$onLoadChildren(String parentId, ParceledListSlice list) {
            MediaBrowser mediaBrowser = (MediaBrowser)this.mMediaBrowser.get();
            if (mediaBrowser != null) {
                mediaBrowser.onLoadChildren(this, parentId, list);
            }
        }

        private void __constructor__(MediaBrowser mediaBrowser) {
            this.$$robo$$android_media_browse_MediaBrowser_ServiceCallbacks$__constructor__(mediaBrowser);
        }

        public ServiceCallbacks(MediaBrowser mediaBrowser) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_browse_MediaBrowser_ServiceCallbacks$__constructor__(android.media.browse.MediaBrowser ), 0, this, mediaBrowser);
        }

        @Override
        public void onConnect(String string2, MediaSession.Token token, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onConnect", $$robo$$android_media_browse_MediaBrowser_ServiceCallbacks$onConnect(java.lang.String android.media.session.MediaSession$Token android.os.Bundle ), 0, this, string2, token, bundle);
        }

        @Override
        public void onConnectFailed() {
            InvokeDynamicSupport.bootstrap("onConnectFailed", $$robo$$android_media_browse_MediaBrowser_ServiceCallbacks$onConnectFailed(), 0, this);
        }

        @Override
        public void onLoadChildren(String string2, ParceledListSlice parceledListSlice) {
            InvokeDynamicSupport.bootstrap("onLoadChildren", $$robo$$android_media_browse_MediaBrowser_ServiceCallbacks$onLoadChildren(java.lang.String android.content.pm.ParceledListSlice ), 0, this, string2, parceledListSlice);
        }

        public /* synthetic */ ServiceCallbacks() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ServiceCallbacks)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class MediaServiceConnection
    implements ServiceConnection,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ MediaBrowser this$0;

        private void $$robo$$android_media_browse_MediaBrowser_MediaServiceConnection$__constructor__(MediaBrowser mediaBrowser) {
        }

        private final void $$robo$$android_media_browse_MediaBrowser_MediaServiceConnection$onServiceConnected(ComponentName name, IBinder binder) {
            if (!this.isCurrent("onServiceConnected")) {
                return;
            }
            this.this$0.mServiceBinder = IMediaBrowserService.Stub.asInterface(binder);
            this.this$0.mServiceCallbacks = this.this$0.getNewServiceCallbacks();
            this.this$0.mState = 1;
            try {
                this.this$0.mServiceBinder.connect(this.this$0.mContext.getPackageName(), this.this$0.mRootHints, this.this$0.mServiceCallbacks);
            }
            catch (RemoteException ex) {
                Log.w("MediaBrowser", "RemoteException during connect for " + this.this$0.mServiceComponent);
            }
        }

        private final void $$robo$$android_media_browse_MediaBrowser_MediaServiceConnection$onServiceDisconnected(ComponentName name) {
            if (!this.isCurrent("onServiceDisconnected")) {
                return;
            }
            this.this$0.mServiceBinder = null;
            this.this$0.mServiceCallbacks = null;
            this.this$0.mState = 3;
            this.this$0.mCallback.onConnectionSuspended();
        }

        private final boolean $$robo$$android_media_browse_MediaBrowser_MediaServiceConnection$isCurrent(String funcName) {
            if (this.this$0.mServiceConnection != this) {
                if (this.this$0.mState != 0) {
                    Log.i("MediaBrowser", funcName + " for " + this.this$0.mServiceComponent + " with mServiceConnection=" + this.this$0.mServiceConnection + " this=" + this);
                }
                return false;
            }
            return true;
        }

        private /* synthetic */ void $$robo$$android_media_browse_MediaBrowser_MediaServiceConnection$__constructor__(MediaBrowser x0, 1 x1) {
        }

        private void __constructor__(MediaBrowser mediaBrowser) {
            this.$$robo$$android_media_browse_MediaBrowser_MediaServiceConnection$__constructor__(mediaBrowser);
        }

        private MediaServiceConnection(MediaBrowser mediaBrowser) {
            this.this$0 = mediaBrowser;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_browse_MediaBrowser_MediaServiceConnection$__constructor__(android.media.browse.MediaBrowser ), 0, this, mediaBrowser);
        }

        @Override
        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            InvokeDynamicSupport.bootstrap("onServiceConnected", $$robo$$android_media_browse_MediaBrowser_MediaServiceConnection$onServiceConnected(android.content.ComponentName android.os.IBinder ), 0, this, componentName, iBinder);
        }

        @Override
        public void onServiceDisconnected(ComponentName componentName) {
            InvokeDynamicSupport.bootstrap("onServiceDisconnected", $$robo$$android_media_browse_MediaBrowser_MediaServiceConnection$onServiceDisconnected(android.content.ComponentName ), 0, this, componentName);
        }

        private boolean isCurrent(String string2) {
            return (boolean)InvokeDynamicSupport.bootstrap("isCurrent", $$robo$$android_media_browse_MediaBrowser_MediaServiceConnection$isCurrent(java.lang.String ), 0, this, string2);
        }

        private /* synthetic */ void __constructor__(MediaBrowser mediaBrowser, 1 var2_2) {
            this.$$robo$$android_media_browse_MediaBrowser_MediaServiceConnection$__constructor__(mediaBrowser, var2_2);
        }

        public /* synthetic */ MediaServiceConnection() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MediaServiceConnection)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class SubscriptionCallback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_media_browse_MediaBrowser_SubscriptionCallback$__constructor__() {
        }

        private final void $$robo$$android_media_browse_MediaBrowser_SubscriptionCallback$onChildrenLoaded(String parentId, List<MediaItem> children) {
        }

        private final void $$robo$$android_media_browse_MediaBrowser_SubscriptionCallback$onError(String id2) {
        }

        private void __constructor__() {
            this.$$robo$$android_media_browse_MediaBrowser_SubscriptionCallback$__constructor__();
        }

        public SubscriptionCallback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_browse_MediaBrowser_SubscriptionCallback$__constructor__(), 0, this);
        }

        public void onChildrenLoaded(String string2, List<MediaItem> list) {
            InvokeDynamicSupport.bootstrap("onChildrenLoaded", $$robo$$android_media_browse_MediaBrowser_SubscriptionCallback$onChildrenLoaded(java.lang.String java.util.List<android.media.browse.MediaBrowser$MediaItem> ), 0, this, string2, list);
        }

        public void onError(String string2) {
            InvokeDynamicSupport.bootstrap("onError", $$robo$$android_media_browse_MediaBrowser_SubscriptionCallback$onError(java.lang.String ), 0, this, string2);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SubscriptionCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class ConnectionCallback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_media_browse_MediaBrowser_ConnectionCallback$__constructor__() {
        }

        private final void $$robo$$android_media_browse_MediaBrowser_ConnectionCallback$onConnected() {
        }

        private final void $$robo$$android_media_browse_MediaBrowser_ConnectionCallback$onConnectionSuspended() {
        }

        private final void $$robo$$android_media_browse_MediaBrowser_ConnectionCallback$onConnectionFailed() {
        }

        private void __constructor__() {
            this.$$robo$$android_media_browse_MediaBrowser_ConnectionCallback$__constructor__();
        }

        public ConnectionCallback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_browse_MediaBrowser_ConnectionCallback$__constructor__(), 0, this);
        }

        public void onConnected() {
            InvokeDynamicSupport.bootstrap("onConnected", $$robo$$android_media_browse_MediaBrowser_ConnectionCallback$onConnected(), 0, this);
        }

        public void onConnectionSuspended() {
            InvokeDynamicSupport.bootstrap("onConnectionSuspended", $$robo$$android_media_browse_MediaBrowser_ConnectionCallback$onConnectionSuspended(), 0, this);
        }

        public void onConnectionFailed() {
            InvokeDynamicSupport.bootstrap("onConnectionFailed", $$robo$$android_media_browse_MediaBrowser_ConnectionCallback$onConnectionFailed(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ConnectionCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class MediaItem
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mFlags;
        private MediaDescription mDescription;
        public static int FLAG_BROWSABLE = 1;
        public static int FLAG_PLAYABLE = 2;
        public static Parcelable.Creator<MediaItem> CREATOR;

        private void $$robo$$android_media_browse_MediaBrowser_MediaItem$__constructor__(MediaDescription description, int flags) {
            if (description == null) {
                throw new IllegalArgumentException("description cannot be null");
            }
            if (TextUtils.isEmpty(description.getMediaId())) {
                throw new IllegalArgumentException("description must have a non-empty media id");
            }
            this.mFlags = flags;
            this.mDescription = description;
        }

        private void $$robo$$android_media_browse_MediaBrowser_MediaItem$__constructor__(Parcel in) {
            this.mFlags = in.readInt();
            this.mDescription = MediaDescription.CREATOR.createFromParcel(in);
        }

        private final int $$robo$$android_media_browse_MediaBrowser_MediaItem$describeContents() {
            return 0;
        }

        private final void $$robo$$android_media_browse_MediaBrowser_MediaItem$writeToParcel(Parcel out, int flags) {
            out.writeInt(this.mFlags);
            this.mDescription.writeToParcel(out, flags);
        }

        private final String $$robo$$android_media_browse_MediaBrowser_MediaItem$toString() {
            StringBuilder sb = new StringBuilder("MediaItem{");
            sb.append("mFlags=").append(this.mFlags);
            sb.append(", mDescription=").append(this.mDescription);
            sb.append('}');
            return sb.toString();
        }

        private final int $$robo$$android_media_browse_MediaBrowser_MediaItem$getFlags() {
            return this.mFlags;
        }

        private final boolean $$robo$$android_media_browse_MediaBrowser_MediaItem$isBrowsable() {
            return (this.mFlags & 1) != 0;
        }

        private final boolean $$robo$$android_media_browse_MediaBrowser_MediaItem$isPlayable() {
            return (this.mFlags & 2) != 0;
        }

        private final MediaDescription $$robo$$android_media_browse_MediaBrowser_MediaItem$getDescription() {
            return this.mDescription;
        }

        private final String $$robo$$android_media_browse_MediaBrowser_MediaItem$getMediaId() {
            return this.mDescription.getMediaId();
        }

        private /* synthetic */ void $$robo$$android_media_browse_MediaBrowser_MediaItem$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<MediaItem>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_media_browse_MediaBrowser_MediaItem_1$__constructor__() {
                }

                private final MediaItem $$robo$$android_media_browse_MediaBrowser_MediaItem_1$createFromParcel(Parcel in) {
                    return new MediaItem(in);
                }

                private final MediaItem[] $$robo$$android_media_browse_MediaBrowser_MediaItem_1$newArray(int size) {
                    return new MediaItem[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_media_browse_MediaBrowser_MediaItem_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_browse_MediaBrowser_MediaItem_1$__constructor__(), 0, this);
                }

                @Override
                public MediaItem createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_media_browse_MediaBrowser_MediaItem_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public MediaItem[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_media_browse_MediaBrowser_MediaItem_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(MediaDescription mediaDescription, int n) {
            this.$$robo$$android_media_browse_MediaBrowser_MediaItem$__constructor__(mediaDescription, n);
        }

        public MediaItem(MediaDescription mediaDescription, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_browse_MediaBrowser_MediaItem$__constructor__(android.media.MediaDescription int ), 0, this, mediaDescription, n);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_media_browse_MediaBrowser_MediaItem$__constructor__(parcel);
        }

        private MediaItem(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_browse_MediaBrowser_MediaItem$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_media_browse_MediaBrowser_MediaItem$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_media_browse_MediaBrowser_MediaItem$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_media_browse_MediaBrowser_MediaItem$toString(), 0, this);
        }

        public int getFlags() {
            return (int)InvokeDynamicSupport.bootstrap("getFlags", $$robo$$android_media_browse_MediaBrowser_MediaItem$getFlags(), 0, this);
        }

        public boolean isBrowsable() {
            return (boolean)InvokeDynamicSupport.bootstrap("isBrowsable", $$robo$$android_media_browse_MediaBrowser_MediaItem$isBrowsable(), 0, this);
        }

        public boolean isPlayable() {
            return (boolean)InvokeDynamicSupport.bootstrap("isPlayable", $$robo$$android_media_browse_MediaBrowser_MediaItem$isPlayable(), 0, this);
        }

        public MediaDescription getDescription() {
            return InvokeDynamicSupport.bootstrap("getDescription", $$robo$$android_media_browse_MediaBrowser_MediaItem$getDescription(), 0, this);
        }

        public String getMediaId() {
            return InvokeDynamicSupport.bootstrap("getMediaId", $$robo$$android_media_browse_MediaBrowser_MediaItem$getMediaId(), 0, this);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_media_browse_MediaBrowser_MediaItem$__constructor__(parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(MediaItem.class);
        }

        public /* synthetic */ MediaItem() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MediaItem)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

