/*
 * Decompiled with CFR 0.152.
 */
package android.media.session;

import android.app.PendingIntent;
import android.content.Context;
import android.content.pm.ParceledListSlice;
import android.media.AudioAttributes;
import android.media.MediaMetadata;
import android.media.Rating;
import android.media.session.ISessionController;
import android.media.session.ISessionControllerCallback;
import android.media.session.MediaSession;
import android.media.session.ParcelableVolumeInfo;
import android.media.session.PlaybackState;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.text.TextUtils;
import android.util.Log;
import android.view.KeyEvent;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class MediaController
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "MediaController";
    private static int MSG_EVENT = 1;
    private static int MSG_UPDATE_PLAYBACK_STATE = 2;
    private static int MSG_UPDATE_METADATA = 3;
    private static int MSG_UPDATE_VOLUME = 4;
    private static int MSG_UPDATE_QUEUE = 5;
    private static int MSG_UPDATE_QUEUE_TITLE = 6;
    private static int MSG_UPDATE_EXTRAS = 7;
    private static int MSG_DESTROYED = 8;
    private ISessionController mSessionBinder;
    private MediaSession.Token mToken;
    private Context mContext;
    private CallbackStub mCbStub;
    private ArrayList<MessageHandler> mCallbacks;
    private Object mLock;
    private boolean mCbRegistered;
    private String mPackageName;
    private String mTag;
    private TransportControls mTransportControls;

    private void $$robo$$android_media_session_MediaController$__constructor__(Context context, ISessionController sessionBinder) {
        this.mCbStub = new CallbackStub(this);
        this.mCallbacks = new ArrayList();
        this.mLock = new Object();
        this.mCbRegistered = false;
        if (sessionBinder == null) {
            throw new IllegalArgumentException("Session token cannot be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Context cannot be null");
        }
        this.mSessionBinder = sessionBinder;
        this.mTransportControls = new TransportControls(this);
        this.mToken = new MediaSession.Token(sessionBinder);
        this.mContext = context;
    }

    private void $$robo$$android_media_session_MediaController$__constructor__(Context context, MediaSession.Token token) {
    }

    private final TransportControls $$robo$$android_media_session_MediaController$getTransportControls() {
        return this.mTransportControls;
    }

    private final boolean $$robo$$android_media_session_MediaController$dispatchMediaButtonEvent(KeyEvent keyEvent) {
        if (keyEvent == null) {
            throw new IllegalArgumentException("KeyEvent may not be null");
        }
        if (!KeyEvent.isMediaKey(keyEvent.getKeyCode())) {
            return false;
        }
        try {
            return this.mSessionBinder.sendMediaButton(keyEvent);
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    private final PlaybackState $$robo$$android_media_session_MediaController$getPlaybackState() {
        try {
            return this.mSessionBinder.getPlaybackState();
        }
        catch (RemoteException e) {
            Log.wtf("MediaController", "Error calling getPlaybackState.", e);
            return null;
        }
    }

    private final MediaMetadata $$robo$$android_media_session_MediaController$getMetadata() {
        try {
            return this.mSessionBinder.getMetadata();
        }
        catch (RemoteException e) {
            Log.wtf("MediaController", "Error calling getMetadata.", e);
            return null;
        }
    }

    private final List<MediaSession.QueueItem> $$robo$$android_media_session_MediaController$getQueue() {
        try {
            ParceledListSlice queue = this.mSessionBinder.getQueue();
            if (queue != null) {
                return queue.getList();
            }
        }
        catch (RemoteException e) {
            Log.wtf("MediaController", "Error calling getQueue.", e);
        }
        return null;
    }

    private final CharSequence $$robo$$android_media_session_MediaController$getQueueTitle() {
        try {
            return this.mSessionBinder.getQueueTitle();
        }
        catch (RemoteException e) {
            Log.wtf("MediaController", "Error calling getQueueTitle", e);
            return null;
        }
    }

    private final Bundle $$robo$$android_media_session_MediaController$getExtras() {
        try {
            return this.mSessionBinder.getExtras();
        }
        catch (RemoteException e) {
            Log.wtf("MediaController", "Error calling getExtras", e);
            return null;
        }
    }

    private final int $$robo$$android_media_session_MediaController$getRatingType() {
        try {
            return this.mSessionBinder.getRatingType();
        }
        catch (RemoteException e) {
            Log.wtf("MediaController", "Error calling getRatingType.", e);
            return 0;
        }
    }

    private final long $$robo$$android_media_session_MediaController$getFlags() {
        try {
            return this.mSessionBinder.getFlags();
        }
        catch (RemoteException e) {
            Log.wtf("MediaController", "Error calling getFlags.", e);
            return 0L;
        }
    }

    private final PlaybackInfo $$robo$$android_media_session_MediaController$getPlaybackInfo() {
        try {
            ParcelableVolumeInfo result = this.mSessionBinder.getVolumeAttributes();
            return new PlaybackInfo(result.volumeType, result.audioAttrs, result.controlType, result.maxVolume, result.currentVolume);
        }
        catch (RemoteException e) {
            Log.wtf("MediaController", "Error calling getAudioInfo.", e);
            return null;
        }
    }

    private final PendingIntent $$robo$$android_media_session_MediaController$getSessionActivity() {
        try {
            return this.mSessionBinder.getLaunchPendingIntent();
        }
        catch (RemoteException e) {
            Log.wtf("MediaController", "Error calling getPendingIntent.", e);
            return null;
        }
    }

    private final MediaSession.Token $$robo$$android_media_session_MediaController$getSessionToken() {
        return this.mToken;
    }

    private final void $$robo$$android_media_session_MediaController$setVolumeTo(int value, int flags) {
        try {
            this.mSessionBinder.setVolumeTo(value, flags, this.mContext.getPackageName());
        }
        catch (RemoteException e) {
            Log.wtf("MediaController", "Error calling setVolumeTo.", e);
        }
    }

    private final void $$robo$$android_media_session_MediaController$adjustVolume(int direction, int flags) {
        try {
            this.mSessionBinder.adjustVolume(direction, flags, this.mContext.getPackageName());
        }
        catch (RemoteException e) {
            Log.wtf("MediaController", "Error calling adjustVolumeBy.", e);
        }
    }

    private final void $$robo$$android_media_session_MediaController$registerCallback(Callback callback) {
        this.registerCallback(callback, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_session_MediaController$registerCallback(Callback callback, Handler handler) {
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null");
        }
        if (handler == null) {
            handler = new Handler();
        }
        Object object = this.mLock;
        synchronized (object) {
            this.addCallbackLocked(callback, handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_session_MediaController$unregisterCallback(Callback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.removeCallbackLocked(callback);
        }
    }

    private final void $$robo$$android_media_session_MediaController$sendCommand(String command, Bundle args, ResultReceiver cb) {
        if (TextUtils.isEmpty(command)) {
            throw new IllegalArgumentException("command cannot be null or empty");
        }
        try {
            this.mSessionBinder.sendCommand(command, args, cb);
        }
        catch (RemoteException e) {
            Log.d("MediaController", "Dead object in sendCommand.", e);
        }
    }

    private final String $$robo$$android_media_session_MediaController$getPackageName() {
        if (this.mPackageName == null) {
            try {
                this.mPackageName = this.mSessionBinder.getPackageName();
            }
            catch (RemoteException e) {
                Log.d("MediaController", "Dead object in getPackageName.", e);
            }
        }
        return this.mPackageName;
    }

    private final String $$robo$$android_media_session_MediaController$getTag() {
        if (this.mTag == null) {
            try {
                this.mTag = this.mSessionBinder.getTag();
            }
            catch (RemoteException e) {
                Log.d("MediaController", "Dead object in getTag.", e);
            }
        }
        return this.mTag;
    }

    private final ISessionController $$robo$$android_media_session_MediaController$getSessionBinder() {
        return this.mSessionBinder;
    }

    private final boolean $$robo$$android_media_session_MediaController$controlsSameSession(MediaController other) {
        if (other == null) {
            return false;
        }
        return this.mSessionBinder.asBinder() == other.getSessionBinder().asBinder();
    }

    private final void $$robo$$android_media_session_MediaController$addCallbackLocked(Callback cb, Handler handler) {
        if (this.getHandlerForCallbackLocked(cb) != null) {
            Log.w("MediaController", "Callback is already added, ignoring");
            return;
        }
        MessageHandler holder = new MessageHandler(handler.getLooper(), cb);
        this.mCallbacks.add(holder);
        if (!this.mCbRegistered) {
            try {
                this.mSessionBinder.registerCallbackListener(this.mCbStub);
                this.mCbRegistered = true;
            }
            catch (RemoteException e) {
                Log.e("MediaController", "Dead object in registerCallback", e);
            }
        }
    }

    private final boolean $$robo$$android_media_session_MediaController$removeCallbackLocked(Callback cb) {
        boolean success = false;
        for (int i = this.mCallbacks.size() - 1; i >= 0; --i) {
            MessageHandler handler = this.mCallbacks.get(i);
            if (cb != handler.mCallback) continue;
            this.mCallbacks.remove(i);
            success = true;
        }
        if (this.mCbRegistered && this.mCallbacks.size() == 0) {
            try {
                this.mSessionBinder.unregisterCallbackListener(this.mCbStub);
            }
            catch (RemoteException e) {
                Log.e("MediaController", "Dead object in removeCallbackLocked");
            }
            this.mCbRegistered = false;
        }
        return success;
    }

    private final MessageHandler $$robo$$android_media_session_MediaController$getHandlerForCallbackLocked(Callback cb) {
        if (cb == null) {
            throw new IllegalArgumentException("Callback cannot be null");
        }
        for (int i = this.mCallbacks.size() - 1; i >= 0; --i) {
            MessageHandler handler = this.mCallbacks.get(i);
            if (cb != handler.mCallback) continue;
            return handler;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_session_MediaController$postMessage(int what, Object obj, Bundle data) {
        Object object = this.mLock;
        synchronized (object) {
            for (int i = this.mCallbacks.size() - 1; i >= 0; --i) {
                this.mCallbacks.get(i).post(what, obj, data);
            }
        }
    }

    private void __constructor__(Context context, ISessionController iSessionController) {
        this.$$robo$$android_media_session_MediaController$__constructor__(context, iSessionController);
    }

    public MediaController(Context context, ISessionController iSessionController) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_session_MediaController$__constructor__(android.content.Context android.media.session.ISessionController ), 0, this, context, iSessionController);
    }

    private void __constructor__(Context context, MediaSession.Token token) {
        this.$$robo$$android_media_session_MediaController$__constructor__(context, token);
    }

    public MediaController(Context context, MediaSession.Token token) {
        this(context, token.getBinder());
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_session_MediaController$__constructor__(android.content.Context android.media.session.MediaSession$Token ), 0, this, context, token);
    }

    public TransportControls getTransportControls() {
        return InvokeDynamicSupport.bootstrap("getTransportControls", $$robo$$android_media_session_MediaController$getTransportControls(), 0, this);
    }

    public boolean dispatchMediaButtonEvent(KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchMediaButtonEvent", $$robo$$android_media_session_MediaController$dispatchMediaButtonEvent(android.view.KeyEvent ), 0, this, keyEvent);
    }

    public PlaybackState getPlaybackState() {
        return InvokeDynamicSupport.bootstrap("getPlaybackState", $$robo$$android_media_session_MediaController$getPlaybackState(), 0, this);
    }

    public MediaMetadata getMetadata() {
        return InvokeDynamicSupport.bootstrap("getMetadata", $$robo$$android_media_session_MediaController$getMetadata(), 0, this);
    }

    public List<MediaSession.QueueItem> getQueue() {
        return InvokeDynamicSupport.bootstrap("getQueue", $$robo$$android_media_session_MediaController$getQueue(), 0, this);
    }

    public CharSequence getQueueTitle() {
        return InvokeDynamicSupport.bootstrap("getQueueTitle", $$robo$$android_media_session_MediaController$getQueueTitle(), 0, this);
    }

    public Bundle getExtras() {
        return InvokeDynamicSupport.bootstrap("getExtras", $$robo$$android_media_session_MediaController$getExtras(), 0, this);
    }

    public int getRatingType() {
        return (int)InvokeDynamicSupport.bootstrap("getRatingType", $$robo$$android_media_session_MediaController$getRatingType(), 0, this);
    }

    public long getFlags() {
        return (long)InvokeDynamicSupport.bootstrap("getFlags", $$robo$$android_media_session_MediaController$getFlags(), 0, this);
    }

    public PlaybackInfo getPlaybackInfo() {
        return InvokeDynamicSupport.bootstrap("getPlaybackInfo", $$robo$$android_media_session_MediaController$getPlaybackInfo(), 0, this);
    }

    public PendingIntent getSessionActivity() {
        return InvokeDynamicSupport.bootstrap("getSessionActivity", $$robo$$android_media_session_MediaController$getSessionActivity(), 0, this);
    }

    public MediaSession.Token getSessionToken() {
        return InvokeDynamicSupport.bootstrap("getSessionToken", $$robo$$android_media_session_MediaController$getSessionToken(), 0, this);
    }

    public void setVolumeTo(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setVolumeTo", $$robo$$android_media_session_MediaController$setVolumeTo(int int ), 0, this, n, n2);
    }

    public void adjustVolume(int n, int n2) {
        InvokeDynamicSupport.bootstrap("adjustVolume", $$robo$$android_media_session_MediaController$adjustVolume(int int ), 0, this, n, n2);
    }

    public void registerCallback(Callback callback) {
        InvokeDynamicSupport.bootstrap("registerCallback", $$robo$$android_media_session_MediaController$registerCallback(android.media.session.MediaController$Callback ), 0, this, callback);
    }

    public void registerCallback(Callback callback, Handler handler) {
        InvokeDynamicSupport.bootstrap("registerCallback", $$robo$$android_media_session_MediaController$registerCallback(android.media.session.MediaController$Callback android.os.Handler ), 0, this, callback, handler);
    }

    public void unregisterCallback(Callback callback) {
        InvokeDynamicSupport.bootstrap("unregisterCallback", $$robo$$android_media_session_MediaController$unregisterCallback(android.media.session.MediaController$Callback ), 0, this, callback);
    }

    public void sendCommand(String string2, Bundle bundle, ResultReceiver resultReceiver) {
        InvokeDynamicSupport.bootstrap("sendCommand", $$robo$$android_media_session_MediaController$sendCommand(java.lang.String android.os.Bundle android.os.ResultReceiver ), 0, this, string2, bundle, resultReceiver);
    }

    public String getPackageName() {
        return InvokeDynamicSupport.bootstrap("getPackageName", $$robo$$android_media_session_MediaController$getPackageName(), 0, this);
    }

    public String getTag() {
        return InvokeDynamicSupport.bootstrap("getTag", $$robo$$android_media_session_MediaController$getTag(), 0, this);
    }

    ISessionController getSessionBinder() {
        return InvokeDynamicSupport.bootstrap("getSessionBinder", $$robo$$android_media_session_MediaController$getSessionBinder(), 0, this);
    }

    public boolean controlsSameSession(MediaController mediaController) {
        return (boolean)InvokeDynamicSupport.bootstrap("controlsSameSession", $$robo$$android_media_session_MediaController$controlsSameSession(android.media.session.MediaController ), 0, this, mediaController);
    }

    private void addCallbackLocked(Callback callback, Handler handler) {
        InvokeDynamicSupport.bootstrap("addCallbackLocked", $$robo$$android_media_session_MediaController$addCallbackLocked(android.media.session.MediaController$Callback android.os.Handler ), 0, this, callback, handler);
    }

    private boolean removeCallbackLocked(Callback callback) {
        return (boolean)InvokeDynamicSupport.bootstrap("removeCallbackLocked", $$robo$$android_media_session_MediaController$removeCallbackLocked(android.media.session.MediaController$Callback ), 0, this, callback);
    }

    private MessageHandler getHandlerForCallbackLocked(Callback callback) {
        return InvokeDynamicSupport.bootstrap("getHandlerForCallbackLocked", $$robo$$android_media_session_MediaController$getHandlerForCallbackLocked(android.media.session.MediaController$Callback ), 0, this, callback);
    }

    private void postMessage(int n, Object object, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("postMessage", $$robo$$android_media_session_MediaController$postMessage(int java.lang.Object android.os.Bundle ), 0, this, n, object, bundle);
    }

    public /* synthetic */ MediaController() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MediaController)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class MessageHandler
    extends Handler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Callback mCallback;

        private void $$robo$$android_media_session_MediaController_MessageHandler$__constructor__(Looper looper, Callback cb) {
            this.mCallback = cb;
        }

        private final void $$robo$$android_media_session_MediaController_MessageHandler$handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    this.mCallback.onSessionEvent((String)msg.obj, msg.getData());
                    break;
                }
                case 2: {
                    this.mCallback.onPlaybackStateChanged((PlaybackState)msg.obj);
                    break;
                }
                case 3: {
                    this.mCallback.onMetadataChanged((MediaMetadata)msg.obj);
                    break;
                }
                case 5: {
                    this.mCallback.onQueueChanged((List)msg.obj);
                    break;
                }
                case 6: {
                    this.mCallback.onQueueTitleChanged((CharSequence)msg.obj);
                    break;
                }
                case 7: {
                    this.mCallback.onExtrasChanged((Bundle)msg.obj);
                    break;
                }
                case 4: {
                    this.mCallback.onAudioInfoChanged((PlaybackInfo)msg.obj);
                    break;
                }
                case 8: {
                    this.mCallback.onSessionDestroyed();
                }
            }
        }

        private final void $$robo$$android_media_session_MediaController_MessageHandler$post(int what, Object obj, Bundle data) {
            this.obtainMessage(what, obj).sendToTarget();
        }

        private void __constructor__(Looper looper, Callback callback) {
            this.$$robo$$android_media_session_MediaController_MessageHandler$__constructor__(looper, callback);
        }

        public MessageHandler(Looper looper, Callback callback) {
            super(looper, null, true);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_session_MediaController_MessageHandler$__constructor__(android.os.Looper android.media.session.MediaController$Callback ), 0, this, looper, callback);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_media_session_MediaController_MessageHandler$handleMessage(android.os.Message ), 0, this, message);
        }

        public void post(int n, Object object, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("post", $$robo$$android_media_session_MediaController_MessageHandler$post(int java.lang.Object android.os.Bundle ), 0, this, n, object, bundle);
        }

        public /* synthetic */ MessageHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MessageHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class CallbackStub
    extends ISessionControllerCallback.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private WeakReference<MediaController> mController;

        private void $$robo$$android_media_session_MediaController_CallbackStub$__constructor__(MediaController controller) {
            this.mController = new WeakReference<MediaController>(controller);
        }

        private final void $$robo$$android_media_session_MediaController_CallbackStub$onSessionDestroyed() {
            MediaController controller = (MediaController)this.mController.get();
            if (controller != null) {
                controller.postMessage(8, null, null);
            }
        }

        private final void $$robo$$android_media_session_MediaController_CallbackStub$onEvent(String event, Bundle extras) {
            MediaController controller = (MediaController)this.mController.get();
            if (controller != null) {
                controller.postMessage(1, event, extras);
            }
        }

        private final void $$robo$$android_media_session_MediaController_CallbackStub$onPlaybackStateChanged(PlaybackState state) {
            MediaController controller = (MediaController)this.mController.get();
            if (controller != null) {
                controller.postMessage(2, state, null);
            }
        }

        private final void $$robo$$android_media_session_MediaController_CallbackStub$onMetadataChanged(MediaMetadata metadata) {
            MediaController controller = (MediaController)this.mController.get();
            if (controller != null) {
                controller.postMessage(3, metadata, null);
            }
        }

        private final void $$robo$$android_media_session_MediaController_CallbackStub$onQueueChanged(ParceledListSlice parceledQueue) {
            List queue = parceledQueue == null ? null : parceledQueue.getList();
            MediaController controller = (MediaController)this.mController.get();
            if (controller != null) {
                controller.postMessage(5, queue, null);
            }
        }

        private final void $$robo$$android_media_session_MediaController_CallbackStub$onQueueTitleChanged(CharSequence title) {
            MediaController controller = (MediaController)this.mController.get();
            if (controller != null) {
                controller.postMessage(6, title, null);
            }
        }

        private final void $$robo$$android_media_session_MediaController_CallbackStub$onExtrasChanged(Bundle extras) {
            MediaController controller = (MediaController)this.mController.get();
            if (controller != null) {
                controller.postMessage(7, extras, null);
            }
        }

        private final void $$robo$$android_media_session_MediaController_CallbackStub$onVolumeInfoChanged(ParcelableVolumeInfo pvi) {
            MediaController controller = (MediaController)this.mController.get();
            if (controller != null) {
                PlaybackInfo info = new PlaybackInfo(pvi.volumeType, pvi.audioAttrs, pvi.controlType, pvi.maxVolume, pvi.currentVolume);
                controller.postMessage(4, info, null);
            }
        }

        private void __constructor__(MediaController mediaController) {
            this.$$robo$$android_media_session_MediaController_CallbackStub$__constructor__(mediaController);
        }

        public CallbackStub(MediaController mediaController) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_session_MediaController_CallbackStub$__constructor__(android.media.session.MediaController ), 0, this, mediaController);
        }

        @Override
        public void onSessionDestroyed() {
            InvokeDynamicSupport.bootstrap("onSessionDestroyed", $$robo$$android_media_session_MediaController_CallbackStub$onSessionDestroyed(), 0, this);
        }

        @Override
        public void onEvent(String string2, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onEvent", $$robo$$android_media_session_MediaController_CallbackStub$onEvent(java.lang.String android.os.Bundle ), 0, this, string2, bundle);
        }

        @Override
        public void onPlaybackStateChanged(PlaybackState playbackState) {
            InvokeDynamicSupport.bootstrap("onPlaybackStateChanged", $$robo$$android_media_session_MediaController_CallbackStub$onPlaybackStateChanged(android.media.session.PlaybackState ), 0, this, playbackState);
        }

        @Override
        public void onMetadataChanged(MediaMetadata mediaMetadata) {
            InvokeDynamicSupport.bootstrap("onMetadataChanged", $$robo$$android_media_session_MediaController_CallbackStub$onMetadataChanged(android.media.MediaMetadata ), 0, this, mediaMetadata);
        }

        @Override
        public void onQueueChanged(ParceledListSlice parceledListSlice) {
            InvokeDynamicSupport.bootstrap("onQueueChanged", $$robo$$android_media_session_MediaController_CallbackStub$onQueueChanged(android.content.pm.ParceledListSlice ), 0, this, parceledListSlice);
        }

        @Override
        public void onQueueTitleChanged(CharSequence charSequence) {
            InvokeDynamicSupport.bootstrap("onQueueTitleChanged", $$robo$$android_media_session_MediaController_CallbackStub$onQueueTitleChanged(java.lang.CharSequence ), 0, this, charSequence);
        }

        @Override
        public void onExtrasChanged(Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onExtrasChanged", $$robo$$android_media_session_MediaController_CallbackStub$onExtrasChanged(android.os.Bundle ), 0, this, bundle);
        }

        @Override
        public void onVolumeInfoChanged(ParcelableVolumeInfo parcelableVolumeInfo) {
            InvokeDynamicSupport.bootstrap("onVolumeInfoChanged", $$robo$$android_media_session_MediaController_CallbackStub$onVolumeInfoChanged(android.media.session.ParcelableVolumeInfo ), 0, this, parcelableVolumeInfo);
        }

        public /* synthetic */ CallbackStub() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CallbackStub)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class PlaybackInfo
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int PLAYBACK_TYPE_REMOTE = 2;
        public static int PLAYBACK_TYPE_LOCAL = 1;
        private int mVolumeType;
        private int mVolumeControl;
        private int mMaxVolume;
        private int mCurrentVolume;
        private AudioAttributes mAudioAttrs;

        private void $$robo$$android_media_session_MediaController_PlaybackInfo$__constructor__(int type, AudioAttributes attrs, int control, int max, int current) {
            this.mVolumeType = type;
            this.mAudioAttrs = attrs;
            this.mVolumeControl = control;
            this.mMaxVolume = max;
            this.mCurrentVolume = current;
        }

        private final int $$robo$$android_media_session_MediaController_PlaybackInfo$getPlaybackType() {
            return this.mVolumeType;
        }

        private final AudioAttributes $$robo$$android_media_session_MediaController_PlaybackInfo$getAudioAttributes() {
            return this.mAudioAttrs;
        }

        private final int $$robo$$android_media_session_MediaController_PlaybackInfo$getVolumeControl() {
            return this.mVolumeControl;
        }

        private final int $$robo$$android_media_session_MediaController_PlaybackInfo$getMaxVolume() {
            return this.mMaxVolume;
        }

        private final int $$robo$$android_media_session_MediaController_PlaybackInfo$getCurrentVolume() {
            return this.mCurrentVolume;
        }

        private void __constructor__(int n, AudioAttributes audioAttributes, int n2, int n3, int n4) {
            this.$$robo$$android_media_session_MediaController_PlaybackInfo$__constructor__(n, audioAttributes, n2, n3, n4);
        }

        public PlaybackInfo(int n, AudioAttributes audioAttributes, int n2, int n3, int n4) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_session_MediaController_PlaybackInfo$__constructor__(int android.media.AudioAttributes int int int ), 0, this, n, audioAttributes, n2, n3, n4);
        }

        public int getPlaybackType() {
            return (int)InvokeDynamicSupport.bootstrap("getPlaybackType", $$robo$$android_media_session_MediaController_PlaybackInfo$getPlaybackType(), 0, this);
        }

        public AudioAttributes getAudioAttributes() {
            return InvokeDynamicSupport.bootstrap("getAudioAttributes", $$robo$$android_media_session_MediaController_PlaybackInfo$getAudioAttributes(), 0, this);
        }

        public int getVolumeControl() {
            return (int)InvokeDynamicSupport.bootstrap("getVolumeControl", $$robo$$android_media_session_MediaController_PlaybackInfo$getVolumeControl(), 0, this);
        }

        public int getMaxVolume() {
            return (int)InvokeDynamicSupport.bootstrap("getMaxVolume", $$robo$$android_media_session_MediaController_PlaybackInfo$getMaxVolume(), 0, this);
        }

        public int getCurrentVolume() {
            return (int)InvokeDynamicSupport.bootstrap("getCurrentVolume", $$robo$$android_media_session_MediaController_PlaybackInfo$getCurrentVolume(), 0, this);
        }

        public /* synthetic */ PlaybackInfo() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PlaybackInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public final class TransportControls
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static String TAG = "TransportController";
        /* synthetic */ MediaController this$0;

        private void $$robo$$android_media_session_MediaController_TransportControls$__constructor__(MediaController mediaController) {
        }

        private final void $$robo$$android_media_session_MediaController_TransportControls$play() {
            try {
                this.this$0.mSessionBinder.play();
            }
            catch (RemoteException e) {
                Log.wtf("TransportController", "Error calling play.", e);
            }
        }

        private final void $$robo$$android_media_session_MediaController_TransportControls$playFromMediaId(String mediaId, Bundle extras) {
            if (TextUtils.isEmpty(mediaId)) {
                throw new IllegalArgumentException("You must specify a non-empty String for playFromMediaId.");
            }
            try {
                this.this$0.mSessionBinder.playFromMediaId(mediaId, extras);
            }
            catch (RemoteException e) {
                Log.wtf("TransportController", "Error calling play(" + mediaId + ").", e);
            }
        }

        private final void $$robo$$android_media_session_MediaController_TransportControls$playFromSearch(String query, Bundle extras) {
            if (query == null) {
                query = "";
            }
            try {
                this.this$0.mSessionBinder.playFromSearch(query, extras);
            }
            catch (RemoteException e) {
                Log.wtf("TransportController", "Error calling play(" + query + ").", e);
            }
        }

        private final void $$robo$$android_media_session_MediaController_TransportControls$skipToQueueItem(long id2) {
            try {
                this.this$0.mSessionBinder.skipToQueueItem(id2);
            }
            catch (RemoteException e) {
                Log.wtf("TransportController", "Error calling skipToItem(" + id2 + ").", e);
            }
        }

        private final void $$robo$$android_media_session_MediaController_TransportControls$pause() {
            try {
                this.this$0.mSessionBinder.pause();
            }
            catch (RemoteException e) {
                Log.wtf("TransportController", "Error calling pause.", e);
            }
        }

        private final void $$robo$$android_media_session_MediaController_TransportControls$stop() {
            try {
                this.this$0.mSessionBinder.stop();
            }
            catch (RemoteException e) {
                Log.wtf("TransportController", "Error calling stop.", e);
            }
        }

        private final void $$robo$$android_media_session_MediaController_TransportControls$seekTo(long pos) {
            try {
                this.this$0.mSessionBinder.seekTo(pos);
            }
            catch (RemoteException e) {
                Log.wtf("TransportController", "Error calling seekTo.", e);
            }
        }

        private final void $$robo$$android_media_session_MediaController_TransportControls$fastForward() {
            try {
                this.this$0.mSessionBinder.fastForward();
            }
            catch (RemoteException e) {
                Log.wtf("TransportController", "Error calling fastForward.", e);
            }
        }

        private final void $$robo$$android_media_session_MediaController_TransportControls$skipToNext() {
            try {
                this.this$0.mSessionBinder.next();
            }
            catch (RemoteException e) {
                Log.wtf("TransportController", "Error calling next.", e);
            }
        }

        private final void $$robo$$android_media_session_MediaController_TransportControls$rewind() {
            try {
                this.this$0.mSessionBinder.rewind();
            }
            catch (RemoteException e) {
                Log.wtf("TransportController", "Error calling rewind.", e);
            }
        }

        private final void $$robo$$android_media_session_MediaController_TransportControls$skipToPrevious() {
            try {
                this.this$0.mSessionBinder.previous();
            }
            catch (RemoteException e) {
                Log.wtf("TransportController", "Error calling previous.", e);
            }
        }

        private final void $$robo$$android_media_session_MediaController_TransportControls$setRating(Rating rating) {
            try {
                this.this$0.mSessionBinder.rate(rating);
            }
            catch (RemoteException e) {
                Log.wtf("TransportController", "Error calling rate.", e);
            }
        }

        private final void $$robo$$android_media_session_MediaController_TransportControls$sendCustomAction(PlaybackState.CustomAction customAction, Bundle args) {
            if (customAction == null) {
                throw new IllegalArgumentException("CustomAction cannot be null.");
            }
            this.sendCustomAction(customAction.getAction(), args);
        }

        private final void $$robo$$android_media_session_MediaController_TransportControls$sendCustomAction(String action, Bundle args) {
            if (TextUtils.isEmpty(action)) {
                throw new IllegalArgumentException("CustomAction cannot be null.");
            }
            try {
                this.this$0.mSessionBinder.sendCustomAction(action, args);
            }
            catch (RemoteException e) {
                Log.d("TransportController", "Dead object in sendCustomAction.", e);
            }
        }

        private /* synthetic */ void $$robo$$android_media_session_MediaController_TransportControls$__constructor__(MediaController x0, 1 x1) {
        }

        private void __constructor__(MediaController mediaController) {
            this.$$robo$$android_media_session_MediaController_TransportControls$__constructor__(mediaController);
        }

        private TransportControls(MediaController mediaController) {
            this.this$0 = mediaController;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_session_MediaController_TransportControls$__constructor__(android.media.session.MediaController ), 0, this, mediaController);
        }

        public void play() {
            InvokeDynamicSupport.bootstrap("play", $$robo$$android_media_session_MediaController_TransportControls$play(), 0, this);
        }

        public void playFromMediaId(String string2, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("playFromMediaId", $$robo$$android_media_session_MediaController_TransportControls$playFromMediaId(java.lang.String android.os.Bundle ), 0, this, string2, bundle);
        }

        public void playFromSearch(String string2, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("playFromSearch", $$robo$$android_media_session_MediaController_TransportControls$playFromSearch(java.lang.String android.os.Bundle ), 0, this, string2, bundle);
        }

        public void skipToQueueItem(long l) {
            InvokeDynamicSupport.bootstrap("skipToQueueItem", $$robo$$android_media_session_MediaController_TransportControls$skipToQueueItem(long ), 0, this, l);
        }

        public void pause() {
            InvokeDynamicSupport.bootstrap("pause", $$robo$$android_media_session_MediaController_TransportControls$pause(), 0, this);
        }

        public void stop() {
            InvokeDynamicSupport.bootstrap("stop", $$robo$$android_media_session_MediaController_TransportControls$stop(), 0, this);
        }

        public void seekTo(long l) {
            InvokeDynamicSupport.bootstrap("seekTo", $$robo$$android_media_session_MediaController_TransportControls$seekTo(long ), 0, this, l);
        }

        public void fastForward() {
            InvokeDynamicSupport.bootstrap("fastForward", $$robo$$android_media_session_MediaController_TransportControls$fastForward(), 0, this);
        }

        public void skipToNext() {
            InvokeDynamicSupport.bootstrap("skipToNext", $$robo$$android_media_session_MediaController_TransportControls$skipToNext(), 0, this);
        }

        public void rewind() {
            InvokeDynamicSupport.bootstrap("rewind", $$robo$$android_media_session_MediaController_TransportControls$rewind(), 0, this);
        }

        public void skipToPrevious() {
            InvokeDynamicSupport.bootstrap("skipToPrevious", $$robo$$android_media_session_MediaController_TransportControls$skipToPrevious(), 0, this);
        }

        public void setRating(Rating rating) {
            InvokeDynamicSupport.bootstrap("setRating", $$robo$$android_media_session_MediaController_TransportControls$setRating(android.media.Rating ), 0, this, rating);
        }

        public void sendCustomAction(PlaybackState.CustomAction customAction, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("sendCustomAction", $$robo$$android_media_session_MediaController_TransportControls$sendCustomAction(android.media.session.PlaybackState$CustomAction android.os.Bundle ), 0, this, customAction, bundle);
        }

        public void sendCustomAction(String string2, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("sendCustomAction", $$robo$$android_media_session_MediaController_TransportControls$sendCustomAction(java.lang.String android.os.Bundle ), 0, this, string2, bundle);
        }

        private /* synthetic */ void __constructor__(MediaController mediaController, 1 var2_2) {
            this.$$robo$$android_media_session_MediaController_TransportControls$__constructor__(mediaController, var2_2);
        }

        public /* synthetic */ TransportControls() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TransportControls)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class Callback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_media_session_MediaController_Callback$__constructor__() {
        }

        private final void $$robo$$android_media_session_MediaController_Callback$onSessionDestroyed() {
        }

        private final void $$robo$$android_media_session_MediaController_Callback$onSessionEvent(String event, Bundle extras) {
        }

        private final void $$robo$$android_media_session_MediaController_Callback$onPlaybackStateChanged(PlaybackState state) {
        }

        private final void $$robo$$android_media_session_MediaController_Callback$onMetadataChanged(MediaMetadata metadata) {
        }

        private final void $$robo$$android_media_session_MediaController_Callback$onQueueChanged(List<MediaSession.QueueItem> queue) {
        }

        private final void $$robo$$android_media_session_MediaController_Callback$onQueueTitleChanged(CharSequence title) {
        }

        private final void $$robo$$android_media_session_MediaController_Callback$onExtrasChanged(Bundle extras) {
        }

        private final void $$robo$$android_media_session_MediaController_Callback$onAudioInfoChanged(PlaybackInfo info) {
        }

        private void __constructor__() {
            this.$$robo$$android_media_session_MediaController_Callback$__constructor__();
        }

        public Callback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_session_MediaController_Callback$__constructor__(), 0, this);
        }

        public void onSessionDestroyed() {
            InvokeDynamicSupport.bootstrap("onSessionDestroyed", $$robo$$android_media_session_MediaController_Callback$onSessionDestroyed(), 0, this);
        }

        public void onSessionEvent(String string2, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onSessionEvent", $$robo$$android_media_session_MediaController_Callback$onSessionEvent(java.lang.String android.os.Bundle ), 0, this, string2, bundle);
        }

        public void onPlaybackStateChanged(PlaybackState playbackState) {
            InvokeDynamicSupport.bootstrap("onPlaybackStateChanged", $$robo$$android_media_session_MediaController_Callback$onPlaybackStateChanged(android.media.session.PlaybackState ), 0, this, playbackState);
        }

        public void onMetadataChanged(MediaMetadata mediaMetadata) {
            InvokeDynamicSupport.bootstrap("onMetadataChanged", $$robo$$android_media_session_MediaController_Callback$onMetadataChanged(android.media.MediaMetadata ), 0, this, mediaMetadata);
        }

        public void onQueueChanged(List<MediaSession.QueueItem> list) {
            InvokeDynamicSupport.bootstrap("onQueueChanged", $$robo$$android_media_session_MediaController_Callback$onQueueChanged(java.util.List<android.media.session.MediaSession$QueueItem> ), 0, this, list);
        }

        public void onQueueTitleChanged(CharSequence charSequence) {
            InvokeDynamicSupport.bootstrap("onQueueTitleChanged", $$robo$$android_media_session_MediaController_Callback$onQueueTitleChanged(java.lang.CharSequence ), 0, this, charSequence);
        }

        public void onExtrasChanged(Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onExtrasChanged", $$robo$$android_media_session_MediaController_Callback$onExtrasChanged(android.os.Bundle ), 0, this, bundle);
        }

        public void onAudioInfoChanged(PlaybackInfo playbackInfo) {
            InvokeDynamicSupport.bootstrap("onAudioInfoChanged", $$robo$$android_media_session_MediaController_Callback$onAudioInfoChanged(android.media.session.MediaController$PlaybackInfo ), 0, this, playbackInfo);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Callback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

