/*
 * Decompiled with CFR 0.152.
 */
package android.media.session;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.media.MediaMetadata;
import android.media.Rating;
import android.media.session.MediaSession;
import android.media.session.MediaSessionManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.ArrayMap;
import android.util.Log;
import android.view.KeyEvent;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class MediaSessionLegacyHelper
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "MediaSessionHelper";
    private static boolean DEBUG;
    private static Object sLock;
    private static MediaSessionLegacyHelper sInstance;
    private Context mContext;
    private MediaSessionManager mSessionManager;
    private Handler mHandler;
    private ArrayMap<PendingIntent, SessionHolder> mSessions;

    private void $$robo$$android_media_session_MediaSessionLegacyHelper$__constructor__(Context context) {
        this.mHandler = new Handler(Looper.getMainLooper());
        this.mSessions = new ArrayMap();
        this.mContext = context;
        this.mSessionManager = (MediaSessionManager)context.getSystemService("media_session");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final MediaSessionLegacyHelper $$robo$$android_media_session_MediaSessionLegacyHelper$getHelper(Context context) {
        if (DEBUG) {
            Log.d("MediaSessionHelper", "Attempting to get helper with context " + context);
        }
        Object object = sLock;
        synchronized (object) {
            if (sInstance == null) {
                sInstance = new MediaSessionLegacyHelper(context);
            }
        }
        return sInstance;
    }

    private static final Bundle $$robo$$android_media_session_MediaSessionLegacyHelper$getOldMetadata(MediaMetadata metadata, int artworkWidth, int artworkHeight) {
        boolean includeArtwork = artworkWidth != -1 && artworkHeight != -1;
        Bundle oldMetadata = new Bundle();
        if (metadata.containsKey("android.media.metadata.ALBUM")) {
            oldMetadata.putString(String.valueOf(1), metadata.getString("android.media.metadata.ALBUM"));
        }
        if (includeArtwork && metadata.containsKey("android.media.metadata.ART")) {
            Bitmap art = metadata.getBitmap("android.media.metadata.ART");
            oldMetadata.putParcelable(String.valueOf(100), MediaSessionLegacyHelper.scaleBitmapIfTooBig(art, artworkWidth, artworkHeight));
        } else if (includeArtwork && metadata.containsKey("android.media.metadata.ALBUM_ART")) {
            Bitmap art = metadata.getBitmap("android.media.metadata.ALBUM_ART");
            oldMetadata.putParcelable(String.valueOf(100), MediaSessionLegacyHelper.scaleBitmapIfTooBig(art, artworkWidth, artworkHeight));
        }
        if (metadata.containsKey("android.media.metadata.ALBUM_ARTIST")) {
            oldMetadata.putString(String.valueOf(13), metadata.getString("android.media.metadata.ALBUM_ARTIST"));
        }
        if (metadata.containsKey("android.media.metadata.ARTIST")) {
            oldMetadata.putString(String.valueOf(2), metadata.getString("android.media.metadata.ARTIST"));
        }
        if (metadata.containsKey("android.media.metadata.AUTHOR")) {
            oldMetadata.putString(String.valueOf(3), metadata.getString("android.media.metadata.AUTHOR"));
        }
        if (metadata.containsKey("android.media.metadata.COMPILATION")) {
            oldMetadata.putString(String.valueOf(15), metadata.getString("android.media.metadata.COMPILATION"));
        }
        if (metadata.containsKey("android.media.metadata.COMPOSER")) {
            oldMetadata.putString(String.valueOf(4), metadata.getString("android.media.metadata.COMPOSER"));
        }
        if (metadata.containsKey("android.media.metadata.DATE")) {
            oldMetadata.putString(String.valueOf(5), metadata.getString("android.media.metadata.DATE"));
        }
        if (metadata.containsKey("android.media.metadata.DISC_NUMBER")) {
            oldMetadata.putLong(String.valueOf(14), metadata.getLong("android.media.metadata.DISC_NUMBER"));
        }
        if (metadata.containsKey("android.media.metadata.DURATION")) {
            oldMetadata.putLong(String.valueOf(9), metadata.getLong("android.media.metadata.DURATION"));
        }
        if (metadata.containsKey("android.media.metadata.GENRE")) {
            oldMetadata.putString(String.valueOf(6), metadata.getString("android.media.metadata.GENRE"));
        }
        if (metadata.containsKey("android.media.metadata.NUM_TRACKS")) {
            oldMetadata.putLong(String.valueOf(10), metadata.getLong("android.media.metadata.NUM_TRACKS"));
        }
        if (metadata.containsKey("android.media.metadata.RATING")) {
            oldMetadata.putParcelable(String.valueOf(101), metadata.getRating("android.media.metadata.RATING"));
        }
        if (metadata.containsKey("android.media.metadata.USER_RATING")) {
            oldMetadata.putParcelable(String.valueOf(0x10000001), metadata.getRating("android.media.metadata.USER_RATING"));
        }
        if (metadata.containsKey("android.media.metadata.TITLE")) {
            oldMetadata.putString(String.valueOf(7), metadata.getString("android.media.metadata.TITLE"));
        }
        if (metadata.containsKey("android.media.metadata.TRACK_NUMBER")) {
            oldMetadata.putLong(String.valueOf(0), metadata.getLong("android.media.metadata.TRACK_NUMBER"));
        }
        if (metadata.containsKey("android.media.metadata.WRITER")) {
            oldMetadata.putString(String.valueOf(11), metadata.getString("android.media.metadata.WRITER"));
        }
        if (metadata.containsKey("android.media.metadata.YEAR")) {
            oldMetadata.putString(String.valueOf(8), metadata.getString("android.media.metadata.YEAR"));
        }
        return oldMetadata;
    }

    private final MediaSession $$robo$$android_media_session_MediaSessionLegacyHelper$getSession(PendingIntent pi) {
        SessionHolder holder = this.mSessions.get(pi);
        return holder == null ? null : holder.mSession;
    }

    private final void $$robo$$android_media_session_MediaSessionLegacyHelper$sendMediaButtonEvent(KeyEvent keyEvent, boolean needWakeLock) {
        if (keyEvent == null) {
            Log.w("MediaSessionHelper", "Tried to send a null key event. Ignoring.");
            return;
        }
        this.mSessionManager.dispatchMediaKeyEvent(keyEvent, needWakeLock);
        if (DEBUG) {
            Log.d("MediaSessionHelper", "dispatched media key " + keyEvent);
        }
    }

    private final void $$robo$$android_media_session_MediaSessionLegacyHelper$sendVolumeKeyEvent(KeyEvent keyEvent, boolean musicOnly) {
        if (keyEvent == null) {
            Log.w("MediaSessionHelper", "Tried to send a null key event. Ignoring.");
            return;
        }
        boolean down = keyEvent.getAction() == 0;
        boolean up = keyEvent.getAction() == 1;
        int direction = 0;
        switch (keyEvent.getKeyCode()) {
            case 24: {
                direction = 1;
                break;
            }
            case 25: {
                direction = -1;
                break;
            }
        }
        if ((down || up) && direction != 0) {
            if (up) {
                direction = 0;
            }
            int flags = musicOnly ? 512 : (up ? 20 : 17);
            this.mSessionManager.dispatchAdjustVolume(Integer.MIN_VALUE, direction, flags);
        }
    }

    private final void $$robo$$android_media_session_MediaSessionLegacyHelper$sendAdjustVolumeBy(int suggestedStream, int delta, int flags) {
        this.mSessionManager.dispatchAdjustVolume(suggestedStream, delta, flags);
        if (DEBUG) {
            Log.d("MediaSessionHelper", "dispatched volume adjustment");
        }
    }

    private final boolean $$robo$$android_media_session_MediaSessionLegacyHelper$isGlobalPriorityActive() {
        return this.mSessionManager.isGlobalPriorityActive();
    }

    private final void $$robo$$android_media_session_MediaSessionLegacyHelper$addRccListener(PendingIntent pi, MediaSession.Callback listener) {
        if (pi == null) {
            Log.w("MediaSessionHelper", "Pending intent was null, can't add rcc listener.");
            return;
        }
        SessionHolder holder = this.getHolder(pi, true);
        if (holder == null) {
            return;
        }
        if (holder.mRccListener != null && holder.mRccListener == listener) {
            if (DEBUG) {
                Log.d("MediaSessionHelper", "addRccListener listener already added.");
            }
            return;
        }
        holder.mRccListener = listener;
        holder.mFlags |= 2;
        holder.mSession.setFlags(holder.mFlags);
        holder.update();
        if (DEBUG) {
            Log.d("MediaSessionHelper", "Added rcc listener for " + pi + ".");
        }
    }

    private final void $$robo$$android_media_session_MediaSessionLegacyHelper$removeRccListener(PendingIntent pi) {
        if (pi == null) {
            return;
        }
        SessionHolder holder = this.getHolder(pi, false);
        if (holder != null && holder.mRccListener != null) {
            holder.mRccListener = null;
            holder.mFlags &= 0xFFFFFFFD;
            holder.mSession.setFlags(holder.mFlags);
            holder.update();
            if (DEBUG) {
                Log.d("MediaSessionHelper", "Removed rcc listener for " + pi + ".");
            }
        }
    }

    private final void $$robo$$android_media_session_MediaSessionLegacyHelper$addMediaButtonListener(PendingIntent pi, ComponentName mbrComponent, Context context) {
        if (pi == null) {
            Log.w("MediaSessionHelper", "Pending intent was null, can't addMediaButtonListener.");
            return;
        }
        SessionHolder holder = this.getHolder(pi, true);
        if (holder == null) {
            return;
        }
        if (holder.mMediaButtonListener != null && DEBUG) {
            Log.d("MediaSessionHelper", "addMediaButtonListener already added " + pi);
        }
        holder.mMediaButtonListener = new MediaButtonListener(pi, context);
        holder.mFlags |= 1;
        holder.mSession.setFlags(holder.mFlags);
        holder.mSession.setMediaButtonReceiver(pi);
        holder.update();
        if (DEBUG) {
            Log.d("MediaSessionHelper", "addMediaButtonListener added " + pi);
        }
    }

    private final void $$robo$$android_media_session_MediaSessionLegacyHelper$removeMediaButtonListener(PendingIntent pi) {
        if (pi == null) {
            return;
        }
        SessionHolder holder = this.getHolder(pi, false);
        if (holder != null && holder.mMediaButtonListener != null) {
            holder.mFlags &= 0xFFFFFFFE;
            holder.mSession.setFlags(holder.mFlags);
            holder.mMediaButtonListener = null;
            holder.update();
            if (DEBUG) {
                Log.d("MediaSessionHelper", "removeMediaButtonListener removed " + pi);
            }
        }
    }

    private static final Bitmap $$robo$$android_media_session_MediaSessionLegacyHelper$scaleBitmapIfTooBig(Bitmap bitmap, int maxWidth, int maxHeight) {
        if (bitmap != null) {
            int width = bitmap.getWidth();
            int height = bitmap.getHeight();
            if (width > maxWidth || height > maxHeight) {
                float scale = Math.min((float)maxWidth / (float)width, (float)maxHeight / (float)height);
                int newWidth = Math.round(scale * (float)width);
                int newHeight = Math.round(scale * (float)height);
                Bitmap.Config newConfig = bitmap.getConfig();
                if (newConfig == null) {
                    newConfig = Bitmap.Config.ARGB_8888;
                }
                Bitmap outBitmap = Bitmap.createBitmap(newWidth, newHeight, newConfig);
                Canvas canvas = new Canvas(outBitmap);
                Paint paint = new Paint();
                paint.setAntiAlias(true);
                paint.setFilterBitmap(true);
                canvas.drawBitmap(bitmap, null, new RectF(0.0f, 0.0f, outBitmap.getWidth(), outBitmap.getHeight()), paint);
                bitmap = outBitmap;
            }
        }
        return bitmap;
    }

    private final SessionHolder $$robo$$android_media_session_MediaSessionLegacyHelper$getHolder(PendingIntent pi, boolean createIfMissing) {
        SessionHolder holder = this.mSessions.get(pi);
        if (holder == null && createIfMissing) {
            MediaSession session = new MediaSession(this.mContext, "MediaSessionHelper-" + pi.getCreatorPackage());
            session.setActive(true);
            holder = new SessionHolder(this, session, pi);
            this.mSessions.put(pi, holder);
        }
        return holder;
    }

    private static final void $$robo$$android_media_session_MediaSessionLegacyHelper$sendKeyEvent(PendingIntent pi, Context context, Intent intent) {
        try {
            pi.send(context, 0, intent);
        }
        catch (PendingIntent.CanceledException e) {
            Log.e("MediaSessionHelper", "Error sending media key down event:", e);
            return;
        }
    }

    static void __staticInitializer__() {
        DEBUG = Log.isLoggable("MediaSessionHelper", 3);
        sLock = new Object();
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_media_session_MediaSessionLegacyHelper$__constructor__(context);
    }

    private MediaSessionLegacyHelper(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_session_MediaSessionLegacyHelper$__constructor__(android.content.Context ), 0, this, context);
    }

    public static MediaSessionLegacyHelper getHelper(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getHelper", $$robo$$android_media_session_MediaSessionLegacyHelper$getHelper(android.content.Context ), 0, (Context)context);
    }

    public static Bundle getOldMetadata(MediaMetadata mediaMetadata, int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("getOldMetadata", $$robo$$android_media_session_MediaSessionLegacyHelper$getOldMetadata(android.media.MediaMetadata int int ), 0, (MediaMetadata)mediaMetadata, (int)n, (int)n2);
    }

    public MediaSession getSession(PendingIntent pendingIntent) {
        return InvokeDynamicSupport.bootstrap("getSession", $$robo$$android_media_session_MediaSessionLegacyHelper$getSession(android.app.PendingIntent ), 0, this, pendingIntent);
    }

    public void sendMediaButtonEvent(KeyEvent keyEvent, boolean bl) {
        InvokeDynamicSupport.bootstrap("sendMediaButtonEvent", $$robo$$android_media_session_MediaSessionLegacyHelper$sendMediaButtonEvent(android.view.KeyEvent boolean ), 0, this, keyEvent, bl);
    }

    public void sendVolumeKeyEvent(KeyEvent keyEvent, boolean bl) {
        InvokeDynamicSupport.bootstrap("sendVolumeKeyEvent", $$robo$$android_media_session_MediaSessionLegacyHelper$sendVolumeKeyEvent(android.view.KeyEvent boolean ), 0, this, keyEvent, bl);
    }

    public void sendAdjustVolumeBy(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("sendAdjustVolumeBy", $$robo$$android_media_session_MediaSessionLegacyHelper$sendAdjustVolumeBy(int int int ), 0, this, n, n2, n3);
    }

    public boolean isGlobalPriorityActive() {
        return (boolean)InvokeDynamicSupport.bootstrap("isGlobalPriorityActive", $$robo$$android_media_session_MediaSessionLegacyHelper$isGlobalPriorityActive(), 0, this);
    }

    public void addRccListener(PendingIntent pendingIntent, MediaSession.Callback callback) {
        InvokeDynamicSupport.bootstrap("addRccListener", $$robo$$android_media_session_MediaSessionLegacyHelper$addRccListener(android.app.PendingIntent android.media.session.MediaSession$Callback ), 0, this, pendingIntent, callback);
    }

    public void removeRccListener(PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("removeRccListener", $$robo$$android_media_session_MediaSessionLegacyHelper$removeRccListener(android.app.PendingIntent ), 0, this, pendingIntent);
    }

    public void addMediaButtonListener(PendingIntent pendingIntent, ComponentName componentName, Context context) {
        InvokeDynamicSupport.bootstrap("addMediaButtonListener", $$robo$$android_media_session_MediaSessionLegacyHelper$addMediaButtonListener(android.app.PendingIntent android.content.ComponentName android.content.Context ), 0, this, pendingIntent, componentName, context);
    }

    public void removeMediaButtonListener(PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("removeMediaButtonListener", $$robo$$android_media_session_MediaSessionLegacyHelper$removeMediaButtonListener(android.app.PendingIntent ), 0, this, pendingIntent);
    }

    private static Bitmap scaleBitmapIfTooBig(Bitmap bitmap, int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("scaleBitmapIfTooBig", $$robo$$android_media_session_MediaSessionLegacyHelper$scaleBitmapIfTooBig(android.graphics.Bitmap int int ), 0, (Bitmap)bitmap, (int)n, (int)n2);
    }

    private SessionHolder getHolder(PendingIntent pendingIntent, boolean bl) {
        return InvokeDynamicSupport.bootstrap("getHolder", $$robo$$android_media_session_MediaSessionLegacyHelper$getHolder(android.app.PendingIntent boolean ), 0, this, pendingIntent, bl);
    }

    private static void sendKeyEvent(PendingIntent pendingIntent, Context context, Intent intent) {
        InvokeDynamicSupport.bootstrapStatic("sendKeyEvent", $$robo$$android_media_session_MediaSessionLegacyHelper$sendKeyEvent(android.app.PendingIntent android.content.Context android.content.Intent ), 0, (PendingIntent)pendingIntent, (Context)context, (Intent)intent);
    }

    static {
        RobolectricInternals.classInitializing(MediaSessionLegacyHelper.class);
    }

    public /* synthetic */ MediaSessionLegacyHelper() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MediaSessionLegacyHelper)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class SessionHolder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public MediaSession mSession;
        public PendingIntent mPi;
        public MediaButtonListener mMediaButtonListener;
        public MediaSession.Callback mRccListener;
        public int mFlags;
        public SessionCallback mCb;
        /* synthetic */ MediaSessionLegacyHelper this$0;

        private void $$robo$$android_media_session_MediaSessionLegacyHelper_SessionHolder$__constructor__(MediaSessionLegacyHelper mediaSessionLegacyHelper, MediaSession session, PendingIntent pi) {
            this.mSession = session;
            this.mPi = pi;
        }

        private final void $$robo$$android_media_session_MediaSessionLegacyHelper_SessionHolder$update() {
            if (this.mMediaButtonListener == null && this.mRccListener == null) {
                this.mSession.setCallback(null);
                this.mSession.release();
                this.mCb = null;
                this.this$0.mSessions.remove(this.mPi);
            } else if (this.mCb == null) {
                this.mCb = new SessionCallback(this);
                Handler handler = new Handler(Looper.getMainLooper());
                this.mSession.setCallback(this.mCb, handler);
            }
        }

        private void __constructor__(MediaSessionLegacyHelper mediaSessionLegacyHelper, MediaSession mediaSession, PendingIntent pendingIntent) {
            this.$$robo$$android_media_session_MediaSessionLegacyHelper_SessionHolder$__constructor__(mediaSessionLegacyHelper, mediaSession, pendingIntent);
        }

        public SessionHolder(MediaSessionLegacyHelper mediaSessionLegacyHelper, MediaSession mediaSession, PendingIntent pendingIntent) {
            this.this$0 = mediaSessionLegacyHelper;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_session_MediaSessionLegacyHelper_SessionHolder$__constructor__(android.media.session.MediaSessionLegacyHelper android.media.session.MediaSession android.app.PendingIntent ), 0, this, mediaSessionLegacyHelper, mediaSession, pendingIntent);
        }

        public void update() {
            InvokeDynamicSupport.bootstrap("update", $$robo$$android_media_session_MediaSessionLegacyHelper_SessionHolder$update(), 0, this);
        }

        public /* synthetic */ SessionHolder() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SessionHolder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        private class SessionCallback
        extends MediaSession.Callback
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ SessionHolder this$1;

            private void $$robo$$android_media_session_MediaSessionLegacyHelper_SessionHolder_SessionCallback$__constructor__(SessionHolder sessionHolder) {
            }

            private final boolean $$robo$$android_media_session_MediaSessionLegacyHelper_SessionHolder_SessionCallback$onMediaButtonEvent(Intent mediaButtonIntent) {
                if (this.this$1.mMediaButtonListener != null) {
                    this.this$1.mMediaButtonListener.onMediaButtonEvent(mediaButtonIntent);
                }
                return true;
            }

            private final void $$robo$$android_media_session_MediaSessionLegacyHelper_SessionHolder_SessionCallback$onPlay() {
                if (this.this$1.mMediaButtonListener != null) {
                    this.this$1.mMediaButtonListener.onPlay();
                }
            }

            private final void $$robo$$android_media_session_MediaSessionLegacyHelper_SessionHolder_SessionCallback$onPause() {
                if (this.this$1.mMediaButtonListener != null) {
                    this.this$1.mMediaButtonListener.onPause();
                }
            }

            private final void $$robo$$android_media_session_MediaSessionLegacyHelper_SessionHolder_SessionCallback$onSkipToNext() {
                if (this.this$1.mMediaButtonListener != null) {
                    this.this$1.mMediaButtonListener.onSkipToNext();
                }
            }

            private final void $$robo$$android_media_session_MediaSessionLegacyHelper_SessionHolder_SessionCallback$onSkipToPrevious() {
                if (this.this$1.mMediaButtonListener != null) {
                    this.this$1.mMediaButtonListener.onSkipToPrevious();
                }
            }

            private final void $$robo$$android_media_session_MediaSessionLegacyHelper_SessionHolder_SessionCallback$onFastForward() {
                if (this.this$1.mMediaButtonListener != null) {
                    this.this$1.mMediaButtonListener.onFastForward();
                }
            }

            private final void $$robo$$android_media_session_MediaSessionLegacyHelper_SessionHolder_SessionCallback$onRewind() {
                if (this.this$1.mMediaButtonListener != null) {
                    this.this$1.mMediaButtonListener.onRewind();
                }
            }

            private final void $$robo$$android_media_session_MediaSessionLegacyHelper_SessionHolder_SessionCallback$onStop() {
                if (this.this$1.mMediaButtonListener != null) {
                    this.this$1.mMediaButtonListener.onStop();
                }
            }

            private final void $$robo$$android_media_session_MediaSessionLegacyHelper_SessionHolder_SessionCallback$onSeekTo(long pos) {
                if (this.this$1.mRccListener != null) {
                    this.this$1.mRccListener.onSeekTo(pos);
                }
            }

            private final void $$robo$$android_media_session_MediaSessionLegacyHelper_SessionHolder_SessionCallback$onSetRating(Rating rating) {
                if (this.this$1.mRccListener != null) {
                    this.this$1.mRccListener.onSetRating(rating);
                }
            }

            private /* synthetic */ void $$robo$$android_media_session_MediaSessionLegacyHelper_SessionHolder_SessionCallback$__constructor__(SessionHolder x0, 1 x1) {
            }

            private void __constructor__(SessionHolder sessionHolder) {
                this.$$robo$$android_media_session_MediaSessionLegacyHelper_SessionHolder_SessionCallback$__constructor__(sessionHolder);
            }

            private SessionCallback(SessionHolder sessionHolder) {
                this.this$1 = sessionHolder;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_session_MediaSessionLegacyHelper_SessionHolder_SessionCallback$__constructor__(android.media.session.MediaSessionLegacyHelper$SessionHolder ), 0, this, sessionHolder);
            }

            @Override
            public boolean onMediaButtonEvent(Intent intent) {
                return (boolean)InvokeDynamicSupport.bootstrap("onMediaButtonEvent", $$robo$$android_media_session_MediaSessionLegacyHelper_SessionHolder_SessionCallback$onMediaButtonEvent(android.content.Intent ), 0, this, intent);
            }

            @Override
            public void onPlay() {
                InvokeDynamicSupport.bootstrap("onPlay", $$robo$$android_media_session_MediaSessionLegacyHelper_SessionHolder_SessionCallback$onPlay(), 0, this);
            }

            @Override
            public void onPause() {
                InvokeDynamicSupport.bootstrap("onPause", $$robo$$android_media_session_MediaSessionLegacyHelper_SessionHolder_SessionCallback$onPause(), 0, this);
            }

            @Override
            public void onSkipToNext() {
                InvokeDynamicSupport.bootstrap("onSkipToNext", $$robo$$android_media_session_MediaSessionLegacyHelper_SessionHolder_SessionCallback$onSkipToNext(), 0, this);
            }

            @Override
            public void onSkipToPrevious() {
                InvokeDynamicSupport.bootstrap("onSkipToPrevious", $$robo$$android_media_session_MediaSessionLegacyHelper_SessionHolder_SessionCallback$onSkipToPrevious(), 0, this);
            }

            @Override
            public void onFastForward() {
                InvokeDynamicSupport.bootstrap("onFastForward", $$robo$$android_media_session_MediaSessionLegacyHelper_SessionHolder_SessionCallback$onFastForward(), 0, this);
            }

            @Override
            public void onRewind() {
                InvokeDynamicSupport.bootstrap("onRewind", $$robo$$android_media_session_MediaSessionLegacyHelper_SessionHolder_SessionCallback$onRewind(), 0, this);
            }

            @Override
            public void onStop() {
                InvokeDynamicSupport.bootstrap("onStop", $$robo$$android_media_session_MediaSessionLegacyHelper_SessionHolder_SessionCallback$onStop(), 0, this);
            }

            @Override
            public void onSeekTo(long l) {
                InvokeDynamicSupport.bootstrap("onSeekTo", $$robo$$android_media_session_MediaSessionLegacyHelper_SessionHolder_SessionCallback$onSeekTo(long ), 0, this, l);
            }

            @Override
            public void onSetRating(Rating rating) {
                InvokeDynamicSupport.bootstrap("onSetRating", $$robo$$android_media_session_MediaSessionLegacyHelper_SessionHolder_SessionCallback$onSetRating(android.media.Rating ), 0, this, rating);
            }

            private /* synthetic */ void __constructor__(SessionHolder sessionHolder, 1 var2_2) {
                this.$$robo$$android_media_session_MediaSessionLegacyHelper_SessionHolder_SessionCallback$__constructor__(sessionHolder, var2_2);
            }

            public /* synthetic */ SessionCallback() {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SessionCallback)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class MediaButtonListener
    extends MediaSession.Callback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private PendingIntent mPendingIntent;
        private Context mContext;

        private void $$robo$$android_media_session_MediaSessionLegacyHelper_MediaButtonListener$__constructor__(PendingIntent pi, Context context) {
            this.mPendingIntent = pi;
            this.mContext = context;
        }

        private final boolean $$robo$$android_media_session_MediaSessionLegacyHelper_MediaButtonListener$onMediaButtonEvent(Intent mediaButtonIntent) {
            MediaSessionLegacyHelper.sendKeyEvent(this.mPendingIntent, this.mContext, mediaButtonIntent);
            return true;
        }

        private final void $$robo$$android_media_session_MediaSessionLegacyHelper_MediaButtonListener$onPlay() {
            this.sendKeyEvent(126);
        }

        private final void $$robo$$android_media_session_MediaSessionLegacyHelper_MediaButtonListener$onPause() {
            this.sendKeyEvent(127);
        }

        private final void $$robo$$android_media_session_MediaSessionLegacyHelper_MediaButtonListener$onSkipToNext() {
            this.sendKeyEvent(87);
        }

        private final void $$robo$$android_media_session_MediaSessionLegacyHelper_MediaButtonListener$onSkipToPrevious() {
            this.sendKeyEvent(88);
        }

        private final void $$robo$$android_media_session_MediaSessionLegacyHelper_MediaButtonListener$onFastForward() {
            this.sendKeyEvent(90);
        }

        private final void $$robo$$android_media_session_MediaSessionLegacyHelper_MediaButtonListener$onRewind() {
            this.sendKeyEvent(89);
        }

        private final void $$robo$$android_media_session_MediaSessionLegacyHelper_MediaButtonListener$onStop() {
            this.sendKeyEvent(86);
        }

        private final void $$robo$$android_media_session_MediaSessionLegacyHelper_MediaButtonListener$sendKeyEvent(int keyCode) {
            KeyEvent ke = new KeyEvent(0, keyCode);
            Intent intent = new Intent("android.intent.action.MEDIA_BUTTON");
            intent.addFlags(0x10000000);
            intent.putExtra("android.intent.extra.KEY_EVENT", ke);
            MediaSessionLegacyHelper.sendKeyEvent(this.mPendingIntent, this.mContext, intent);
            ke = new KeyEvent(1, keyCode);
            intent.putExtra("android.intent.extra.KEY_EVENT", ke);
            MediaSessionLegacyHelper.sendKeyEvent(this.mPendingIntent, this.mContext, intent);
            if (DEBUG) {
                Log.d("MediaSessionHelper", "Sent " + keyCode + " to pending intent " + this.mPendingIntent);
            }
        }

        private void __constructor__(PendingIntent pendingIntent, Context context) {
            this.$$robo$$android_media_session_MediaSessionLegacyHelper_MediaButtonListener$__constructor__(pendingIntent, context);
        }

        public MediaButtonListener(PendingIntent pendingIntent, Context context) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_session_MediaSessionLegacyHelper_MediaButtonListener$__constructor__(android.app.PendingIntent android.content.Context ), 0, this, pendingIntent, context);
        }

        @Override
        public boolean onMediaButtonEvent(Intent intent) {
            return (boolean)InvokeDynamicSupport.bootstrap("onMediaButtonEvent", $$robo$$android_media_session_MediaSessionLegacyHelper_MediaButtonListener$onMediaButtonEvent(android.content.Intent ), 0, this, intent);
        }

        @Override
        public void onPlay() {
            InvokeDynamicSupport.bootstrap("onPlay", $$robo$$android_media_session_MediaSessionLegacyHelper_MediaButtonListener$onPlay(), 0, this);
        }

        @Override
        public void onPause() {
            InvokeDynamicSupport.bootstrap("onPause", $$robo$$android_media_session_MediaSessionLegacyHelper_MediaButtonListener$onPause(), 0, this);
        }

        @Override
        public void onSkipToNext() {
            InvokeDynamicSupport.bootstrap("onSkipToNext", $$robo$$android_media_session_MediaSessionLegacyHelper_MediaButtonListener$onSkipToNext(), 0, this);
        }

        @Override
        public void onSkipToPrevious() {
            InvokeDynamicSupport.bootstrap("onSkipToPrevious", $$robo$$android_media_session_MediaSessionLegacyHelper_MediaButtonListener$onSkipToPrevious(), 0, this);
        }

        @Override
        public void onFastForward() {
            InvokeDynamicSupport.bootstrap("onFastForward", $$robo$$android_media_session_MediaSessionLegacyHelper_MediaButtonListener$onFastForward(), 0, this);
        }

        @Override
        public void onRewind() {
            InvokeDynamicSupport.bootstrap("onRewind", $$robo$$android_media_session_MediaSessionLegacyHelper_MediaButtonListener$onRewind(), 0, this);
        }

        @Override
        public void onStop() {
            InvokeDynamicSupport.bootstrap("onStop", $$robo$$android_media_session_MediaSessionLegacyHelper_MediaButtonListener$onStop(), 0, this);
        }

        private void sendKeyEvent(int n) {
            InvokeDynamicSupport.bootstrap("sendKeyEvent", $$robo$$android_media_session_MediaSessionLegacyHelper_MediaButtonListener$sendKeyEvent(int ), 0, this, n);
        }

        public /* synthetic */ MediaButtonListener() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MediaButtonListener)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

