/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv;

import android.graphics.Rect;
import android.media.tv.ITvInputClient;
import android.media.tv.ITvInputHardware;
import android.media.tv.ITvInputHardwareCallback;
import android.media.tv.ITvInputManagerCallback;
import android.media.tv.TvContentRatingSystemInfo;
import android.media.tv.TvInputHardwareInfo;
import android.media.tv.TvInputInfo;
import android.media.tv.TvStreamConfig;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.Surface;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public interface ITvInputManager
extends IInterface,
InstrumentedInterface {
    public List<TvInputInfo> getTvInputList(int var1) throws RemoteException;

    public TvInputInfo getTvInputInfo(String var1, int var2) throws RemoteException;

    public List<TvContentRatingSystemInfo> getTvContentRatingSystemList(int var1) throws RemoteException;

    public void registerCallback(ITvInputManagerCallback var1, int var2) throws RemoteException;

    public void unregisterCallback(ITvInputManagerCallback var1, int var2) throws RemoteException;

    public boolean isParentalControlsEnabled(int var1) throws RemoteException;

    public void setParentalControlsEnabled(boolean var1, int var2) throws RemoteException;

    public boolean isRatingBlocked(String var1, int var2) throws RemoteException;

    public List<String> getBlockedRatings(int var1) throws RemoteException;

    public void addBlockedRating(String var1, int var2) throws RemoteException;

    public void removeBlockedRating(String var1, int var2) throws RemoteException;

    public void createSession(ITvInputClient var1, String var2, int var3, int var4) throws RemoteException;

    public void releaseSession(IBinder var1, int var2) throws RemoteException;

    public void setMainSession(IBinder var1, int var2) throws RemoteException;

    public void setSurface(IBinder var1, Surface var2, int var3) throws RemoteException;

    public void dispatchSurfaceChanged(IBinder var1, int var2, int var3, int var4, int var5) throws RemoteException;

    public void setVolume(IBinder var1, float var2, int var3) throws RemoteException;

    public void tune(IBinder var1, Uri var2, Bundle var3, int var4) throws RemoteException;

    public void setCaptionEnabled(IBinder var1, boolean var2, int var3) throws RemoteException;

    public void selectTrack(IBinder var1, int var2, String var3, int var4) throws RemoteException;

    public void sendAppPrivateCommand(IBinder var1, String var2, Bundle var3, int var4) throws RemoteException;

    public void createOverlayView(IBinder var1, IBinder var2, Rect var3, int var4) throws RemoteException;

    public void relayoutOverlayView(IBinder var1, Rect var2, int var3) throws RemoteException;

    public void removeOverlayView(IBinder var1, int var2) throws RemoteException;

    public void requestUnblockContent(IBinder var1, String var2, int var3) throws RemoteException;

    public List<TvInputHardwareInfo> getHardwareList() throws RemoteException;

    public ITvInputHardware acquireTvInputHardware(int var1, ITvInputHardwareCallback var2, TvInputInfo var3, int var4) throws RemoteException;

    public void releaseTvInputHardware(int var1, ITvInputHardware var2, int var3) throws RemoteException;

    public List<TvStreamConfig> getAvailableTvStreamConfigList(String var1, int var2) throws RemoteException;

    public boolean captureFrame(String var1, Surface var2, TvStreamConfig var3, int var4) throws RemoteException;

    public boolean isSingleSessionActive(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ITvInputManager,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static String DESCRIPTOR = "android.media.tv.ITvInputManager";
        static int TRANSACTION_getTvInputList = 1;
        static int TRANSACTION_getTvInputInfo = 2;
        static int TRANSACTION_getTvContentRatingSystemList = 3;
        static int TRANSACTION_registerCallback = 4;
        static int TRANSACTION_unregisterCallback = 5;
        static int TRANSACTION_isParentalControlsEnabled = 6;
        static int TRANSACTION_setParentalControlsEnabled = 7;
        static int TRANSACTION_isRatingBlocked = 8;
        static int TRANSACTION_getBlockedRatings = 9;
        static int TRANSACTION_addBlockedRating = 10;
        static int TRANSACTION_removeBlockedRating = 11;
        static int TRANSACTION_createSession = 12;
        static int TRANSACTION_releaseSession = 13;
        static int TRANSACTION_setMainSession = 14;
        static int TRANSACTION_setSurface = 15;
        static int TRANSACTION_dispatchSurfaceChanged = 16;
        static int TRANSACTION_setVolume = 17;
        static int TRANSACTION_tune = 18;
        static int TRANSACTION_setCaptionEnabled = 19;
        static int TRANSACTION_selectTrack = 20;
        static int TRANSACTION_sendAppPrivateCommand = 21;
        static int TRANSACTION_createOverlayView = 22;
        static int TRANSACTION_relayoutOverlayView = 23;
        static int TRANSACTION_removeOverlayView = 24;
        static int TRANSACTION_requestUnblockContent = 25;
        static int TRANSACTION_getHardwareList = 26;
        static int TRANSACTION_acquireTvInputHardware = 27;
        static int TRANSACTION_releaseTvInputHardware = 28;
        static int TRANSACTION_getAvailableTvStreamConfigList = 29;
        static int TRANSACTION_captureFrame = 30;
        static int TRANSACTION_isSingleSessionActive = 31;

        private void $$robo$$android_media_tv_ITvInputManager_Stub$__constructor__() {
            this.attachInterface(this, "android.media.tv.ITvInputManager");
        }

        private static final ITvInputManager $$robo$$android_media_tv_ITvInputManager_Stub$asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface("android.media.tv.ITvInputManager");
            if (iin != null && iin instanceof ITvInputManager) {
                return (ITvInputManager)iin;
            }
            return new Proxy(obj);
        }

        private final IBinder $$robo$$android_media_tv_ITvInputManager_Stub$asBinder() {
            return this;
        }

        private final boolean $$robo$$android_media_tv_ITvInputManager_Stub$onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            switch (code) {
                case 1598968902: {
                    reply.writeString("android.media.tv.ITvInputManager");
                    return true;
                }
                case 1: {
                    data.enforceInterface("android.media.tv.ITvInputManager");
                    int _arg0 = data.readInt();
                    List _result = this.getTvInputList(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    return true;
                }
                case 2: {
                    data.enforceInterface("android.media.tv.ITvInputManager");
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    TvInputInfo _result = this.getTvInputInfo(_arg0, _arg1);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 3: {
                    data.enforceInterface("android.media.tv.ITvInputManager");
                    int _arg0 = data.readInt();
                    List _result = this.getTvContentRatingSystemList(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    return true;
                }
                case 4: {
                    data.enforceInterface("android.media.tv.ITvInputManager");
                    ITvInputManagerCallback _arg0 = ITvInputManagerCallback.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    this.registerCallback(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 5: {
                    data.enforceInterface("android.media.tv.ITvInputManager");
                    ITvInputManagerCallback _arg0 = ITvInputManagerCallback.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    this.unregisterCallback(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 6: {
                    data.enforceInterface("android.media.tv.ITvInputManager");
                    int _arg0 = data.readInt();
                    boolean _result = this.isParentalControlsEnabled(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 7: {
                    data.enforceInterface("android.media.tv.ITvInputManager");
                    boolean _arg0 = 0 != data.readInt();
                    int _arg1 = data.readInt();
                    this.setParentalControlsEnabled(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 8: {
                    data.enforceInterface("android.media.tv.ITvInputManager");
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    boolean _result = this.isRatingBlocked(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 9: {
                    data.enforceInterface("android.media.tv.ITvInputManager");
                    int _arg0 = data.readInt();
                    List _result = this.getBlockedRatings(_arg0);
                    reply.writeNoException();
                    reply.writeStringList(_result);
                    return true;
                }
                case 10: {
                    data.enforceInterface("android.media.tv.ITvInputManager");
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    this.addBlockedRating(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 11: {
                    data.enforceInterface("android.media.tv.ITvInputManager");
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    this.removeBlockedRating(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 12: {
                    data.enforceInterface("android.media.tv.ITvInputManager");
                    ITvInputClient _arg0 = ITvInputClient.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    this.createSession(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 13: {
                    data.enforceInterface("android.media.tv.ITvInputManager");
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    this.releaseSession(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 14: {
                    data.enforceInterface("android.media.tv.ITvInputManager");
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    this.setMainSession(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 15: {
                    data.enforceInterface("android.media.tv.ITvInputManager");
                    IBinder _arg0 = data.readStrongBinder();
                    Surface _arg1 = 0 != data.readInt() ? Surface.CREATOR.createFromParcel(data) : null;
                    int _arg2 = data.readInt();
                    this.setSurface(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 16: {
                    data.enforceInterface("android.media.tv.ITvInputManager");
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    this.dispatchSurfaceChanged(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    return true;
                }
                case 17: {
                    data.enforceInterface("android.media.tv.ITvInputManager");
                    IBinder _arg0 = data.readStrongBinder();
                    float _arg1 = data.readFloat();
                    int _arg2 = data.readInt();
                    this.setVolume(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 18: {
                    data.enforceInterface("android.media.tv.ITvInputManager");
                    IBinder _arg0 = data.readStrongBinder();
                    Uri _arg1 = 0 != data.readInt() ? Uri.CREATOR.createFromParcel(data) : null;
                    Bundle _arg2 = 0 != data.readInt() ? Bundle.CREATOR.createFromParcel(data) : null;
                    int _arg3 = data.readInt();
                    this.tune(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 19: {
                    data.enforceInterface("android.media.tv.ITvInputManager");
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _arg1 = 0 != data.readInt();
                    int _arg2 = data.readInt();
                    this.setCaptionEnabled(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 20: {
                    data.enforceInterface("android.media.tv.ITvInputManager");
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    int _arg3 = data.readInt();
                    this.selectTrack(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 21: {
                    data.enforceInterface("android.media.tv.ITvInputManager");
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    Bundle _arg2 = 0 != data.readInt() ? Bundle.CREATOR.createFromParcel(data) : null;
                    int _arg3 = data.readInt();
                    this.sendAppPrivateCommand(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 22: {
                    data.enforceInterface("android.media.tv.ITvInputManager");
                    IBinder _arg0 = data.readStrongBinder();
                    IBinder _arg1 = data.readStrongBinder();
                    Rect _arg2 = 0 != data.readInt() ? Rect.CREATOR.createFromParcel(data) : null;
                    int _arg3 = data.readInt();
                    this.createOverlayView(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 23: {
                    data.enforceInterface("android.media.tv.ITvInputManager");
                    IBinder _arg0 = data.readStrongBinder();
                    Rect _arg1 = 0 != data.readInt() ? Rect.CREATOR.createFromParcel(data) : null;
                    int _arg2 = data.readInt();
                    this.relayoutOverlayView(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 24: {
                    data.enforceInterface("android.media.tv.ITvInputManager");
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    this.removeOverlayView(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 25: {
                    data.enforceInterface("android.media.tv.ITvInputManager");
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    this.requestUnblockContent(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 26: {
                    data.enforceInterface("android.media.tv.ITvInputManager");
                    List _result = this.getHardwareList();
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    return true;
                }
                case 27: {
                    data.enforceInterface("android.media.tv.ITvInputManager");
                    int _arg0 = data.readInt();
                    ITvInputHardwareCallback _arg1 = ITvInputHardwareCallback.Stub.asInterface(data.readStrongBinder());
                    TvInputInfo _arg2 = 0 != data.readInt() ? TvInputInfo.CREATOR.createFromParcel(data) : null;
                    int _arg3 = data.readInt();
                    ITvInputHardware _result = this.acquireTvInputHardware(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeStrongBinder(_result != null ? _result.asBinder() : null);
                    return true;
                }
                case 28: {
                    data.enforceInterface("android.media.tv.ITvInputManager");
                    int _arg0 = data.readInt();
                    ITvInputHardware _arg1 = ITvInputHardware.Stub.asInterface(data.readStrongBinder());
                    int _arg2 = data.readInt();
                    this.releaseTvInputHardware(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 29: {
                    data.enforceInterface("android.media.tv.ITvInputManager");
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    List _result = this.getAvailableTvStreamConfigList(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    return true;
                }
                case 30: {
                    data.enforceInterface("android.media.tv.ITvInputManager");
                    String _arg0 = data.readString();
                    Surface _arg1 = 0 != data.readInt() ? Surface.CREATOR.createFromParcel(data) : null;
                    TvStreamConfig _arg2 = 0 != data.readInt() ? TvStreamConfig.CREATOR.createFromParcel(data) : null;
                    int _arg3 = data.readInt();
                    boolean _result = this.captureFrame(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 31: {
                    data.enforceInterface("android.media.tv.ITvInputManager");
                    int _arg0 = data.readInt();
                    boolean _result = this.isSingleSessionActive(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        private void __constructor__() {
            this.$$robo$$android_media_tv_ITvInputManager_Stub$__constructor__();
        }

        public Stub() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_ITvInputManager_Stub$__constructor__(), 0, this);
        }

        public static ITvInputManager asInterface(IBinder iBinder) {
            return InvokeDynamicSupport.bootstrapStatic("asInterface", $$robo$$android_media_tv_ITvInputManager_Stub$asInterface(android.os.IBinder ), 0, (IBinder)iBinder);
        }

        @Override
        public IBinder asBinder() {
            return InvokeDynamicSupport.bootstrap("asBinder", $$robo$$android_media_tv_ITvInputManager_Stub$asBinder(), 0, this);
        }

        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            return (boolean)InvokeDynamicSupport.bootstrap("onTransact", $$robo$$android_media_tv_ITvInputManager_Stub$onTransact(int android.os.Parcel android.os.Parcel int ), 0, this, n, parcel, parcel2, n2);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Stub)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        private static class Proxy
        implements ITvInputManager,
        ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            private IBinder mRemote;

            private void $$robo$$android_media_tv_ITvInputManager_Stub_Proxy$__constructor__(IBinder remote) {
                this.mRemote = remote;
            }

            private final IBinder $$robo$$android_media_tv_ITvInputManager_Stub_Proxy$asBinder() {
                return this.mRemote;
            }

            private final String $$robo$$android_media_tv_ITvInputManager_Stub_Proxy$getInterfaceDescriptor() {
                return "android.media.tv.ITvInputManager";
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final List<TvInputInfo> $$robo$$android_media_tv_ITvInputManager_Stub_Proxy$getTvInputList(int userId) throws RemoteException {
                ArrayList<TvInputInfo> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.media.tv.ITvInputManager");
                    _data.writeInt(userId);
                    this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(TvInputInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final TvInputInfo $$robo$$android_media_tv_ITvInputManager_Stub_Proxy$getTvInputInfo(String inputId, int userId) throws RemoteException {
                TvInputInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.media.tv.ITvInputManager");
                    _data.writeString(inputId);
                    _data.writeInt(userId);
                    this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? TvInputInfo.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final List<TvContentRatingSystemInfo> $$robo$$android_media_tv_ITvInputManager_Stub_Proxy$getTvContentRatingSystemList(int userId) throws RemoteException {
                ArrayList<TvContentRatingSystemInfo> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.media.tv.ITvInputManager");
                    _data.writeInt(userId);
                    this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(TvContentRatingSystemInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_media_tv_ITvInputManager_Stub_Proxy$registerCallback(ITvInputManagerCallback callback, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.media.tv.ITvInputManager");
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    _data.writeInt(userId);
                    this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_media_tv_ITvInputManager_Stub_Proxy$unregisterCallback(ITvInputManagerCallback callback, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.media.tv.ITvInputManager");
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    _data.writeInt(userId);
                    this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_media_tv_ITvInputManager_Stub_Proxy$isParentalControlsEnabled(int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.media.tv.ITvInputManager");
                    _data.writeInt(userId);
                    this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_media_tv_ITvInputManager_Stub_Proxy$setParentalControlsEnabled(boolean enabled, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.media.tv.ITvInputManager");
                    _data.writeInt(enabled ? 1 : 0);
                    _data.writeInt(userId);
                    this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_media_tv_ITvInputManager_Stub_Proxy$isRatingBlocked(String rating, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.media.tv.ITvInputManager");
                    _data.writeString(rating);
                    _data.writeInt(userId);
                    this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final List<String> $$robo$$android_media_tv_ITvInputManager_Stub_Proxy$getBlockedRatings(int userId) throws RemoteException {
                ArrayList<String> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.media.tv.ITvInputManager");
                    _data.writeInt(userId);
                    this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArrayList();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_media_tv_ITvInputManager_Stub_Proxy$addBlockedRating(String rating, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.media.tv.ITvInputManager");
                    _data.writeString(rating);
                    _data.writeInt(userId);
                    this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_media_tv_ITvInputManager_Stub_Proxy$removeBlockedRating(String rating, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.media.tv.ITvInputManager");
                    _data.writeString(rating);
                    _data.writeInt(userId);
                    this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_media_tv_ITvInputManager_Stub_Proxy$createSession(ITvInputClient client, String inputId, int seq, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.media.tv.ITvInputManager");
                    _data.writeStrongBinder(client != null ? client.asBinder() : null);
                    _data.writeString(inputId);
                    _data.writeInt(seq);
                    _data.writeInt(userId);
                    this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_media_tv_ITvInputManager_Stub_Proxy$releaseSession(IBinder sessionToken, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.media.tv.ITvInputManager");
                    _data.writeStrongBinder(sessionToken);
                    _data.writeInt(userId);
                    this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_media_tv_ITvInputManager_Stub_Proxy$setMainSession(IBinder sessionToken, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.media.tv.ITvInputManager");
                    _data.writeStrongBinder(sessionToken);
                    _data.writeInt(userId);
                    this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_media_tv_ITvInputManager_Stub_Proxy$setSurface(IBinder sessionToken, Surface surface, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.media.tv.ITvInputManager");
                    _data.writeStrongBinder(sessionToken);
                    if (surface != null) {
                        _data.writeInt(1);
                        surface.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(userId);
                    this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_media_tv_ITvInputManager_Stub_Proxy$dispatchSurfaceChanged(IBinder sessionToken, int format, int width, int height, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.media.tv.ITvInputManager");
                    _data.writeStrongBinder(sessionToken);
                    _data.writeInt(format);
                    _data.writeInt(width);
                    _data.writeInt(height);
                    _data.writeInt(userId);
                    this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_media_tv_ITvInputManager_Stub_Proxy$setVolume(IBinder sessionToken, float volume, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.media.tv.ITvInputManager");
                    _data.writeStrongBinder(sessionToken);
                    _data.writeFloat(volume);
                    _data.writeInt(userId);
                    this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_media_tv_ITvInputManager_Stub_Proxy$tune(IBinder sessionToken, Uri channelUri, Bundle params, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.media.tv.ITvInputManager");
                    _data.writeStrongBinder(sessionToken);
                    if (channelUri != null) {
                        _data.writeInt(1);
                        channelUri.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (params != null) {
                        _data.writeInt(1);
                        params.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(userId);
                    this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_media_tv_ITvInputManager_Stub_Proxy$setCaptionEnabled(IBinder sessionToken, boolean enabled, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.media.tv.ITvInputManager");
                    _data.writeStrongBinder(sessionToken);
                    _data.writeInt(enabled ? 1 : 0);
                    _data.writeInt(userId);
                    this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_media_tv_ITvInputManager_Stub_Proxy$selectTrack(IBinder sessionToken, int type, String trackId, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.media.tv.ITvInputManager");
                    _data.writeStrongBinder(sessionToken);
                    _data.writeInt(type);
                    _data.writeString(trackId);
                    _data.writeInt(userId);
                    this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_media_tv_ITvInputManager_Stub_Proxy$sendAppPrivateCommand(IBinder sessionToken, String action, Bundle data, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.media.tv.ITvInputManager");
                    _data.writeStrongBinder(sessionToken);
                    _data.writeString(action);
                    if (data != null) {
                        _data.writeInt(1);
                        data.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(userId);
                    this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_media_tv_ITvInputManager_Stub_Proxy$createOverlayView(IBinder sessionToken, IBinder windowToken, Rect frame, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.media.tv.ITvInputManager");
                    _data.writeStrongBinder(sessionToken);
                    _data.writeStrongBinder(windowToken);
                    if (frame != null) {
                        _data.writeInt(1);
                        frame.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(userId);
                    this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_media_tv_ITvInputManager_Stub_Proxy$relayoutOverlayView(IBinder sessionToken, Rect frame, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.media.tv.ITvInputManager");
                    _data.writeStrongBinder(sessionToken);
                    if (frame != null) {
                        _data.writeInt(1);
                        frame.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(userId);
                    this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_media_tv_ITvInputManager_Stub_Proxy$removeOverlayView(IBinder sessionToken, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.media.tv.ITvInputManager");
                    _data.writeStrongBinder(sessionToken);
                    _data.writeInt(userId);
                    this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_media_tv_ITvInputManager_Stub_Proxy$requestUnblockContent(IBinder sessionToken, String unblockedRating, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.media.tv.ITvInputManager");
                    _data.writeStrongBinder(sessionToken);
                    _data.writeString(unblockedRating);
                    _data.writeInt(userId);
                    this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final List<TvInputHardwareInfo> $$robo$$android_media_tv_ITvInputManager_Stub_Proxy$getHardwareList() throws RemoteException {
                ArrayList<TvInputHardwareInfo> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.media.tv.ITvInputManager");
                    this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(TvInputHardwareInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final ITvInputHardware $$robo$$android_media_tv_ITvInputManager_Stub_Proxy$acquireTvInputHardware(int deviceId, ITvInputHardwareCallback callback, TvInputInfo info, int userId) throws RemoteException {
                ITvInputHardware _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.media.tv.ITvInputManager");
                    _data.writeInt(deviceId);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    if (info != null) {
                        _data.writeInt(1);
                        info.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(userId);
                    this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                    _result = ITvInputHardware.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_media_tv_ITvInputManager_Stub_Proxy$releaseTvInputHardware(int deviceId, ITvInputHardware hardware, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.media.tv.ITvInputManager");
                    _data.writeInt(deviceId);
                    _data.writeStrongBinder(hardware != null ? hardware.asBinder() : null);
                    _data.writeInt(userId);
                    this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final List<TvStreamConfig> $$robo$$android_media_tv_ITvInputManager_Stub_Proxy$getAvailableTvStreamConfigList(String inputId, int userId) throws RemoteException {
                ArrayList<TvStreamConfig> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.media.tv.ITvInputManager");
                    _data.writeString(inputId);
                    _data.writeInt(userId);
                    this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(TvStreamConfig.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_media_tv_ITvInputManager_Stub_Proxy$captureFrame(String inputId, Surface surface, TvStreamConfig config, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.media.tv.ITvInputManager");
                    _data.writeString(inputId);
                    if (surface != null) {
                        _data.writeInt(1);
                        surface.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (config != null) {
                        _data.writeInt(1);
                        config.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(userId);
                    this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_media_tv_ITvInputManager_Stub_Proxy$isSingleSessionActive(int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.media.tv.ITvInputManager");
                    _data.writeInt(userId);
                    this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            private void __constructor__(IBinder iBinder) {
                this.$$robo$$android_media_tv_ITvInputManager_Stub_Proxy$__constructor__(iBinder);
            }

            Proxy(IBinder iBinder) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_ITvInputManager_Stub_Proxy$__constructor__(android.os.IBinder ), 0, this, iBinder);
            }

            @Override
            public IBinder asBinder() {
                return InvokeDynamicSupport.bootstrap("asBinder", $$robo$$android_media_tv_ITvInputManager_Stub_Proxy$asBinder(), 0, this);
            }

            public String getInterfaceDescriptor() {
                return InvokeDynamicSupport.bootstrap("getInterfaceDescriptor", $$robo$$android_media_tv_ITvInputManager_Stub_Proxy$getInterfaceDescriptor(), 0, this);
            }

            @Override
            public List<TvInputInfo> getTvInputList(int n) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getTvInputList", $$robo$$android_media_tv_ITvInputManager_Stub_Proxy$getTvInputList(int ), 0, this, n);
            }

            @Override
            public TvInputInfo getTvInputInfo(String string2, int n) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getTvInputInfo", $$robo$$android_media_tv_ITvInputManager_Stub_Proxy$getTvInputInfo(java.lang.String int ), 0, this, string2, n);
            }

            @Override
            public List<TvContentRatingSystemInfo> getTvContentRatingSystemList(int n) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getTvContentRatingSystemList", $$robo$$android_media_tv_ITvInputManager_Stub_Proxy$getTvContentRatingSystemList(int ), 0, this, n);
            }

            @Override
            public void registerCallback(ITvInputManagerCallback iTvInputManagerCallback, int n) throws RemoteException {
                InvokeDynamicSupport.bootstrap("registerCallback", $$robo$$android_media_tv_ITvInputManager_Stub_Proxy$registerCallback(android.media.tv.ITvInputManagerCallback int ), 0, this, iTvInputManagerCallback, n);
            }

            @Override
            public void unregisterCallback(ITvInputManagerCallback iTvInputManagerCallback, int n) throws RemoteException {
                InvokeDynamicSupport.bootstrap("unregisterCallback", $$robo$$android_media_tv_ITvInputManager_Stub_Proxy$unregisterCallback(android.media.tv.ITvInputManagerCallback int ), 0, this, iTvInputManagerCallback, n);
            }

            @Override
            public boolean isParentalControlsEnabled(int n) throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("isParentalControlsEnabled", $$robo$$android_media_tv_ITvInputManager_Stub_Proxy$isParentalControlsEnabled(int ), 0, this, n);
            }

            @Override
            public void setParentalControlsEnabled(boolean bl, int n) throws RemoteException {
                InvokeDynamicSupport.bootstrap("setParentalControlsEnabled", $$robo$$android_media_tv_ITvInputManager_Stub_Proxy$setParentalControlsEnabled(boolean int ), 0, this, bl, n);
            }

            @Override
            public boolean isRatingBlocked(String string2, int n) throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("isRatingBlocked", $$robo$$android_media_tv_ITvInputManager_Stub_Proxy$isRatingBlocked(java.lang.String int ), 0, this, string2, n);
            }

            @Override
            public List<String> getBlockedRatings(int n) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getBlockedRatings", $$robo$$android_media_tv_ITvInputManager_Stub_Proxy$getBlockedRatings(int ), 0, this, n);
            }

            @Override
            public void addBlockedRating(String string2, int n) throws RemoteException {
                InvokeDynamicSupport.bootstrap("addBlockedRating", $$robo$$android_media_tv_ITvInputManager_Stub_Proxy$addBlockedRating(java.lang.String int ), 0, this, string2, n);
            }

            @Override
            public void removeBlockedRating(String string2, int n) throws RemoteException {
                InvokeDynamicSupport.bootstrap("removeBlockedRating", $$robo$$android_media_tv_ITvInputManager_Stub_Proxy$removeBlockedRating(java.lang.String int ), 0, this, string2, n);
            }

            @Override
            public void createSession(ITvInputClient iTvInputClient, String string2, int n, int n2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("createSession", $$robo$$android_media_tv_ITvInputManager_Stub_Proxy$createSession(android.media.tv.ITvInputClient java.lang.String int int ), 0, this, iTvInputClient, string2, n, n2);
            }

            @Override
            public void releaseSession(IBinder iBinder, int n) throws RemoteException {
                InvokeDynamicSupport.bootstrap("releaseSession", $$robo$$android_media_tv_ITvInputManager_Stub_Proxy$releaseSession(android.os.IBinder int ), 0, this, iBinder, n);
            }

            @Override
            public void setMainSession(IBinder iBinder, int n) throws RemoteException {
                InvokeDynamicSupport.bootstrap("setMainSession", $$robo$$android_media_tv_ITvInputManager_Stub_Proxy$setMainSession(android.os.IBinder int ), 0, this, iBinder, n);
            }

            @Override
            public void setSurface(IBinder iBinder, Surface surface, int n) throws RemoteException {
                InvokeDynamicSupport.bootstrap("setSurface", $$robo$$android_media_tv_ITvInputManager_Stub_Proxy$setSurface(android.os.IBinder android.view.Surface int ), 0, this, iBinder, surface, n);
            }

            @Override
            public void dispatchSurfaceChanged(IBinder iBinder, int n, int n2, int n3, int n4) throws RemoteException {
                InvokeDynamicSupport.bootstrap("dispatchSurfaceChanged", $$robo$$android_media_tv_ITvInputManager_Stub_Proxy$dispatchSurfaceChanged(android.os.IBinder int int int int ), 0, this, iBinder, n, n2, n3, n4);
            }

            @Override
            public void setVolume(IBinder iBinder, float f, int n) throws RemoteException {
                InvokeDynamicSupport.bootstrap("setVolume", $$robo$$android_media_tv_ITvInputManager_Stub_Proxy$setVolume(android.os.IBinder float int ), 0, this, iBinder, f, n);
            }

            @Override
            public void tune(IBinder iBinder, Uri uri, Bundle bundle, int n) throws RemoteException {
                InvokeDynamicSupport.bootstrap("tune", $$robo$$android_media_tv_ITvInputManager_Stub_Proxy$tune(android.os.IBinder android.net.Uri android.os.Bundle int ), 0, this, iBinder, uri, bundle, n);
            }

            @Override
            public void setCaptionEnabled(IBinder iBinder, boolean bl, int n) throws RemoteException {
                InvokeDynamicSupport.bootstrap("setCaptionEnabled", $$robo$$android_media_tv_ITvInputManager_Stub_Proxy$setCaptionEnabled(android.os.IBinder boolean int ), 0, this, iBinder, bl, n);
            }

            @Override
            public void selectTrack(IBinder iBinder, int n, String string2, int n2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("selectTrack", $$robo$$android_media_tv_ITvInputManager_Stub_Proxy$selectTrack(android.os.IBinder int java.lang.String int ), 0, this, iBinder, n, string2, n2);
            }

            @Override
            public void sendAppPrivateCommand(IBinder iBinder, String string2, Bundle bundle, int n) throws RemoteException {
                InvokeDynamicSupport.bootstrap("sendAppPrivateCommand", $$robo$$android_media_tv_ITvInputManager_Stub_Proxy$sendAppPrivateCommand(android.os.IBinder java.lang.String android.os.Bundle int ), 0, this, iBinder, string2, bundle, n);
            }

            @Override
            public void createOverlayView(IBinder iBinder, IBinder iBinder2, Rect rect, int n) throws RemoteException {
                InvokeDynamicSupport.bootstrap("createOverlayView", $$robo$$android_media_tv_ITvInputManager_Stub_Proxy$createOverlayView(android.os.IBinder android.os.IBinder android.graphics.Rect int ), 0, this, iBinder, iBinder2, rect, n);
            }

            @Override
            public void relayoutOverlayView(IBinder iBinder, Rect rect, int n) throws RemoteException {
                InvokeDynamicSupport.bootstrap("relayoutOverlayView", $$robo$$android_media_tv_ITvInputManager_Stub_Proxy$relayoutOverlayView(android.os.IBinder android.graphics.Rect int ), 0, this, iBinder, rect, n);
            }

            @Override
            public void removeOverlayView(IBinder iBinder, int n) throws RemoteException {
                InvokeDynamicSupport.bootstrap("removeOverlayView", $$robo$$android_media_tv_ITvInputManager_Stub_Proxy$removeOverlayView(android.os.IBinder int ), 0, this, iBinder, n);
            }

            @Override
            public void requestUnblockContent(IBinder iBinder, String string2, int n) throws RemoteException {
                InvokeDynamicSupport.bootstrap("requestUnblockContent", $$robo$$android_media_tv_ITvInputManager_Stub_Proxy$requestUnblockContent(android.os.IBinder java.lang.String int ), 0, this, iBinder, string2, n);
            }

            @Override
            public List<TvInputHardwareInfo> getHardwareList() throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getHardwareList", $$robo$$android_media_tv_ITvInputManager_Stub_Proxy$getHardwareList(), 0, this);
            }

            @Override
            public ITvInputHardware acquireTvInputHardware(int n, ITvInputHardwareCallback iTvInputHardwareCallback, TvInputInfo tvInputInfo, int n2) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("acquireTvInputHardware", $$robo$$android_media_tv_ITvInputManager_Stub_Proxy$acquireTvInputHardware(int android.media.tv.ITvInputHardwareCallback android.media.tv.TvInputInfo int ), 0, this, n, iTvInputHardwareCallback, tvInputInfo, n2);
            }

            @Override
            public void releaseTvInputHardware(int n, ITvInputHardware iTvInputHardware, int n2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("releaseTvInputHardware", $$robo$$android_media_tv_ITvInputManager_Stub_Proxy$releaseTvInputHardware(int android.media.tv.ITvInputHardware int ), 0, this, n, iTvInputHardware, n2);
            }

            @Override
            public List<TvStreamConfig> getAvailableTvStreamConfigList(String string2, int n) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getAvailableTvStreamConfigList", $$robo$$android_media_tv_ITvInputManager_Stub_Proxy$getAvailableTvStreamConfigList(java.lang.String int ), 0, this, string2, n);
            }

            @Override
            public boolean captureFrame(String string2, Surface surface, TvStreamConfig tvStreamConfig, int n) throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("captureFrame", $$robo$$android_media_tv_ITvInputManager_Stub_Proxy$captureFrame(java.lang.String android.view.Surface android.media.tv.TvStreamConfig int ), 0, this, string2, surface, tvStreamConfig, n);
            }

            @Override
            public boolean isSingleSessionActive(int n) throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("isSingleSessionActive", $$robo$$android_media_tv_ITvInputManager_Stub_Proxy$isSingleSessionActive(int ), 0, this, n);
            }

            public /* synthetic */ Proxy() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Proxy)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }
}

