/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv;

import android.content.Context;
import android.graphics.Rect;
import android.media.tv.ITvInputSession;
import android.media.tv.TvInputService;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import android.view.InputChannel;
import android.view.InputEvent;
import android.view.InputEventReceiver;
import android.view.Surface;
import com.android.internal.os.HandlerCaller;
import com.android.internal.os.SomeArgs;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.invoke.CallSite;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ITvInputSessionWrapper
extends ITvInputSession.Stub
implements HandlerCaller.Callback,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "TvInputSessionWrapper";
    private static int MESSAGE_HANDLING_DURATION_THRESHOLD_MILLIS = 50;
    private static int DO_RELEASE = 1;
    private static int DO_SET_MAIN = 2;
    private static int DO_SET_SURFACE = 3;
    private static int DO_DISPATCH_SURFACE_CHANGED = 4;
    private static int DO_SET_STREAM_VOLUME = 5;
    private static int DO_TUNE = 6;
    private static int DO_SET_CAPTION_ENABLED = 7;
    private static int DO_SELECT_TRACK = 8;
    private static int DO_APP_PRIVATE_COMMAND = 9;
    private static int DO_CREATE_OVERLAY_VIEW = 10;
    private static int DO_RELAYOUT_OVERLAY_VIEW = 11;
    private static int DO_REMOVE_OVERLAY_VIEW = 12;
    private static int DO_REQUEST_UNBLOCK_CONTENT = 13;
    private HandlerCaller mCaller;
    private TvInputService.Session mTvInputSessionImpl;
    private InputChannel mChannel;
    private TvInputEventReceiver mReceiver;

    private void $$robo$$android_media_tv_ITvInputSessionWrapper$__constructor__(Context context, TvInputService.Session sessionImpl, InputChannel channel) {
        this.mCaller = new HandlerCaller(context, null, this, true);
        this.mTvInputSessionImpl = sessionImpl;
        this.mChannel = channel;
        if (channel != null) {
            this.mReceiver = new TvInputEventReceiver(this, channel, context.getMainLooper());
        }
    }

    private final void $$robo$$android_media_tv_ITvInputSessionWrapper$executeMessage(Message msg) {
        reference var4_9;
        if (this.mTvInputSessionImpl == null) {
            return;
        }
        CallSite startTime = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        switch (msg.what) {
            case 1: {
                this.mTvInputSessionImpl.release();
                this.mTvInputSessionImpl = null;
                if (this.mReceiver != null) {
                    this.mReceiver.dispose();
                    this.mReceiver = null;
                }
                if (this.mChannel == null) break;
                this.mChannel.dispose();
                this.mChannel = null;
                break;
            }
            case 2: {
                this.mTvInputSessionImpl.setMain((Boolean)msg.obj);
                break;
            }
            case 3: {
                this.mTvInputSessionImpl.setSurface((Surface)msg.obj);
                break;
            }
            case 4: {
                SomeArgs someArgs = (SomeArgs)msg.obj;
                this.mTvInputSessionImpl.dispatchSurfaceChanged(someArgs.argi1, someArgs.argi2, someArgs.argi3);
                someArgs.recycle();
                break;
            }
            case 5: {
                this.mTvInputSessionImpl.setStreamVolume(((Float)msg.obj).floatValue());
                break;
            }
            case 6: {
                SomeArgs someArgs = (SomeArgs)msg.obj;
                this.mTvInputSessionImpl.tune((Uri)someArgs.arg1, (Bundle)someArgs.arg2);
                someArgs.recycle();
                break;
            }
            case 7: {
                this.mTvInputSessionImpl.setCaptionEnabled((Boolean)msg.obj);
                break;
            }
            case 8: {
                SomeArgs someArgs = (SomeArgs)msg.obj;
                this.mTvInputSessionImpl.selectTrack((Integer)someArgs.arg1, (String)someArgs.arg2);
                someArgs.recycle();
                break;
            }
            case 9: {
                SomeArgs someArgs = (SomeArgs)msg.obj;
                this.mTvInputSessionImpl.appPrivateCommand((String)someArgs.arg1, (Bundle)someArgs.arg2);
                someArgs.recycle();
                break;
            }
            case 10: {
                SomeArgs someArgs = (SomeArgs)msg.obj;
                this.mTvInputSessionImpl.createOverlayView((IBinder)someArgs.arg1, (Rect)someArgs.arg2);
                someArgs.recycle();
                break;
            }
            case 11: {
                this.mTvInputSessionImpl.relayoutOverlayView((Rect)msg.obj);
                break;
            }
            case 12: {
                this.mTvInputSessionImpl.removeOverlayView(true);
                break;
            }
            case 13: {
                this.mTvInputSessionImpl.unblockContent((String)msg.obj);
                break;
            }
            default: {
                Log.w("TvInputSessionWrapper", "Unhandled message code: " + msg.what);
            }
        }
        if ((var4_9 = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System") - startTime) > 50L) {
            Log.w("TvInputSessionWrapper", "Handling message (" + msg.what + ") took too long time (duration=" + (long)var4_9 + "ms)");
        }
    }

    private final void $$robo$$android_media_tv_ITvInputSessionWrapper$release() {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessage(1));
    }

    private final void $$robo$$android_media_tv_ITvInputSessionWrapper$setMain(boolean isMain) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageO(2, isMain));
    }

    private final void $$robo$$android_media_tv_ITvInputSessionWrapper$setSurface(Surface surface) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageO(3, surface));
    }

    private final void $$robo$$android_media_tv_ITvInputSessionWrapper$dispatchSurfaceChanged(int format, int width, int height) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageIIII(4, format, width, height, 0));
    }

    private final void $$robo$$android_media_tv_ITvInputSessionWrapper$setVolume(float volume) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageO(5, Float.valueOf(volume)));
    }

    private final void $$robo$$android_media_tv_ITvInputSessionWrapper$tune(Uri channelUri, Bundle params) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageOO(6, channelUri, params));
    }

    private final void $$robo$$android_media_tv_ITvInputSessionWrapper$setCaptionEnabled(boolean enabled) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageO(7, enabled));
    }

    private final void $$robo$$android_media_tv_ITvInputSessionWrapper$selectTrack(int type, String trackId) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageOO(8, type, trackId));
    }

    private final void $$robo$$android_media_tv_ITvInputSessionWrapper$appPrivateCommand(String action, Bundle data) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageOO(9, action, data));
    }

    private final void $$robo$$android_media_tv_ITvInputSessionWrapper$createOverlayView(IBinder windowToken, Rect frame) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageOO(10, windowToken, frame));
    }

    private final void $$robo$$android_media_tv_ITvInputSessionWrapper$relayoutOverlayView(Rect frame) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageO(11, frame));
    }

    private final void $$robo$$android_media_tv_ITvInputSessionWrapper$removeOverlayView() {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessage(12));
    }

    private final void $$robo$$android_media_tv_ITvInputSessionWrapper$requestUnblockContent(String unblockedRating) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageO(13, unblockedRating));
    }

    private void __constructor__(Context context, TvInputService.Session session, InputChannel inputChannel) {
        this.$$robo$$android_media_tv_ITvInputSessionWrapper$__constructor__(context, session, inputChannel);
    }

    public ITvInputSessionWrapper(Context context, TvInputService.Session session, InputChannel inputChannel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_ITvInputSessionWrapper$__constructor__(android.content.Context android.media.tv.TvInputService$Session android.view.InputChannel ), 0, this, context, session, inputChannel);
    }

    @Override
    public void executeMessage(Message message) {
        InvokeDynamicSupport.bootstrap("executeMessage", $$robo$$android_media_tv_ITvInputSessionWrapper$executeMessage(android.os.Message ), 0, this, message);
    }

    @Override
    public void release() {
        InvokeDynamicSupport.bootstrap("release", $$robo$$android_media_tv_ITvInputSessionWrapper$release(), 0, this);
    }

    @Override
    public void setMain(boolean bl) {
        InvokeDynamicSupport.bootstrap("setMain", $$robo$$android_media_tv_ITvInputSessionWrapper$setMain(boolean ), 0, this, bl);
    }

    @Override
    public void setSurface(Surface surface) {
        InvokeDynamicSupport.bootstrap("setSurface", $$robo$$android_media_tv_ITvInputSessionWrapper$setSurface(android.view.Surface ), 0, this, surface);
    }

    @Override
    public void dispatchSurfaceChanged(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("dispatchSurfaceChanged", $$robo$$android_media_tv_ITvInputSessionWrapper$dispatchSurfaceChanged(int int int ), 0, this, n, n2, n3);
    }

    @Override
    public void setVolume(float f) {
        InvokeDynamicSupport.bootstrap("setVolume", $$robo$$android_media_tv_ITvInputSessionWrapper$setVolume(float ), 0, this, f);
    }

    @Override
    public void tune(Uri uri, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("tune", $$robo$$android_media_tv_ITvInputSessionWrapper$tune(android.net.Uri android.os.Bundle ), 0, this, uri, bundle);
    }

    @Override
    public void setCaptionEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setCaptionEnabled", $$robo$$android_media_tv_ITvInputSessionWrapper$setCaptionEnabled(boolean ), 0, this, bl);
    }

    @Override
    public void selectTrack(int n, String string2) {
        InvokeDynamicSupport.bootstrap("selectTrack", $$robo$$android_media_tv_ITvInputSessionWrapper$selectTrack(int java.lang.String ), 0, this, n, string2);
    }

    @Override
    public void appPrivateCommand(String string2, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("appPrivateCommand", $$robo$$android_media_tv_ITvInputSessionWrapper$appPrivateCommand(java.lang.String android.os.Bundle ), 0, this, string2, bundle);
    }

    @Override
    public void createOverlayView(IBinder iBinder, Rect rect) {
        InvokeDynamicSupport.bootstrap("createOverlayView", $$robo$$android_media_tv_ITvInputSessionWrapper$createOverlayView(android.os.IBinder android.graphics.Rect ), 0, this, iBinder, rect);
    }

    @Override
    public void relayoutOverlayView(Rect rect) {
        InvokeDynamicSupport.bootstrap("relayoutOverlayView", $$robo$$android_media_tv_ITvInputSessionWrapper$relayoutOverlayView(android.graphics.Rect ), 0, this, rect);
    }

    @Override
    public void removeOverlayView() {
        InvokeDynamicSupport.bootstrap("removeOverlayView", $$robo$$android_media_tv_ITvInputSessionWrapper$removeOverlayView(), 0, this);
    }

    @Override
    public void requestUnblockContent(String string2) {
        InvokeDynamicSupport.bootstrap("requestUnblockContent", $$robo$$android_media_tv_ITvInputSessionWrapper$requestUnblockContent(java.lang.String ), 0, this, string2);
    }

    public /* synthetic */ ITvInputSessionWrapper() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ITvInputSessionWrapper)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class TvInputEventReceiver
    extends InputEventReceiver
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ ITvInputSessionWrapper this$0;

        private void $$robo$$android_media_tv_ITvInputSessionWrapper_TvInputEventReceiver$__constructor__(ITvInputSessionWrapper iTvInputSessionWrapper, InputChannel inputChannel, Looper looper) {
        }

        private final void $$robo$$android_media_tv_ITvInputSessionWrapper_TvInputEventReceiver$onInputEvent(InputEvent event) {
            if (this.this$0.mTvInputSessionImpl == null) {
                this.finishInputEvent(event, false);
                return;
            }
            int handled = this.this$0.mTvInputSessionImpl.dispatchInputEvent(event, this);
            if (handled != -1) {
                this.finishInputEvent(event, handled == 1);
            }
        }

        private void __constructor__(ITvInputSessionWrapper iTvInputSessionWrapper, InputChannel inputChannel, Looper looper) {
            this.$$robo$$android_media_tv_ITvInputSessionWrapper_TvInputEventReceiver$__constructor__(iTvInputSessionWrapper, inputChannel, looper);
        }

        public TvInputEventReceiver(ITvInputSessionWrapper iTvInputSessionWrapper, InputChannel inputChannel, Looper looper) {
            this.this$0 = iTvInputSessionWrapper;
            super(inputChannel, looper);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_ITvInputSessionWrapper_TvInputEventReceiver$__constructor__(android.media.tv.ITvInputSessionWrapper android.view.InputChannel android.os.Looper ), 0, this, iTvInputSessionWrapper, inputChannel, looper);
        }

        @Override
        public void onInputEvent(InputEvent inputEvent) {
            InvokeDynamicSupport.bootstrap("onInputEvent", $$robo$$android_media_tv_ITvInputSessionWrapper_TvInputEventReceiver$onInputEvent(android.view.InputEvent ), 0, this, inputEvent);
        }

        public /* synthetic */ TvInputEventReceiver() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TvInputEventReceiver)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

