/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.drawable.Drawable;
import android.hardware.hdmi.HdmiDeviceInfo;
import android.media.tv.TvInputHardwareInfo;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.UserHandle;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseIntArray;
import android.util.Xml;
import com.android.internal.R;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParserException;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class TvInputInfo
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static boolean DEBUG = false;
    private static String TAG = "TvInputInfo";
    public static int TYPE_TUNER = 0;
    public static int TYPE_OTHER = 1000;
    public static int TYPE_COMPOSITE = 1001;
    public static int TYPE_SVIDEO = 1002;
    public static int TYPE_SCART = 1003;
    public static int TYPE_COMPONENT = 1004;
    public static int TYPE_VGA = 1005;
    public static int TYPE_DVI = 1006;
    public static int TYPE_HDMI = 1007;
    public static int TYPE_DISPLAY_PORT = 1008;
    public static String EXTRA_INPUT_ID = "android.media.tv.extra.INPUT_ID";
    private static SparseIntArray sHardwareTypeToTvInputType;
    private static String XML_START_TAG_NAME = "tv-input";
    private static String DELIMITER_INFO_IN_ID = "/";
    private static String PREFIX_HDMI_DEVICE = "HDMI";
    private static String PREFIX_HARDWARE_DEVICE = "HW";
    private static int LENGTH_HDMI_PHYSICAL_ADDRESS = 4;
    private static int LENGTH_HDMI_DEVICE_ID = 2;
    private ResolveInfo mService;
    private String mId;
    private String mParentId;
    private String mSetupActivity;
    private String mSettingsActivity;
    private int mType;
    private HdmiDeviceInfo mHdmiDeviceInfo;
    private String mLabel;
    private Uri mIconUri;
    private boolean mIsConnectedToHdmiSwitch;
    public static Parcelable.Creator<TvInputInfo> CREATOR;

    private static final TvInputInfo $$robo$$android_media_tv_TvInputInfo$createTvInputInfo(Context context, ResolveInfo service) throws XmlPullParserException, IOException {
        return TvInputInfo.createTvInputInfo(context, service, TvInputInfo.generateInputIdForComponentName(new ComponentName(service.serviceInfo.packageName, service.serviceInfo.name)), null, 0, null, null, false);
    }

    private static final TvInputInfo $$robo$$android_media_tv_TvInputInfo$createTvInputInfo(Context context, ResolveInfo service, HdmiDeviceInfo hdmiDeviceInfo, String parentId, String label, Uri iconUri) throws XmlPullParserException, IOException {
        boolean isConnectedToHdmiSwitch = (hdmiDeviceInfo.getPhysicalAddress() & 0xFFF) != 0;
        TvInputInfo input = TvInputInfo.createTvInputInfo(context, service, TvInputInfo.generateInputIdForHdmiDevice(new ComponentName(service.serviceInfo.packageName, service.serviceInfo.name), hdmiDeviceInfo), parentId, 1007, label, iconUri, isConnectedToHdmiSwitch);
        input.mHdmiDeviceInfo = hdmiDeviceInfo;
        return input;
    }

    private static final TvInputInfo $$robo$$android_media_tv_TvInputInfo$createTvInputInfo(Context context, ResolveInfo service, TvInputHardwareInfo hardwareInfo, String label, Uri iconUri) throws XmlPullParserException, IOException {
        int inputType = sHardwareTypeToTvInputType.get(hardwareInfo.getType(), 0);
        return TvInputInfo.createTvInputInfo(context, service, TvInputInfo.generateInputIdForHardware(new ComponentName(service.serviceInfo.packageName, service.serviceInfo.name), hardwareInfo), null, inputType, label, iconUri, false);
    }

    private static final TvInputInfo $$robo$$android_media_tv_TvInputInfo$createTvInputInfo(Context context, ResolveInfo service, String id2, String parentId, int inputType, String label, Uri iconUri, boolean isConnectedToHdmiSwitch) throws XmlPullParserException, IOException {
        ServiceInfo si = service.serviceInfo;
        PackageManager pm = context.getPackageManager();
        try (XmlResourceParser parser = null;){
            int type;
            parser = si.loadXmlMetaData(pm, "android.media.tv.input");
            if (parser == null) {
                throw new XmlPullParserException("No android.media.tv.input meta-data for " + si.name);
            }
            Resources res = pm.getResourcesForApplication(si.applicationInfo);
            AttributeSet attrs = Xml.asAttributeSet(parser);
            while ((type = parser.next()) != 1 && type != 2) {
            }
            String nodeName = parser.getName();
            if (!"tv-input".equals(nodeName)) {
                throw new XmlPullParserException("Meta-data does not start with tv-input-service tag in " + si.name);
            }
            TvInputInfo input = new TvInputInfo(service, id2, parentId, inputType);
            TypedArray sa = res.obtainAttributes(attrs, R.styleable.TvInputService);
            input.mSetupActivity = sa.getString(1);
            input.mSettingsActivity = sa.getString(0);
            sa.recycle();
            input.mLabel = label;
            input.mIconUri = iconUri;
            input.mIsConnectedToHdmiSwitch = isConnectedToHdmiSwitch;
            TvInputInfo tvInputInfo = input;
            return tvInputInfo;
        }
    }

    private void $$robo$$android_media_tv_TvInputInfo$__constructor__(ResolveInfo service, String id2, String parentId, int type) {
        this.mType = 0;
        this.mService = service;
        this.mId = id2;
        this.mParentId = parentId;
        this.mType = type;
    }

    private final String $$robo$$android_media_tv_TvInputInfo$getId() {
        return this.mId;
    }

    private final String $$robo$$android_media_tv_TvInputInfo$getParentId() {
        return this.mParentId;
    }

    private final ServiceInfo $$robo$$android_media_tv_TvInputInfo$getServiceInfo() {
        return this.mService.serviceInfo;
    }

    private final ComponentName $$robo$$android_media_tv_TvInputInfo$getComponent() {
        return new ComponentName(this.mService.serviceInfo.packageName, this.mService.serviceInfo.name);
    }

    private final Intent $$robo$$android_media_tv_TvInputInfo$createSetupIntent() {
        if (!TextUtils.isEmpty(this.mSetupActivity)) {
            Intent intent = new Intent("android.intent.action.MAIN");
            intent.setClassName(this.mService.serviceInfo.packageName, this.mSetupActivity);
            intent.putExtra("android.media.tv.extra.INPUT_ID", this.getId());
            return intent;
        }
        return null;
    }

    private final Intent $$robo$$android_media_tv_TvInputInfo$createSettingsIntent() {
        if (!TextUtils.isEmpty(this.mSettingsActivity)) {
            Intent intent = new Intent("android.intent.action.MAIN");
            intent.setClassName(this.mService.serviceInfo.packageName, this.mSettingsActivity);
            intent.putExtra("android.media.tv.extra.INPUT_ID", this.getId());
            return intent;
        }
        return null;
    }

    private final int $$robo$$android_media_tv_TvInputInfo$getType() {
        return this.mType;
    }

    private final HdmiDeviceInfo $$robo$$android_media_tv_TvInputInfo$getHdmiDeviceInfo() {
        if (this.mType == 1007) {
            return this.mHdmiDeviceInfo;
        }
        return null;
    }

    private final boolean $$robo$$android_media_tv_TvInputInfo$isPassthroughInput() {
        return this.mType != 0;
    }

    private final boolean $$robo$$android_media_tv_TvInputInfo$isConnectedToHdmiSwitch() {
        return this.mIsConnectedToHdmiSwitch;
    }

    private final boolean $$robo$$android_media_tv_TvInputInfo$isHidden(Context context) {
        return TvInputSettings.isHidden(context, this.mId, UserHandle.myUserId());
    }

    private final CharSequence $$robo$$android_media_tv_TvInputInfo$loadLabel(Context context) {
        if (TextUtils.isEmpty(this.mLabel)) {
            return this.mService.loadLabel(context.getPackageManager());
        }
        return this.mLabel;
    }

    private final CharSequence $$robo$$android_media_tv_TvInputInfo$loadCustomLabel(Context context) {
        return TvInputSettings.getCustomLabel(context, this.mId, UserHandle.myUserId());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Drawable $$robo$$android_media_tv_TvInputInfo$loadIcon(Context context) {
        if (this.mIconUri == null) {
            return this.loadServiceIcon(context);
        }
        try (InputStream is = context.getContentResolver().openInputStream(this.mIconUri);){
            Drawable drawable3 = Drawable.createFromStream(is, null);
            if (drawable3 == null) {
                Drawable drawable4 = this.loadServiceIcon(context);
                return drawable4;
            }
            Drawable drawable2 = drawable3;
            return drawable2;
        }
        catch (IOException e) {
            Log.w("TvInputInfo", "Loading the default icon due to a failure on loading " + this.mIconUri, e);
            return this.loadServiceIcon(context);
        }
    }

    private final int $$robo$$android_media_tv_TvInputInfo$describeContents() {
        return 0;
    }

    private final int $$robo$$android_media_tv_TvInputInfo$hashCode() {
        return this.mId.hashCode();
    }

    private final boolean $$robo$$android_media_tv_TvInputInfo$equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TvInputInfo)) {
            return false;
        }
        TvInputInfo obj = (TvInputInfo)o;
        return this.mId.equals(obj.mId);
    }

    private final String $$robo$$android_media_tv_TvInputInfo$toString() {
        return "TvInputInfo{id=" + this.mId + ", pkg=" + this.mService.serviceInfo.packageName + ", service=" + this.mService.serviceInfo.name + "}";
    }

    private final void $$robo$$android_media_tv_TvInputInfo$writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mId);
        dest.writeString(this.mParentId);
        this.mService.writeToParcel(dest, flags);
        dest.writeString(this.mSetupActivity);
        dest.writeString(this.mSettingsActivity);
        dest.writeInt(this.mType);
        dest.writeParcelable(this.mHdmiDeviceInfo, flags);
        dest.writeParcelable(this.mIconUri, flags);
        dest.writeString(this.mLabel);
        dest.writeByte(this.mIsConnectedToHdmiSwitch ? (byte)1 : 0);
    }

    private final Drawable $$robo$$android_media_tv_TvInputInfo$loadServiceIcon(Context context) {
        if (this.mService.serviceInfo.icon == 0 && this.mService.serviceInfo.applicationInfo.icon == 0) {
            return null;
        }
        return this.mService.serviceInfo.loadIcon(context.getPackageManager());
    }

    private static final String $$robo$$android_media_tv_TvInputInfo$generateInputIdForComponentName(ComponentName name) {
        return name.flattenToShortString();
    }

    private static final String $$robo$$android_media_tv_TvInputInfo$generateInputIdForHdmiDevice(ComponentName name, HdmiDeviceInfo deviceInfo) {
        String format = String.format("%s%s%%0%sX%%0%sX", "/", "HDMI", 4, 2);
        return name.flattenToShortString() + String.format(format, deviceInfo.getPhysicalAddress(), deviceInfo.getId());
    }

    private static final String $$robo$$android_media_tv_TvInputInfo$generateInputIdForHardware(ComponentName name, TvInputHardwareInfo hardwareInfo) {
        return name.flattenToShortString() + String.format("%s%s%d", "/", "HW", hardwareInfo.getDeviceId());
    }

    private void $$robo$$android_media_tv_TvInputInfo$__constructor__(Parcel in) {
        this.mType = 0;
        this.mId = in.readString();
        this.mParentId = in.readString();
        this.mService = ResolveInfo.CREATOR.createFromParcel(in);
        this.mSetupActivity = in.readString();
        this.mSettingsActivity = in.readString();
        this.mType = in.readInt();
        this.mHdmiDeviceInfo = (HdmiDeviceInfo)in.readParcelable(null);
        this.mIconUri = (Uri)in.readParcelable(null);
        this.mLabel = in.readString();
        this.mIsConnectedToHdmiSwitch = in.readByte() == 1;
    }

    private /* synthetic */ void $$robo$$android_media_tv_TvInputInfo$__constructor__(Parcel x0, 1 x1) {
    }

    static void __staticInitializer__() {
        sHardwareTypeToTvInputType = new SparseIntArray();
        sHardwareTypeToTvInputType.put(1, 1000);
        sHardwareTypeToTvInputType.put(2, 0);
        sHardwareTypeToTvInputType.put(3, 1001);
        sHardwareTypeToTvInputType.put(4, 1002);
        sHardwareTypeToTvInputType.put(5, 1003);
        sHardwareTypeToTvInputType.put(6, 1004);
        sHardwareTypeToTvInputType.put(7, 1005);
        sHardwareTypeToTvInputType.put(8, 1006);
        sHardwareTypeToTvInputType.put(9, 1007);
        sHardwareTypeToTvInputType.put(10, 1008);
        CREATOR = new Parcelable.Creator<TvInputInfo>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_media_tv_TvInputInfo_1$__constructor__() {
            }

            private final TvInputInfo $$robo$$android_media_tv_TvInputInfo_1$createFromParcel(Parcel in) {
                return new TvInputInfo(in);
            }

            private final TvInputInfo[] $$robo$$android_media_tv_TvInputInfo_1$newArray(int size) {
                return new TvInputInfo[size];
            }

            private void __constructor__() {
                this.$$robo$$android_media_tv_TvInputInfo_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputInfo_1$__constructor__(), 0, this);
            }

            @Override
            public TvInputInfo createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_media_tv_TvInputInfo_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public TvInputInfo[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_media_tv_TvInputInfo_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    public static TvInputInfo createTvInputInfo(Context context, ResolveInfo resolveInfo) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("createTvInputInfo", $$robo$$android_media_tv_TvInputInfo$createTvInputInfo(android.content.Context android.content.pm.ResolveInfo ), 0, (Context)context, (ResolveInfo)resolveInfo);
    }

    public static TvInputInfo createTvInputInfo(Context context, ResolveInfo resolveInfo, HdmiDeviceInfo hdmiDeviceInfo, String string2, String string3, Uri uri) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("createTvInputInfo", $$robo$$android_media_tv_TvInputInfo$createTvInputInfo(android.content.Context android.content.pm.ResolveInfo android.hardware.hdmi.HdmiDeviceInfo java.lang.String java.lang.String android.net.Uri ), 0, (Context)context, (ResolveInfo)resolveInfo, (HdmiDeviceInfo)hdmiDeviceInfo, (String)string2, (String)string3, (Uri)uri);
    }

    public static TvInputInfo createTvInputInfo(Context context, ResolveInfo resolveInfo, TvInputHardwareInfo tvInputHardwareInfo, String string2, Uri uri) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("createTvInputInfo", $$robo$$android_media_tv_TvInputInfo$createTvInputInfo(android.content.Context android.content.pm.ResolveInfo android.media.tv.TvInputHardwareInfo java.lang.String android.net.Uri ), 0, (Context)context, (ResolveInfo)resolveInfo, (TvInputHardwareInfo)tvInputHardwareInfo, (String)string2, (Uri)uri);
    }

    private static TvInputInfo createTvInputInfo(Context context, ResolveInfo resolveInfo, String string2, String string3, int n, String string4, Uri uri, boolean bl) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("createTvInputInfo", $$robo$$android_media_tv_TvInputInfo$createTvInputInfo(android.content.Context android.content.pm.ResolveInfo java.lang.String java.lang.String int java.lang.String android.net.Uri boolean ), 0, (Context)context, (ResolveInfo)resolveInfo, (String)string2, (String)string3, (int)n, (String)string4, (Uri)uri, (boolean)bl);
    }

    private void __constructor__(ResolveInfo resolveInfo, String string2, String string3, int n) {
        this.$$robo$$android_media_tv_TvInputInfo$__constructor__(resolveInfo, string2, string3, n);
    }

    private TvInputInfo(ResolveInfo resolveInfo, String string2, String string3, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputInfo$__constructor__(android.content.pm.ResolveInfo java.lang.String java.lang.String int ), 0, this, resolveInfo, string2, string3, n);
    }

    public String getId() {
        return InvokeDynamicSupport.bootstrap("getId", $$robo$$android_media_tv_TvInputInfo$getId(), 0, this);
    }

    public String getParentId() {
        return InvokeDynamicSupport.bootstrap("getParentId", $$robo$$android_media_tv_TvInputInfo$getParentId(), 0, this);
    }

    public ServiceInfo getServiceInfo() {
        return InvokeDynamicSupport.bootstrap("getServiceInfo", $$robo$$android_media_tv_TvInputInfo$getServiceInfo(), 0, this);
    }

    public ComponentName getComponent() {
        return InvokeDynamicSupport.bootstrap("getComponent", $$robo$$android_media_tv_TvInputInfo$getComponent(), 0, this);
    }

    public Intent createSetupIntent() {
        return InvokeDynamicSupport.bootstrap("createSetupIntent", $$robo$$android_media_tv_TvInputInfo$createSetupIntent(), 0, this);
    }

    public Intent createSettingsIntent() {
        return InvokeDynamicSupport.bootstrap("createSettingsIntent", $$robo$$android_media_tv_TvInputInfo$createSettingsIntent(), 0, this);
    }

    public int getType() {
        return (int)InvokeDynamicSupport.bootstrap("getType", $$robo$$android_media_tv_TvInputInfo$getType(), 0, this);
    }

    public HdmiDeviceInfo getHdmiDeviceInfo() {
        return InvokeDynamicSupport.bootstrap("getHdmiDeviceInfo", $$robo$$android_media_tv_TvInputInfo$getHdmiDeviceInfo(), 0, this);
    }

    public boolean isPassthroughInput() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPassthroughInput", $$robo$$android_media_tv_TvInputInfo$isPassthroughInput(), 0, this);
    }

    public boolean isConnectedToHdmiSwitch() {
        return (boolean)InvokeDynamicSupport.bootstrap("isConnectedToHdmiSwitch", $$robo$$android_media_tv_TvInputInfo$isConnectedToHdmiSwitch(), 0, this);
    }

    public boolean isHidden(Context context) {
        return (boolean)InvokeDynamicSupport.bootstrap("isHidden", $$robo$$android_media_tv_TvInputInfo$isHidden(android.content.Context ), 0, this, context);
    }

    public CharSequence loadLabel(Context context) {
        return InvokeDynamicSupport.bootstrap("loadLabel", $$robo$$android_media_tv_TvInputInfo$loadLabel(android.content.Context ), 0, this, context);
    }

    public CharSequence loadCustomLabel(Context context) {
        return InvokeDynamicSupport.bootstrap("loadCustomLabel", $$robo$$android_media_tv_TvInputInfo$loadCustomLabel(android.content.Context ), 0, this, context);
    }

    public Drawable loadIcon(Context context) {
        return InvokeDynamicSupport.bootstrap("loadIcon", $$robo$$android_media_tv_TvInputInfo$loadIcon(android.content.Context ), 0, this, context);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_media_tv_TvInputInfo$describeContents(), 0, this);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_media_tv_TvInputInfo$hashCode(), 0, this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_media_tv_TvInputInfo$equals(java.lang.Object ), 0, this, object);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_media_tv_TvInputInfo$toString(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_media_tv_TvInputInfo$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    private Drawable loadServiceIcon(Context context) {
        return InvokeDynamicSupport.bootstrap("loadServiceIcon", $$robo$$android_media_tv_TvInputInfo$loadServiceIcon(android.content.Context ), 0, this, context);
    }

    private static String generateInputIdForComponentName(ComponentName componentName) {
        return InvokeDynamicSupport.bootstrapStatic("generateInputIdForComponentName", $$robo$$android_media_tv_TvInputInfo$generateInputIdForComponentName(android.content.ComponentName ), 0, (ComponentName)componentName);
    }

    private static String generateInputIdForHdmiDevice(ComponentName componentName, HdmiDeviceInfo hdmiDeviceInfo) {
        return InvokeDynamicSupport.bootstrapStatic("generateInputIdForHdmiDevice", $$robo$$android_media_tv_TvInputInfo$generateInputIdForHdmiDevice(android.content.ComponentName android.hardware.hdmi.HdmiDeviceInfo ), 0, (ComponentName)componentName, (HdmiDeviceInfo)hdmiDeviceInfo);
    }

    private static String generateInputIdForHardware(ComponentName componentName, TvInputHardwareInfo tvInputHardwareInfo) {
        return InvokeDynamicSupport.bootstrapStatic("generateInputIdForHardware", $$robo$$android_media_tv_TvInputInfo$generateInputIdForHardware(android.content.ComponentName android.media.tv.TvInputHardwareInfo ), 0, (ComponentName)componentName, (TvInputHardwareInfo)tvInputHardwareInfo);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_media_tv_TvInputInfo$__constructor__(parcel);
    }

    private TvInputInfo(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputInfo$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
        this.$$robo$$android_media_tv_TvInputInfo$__constructor__(parcel, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(TvInputInfo.class);
    }

    public /* synthetic */ TvInputInfo() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TvInputInfo)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class TvInputSettings
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static String TV_INPUT_SEPARATOR = ":";
        private static String CUSTOM_NAME_SEPARATOR = ",";

        private void $$robo$$android_media_tv_TvInputInfo_TvInputSettings$__constructor__() {
        }

        private static final boolean $$robo$$android_media_tv_TvInputInfo_TvInputSettings$isHidden(Context context, String inputId, int userId) {
            return TvInputSettings.getHiddenTvInputIds(context, userId).contains(inputId);
        }

        private static final String $$robo$$android_media_tv_TvInputInfo_TvInputSettings$getCustomLabel(Context context, String inputId, int userId) {
            return TvInputSettings.getCustomLabels(context, userId).get(inputId);
        }

        private static final Set<String> $$robo$$android_media_tv_TvInputInfo_TvInputSettings$getHiddenTvInputIds(Context context, int userId) {
            String[] ids;
            String hiddenIdsString = Settings.Secure.getStringForUser(context.getContentResolver(), "tv_input_hidden_inputs", userId);
            HashSet<String> set = new HashSet<String>();
            if (TextUtils.isEmpty(hiddenIdsString)) {
                return set;
            }
            for (String id2 : ids = hiddenIdsString.split(":")) {
                set.add(Uri.decode(id2));
            }
            return set;
        }

        private static final Map<String, String> $$robo$$android_media_tv_TvInputInfo_TvInputSettings$getCustomLabels(Context context, int userId) {
            String[] pairs;
            String labelsString = Settings.Secure.getStringForUser(context.getContentResolver(), "tv_input_custom_labels", userId);
            HashMap<String, String> map = new HashMap<String, String>();
            if (TextUtils.isEmpty(labelsString)) {
                return map;
            }
            for (String pairString : pairs = labelsString.split(":")) {
                String[] pair = pairString.split(",");
                map.put(Uri.decode(pair[0]), Uri.decode(pair[1]));
            }
            return map;
        }

        private static final void $$robo$$android_media_tv_TvInputInfo_TvInputSettings$putHiddenTvInputs(Context context, Set<String> hiddenInputIds, int userId) {
            StringBuilder builder = new StringBuilder();
            boolean firstItem = true;
            for (String inputId : hiddenInputIds) {
                TvInputSettings.ensureValidField(inputId);
                if (firstItem) {
                    firstItem = false;
                } else {
                    builder.append(":");
                }
                builder.append(Uri.encode(inputId));
            }
            Settings.Secure.putStringForUser(context.getContentResolver(), "tv_input_hidden_inputs", builder.toString(), userId);
        }

        private static final void $$robo$$android_media_tv_TvInputInfo_TvInputSettings$putCustomLabels(Context context, Map<String, String> customLabels, int userId) {
            StringBuilder builder = new StringBuilder();
            boolean firstItem = true;
            for (Map.Entry<String, String> entry : customLabels.entrySet()) {
                TvInputSettings.ensureValidField(entry.getKey());
                TvInputSettings.ensureValidField(entry.getValue());
                if (firstItem) {
                    firstItem = false;
                } else {
                    builder.append(":");
                }
                builder.append(Uri.encode(entry.getKey()));
                builder.append(",");
                builder.append(Uri.encode(entry.getValue()));
            }
            Settings.Secure.putStringForUser(context.getContentResolver(), "tv_input_custom_labels", builder.toString(), userId);
        }

        private static final void $$robo$$android_media_tv_TvInputInfo_TvInputSettings$ensureValidField(String value) {
            if (TextUtils.isEmpty(value)) {
                throw new IllegalArgumentException(value + " should not empty ");
            }
        }

        private void __constructor__() {
            this.$$robo$$android_media_tv_TvInputInfo_TvInputSettings$__constructor__();
        }

        private TvInputSettings() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvInputInfo_TvInputSettings$__constructor__(), 0, this);
        }

        private static boolean isHidden(Context context, String string2, int n) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("isHidden", $$robo$$android_media_tv_TvInputInfo_TvInputSettings$isHidden(android.content.Context java.lang.String int ), 0, (Context)context, (String)string2, (int)n);
        }

        private static String getCustomLabel(Context context, String string2, int n) {
            return InvokeDynamicSupport.bootstrapStatic("getCustomLabel", $$robo$$android_media_tv_TvInputInfo_TvInputSettings$getCustomLabel(android.content.Context java.lang.String int ), 0, (Context)context, (String)string2, (int)n);
        }

        public static Set<String> getHiddenTvInputIds(Context context, int n) {
            return InvokeDynamicSupport.bootstrapStatic("getHiddenTvInputIds", $$robo$$android_media_tv_TvInputInfo_TvInputSettings$getHiddenTvInputIds(android.content.Context int ), 0, (Context)context, (int)n);
        }

        public static Map<String, String> getCustomLabels(Context context, int n) {
            return InvokeDynamicSupport.bootstrapStatic("getCustomLabels", $$robo$$android_media_tv_TvInputInfo_TvInputSettings$getCustomLabels(android.content.Context int ), 0, (Context)context, (int)n);
        }

        public static void putHiddenTvInputs(Context context, Set<String> set, int n) {
            InvokeDynamicSupport.bootstrapStatic("putHiddenTvInputs", $$robo$$android_media_tv_TvInputInfo_TvInputSettings$putHiddenTvInputs(android.content.Context java.util.Set<java.lang.String> int ), 0, (Context)context, set, (int)n);
        }

        public static void putCustomLabels(Context context, Map<String, String> map, int n) {
            InvokeDynamicSupport.bootstrapStatic("putCustomLabels", $$robo$$android_media_tv_TvInputInfo_TvInputSettings$putCustomLabels(android.content.Context java.util.Map<java.lang.String, java.lang.String> int ), 0, (Context)context, map, (int)n);
        }

        private static void ensureValidField(String string2) {
            InvokeDynamicSupport.bootstrapStatic("ensureValidField", $$robo$$android_media_tv_TvInputInfo_TvInputSettings$ensureValidField(java.lang.String ), 0, (String)string2);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TvInputSettings)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

