/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.app.PendingIntent;
import android.content.Context;
import android.net.IConnectivityManager;
import android.net.LinkProperties;
import android.net.LinkQualityInfo;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.NetworkMisc;
import android.net.NetworkQuotaInfo;
import android.net.NetworkRequest;
import android.net.NetworkUtils;
import android.net.ProxyInfo;
import android.os.Binder;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.INetworkActivityListener;
import android.os.INetworkManagementService;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.ArrayMap;
import android.util.Log;
import com.android.internal.telephony.ITelephony;
import com.android.internal.util.Preconditions;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import libcore.net.event.NetworkEventDispatcher;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ConnectivityManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "ConnectivityManager";
    private static boolean LEGACY_DBG = true;
    public static String CONNECTIVITY_ACTION = "android.net.conn.CONNECTIVITY_CHANGE";
    public static String CONNECTIVITY_ACTION_IMMEDIATE = "android.net.conn.CONNECTIVITY_CHANGE_IMMEDIATE";
    @Deprecated
    public static String EXTRA_NETWORK_INFO = "networkInfo";
    public static String EXTRA_NETWORK_TYPE = "networkType";
    public static String EXTRA_IS_FAILOVER = "isFailover";
    public static String EXTRA_OTHER_NETWORK_INFO = "otherNetwork";
    public static String EXTRA_NO_CONNECTIVITY = "noConnectivity";
    public static String EXTRA_REASON = "reason";
    public static String EXTRA_EXTRA_INFO = "extraInfo";
    public static String EXTRA_INET_CONDITION = "inetCondition";
    public static String ACTION_DATA_ACTIVITY_CHANGE = "android.net.conn.DATA_ACTIVITY_CHANGE";
    public static String EXTRA_DEVICE_TYPE = "deviceType";
    public static String EXTRA_IS_ACTIVE = "isActive";
    public static String EXTRA_REALTIME_NS = "tsNanos";
    @Deprecated
    public static String ACTION_BACKGROUND_DATA_SETTING_CHANGED = "android.net.conn.BACKGROUND_DATA_SETTING_CHANGED";
    public static String INET_CONDITION_ACTION = "android.net.conn.INET_CONDITION_ACTION";
    public static String ACTION_TETHER_STATE_CHANGED = "android.net.conn.TETHER_STATE_CHANGED";
    public static String EXTRA_AVAILABLE_TETHER = "availableArray";
    public static String EXTRA_ACTIVE_TETHER = "activeArray";
    public static String EXTRA_ERRORED_TETHER = "erroredArray";
    public static String ACTION_CAPTIVE_PORTAL_TEST_COMPLETED = "android.net.conn.CAPTIVE_PORTAL_TEST_COMPLETED";
    public static String EXTRA_IS_CAPTIVE_PORTAL = "captivePortal";
    public static int TYPE_NONE = -1;
    public static int TYPE_MOBILE = 0;
    public static int TYPE_WIFI = 1;
    public static int TYPE_MOBILE_MMS = 2;
    public static int TYPE_MOBILE_SUPL = 3;
    public static int TYPE_MOBILE_DUN = 4;
    public static int TYPE_MOBILE_HIPRI = 5;
    public static int TYPE_WIMAX = 6;
    public static int TYPE_BLUETOOTH = 7;
    public static int TYPE_DUMMY = 8;
    public static int TYPE_ETHERNET = 9;
    public static int TYPE_MOBILE_FOTA = 10;
    public static int TYPE_MOBILE_IMS = 11;
    public static int TYPE_MOBILE_CBS = 12;
    public static int TYPE_WIFI_P2P = 13;
    public static int TYPE_MOBILE_IA = 14;
    public static int TYPE_MOBILE_EMERGENCY = 15;
    public static int TYPE_PROXY = 16;
    public static int TYPE_VPN = 17;
    public static int MAX_RADIO_TYPE = 17;
    public static int MAX_NETWORK_TYPE = 17;
    @Deprecated
    public static int DEFAULT_NETWORK_PREFERENCE = 1;
    public static int CONNECTIVITY_CHANGE_DELAY_DEFAULT = 3000;
    public static int REQUEST_ID_UNSET = 0;
    public static int NETID_UNSET = 0;
    private IConnectivityManager mService;
    private INetworkManagementService mNMService;
    private static HashMap<NetworkCapabilities, LegacyRequest> sLegacyRequests;
    private ArrayMap<OnNetworkActiveListener, INetworkActivityListener> mNetworkActivityListeners;
    public static int TETHER_ERROR_NO_ERROR = 0;
    public static int TETHER_ERROR_UNKNOWN_IFACE = 1;
    public static int TETHER_ERROR_SERVICE_UNAVAIL = 2;
    public static int TETHER_ERROR_UNSUPPORTED = 3;
    public static int TETHER_ERROR_UNAVAIL_IFACE = 4;
    public static int TETHER_ERROR_MASTER_ERROR = 5;
    public static int TETHER_ERROR_TETHER_IFACE_ERROR = 6;
    public static int TETHER_ERROR_UNTETHER_IFACE_ERROR = 7;
    public static int TETHER_ERROR_ENABLE_NAT_ERROR = 8;
    public static int TETHER_ERROR_DISABLE_NAT_ERROR = 9;
    public static int TETHER_ERROR_IFACE_CFG_ERROR = 10;
    private static int BASE = 524288;
    public static int CALLBACK_PRECHECK = 524289;
    public static int CALLBACK_AVAILABLE = 524290;
    public static int CALLBACK_LOSING = 524291;
    public static int CALLBACK_LOST = 524292;
    public static int CALLBACK_UNAVAIL = 524293;
    public static int CALLBACK_CAP_CHANGED = 524294;
    public static int CALLBACK_IP_CHANGED = 524295;
    public static int CALLBACK_RELEASED = 524296;
    public static int CALLBACK_EXIT = 524297;
    private static int EXPIRE_LEGACY_REQUEST = 524298;
    static HashMap<NetworkRequest, NetworkCallback> sNetworkCallback;
    static AtomicInteger sCallbackRefCount;
    static CallbackHandler sCallbackHandler;
    private static int LISTEN = 1;
    private static int REQUEST = 2;
    public static int MAX_NETWORK_REQUEST_TIMEOUT_MS = 6000000;
    public static String EXTRA_NETWORK_REQUEST_NETWORK = "networkRequestNetwork";
    public static String EXTRA_NETWORK_REQUEST_NETWORK_REQUEST = "networkRequestNetworkRequest";

    private static final boolean $$robo$$android_net_ConnectivityManager$isNetworkTypeValid(int networkType) {
        return networkType >= 0 && networkType <= 17;
    }

    private static final String $$robo$$android_net_ConnectivityManager$getNetworkTypeName(int type) {
        switch (type) {
            case 0: {
                return "MOBILE";
            }
            case 1: {
                return "WIFI";
            }
            case 2: {
                return "MOBILE_MMS";
            }
            case 3: {
                return "MOBILE_SUPL";
            }
            case 4: {
                return "MOBILE_DUN";
            }
            case 5: {
                return "MOBILE_HIPRI";
            }
            case 6: {
                return "WIMAX";
            }
            case 7: {
                return "BLUETOOTH";
            }
            case 8: {
                return "DUMMY";
            }
            case 9: {
                return "ETHERNET";
            }
            case 10: {
                return "MOBILE_FOTA";
            }
            case 11: {
                return "MOBILE_IMS";
            }
            case 12: {
                return "MOBILE_CBS";
            }
            case 13: {
                return "WIFI_P2P";
            }
            case 14: {
                return "MOBILE_IA";
            }
            case 15: {
                return "MOBILE_EMERGENCY";
            }
            case 16: {
                return "PROXY";
            }
        }
        return Integer.toString(type);
    }

    private static final boolean $$robo$$android_net_ConnectivityManager$isNetworkTypeMobile(int networkType) {
        switch (networkType) {
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                return true;
            }
        }
        return false;
    }

    private static final boolean $$robo$$android_net_ConnectivityManager$isNetworkTypeWifi(int networkType) {
        switch (networkType) {
            case 1: 
            case 13: {
                return true;
            }
        }
        return false;
    }

    private final void $$robo$$android_net_ConnectivityManager$setNetworkPreference(int preference) {
    }

    private final int $$robo$$android_net_ConnectivityManager$getNetworkPreference() {
        return -1;
    }

    private final NetworkInfo $$robo$$android_net_ConnectivityManager$getActiveNetworkInfo() {
        try {
            return this.mService.getActiveNetworkInfo();
        }
        catch (RemoteException e) {
            return null;
        }
    }

    private final NetworkInfo $$robo$$android_net_ConnectivityManager$getActiveNetworkInfoForUid(int uid) {
        try {
            return this.mService.getActiveNetworkInfoForUid(uid);
        }
        catch (RemoteException e) {
            return null;
        }
    }

    private final NetworkInfo $$robo$$android_net_ConnectivityManager$getNetworkInfo(int networkType) {
        try {
            return this.mService.getNetworkInfo(networkType);
        }
        catch (RemoteException e) {
            return null;
        }
    }

    private final NetworkInfo $$robo$$android_net_ConnectivityManager$getNetworkInfo(Network network) {
        try {
            return this.mService.getNetworkInfoForNetwork(network);
        }
        catch (RemoteException e) {
            return null;
        }
    }

    private final NetworkInfo[] $$robo$$android_net_ConnectivityManager$getAllNetworkInfo() {
        try {
            return this.mService.getAllNetworkInfo();
        }
        catch (RemoteException e) {
            return null;
        }
    }

    private final Network $$robo$$android_net_ConnectivityManager$getNetworkForType(int networkType) {
        try {
            return this.mService.getNetworkForType(networkType);
        }
        catch (RemoteException e) {
            return null;
        }
    }

    private final Network[] $$robo$$android_net_ConnectivityManager$getAllNetworks() {
        try {
            return this.mService.getAllNetworks();
        }
        catch (RemoteException e) {
            return null;
        }
    }

    private final NetworkInfo $$robo$$android_net_ConnectivityManager$getProvisioningOrActiveNetworkInfo() {
        try {
            return this.mService.getProvisioningOrActiveNetworkInfo();
        }
        catch (RemoteException e) {
            return null;
        }
    }

    private final LinkProperties $$robo$$android_net_ConnectivityManager$getActiveLinkProperties() {
        try {
            return this.mService.getActiveLinkProperties();
        }
        catch (RemoteException e) {
            return null;
        }
    }

    private final LinkProperties $$robo$$android_net_ConnectivityManager$getLinkProperties(int networkType) {
        try {
            return this.mService.getLinkPropertiesForType(networkType);
        }
        catch (RemoteException e) {
            return null;
        }
    }

    private final LinkProperties $$robo$$android_net_ConnectivityManager$getLinkProperties(Network network) {
        try {
            return this.mService.getLinkProperties(network);
        }
        catch (RemoteException e) {
            return null;
        }
    }

    private final NetworkCapabilities $$robo$$android_net_ConnectivityManager$getNetworkCapabilities(Network network) {
        try {
            return this.mService.getNetworkCapabilities(network);
        }
        catch (RemoteException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_net_ConnectivityManager$startUsingNetworkFeature(int networkType, String feature) {
        NetworkCapabilities netCap = this.networkCapabilitiesForFeature(networkType, feature);
        if (netCap == null) {
            Log.d("ConnectivityManager", "Can't satisfy startUsingNetworkFeature for " + networkType + ", " + feature);
            return 3;
        }
        NetworkRequest request = null;
        HashMap<NetworkCapabilities, LegacyRequest> hashMap = sLegacyRequests;
        synchronized (hashMap) {
            Log.d("ConnectivityManager", "Looking for legacyRequest for netCap with hash: " + netCap + " (" + netCap.hashCode() + ")");
            Log.d("ConnectivityManager", "sLegacyRequests has:");
            for (NetworkCapabilities nc : sLegacyRequests.keySet()) {
                Log.d("ConnectivityManager", "  " + nc + " (" + nc.hashCode() + ")");
            }
            LegacyRequest l = sLegacyRequests.get(netCap);
            if (l != null) {
                Log.d("ConnectivityManager", "renewing startUsingNetworkFeature request " + l.networkRequest);
                this.renewRequestLocked(l);
                if (l.currentNetwork != null) {
                    return 0;
                }
                return 1;
            }
            request = this.requestNetworkForFeatureLocked(netCap);
        }
        if (request != null) {
            Log.d("ConnectivityManager", "starting startUsingNetworkFeature for request " + request);
            return 1;
        }
        Log.d("ConnectivityManager", " request Failed");
        return 3;
    }

    private final int $$robo$$android_net_ConnectivityManager$stopUsingNetworkFeature(int networkType, String feature) {
        NetworkCapabilities netCap = this.networkCapabilitiesForFeature(networkType, feature);
        if (netCap == null) {
            Log.d("ConnectivityManager", "Can't satisfy stopUsingNetworkFeature for " + networkType + ", " + feature);
            return -1;
        }
        NetworkCallback networkCallback = this.removeRequestForFeature(netCap);
        if (networkCallback != null) {
            Log.d("ConnectivityManager", "stopUsingNetworkFeature for " + networkType + ", " + feature);
            this.unregisterNetworkCallback(networkCallback);
        }
        return 1;
    }

    private static final void $$robo$$android_net_ConnectivityManager$maybeMarkCapabilitiesRestricted(NetworkCapabilities nc) {
        block3: for (int capability : nc.getCapabilities()) {
            switch (capability) {
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 13: {
                    continue block3;
                }
                default: {
                    return;
                }
            }
        }
        nc.removeCapability(13);
    }

    private final NetworkCapabilities $$robo$$android_net_ConnectivityManager$networkCapabilitiesForFeature(int networkType, String feature) {
        if (networkType == 0) {
            int cap = -1;
            if ("enableMMS".equals(feature)) {
                cap = 0;
            } else if ("enableSUPL".equals(feature)) {
                cap = 1;
            } else if ("enableDUN".equals(feature) || "enableDUNAlways".equals(feature)) {
                cap = 2;
            } else if ("enableHIPRI".equals(feature)) {
                cap = 12;
            } else if ("enableFOTA".equals(feature)) {
                cap = 3;
            } else if ("enableIMS".equals(feature)) {
                cap = 4;
            } else if ("enableCBS".equals(feature)) {
                cap = 5;
            } else {
                return null;
            }
            NetworkCapabilities netCap = new NetworkCapabilities();
            netCap.addTransportType(0).addCapability(cap);
            ConnectivityManager.maybeMarkCapabilitiesRestricted(netCap);
            return netCap;
        }
        if (networkType == 1 && "p2p".equals(feature)) {
            NetworkCapabilities netCap = new NetworkCapabilities();
            netCap.addTransportType(1);
            netCap.addCapability(6);
            ConnectivityManager.maybeMarkCapabilitiesRestricted(netCap);
            return netCap;
        }
        return null;
    }

    private final int $$robo$$android_net_ConnectivityManager$inferLegacyTypeForNetworkCapabilities(NetworkCapabilities netCap) {
        if (netCap == null) {
            return -1;
        }
        if (!netCap.hasTransport(0)) {
            return -1;
        }
        if (netCap.hasCapability(5)) {
            if (netCap.equals(this.networkCapabilitiesForFeature(0, "enableCBS"))) {
                return 12;
            }
            return -1;
        }
        if (netCap.hasCapability(4)) {
            if (netCap.equals(this.networkCapabilitiesForFeature(0, "enableIMS"))) {
                return 11;
            }
            return -1;
        }
        if (netCap.hasCapability(3)) {
            if (netCap.equals(this.networkCapabilitiesForFeature(0, "enableFOTA"))) {
                return 10;
            }
            return -1;
        }
        if (netCap.hasCapability(2)) {
            if (netCap.equals(this.networkCapabilitiesForFeature(0, "enableDUN"))) {
                return 4;
            }
            return -1;
        }
        if (netCap.hasCapability(1)) {
            if (netCap.equals(this.networkCapabilitiesForFeature(0, "enableSUPL"))) {
                return 3;
            }
            return -1;
        }
        if (netCap.hasCapability(0)) {
            if (netCap.equals(this.networkCapabilitiesForFeature(0, "enableMMS"))) {
                return 2;
            }
            return -1;
        }
        if (netCap.hasCapability(12)) {
            if (netCap.equals(this.networkCapabilitiesForFeature(0, "enableHIPRI"))) {
                return 5;
            }
            return -1;
        }
        return -1;
    }

    private final int $$robo$$android_net_ConnectivityManager$legacyTypeForNetworkCapabilities(NetworkCapabilities netCap) {
        if (netCap == null) {
            return -1;
        }
        if (netCap.hasCapability(5)) {
            return 12;
        }
        if (netCap.hasCapability(4)) {
            return 11;
        }
        if (netCap.hasCapability(3)) {
            return 10;
        }
        if (netCap.hasCapability(2)) {
            return 4;
        }
        if (netCap.hasCapability(1)) {
            return 3;
        }
        if (netCap.hasCapability(0)) {
            return 2;
        }
        if (netCap.hasCapability(12)) {
            return 5;
        }
        if (netCap.hasCapability(6)) {
            return 13;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final NetworkRequest $$robo$$android_net_ConnectivityManager$findRequestForFeature(NetworkCapabilities netCap) {
        HashMap<NetworkCapabilities, LegacyRequest> hashMap = sLegacyRequests;
        synchronized (hashMap) {
            LegacyRequest l = sLegacyRequests.get(netCap);
            if (l != null) {
                return l.networkRequest;
            }
        }
        return null;
    }

    private final void $$robo$$android_net_ConnectivityManager$renewRequestLocked(LegacyRequest l) {
        ++l.expireSequenceNumber;
        Log.d("ConnectivityManager", "renewing request to seqNum " + l.expireSequenceNumber);
        this.sendExpireMsgForFeature(l.networkCapabilities, l.expireSequenceNumber, l.delay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_net_ConnectivityManager$expireRequest(NetworkCapabilities netCap, int sequenceNum) {
        int ourSeqNum = -1;
        HashMap<NetworkCapabilities, LegacyRequest> hashMap = sLegacyRequests;
        synchronized (hashMap) {
            LegacyRequest l = sLegacyRequests.get(netCap);
            if (l == null) {
                return;
            }
            ourSeqNum = l.expireSequenceNumber;
            if (l.expireSequenceNumber == sequenceNum) {
                this.unregisterNetworkCallback(l.networkCallback);
                sLegacyRequests.remove(netCap);
            }
        }
        Log.d("ConnectivityManager", "expireRequest with " + ourSeqNum + ", " + sequenceNum);
    }

    private final NetworkRequest $$robo$$android_net_ConnectivityManager$requestNetworkForFeatureLocked(NetworkCapabilities netCap) {
        int delay = -1;
        int type = this.legacyTypeForNetworkCapabilities(netCap);
        try {
            delay = this.mService.getRestoreDefaultNetworkDelay(type);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        LegacyRequest l = new LegacyRequest();
        l.networkCapabilities = netCap;
        l.delay = delay;
        l.expireSequenceNumber = 0;
        l.networkRequest = this.sendRequestForNetwork(netCap, l.networkCallback, 0, 2, type);
        if (l.networkRequest == null) {
            return null;
        }
        sLegacyRequests.put(netCap, l);
        this.sendExpireMsgForFeature(netCap, l.expireSequenceNumber, delay);
        return l.networkRequest;
    }

    private final void $$robo$$android_net_ConnectivityManager$sendExpireMsgForFeature(NetworkCapabilities netCap, int seqNum, int delay) {
        if (delay >= 0) {
            Log.d("ConnectivityManager", "sending expire msg with seqNum " + seqNum + " and delay " + delay);
            Message msg = sCallbackHandler.obtainMessage(524298, seqNum, 0, netCap);
            sCallbackHandler.sendMessageDelayed(msg, delay);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final NetworkCallback $$robo$$android_net_ConnectivityManager$removeRequestForFeature(NetworkCapabilities netCap) {
        HashMap<NetworkCapabilities, LegacyRequest> hashMap = sLegacyRequests;
        synchronized (hashMap) {
            LegacyRequest l = sLegacyRequests.remove(netCap);
            if (l == null) {
                return null;
            }
            return l.networkCallback;
        }
    }

    private final boolean $$robo$$android_net_ConnectivityManager$requestRouteToHost(int networkType, int hostAddress) {
        return this.requestRouteToHostAddress(networkType, NetworkUtils.intToInetAddress(hostAddress));
    }

    private final boolean $$robo$$android_net_ConnectivityManager$requestRouteToHostAddress(int networkType, InetAddress hostAddress) {
        try {
            return this.mService.requestRouteToHostAddress(networkType, hostAddress.getAddress());
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Deprecated
    private final boolean $$robo$$android_net_ConnectivityManager$getBackgroundDataSetting() {
        return true;
    }

    @Deprecated
    private final void $$robo$$android_net_ConnectivityManager$setBackgroundDataSetting(boolean allowBackgroundData) {
    }

    private final NetworkQuotaInfo $$robo$$android_net_ConnectivityManager$getActiveNetworkQuotaInfo() {
        try {
            return this.mService.getActiveNetworkQuotaInfo();
        }
        catch (RemoteException e) {
            return null;
        }
    }

    private final boolean $$robo$$android_net_ConnectivityManager$getMobileDataEnabled() {
        IBinder b = ServiceManager.getService("phone");
        if (b != null) {
            try {
                ITelephony it = ITelephony.Stub.asInterface(b);
                return it.getDataEnabled();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final INetworkManagementService $$robo$$android_net_ConnectivityManager$getNetworkManagementService() {
        ConnectivityManager connectivityManager = this;
        synchronized (connectivityManager) {
            if (this.mNMService != null) {
                return this.mNMService;
            }
            IBinder b = ServiceManager.getService("network_management");
            this.mNMService = INetworkManagementService.Stub.asInterface(b);
            return this.mNMService;
        }
    }

    private final void $$robo$$android_net_ConnectivityManager$addDefaultNetworkActiveListener(OnNetworkActiveListener l) {
        ShadowedObject rl = new ShadowedObject(this, l){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ OnNetworkActiveListener val$l;
            /* synthetic */ ConnectivityManager this$0;

            private void $$robo$$android_net_ConnectivityManager_1$__constructor__(ConnectivityManager connectivityManager, OnNetworkActiveListener onNetworkActiveListener) {
            }

            private final void $$robo$$android_net_ConnectivityManager_1$onNetworkActive() throws RemoteException {
                this.val$l.onNetworkActive();
            }

            private void __constructor__(ConnectivityManager connectivityManager, OnNetworkActiveListener onNetworkActiveListener) {
                this.$$robo$$android_net_ConnectivityManager_1$__constructor__(connectivityManager, onNetworkActiveListener);
            }
            {
                this.this$0 = connectivityManager;
                this.val$l = onNetworkActiveListener;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_ConnectivityManager_1$__constructor__(android.net.ConnectivityManager android.net.ConnectivityManager$OnNetworkActiveListener ), 0, this, connectivityManager, onNetworkActiveListener);
            }

            @Override
            public void onNetworkActive() throws RemoteException {
                InvokeDynamicSupport.bootstrap("onNetworkActive", $$robo$$android_net_ConnectivityManager_1$onNetworkActive(), 0, this);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        try {
            this.getNetworkManagementService().registerNetworkActivityListener((INetworkActivityListener)rl);
            this.mNetworkActivityListeners.put(l, (INetworkActivityListener)rl);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_net_ConnectivityManager$removeDefaultNetworkActiveListener(OnNetworkActiveListener l) {
        INetworkActivityListener rl = this.mNetworkActivityListeners.get(l);
        if (rl == null) {
            throw new IllegalArgumentException("Listener not registered: " + l);
        }
        try {
            this.getNetworkManagementService().unregisterNetworkActivityListener(rl);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final boolean $$robo$$android_net_ConnectivityManager$isDefaultNetworkActive() {
        try {
            return this.getNetworkManagementService().isNetworkActive();
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    private void $$robo$$android_net_ConnectivityManager$__constructor__(IConnectivityManager service) {
        this.mNetworkActivityListeners = new ArrayMap();
        this.mService = Preconditions.checkNotNull(service, "missing IConnectivityManager");
    }

    private static final ConnectivityManager $$robo$$android_net_ConnectivityManager$from(Context context) {
        return (ConnectivityManager)context.getSystemService("connectivity");
    }

    private static final void $$robo$$android_net_ConnectivityManager$enforceTetherChangePermission(Context context) {
        if (context.getResources().getStringArray(17235989).length == 2) {
            context.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", "ConnectivityService");
        } else {
            context.enforceCallingOrSelfPermission("android.permission.CHANGE_NETWORK_STATE", "ConnectivityService");
        }
    }

    private final String[] $$robo$$android_net_ConnectivityManager$getTetherableIfaces() {
        try {
            return this.mService.getTetherableIfaces();
        }
        catch (RemoteException e) {
            return new String[0];
        }
    }

    private final String[] $$robo$$android_net_ConnectivityManager$getTetheredIfaces() {
        try {
            return this.mService.getTetheredIfaces();
        }
        catch (RemoteException e) {
            return new String[0];
        }
    }

    private final String[] $$robo$$android_net_ConnectivityManager$getTetheringErroredIfaces() {
        try {
            return this.mService.getTetheringErroredIfaces();
        }
        catch (RemoteException e) {
            return new String[0];
        }
    }

    private final String[] $$robo$$android_net_ConnectivityManager$getTetheredDhcpRanges() {
        try {
            return this.mService.getTetheredDhcpRanges();
        }
        catch (RemoteException e) {
            return new String[0];
        }
    }

    private final int $$robo$$android_net_ConnectivityManager$tether(String iface) {
        try {
            return this.mService.tether(iface);
        }
        catch (RemoteException e) {
            return 2;
        }
    }

    private final int $$robo$$android_net_ConnectivityManager$untether(String iface) {
        try {
            return this.mService.untether(iface);
        }
        catch (RemoteException e) {
            return 2;
        }
    }

    private final boolean $$robo$$android_net_ConnectivityManager$isTetheringSupported() {
        try {
            return this.mService.isTetheringSupported();
        }
        catch (RemoteException e) {
            return false;
        }
    }

    private final String[] $$robo$$android_net_ConnectivityManager$getTetherableUsbRegexs() {
        try {
            return this.mService.getTetherableUsbRegexs();
        }
        catch (RemoteException e) {
            return new String[0];
        }
    }

    private final String[] $$robo$$android_net_ConnectivityManager$getTetherableWifiRegexs() {
        try {
            return this.mService.getTetherableWifiRegexs();
        }
        catch (RemoteException e) {
            return new String[0];
        }
    }

    private final String[] $$robo$$android_net_ConnectivityManager$getTetherableBluetoothRegexs() {
        try {
            return this.mService.getTetherableBluetoothRegexs();
        }
        catch (RemoteException e) {
            return new String[0];
        }
    }

    private final int $$robo$$android_net_ConnectivityManager$setUsbTethering(boolean enable) {
        try {
            return this.mService.setUsbTethering(enable);
        }
        catch (RemoteException e) {
            return 2;
        }
    }

    private final int $$robo$$android_net_ConnectivityManager$getLastTetherError(String iface) {
        try {
            return this.mService.getLastTetherError(iface);
        }
        catch (RemoteException e) {
            return 2;
        }
    }

    private final void $$robo$$android_net_ConnectivityManager$reportInetCondition(int networkType, int percentage) {
        try {
            this.mService.reportInetCondition(networkType, percentage);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_net_ConnectivityManager$reportBadNetwork(Network network) {
        try {
            this.mService.reportBadNetwork(network);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_net_ConnectivityManager$setGlobalProxy(ProxyInfo p) {
        try {
            this.mService.setGlobalProxy(p);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final ProxyInfo $$robo$$android_net_ConnectivityManager$getGlobalProxy() {
        try {
            return this.mService.getGlobalProxy();
        }
        catch (RemoteException e) {
            return null;
        }
    }

    private final ProxyInfo $$robo$$android_net_ConnectivityManager$getProxy() {
        try {
            return this.mService.getProxy();
        }
        catch (RemoteException e) {
            return null;
        }
    }

    private final void $$robo$$android_net_ConnectivityManager$setDataDependency(int networkType, boolean met) {
        try {
            this.mService.setDataDependency(networkType, met);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final boolean $$robo$$android_net_ConnectivityManager$isNetworkSupported(int networkType) {
        try {
            return this.mService.isNetworkSupported(networkType);
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    private final boolean $$robo$$android_net_ConnectivityManager$isActiveNetworkMetered() {
        try {
            return this.mService.isActiveNetworkMetered();
        }
        catch (RemoteException e) {
            return false;
        }
    }

    private final boolean $$robo$$android_net_ConnectivityManager$updateLockdownVpn() {
        try {
            return this.mService.updateLockdownVpn();
        }
        catch (RemoteException e) {
            return false;
        }
    }

    private final void $$robo$$android_net_ConnectivityManager$captivePortalCheckCompleted(NetworkInfo info, boolean isCaptivePortal) {
        try {
            this.mService.captivePortalCheckCompleted(info, isCaptivePortal);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_net_ConnectivityManager$supplyMessenger(int networkType, Messenger messenger) {
        try {
            this.mService.supplyMessenger(networkType, messenger);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final int $$robo$$android_net_ConnectivityManager$checkMobileProvisioning(int suggestedTimeOutMs) {
        int timeOutMs = -1;
        try {
            timeOutMs = this.mService.checkMobileProvisioning(suggestedTimeOutMs);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return timeOutMs;
    }

    private final String $$robo$$android_net_ConnectivityManager$getMobileProvisioningUrl() {
        try {
            return this.mService.getMobileProvisioningUrl();
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    private final String $$robo$$android_net_ConnectivityManager$getMobileRedirectedProvisioningUrl() {
        try {
            return this.mService.getMobileRedirectedProvisioningUrl();
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    private final LinkQualityInfo $$robo$$android_net_ConnectivityManager$getLinkQualityInfo(int networkType) {
        try {
            LinkQualityInfo li = this.mService.getLinkQualityInfo(networkType);
            return li;
        }
        catch (RemoteException e) {
            return null;
        }
    }

    private final LinkQualityInfo $$robo$$android_net_ConnectivityManager$getActiveLinkQualityInfo() {
        try {
            LinkQualityInfo li = this.mService.getActiveLinkQualityInfo();
            return li;
        }
        catch (RemoteException e) {
            return null;
        }
    }

    private final LinkQualityInfo[] $$robo$$android_net_ConnectivityManager$getAllLinkQualityInfo() {
        try {
            LinkQualityInfo[] li = this.mService.getAllLinkQualityInfo();
            return li;
        }
        catch (RemoteException e) {
            return null;
        }
    }

    private final void $$robo$$android_net_ConnectivityManager$setProvisioningNotificationVisible(boolean visible, int networkType, String action) {
        try {
            this.mService.setProvisioningNotificationVisible(visible, networkType, action);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_net_ConnectivityManager$setAirplaneMode(boolean enable) {
        try {
            this.mService.setAirplaneMode(enable);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_net_ConnectivityManager$registerNetworkFactory(Messenger messenger, String name) {
        try {
            this.mService.registerNetworkFactory(messenger, name);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_net_ConnectivityManager$unregisterNetworkFactory(Messenger messenger) {
        try {
            this.mService.unregisterNetworkFactory(messenger);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_net_ConnectivityManager$registerNetworkAgent(Messenger messenger, NetworkInfo ni, LinkProperties lp, NetworkCapabilities nc, int score, NetworkMisc misc) {
        try {
            this.mService.registerNetworkAgent(messenger, ni, lp, nc, score, misc);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_net_ConnectivityManager$incCallbackHandlerRefCount() {
        AtomicInteger atomicInteger = sCallbackRefCount;
        synchronized (atomicInteger) {
            if (sCallbackRefCount.incrementAndGet() == 1) {
                HandlerThread callbackThread = new HandlerThread("ConnectivityManager");
                callbackThread.start();
                sCallbackHandler = new CallbackHandler(this, callbackThread.getLooper(), sNetworkCallback, sCallbackRefCount, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_net_ConnectivityManager$decCallbackHandlerRefCount() {
        AtomicInteger atomicInteger = sCallbackRefCount;
        synchronized (atomicInteger) {
            if (sCallbackRefCount.decrementAndGet() == 0) {
                sCallbackHandler.obtainMessage(524297).sendToTarget();
                sCallbackHandler = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final NetworkRequest $$robo$$android_net_ConnectivityManager$sendRequestForNetwork(NetworkCapabilities need, NetworkCallback networkCallback, int timeoutSec, int action, int legacyType) {
        if (networkCallback == null) {
            throw new IllegalArgumentException("null NetworkCallback");
        }
        if (need == null) {
            throw new IllegalArgumentException("null NetworkCapabilities");
        }
        try {
            this.incCallbackHandlerRefCount();
            HashMap<NetworkRequest, NetworkCallback> hashMap = sNetworkCallback;
            synchronized (hashMap) {
                if (action == 1) {
                    networkCallback.networkRequest = this.mService.listenForNetwork(need, new Messenger(ConnectivityManager.sCallbackHandler), new Binder());
                } else {
                    networkCallback.networkRequest = this.mService.requestNetwork(need, new Messenger(ConnectivityManager.sCallbackHandler), timeoutSec, new Binder(), legacyType);
                }
                if (networkCallback.networkRequest != null) {
                    sNetworkCallback.put(networkCallback.networkRequest, networkCallback);
                }
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (networkCallback.networkRequest == null) {
            this.decCallbackHandlerRefCount();
        }
        return networkCallback.networkRequest;
    }

    private final void $$robo$$android_net_ConnectivityManager$requestNetwork(NetworkRequest request, NetworkCallback networkCallback) {
        this.sendRequestForNetwork(request.networkCapabilities, networkCallback, 0, 2, this.inferLegacyTypeForNetworkCapabilities(request.networkCapabilities));
    }

    private final void $$robo$$android_net_ConnectivityManager$requestNetwork(NetworkRequest request, NetworkCallback networkCallback, int timeoutMs) {
        this.sendRequestForNetwork(request.networkCapabilities, networkCallback, timeoutMs, 2, this.inferLegacyTypeForNetworkCapabilities(request.networkCapabilities));
    }

    private final void $$robo$$android_net_ConnectivityManager$requestNetwork(NetworkRequest request, PendingIntent operation) {
        try {
            this.mService.pendingRequestForNetwork(request.networkCapabilities, operation);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_net_ConnectivityManager$registerNetworkCallback(NetworkRequest request, NetworkCallback networkCallback) {
        this.sendRequestForNetwork(request.networkCapabilities, networkCallback, 0, 1, -1);
    }

    private final void $$robo$$android_net_ConnectivityManager$unregisterNetworkCallback(NetworkCallback networkCallback) {
        if (networkCallback == null || networkCallback.networkRequest == null || ((NetworkCallback)networkCallback).networkRequest.requestId == 0) {
            throw new IllegalArgumentException("Invalid NetworkCallback");
        }
        try {
            this.mService.releaseNetworkRequest(networkCallback.networkRequest);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private static final boolean $$robo$$android_net_ConnectivityManager$setProcessDefaultNetwork(Network network) {
        int netId;
        int n = netId = network == null ? 0 : network.netId;
        if (netId == NetworkUtils.getNetworkBoundToProcess()) {
            return true;
        }
        if (NetworkUtils.bindProcessToNetwork(netId)) {
            InetAddress.clearDnsCache();
            NetworkEventDispatcher.getInstance().onNetworkConfigurationChanged();
            return true;
        }
        return false;
    }

    private static final Network $$robo$$android_net_ConnectivityManager$getProcessDefaultNetwork() {
        int netId = NetworkUtils.getNetworkBoundToProcess();
        if (netId == 0) {
            return null;
        }
        return new Network(netId);
    }

    private static final boolean $$robo$$android_net_ConnectivityManager$setProcessDefaultNetworkForHostResolution(Network network) {
        return NetworkUtils.bindProcessToNetworkForHostResolution(network == null ? 0 : network.netId);
    }

    static void __staticInitializer__() {
        sLegacyRequests = new HashMap();
        sNetworkCallback = new HashMap();
        sCallbackRefCount = new AtomicInteger(0);
        sCallbackHandler = null;
    }

    public static boolean isNetworkTypeValid(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isNetworkTypeValid", $$robo$$android_net_ConnectivityManager$isNetworkTypeValid(int ), 0, (int)n);
    }

    public static String getNetworkTypeName(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getNetworkTypeName", $$robo$$android_net_ConnectivityManager$getNetworkTypeName(int ), 0, (int)n);
    }

    public static boolean isNetworkTypeMobile(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isNetworkTypeMobile", $$robo$$android_net_ConnectivityManager$isNetworkTypeMobile(int ), 0, (int)n);
    }

    public static boolean isNetworkTypeWifi(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isNetworkTypeWifi", $$robo$$android_net_ConnectivityManager$isNetworkTypeWifi(int ), 0, (int)n);
    }

    public void setNetworkPreference(int n) {
        InvokeDynamicSupport.bootstrap("setNetworkPreference", $$robo$$android_net_ConnectivityManager$setNetworkPreference(int ), 0, this, n);
    }

    public int getNetworkPreference() {
        return (int)InvokeDynamicSupport.bootstrap("getNetworkPreference", $$robo$$android_net_ConnectivityManager$getNetworkPreference(), 0, this);
    }

    public NetworkInfo getActiveNetworkInfo() {
        return InvokeDynamicSupport.bootstrap("getActiveNetworkInfo", $$robo$$android_net_ConnectivityManager$getActiveNetworkInfo(), 0, this);
    }

    public NetworkInfo getActiveNetworkInfoForUid(int n) {
        return InvokeDynamicSupport.bootstrap("getActiveNetworkInfoForUid", $$robo$$android_net_ConnectivityManager$getActiveNetworkInfoForUid(int ), 0, this, n);
    }

    public NetworkInfo getNetworkInfo(int n) {
        return InvokeDynamicSupport.bootstrap("getNetworkInfo", $$robo$$android_net_ConnectivityManager$getNetworkInfo(int ), 0, this, n);
    }

    public NetworkInfo getNetworkInfo(Network network) {
        return InvokeDynamicSupport.bootstrap("getNetworkInfo", $$robo$$android_net_ConnectivityManager$getNetworkInfo(android.net.Network ), 0, this, network);
    }

    public NetworkInfo[] getAllNetworkInfo() {
        return InvokeDynamicSupport.bootstrap("getAllNetworkInfo", $$robo$$android_net_ConnectivityManager$getAllNetworkInfo(), 0, this);
    }

    public Network getNetworkForType(int n) {
        return InvokeDynamicSupport.bootstrap("getNetworkForType", $$robo$$android_net_ConnectivityManager$getNetworkForType(int ), 0, this, n);
    }

    public Network[] getAllNetworks() {
        return InvokeDynamicSupport.bootstrap("getAllNetworks", $$robo$$android_net_ConnectivityManager$getAllNetworks(), 0, this);
    }

    public NetworkInfo getProvisioningOrActiveNetworkInfo() {
        return InvokeDynamicSupport.bootstrap("getProvisioningOrActiveNetworkInfo", $$robo$$android_net_ConnectivityManager$getProvisioningOrActiveNetworkInfo(), 0, this);
    }

    public LinkProperties getActiveLinkProperties() {
        return InvokeDynamicSupport.bootstrap("getActiveLinkProperties", $$robo$$android_net_ConnectivityManager$getActiveLinkProperties(), 0, this);
    }

    public LinkProperties getLinkProperties(int n) {
        return InvokeDynamicSupport.bootstrap("getLinkProperties", $$robo$$android_net_ConnectivityManager$getLinkProperties(int ), 0, this, n);
    }

    public LinkProperties getLinkProperties(Network network) {
        return InvokeDynamicSupport.bootstrap("getLinkProperties", $$robo$$android_net_ConnectivityManager$getLinkProperties(android.net.Network ), 0, this, network);
    }

    public NetworkCapabilities getNetworkCapabilities(Network network) {
        return InvokeDynamicSupport.bootstrap("getNetworkCapabilities", $$robo$$android_net_ConnectivityManager$getNetworkCapabilities(android.net.Network ), 0, this, network);
    }

    public int startUsingNetworkFeature(int n, String string2) {
        return (int)InvokeDynamicSupport.bootstrap("startUsingNetworkFeature", $$robo$$android_net_ConnectivityManager$startUsingNetworkFeature(int java.lang.String ), 0, this, n, string2);
    }

    public int stopUsingNetworkFeature(int n, String string2) {
        return (int)InvokeDynamicSupport.bootstrap("stopUsingNetworkFeature", $$robo$$android_net_ConnectivityManager$stopUsingNetworkFeature(int java.lang.String ), 0, this, n, string2);
    }

    public static void maybeMarkCapabilitiesRestricted(NetworkCapabilities networkCapabilities) {
        InvokeDynamicSupport.bootstrapStatic("maybeMarkCapabilitiesRestricted", $$robo$$android_net_ConnectivityManager$maybeMarkCapabilitiesRestricted(android.net.NetworkCapabilities ), 0, (NetworkCapabilities)networkCapabilities);
    }

    private NetworkCapabilities networkCapabilitiesForFeature(int n, String string2) {
        return InvokeDynamicSupport.bootstrap("networkCapabilitiesForFeature", $$robo$$android_net_ConnectivityManager$networkCapabilitiesForFeature(int java.lang.String ), 0, this, n, string2);
    }

    private int inferLegacyTypeForNetworkCapabilities(NetworkCapabilities networkCapabilities) {
        return (int)InvokeDynamicSupport.bootstrap("inferLegacyTypeForNetworkCapabilities", $$robo$$android_net_ConnectivityManager$inferLegacyTypeForNetworkCapabilities(android.net.NetworkCapabilities ), 0, this, networkCapabilities);
    }

    private int legacyTypeForNetworkCapabilities(NetworkCapabilities networkCapabilities) {
        return (int)InvokeDynamicSupport.bootstrap("legacyTypeForNetworkCapabilities", $$robo$$android_net_ConnectivityManager$legacyTypeForNetworkCapabilities(android.net.NetworkCapabilities ), 0, this, networkCapabilities);
    }

    private NetworkRequest findRequestForFeature(NetworkCapabilities networkCapabilities) {
        return InvokeDynamicSupport.bootstrap("findRequestForFeature", $$robo$$android_net_ConnectivityManager$findRequestForFeature(android.net.NetworkCapabilities ), 0, this, networkCapabilities);
    }

    private void renewRequestLocked(LegacyRequest legacyRequest) {
        InvokeDynamicSupport.bootstrap("renewRequestLocked", $$robo$$android_net_ConnectivityManager$renewRequestLocked(android.net.ConnectivityManager$LegacyRequest ), 0, this, legacyRequest);
    }

    private void expireRequest(NetworkCapabilities networkCapabilities, int n) {
        InvokeDynamicSupport.bootstrap("expireRequest", $$robo$$android_net_ConnectivityManager$expireRequest(android.net.NetworkCapabilities int ), 0, this, networkCapabilities, n);
    }

    private NetworkRequest requestNetworkForFeatureLocked(NetworkCapabilities networkCapabilities) {
        return InvokeDynamicSupport.bootstrap("requestNetworkForFeatureLocked", $$robo$$android_net_ConnectivityManager$requestNetworkForFeatureLocked(android.net.NetworkCapabilities ), 0, this, networkCapabilities);
    }

    private void sendExpireMsgForFeature(NetworkCapabilities networkCapabilities, int n, int n2) {
        InvokeDynamicSupport.bootstrap("sendExpireMsgForFeature", $$robo$$android_net_ConnectivityManager$sendExpireMsgForFeature(android.net.NetworkCapabilities int int ), 0, this, networkCapabilities, n, n2);
    }

    private NetworkCallback removeRequestForFeature(NetworkCapabilities networkCapabilities) {
        return InvokeDynamicSupport.bootstrap("removeRequestForFeature", $$robo$$android_net_ConnectivityManager$removeRequestForFeature(android.net.NetworkCapabilities ), 0, this, networkCapabilities);
    }

    public boolean requestRouteToHost(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("requestRouteToHost", $$robo$$android_net_ConnectivityManager$requestRouteToHost(int int ), 0, this, n, n2);
    }

    public boolean requestRouteToHostAddress(int n, InetAddress inetAddress) {
        return (boolean)InvokeDynamicSupport.bootstrap("requestRouteToHostAddress", $$robo$$android_net_ConnectivityManager$requestRouteToHostAddress(int java.net.InetAddress ), 0, this, n, inetAddress);
    }

    @Deprecated
    public boolean getBackgroundDataSetting() {
        return (boolean)InvokeDynamicSupport.bootstrap("getBackgroundDataSetting", $$robo$$android_net_ConnectivityManager$getBackgroundDataSetting(), 0, this);
    }

    @Deprecated
    public void setBackgroundDataSetting(boolean bl) {
        InvokeDynamicSupport.bootstrap("setBackgroundDataSetting", $$robo$$android_net_ConnectivityManager$setBackgroundDataSetting(boolean ), 0, this, bl);
    }

    public NetworkQuotaInfo getActiveNetworkQuotaInfo() {
        return InvokeDynamicSupport.bootstrap("getActiveNetworkQuotaInfo", $$robo$$android_net_ConnectivityManager$getActiveNetworkQuotaInfo(), 0, this);
    }

    public boolean getMobileDataEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("getMobileDataEnabled", $$robo$$android_net_ConnectivityManager$getMobileDataEnabled(), 0, this);
    }

    private INetworkManagementService getNetworkManagementService() {
        return InvokeDynamicSupport.bootstrap("getNetworkManagementService", $$robo$$android_net_ConnectivityManager$getNetworkManagementService(), 0, this);
    }

    public void addDefaultNetworkActiveListener(OnNetworkActiveListener onNetworkActiveListener) {
        InvokeDynamicSupport.bootstrap("addDefaultNetworkActiveListener", $$robo$$android_net_ConnectivityManager$addDefaultNetworkActiveListener(android.net.ConnectivityManager$OnNetworkActiveListener ), 0, this, onNetworkActiveListener);
    }

    public void removeDefaultNetworkActiveListener(OnNetworkActiveListener onNetworkActiveListener) {
        InvokeDynamicSupport.bootstrap("removeDefaultNetworkActiveListener", $$robo$$android_net_ConnectivityManager$removeDefaultNetworkActiveListener(android.net.ConnectivityManager$OnNetworkActiveListener ), 0, this, onNetworkActiveListener);
    }

    public boolean isDefaultNetworkActive() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDefaultNetworkActive", $$robo$$android_net_ConnectivityManager$isDefaultNetworkActive(), 0, this);
    }

    private void __constructor__(IConnectivityManager iConnectivityManager) {
        this.$$robo$$android_net_ConnectivityManager$__constructor__(iConnectivityManager);
    }

    public ConnectivityManager(IConnectivityManager iConnectivityManager) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_ConnectivityManager$__constructor__(android.net.IConnectivityManager ), 0, this, iConnectivityManager);
    }

    public static ConnectivityManager from(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("from", $$robo$$android_net_ConnectivityManager$from(android.content.Context ), 0, (Context)context);
    }

    public static void enforceTetherChangePermission(Context context) {
        InvokeDynamicSupport.bootstrapStatic("enforceTetherChangePermission", $$robo$$android_net_ConnectivityManager$enforceTetherChangePermission(android.content.Context ), 0, (Context)context);
    }

    public String[] getTetherableIfaces() {
        return InvokeDynamicSupport.bootstrap("getTetherableIfaces", $$robo$$android_net_ConnectivityManager$getTetherableIfaces(), 0, this);
    }

    public String[] getTetheredIfaces() {
        return InvokeDynamicSupport.bootstrap("getTetheredIfaces", $$robo$$android_net_ConnectivityManager$getTetheredIfaces(), 0, this);
    }

    public String[] getTetheringErroredIfaces() {
        return InvokeDynamicSupport.bootstrap("getTetheringErroredIfaces", $$robo$$android_net_ConnectivityManager$getTetheringErroredIfaces(), 0, this);
    }

    public String[] getTetheredDhcpRanges() {
        return InvokeDynamicSupport.bootstrap("getTetheredDhcpRanges", $$robo$$android_net_ConnectivityManager$getTetheredDhcpRanges(), 0, this);
    }

    public int tether(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("tether", $$robo$$android_net_ConnectivityManager$tether(java.lang.String ), 0, this, string2);
    }

    public int untether(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("untether", $$robo$$android_net_ConnectivityManager$untether(java.lang.String ), 0, this, string2);
    }

    public boolean isTetheringSupported() {
        return (boolean)InvokeDynamicSupport.bootstrap("isTetheringSupported", $$robo$$android_net_ConnectivityManager$isTetheringSupported(), 0, this);
    }

    public String[] getTetherableUsbRegexs() {
        return InvokeDynamicSupport.bootstrap("getTetherableUsbRegexs", $$robo$$android_net_ConnectivityManager$getTetherableUsbRegexs(), 0, this);
    }

    public String[] getTetherableWifiRegexs() {
        return InvokeDynamicSupport.bootstrap("getTetherableWifiRegexs", $$robo$$android_net_ConnectivityManager$getTetherableWifiRegexs(), 0, this);
    }

    public String[] getTetherableBluetoothRegexs() {
        return InvokeDynamicSupport.bootstrap("getTetherableBluetoothRegexs", $$robo$$android_net_ConnectivityManager$getTetherableBluetoothRegexs(), 0, this);
    }

    public int setUsbTethering(boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("setUsbTethering", $$robo$$android_net_ConnectivityManager$setUsbTethering(boolean ), 0, this, bl);
    }

    public int getLastTetherError(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("getLastTetherError", $$robo$$android_net_ConnectivityManager$getLastTetherError(java.lang.String ), 0, this, string2);
    }

    public void reportInetCondition(int n, int n2) {
        InvokeDynamicSupport.bootstrap("reportInetCondition", $$robo$$android_net_ConnectivityManager$reportInetCondition(int int ), 0, this, n, n2);
    }

    public void reportBadNetwork(Network network) {
        InvokeDynamicSupport.bootstrap("reportBadNetwork", $$robo$$android_net_ConnectivityManager$reportBadNetwork(android.net.Network ), 0, this, network);
    }

    public void setGlobalProxy(ProxyInfo proxyInfo) {
        InvokeDynamicSupport.bootstrap("setGlobalProxy", $$robo$$android_net_ConnectivityManager$setGlobalProxy(android.net.ProxyInfo ), 0, this, proxyInfo);
    }

    public ProxyInfo getGlobalProxy() {
        return InvokeDynamicSupport.bootstrap("getGlobalProxy", $$robo$$android_net_ConnectivityManager$getGlobalProxy(), 0, this);
    }

    public ProxyInfo getProxy() {
        return InvokeDynamicSupport.bootstrap("getProxy", $$robo$$android_net_ConnectivityManager$getProxy(), 0, this);
    }

    public void setDataDependency(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("setDataDependency", $$robo$$android_net_ConnectivityManager$setDataDependency(int boolean ), 0, this, n, bl);
    }

    public boolean isNetworkSupported(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isNetworkSupported", $$robo$$android_net_ConnectivityManager$isNetworkSupported(int ), 0, this, n);
    }

    public boolean isActiveNetworkMetered() {
        return (boolean)InvokeDynamicSupport.bootstrap("isActiveNetworkMetered", $$robo$$android_net_ConnectivityManager$isActiveNetworkMetered(), 0, this);
    }

    public boolean updateLockdownVpn() {
        return (boolean)InvokeDynamicSupport.bootstrap("updateLockdownVpn", $$robo$$android_net_ConnectivityManager$updateLockdownVpn(), 0, this);
    }

    public void captivePortalCheckCompleted(NetworkInfo networkInfo, boolean bl) {
        InvokeDynamicSupport.bootstrap("captivePortalCheckCompleted", $$robo$$android_net_ConnectivityManager$captivePortalCheckCompleted(android.net.NetworkInfo boolean ), 0, this, networkInfo, bl);
    }

    public void supplyMessenger(int n, Messenger messenger) {
        InvokeDynamicSupport.bootstrap("supplyMessenger", $$robo$$android_net_ConnectivityManager$supplyMessenger(int android.os.Messenger ), 0, this, n, messenger);
    }

    public int checkMobileProvisioning(int n) {
        return (int)InvokeDynamicSupport.bootstrap("checkMobileProvisioning", $$robo$$android_net_ConnectivityManager$checkMobileProvisioning(int ), 0, this, n);
    }

    public String getMobileProvisioningUrl() {
        return InvokeDynamicSupport.bootstrap("getMobileProvisioningUrl", $$robo$$android_net_ConnectivityManager$getMobileProvisioningUrl(), 0, this);
    }

    public String getMobileRedirectedProvisioningUrl() {
        return InvokeDynamicSupport.bootstrap("getMobileRedirectedProvisioningUrl", $$robo$$android_net_ConnectivityManager$getMobileRedirectedProvisioningUrl(), 0, this);
    }

    public LinkQualityInfo getLinkQualityInfo(int n) {
        return InvokeDynamicSupport.bootstrap("getLinkQualityInfo", $$robo$$android_net_ConnectivityManager$getLinkQualityInfo(int ), 0, this, n);
    }

    public LinkQualityInfo getActiveLinkQualityInfo() {
        return InvokeDynamicSupport.bootstrap("getActiveLinkQualityInfo", $$robo$$android_net_ConnectivityManager$getActiveLinkQualityInfo(), 0, this);
    }

    public LinkQualityInfo[] getAllLinkQualityInfo() {
        return InvokeDynamicSupport.bootstrap("getAllLinkQualityInfo", $$robo$$android_net_ConnectivityManager$getAllLinkQualityInfo(), 0, this);
    }

    public void setProvisioningNotificationVisible(boolean bl, int n, String string2) {
        InvokeDynamicSupport.bootstrap("setProvisioningNotificationVisible", $$robo$$android_net_ConnectivityManager$setProvisioningNotificationVisible(boolean int java.lang.String ), 0, this, bl, n, string2);
    }

    public void setAirplaneMode(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAirplaneMode", $$robo$$android_net_ConnectivityManager$setAirplaneMode(boolean ), 0, this, bl);
    }

    public void registerNetworkFactory(Messenger messenger, String string2) {
        InvokeDynamicSupport.bootstrap("registerNetworkFactory", $$robo$$android_net_ConnectivityManager$registerNetworkFactory(android.os.Messenger java.lang.String ), 0, this, messenger, string2);
    }

    public void unregisterNetworkFactory(Messenger messenger) {
        InvokeDynamicSupport.bootstrap("unregisterNetworkFactory", $$robo$$android_net_ConnectivityManager$unregisterNetworkFactory(android.os.Messenger ), 0, this, messenger);
    }

    public void registerNetworkAgent(Messenger messenger, NetworkInfo networkInfo, LinkProperties linkProperties, NetworkCapabilities networkCapabilities, int n, NetworkMisc networkMisc) {
        InvokeDynamicSupport.bootstrap("registerNetworkAgent", $$robo$$android_net_ConnectivityManager$registerNetworkAgent(android.os.Messenger android.net.NetworkInfo android.net.LinkProperties android.net.NetworkCapabilities int android.net.NetworkMisc ), 0, this, messenger, networkInfo, linkProperties, networkCapabilities, n, networkMisc);
    }

    private void incCallbackHandlerRefCount() {
        InvokeDynamicSupport.bootstrap("incCallbackHandlerRefCount", $$robo$$android_net_ConnectivityManager$incCallbackHandlerRefCount(), 0, this);
    }

    private void decCallbackHandlerRefCount() {
        InvokeDynamicSupport.bootstrap("decCallbackHandlerRefCount", $$robo$$android_net_ConnectivityManager$decCallbackHandlerRefCount(), 0, this);
    }

    private NetworkRequest sendRequestForNetwork(NetworkCapabilities networkCapabilities, NetworkCallback networkCallback, int n, int n2, int n3) {
        return InvokeDynamicSupport.bootstrap("sendRequestForNetwork", $$robo$$android_net_ConnectivityManager$sendRequestForNetwork(android.net.NetworkCapabilities android.net.ConnectivityManager$NetworkCallback int int int ), 0, this, networkCapabilities, networkCallback, n, n2, n3);
    }

    public void requestNetwork(NetworkRequest networkRequest, NetworkCallback networkCallback) {
        InvokeDynamicSupport.bootstrap("requestNetwork", $$robo$$android_net_ConnectivityManager$requestNetwork(android.net.NetworkRequest android.net.ConnectivityManager$NetworkCallback ), 0, this, networkRequest, networkCallback);
    }

    public void requestNetwork(NetworkRequest networkRequest, NetworkCallback networkCallback, int n) {
        InvokeDynamicSupport.bootstrap("requestNetwork", $$robo$$android_net_ConnectivityManager$requestNetwork(android.net.NetworkRequest android.net.ConnectivityManager$NetworkCallback int ), 0, this, networkRequest, networkCallback, n);
    }

    public void requestNetwork(NetworkRequest networkRequest, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("requestNetwork", $$robo$$android_net_ConnectivityManager$requestNetwork(android.net.NetworkRequest android.app.PendingIntent ), 0, this, networkRequest, pendingIntent);
    }

    public void registerNetworkCallback(NetworkRequest networkRequest, NetworkCallback networkCallback) {
        InvokeDynamicSupport.bootstrap("registerNetworkCallback", $$robo$$android_net_ConnectivityManager$registerNetworkCallback(android.net.NetworkRequest android.net.ConnectivityManager$NetworkCallback ), 0, this, networkRequest, networkCallback);
    }

    public void unregisterNetworkCallback(NetworkCallback networkCallback) {
        InvokeDynamicSupport.bootstrap("unregisterNetworkCallback", $$robo$$android_net_ConnectivityManager$unregisterNetworkCallback(android.net.ConnectivityManager$NetworkCallback ), 0, this, networkCallback);
    }

    public static boolean setProcessDefaultNetwork(Network network) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("setProcessDefaultNetwork", $$robo$$android_net_ConnectivityManager$setProcessDefaultNetwork(android.net.Network ), 0, (Network)network);
    }

    public static Network getProcessDefaultNetwork() {
        return InvokeDynamicSupport.bootstrapStatic("getProcessDefaultNetwork", $$robo$$android_net_ConnectivityManager$getProcessDefaultNetwork(), 0);
    }

    public static boolean setProcessDefaultNetworkForHostResolution(Network network) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("setProcessDefaultNetworkForHostResolution", $$robo$$android_net_ConnectivityManager$setProcessDefaultNetworkForHostResolution(android.net.Network ), 0, (Network)network);
    }

    static {
        RobolectricInternals.classInitializing(ConnectivityManager.class);
    }

    public /* synthetic */ ConnectivityManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ConnectivityManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class CallbackHandler
    extends Handler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private HashMap<NetworkRequest, NetworkCallback> mCallbackMap;
        private AtomicInteger mRefCount;
        private static String TAG = "ConnectivityManager.CallbackHandler";
        private ConnectivityManager mCm;
        /* synthetic */ ConnectivityManager this$0;

        private void $$robo$$android_net_ConnectivityManager_CallbackHandler$__constructor__(ConnectivityManager connectivityManager, Looper looper, HashMap<NetworkRequest, NetworkCallback> callbackMap, AtomicInteger refCount, ConnectivityManager cm) {
            this.mCallbackMap = callbackMap;
            this.mRefCount = refCount;
            this.mCm = cm;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_net_ConnectivityManager_CallbackHandler$handleMessage(Message message) {
            Log.d("ConnectivityManager.CallbackHandler", "CM callback handler got msg " + message.what);
            switch (message.what) {
                case 524289: {
                    NetworkRequest request = (NetworkRequest)this.getObject(message, NetworkRequest.class);
                    NetworkCallback callbacks = this.getCallbacks(request);
                    if (callbacks != null) {
                        callbacks.onPreCheck((Network)this.getObject(message, Network.class));
                        break;
                    }
                    Log.e("ConnectivityManager.CallbackHandler", "callback not found for PRECHECK message");
                    break;
                }
                case 524290: {
                    NetworkRequest request = (NetworkRequest)this.getObject(message, NetworkRequest.class);
                    NetworkCallback callbacks = this.getCallbacks(request);
                    if (callbacks != null) {
                        callbacks.onAvailable((Network)this.getObject(message, Network.class));
                        break;
                    }
                    Log.e("ConnectivityManager.CallbackHandler", "callback not found for AVAILABLE message");
                    break;
                }
                case 524291: {
                    NetworkRequest request = (NetworkRequest)this.getObject(message, NetworkRequest.class);
                    NetworkCallback callbacks = this.getCallbacks(request);
                    if (callbacks != null) {
                        callbacks.onLosing((Network)this.getObject(message, Network.class), message.arg1);
                        break;
                    }
                    Log.e("ConnectivityManager.CallbackHandler", "callback not found for LOSING message");
                    break;
                }
                case 524292: {
                    NetworkRequest request = (NetworkRequest)this.getObject(message, NetworkRequest.class);
                    NetworkCallback callbacks = this.getCallbacks(request);
                    if (callbacks != null) {
                        callbacks.onLost((Network)this.getObject(message, Network.class));
                        break;
                    }
                    Log.e("ConnectivityManager.CallbackHandler", "callback not found for LOST message");
                    break;
                }
                case 524293: {
                    NetworkRequest request = (NetworkRequest)this.getObject(message, NetworkRequest.class);
                    NetworkCallback callbacks = null;
                    HashMap<NetworkRequest, NetworkCallback> hashMap = this.mCallbackMap;
                    synchronized (hashMap) {
                        callbacks = this.mCallbackMap.get(request);
                    }
                    if (callbacks != null) {
                        callbacks.onUnavailable();
                        break;
                    }
                    Log.e("ConnectivityManager.CallbackHandler", "callback not found for UNAVAIL message");
                    break;
                }
                case 524294: {
                    NetworkRequest request = (NetworkRequest)this.getObject(message, NetworkRequest.class);
                    NetworkCallback callbacks = this.getCallbacks(request);
                    if (callbacks != null) {
                        Network network = (Network)this.getObject(message, Network.class);
                        NetworkCapabilities cap = (NetworkCapabilities)this.getObject(message, NetworkCapabilities.class);
                        callbacks.onCapabilitiesChanged(network, cap);
                        break;
                    }
                    Log.e("ConnectivityManager.CallbackHandler", "callback not found for CAP_CHANGED message");
                    break;
                }
                case 524295: {
                    NetworkRequest request = (NetworkRequest)this.getObject(message, NetworkRequest.class);
                    NetworkCallback callbacks = this.getCallbacks(request);
                    if (callbacks != null) {
                        Network network = (Network)this.getObject(message, Network.class);
                        LinkProperties lp = (LinkProperties)this.getObject(message, LinkProperties.class);
                        callbacks.onLinkPropertiesChanged(network, lp);
                        break;
                    }
                    Log.e("ConnectivityManager.CallbackHandler", "callback not found for IP_CHANGED message");
                    break;
                }
                case 524296: {
                    NetworkRequest req = (NetworkRequest)this.getObject(message, NetworkRequest.class);
                    NetworkCallback callbacks = null;
                    Serializable serializable = this.mCallbackMap;
                    synchronized (serializable) {
                        callbacks = this.mCallbackMap.remove(req);
                    }
                    if (callbacks != null) {
                        serializable = this.mRefCount;
                        synchronized (serializable) {
                            if (this.mRefCount.decrementAndGet() == 0) {
                                this.getLooper().quit();
                            }
                            break;
                        }
                    }
                    Log.e("ConnectivityManager.CallbackHandler", "callback not found for CANCELED message");
                    break;
                }
                case 524297: {
                    Log.d("ConnectivityManager.CallbackHandler", "Listener quiting");
                    this.getLooper().quit();
                    break;
                }
                case 524298: {
                    this.this$0.expireRequest((NetworkCapabilities)message.obj, message.arg1);
                }
            }
        }

        private final Object $$robo$$android_net_ConnectivityManager_CallbackHandler$getObject(Message msg, Class c) {
            return msg.getData().getParcelable(c.getSimpleName());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final NetworkCallback $$robo$$android_net_ConnectivityManager_CallbackHandler$getCallbacks(NetworkRequest req) {
            HashMap<NetworkRequest, NetworkCallback> hashMap = this.mCallbackMap;
            synchronized (hashMap) {
                return this.mCallbackMap.get(req);
            }
        }

        private void __constructor__(ConnectivityManager connectivityManager, Looper looper, HashMap<NetworkRequest, NetworkCallback> hashMap, AtomicInteger atomicInteger, ConnectivityManager connectivityManager2) {
            this.$$robo$$android_net_ConnectivityManager_CallbackHandler$__constructor__(connectivityManager, looper, hashMap, atomicInteger, connectivityManager2);
        }

        CallbackHandler(ConnectivityManager connectivityManager, Looper looper, HashMap<NetworkRequest, NetworkCallback> hashMap, AtomicInteger atomicInteger, ConnectivityManager connectivityManager2) {
            this.this$0 = connectivityManager;
            super(looper);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_ConnectivityManager_CallbackHandler$__constructor__(android.net.ConnectivityManager android.os.Looper java.util.HashMap<android.net.NetworkRequest, android.net.ConnectivityManager$NetworkCallback> java.util.concurrent.atomic.AtomicInteger android.net.ConnectivityManager ), 0, this, connectivityManager, looper, hashMap, atomicInteger, connectivityManager2);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_net_ConnectivityManager_CallbackHandler$handleMessage(android.os.Message ), 0, this, message);
        }

        private Object getObject(Message message, Class clazz) {
            return InvokeDynamicSupport.bootstrap("getObject", $$robo$$android_net_ConnectivityManager_CallbackHandler$getObject(android.os.Message java.lang.Class ), 0, this, message, clazz);
        }

        private NetworkCallback getCallbacks(NetworkRequest networkRequest) {
            return InvokeDynamicSupport.bootstrap("getCallbacks", $$robo$$android_net_ConnectivityManager_CallbackHandler$getCallbacks(android.net.NetworkRequest ), 0, this, networkRequest);
        }

        public /* synthetic */ CallbackHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CallbackHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class NetworkCallback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int PRECHECK = 1;
        public static int AVAILABLE = 2;
        public static int LOSING = 3;
        public static int LOST = 4;
        public static int UNAVAIL = 5;
        public static int CAP_CHANGED = 6;
        public static int PROP_CHANGED = 7;
        public static int CANCELED = 8;
        private NetworkRequest networkRequest;

        private void $$robo$$android_net_ConnectivityManager_NetworkCallback$__constructor__() {
        }

        private final void $$robo$$android_net_ConnectivityManager_NetworkCallback$onPreCheck(Network network) {
        }

        private final void $$robo$$android_net_ConnectivityManager_NetworkCallback$onAvailable(Network network) {
        }

        private final void $$robo$$android_net_ConnectivityManager_NetworkCallback$onLosing(Network network, int maxMsToLive) {
        }

        private final void $$robo$$android_net_ConnectivityManager_NetworkCallback$onLost(Network network) {
        }

        private final void $$robo$$android_net_ConnectivityManager_NetworkCallback$onUnavailable() {
        }

        private final void $$robo$$android_net_ConnectivityManager_NetworkCallback$onCapabilitiesChanged(Network network, NetworkCapabilities networkCapabilities) {
        }

        private final void $$robo$$android_net_ConnectivityManager_NetworkCallback$onLinkPropertiesChanged(Network network, LinkProperties linkProperties) {
        }

        private void __constructor__() {
            this.$$robo$$android_net_ConnectivityManager_NetworkCallback$__constructor__();
        }

        public NetworkCallback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_ConnectivityManager_NetworkCallback$__constructor__(), 0, this);
        }

        public void onPreCheck(Network network) {
            InvokeDynamicSupport.bootstrap("onPreCheck", $$robo$$android_net_ConnectivityManager_NetworkCallback$onPreCheck(android.net.Network ), 0, this, network);
        }

        public void onAvailable(Network network) {
            InvokeDynamicSupport.bootstrap("onAvailable", $$robo$$android_net_ConnectivityManager_NetworkCallback$onAvailable(android.net.Network ), 0, this, network);
        }

        public void onLosing(Network network, int n) {
            InvokeDynamicSupport.bootstrap("onLosing", $$robo$$android_net_ConnectivityManager_NetworkCallback$onLosing(android.net.Network int ), 0, this, network, n);
        }

        public void onLost(Network network) {
            InvokeDynamicSupport.bootstrap("onLost", $$robo$$android_net_ConnectivityManager_NetworkCallback$onLost(android.net.Network ), 0, this, network);
        }

        public void onUnavailable() {
            InvokeDynamicSupport.bootstrap("onUnavailable", $$robo$$android_net_ConnectivityManager_NetworkCallback$onUnavailable(), 0, this);
        }

        public void onCapabilitiesChanged(Network network, NetworkCapabilities networkCapabilities) {
            InvokeDynamicSupport.bootstrap("onCapabilitiesChanged", $$robo$$android_net_ConnectivityManager_NetworkCallback$onCapabilitiesChanged(android.net.Network android.net.NetworkCapabilities ), 0, this, network, networkCapabilities);
        }

        public void onLinkPropertiesChanged(Network network, LinkProperties linkProperties) {
            InvokeDynamicSupport.bootstrap("onLinkPropertiesChanged", $$robo$$android_net_ConnectivityManager_NetworkCallback$onLinkPropertiesChanged(android.net.Network android.net.LinkProperties ), 0, this, network, linkProperties);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NetworkCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface OnNetworkActiveListener
    extends InstrumentedInterface {
        public void onNetworkActive();
    }

    private static class LegacyRequest
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        NetworkCapabilities networkCapabilities;
        NetworkRequest networkRequest;
        int expireSequenceNumber;
        Network currentNetwork;
        int delay;
        NetworkCallback networkCallback;

        private void $$robo$$android_net_ConnectivityManager_LegacyRequest$__constructor__() {
            this.delay = -1;
            this.networkCallback = new ShadowedObject(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ LegacyRequest this$0;

                private void $$robo$$android_net_ConnectivityManager_LegacyRequest_1$__constructor__(LegacyRequest legacyRequest) {
                }

                private final void $$robo$$android_net_ConnectivityManager_LegacyRequest_1$onAvailable(Network network) {
                    this.this$0.currentNetwork = network;
                    Log.d("ConnectivityManager", "startUsingNetworkFeature got Network:" + network);
                    ConnectivityManager.setProcessDefaultNetworkForHostResolution(network);
                }

                private final void $$robo$$android_net_ConnectivityManager_LegacyRequest_1$onLost(Network network) {
                    if (network.equals(this.this$0.currentNetwork)) {
                        this.this$0.currentNetwork = null;
                        ConnectivityManager.setProcessDefaultNetworkForHostResolution(null);
                    }
                    Log.d("ConnectivityManager", "startUsingNetworkFeature lost Network:" + network);
                }

                private void __constructor__(LegacyRequest legacyRequest) {
                    this.$$robo$$android_net_ConnectivityManager_LegacyRequest_1$__constructor__(legacyRequest);
                }
                {
                    this.this$0 = legacyRequest;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_ConnectivityManager_LegacyRequest_1$__constructor__(android.net.ConnectivityManager$LegacyRequest ), 0, this, legacyRequest);
                }

                @Override
                public void onAvailable(Network network) {
                    InvokeDynamicSupport.bootstrap("onAvailable", $$robo$$android_net_ConnectivityManager_LegacyRequest_1$onAvailable(android.net.Network ), 0, this, network);
                }

                @Override
                public void onLost(Network network) {
                    InvokeDynamicSupport.bootstrap("onLost", $$robo$$android_net_ConnectivityManager_LegacyRequest_1$onLost(android.net.Network ), 0, this, network);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private /* synthetic */ void $$robo$$android_net_ConnectivityManager_LegacyRequest$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_net_ConnectivityManager_LegacyRequest$__constructor__();
        }

        private LegacyRequest() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_ConnectivityManager_LegacyRequest$__constructor__(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_net_ConnectivityManager_LegacyRequest$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LegacyRequest)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

