/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.LinkAddress;
import android.net.NetworkUtils;
import android.net.StaticIpConfiguration;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.Objects;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class DhcpResults
extends StaticIpConfiguration
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "DhcpResults";
    public InetAddress serverAddress;
    public String vendorInfo;
    public int leaseDuration;
    public static Parcelable.Creator<DhcpResults> CREATOR;

    private void $$robo$$android_net_DhcpResults$__constructor__() {
    }

    private void $$robo$$android_net_DhcpResults$__constructor__(StaticIpConfiguration source) {
    }

    private void $$robo$$android_net_DhcpResults$__constructor__(DhcpResults source) {
        if (source != null) {
            this.serverAddress = source.serverAddress;
            this.vendorInfo = source.vendorInfo;
            this.leaseDuration = source.leaseDuration;
        }
    }

    private final void $$robo$$android_net_DhcpResults$updateFromDhcpRequest(DhcpResults orig) {
        if (orig == null) {
            return;
        }
        if (this.gateway == null) {
            this.gateway = orig.gateway;
        }
        if (this.dnsServers.size() == 0) {
            this.dnsServers.addAll(orig.dnsServers);
        }
    }

    private final boolean $$robo$$android_net_DhcpResults$hasMeteredHint() {
        if (this.vendorInfo != null) {
            return this.vendorInfo.contains("ANDROID_METERED");
        }
        return false;
    }

    private final void $$robo$$android_net_DhcpResults$clear() {
        super.clear();
        this.vendorInfo = null;
        this.leaseDuration = 0;
    }

    private final String $$robo$$android_net_DhcpResults$toString() {
        StringBuffer str = new StringBuffer(super.toString());
        str.append(" DHCP server ").append(this.serverAddress);
        str.append(" Vendor info ").append(this.vendorInfo);
        str.append(" lease ").append(this.leaseDuration).append(" seconds");
        return str.toString();
    }

    private final boolean $$robo$$android_net_DhcpResults$equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DhcpResults)) {
            return false;
        }
        DhcpResults target = (DhcpResults)obj;
        return super.equals((StaticIpConfiguration)obj) && Objects.equals(this.serverAddress, target.serverAddress) && Objects.equals(this.vendorInfo, target.vendorInfo) && this.leaseDuration == target.leaseDuration;
    }

    private final void $$robo$$android_net_DhcpResults$writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeInt(this.leaseDuration);
        NetworkUtils.parcelInetAddress(dest, this.serverAddress, flags);
        dest.writeString(this.vendorInfo);
    }

    private static final void $$robo$$android_net_DhcpResults$readFromParcel(DhcpResults dhcpResults, Parcel in) {
        StaticIpConfiguration.readFromParcel(dhcpResults, in);
        dhcpResults.leaseDuration = in.readInt();
        dhcpResults.serverAddress = NetworkUtils.unparcelInetAddress(in);
        dhcpResults.vendorInfo = in.readString();
    }

    private final boolean $$robo$$android_net_DhcpResults$setIpAddress(String addrString, int prefixLength) {
        try {
            Inet4Address addr = (Inet4Address)NetworkUtils.numericToInetAddress(addrString);
            this.ipAddress = new LinkAddress(addr, prefixLength);
        }
        catch (ClassCastException | IllegalArgumentException e) {
            Log.e("DhcpResults", "setIpAddress failed with addrString " + addrString + "/" + prefixLength);
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_net_DhcpResults$setGateway(String addrString) {
        try {
            this.gateway = NetworkUtils.numericToInetAddress(addrString);
        }
        catch (IllegalArgumentException e) {
            Log.e("DhcpResults", "setGateway failed with addrString " + addrString);
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_net_DhcpResults$addDns(String addrString) {
        if (!TextUtils.isEmpty(addrString)) {
            try {
                this.dnsServers.add(NetworkUtils.numericToInetAddress(addrString));
            }
            catch (IllegalArgumentException e) {
                Log.e("DhcpResults", "addDns failed with addrString " + addrString);
                return true;
            }
        }
        return false;
    }

    private final boolean $$robo$$android_net_DhcpResults$setServerAddress(String addrString) {
        try {
            this.serverAddress = NetworkUtils.numericToInetAddress(addrString);
        }
        catch (IllegalArgumentException e) {
            Log.e("DhcpResults", "setServerAddress failed with addrString " + addrString);
            return true;
        }
        return false;
    }

    private final void $$robo$$android_net_DhcpResults$setLeaseDuration(int duration) {
        this.leaseDuration = duration;
    }

    private final void $$robo$$android_net_DhcpResults$setVendorInfo(String info) {
        this.vendorInfo = info;
    }

    private final void $$robo$$android_net_DhcpResults$setDomains(String domains) {
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<DhcpResults>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_net_DhcpResults_1$__constructor__() {
            }

            private final DhcpResults $$robo$$android_net_DhcpResults_1$createFromParcel(Parcel in) {
                DhcpResults dhcpResults = new DhcpResults();
                DhcpResults.readFromParcel(dhcpResults, in);
                return dhcpResults;
            }

            private final DhcpResults[] $$robo$$android_net_DhcpResults_1$newArray(int size) {
                return new DhcpResults[size];
            }

            private void __constructor__() {
                this.$$robo$$android_net_DhcpResults_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_DhcpResults_1$__constructor__(), 0, this);
            }

            @Override
            public DhcpResults createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_DhcpResults_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public DhcpResults[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_DhcpResults_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__() {
        this.$$robo$$android_net_DhcpResults$__constructor__();
    }

    public DhcpResults() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_DhcpResults$__constructor__(), 0, this);
    }

    private void __constructor__(StaticIpConfiguration staticIpConfiguration) {
        this.$$robo$$android_net_DhcpResults$__constructor__(staticIpConfiguration);
    }

    public DhcpResults(StaticIpConfiguration staticIpConfiguration) {
        super(staticIpConfiguration);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_DhcpResults$__constructor__(android.net.StaticIpConfiguration ), 0, this, staticIpConfiguration);
    }

    private void __constructor__(DhcpResults dhcpResults) {
        this.$$robo$$android_net_DhcpResults$__constructor__(dhcpResults);
    }

    public DhcpResults(DhcpResults dhcpResults) {
        super(dhcpResults);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_DhcpResults$__constructor__(android.net.DhcpResults ), 0, this, dhcpResults);
    }

    public void updateFromDhcpRequest(DhcpResults dhcpResults) {
        InvokeDynamicSupport.bootstrap("updateFromDhcpRequest", $$robo$$android_net_DhcpResults$updateFromDhcpRequest(android.net.DhcpResults ), 0, this, dhcpResults);
    }

    public boolean hasMeteredHint() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasMeteredHint", $$robo$$android_net_DhcpResults$hasMeteredHint(), 0, this);
    }

    @Override
    public void clear() {
        InvokeDynamicSupport.bootstrap("clear", $$robo$$android_net_DhcpResults$clear(), 0, this);
    }

    @Override
    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_DhcpResults$toString(), 0, this);
    }

    @Override
    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_net_DhcpResults$equals(java.lang.Object ), 0, this, object);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_DhcpResults$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    private static void readFromParcel(DhcpResults dhcpResults, Parcel parcel) {
        InvokeDynamicSupport.bootstrapStatic("readFromParcel", $$robo$$android_net_DhcpResults$readFromParcel(android.net.DhcpResults android.os.Parcel ), 0, (DhcpResults)dhcpResults, (Parcel)parcel);
    }

    public boolean setIpAddress(String string2, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("setIpAddress", $$robo$$android_net_DhcpResults$setIpAddress(java.lang.String int ), 0, this, string2, n);
    }

    public boolean setGateway(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("setGateway", $$robo$$android_net_DhcpResults$setGateway(java.lang.String ), 0, this, string2);
    }

    public boolean addDns(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("addDns", $$robo$$android_net_DhcpResults$addDns(java.lang.String ), 0, this, string2);
    }

    public boolean setServerAddress(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("setServerAddress", $$robo$$android_net_DhcpResults$setServerAddress(java.lang.String ), 0, this, string2);
    }

    public void setLeaseDuration(int n) {
        InvokeDynamicSupport.bootstrap("setLeaseDuration", $$robo$$android_net_DhcpResults$setLeaseDuration(int ), 0, this, n);
    }

    public void setVendorInfo(String string2) {
        InvokeDynamicSupport.bootstrap("setVendorInfo", $$robo$$android_net_DhcpResults$setVendorInfo(java.lang.String ), 0, this, string2);
    }

    public void setDomains(String string2) {
        InvokeDynamicSupport.bootstrap("setDomains", $$robo$$android_net_DhcpResults$setDomains(java.lang.String ), 0, this, string2);
    }

    static {
        RobolectricInternals.classInitializing(DhcpResults.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DhcpResults)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

