/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.DhcpResults;
import android.net.NetworkUtils;
import android.os.Message;
import android.os.PowerManager;
import android.os.SystemClock;
import android.util.Log;
import com.android.internal.util.State;
import com.android.internal.util.StateMachine;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class DhcpStateMachine
extends StateMachine
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "DhcpStateMachine";
    private static boolean DBG = false;
    private StateMachine mController;
    private Context mContext;
    private BroadcastReceiver mBroadcastReceiver;
    private AlarmManager mAlarmManager;
    private PendingIntent mDhcpRenewalIntent;
    private PowerManager.WakeLock mDhcpRenewWakeLock;
    private static String WAKELOCK_TAG = "DHCP";
    private DhcpResults mDhcpResults;
    private static int DHCP_RENEW = 0;
    private static String ACTION_DHCP_RENEW = "android.net.wifi.DHCP_RENEW";
    private static int MIN_RENEWAL_TIME_SECS = 300;
    private String mInterfaceName;
    private boolean mRegisteredForPreDhcpNotification;
    private static int BASE = 196608;
    public static int CMD_START_DHCP = 196609;
    public static int CMD_STOP_DHCP = 196610;
    public static int CMD_RENEW_DHCP = 196611;
    public static int CMD_PRE_DHCP_ACTION = 196612;
    public static int CMD_POST_DHCP_ACTION = 196613;
    public static int CMD_ON_QUIT = 196614;
    public static int CMD_PRE_DHCP_ACTION_COMPLETE = 196615;
    public static int DHCP_SUCCESS = 1;
    public static int DHCP_FAILURE = 2;
    private State mDefaultState;
    private State mStoppedState;
    private State mWaitBeforeStartState;
    private State mRunningState;
    private State mWaitBeforeRenewalState;

    private void $$robo$$android_net_DhcpStateMachine$__constructor__(Context context, StateMachine controller, String intf) {
        this.mRegisteredForPreDhcpNotification = false;
        this.mDefaultState = new DefaultState(this);
        this.mStoppedState = new StoppedState(this);
        this.mWaitBeforeStartState = new WaitBeforeStartState(this);
        this.mRunningState = new RunningState(this);
        this.mWaitBeforeRenewalState = new WaitBeforeRenewalState(this);
        this.mContext = context;
        this.mController = controller;
        this.mInterfaceName = intf;
        this.mAlarmManager = (AlarmManager)this.mContext.getSystemService("alarm");
        Intent dhcpRenewalIntent = new Intent("android.net.wifi.DHCP_RENEW", null);
        this.mDhcpRenewalIntent = PendingIntent.getBroadcast(this.mContext, 0, dhcpRenewalIntent, 0);
        PowerManager powerManager = (PowerManager)this.mContext.getSystemService("power");
        this.mDhcpRenewWakeLock = powerManager.newWakeLock(1, "DHCP");
        this.mDhcpRenewWakeLock.setReferenceCounted(false);
        this.mBroadcastReceiver = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ DhcpStateMachine this$0;

            private void $$robo$$android_net_DhcpStateMachine_1$__constructor__(DhcpStateMachine dhcpStateMachine) {
            }

            private final void $$robo$$android_net_DhcpStateMachine_1$onReceive(Context context, Intent intent) {
                this.this$0.mDhcpRenewWakeLock.acquire(40000L);
                this.this$0.sendMessage(196611);
            }

            private void __constructor__(DhcpStateMachine dhcpStateMachine) {
                this.$$robo$$android_net_DhcpStateMachine_1$__constructor__(dhcpStateMachine);
            }
            {
                this.this$0 = dhcpStateMachine;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_DhcpStateMachine_1$__constructor__(android.net.DhcpStateMachine ), 0, this, dhcpStateMachine);
            }

            @Override
            public void onReceive(Context context, Intent intent) {
                InvokeDynamicSupport.bootstrap("onReceive", $$robo$$android_net_DhcpStateMachine_1$onReceive(android.content.Context android.content.Intent ), 0, this, context, intent);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mContext.registerReceiver(this.mBroadcastReceiver, new IntentFilter("android.net.wifi.DHCP_RENEW"));
        this.addState(this.mDefaultState);
        this.addState(this.mStoppedState, this.mDefaultState);
        this.addState(this.mWaitBeforeStartState, this.mDefaultState);
        this.addState(this.mRunningState, this.mDefaultState);
        this.addState(this.mWaitBeforeRenewalState, this.mDefaultState);
        this.setInitialState(this.mStoppedState);
    }

    private static final DhcpStateMachine $$robo$$android_net_DhcpStateMachine$makeDhcpStateMachine(Context context, StateMachine controller, String intf) {
        DhcpStateMachine dsm = new DhcpStateMachine(context, controller, intf);
        dsm.start();
        return dsm;
    }

    private final void $$robo$$android_net_DhcpStateMachine$registerForPreDhcpNotification() {
        this.mRegisteredForPreDhcpNotification = true;
    }

    private final void $$robo$$android_net_DhcpStateMachine$doQuit() {
        this.quit();
    }

    private final void $$robo$$android_net_DhcpStateMachine$onQuitting() {
        this.mController.sendMessage(196614);
    }

    private final boolean $$robo$$android_net_DhcpStateMachine$runDhcp(DhcpAction dhcpAction) {
        boolean success = false;
        DhcpResults dhcpResults = new DhcpResults();
        if (dhcpAction == DhcpAction.START) {
            NetworkUtils.stopDhcp(this.mInterfaceName);
            success = NetworkUtils.runDhcp(this.mInterfaceName, dhcpResults);
        } else if (dhcpAction == DhcpAction.RENEW && (success = NetworkUtils.runDhcpRenew(this.mInterfaceName, dhcpResults))) {
            dhcpResults.updateFromDhcpRequest(this.mDhcpResults);
        }
        if (success) {
            long leaseDuration = dhcpResults.leaseDuration;
            if (leaseDuration >= 0L) {
                if (leaseDuration < 300L) {
                    leaseDuration = 300L;
                }
                this.mAlarmManager.setExact(2, SystemClock.elapsedRealtime() + leaseDuration * 480L, this.mDhcpRenewalIntent);
            }
            this.mDhcpResults = dhcpResults;
            this.mController.obtainMessage(196613, 1, 0, dhcpResults).sendToTarget();
        } else {
            Log.e("DhcpStateMachine", "DHCP failed on " + this.mInterfaceName + ": " + NetworkUtils.getDhcpError());
            NetworkUtils.stopDhcp(this.mInterfaceName);
            this.mController.obtainMessage(196613, 2, 0).sendToTarget();
        }
        return success;
    }

    private void __constructor__(Context context, StateMachine stateMachine, String string2) {
        this.$$robo$$android_net_DhcpStateMachine$__constructor__(context, stateMachine, string2);
    }

    private DhcpStateMachine(Context context, StateMachine stateMachine, String string2) {
        super("DhcpStateMachine");
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_DhcpStateMachine$__constructor__(android.content.Context com.android.internal.util.StateMachine java.lang.String ), 0, this, context, stateMachine, string2);
    }

    public static DhcpStateMachine makeDhcpStateMachine(Context context, StateMachine stateMachine, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("makeDhcpStateMachine", $$robo$$android_net_DhcpStateMachine$makeDhcpStateMachine(android.content.Context com.android.internal.util.StateMachine java.lang.String ), 0, (Context)context, (StateMachine)stateMachine, (String)string2);
    }

    public void registerForPreDhcpNotification() {
        InvokeDynamicSupport.bootstrap("registerForPreDhcpNotification", $$robo$$android_net_DhcpStateMachine$registerForPreDhcpNotification(), 0, this);
    }

    public void doQuit() {
        InvokeDynamicSupport.bootstrap("doQuit", $$robo$$android_net_DhcpStateMachine$doQuit(), 0, this);
    }

    @Override
    protected void onQuitting() {
        InvokeDynamicSupport.bootstrap("onQuitting", $$robo$$android_net_DhcpStateMachine$onQuitting(), 0, this);
    }

    private boolean runDhcp(DhcpAction dhcpAction) {
        return (boolean)InvokeDynamicSupport.bootstrap("runDhcp", $$robo$$android_net_DhcpStateMachine$runDhcp(android.net.DhcpStateMachine$DhcpAction ), 0, this, dhcpAction);
    }

    public /* synthetic */ DhcpStateMachine() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DhcpStateMachine)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public class WaitBeforeRenewalState
    extends State
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ DhcpStateMachine this$0;

        private void $$robo$$android_net_DhcpStateMachine_WaitBeforeRenewalState$__constructor__(DhcpStateMachine dhcpStateMachine) {
        }

        private final void $$robo$$android_net_DhcpStateMachine_WaitBeforeRenewalState$enter() {
        }

        private final boolean $$robo$$android_net_DhcpStateMachine_WaitBeforeRenewalState$processMessage(Message message) {
            boolean retValue = true;
            switch (message.what) {
                case 196610: {
                    this.this$0.mAlarmManager.cancel(this.this$0.mDhcpRenewalIntent);
                    if (!NetworkUtils.stopDhcp(this.this$0.mInterfaceName)) {
                        Log.e("DhcpStateMachine", "Failed to stop Dhcp on " + this.this$0.mInterfaceName);
                    }
                    this.this$0.transitionTo(this.this$0.mStoppedState);
                    break;
                }
                case 196615: {
                    if (this.this$0.runDhcp(DhcpAction.RENEW)) {
                        this.this$0.transitionTo(this.this$0.mRunningState);
                        break;
                    }
                    this.this$0.transitionTo(this.this$0.mStoppedState);
                    break;
                }
                case 196609: {
                    break;
                }
                default: {
                    retValue = false;
                }
            }
            return retValue;
        }

        private final void $$robo$$android_net_DhcpStateMachine_WaitBeforeRenewalState$exit() {
            this.this$0.mDhcpRenewWakeLock.release();
        }

        private void __constructor__(DhcpStateMachine dhcpStateMachine) {
            this.$$robo$$android_net_DhcpStateMachine_WaitBeforeRenewalState$__constructor__(dhcpStateMachine);
        }

        WaitBeforeRenewalState(DhcpStateMachine dhcpStateMachine) {
            this.this$0 = dhcpStateMachine;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_DhcpStateMachine_WaitBeforeRenewalState$__constructor__(android.net.DhcpStateMachine ), 0, this, dhcpStateMachine);
        }

        @Override
        public void enter() {
            InvokeDynamicSupport.bootstrap("enter", $$robo$$android_net_DhcpStateMachine_WaitBeforeRenewalState$enter(), 0, this);
        }

        @Override
        public boolean processMessage(Message message) {
            return (boolean)InvokeDynamicSupport.bootstrap("processMessage", $$robo$$android_net_DhcpStateMachine_WaitBeforeRenewalState$processMessage(android.os.Message ), 0, this, message);
        }

        @Override
        public void exit() {
            InvokeDynamicSupport.bootstrap("exit", $$robo$$android_net_DhcpStateMachine_WaitBeforeRenewalState$exit(), 0, this);
        }

        public /* synthetic */ WaitBeforeRenewalState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WaitBeforeRenewalState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class RunningState
    extends State
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ DhcpStateMachine this$0;

        private void $$robo$$android_net_DhcpStateMachine_RunningState$__constructor__(DhcpStateMachine dhcpStateMachine) {
        }

        private final void $$robo$$android_net_DhcpStateMachine_RunningState$enter() {
        }

        private final boolean $$robo$$android_net_DhcpStateMachine_RunningState$processMessage(Message message) {
            boolean retValue = true;
            switch (message.what) {
                case 196610: {
                    this.this$0.mAlarmManager.cancel(this.this$0.mDhcpRenewalIntent);
                    if (!NetworkUtils.stopDhcp(this.this$0.mInterfaceName)) {
                        Log.e("DhcpStateMachine", "Failed to stop Dhcp on " + this.this$0.mInterfaceName);
                    }
                    this.this$0.transitionTo(this.this$0.mStoppedState);
                    break;
                }
                case 196611: {
                    if (this.this$0.mRegisteredForPreDhcpNotification) {
                        this.this$0.mController.sendMessage(196612);
                        this.this$0.transitionTo(this.this$0.mWaitBeforeRenewalState);
                        break;
                    }
                    if (!this.this$0.runDhcp(DhcpAction.RENEW)) {
                        this.this$0.transitionTo(this.this$0.mStoppedState);
                    }
                    this.this$0.mDhcpRenewWakeLock.release();
                    break;
                }
                case 196609: {
                    break;
                }
                default: {
                    retValue = false;
                }
            }
            return retValue;
        }

        private void __constructor__(DhcpStateMachine dhcpStateMachine) {
            this.$$robo$$android_net_DhcpStateMachine_RunningState$__constructor__(dhcpStateMachine);
        }

        RunningState(DhcpStateMachine dhcpStateMachine) {
            this.this$0 = dhcpStateMachine;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_DhcpStateMachine_RunningState$__constructor__(android.net.DhcpStateMachine ), 0, this, dhcpStateMachine);
        }

        @Override
        public void enter() {
            InvokeDynamicSupport.bootstrap("enter", $$robo$$android_net_DhcpStateMachine_RunningState$enter(), 0, this);
        }

        @Override
        public boolean processMessage(Message message) {
            return (boolean)InvokeDynamicSupport.bootstrap("processMessage", $$robo$$android_net_DhcpStateMachine_RunningState$processMessage(android.os.Message ), 0, this, message);
        }

        public /* synthetic */ RunningState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RunningState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class WaitBeforeStartState
    extends State
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ DhcpStateMachine this$0;

        private void $$robo$$android_net_DhcpStateMachine_WaitBeforeStartState$__constructor__(DhcpStateMachine dhcpStateMachine) {
        }

        private final void $$robo$$android_net_DhcpStateMachine_WaitBeforeStartState$enter() {
        }

        private final boolean $$robo$$android_net_DhcpStateMachine_WaitBeforeStartState$processMessage(Message message) {
            boolean retValue = true;
            switch (message.what) {
                case 196615: {
                    if (this.this$0.runDhcp(DhcpAction.START)) {
                        this.this$0.transitionTo(this.this$0.mRunningState);
                        break;
                    }
                    this.this$0.transitionTo(this.this$0.mStoppedState);
                    break;
                }
                case 196610: {
                    this.this$0.transitionTo(this.this$0.mStoppedState);
                    break;
                }
                case 196609: {
                    break;
                }
                default: {
                    retValue = false;
                }
            }
            return retValue;
        }

        private void __constructor__(DhcpStateMachine dhcpStateMachine) {
            this.$$robo$$android_net_DhcpStateMachine_WaitBeforeStartState$__constructor__(dhcpStateMachine);
        }

        WaitBeforeStartState(DhcpStateMachine dhcpStateMachine) {
            this.this$0 = dhcpStateMachine;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_DhcpStateMachine_WaitBeforeStartState$__constructor__(android.net.DhcpStateMachine ), 0, this, dhcpStateMachine);
        }

        @Override
        public void enter() {
            InvokeDynamicSupport.bootstrap("enter", $$robo$$android_net_DhcpStateMachine_WaitBeforeStartState$enter(), 0, this);
        }

        @Override
        public boolean processMessage(Message message) {
            return (boolean)InvokeDynamicSupport.bootstrap("processMessage", $$robo$$android_net_DhcpStateMachine_WaitBeforeStartState$processMessage(android.os.Message ), 0, this, message);
        }

        public /* synthetic */ WaitBeforeStartState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WaitBeforeStartState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class StoppedState
    extends State
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ DhcpStateMachine this$0;

        private void $$robo$$android_net_DhcpStateMachine_StoppedState$__constructor__(DhcpStateMachine dhcpStateMachine) {
        }

        private final void $$robo$$android_net_DhcpStateMachine_StoppedState$enter() {
        }

        private final boolean $$robo$$android_net_DhcpStateMachine_StoppedState$processMessage(Message message) {
            boolean retValue = true;
            switch (message.what) {
                case 196609: {
                    if (this.this$0.mRegisteredForPreDhcpNotification) {
                        this.this$0.mController.sendMessage(196612);
                        this.this$0.transitionTo(this.this$0.mWaitBeforeStartState);
                        break;
                    }
                    if (!this.this$0.runDhcp(DhcpAction.START)) break;
                    this.this$0.transitionTo(this.this$0.mRunningState);
                    break;
                }
                case 196610: {
                    break;
                }
                default: {
                    retValue = false;
                }
            }
            return retValue;
        }

        private void __constructor__(DhcpStateMachine dhcpStateMachine) {
            this.$$robo$$android_net_DhcpStateMachine_StoppedState$__constructor__(dhcpStateMachine);
        }

        StoppedState(DhcpStateMachine dhcpStateMachine) {
            this.this$0 = dhcpStateMachine;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_DhcpStateMachine_StoppedState$__constructor__(android.net.DhcpStateMachine ), 0, this, dhcpStateMachine);
        }

        @Override
        public void enter() {
            InvokeDynamicSupport.bootstrap("enter", $$robo$$android_net_DhcpStateMachine_StoppedState$enter(), 0, this);
        }

        @Override
        public boolean processMessage(Message message) {
            return (boolean)InvokeDynamicSupport.bootstrap("processMessage", $$robo$$android_net_DhcpStateMachine_StoppedState$processMessage(android.os.Message ), 0, this, message);
        }

        public /* synthetic */ StoppedState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StoppedState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class DefaultState
    extends State
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ DhcpStateMachine this$0;

        private void $$robo$$android_net_DhcpStateMachine_DefaultState$__constructor__(DhcpStateMachine dhcpStateMachine) {
        }

        private final void $$robo$$android_net_DhcpStateMachine_DefaultState$exit() {
            this.this$0.mContext.unregisterReceiver(this.this$0.mBroadcastReceiver);
        }

        private final boolean $$robo$$android_net_DhcpStateMachine_DefaultState$processMessage(Message message) {
            switch (message.what) {
                case 196611: {
                    Log.e("DhcpStateMachine", "Error! Failed to handle a DHCP renewal on " + this.this$0.mInterfaceName);
                    this.this$0.mDhcpRenewWakeLock.release();
                    break;
                }
                default: {
                    Log.e("DhcpStateMachine", "Error! unhandled message  " + message);
                }
            }
            return true;
        }

        private void __constructor__(DhcpStateMachine dhcpStateMachine) {
            this.$$robo$$android_net_DhcpStateMachine_DefaultState$__constructor__(dhcpStateMachine);
        }

        DefaultState(DhcpStateMachine dhcpStateMachine) {
            this.this$0 = dhcpStateMachine;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_DhcpStateMachine_DefaultState$__constructor__(android.net.DhcpStateMachine ), 0, this, dhcpStateMachine);
        }

        @Override
        public void exit() {
            InvokeDynamicSupport.bootstrap("exit", $$robo$$android_net_DhcpStateMachine_DefaultState$exit(), 0, this);
        }

        @Override
        public boolean processMessage(Message message) {
            return (boolean)InvokeDynamicSupport.bootstrap("processMessage", $$robo$$android_net_DhcpStateMachine_DefaultState$processMessage(android.os.Message ), 0, this, message);
        }

        public /* synthetic */ DefaultState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DefaultState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class DhcpAction
    extends Enum<DhcpAction> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ DhcpAction START;
        public static /* enum */ DhcpAction RENEW;
        private static /* synthetic */ DhcpAction[] $VALUES;

        private static final DhcpAction[] $$robo$$android_net_DhcpStateMachine_DhcpAction$values() {
            return (DhcpAction[])$VALUES.clone();
        }

        private static final DhcpAction $$robo$$android_net_DhcpStateMachine_DhcpAction$valueOf(String name) {
            return Enum.valueOf(DhcpAction.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_net_DhcpStateMachine_DhcpAction$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            START = new DhcpAction();
            RENEW = new DhcpAction();
            $VALUES = new DhcpAction[]{START, RENEW};
        }

        public static DhcpAction[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_net_DhcpStateMachine_DhcpAction$values(), 0);
        }

        public static DhcpAction valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_net_DhcpStateMachine_DhcpAction$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_net_DhcpStateMachine_DhcpAction$__constructor__(string2, n);
        }

        private DhcpAction() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_DhcpStateMachine_DhcpAction$__constructor__(java.lang.String int ), 0, this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(DhcpAction.class);
        }

        public /* synthetic */ DhcpAction() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DhcpAction)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

