/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.LinkProperties;
import android.net.NetworkUtils;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.provider.Settings;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class DnsPinger
extends Handler
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static boolean DBG = false;
    private static int RECEIVE_POLL_INTERVAL_MS = 200;
    private static int DNS_PORT = 53;
    private static int SOCKET_TIMEOUT_MS = 1;
    private static Random sRandom;
    private static AtomicInteger sCounter;
    private ConnectivityManager mConnectivityManager;
    private Context mContext;
    private int mConnectionType;
    private Handler mTarget;
    private ArrayList<InetAddress> mDefaultDns;
    private String TAG;
    private AtomicInteger mCurrentToken;
    private static int BASE = 327680;
    public static int DNS_PING_RESULT = 327680;
    public static int TIMEOUT = -1;
    public static int SOCKET_EXCEPTION = -2;
    private static int ACTION_PING_DNS = 327681;
    private static int ACTION_LISTEN_FOR_RESPONSE = 327682;
    private static int ACTION_CANCEL_ALL_PINGS = 327683;
    private List<ActivePing> mActivePings;
    private int mEventCounter;
    private static byte[] mDnsQuery;

    private void $$robo$$android_net_DnsPinger$__constructor__(Context context, String TAG, Looper looper, Handler target, int connectionType) {
        this.mConnectivityManager = null;
        this.mCurrentToken = new AtomicInteger();
        this.mActivePings = new ArrayList<ActivePing>();
        this.TAG = TAG;
        this.mContext = context;
        this.mTarget = target;
        this.mConnectionType = connectionType;
        if (!ConnectivityManager.isNetworkTypeValid(connectionType)) {
            throw new IllegalArgumentException("Invalid connectionType in constructor: " + connectionType);
        }
        this.mDefaultDns = new ArrayList();
        this.mDefaultDns.add(this.getDefaultDns());
        this.mEventCounter = 0;
    }

    private final void $$robo$$android_net_DnsPinger$handleMessage(Message msg) {
        switch (msg.what) {
            case 327681: {
                DnsArg dnsArg = (DnsArg)msg.obj;
                if (dnsArg.seq != this.mCurrentToken.get()) break;
                try {
                    ActivePing newActivePing = new ActivePing(this);
                    InetAddress dnsAddress = dnsArg.dns;
                    newActivePing.internalId = msg.arg1;
                    newActivePing.timeout = msg.arg2;
                    newActivePing.socket = new DatagramSocket();
                    newActivePing.socket.setSoTimeout(1);
                    try {
                        newActivePing.socket.setNetworkInterface(NetworkInterface.getByName(this.getCurrentLinkProperties().getInterfaceName()));
                    }
                    catch (Exception e) {
                        this.loge("sendDnsPing::Error binding to socket " + e);
                    }
                    newActivePing.packetId = (short)sRandom.nextInt();
                    byte[] buf = (byte[])mDnsQuery.clone();
                    buf[0] = (byte)(newActivePing.packetId >> 8);
                    buf[1] = (byte)newActivePing.packetId;
                    DatagramPacket packet = new DatagramPacket(buf, buf.length, dnsAddress, 53);
                    newActivePing.socket.send(packet);
                    this.mActivePings.add(newActivePing);
                    ++this.mEventCounter;
                    this.sendMessageDelayed(this.obtainMessage(327682, this.mEventCounter, 0), 200L);
                }
                catch (IOException e) {
                    this.sendResponse(msg.arg1, -9999, -2);
                }
                break;
            }
            case 327682: {
                if (msg.arg1 != this.mEventCounter) break;
                for (ActivePing curPing : this.mActivePings) {
                    try {
                        byte[] responseBuf = new byte[2];
                        DatagramPacket replyPacket = new DatagramPacket(responseBuf, 2);
                        curPing.socket.receive(replyPacket);
                        if (responseBuf[0] != (byte)(curPing.packetId >> 8) || responseBuf[1] != (byte)curPing.packetId) continue;
                        curPing.result = (int)(SystemClock.elapsedRealtime() - curPing.start);
                    }
                    catch (SocketTimeoutException responseBuf) {
                    }
                    catch (Exception e) {
                        curPing.result = -2;
                    }
                }
                Iterator<ActivePing> iter = this.mActivePings.iterator();
                while (iter.hasNext()) {
                    ActivePing curPing;
                    curPing = iter.next();
                    if (curPing.result != null) {
                        this.sendResponse(curPing.internalId, curPing.packetId, curPing.result);
                        curPing.socket.close();
                        iter.remove();
                        continue;
                    }
                    if (SystemClock.elapsedRealtime() <= curPing.start + (long)curPing.timeout) continue;
                    this.sendResponse(curPing.internalId, curPing.packetId, -1);
                    curPing.socket.close();
                    iter.remove();
                }
                if (this.mActivePings.isEmpty()) break;
                this.sendMessageDelayed(this.obtainMessage(327682, this.mEventCounter, 0), 200L);
                break;
            }
            case 327683: {
                for (ActivePing activePing : this.mActivePings) {
                    activePing.socket.close();
                }
                this.mActivePings.clear();
            }
        }
    }

    private final List<InetAddress> $$robo$$android_net_DnsPinger$getDnsList() {
        LinkProperties curLinkProps = this.getCurrentLinkProperties();
        if (curLinkProps == null) {
            this.loge("getCurLinkProperties:: LP for type" + this.mConnectionType + " is null!");
            return this.mDefaultDns;
        }
        List<InetAddress> dnses = curLinkProps.getDnsServers();
        if (dnses == null || dnses.size() == 0) {
            this.loge("getDns::LinkProps has null dns - returning default");
            return this.mDefaultDns;
        }
        return new ArrayList<InetAddress>(dnses);
    }

    private final int $$robo$$android_net_DnsPinger$pingDnsAsync(InetAddress dns, int timeout, int delay) {
        int id2 = sCounter.incrementAndGet();
        this.sendMessageDelayed(this.obtainMessage(327681, id2, timeout, new DnsArg(this, dns, this.mCurrentToken.get())), delay);
        return id2;
    }

    private final void $$robo$$android_net_DnsPinger$cancelPings() {
        this.mCurrentToken.incrementAndGet();
        this.obtainMessage(327683).sendToTarget();
    }

    private final void $$robo$$android_net_DnsPinger$sendResponse(int internalId, int externalId, int responseVal) {
        this.mTarget.sendMessage(this.obtainMessage(327680, internalId, responseVal));
    }

    private final LinkProperties $$robo$$android_net_DnsPinger$getCurrentLinkProperties() {
        if (this.mConnectivityManager == null) {
            this.mConnectivityManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        }
        return this.mConnectivityManager.getLinkProperties(this.mConnectionType);
    }

    private final InetAddress $$robo$$android_net_DnsPinger$getDefaultDns() {
        String dns = Settings.Global.getString(this.mContext.getContentResolver(), "default_dns_server");
        if (dns == null || dns.length() == 0) {
            dns = this.mContext.getResources().getString(17039400);
        }
        try {
            return NetworkUtils.numericToInetAddress(dns);
        }
        catch (IllegalArgumentException e) {
            this.loge("getDefaultDns::malformed default dns address");
            return null;
        }
    }

    private final void $$robo$$android_net_DnsPinger$log(String s) {
        Log.d(this.TAG, s);
    }

    private final void $$robo$$android_net_DnsPinger$loge(String s) {
        Log.e(this.TAG, s);
    }

    static void __staticInitializer__() {
        sRandom = new Random();
        sCounter = new AtomicInteger();
        mDnsQuery = new byte[]{0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 3, 119, 119, 119, 6, 103, 111, 111, 103, 108, 101, 3, 99, 111, 109, 0, 0, 1, 0, 1};
    }

    private void __constructor__(Context context, String string2, Looper looper, Handler handler, int n) {
        this.$$robo$$android_net_DnsPinger$__constructor__(context, string2, looper, handler, n);
    }

    public DnsPinger(Context context, String string2, Looper looper, Handler handler, int n) {
        super(looper);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_DnsPinger$__constructor__(android.content.Context java.lang.String android.os.Looper android.os.Handler int ), 0, this, context, string2, looper, handler, n);
    }

    @Override
    public void handleMessage(Message message) {
        InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_net_DnsPinger$handleMessage(android.os.Message ), 0, this, message);
    }

    public List<InetAddress> getDnsList() {
        return InvokeDynamicSupport.bootstrap("getDnsList", $$robo$$android_net_DnsPinger$getDnsList(), 0, this);
    }

    public int pingDnsAsync(InetAddress inetAddress, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("pingDnsAsync", $$robo$$android_net_DnsPinger$pingDnsAsync(java.net.InetAddress int int ), 0, this, inetAddress, n, n2);
    }

    public void cancelPings() {
        InvokeDynamicSupport.bootstrap("cancelPings", $$robo$$android_net_DnsPinger$cancelPings(), 0, this);
    }

    private void sendResponse(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("sendResponse", $$robo$$android_net_DnsPinger$sendResponse(int int int ), 0, this, n, n2, n3);
    }

    private LinkProperties getCurrentLinkProperties() {
        return InvokeDynamicSupport.bootstrap("getCurrentLinkProperties", $$robo$$android_net_DnsPinger$getCurrentLinkProperties(), 0, this);
    }

    private InetAddress getDefaultDns() {
        return InvokeDynamicSupport.bootstrap("getDefaultDns", $$robo$$android_net_DnsPinger$getDefaultDns(), 0, this);
    }

    private void log(String string2) {
        InvokeDynamicSupport.bootstrap("log", $$robo$$android_net_DnsPinger$log(java.lang.String ), 0, this, string2);
    }

    private void loge(String string2) {
        InvokeDynamicSupport.bootstrap("loge", $$robo$$android_net_DnsPinger$loge(java.lang.String ), 0, this, string2);
    }

    static {
        RobolectricInternals.classInitializing(DnsPinger.class);
    }

    public /* synthetic */ DnsPinger() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DnsPinger)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class DnsArg
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        InetAddress dns;
        int seq;
        /* synthetic */ DnsPinger this$0;

        private void $$robo$$android_net_DnsPinger_DnsArg$__constructor__(DnsPinger dnsPinger, InetAddress d, int s) {
            this.dns = d;
            this.seq = s;
        }

        private void __constructor__(DnsPinger dnsPinger, InetAddress inetAddress, int n) {
            this.$$robo$$android_net_DnsPinger_DnsArg$__constructor__(dnsPinger, inetAddress, n);
        }

        DnsArg(DnsPinger dnsPinger, InetAddress inetAddress, int n) {
            this.this$0 = dnsPinger;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_DnsPinger_DnsArg$__constructor__(android.net.DnsPinger java.net.InetAddress int ), 0, this, dnsPinger, inetAddress, n);
        }

        public /* synthetic */ DnsArg() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DnsArg)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class ActivePing
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        DatagramSocket socket;
        int internalId;
        short packetId;
        int timeout;
        Integer result;
        long start;
        /* synthetic */ DnsPinger this$0;

        private void $$robo$$android_net_DnsPinger_ActivePing$__constructor__(DnsPinger dnsPinger) {
            this.start = SystemClock.elapsedRealtime();
        }

        private /* synthetic */ void $$robo$$android_net_DnsPinger_ActivePing$__constructor__(DnsPinger x0, 1 x1) {
        }

        private void __constructor__(DnsPinger dnsPinger) {
            this.$$robo$$android_net_DnsPinger_ActivePing$__constructor__(dnsPinger);
        }

        private ActivePing(DnsPinger dnsPinger) {
            this.this$0 = dnsPinger;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_DnsPinger_ActivePing$__constructor__(android.net.DnsPinger ), 0, this, dnsPinger);
        }

        private /* synthetic */ void __constructor__(DnsPinger dnsPinger, 1 var2_2) {
            this.$$robo$$android_net_DnsPinger_ActivePing$__constructor__(dnsPinger, var2_2);
        }

        public /* synthetic */ ActivePing() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ActivePing)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

