/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.BaseNetworkStateTracker;
import android.net.LinkProperties;
import android.net.LinkQualityInfo;
import android.net.MobileLinkQualityInfo;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.SamplingDataTracker;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.telephony.PhoneStateListener;
import android.telephony.SignalStrength;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Slog;
import com.android.internal.telephony.ITelephony;
import com.android.internal.telephony.PhoneConstants;
import com.android.internal.util.AsyncChannel;
import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.util.concurrent.atomic.AtomicBoolean;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class MobileDataStateTracker
extends BaseNetworkStateTracker
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "MobileDataStateTracker";
    private static boolean DBG = false;
    private static boolean VDBG = false;
    private PhoneConstants.DataState mMobileDataState;
    private ITelephony mPhoneService;
    private String mApnType;
    private NetworkInfo mNetworkInfo;
    private boolean mTeardownRequested;
    private Handler mTarget;
    private Context mContext;
    private LinkProperties mLinkProperties;
    private boolean mPrivateDnsRouteSet;
    private boolean mDefaultRouteSet;
    protected boolean mUserDataEnabled;
    protected boolean mPolicyDataEnabled;
    private Handler mHandler;
    private AsyncChannel mDataConnectionTrackerAc;
    private AtomicBoolean mIsCaptivePortal;
    private SignalStrength mSignalStrength;
    private SamplingDataTracker mSamplingDataTracker;
    private static int UNKNOWN = Integer.MAX_VALUE;
    private PhoneStateListener mPhoneStateListener;
    private static NetworkDataEntry[] mTheoreticalBWTable;

    private void $$robo$$android_net_MobileDataStateTracker$__constructor__(int netType, String tag) {
        this.mTeardownRequested = false;
        this.mPrivateDnsRouteSet = false;
        this.mDefaultRouteSet = false;
        this.mUserDataEnabled = true;
        this.mPolicyDataEnabled = true;
        this.mIsCaptivePortal = new AtomicBoolean(false);
        this.mSamplingDataTracker = new SamplingDataTracker();
        this.mPhoneStateListener = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ MobileDataStateTracker this$0;

            private void $$robo$$android_net_MobileDataStateTracker_1$__constructor__(MobileDataStateTracker mobileDataStateTracker) {
            }

            private final void $$robo$$android_net_MobileDataStateTracker_1$onSignalStrengthsChanged(SignalStrength signalStrength) {
                this.this$0.mSignalStrength = signalStrength;
            }

            private void __constructor__(MobileDataStateTracker mobileDataStateTracker) {
                this.$$robo$$android_net_MobileDataStateTracker_1$__constructor__(mobileDataStateTracker);
            }
            {
                this.this$0 = mobileDataStateTracker;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_MobileDataStateTracker_1$__constructor__(android.net.MobileDataStateTracker ), 0, this, mobileDataStateTracker);
            }

            @Override
            public void onSignalStrengthsChanged(SignalStrength signalStrength) {
                InvokeDynamicSupport.bootstrap("onSignalStrengthsChanged", $$robo$$android_net_MobileDataStateTracker_1$onSignalStrengthsChanged(android.telephony.SignalStrength ), 0, this, signalStrength);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mNetworkInfo = new NetworkInfo(netType, TelephonyManager.getDefault().getNetworkType(), tag, TelephonyManager.getDefault().getNetworkTypeName());
        this.mApnType = MobileDataStateTracker.networkTypeToApnType(netType);
    }

    private final void $$robo$$android_net_MobileDataStateTracker$startMonitoring(Context context, Handler target) {
        this.mTarget = target;
        this.mContext = context;
        this.mHandler = new MdstHandler(target.getLooper(), this);
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.ANY_DATA_STATE");
        filter.addAction("android.intent.action.DATA_CONNECTION_CONNECTED_TO_PROVISIONING_APN");
        filter.addAction("android.intent.action.DATA_CONNECTION_FAILED");
        this.mContext.registerReceiver(new MobileDataStateReceiver(this), filter);
        this.mMobileDataState = PhoneConstants.DataState.DISCONNECTED;
        TelephonyManager tm = (TelephonyManager)this.mContext.getSystemService("phone");
        tm.listen(this.mPhoneStateListener, 256);
    }

    private final boolean $$robo$$android_net_MobileDataStateTracker$isPrivateDnsRouteSet() {
        return this.mPrivateDnsRouteSet;
    }

    private final void $$robo$$android_net_MobileDataStateTracker$privateDnsRouteSet(boolean enabled) {
        this.mPrivateDnsRouteSet = enabled;
    }

    private final NetworkInfo $$robo$$android_net_MobileDataStateTracker$getNetworkInfo() {
        return this.mNetworkInfo;
    }

    private final boolean $$robo$$android_net_MobileDataStateTracker$isDefaultRouteSet() {
        return this.mDefaultRouteSet;
    }

    private final void $$robo$$android_net_MobileDataStateTracker$defaultRouteSet(boolean enabled) {
        this.mDefaultRouteSet = enabled;
    }

    private final void $$robo$$android_net_MobileDataStateTracker$releaseWakeLock() {
    }

    private final void $$robo$$android_net_MobileDataStateTracker$updateLinkProperitesAndCapatilities(Intent intent) {
        this.mLinkProperties = (LinkProperties)intent.getParcelableExtra("linkProperties");
        if (this.mLinkProperties == null) {
            this.loge("CONNECTED event did not supply link properties.");
            this.mLinkProperties = new LinkProperties();
        }
        this.mLinkProperties.setMtu(this.mContext.getResources().getInteger(17694832));
        this.mNetworkCapabilities = (NetworkCapabilities)intent.getParcelableExtra("networkCapabilities");
        if (this.mNetworkCapabilities == null) {
            this.loge("CONNECTED event did not supply network capabilities.");
            this.mNetworkCapabilities = new NetworkCapabilities();
        }
    }

    private final void $$robo$$android_net_MobileDataStateTracker$getPhoneService(boolean forceRefresh) {
        if (this.mPhoneService == null || forceRefresh) {
            this.mPhoneService = ITelephony.Stub.asInterface(ServiceManager.getService("phone"));
        }
    }

    private final boolean $$robo$$android_net_MobileDataStateTracker$isAvailable() {
        return this.mNetworkInfo.isAvailable();
    }

    private final String $$robo$$android_net_MobileDataStateTracker$getTcpBufferSizesPropName() {
        String networkTypeStr = "unknown";
        TelephonyManager tm = new TelephonyManager(this.mContext);
        switch (tm.getNetworkType()) {
            case 1: {
                networkTypeStr = "gprs";
                break;
            }
            case 2: {
                networkTypeStr = "edge";
                break;
            }
            case 3: {
                networkTypeStr = "umts";
                break;
            }
            case 8: {
                networkTypeStr = "hsdpa";
                break;
            }
            case 9: {
                networkTypeStr = "hsupa";
                break;
            }
            case 10: {
                networkTypeStr = "hspa";
                break;
            }
            case 15: {
                networkTypeStr = "hspap";
                break;
            }
            case 4: {
                networkTypeStr = "cdma";
                break;
            }
            case 7: {
                networkTypeStr = "1xrtt";
                break;
            }
            case 5: {
                networkTypeStr = "evdo";
                break;
            }
            case 6: {
                networkTypeStr = "evdo";
                break;
            }
            case 12: {
                networkTypeStr = "evdo";
                break;
            }
            case 11: {
                networkTypeStr = "iden";
                break;
            }
            case 13: {
                networkTypeStr = "lte";
                break;
            }
            case 14: {
                networkTypeStr = "ehrpd";
                break;
            }
            default: {
                this.loge("unknown network type: " + tm.getNetworkType());
            }
        }
        return "net.tcp.buffersize." + networkTypeStr;
    }

    private final boolean $$robo$$android_net_MobileDataStateTracker$teardown() {
        this.setTeardownRequested(true);
        return this.setEnableApn(this.mApnType, false) != 3;
    }

    private final boolean $$robo$$android_net_MobileDataStateTracker$isReady() {
        return this.mDataConnectionTrackerAc != null;
    }

    private final void $$robo$$android_net_MobileDataStateTracker$captivePortalCheckCompleted(boolean isCaptivePortal) {
        if (this.mIsCaptivePortal.getAndSet(isCaptivePortal) != isCaptivePortal) {
            this.setEnableFailFastMobileData(isCaptivePortal ? 1 : 0);
        }
    }

    private final void $$robo$$android_net_MobileDataStateTracker$setDetailedState(NetworkInfo.DetailedState state, String reason, String extraInfo) {
        if (state != this.mNetworkInfo.getDetailedState()) {
            boolean wasConnecting = this.mNetworkInfo.getState() == NetworkInfo.State.CONNECTING;
            String lastReason = this.mNetworkInfo.getReason();
            if (wasConnecting && state == NetworkInfo.DetailedState.CONNECTED && reason == null && lastReason != null) {
                reason = lastReason;
            }
            this.mNetworkInfo.setDetailedState(state, reason, extraInfo);
            Message msg = this.mTarget.obtainMessage(458752, new NetworkInfo(this.mNetworkInfo));
            msg.sendToTarget();
        }
    }

    private final void $$robo$$android_net_MobileDataStateTracker$setTeardownRequested(boolean isRequested) {
        this.mTeardownRequested = isRequested;
    }

    private final boolean $$robo$$android_net_MobileDataStateTracker$isTeardownRequested() {
        return this.mTeardownRequested;
    }

    private final boolean $$robo$$android_net_MobileDataStateTracker$reconnect() {
        boolean retValue = false;
        this.setTeardownRequested(false);
        switch (this.setEnableApn(this.mApnType, true)) {
            case 0: {
                retValue = true;
                break;
            }
            case 1: {
                this.mNetworkInfo.setDetailedState(NetworkInfo.DetailedState.IDLE, null, null);
                retValue = true;
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            default: {
                this.loge("Error in reconnect - unexpected response.");
            }
        }
        return retValue;
    }

    private final boolean $$robo$$android_net_MobileDataStateTracker$setRadio(boolean turnOn) {
        this.getPhoneService(false);
        for (int retry = 0; retry < 2; ++retry) {
            if (this.mPhoneService == null) {
                this.loge("Ignoring mobile radio request because could not acquire PhoneService");
                break;
            }
            try {
                return this.mPhoneService.setRadio(turnOn);
            }
            catch (RemoteException e) {
                if (retry != 0) continue;
                this.getPhoneService(true);
                continue;
            }
        }
        this.loge("Could not set radio power to " + (turnOn ? "on" : "off"));
        return false;
    }

    private final void $$robo$$android_net_MobileDataStateTracker$setInternalDataEnable(boolean enabled) {
        AsyncChannel channel = this.mDataConnectionTrackerAc;
        if (channel != null) {
            channel.sendMessage(270363, enabled ? 1 : 0);
        }
    }

    private final void $$robo$$android_net_MobileDataStateTracker$setUserDataEnable(boolean enabled) {
        AsyncChannel channel = this.mDataConnectionTrackerAc;
        if (channel != null) {
            channel.sendMessage(270366, enabled ? 1 : 0);
            this.mUserDataEnabled = enabled;
        }
    }

    private final void $$robo$$android_net_MobileDataStateTracker$setPolicyDataEnable(boolean enabled) {
        AsyncChannel channel = this.mDataConnectionTrackerAc;
        if (channel != null) {
            channel.sendMessage(270368, enabled ? 1 : 0);
            this.mPolicyDataEnabled = enabled;
        }
    }

    private final void $$robo$$android_net_MobileDataStateTracker$setEnableFailFastMobileData(int enabled) {
        AsyncChannel channel = this.mDataConnectionTrackerAc;
        if (channel != null) {
            channel.sendMessage(270372, enabled);
        }
    }

    private final void $$robo$$android_net_MobileDataStateTracker$setDependencyMet(boolean met) {
        Bundle bundle = Bundle.forPair("apnType", this.mApnType);
        try {
            Message msg = Message.obtain();
            msg.what = 270367;
            msg.arg1 = met ? 1 : 0;
            msg.setData(bundle);
            this.mDataConnectionTrackerAc.sendMessage(msg);
        }
        catch (NullPointerException e) {
            this.loge("setDependencyMet: X mAc was null" + e);
        }
    }

    private final void $$robo$$android_net_MobileDataStateTracker$enableMobileProvisioning(String url) {
        AsyncChannel channel = this.mDataConnectionTrackerAc;
        if (channel != null) {
            Message msg = Message.obtain();
            msg.what = 270373;
            msg.setData(Bundle.forPair("provisioningUrl", url));
            channel.sendMessage(msg);
        }
    }

    private final boolean $$robo$$android_net_MobileDataStateTracker$isProvisioningNetwork() {
        boolean retVal;
        try {
            Message msg = Message.obtain();
            msg.what = 270374;
            msg.setData(Bundle.forPair("apnType", this.mApnType));
            Message result = this.mDataConnectionTrackerAc.sendMessageSynchronously(msg);
            retVal = result.arg1 == 1;
        }
        catch (NullPointerException e) {
            this.loge("isProvisioningNetwork: X " + e);
            retVal = false;
        }
        return retVal;
    }

    private final void $$robo$$android_net_MobileDataStateTracker$addStackedLink(LinkProperties link) {
        this.mLinkProperties.addStackedLink(link);
    }

    private final void $$robo$$android_net_MobileDataStateTracker$removeStackedLink(LinkProperties link) {
        this.mLinkProperties.removeStackedLink(link);
    }

    private final String $$robo$$android_net_MobileDataStateTracker$toString() {
        CharArrayWriter writer = new CharArrayWriter();
        PrintWriter pw = new PrintWriter(writer);
        pw.print("Mobile data state: ");
        pw.println((Object)this.mMobileDataState);
        pw.print("Data enabled: user=");
        pw.print(this.mUserDataEnabled);
        pw.print(", policy=");
        pw.println(this.mPolicyDataEnabled);
        return writer.toString();
    }

    private final int $$robo$$android_net_MobileDataStateTracker$setEnableApn(String apnType, boolean enable) {
        this.getPhoneService(false);
        for (int retry = 0; retry < 2; ++retry) {
            if (this.mPhoneService != null) continue;
            this.loge("Ignoring feature request because could not acquire PhoneService");
            break;
        }
        this.loge("Could not " + (enable ? "enable" : "disable") + " APN type \"" + apnType + "\"");
        return 3;
    }

    private static final String $$robo$$android_net_MobileDataStateTracker$networkTypeToApnType(int netType) {
        switch (netType) {
            case 0: {
                return "default";
            }
            case 2: {
                return "mms";
            }
            case 3: {
                return "supl";
            }
            case 4: {
                return "dun";
            }
            case 5: {
                return "hipri";
            }
            case 10: {
                return "fota";
            }
            case 11: {
                return "ims";
            }
            case 12: {
                return "cbs";
            }
            case 14: {
                return "ia";
            }
            case 15: {
                return "emergency";
            }
        }
        MobileDataStateTracker.sloge("Error mapping networkType " + netType + " to apnType.");
        return null;
    }

    private final LinkProperties $$robo$$android_net_MobileDataStateTracker$getLinkProperties() {
        return new LinkProperties(this.mLinkProperties);
    }

    private final void $$robo$$android_net_MobileDataStateTracker$supplyMessenger(Messenger messenger) {
        AsyncChannel ac = new AsyncChannel();
        ac.connect(this.mContext, this.mHandler, messenger);
    }

    private final void $$robo$$android_net_MobileDataStateTracker$log(String s) {
        Slog.d("MobileDataStateTracker", this.mApnType + ": " + s);
    }

    private final void $$robo$$android_net_MobileDataStateTracker$loge(String s) {
        Slog.e("MobileDataStateTracker", this.mApnType + ": " + s);
    }

    private static final void $$robo$$android_net_MobileDataStateTracker$sloge(String s) {
        Slog.e("MobileDataStateTracker", s);
    }

    private final LinkQualityInfo $$robo$$android_net_MobileDataStateTracker$getLinkQualityInfo() {
        SignalStrength ss;
        if (this.mNetworkInfo == null || this.mNetworkInfo.getType() == -1) {
            return null;
        }
        MobileLinkQualityInfo li = new MobileLinkQualityInfo();
        li.setNetworkType(this.mNetworkInfo.getType());
        this.mSamplingDataTracker.setCommonLinkQualityInfoFields(li);
        if (this.mNetworkInfo.getSubtype() != 0) {
            li.setMobileNetworkType(this.mNetworkInfo.getSubtype());
            NetworkDataEntry entry = MobileDataStateTracker.getNetworkDataEntry(this.mNetworkInfo.getSubtype());
            if (entry != null) {
                li.setTheoreticalRxBandwidth(entry.downloadBandwidth);
                li.setTheoreticalRxBandwidth(entry.uploadBandwidth);
                li.setTheoreticalLatency(entry.latency);
            }
            if (this.mSignalStrength != null) {
                li.setNormalizedSignalStrength(MobileDataStateTracker.getNormalizedSignalStrength(li.getMobileNetworkType(), this.mSignalStrength));
            }
        }
        if ((ss = this.mSignalStrength) != null) {
            li.setRssi(ss.getGsmSignalStrength());
            li.setGsmErrorRate(ss.getGsmBitErrorRate());
            li.setCdmaDbm(ss.getCdmaDbm());
            li.setCdmaEcio(ss.getCdmaEcio());
            li.setEvdoDbm(ss.getEvdoDbm());
            li.setEvdoEcio(ss.getEvdoEcio());
            li.setEvdoSnr(ss.getEvdoSnr());
            li.setLteSignalStrength(ss.getLteSignalStrength());
            li.setLteRsrp(ss.getLteRsrp());
            li.setLteRsrq(ss.getLteRsrq());
            li.setLteRssnr(ss.getLteRssnr());
            li.setLteCqi(ss.getLteCqi());
        }
        return li;
    }

    private static final NetworkDataEntry $$robo$$android_net_MobileDataStateTracker$getNetworkDataEntry(int networkType) {
        for (NetworkDataEntry entry : mTheoreticalBWTable) {
            if (entry.networkType != networkType) continue;
            return entry;
        }
        Slog.e("MobileDataStateTracker", "Could not find Theoretical BW entry for " + String.valueOf(networkType));
        return null;
    }

    private static final int $$robo$$android_net_MobileDataStateTracker$getNormalizedSignalStrength(int networkType, SignalStrength ss) {
        int level;
        switch (networkType) {
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 15: {
                level = ss.getGsmLevel();
                break;
            }
            case 4: 
            case 7: {
                level = ss.getCdmaLevel();
                break;
            }
            case 5: 
            case 6: 
            case 12: {
                level = ss.getEvdoLevel();
                break;
            }
            case 13: {
                level = ss.getLteLevel();
                break;
            }
            default: {
                return Integer.MAX_VALUE;
            }
        }
        return level * 100 / 5;
    }

    private final void $$robo$$android_net_MobileDataStateTracker$startSampling(SamplingDataTracker.SamplingSnapshot s) {
        this.mSamplingDataTracker.startSampling(s);
    }

    private final void $$robo$$android_net_MobileDataStateTracker$stopSampling(SamplingDataTracker.SamplingSnapshot s) {
        this.mSamplingDataTracker.stopSampling(s);
    }

    static void __staticInitializer__() {
        mTheoreticalBWTable = new NetworkDataEntry[]{new NetworkDataEntry(2, 237, 118, Integer.MAX_VALUE), new NetworkDataEntry(1, 48, 40, Integer.MAX_VALUE), new NetworkDataEntry(3, 384, 64, Integer.MAX_VALUE), new NetworkDataEntry(8, 14400, Integer.MAX_VALUE, Integer.MAX_VALUE), new NetworkDataEntry(9, 14400, 5760, Integer.MAX_VALUE), new NetworkDataEntry(10, 14400, 5760, Integer.MAX_VALUE), new NetworkDataEntry(15, 21000, 5760, Integer.MAX_VALUE), new NetworkDataEntry(4, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE), new NetworkDataEntry(7, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE), new NetworkDataEntry(5, 2468, 153, Integer.MAX_VALUE), new NetworkDataEntry(6, 3072, 1800, Integer.MAX_VALUE), new NetworkDataEntry(12, 14700, 1800, Integer.MAX_VALUE), new NetworkDataEntry(11, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE), new NetworkDataEntry(13, 100000, 50000, Integer.MAX_VALUE), new NetworkDataEntry(14, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE)};
    }

    private void __constructor__(int n, String string2) {
        this.$$robo$$android_net_MobileDataStateTracker$__constructor__(n, string2);
    }

    public MobileDataStateTracker(int n, String string2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_MobileDataStateTracker$__constructor__(int java.lang.String ), 0, this, n, string2);
    }

    @Override
    public void startMonitoring(Context context, Handler handler) {
        InvokeDynamicSupport.bootstrap("startMonitoring", $$robo$$android_net_MobileDataStateTracker$startMonitoring(android.content.Context android.os.Handler ), 0, this, context, handler);
    }

    @Override
    public boolean isPrivateDnsRouteSet() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPrivateDnsRouteSet", $$robo$$android_net_MobileDataStateTracker$isPrivateDnsRouteSet(), 0, this);
    }

    @Override
    public void privateDnsRouteSet(boolean bl) {
        InvokeDynamicSupport.bootstrap("privateDnsRouteSet", $$robo$$android_net_MobileDataStateTracker$privateDnsRouteSet(boolean ), 0, this, bl);
    }

    @Override
    public NetworkInfo getNetworkInfo() {
        return InvokeDynamicSupport.bootstrap("getNetworkInfo", $$robo$$android_net_MobileDataStateTracker$getNetworkInfo(), 0, this);
    }

    @Override
    public boolean isDefaultRouteSet() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDefaultRouteSet", $$robo$$android_net_MobileDataStateTracker$isDefaultRouteSet(), 0, this);
    }

    @Override
    public void defaultRouteSet(boolean bl) {
        InvokeDynamicSupport.bootstrap("defaultRouteSet", $$robo$$android_net_MobileDataStateTracker$defaultRouteSet(boolean ), 0, this, bl);
    }

    public void releaseWakeLock() {
        InvokeDynamicSupport.bootstrap("releaseWakeLock", $$robo$$android_net_MobileDataStateTracker$releaseWakeLock(), 0, this);
    }

    private void updateLinkProperitesAndCapatilities(Intent intent) {
        InvokeDynamicSupport.bootstrap("updateLinkProperitesAndCapatilities", $$robo$$android_net_MobileDataStateTracker$updateLinkProperitesAndCapatilities(android.content.Intent ), 0, this, intent);
    }

    private void getPhoneService(boolean bl) {
        InvokeDynamicSupport.bootstrap("getPhoneService", $$robo$$android_net_MobileDataStateTracker$getPhoneService(boolean ), 0, this, bl);
    }

    @Override
    public boolean isAvailable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAvailable", $$robo$$android_net_MobileDataStateTracker$isAvailable(), 0, this);
    }

    @Override
    public String getTcpBufferSizesPropName() {
        return InvokeDynamicSupport.bootstrap("getTcpBufferSizesPropName", $$robo$$android_net_MobileDataStateTracker$getTcpBufferSizesPropName(), 0, this);
    }

    @Override
    public boolean teardown() {
        return (boolean)InvokeDynamicSupport.bootstrap("teardown", $$robo$$android_net_MobileDataStateTracker$teardown(), 0, this);
    }

    public boolean isReady() {
        return (boolean)InvokeDynamicSupport.bootstrap("isReady", $$robo$$android_net_MobileDataStateTracker$isReady(), 0, this);
    }

    @Override
    public void captivePortalCheckCompleted(boolean bl) {
        InvokeDynamicSupport.bootstrap("captivePortalCheckCompleted", $$robo$$android_net_MobileDataStateTracker$captivePortalCheckCompleted(boolean ), 0, this, bl);
    }

    private void setDetailedState(NetworkInfo.DetailedState detailedState, String string2, String string3) {
        InvokeDynamicSupport.bootstrap("setDetailedState", $$robo$$android_net_MobileDataStateTracker$setDetailedState(android.net.NetworkInfo$DetailedState java.lang.String java.lang.String ), 0, this, detailedState, string2, string3);
    }

    @Override
    public void setTeardownRequested(boolean bl) {
        InvokeDynamicSupport.bootstrap("setTeardownRequested", $$robo$$android_net_MobileDataStateTracker$setTeardownRequested(boolean ), 0, this, bl);
    }

    @Override
    public boolean isTeardownRequested() {
        return (boolean)InvokeDynamicSupport.bootstrap("isTeardownRequested", $$robo$$android_net_MobileDataStateTracker$isTeardownRequested(), 0, this);
    }

    @Override
    public boolean reconnect() {
        return (boolean)InvokeDynamicSupport.bootstrap("reconnect", $$robo$$android_net_MobileDataStateTracker$reconnect(), 0, this);
    }

    @Override
    public boolean setRadio(boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("setRadio", $$robo$$android_net_MobileDataStateTracker$setRadio(boolean ), 0, this, bl);
    }

    public void setInternalDataEnable(boolean bl) {
        InvokeDynamicSupport.bootstrap("setInternalDataEnable", $$robo$$android_net_MobileDataStateTracker$setInternalDataEnable(boolean ), 0, this, bl);
    }

    @Override
    public void setUserDataEnable(boolean bl) {
        InvokeDynamicSupport.bootstrap("setUserDataEnable", $$robo$$android_net_MobileDataStateTracker$setUserDataEnable(boolean ), 0, this, bl);
    }

    @Override
    public void setPolicyDataEnable(boolean bl) {
        InvokeDynamicSupport.bootstrap("setPolicyDataEnable", $$robo$$android_net_MobileDataStateTracker$setPolicyDataEnable(boolean ), 0, this, bl);
    }

    public void setEnableFailFastMobileData(int n) {
        InvokeDynamicSupport.bootstrap("setEnableFailFastMobileData", $$robo$$android_net_MobileDataStateTracker$setEnableFailFastMobileData(int ), 0, this, n);
    }

    @Override
    public void setDependencyMet(boolean bl) {
        InvokeDynamicSupport.bootstrap("setDependencyMet", $$robo$$android_net_MobileDataStateTracker$setDependencyMet(boolean ), 0, this, bl);
    }

    public void enableMobileProvisioning(String string2) {
        InvokeDynamicSupport.bootstrap("enableMobileProvisioning", $$robo$$android_net_MobileDataStateTracker$enableMobileProvisioning(java.lang.String ), 0, this, string2);
    }

    public boolean isProvisioningNetwork() {
        return (boolean)InvokeDynamicSupport.bootstrap("isProvisioningNetwork", $$robo$$android_net_MobileDataStateTracker$isProvisioningNetwork(), 0, this);
    }

    @Override
    public void addStackedLink(LinkProperties linkProperties) {
        InvokeDynamicSupport.bootstrap("addStackedLink", $$robo$$android_net_MobileDataStateTracker$addStackedLink(android.net.LinkProperties ), 0, this, linkProperties);
    }

    @Override
    public void removeStackedLink(LinkProperties linkProperties) {
        InvokeDynamicSupport.bootstrap("removeStackedLink", $$robo$$android_net_MobileDataStateTracker$removeStackedLink(android.net.LinkProperties ), 0, this, linkProperties);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_MobileDataStateTracker$toString(), 0, this);
    }

    private int setEnableApn(String string2, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("setEnableApn", $$robo$$android_net_MobileDataStateTracker$setEnableApn(java.lang.String boolean ), 0, this, string2, bl);
    }

    public static String networkTypeToApnType(int n) {
        return InvokeDynamicSupport.bootstrapStatic("networkTypeToApnType", $$robo$$android_net_MobileDataStateTracker$networkTypeToApnType(int ), 0, (int)n);
    }

    @Override
    public LinkProperties getLinkProperties() {
        return InvokeDynamicSupport.bootstrap("getLinkProperties", $$robo$$android_net_MobileDataStateTracker$getLinkProperties(), 0, this);
    }

    @Override
    public void supplyMessenger(Messenger messenger) {
        InvokeDynamicSupport.bootstrap("supplyMessenger", $$robo$$android_net_MobileDataStateTracker$supplyMessenger(android.os.Messenger ), 0, this, messenger);
    }

    private void log(String string2) {
        InvokeDynamicSupport.bootstrap("log", $$robo$$android_net_MobileDataStateTracker$log(java.lang.String ), 0, this, string2);
    }

    private void loge(String string2) {
        InvokeDynamicSupport.bootstrap("loge", $$robo$$android_net_MobileDataStateTracker$loge(java.lang.String ), 0, this, string2);
    }

    private static void sloge(String string2) {
        InvokeDynamicSupport.bootstrapStatic("sloge", $$robo$$android_net_MobileDataStateTracker$sloge(java.lang.String ), 0, (String)string2);
    }

    @Override
    public LinkQualityInfo getLinkQualityInfo() {
        return InvokeDynamicSupport.bootstrap("getLinkQualityInfo", $$robo$$android_net_MobileDataStateTracker$getLinkQualityInfo(), 0, this);
    }

    private static NetworkDataEntry getNetworkDataEntry(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getNetworkDataEntry", $$robo$$android_net_MobileDataStateTracker$getNetworkDataEntry(int ), 0, (int)n);
    }

    private static int getNormalizedSignalStrength(int n, SignalStrength signalStrength) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getNormalizedSignalStrength", $$robo$$android_net_MobileDataStateTracker$getNormalizedSignalStrength(int android.telephony.SignalStrength ), 0, (int)n, (SignalStrength)signalStrength);
    }

    @Override
    public void startSampling(SamplingDataTracker.SamplingSnapshot samplingSnapshot) {
        InvokeDynamicSupport.bootstrap("startSampling", $$robo$$android_net_MobileDataStateTracker$startSampling(android.net.SamplingDataTracker$SamplingSnapshot ), 0, this, samplingSnapshot);
    }

    @Override
    public void stopSampling(SamplingDataTracker.SamplingSnapshot samplingSnapshot) {
        InvokeDynamicSupport.bootstrap("stopSampling", $$robo$$android_net_MobileDataStateTracker$stopSampling(android.net.SamplingDataTracker$SamplingSnapshot ), 0, this, samplingSnapshot);
    }

    static {
        RobolectricInternals.classInitializing(MobileDataStateTracker.class);
    }

    public /* synthetic */ MobileDataStateTracker() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MobileDataStateTracker)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class 2
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        static /* synthetic */ int[] $SwitchMap$com$android$internal$telephony$PhoneConstants$DataState;

        static void __staticInitializer__() {
            $SwitchMap$com$android$internal$telephony$PhoneConstants$DataState = new int[PhoneConstants.DataState.values().length];
            try {
                2.$SwitchMap$com$android$internal$telephony$PhoneConstants$DataState[PhoneConstants.DataState.DISCONNECTED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                2.$SwitchMap$com$android$internal$telephony$PhoneConstants$DataState[PhoneConstants.DataState.CONNECTING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                2.$SwitchMap$com$android$internal$telephony$PhoneConstants$DataState[PhoneConstants.DataState.SUSPENDED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                2.$SwitchMap$com$android$internal$telephony$PhoneConstants$DataState[PhoneConstants.DataState.CONNECTED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }

        static {
            RobolectricInternals.classInitializing(2.class);
        }

        public /* synthetic */ 2() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (2)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class NetworkDataEntry
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int networkType;
        public int downloadBandwidth;
        public int uploadBandwidth;
        public int latency;

        private void $$robo$$android_net_MobileDataStateTracker_NetworkDataEntry$__constructor__(int i1, int i2, int i3, int i4) {
            this.networkType = i1;
            this.downloadBandwidth = i2;
            this.uploadBandwidth = i3;
            this.latency = i4;
        }

        private void __constructor__(int n, int n2, int n3, int n4) {
            this.$$robo$$android_net_MobileDataStateTracker_NetworkDataEntry$__constructor__(n, n2, n3, n4);
        }

        NetworkDataEntry(int n, int n2, int n3, int n4) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_MobileDataStateTracker_NetworkDataEntry$__constructor__(int int int int ), 0, this, n, n2, n3, n4);
        }

        public /* synthetic */ NetworkDataEntry() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NetworkDataEntry)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class MobileDataStateReceiver
    extends BroadcastReceiver
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ MobileDataStateTracker this$0;

        private void $$robo$$android_net_MobileDataStateTracker_MobileDataStateReceiver$__constructor__(MobileDataStateTracker mobileDataStateTracker) {
        }

        private final void $$robo$$android_net_MobileDataStateTracker_MobileDataStateReceiver$onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.intent.action.DATA_CONNECTION_CONNECTED_TO_PROVISIONING_APN")) {
                String apnName = intent.getStringExtra("apn");
                String apnType = intent.getStringExtra("apnType");
                if (!TextUtils.equals(this.this$0.mApnType, apnType)) {
                    return;
                }
                this.this$0.mMobileDataState = PhoneConstants.DataState.CONNECTING;
                this.this$0.updateLinkProperitesAndCapatilities(intent);
                this.this$0.mNetworkInfo.setIsConnectedToProvisioningNetwork(true);
                this.this$0.setDetailedState(NetworkInfo.DetailedState.SUSPENDED, "", apnName);
            } else if (intent.getAction().equals("android.intent.action.ANY_DATA_STATE")) {
                String apnType = intent.getStringExtra("apnType");
                if (!TextUtils.equals(apnType, this.this$0.mApnType)) {
                    return;
                }
                this.this$0.mNetworkInfo.setIsConnectedToProvisioningNetwork(false);
                int oldSubtype = this.this$0.mNetworkInfo.getSubtype();
                int newSubType = TelephonyManager.getDefault().getNetworkType();
                String subTypeName = TelephonyManager.getDefault().getNetworkTypeName();
                this.this$0.mNetworkInfo.setSubtype(newSubType, subTypeName);
                if (newSubType != oldSubtype && this.this$0.mNetworkInfo.isConnected()) {
                    Message msg = this.this$0.mTarget.obtainMessage(458755, oldSubtype, 0, this.this$0.mNetworkInfo);
                    msg.sendToTarget();
                }
                PhoneConstants.DataState state = Enum.valueOf(PhoneConstants.DataState.class, intent.getStringExtra("state"));
                String reason = intent.getStringExtra("reason");
                String apnName = intent.getStringExtra("apn");
                this.this$0.mNetworkInfo.setRoaming(intent.getBooleanExtra("networkRoaming", false));
                this.this$0.mNetworkInfo.setIsAvailable(!intent.getBooleanExtra("networkUnvailable", false));
                if (this.this$0.mMobileDataState != state) {
                    this.this$0.mMobileDataState = state;
                    switch (2.$SwitchMap$com$android$internal$telephony$PhoneConstants$DataState[state.ordinal()]) {
                        case 1: {
                            if (this.this$0.isTeardownRequested()) {
                                this.this$0.setTeardownRequested(false);
                            }
                            this.this$0.setDetailedState(NetworkInfo.DetailedState.DISCONNECTED, reason, apnName);
                            break;
                        }
                        case 2: {
                            this.this$0.setDetailedState(NetworkInfo.DetailedState.CONNECTING, reason, apnName);
                            break;
                        }
                        case 3: {
                            this.this$0.setDetailedState(NetworkInfo.DetailedState.SUSPENDED, reason, apnName);
                            break;
                        }
                        case 4: {
                            this.this$0.updateLinkProperitesAndCapatilities(intent);
                            this.this$0.setDetailedState(NetworkInfo.DetailedState.CONNECTED, reason, apnName);
                        }
                    }
                    this.this$0.mSamplingDataTracker.resetSamplingData();
                } else if (TextUtils.equals(reason, "linkPropertiesChanged")) {
                    this.this$0.mLinkProperties = (LinkProperties)intent.getParcelableExtra("linkProperties");
                    if (this.this$0.mLinkProperties == null) {
                        this.this$0.loge("No link property in LINK_PROPERTIES change event.");
                        this.this$0.mLinkProperties = new LinkProperties();
                    }
                    this.this$0.mNetworkInfo.setDetailedState(this.this$0.mNetworkInfo.getDetailedState(), reason, this.this$0.mNetworkInfo.getExtraInfo());
                    Message msg = this.this$0.mTarget.obtainMessage(458753, this.this$0.mNetworkInfo);
                    msg.sendToTarget();
                }
            } else if (intent.getAction().equals("android.intent.action.DATA_CONNECTION_FAILED")) {
                String apnType = intent.getStringExtra("apnType");
                if (!TextUtils.equals(apnType, this.this$0.mApnType)) {
                    return;
                }
                this.this$0.mNetworkInfo.setIsConnectedToProvisioningNetwork(false);
                String reason = intent.getStringExtra("reason");
                String apnName = intent.getStringExtra("apn");
                this.this$0.setDetailedState(NetworkInfo.DetailedState.FAILED, reason, apnName);
            }
        }

        private /* synthetic */ void $$robo$$android_net_MobileDataStateTracker_MobileDataStateReceiver$__constructor__(MobileDataStateTracker x0, 1 x1) {
        }

        private void __constructor__(MobileDataStateTracker mobileDataStateTracker) {
            this.$$robo$$android_net_MobileDataStateTracker_MobileDataStateReceiver$__constructor__(mobileDataStateTracker);
        }

        private MobileDataStateReceiver(MobileDataStateTracker mobileDataStateTracker) {
            this.this$0 = mobileDataStateTracker;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_MobileDataStateTracker_MobileDataStateReceiver$__constructor__(android.net.MobileDataStateTracker ), 0, this, mobileDataStateTracker);
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            InvokeDynamicSupport.bootstrap("onReceive", $$robo$$android_net_MobileDataStateTracker_MobileDataStateReceiver$onReceive(android.content.Context android.content.Intent ), 0, this, context, intent);
        }

        private /* synthetic */ void __constructor__(MobileDataStateTracker mobileDataStateTracker, 1 var2_2) {
            this.$$robo$$android_net_MobileDataStateTracker_MobileDataStateReceiver$__constructor__(mobileDataStateTracker, var2_2);
        }

        public /* synthetic */ MobileDataStateReceiver() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MobileDataStateReceiver)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class MdstHandler
    extends Handler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private MobileDataStateTracker mMdst;

        private void $$robo$$android_net_MobileDataStateTracker_MdstHandler$__constructor__(Looper looper, MobileDataStateTracker mdst) {
            this.mMdst = mdst;
        }

        private final void $$robo$$android_net_MobileDataStateTracker_MdstHandler$handleMessage(Message msg) {
            switch (msg.what) {
                case 69632: {
                    if (msg.arg1 != 0) break;
                    this.mMdst.mDataConnectionTrackerAc = (AsyncChannel)msg.obj;
                    break;
                }
                case 69636: {
                    this.mMdst.mDataConnectionTrackerAc = null;
                    break;
                }
            }
        }

        private void __constructor__(Looper looper, MobileDataStateTracker mobileDataStateTracker) {
            this.$$robo$$android_net_MobileDataStateTracker_MdstHandler$__constructor__(looper, mobileDataStateTracker);
        }

        MdstHandler(Looper looper, MobileDataStateTracker mobileDataStateTracker) {
            super(looper);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_MobileDataStateTracker_MdstHandler$__constructor__(android.os.Looper android.net.MobileDataStateTracker ), 0, this, looper, mobileDataStateTracker);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_net_MobileDataStateTracker_MdstHandler$handleMessage(android.os.Message ), 0, this, message);
        }

        public /* synthetic */ MdstHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MdstHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

