/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.NetworkUtils;
import android.os.Parcel;
import android.os.Parcelable;
import android.system.ErrnoException;
import com.android.okhttp.ConnectionPool;
import com.android.okhttp.HostResolver;
import com.android.okhttp.HttpHandler;
import com.android.okhttp.HttpsHandler;
import com.android.okhttp.OkHttpClient;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import javax.net.SocketFactory;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class Network
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public int netId;
    private volatile NetworkBoundSocketFactory mNetworkBoundSocketFactory;
    private volatile ConnectionPool mConnectionPool;
    private volatile HostResolver mHostResolver;
    private Object mLock;
    private static boolean httpKeepAlive;
    private static int httpMaxConnections;
    private static long httpKeepAliveDurationMs;
    public static Parcelable.Creator<Network> CREATOR;

    private void $$robo$$android_net_Network$__constructor__(int netId) {
        this.mNetworkBoundSocketFactory = null;
        this.mConnectionPool = null;
        this.mHostResolver = null;
        this.mLock = new Object();
        this.netId = netId;
    }

    private void $$robo$$android_net_Network$__constructor__(Network that) {
        this.mNetworkBoundSocketFactory = null;
        this.mConnectionPool = null;
        this.mHostResolver = null;
        this.mLock = new Object();
        this.netId = that.netId;
    }

    private final InetAddress[] $$robo$$android_net_Network$getAllByName(String host) throws UnknownHostException {
        return InetAddress.getAllByNameOnNet(host, this.netId);
    }

    private final InetAddress $$robo$$android_net_Network$getByName(String host) throws UnknownHostException {
        return InetAddress.getByNameOnNet(host, this.netId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SocketFactory $$robo$$android_net_Network$getSocketFactory() {
        if (this.mNetworkBoundSocketFactory == null) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mNetworkBoundSocketFactory == null) {
                    this.mNetworkBoundSocketFactory = new NetworkBoundSocketFactory(this, this.netId);
                }
            }
        }
        return this.mNetworkBoundSocketFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_net_Network$maybeInitHttpClient() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mHostResolver == null) {
                this.mHostResolver = new HostResolver(this){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ Network this$0;

                    private void $$robo$$android_net_Network_1$__constructor__(Network network) {
                    }

                    private final InetAddress[] $$robo$$android_net_Network_1$getAllByName(String host) throws UnknownHostException {
                        return this.this$0.getAllByName(host);
                    }

                    private void __constructor__(Network network) {
                        this.$$robo$$android_net_Network_1$__constructor__(network);
                    }
                    {
                        this.this$0 = network;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_Network_1$__constructor__(android.net.Network ), 0, this, network);
                    }

                    @Override
                    public InetAddress[] getAllByName(String string2) throws UnknownHostException {
                        return InvokeDynamicSupport.bootstrap("getAllByName", $$robo$$android_net_Network_1$getAllByName(java.lang.String ), 0, this, string2);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                };
            }
            if (this.mConnectionPool == null) {
                this.mConnectionPool = new ConnectionPool(httpMaxConnections, httpKeepAliveDurationMs);
            }
        }
    }

    private final URLConnection $$robo$$android_net_Network$openConnection(URL url) throws IOException {
        OkHttpClient client;
        this.maybeInitHttpClient();
        String protocol = url.getProtocol();
        if (protocol.equals("http")) {
            client = HttpHandler.createHttpOkHttpClient(null);
        } else if (protocol.equals("https")) {
            client = HttpsHandler.createHttpsOkHttpClient(null);
        } else {
            throw new MalformedURLException("Invalid URL or unrecognized protocol " + protocol);
        }
        return client.setSocketFactory(this.getSocketFactory()).setHostResolver(this.mHostResolver).setConnectionPool(this.mConnectionPool).open(url);
    }

    private final void $$robo$$android_net_Network$bindSocket(Socket socket) throws IOException {
        if (socket.isConnected()) {
            throw new SocketException("Socket is connected");
        }
        socket.getReuseAddress();
        int err = NetworkUtils.bindSocketToNetwork((int)InvokeDynamicSupport.bootstrapIntrinsic("getInt$", "java.io.FileDescriptor", (FileDescriptor)((Object)InvokeDynamicSupport.bootstrapIntrinsic("getFileDescriptor$", "java.net.Socket", (Socket)socket))), this.netId);
        if (err != 0) {
            throw new ErrnoException("Binding socket to network " + this.netId, -err).rethrowAsSocketException();
        }
    }

    private final int $$robo$$android_net_Network$describeContents() {
        return 0;
    }

    private final void $$robo$$android_net_Network$writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.netId);
    }

    private final boolean $$robo$$android_net_Network$equals(Object obj) {
        if (!(obj instanceof Network)) {
            return false;
        }
        Network other = (Network)obj;
        return this.netId == other.netId;
    }

    private final int $$robo$$android_net_Network$hashCode() {
        return this.netId * 11;
    }

    private final String $$robo$$android_net_Network$toString() {
        return Integer.toString(this.netId);
    }

    static void __staticInitializer__() {
        httpKeepAlive = Boolean.parseBoolean(System.getProperty("http.keepAlive", "true"));
        httpMaxConnections = httpKeepAlive ? Integer.parseInt(System.getProperty("http.maxConnections", "5")) : 0;
        httpKeepAliveDurationMs = Long.parseLong(System.getProperty("http.keepAliveDuration", "300000"));
        CREATOR = new Parcelable.Creator<Network>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_net_Network_2$__constructor__() {
            }

            private final Network $$robo$$android_net_Network_2$createFromParcel(Parcel in) {
                int netId = in.readInt();
                return new Network(netId);
            }

            private final Network[] $$robo$$android_net_Network_2$newArray(int size) {
                return new Network[size];
            }

            private void __constructor__() {
                this.$$robo$$android_net_Network_2$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_Network_2$__constructor__(), 0, this);
            }

            @Override
            public Network createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_Network_2$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public Network[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_Network_2$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(int n) {
        this.$$robo$$android_net_Network$__constructor__(n);
    }

    public Network(int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_Network$__constructor__(int ), 0, this, n);
    }

    private void __constructor__(Network network) {
        this.$$robo$$android_net_Network$__constructor__(network);
    }

    public Network(Network network) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_Network$__constructor__(android.net.Network ), 0, this, network);
    }

    public InetAddress[] getAllByName(String string2) throws UnknownHostException {
        return InvokeDynamicSupport.bootstrap("getAllByName", $$robo$$android_net_Network$getAllByName(java.lang.String ), 0, this, string2);
    }

    public InetAddress getByName(String string2) throws UnknownHostException {
        return InvokeDynamicSupport.bootstrap("getByName", $$robo$$android_net_Network$getByName(java.lang.String ), 0, this, string2);
    }

    public SocketFactory getSocketFactory() {
        return InvokeDynamicSupport.bootstrap("getSocketFactory", $$robo$$android_net_Network$getSocketFactory(), 0, this);
    }

    private void maybeInitHttpClient() {
        InvokeDynamicSupport.bootstrap("maybeInitHttpClient", $$robo$$android_net_Network$maybeInitHttpClient(), 0, this);
    }

    public URLConnection openConnection(URL uRL) throws IOException {
        return InvokeDynamicSupport.bootstrap("openConnection", $$robo$$android_net_Network$openConnection(java.net.URL ), 0, this, uRL);
    }

    public void bindSocket(Socket socket) throws IOException {
        InvokeDynamicSupport.bootstrap("bindSocket", $$robo$$android_net_Network$bindSocket(java.net.Socket ), 0, this, socket);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_Network$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_Network$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_net_Network$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_net_Network$hashCode(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_Network$toString(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(Network.class);
    }

    public /* synthetic */ Network() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Network)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class NetworkBoundSocketFactory
    extends SocketFactory
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mNetId;
        /* synthetic */ Network this$0;

        private void $$robo$$android_net_Network_NetworkBoundSocketFactory$__constructor__(Network network, int netId) {
            this.mNetId = netId;
        }

        private final Socket $$robo$$android_net_Network_NetworkBoundSocketFactory$connectToHost(String host, int port, SocketAddress localAddress) throws IOException {
            InetAddress[] hostAddresses = this.this$0.getAllByName(host);
            for (int i = 0; i < hostAddresses.length; ++i) {
                try {
                    Socket socket = this.createSocket();
                    if (localAddress != null) {
                        socket.bind(localAddress);
                    }
                    socket.connect(new InetSocketAddress(hostAddresses[i], port));
                    return socket;
                }
                catch (IOException e) {
                    if (i != hostAddresses.length - 1) continue;
                    throw e;
                }
            }
            throw new UnknownHostException(host);
        }

        private final Socket $$robo$$android_net_Network_NetworkBoundSocketFactory$createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
            return this.connectToHost(host, port, new InetSocketAddress(localHost, localPort));
        }

        private final Socket $$robo$$android_net_Network_NetworkBoundSocketFactory$createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
            Socket socket = this.createSocket();
            socket.bind(new InetSocketAddress(localAddress, localPort));
            socket.connect(new InetSocketAddress(address, port));
            return socket;
        }

        private final Socket $$robo$$android_net_Network_NetworkBoundSocketFactory$createSocket(InetAddress host, int port) throws IOException {
            Socket socket = this.createSocket();
            socket.connect(new InetSocketAddress(host, port));
            return socket;
        }

        private final Socket $$robo$$android_net_Network_NetworkBoundSocketFactory$createSocket(String host, int port) throws IOException {
            return this.connectToHost(host, port, null);
        }

        private final Socket $$robo$$android_net_Network_NetworkBoundSocketFactory$createSocket() throws IOException {
            Socket socket = new Socket();
            this.this$0.bindSocket(socket);
            return socket;
        }

        private void __constructor__(Network network, int n) {
            this.$$robo$$android_net_Network_NetworkBoundSocketFactory$__constructor__(network, n);
        }

        public NetworkBoundSocketFactory(Network network, int n) {
            this.this$0 = network;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_Network_NetworkBoundSocketFactory$__constructor__(android.net.Network int ), 0, this, network, n);
        }

        private Socket connectToHost(String string2, int n, SocketAddress socketAddress) throws IOException {
            return InvokeDynamicSupport.bootstrap("connectToHost", $$robo$$android_net_Network_NetworkBoundSocketFactory$connectToHost(java.lang.String int java.net.SocketAddress ), 0, this, string2, n, socketAddress);
        }

        @Override
        public Socket createSocket(String string2, int n, InetAddress inetAddress, int n2) throws IOException {
            return InvokeDynamicSupport.bootstrap("createSocket", $$robo$$android_net_Network_NetworkBoundSocketFactory$createSocket(java.lang.String int java.net.InetAddress int ), 0, this, string2, n, inetAddress, n2);
        }

        @Override
        public Socket createSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
            return InvokeDynamicSupport.bootstrap("createSocket", $$robo$$android_net_Network_NetworkBoundSocketFactory$createSocket(java.net.InetAddress int java.net.InetAddress int ), 0, this, inetAddress, n, inetAddress2, n2);
        }

        @Override
        public Socket createSocket(InetAddress inetAddress, int n) throws IOException {
            return InvokeDynamicSupport.bootstrap("createSocket", $$robo$$android_net_Network_NetworkBoundSocketFactory$createSocket(java.net.InetAddress int ), 0, this, inetAddress, n);
        }

        @Override
        public Socket createSocket(String string2, int n) throws IOException {
            return InvokeDynamicSupport.bootstrap("createSocket", $$robo$$android_net_Network_NetworkBoundSocketFactory$createSocket(java.lang.String int ), 0, this, string2, n);
        }

        @Override
        public Socket createSocket() throws IOException {
            return InvokeDynamicSupport.bootstrap("createSocket", $$robo$$android_net_Network_NetworkBoundSocketFactory$createSocket(), 0, this);
        }

        public /* synthetic */ NetworkBoundSocketFactory() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NetworkBoundSocketFactory)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

