/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class NetworkCapabilities
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "NetworkCapabilities";
    private static boolean DBG = false;
    private long mNetworkCapabilities;
    public static int NET_CAPABILITY_MMS = 0;
    public static int NET_CAPABILITY_SUPL = 1;
    public static int NET_CAPABILITY_DUN = 2;
    public static int NET_CAPABILITY_FOTA = 3;
    public static int NET_CAPABILITY_IMS = 4;
    public static int NET_CAPABILITY_CBS = 5;
    public static int NET_CAPABILITY_WIFI_P2P = 6;
    public static int NET_CAPABILITY_IA = 7;
    public static int NET_CAPABILITY_RCS = 8;
    public static int NET_CAPABILITY_XCAP = 9;
    public static int NET_CAPABILITY_EIMS = 10;
    public static int NET_CAPABILITY_NOT_METERED = 11;
    public static int NET_CAPABILITY_INTERNET = 12;
    public static int NET_CAPABILITY_NOT_RESTRICTED = 13;
    public static int NET_CAPABILITY_TRUSTED = 14;
    public static int NET_CAPABILITY_NOT_VPN = 15;
    private static int MIN_NET_CAPABILITY = 0;
    private static int MAX_NET_CAPABILITY = 15;
    private long mTransportTypes;
    public static int TRANSPORT_CELLULAR = 0;
    public static int TRANSPORT_WIFI = 1;
    public static int TRANSPORT_BLUETOOTH = 2;
    public static int TRANSPORT_ETHERNET = 3;
    public static int TRANSPORT_VPN = 4;
    private static int MIN_TRANSPORT = 0;
    private static int MAX_TRANSPORT = 4;
    private int mLinkUpBandwidthKbps;
    private int mLinkDownBandwidthKbps;
    private String mNetworkSpecifier;
    public static Parcelable.Creator<NetworkCapabilities> CREATOR;

    private void $$robo$$android_net_NetworkCapabilities$__constructor__() {
        this.mNetworkCapabilities = 57344L;
    }

    private void $$robo$$android_net_NetworkCapabilities$__constructor__(NetworkCapabilities nc) {
        this.mNetworkCapabilities = 57344L;
        if (nc != null) {
            this.mNetworkCapabilities = nc.mNetworkCapabilities;
            this.mTransportTypes = nc.mTransportTypes;
            this.mLinkUpBandwidthKbps = nc.mLinkUpBandwidthKbps;
            this.mLinkDownBandwidthKbps = nc.mLinkDownBandwidthKbps;
            this.mNetworkSpecifier = nc.mNetworkSpecifier;
        }
    }

    private final NetworkCapabilities $$robo$$android_net_NetworkCapabilities$addCapability(int capability) {
        if (capability < 0 || capability > 15) {
            throw new IllegalArgumentException("NetworkCapability out of range");
        }
        this.mNetworkCapabilities |= (long)(1 << capability);
        return this;
    }

    private final NetworkCapabilities $$robo$$android_net_NetworkCapabilities$removeCapability(int capability) {
        if (capability < 0 || capability > 15) {
            throw new IllegalArgumentException("NetworkCapability out of range");
        }
        this.mNetworkCapabilities &= (long)(~(1 << capability));
        return this;
    }

    private final int[] $$robo$$android_net_NetworkCapabilities$getCapabilities() {
        return this.enumerateBits(this.mNetworkCapabilities);
    }

    private final boolean $$robo$$android_net_NetworkCapabilities$hasCapability(int capability) {
        if (capability < 0 || capability > 15) {
            return false;
        }
        return (this.mNetworkCapabilities & (long)(1 << capability)) != 0L;
    }

    private final int[] $$robo$$android_net_NetworkCapabilities$enumerateBits(long val) {
        int size = Long.bitCount(val);
        int[] result = new int[size];
        int index = 0;
        int resource = 0;
        while (val > 0L) {
            if ((val & 1L) == 1L) {
                result[index++] = resource;
            }
            val >>= 1;
            ++resource;
        }
        return result;
    }

    private final void $$robo$$android_net_NetworkCapabilities$combineNetCapabilities(NetworkCapabilities nc) {
        this.mNetworkCapabilities |= nc.mNetworkCapabilities;
    }

    private final boolean $$robo$$android_net_NetworkCapabilities$satisfiedByNetCapabilities(NetworkCapabilities nc) {
        return (nc.mNetworkCapabilities & this.mNetworkCapabilities) == this.mNetworkCapabilities;
    }

    private final boolean $$robo$$android_net_NetworkCapabilities$equalsNetCapabilities(NetworkCapabilities nc) {
        return nc.mNetworkCapabilities == this.mNetworkCapabilities;
    }

    private final NetworkCapabilities $$robo$$android_net_NetworkCapabilities$addTransportType(int transportType) {
        if (transportType < 0 || transportType > 4) {
            throw new IllegalArgumentException("TransportType out of range");
        }
        this.mTransportTypes |= (long)(1 << transportType);
        this.setNetworkSpecifier(this.mNetworkSpecifier);
        return this;
    }

    private final NetworkCapabilities $$robo$$android_net_NetworkCapabilities$removeTransportType(int transportType) {
        if (transportType < 0 || transportType > 4) {
            throw new IllegalArgumentException("TransportType out of range");
        }
        this.mTransportTypes &= (long)(~(1 << transportType));
        this.setNetworkSpecifier(this.mNetworkSpecifier);
        return this;
    }

    private final int[] $$robo$$android_net_NetworkCapabilities$getTransportTypes() {
        return this.enumerateBits(this.mTransportTypes);
    }

    private final boolean $$robo$$android_net_NetworkCapabilities$hasTransport(int transportType) {
        if (transportType < 0 || transportType > 4) {
            return false;
        }
        return (this.mTransportTypes & (long)(1 << transportType)) != 0L;
    }

    private final void $$robo$$android_net_NetworkCapabilities$combineTransportTypes(NetworkCapabilities nc) {
        this.mTransportTypes |= nc.mTransportTypes;
    }

    private final boolean $$robo$$android_net_NetworkCapabilities$satisfiedByTransportTypes(NetworkCapabilities nc) {
        return this.mTransportTypes == 0L || (this.mTransportTypes & nc.mTransportTypes) != 0L;
    }

    private final boolean $$robo$$android_net_NetworkCapabilities$equalsTransportTypes(NetworkCapabilities nc) {
        return nc.mTransportTypes == this.mTransportTypes;
    }

    private final void $$robo$$android_net_NetworkCapabilities$setLinkUpstreamBandwidthKbps(int upKbps) {
        this.mLinkUpBandwidthKbps = upKbps;
    }

    private final int $$robo$$android_net_NetworkCapabilities$getLinkUpstreamBandwidthKbps() {
        return this.mLinkUpBandwidthKbps;
    }

    private final void $$robo$$android_net_NetworkCapabilities$setLinkDownstreamBandwidthKbps(int downKbps) {
        this.mLinkDownBandwidthKbps = downKbps;
    }

    private final int $$robo$$android_net_NetworkCapabilities$getLinkDownstreamBandwidthKbps() {
        return this.mLinkDownBandwidthKbps;
    }

    private final void $$robo$$android_net_NetworkCapabilities$combineLinkBandwidths(NetworkCapabilities nc) {
        this.mLinkUpBandwidthKbps = Math.max(this.mLinkUpBandwidthKbps, nc.mLinkUpBandwidthKbps);
        this.mLinkDownBandwidthKbps = Math.max(this.mLinkDownBandwidthKbps, nc.mLinkDownBandwidthKbps);
    }

    private final boolean $$robo$$android_net_NetworkCapabilities$satisfiedByLinkBandwidths(NetworkCapabilities nc) {
        return this.mLinkUpBandwidthKbps <= nc.mLinkUpBandwidthKbps && this.mLinkDownBandwidthKbps <= nc.mLinkDownBandwidthKbps;
    }

    private final boolean $$robo$$android_net_NetworkCapabilities$equalsLinkBandwidths(NetworkCapabilities nc) {
        return this.mLinkUpBandwidthKbps == nc.mLinkUpBandwidthKbps && this.mLinkDownBandwidthKbps == nc.mLinkDownBandwidthKbps;
    }

    private final void $$robo$$android_net_NetworkCapabilities$setNetworkSpecifier(String networkSpecifier) {
        if (!TextUtils.isEmpty(networkSpecifier) && Long.bitCount(this.mTransportTypes) != 1) {
            throw new IllegalStateException("Must have a single transport specified to use setNetworkSpecifier");
        }
        this.mNetworkSpecifier = networkSpecifier;
    }

    private final String $$robo$$android_net_NetworkCapabilities$getNetworkSpecifier() {
        return this.mNetworkSpecifier;
    }

    private final void $$robo$$android_net_NetworkCapabilities$combineSpecifiers(NetworkCapabilities nc) {
        String otherSpecifier = nc.getNetworkSpecifier();
        if (TextUtils.isEmpty(otherSpecifier)) {
            return;
        }
        if (!TextUtils.isEmpty(this.mNetworkSpecifier)) {
            throw new IllegalStateException("Can't combine two networkSpecifiers");
        }
        this.setNetworkSpecifier(otherSpecifier);
    }

    private final boolean $$robo$$android_net_NetworkCapabilities$satisfiedBySpecifier(NetworkCapabilities nc) {
        return TextUtils.isEmpty(this.mNetworkSpecifier) || this.mNetworkSpecifier.equals(nc.mNetworkSpecifier);
    }

    private final boolean $$robo$$android_net_NetworkCapabilities$equalsSpecifier(NetworkCapabilities nc) {
        if (TextUtils.isEmpty(this.mNetworkSpecifier)) {
            return TextUtils.isEmpty(nc.mNetworkSpecifier);
        }
        return this.mNetworkSpecifier.equals(nc.mNetworkSpecifier);
    }

    private final void $$robo$$android_net_NetworkCapabilities$combineCapabilities(NetworkCapabilities nc) {
        this.combineNetCapabilities(nc);
        this.combineTransportTypes(nc);
        this.combineLinkBandwidths(nc);
        this.combineSpecifiers(nc);
    }

    private final boolean $$robo$$android_net_NetworkCapabilities$satisfiedByNetworkCapabilities(NetworkCapabilities nc) {
        return nc != null && this.satisfiedByNetCapabilities(nc) && this.satisfiedByTransportTypes(nc) && this.satisfiedByLinkBandwidths(nc) && this.satisfiedBySpecifier(nc);
    }

    private final boolean $$robo$$android_net_NetworkCapabilities$equals(Object obj) {
        if (obj == null || !(obj instanceof NetworkCapabilities)) {
            return false;
        }
        NetworkCapabilities that = (NetworkCapabilities)obj;
        return this.equalsNetCapabilities(that) && this.equalsTransportTypes(that) && this.equalsLinkBandwidths(that) && this.equalsSpecifier(that);
    }

    private final int $$robo$$android_net_NetworkCapabilities$hashCode() {
        return (int)(this.mNetworkCapabilities & 0xFFFFFFFFFFFFFFFFL) + (int)(this.mNetworkCapabilities >> 32) * 3 + (int)(this.mTransportTypes & 0xFFFFFFFFFFFFFFFFL) * 5 + (int)(this.mTransportTypes >> 32) * 7 + this.mLinkUpBandwidthKbps * 11 + this.mLinkDownBandwidthKbps * 13 + (TextUtils.isEmpty(this.mNetworkSpecifier) ? 0 : this.mNetworkSpecifier.hashCode() * 17);
    }

    private final int $$robo$$android_net_NetworkCapabilities$describeContents() {
        return 0;
    }

    private final void $$robo$$android_net_NetworkCapabilities$writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.mNetworkCapabilities);
        dest.writeLong(this.mTransportTypes);
        dest.writeInt(this.mLinkUpBandwidthKbps);
        dest.writeInt(this.mLinkDownBandwidthKbps);
        dest.writeString(this.mNetworkSpecifier);
    }

    private final String $$robo$$android_net_NetworkCapabilities$toString() {
        int[] types = this.getTransportTypes();
        String transports = types.length > 0 ? " Transports: " : "";
        int i = 0;
        while (i < types.length) {
            switch (types[i]) {
                case 0: {
                    transports = transports + "CELLULAR";
                    break;
                }
                case 1: {
                    transports = transports + "WIFI";
                    break;
                }
                case 2: {
                    transports = transports + "BLUETOOTH";
                    break;
                }
                case 3: {
                    transports = transports + "ETHERNET";
                    break;
                }
                case 4: {
                    transports = transports + "VPN";
                }
            }
            if (++i >= types.length) continue;
            transports = transports + "|";
        }
        types = this.getCapabilities();
        String capabilities = types.length > 0 ? " Capabilities: " : "";
        int i2 = 0;
        while (i2 < types.length) {
            switch (types[i2]) {
                case 0: {
                    capabilities = capabilities + "MMS";
                    break;
                }
                case 1: {
                    capabilities = capabilities + "SUPL";
                    break;
                }
                case 2: {
                    capabilities = capabilities + "DUN";
                    break;
                }
                case 3: {
                    capabilities = capabilities + "FOTA";
                    break;
                }
                case 4: {
                    capabilities = capabilities + "IMS";
                    break;
                }
                case 5: {
                    capabilities = capabilities + "CBS";
                    break;
                }
                case 6: {
                    capabilities = capabilities + "WIFI_P2P";
                    break;
                }
                case 7: {
                    capabilities = capabilities + "IA";
                    break;
                }
                case 8: {
                    capabilities = capabilities + "RCS";
                    break;
                }
                case 9: {
                    capabilities = capabilities + "XCAP";
                    break;
                }
                case 10: {
                    capabilities = capabilities + "EIMS";
                    break;
                }
                case 11: {
                    capabilities = capabilities + "NOT_METERED";
                    break;
                }
                case 12: {
                    capabilities = capabilities + "INTERNET";
                    break;
                }
                case 13: {
                    capabilities = capabilities + "NOT_RESTRICTED";
                    break;
                }
                case 14: {
                    capabilities = capabilities + "TRUSTED";
                    break;
                }
                case 15: {
                    capabilities = capabilities + "NOT_VPN";
                }
            }
            if (++i2 >= types.length) continue;
            capabilities = capabilities + "&";
        }
        String upBand = this.mLinkUpBandwidthKbps > 0 ? " LinkUpBandwidth>=" + this.mLinkUpBandwidthKbps + "Kbps" : "";
        String dnBand = this.mLinkDownBandwidthKbps > 0 ? " LinkDnBandwidth>=" + this.mLinkDownBandwidthKbps + "Kbps" : "";
        String specifier = this.mNetworkSpecifier == null ? "" : " Specifier: <" + this.mNetworkSpecifier + ">";
        return "[" + transports + capabilities + upBand + dnBand + specifier + "]";
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<NetworkCapabilities>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_net_NetworkCapabilities_1$__constructor__() {
            }

            private final NetworkCapabilities $$robo$$android_net_NetworkCapabilities_1$createFromParcel(Parcel in) {
                NetworkCapabilities netCap = new NetworkCapabilities();
                netCap.mNetworkCapabilities = in.readLong();
                netCap.mTransportTypes = in.readLong();
                netCap.mLinkUpBandwidthKbps = in.readInt();
                netCap.mLinkDownBandwidthKbps = in.readInt();
                netCap.mNetworkSpecifier = in.readString();
                return netCap;
            }

            private final NetworkCapabilities[] $$robo$$android_net_NetworkCapabilities_1$newArray(int size) {
                return new NetworkCapabilities[size];
            }

            private void __constructor__() {
                this.$$robo$$android_net_NetworkCapabilities_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_NetworkCapabilities_1$__constructor__(), 0, this);
            }

            @Override
            public NetworkCapabilities createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_NetworkCapabilities_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public NetworkCapabilities[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_NetworkCapabilities_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__() {
        this.$$robo$$android_net_NetworkCapabilities$__constructor__();
    }

    public NetworkCapabilities() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_NetworkCapabilities$__constructor__(), 0, this);
    }

    private void __constructor__(NetworkCapabilities networkCapabilities) {
        this.$$robo$$android_net_NetworkCapabilities$__constructor__(networkCapabilities);
    }

    public NetworkCapabilities(NetworkCapabilities networkCapabilities) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_NetworkCapabilities$__constructor__(android.net.NetworkCapabilities ), 0, this, networkCapabilities);
    }

    public NetworkCapabilities addCapability(int n) {
        return InvokeDynamicSupport.bootstrap("addCapability", $$robo$$android_net_NetworkCapabilities$addCapability(int ), 0, this, n);
    }

    public NetworkCapabilities removeCapability(int n) {
        return InvokeDynamicSupport.bootstrap("removeCapability", $$robo$$android_net_NetworkCapabilities$removeCapability(int ), 0, this, n);
    }

    public int[] getCapabilities() {
        return InvokeDynamicSupport.bootstrap("getCapabilities", $$robo$$android_net_NetworkCapabilities$getCapabilities(), 0, this);
    }

    public boolean hasCapability(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasCapability", $$robo$$android_net_NetworkCapabilities$hasCapability(int ), 0, this, n);
    }

    private int[] enumerateBits(long l) {
        return InvokeDynamicSupport.bootstrap("enumerateBits", $$robo$$android_net_NetworkCapabilities$enumerateBits(long ), 0, this, l);
    }

    private void combineNetCapabilities(NetworkCapabilities networkCapabilities) {
        InvokeDynamicSupport.bootstrap("combineNetCapabilities", $$robo$$android_net_NetworkCapabilities$combineNetCapabilities(android.net.NetworkCapabilities ), 0, this, networkCapabilities);
    }

    private boolean satisfiedByNetCapabilities(NetworkCapabilities networkCapabilities) {
        return (boolean)InvokeDynamicSupport.bootstrap("satisfiedByNetCapabilities", $$robo$$android_net_NetworkCapabilities$satisfiedByNetCapabilities(android.net.NetworkCapabilities ), 0, this, networkCapabilities);
    }

    private boolean equalsNetCapabilities(NetworkCapabilities networkCapabilities) {
        return (boolean)InvokeDynamicSupport.bootstrap("equalsNetCapabilities", $$robo$$android_net_NetworkCapabilities$equalsNetCapabilities(android.net.NetworkCapabilities ), 0, this, networkCapabilities);
    }

    public NetworkCapabilities addTransportType(int n) {
        return InvokeDynamicSupport.bootstrap("addTransportType", $$robo$$android_net_NetworkCapabilities$addTransportType(int ), 0, this, n);
    }

    public NetworkCapabilities removeTransportType(int n) {
        return InvokeDynamicSupport.bootstrap("removeTransportType", $$robo$$android_net_NetworkCapabilities$removeTransportType(int ), 0, this, n);
    }

    public int[] getTransportTypes() {
        return InvokeDynamicSupport.bootstrap("getTransportTypes", $$robo$$android_net_NetworkCapabilities$getTransportTypes(), 0, this);
    }

    public boolean hasTransport(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasTransport", $$robo$$android_net_NetworkCapabilities$hasTransport(int ), 0, this, n);
    }

    private void combineTransportTypes(NetworkCapabilities networkCapabilities) {
        InvokeDynamicSupport.bootstrap("combineTransportTypes", $$robo$$android_net_NetworkCapabilities$combineTransportTypes(android.net.NetworkCapabilities ), 0, this, networkCapabilities);
    }

    private boolean satisfiedByTransportTypes(NetworkCapabilities networkCapabilities) {
        return (boolean)InvokeDynamicSupport.bootstrap("satisfiedByTransportTypes", $$robo$$android_net_NetworkCapabilities$satisfiedByTransportTypes(android.net.NetworkCapabilities ), 0, this, networkCapabilities);
    }

    private boolean equalsTransportTypes(NetworkCapabilities networkCapabilities) {
        return (boolean)InvokeDynamicSupport.bootstrap("equalsTransportTypes", $$robo$$android_net_NetworkCapabilities$equalsTransportTypes(android.net.NetworkCapabilities ), 0, this, networkCapabilities);
    }

    public void setLinkUpstreamBandwidthKbps(int n) {
        InvokeDynamicSupport.bootstrap("setLinkUpstreamBandwidthKbps", $$robo$$android_net_NetworkCapabilities$setLinkUpstreamBandwidthKbps(int ), 0, this, n);
    }

    public int getLinkUpstreamBandwidthKbps() {
        return (int)InvokeDynamicSupport.bootstrap("getLinkUpstreamBandwidthKbps", $$robo$$android_net_NetworkCapabilities$getLinkUpstreamBandwidthKbps(), 0, this);
    }

    public void setLinkDownstreamBandwidthKbps(int n) {
        InvokeDynamicSupport.bootstrap("setLinkDownstreamBandwidthKbps", $$robo$$android_net_NetworkCapabilities$setLinkDownstreamBandwidthKbps(int ), 0, this, n);
    }

    public int getLinkDownstreamBandwidthKbps() {
        return (int)InvokeDynamicSupport.bootstrap("getLinkDownstreamBandwidthKbps", $$robo$$android_net_NetworkCapabilities$getLinkDownstreamBandwidthKbps(), 0, this);
    }

    private void combineLinkBandwidths(NetworkCapabilities networkCapabilities) {
        InvokeDynamicSupport.bootstrap("combineLinkBandwidths", $$robo$$android_net_NetworkCapabilities$combineLinkBandwidths(android.net.NetworkCapabilities ), 0, this, networkCapabilities);
    }

    private boolean satisfiedByLinkBandwidths(NetworkCapabilities networkCapabilities) {
        return (boolean)InvokeDynamicSupport.bootstrap("satisfiedByLinkBandwidths", $$robo$$android_net_NetworkCapabilities$satisfiedByLinkBandwidths(android.net.NetworkCapabilities ), 0, this, networkCapabilities);
    }

    private boolean equalsLinkBandwidths(NetworkCapabilities networkCapabilities) {
        return (boolean)InvokeDynamicSupport.bootstrap("equalsLinkBandwidths", $$robo$$android_net_NetworkCapabilities$equalsLinkBandwidths(android.net.NetworkCapabilities ), 0, this, networkCapabilities);
    }

    public void setNetworkSpecifier(String string2) {
        InvokeDynamicSupport.bootstrap("setNetworkSpecifier", $$robo$$android_net_NetworkCapabilities$setNetworkSpecifier(java.lang.String ), 0, this, string2);
    }

    public String getNetworkSpecifier() {
        return InvokeDynamicSupport.bootstrap("getNetworkSpecifier", $$robo$$android_net_NetworkCapabilities$getNetworkSpecifier(), 0, this);
    }

    private void combineSpecifiers(NetworkCapabilities networkCapabilities) {
        InvokeDynamicSupport.bootstrap("combineSpecifiers", $$robo$$android_net_NetworkCapabilities$combineSpecifiers(android.net.NetworkCapabilities ), 0, this, networkCapabilities);
    }

    private boolean satisfiedBySpecifier(NetworkCapabilities networkCapabilities) {
        return (boolean)InvokeDynamicSupport.bootstrap("satisfiedBySpecifier", $$robo$$android_net_NetworkCapabilities$satisfiedBySpecifier(android.net.NetworkCapabilities ), 0, this, networkCapabilities);
    }

    private boolean equalsSpecifier(NetworkCapabilities networkCapabilities) {
        return (boolean)InvokeDynamicSupport.bootstrap("equalsSpecifier", $$robo$$android_net_NetworkCapabilities$equalsSpecifier(android.net.NetworkCapabilities ), 0, this, networkCapabilities);
    }

    public void combineCapabilities(NetworkCapabilities networkCapabilities) {
        InvokeDynamicSupport.bootstrap("combineCapabilities", $$robo$$android_net_NetworkCapabilities$combineCapabilities(android.net.NetworkCapabilities ), 0, this, networkCapabilities);
    }

    public boolean satisfiedByNetworkCapabilities(NetworkCapabilities networkCapabilities) {
        return (boolean)InvokeDynamicSupport.bootstrap("satisfiedByNetworkCapabilities", $$robo$$android_net_NetworkCapabilities$satisfiedByNetworkCapabilities(android.net.NetworkCapabilities ), 0, this, networkCapabilities);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_net_NetworkCapabilities$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_net_NetworkCapabilities$hashCode(), 0, this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_NetworkCapabilities$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_NetworkCapabilities$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_NetworkCapabilities$toString(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(NetworkCapabilities.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NetworkCapabilities)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

