/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkState;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.telephony.TelephonyManager;
import java.util.Objects;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class NetworkIdentity
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static boolean COMBINE_SUBTYPE_ENABLED = true;
    public static int SUBTYPE_COMBINED = -1;
    int mType;
    int mSubType;
    String mSubscriberId;
    String mNetworkId;
    boolean mRoaming;

    private void $$robo$$android_net_NetworkIdentity$__constructor__(int type, int subType, String subscriberId, String networkId, boolean roaming) {
        this.mType = type;
        this.mSubType = -1;
        this.mSubscriberId = subscriberId;
        this.mNetworkId = networkId;
        this.mRoaming = roaming;
    }

    private final int $$robo$$android_net_NetworkIdentity$hashCode() {
        return Objects.hash(this.mType, this.mSubType, this.mSubscriberId, this.mNetworkId, this.mRoaming);
    }

    private final boolean $$robo$$android_net_NetworkIdentity$equals(Object obj) {
        if (obj instanceof NetworkIdentity) {
            NetworkIdentity ident = (NetworkIdentity)obj;
            return this.mType == ident.mType && this.mSubType == ident.mSubType && this.mRoaming == ident.mRoaming && Objects.equals(this.mSubscriberId, ident.mSubscriberId) && Objects.equals(this.mNetworkId, ident.mNetworkId);
        }
        return false;
    }

    private final String $$robo$$android_net_NetworkIdentity$toString() {
        StringBuilder builder = new StringBuilder("[");
        builder.append("type=").append(ConnectivityManager.getNetworkTypeName(this.mType));
        builder.append(", subType=");
        builder.append("COMBINED");
        if (this.mSubscriberId != null) {
            builder.append(", subscriberId=").append(NetworkIdentity.scrubSubscriberId(this.mSubscriberId));
        }
        if (this.mNetworkId != null) {
            builder.append(", networkId=").append(this.mNetworkId);
        }
        if (this.mRoaming) {
            builder.append(", ROAMING");
        }
        return builder.append("]").toString();
    }

    private final int $$robo$$android_net_NetworkIdentity$getType() {
        return this.mType;
    }

    private final int $$robo$$android_net_NetworkIdentity$getSubType() {
        return this.mSubType;
    }

    private final String $$robo$$android_net_NetworkIdentity$getSubscriberId() {
        return this.mSubscriberId;
    }

    private final String $$robo$$android_net_NetworkIdentity$getNetworkId() {
        return this.mNetworkId;
    }

    private final boolean $$robo$$android_net_NetworkIdentity$getRoaming() {
        return this.mRoaming;
    }

    private static final String $$robo$$android_net_NetworkIdentity$scrubSubscriberId(String subscriberId) {
        if ("eng".equals(Build.TYPE)) {
            return subscriberId;
        }
        if (subscriberId != null) {
            return subscriberId.substring(0, Math.min(6, subscriberId.length())) + "...";
        }
        return "null";
    }

    private static final NetworkIdentity $$robo$$android_net_NetworkIdentity$buildNetworkIdentity(Context context, NetworkState state) {
        int type = state.networkInfo.getType();
        int subType = state.networkInfo.getSubtype();
        String subscriberId = null;
        String networkId = null;
        boolean roaming = false;
        if (ConnectivityManager.isNetworkTypeMobile(type)) {
            TelephonyManager telephony = (TelephonyManager)context.getSystemService("phone");
            roaming = telephony.isNetworkRoaming();
            subscriberId = state.subscriberId != null ? state.subscriberId : telephony.getSubscriberId();
        } else if (type == 1) {
            WifiManager wifi;
            WifiInfo info;
            networkId = state.networkId != null ? state.networkId : ((info = (wifi = (WifiManager)context.getSystemService("wifi")).getConnectionInfo()) != null ? info.getSSID() : null);
        }
        return new NetworkIdentity(type, subType, subscriberId, networkId, roaming);
    }

    private void __constructor__(int n, int n2, String string2, String string3, boolean bl) {
        this.$$robo$$android_net_NetworkIdentity$__constructor__(n, n2, string2, string3, bl);
    }

    public NetworkIdentity(int n, int n2, String string2, String string3, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_NetworkIdentity$__constructor__(int int java.lang.String java.lang.String boolean ), 0, this, n, n2, string2, string3, bl);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_net_NetworkIdentity$hashCode(), 0, this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_net_NetworkIdentity$equals(java.lang.Object ), 0, this, object);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_NetworkIdentity$toString(), 0, this);
    }

    public int getType() {
        return (int)InvokeDynamicSupport.bootstrap("getType", $$robo$$android_net_NetworkIdentity$getType(), 0, this);
    }

    public int getSubType() {
        return (int)InvokeDynamicSupport.bootstrap("getSubType", $$robo$$android_net_NetworkIdentity$getSubType(), 0, this);
    }

    public String getSubscriberId() {
        return InvokeDynamicSupport.bootstrap("getSubscriberId", $$robo$$android_net_NetworkIdentity$getSubscriberId(), 0, this);
    }

    public String getNetworkId() {
        return InvokeDynamicSupport.bootstrap("getNetworkId", $$robo$$android_net_NetworkIdentity$getNetworkId(), 0, this);
    }

    public boolean getRoaming() {
        return (boolean)InvokeDynamicSupport.bootstrap("getRoaming", $$robo$$android_net_NetworkIdentity$getRoaming(), 0, this);
    }

    public static String scrubSubscriberId(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("scrubSubscriberId", $$robo$$android_net_NetworkIdentity$scrubSubscriberId(java.lang.String ), 0, (String)string2);
    }

    public static NetworkIdentity buildNetworkIdentity(Context context, NetworkState networkState) {
        return InvokeDynamicSupport.bootstrapStatic("buildNetworkIdentity", $$robo$$android_net_NetworkIdentity$buildNetworkIdentity(android.content.Context android.net.NetworkState ), 0, (Context)context, (NetworkState)networkState);
    }

    public /* synthetic */ NetworkIdentity() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NetworkIdentity)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

