/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.app.AppOpsManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class NetworkScorerAppManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "NetworkScorerAppManager";
    private static Intent SCORE_INTENT;

    private void $$robo$$android_net_NetworkScorerAppManager$__constructor__() {
    }

    private static final Collection<NetworkScorerAppData> $$robo$$android_net_NetworkScorerAppManager$getAllValidScorers(Context context) {
        ArrayList<NetworkScorerAppData> scorers = new ArrayList<NetworkScorerAppData>();
        PackageManager pm = context.getPackageManager();
        List<ResolveInfo> receivers = pm.queryBroadcastReceivers(SCORE_INTENT, 0, 0);
        for (ResolveInfo receiver : receivers) {
            ActivityInfo activityInfo;
            ActivityInfo receiverInfo = receiver.activityInfo;
            if (receiverInfo == null || !"android.permission.BROADCAST_SCORE_NETWORKS".equals(receiverInfo.permission) || pm.checkPermission("android.permission.SCORE_NETWORKS", receiverInfo.packageName) != 0) continue;
            String configurationActivityClassName = null;
            Intent intent = new Intent("android.net.scoring.CUSTOM_ENABLE");
            intent.setPackage(receiverInfo.packageName);
            List<ResolveInfo> configActivities = pm.queryIntentActivities(intent, 0);
            if (!configActivities.isEmpty() && (activityInfo = configActivities.get((int)0).activityInfo) != null) {
                configurationActivityClassName = activityInfo.name;
            }
            scorers.add(new NetworkScorerAppData(receiverInfo.packageName, receiverInfo.loadLabel(pm), configurationActivityClassName));
        }
        return scorers;
    }

    private static final NetworkScorerAppData $$robo$$android_net_NetworkScorerAppManager$getActiveScorer(Context context) {
        String scorerPackage = Settings.Global.getString(context.getContentResolver(), "network_scorer_app");
        return NetworkScorerAppManager.getScorer(context, scorerPackage);
    }

    private static final boolean $$robo$$android_net_NetworkScorerAppManager$setActiveScorer(Context context, String packageName) {
        String oldPackageName = Settings.Global.getString(context.getContentResolver(), "network_scorer_app");
        if (TextUtils.equals(oldPackageName, packageName)) {
            return true;
        }
        Log.i("NetworkScorerAppManager", "Changing network scorer from " + oldPackageName + " to " + packageName);
        if (packageName == null) {
            Settings.Global.putString(context.getContentResolver(), "network_scorer_app", null);
            return true;
        }
        if (NetworkScorerAppManager.getScorer(context, packageName) != null) {
            Settings.Global.putString(context.getContentResolver(), "network_scorer_app", packageName);
            return true;
        }
        Log.w("NetworkScorerAppManager", "Requested network scorer is not valid: " + packageName);
        return false;
    }

    private static final boolean $$robo$$android_net_NetworkScorerAppManager$isCallerActiveScorer(Context context, int callingUid) {
        NetworkScorerAppData defaultApp = NetworkScorerAppManager.getActiveScorer(context);
        if (defaultApp == null) {
            return false;
        }
        AppOpsManager appOpsMgr = (AppOpsManager)context.getSystemService("appops");
        try {
            appOpsMgr.checkPackage(callingUid, defaultApp.mPackageName);
        }
        catch (SecurityException e) {
            return false;
        }
        return context.checkCallingPermission("android.permission.SCORE_NETWORKS") == 0;
    }

    private static final NetworkScorerAppData $$robo$$android_net_NetworkScorerAppManager$getScorer(Context context, String packageName) {
        if (TextUtils.isEmpty(packageName)) {
            return null;
        }
        Collection<NetworkScorerAppData> applications = NetworkScorerAppManager.getAllValidScorers(context);
        for (NetworkScorerAppData app : applications) {
            if (!packageName.equals(app.mPackageName)) continue;
            return app;
        }
        return null;
    }

    static void __staticInitializer__() {
        SCORE_INTENT = new Intent("android.net.scoring.SCORE_NETWORKS");
    }

    private void __constructor__() {
        this.$$robo$$android_net_NetworkScorerAppManager$__constructor__();
    }

    private NetworkScorerAppManager() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_NetworkScorerAppManager$__constructor__(), 0, this);
    }

    public static Collection<NetworkScorerAppData> getAllValidScorers(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getAllValidScorers", $$robo$$android_net_NetworkScorerAppManager$getAllValidScorers(android.content.Context ), 0, (Context)context);
    }

    public static NetworkScorerAppData getActiveScorer(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getActiveScorer", $$robo$$android_net_NetworkScorerAppManager$getActiveScorer(android.content.Context ), 0, (Context)context);
    }

    public static boolean setActiveScorer(Context context, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("setActiveScorer", $$robo$$android_net_NetworkScorerAppManager$setActiveScorer(android.content.Context java.lang.String ), 0, (Context)context, (String)string2);
    }

    public static boolean isCallerActiveScorer(Context context, int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isCallerActiveScorer", $$robo$$android_net_NetworkScorerAppManager$isCallerActiveScorer(android.content.Context int ), 0, (Context)context, (int)n);
    }

    public static NetworkScorerAppData getScorer(Context context, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getScorer", $$robo$$android_net_NetworkScorerAppManager$getScorer(android.content.Context java.lang.String ), 0, (Context)context, (String)string2);
    }

    static {
        RobolectricInternals.classInitializing(NetworkScorerAppManager.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NetworkScorerAppManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class NetworkScorerAppData
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public String mPackageName;
        public CharSequence mScorerName;
        public String mConfigurationActivityClassName;

        private void $$robo$$android_net_NetworkScorerAppManager_NetworkScorerAppData$__constructor__(String packageName, CharSequence scorerName, String configurationActivityClassName) {
            this.mScorerName = scorerName;
            this.mPackageName = packageName;
            this.mConfigurationActivityClassName = configurationActivityClassName;
        }

        private void __constructor__(String string2, CharSequence charSequence, String string3) {
            this.$$robo$$android_net_NetworkScorerAppManager_NetworkScorerAppData$__constructor__(string2, charSequence, string3);
        }

        public NetworkScorerAppData(String string2, CharSequence charSequence, String string3) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_NetworkScorerAppManager_NetworkScorerAppData$__constructor__(java.lang.String java.lang.CharSequence java.lang.String ), 0, this, string2, charSequence, string3);
        }

        public /* synthetic */ NetworkScorerAppData() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NetworkScorerAppData)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

