/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.util.SparseBooleanArray;
import com.android.internal.util.ArrayUtils;
import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import libcore.util.EmptyArray;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class NetworkStats
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static String IFACE_ALL;
    public static int UID_ALL = -1;
    public static int TAG_ALL = -1;
    public static int SET_ALL = -1;
    public static int SET_DEFAULT = 0;
    public static int SET_FOREGROUND = 1;
    public static int TAG_NONE = 0;
    private long elapsedRealtime;
    private int size;
    private int capacity;
    private String[] iface;
    private int[] uid;
    private int[] set;
    private int[] tag;
    private long[] rxBytes;
    private long[] rxPackets;
    private long[] txBytes;
    private long[] txPackets;
    private long[] operations;
    public static Parcelable.Creator<NetworkStats> CREATOR;

    private void $$robo$$android_net_NetworkStats$__constructor__(long elapsedRealtime, int initialSize) {
        this.elapsedRealtime = elapsedRealtime;
        this.size = 0;
        if (initialSize >= 0) {
            this.capacity = initialSize;
            this.iface = new String[initialSize];
            this.uid = new int[initialSize];
            this.set = new int[initialSize];
            this.tag = new int[initialSize];
            this.rxBytes = new long[initialSize];
            this.rxPackets = new long[initialSize];
            this.txBytes = new long[initialSize];
            this.txPackets = new long[initialSize];
            this.operations = new long[initialSize];
        } else {
            this.capacity = 0;
            this.iface = EmptyArray.STRING;
            this.uid = EmptyArray.INT;
            this.set = EmptyArray.INT;
            this.tag = EmptyArray.INT;
            this.rxBytes = EmptyArray.LONG;
            this.rxPackets = EmptyArray.LONG;
            this.txBytes = EmptyArray.LONG;
            this.txPackets = EmptyArray.LONG;
            this.operations = EmptyArray.LONG;
        }
    }

    private void $$robo$$android_net_NetworkStats$__constructor__(Parcel parcel) {
        this.elapsedRealtime = parcel.readLong();
        this.size = parcel.readInt();
        this.capacity = parcel.readInt();
        this.iface = parcel.createStringArray();
        this.uid = parcel.createIntArray();
        this.set = parcel.createIntArray();
        this.tag = parcel.createIntArray();
        this.rxBytes = parcel.createLongArray();
        this.rxPackets = parcel.createLongArray();
        this.txBytes = parcel.createLongArray();
        this.txPackets = parcel.createLongArray();
        this.operations = parcel.createLongArray();
    }

    private final void $$robo$$android_net_NetworkStats$writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.elapsedRealtime);
        dest.writeInt(this.size);
        dest.writeInt(this.capacity);
        dest.writeStringArray(this.iface);
        dest.writeIntArray(this.uid);
        dest.writeIntArray(this.set);
        dest.writeIntArray(this.tag);
        dest.writeLongArray(this.rxBytes);
        dest.writeLongArray(this.rxPackets);
        dest.writeLongArray(this.txBytes);
        dest.writeLongArray(this.txPackets);
        dest.writeLongArray(this.operations);
    }

    private final NetworkStats $$robo$$android_net_NetworkStats$clone() {
        NetworkStats clone = new NetworkStats(this.elapsedRealtime, this.size);
        Entry entry = null;
        for (int i = 0; i < this.size; ++i) {
            entry = this.getValues(i, entry);
            clone.addValues(entry);
        }
        return clone;
    }

    private final NetworkStats $$robo$$android_net_NetworkStats$addIfaceValues(String iface, long rxBytes, long rxPackets, long txBytes, long txPackets) {
        return this.addValues(iface, -1, 0, 0, rxBytes, rxPackets, txBytes, txPackets, 0L);
    }

    private final NetworkStats $$robo$$android_net_NetworkStats$addValues(String iface, int uid, int set, int tag, long rxBytes, long rxPackets, long txBytes, long txPackets, long operations) {
        return this.addValues(new Entry(iface, uid, set, tag, rxBytes, rxPackets, txBytes, txPackets, operations));
    }

    private final NetworkStats $$robo$$android_net_NetworkStats$addValues(Entry entry) {
        if (this.size >= this.capacity) {
            int newLength = Math.max(this.size, 10) * 3 / 2;
            this.iface = Arrays.copyOf(this.iface, newLength);
            this.uid = Arrays.copyOf(this.uid, newLength);
            this.set = Arrays.copyOf(this.set, newLength);
            this.tag = Arrays.copyOf(this.tag, newLength);
            this.rxBytes = Arrays.copyOf(this.rxBytes, newLength);
            this.rxPackets = Arrays.copyOf(this.rxPackets, newLength);
            this.txBytes = Arrays.copyOf(this.txBytes, newLength);
            this.txPackets = Arrays.copyOf(this.txPackets, newLength);
            this.operations = Arrays.copyOf(this.operations, newLength);
            this.capacity = newLength;
        }
        this.iface[this.size] = entry.iface;
        this.uid[this.size] = entry.uid;
        this.set[this.size] = entry.set;
        this.tag[this.size] = entry.tag;
        this.rxBytes[this.size] = entry.rxBytes;
        this.rxPackets[this.size] = entry.rxPackets;
        this.txBytes[this.size] = entry.txBytes;
        this.txPackets[this.size] = entry.txPackets;
        this.operations[this.size] = entry.operations;
        ++this.size;
        return this;
    }

    private final Entry $$robo$$android_net_NetworkStats$getValues(int i, Entry recycle) {
        Entry entry = recycle != null ? recycle : new Entry();
        entry.iface = this.iface[i];
        entry.uid = this.uid[i];
        entry.set = this.set[i];
        entry.tag = this.tag[i];
        entry.rxBytes = this.rxBytes[i];
        entry.rxPackets = this.rxPackets[i];
        entry.txBytes = this.txBytes[i];
        entry.txPackets = this.txPackets[i];
        entry.operations = this.operations[i];
        return entry;
    }

    private final long $$robo$$android_net_NetworkStats$getElapsedRealtime() {
        return this.elapsedRealtime;
    }

    private final void $$robo$$android_net_NetworkStats$setElapsedRealtime(long time) {
        this.elapsedRealtime = time;
    }

    private final long $$robo$$android_net_NetworkStats$getElapsedRealtimeAge() {
        return SystemClock.elapsedRealtime() - this.elapsedRealtime;
    }

    private final int $$robo$$android_net_NetworkStats$size() {
        return this.size;
    }

    private final int $$robo$$android_net_NetworkStats$internalSize() {
        return this.capacity;
    }

    @Deprecated
    private final NetworkStats $$robo$$android_net_NetworkStats$combineValues(String iface, int uid, int tag, long rxBytes, long rxPackets, long txBytes, long txPackets, long operations) {
        return this.combineValues(iface, uid, 0, tag, rxBytes, rxPackets, txBytes, txPackets, operations);
    }

    private final NetworkStats $$robo$$android_net_NetworkStats$combineValues(String iface, int uid, int set, int tag, long rxBytes, long rxPackets, long txBytes, long txPackets, long operations) {
        return this.combineValues(new Entry(iface, uid, set, tag, rxBytes, rxPackets, txBytes, txPackets, operations));
    }

    private final NetworkStats $$robo$$android_net_NetworkStats$combineValues(Entry entry) {
        int i = this.findIndex(entry.iface, entry.uid, entry.set, entry.tag);
        if (i == -1) {
            this.addValues(entry);
        } else {
            int n = i;
            this.rxBytes[n] = this.rxBytes[n] + entry.rxBytes;
            int n2 = i;
            this.rxPackets[n2] = this.rxPackets[n2] + entry.rxPackets;
            int n3 = i;
            this.txBytes[n3] = this.txBytes[n3] + entry.txBytes;
            int n4 = i;
            this.txPackets[n4] = this.txPackets[n4] + entry.txPackets;
            int n5 = i;
            this.operations[n5] = this.operations[n5] + entry.operations;
        }
        return this;
    }

    private final void $$robo$$android_net_NetworkStats$combineAllValues(NetworkStats another) {
        Entry entry = null;
        for (int i = 0; i < another.size; ++i) {
            entry = another.getValues(i, entry);
            this.combineValues(entry);
        }
    }

    private final int $$robo$$android_net_NetworkStats$findIndex(String iface, int uid, int set, int tag) {
        for (int i = 0; i < this.size; ++i) {
            if (uid != this.uid[i] || set != this.set[i] || tag != this.tag[i] || !Objects.equals(iface, this.iface[i])) continue;
            return i;
        }
        return -1;
    }

    private final int $$robo$$android_net_NetworkStats$findIndexHinted(String iface, int uid, int set, int tag, int hintIndex) {
        for (int offset = 0; offset < this.size; ++offset) {
            int halfOffset = offset / 2;
            int i = offset % 2 == 0 ? (hintIndex + halfOffset) % this.size : (this.size + hintIndex - halfOffset - 1) % this.size;
            if (uid != this.uid[i] || set != this.set[i] || tag != this.tag[i] || !Objects.equals(iface, this.iface[i])) continue;
            return i;
        }
        return -1;
    }

    private final void $$robo$$android_net_NetworkStats$spliceOperationsFrom(NetworkStats stats) {
        for (int i = 0; i < this.size; ++i) {
            int j = stats.findIndex(this.iface[i], this.uid[i], this.set[i], this.tag[i]);
            this.operations[i] = j == -1 ? 0L : stats.operations[j];
        }
    }

    private final String[] $$robo$$android_net_NetworkStats$getUniqueIfaces() {
        HashSet<String> ifaces = new HashSet<String>();
        for (String iface : this.iface) {
            if (iface == IFACE_ALL) continue;
            ifaces.add(iface);
        }
        return ifaces.toArray(new String[ifaces.size()]);
    }

    private final int[] $$robo$$android_net_NetworkStats$getUniqueUids() {
        SparseBooleanArray uids = new SparseBooleanArray();
        for (int uid : this.uid) {
            uids.put(uid, true);
        }
        int size = uids.size();
        int[] result = new int[size];
        for (int i = 0; i < size; ++i) {
            result[i] = uids.keyAt(i);
        }
        return result;
    }

    private final long $$robo$$android_net_NetworkStats$getTotalBytes() {
        Entry entry = this.getTotal(null);
        return entry.rxBytes + entry.txBytes;
    }

    private final Entry $$robo$$android_net_NetworkStats$getTotal(Entry recycle) {
        return this.getTotal(recycle, null, -1, false);
    }

    private final Entry $$robo$$android_net_NetworkStats$getTotal(Entry recycle, int limitUid) {
        return this.getTotal(recycle, null, limitUid, false);
    }

    private final Entry $$robo$$android_net_NetworkStats$getTotal(Entry recycle, HashSet<String> limitIface) {
        return this.getTotal(recycle, limitIface, -1, false);
    }

    private final Entry $$robo$$android_net_NetworkStats$getTotalIncludingTags(Entry recycle) {
        return this.getTotal(recycle, null, -1, true);
    }

    private final Entry $$robo$$android_net_NetworkStats$getTotal(Entry recycle, HashSet<String> limitIface, int limitUid, boolean includeTags) {
        Entry entry = recycle != null ? recycle : new Entry();
        entry.iface = IFACE_ALL;
        entry.uid = limitUid;
        entry.set = -1;
        entry.tag = 0;
        entry.rxBytes = 0L;
        entry.rxPackets = 0L;
        entry.txBytes = 0L;
        entry.txPackets = 0L;
        entry.operations = 0L;
        for (int i = 0; i < this.size; ++i) {
            boolean matchesIface;
            boolean matchesUid = limitUid == -1 || limitUid == this.uid[i];
            boolean bl = matchesIface = limitIface == null || limitIface.contains(this.iface[i]);
            if (!matchesUid || !matchesIface || this.tag[i] != 0 && !includeTags) continue;
            entry.rxBytes += this.rxBytes[i];
            entry.rxPackets += this.rxPackets[i];
            entry.txBytes += this.txBytes[i];
            entry.txPackets += this.txPackets[i];
            entry.operations += this.operations[i];
        }
        return entry;
    }

    private final long $$robo$$android_net_NetworkStats$getTotalPackets() {
        long total = 0L;
        for (int i = this.size - 1; i >= 0; --i) {
            total += this.rxPackets[i] + this.txPackets[i];
        }
        return total;
    }

    private final NetworkStats $$robo$$android_net_NetworkStats$subtract(NetworkStats right) {
        return NetworkStats.subtract(this, right, null, null);
    }

    private static final <C> NetworkStats $$robo$$android_net_NetworkStats$subtract(NetworkStats left, NetworkStats right, NonMonotonicObserver<C> observer, C cookie) {
        return NetworkStats.subtract(left, right, observer, cookie, null);
    }

    private static final <C> NetworkStats $$robo$$android_net_NetworkStats$subtract(NetworkStats left, NetworkStats right, NonMonotonicObserver<C> observer, C cookie, NetworkStats recycle) {
        NetworkStats result;
        long deltaRealtime = left.elapsedRealtime - right.elapsedRealtime;
        if (deltaRealtime < 0L) {
            if (observer != null) {
                observer.foundNonMonotonic(left, -1, right, -1, cookie);
            }
            deltaRealtime = 0L;
        }
        Entry entry = new Entry();
        if (recycle != null && recycle.capacity >= left.size) {
            result = recycle;
            result.size = 0;
            result.elapsedRealtime = deltaRealtime;
        } else {
            result = new NetworkStats(deltaRealtime, left.size);
        }
        for (int i = 0; i < left.size; ++i) {
            entry.iface = left.iface[i];
            entry.uid = left.uid[i];
            entry.set = left.set[i];
            entry.tag = left.tag[i];
            int j = right.findIndexHinted(entry.iface, entry.uid, entry.set, entry.tag, i);
            if (j == -1) {
                entry.rxBytes = left.rxBytes[i];
                entry.rxPackets = left.rxPackets[i];
                entry.txBytes = left.txBytes[i];
                entry.txPackets = left.txPackets[i];
                entry.operations = left.operations[i];
            } else {
                entry.rxBytes = left.rxBytes[i] - right.rxBytes[j];
                entry.rxPackets = left.rxPackets[i] - right.rxPackets[j];
                entry.txBytes = left.txBytes[i] - right.txBytes[j];
                entry.txPackets = left.txPackets[i] - right.txPackets[j];
                entry.operations = left.operations[i] - right.operations[j];
                if (entry.rxBytes < 0L || entry.rxPackets < 0L || entry.txBytes < 0L || entry.txPackets < 0L || entry.operations < 0L) {
                    if (observer != null) {
                        observer.foundNonMonotonic(left, i, right, j, cookie);
                    }
                    entry.rxBytes = Math.max(entry.rxBytes, 0L);
                    entry.rxPackets = Math.max(entry.rxPackets, 0L);
                    entry.txBytes = Math.max(entry.txBytes, 0L);
                    entry.txPackets = Math.max(entry.txPackets, 0L);
                    entry.operations = Math.max(entry.operations, 0L);
                }
            }
            result.addValues(entry);
        }
        return result;
    }

    private final NetworkStats $$robo$$android_net_NetworkStats$groupedByIface() {
        NetworkStats stats = new NetworkStats(this.elapsedRealtime, 10);
        Entry entry = new Entry();
        entry.uid = -1;
        entry.set = -1;
        entry.tag = 0;
        entry.operations = 0L;
        for (int i = 0; i < this.size; ++i) {
            if (this.tag[i] != 0) continue;
            entry.iface = this.iface[i];
            entry.rxBytes = this.rxBytes[i];
            entry.rxPackets = this.rxPackets[i];
            entry.txBytes = this.txBytes[i];
            entry.txPackets = this.txPackets[i];
            stats.combineValues(entry);
        }
        return stats;
    }

    private final NetworkStats $$robo$$android_net_NetworkStats$groupedByUid() {
        NetworkStats stats = new NetworkStats(this.elapsedRealtime, 10);
        Entry entry = new Entry();
        entry.iface = IFACE_ALL;
        entry.set = -1;
        entry.tag = 0;
        for (int i = 0; i < this.size; ++i) {
            if (this.tag[i] != 0) continue;
            entry.uid = this.uid[i];
            entry.rxBytes = this.rxBytes[i];
            entry.rxPackets = this.rxPackets[i];
            entry.txBytes = this.txBytes[i];
            entry.txPackets = this.txPackets[i];
            entry.operations = this.operations[i];
            stats.combineValues(entry);
        }
        return stats;
    }

    private final NetworkStats $$robo$$android_net_NetworkStats$withoutUids(int[] uids) {
        NetworkStats stats = new NetworkStats(this.elapsedRealtime, 10);
        Entry entry = new Entry();
        for (int i = 0; i < this.size; ++i) {
            entry = this.getValues(i, entry);
            if (ArrayUtils.contains(uids, entry.uid)) continue;
            stats.addValues(entry);
        }
        return stats;
    }

    private final void $$robo$$android_net_NetworkStats$dump(String prefix, PrintWriter pw) {
        pw.print(prefix);
        pw.print("NetworkStats: elapsedRealtime=");
        pw.println(this.elapsedRealtime);
        for (int i = 0; i < this.size; ++i) {
            pw.print(prefix);
            pw.print("  [");
            pw.print(i);
            pw.print("]");
            pw.print(" iface=");
            pw.print(this.iface[i]);
            pw.print(" uid=");
            pw.print(this.uid[i]);
            pw.print(" set=");
            pw.print(NetworkStats.setToString(this.set[i]));
            pw.print(" tag=");
            pw.print(NetworkStats.tagToString(this.tag[i]));
            pw.print(" rxBytes=");
            pw.print(this.rxBytes[i]);
            pw.print(" rxPackets=");
            pw.print(this.rxPackets[i]);
            pw.print(" txBytes=");
            pw.print(this.txBytes[i]);
            pw.print(" txPackets=");
            pw.print(this.txPackets[i]);
            pw.print(" operations=");
            pw.println(this.operations[i]);
        }
    }

    private static final String $$robo$$android_net_NetworkStats$setToString(int set) {
        switch (set) {
            case -1: {
                return "ALL";
            }
            case 0: {
                return "DEFAULT";
            }
            case 1: {
                return "FOREGROUND";
            }
        }
        return "UNKNOWN";
    }

    private static final String $$robo$$android_net_NetworkStats$tagToString(int tag) {
        return "0x" + Integer.toHexString(tag);
    }

    private final String $$robo$$android_net_NetworkStats$toString() {
        CharArrayWriter writer = new CharArrayWriter();
        this.dump("", new PrintWriter(writer));
        return writer.toString();
    }

    private final int $$robo$$android_net_NetworkStats$describeContents() {
        return 0;
    }

    static void __staticInitializer__() {
        IFACE_ALL = null;
        CREATOR = new Parcelable.Creator<NetworkStats>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_net_NetworkStats_1$__constructor__() {
            }

            private final NetworkStats $$robo$$android_net_NetworkStats_1$createFromParcel(Parcel in) {
                return new NetworkStats(in);
            }

            private final NetworkStats[] $$robo$$android_net_NetworkStats_1$newArray(int size) {
                return new NetworkStats[size];
            }

            private void __constructor__() {
                this.$$robo$$android_net_NetworkStats_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_NetworkStats_1$__constructor__(), 0, this);
            }

            @Override
            public NetworkStats createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_NetworkStats_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public NetworkStats[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_NetworkStats_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(long l, int n) {
        this.$$robo$$android_net_NetworkStats$__constructor__(l, n);
    }

    public NetworkStats(long l, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_NetworkStats$__constructor__(long int ), 0, this, l, n);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_net_NetworkStats$__constructor__(parcel);
    }

    public NetworkStats(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_NetworkStats$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_NetworkStats$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    public NetworkStats clone() {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_net_NetworkStats$clone(), 0, this);
    }

    public NetworkStats addIfaceValues(String string2, long l, long l2, long l3, long l4) {
        return InvokeDynamicSupport.bootstrap("addIfaceValues", $$robo$$android_net_NetworkStats$addIfaceValues(java.lang.String long long long long ), 0, this, string2, l, l2, l3, l4);
    }

    public NetworkStats addValues(String string2, int n, int n2, int n3, long l, long l2, long l3, long l4, long l5) {
        return InvokeDynamicSupport.bootstrap("addValues", $$robo$$android_net_NetworkStats$addValues(java.lang.String int int int long long long long long ), 0, this, string2, n, n2, n3, l, l2, l3, l4, l5);
    }

    public NetworkStats addValues(Entry entry) {
        return InvokeDynamicSupport.bootstrap("addValues", $$robo$$android_net_NetworkStats$addValues(android.net.NetworkStats$Entry ), 0, this, entry);
    }

    public Entry getValues(int n, Entry entry) {
        return InvokeDynamicSupport.bootstrap("getValues", $$robo$$android_net_NetworkStats$getValues(int android.net.NetworkStats$Entry ), 0, this, n, entry);
    }

    public long getElapsedRealtime() {
        return (long)InvokeDynamicSupport.bootstrap("getElapsedRealtime", $$robo$$android_net_NetworkStats$getElapsedRealtime(), 0, this);
    }

    public void setElapsedRealtime(long l) {
        InvokeDynamicSupport.bootstrap("setElapsedRealtime", $$robo$$android_net_NetworkStats$setElapsedRealtime(long ), 0, this, l);
    }

    public long getElapsedRealtimeAge() {
        return (long)InvokeDynamicSupport.bootstrap("getElapsedRealtimeAge", $$robo$$android_net_NetworkStats$getElapsedRealtimeAge(), 0, this);
    }

    public int size() {
        return (int)InvokeDynamicSupport.bootstrap("size", $$robo$$android_net_NetworkStats$size(), 0, this);
    }

    public int internalSize() {
        return (int)InvokeDynamicSupport.bootstrap("internalSize", $$robo$$android_net_NetworkStats$internalSize(), 0, this);
    }

    @Deprecated
    public NetworkStats combineValues(String string2, int n, int n2, long l, long l2, long l3, long l4, long l5) {
        return InvokeDynamicSupport.bootstrap("combineValues", $$robo$$android_net_NetworkStats$combineValues(java.lang.String int int long long long long long ), 0, this, string2, n, n2, l, l2, l3, l4, l5);
    }

    public NetworkStats combineValues(String string2, int n, int n2, int n3, long l, long l2, long l3, long l4, long l5) {
        return InvokeDynamicSupport.bootstrap("combineValues", $$robo$$android_net_NetworkStats$combineValues(java.lang.String int int int long long long long long ), 0, this, string2, n, n2, n3, l, l2, l3, l4, l5);
    }

    public NetworkStats combineValues(Entry entry) {
        return InvokeDynamicSupport.bootstrap("combineValues", $$robo$$android_net_NetworkStats$combineValues(android.net.NetworkStats$Entry ), 0, this, entry);
    }

    public void combineAllValues(NetworkStats networkStats) {
        InvokeDynamicSupport.bootstrap("combineAllValues", $$robo$$android_net_NetworkStats$combineAllValues(android.net.NetworkStats ), 0, this, networkStats);
    }

    public int findIndex(String string2, int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrap("findIndex", $$robo$$android_net_NetworkStats$findIndex(java.lang.String int int int ), 0, this, string2, n, n2, n3);
    }

    public int findIndexHinted(String string2, int n, int n2, int n3, int n4) {
        return (int)InvokeDynamicSupport.bootstrap("findIndexHinted", $$robo$$android_net_NetworkStats$findIndexHinted(java.lang.String int int int int ), 0, this, string2, n, n2, n3, n4);
    }

    public void spliceOperationsFrom(NetworkStats networkStats) {
        InvokeDynamicSupport.bootstrap("spliceOperationsFrom", $$robo$$android_net_NetworkStats$spliceOperationsFrom(android.net.NetworkStats ), 0, this, networkStats);
    }

    public String[] getUniqueIfaces() {
        return InvokeDynamicSupport.bootstrap("getUniqueIfaces", $$robo$$android_net_NetworkStats$getUniqueIfaces(), 0, this);
    }

    public int[] getUniqueUids() {
        return InvokeDynamicSupport.bootstrap("getUniqueUids", $$robo$$android_net_NetworkStats$getUniqueUids(), 0, this);
    }

    public long getTotalBytes() {
        return (long)InvokeDynamicSupport.bootstrap("getTotalBytes", $$robo$$android_net_NetworkStats$getTotalBytes(), 0, this);
    }

    public Entry getTotal(Entry entry) {
        return InvokeDynamicSupport.bootstrap("getTotal", $$robo$$android_net_NetworkStats$getTotal(android.net.NetworkStats$Entry ), 0, this, entry);
    }

    public Entry getTotal(Entry entry, int n) {
        return InvokeDynamicSupport.bootstrap("getTotal", $$robo$$android_net_NetworkStats$getTotal(android.net.NetworkStats$Entry int ), 0, this, entry, n);
    }

    public Entry getTotal(Entry entry, HashSet<String> hashSet) {
        return InvokeDynamicSupport.bootstrap("getTotal", $$robo$$android_net_NetworkStats$getTotal(android.net.NetworkStats$Entry java.util.HashSet<java.lang.String> ), 0, this, entry, hashSet);
    }

    public Entry getTotalIncludingTags(Entry entry) {
        return InvokeDynamicSupport.bootstrap("getTotalIncludingTags", $$robo$$android_net_NetworkStats$getTotalIncludingTags(android.net.NetworkStats$Entry ), 0, this, entry);
    }

    private Entry getTotal(Entry entry, HashSet<String> hashSet, int n, boolean bl) {
        return InvokeDynamicSupport.bootstrap("getTotal", $$robo$$android_net_NetworkStats$getTotal(android.net.NetworkStats$Entry java.util.HashSet<java.lang.String> int boolean ), 0, this, entry, hashSet, n, bl);
    }

    public long getTotalPackets() {
        return (long)InvokeDynamicSupport.bootstrap("getTotalPackets", $$robo$$android_net_NetworkStats$getTotalPackets(), 0, this);
    }

    public NetworkStats subtract(NetworkStats networkStats) {
        return InvokeDynamicSupport.bootstrap("subtract", $$robo$$android_net_NetworkStats$subtract(android.net.NetworkStats ), 0, this, networkStats);
    }

    public static <C> NetworkStats subtract(NetworkStats networkStats, NetworkStats networkStats2, NonMonotonicObserver<C> nonMonotonicObserver, C c) {
        return InvokeDynamicSupport.bootstrapStatic("subtract", $$robo$$android_net_NetworkStats$subtract(android.net.NetworkStats android.net.NetworkStats android.net.NetworkStats$NonMonotonicObserver<C> C ), 0, (NetworkStats)networkStats, (NetworkStats)networkStats2, nonMonotonicObserver, c);
    }

    public static <C> NetworkStats subtract(NetworkStats networkStats, NetworkStats networkStats2, NonMonotonicObserver<C> nonMonotonicObserver, C c, NetworkStats networkStats3) {
        return InvokeDynamicSupport.bootstrapStatic("subtract", $$robo$$android_net_NetworkStats$subtract(android.net.NetworkStats android.net.NetworkStats android.net.NetworkStats$NonMonotonicObserver<C> C android.net.NetworkStats ), 0, (NetworkStats)networkStats, (NetworkStats)networkStats2, nonMonotonicObserver, c, (NetworkStats)networkStats3);
    }

    public NetworkStats groupedByIface() {
        return InvokeDynamicSupport.bootstrap("groupedByIface", $$robo$$android_net_NetworkStats$groupedByIface(), 0, this);
    }

    public NetworkStats groupedByUid() {
        return InvokeDynamicSupport.bootstrap("groupedByUid", $$robo$$android_net_NetworkStats$groupedByUid(), 0, this);
    }

    public NetworkStats withoutUids(int[] nArray) {
        return InvokeDynamicSupport.bootstrap("withoutUids", $$robo$$android_net_NetworkStats$withoutUids(int[] ), 0, this, nArray);
    }

    public void dump(String string2, PrintWriter printWriter) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_net_NetworkStats$dump(java.lang.String java.io.PrintWriter ), 0, this, string2, printWriter);
    }

    public static String setToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("setToString", $$robo$$android_net_NetworkStats$setToString(int ), 0, (int)n);
    }

    public static String tagToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("tagToString", $$robo$$android_net_NetworkStats$tagToString(int ), 0, (int)n);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_NetworkStats$toString(), 0, this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_NetworkStats$describeContents(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(NetworkStats.class);
    }

    public /* synthetic */ NetworkStats() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NetworkStats)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface NonMonotonicObserver<C> {
        public void foundNonMonotonic(NetworkStats var1, int var2, NetworkStats var3, int var4, C var5);
    }

    public static class Entry
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public String iface;
        public int uid;
        public int set;
        public int tag;
        public long rxBytes;
        public long rxPackets;
        public long txBytes;
        public long txPackets;
        public long operations;

        private void $$robo$$android_net_NetworkStats_Entry$__constructor__() {
        }

        private void $$robo$$android_net_NetworkStats_Entry$__constructor__(long rxBytes, long rxPackets, long txBytes, long txPackets, long operations) {
        }

        private void $$robo$$android_net_NetworkStats_Entry$__constructor__(String iface, int uid, int set, int tag, long rxBytes, long rxPackets, long txBytes, long txPackets, long operations) {
            this.iface = iface;
            this.uid = uid;
            this.set = set;
            this.tag = tag;
            this.rxBytes = rxBytes;
            this.rxPackets = rxPackets;
            this.txBytes = txBytes;
            this.txPackets = txPackets;
            this.operations = operations;
        }

        private final boolean $$robo$$android_net_NetworkStats_Entry$isNegative() {
            return this.rxBytes < 0L || this.rxPackets < 0L || this.txBytes < 0L || this.txPackets < 0L || this.operations < 0L;
        }

        private final boolean $$robo$$android_net_NetworkStats_Entry$isEmpty() {
            return this.rxBytes == 0L && this.rxPackets == 0L && this.txBytes == 0L && this.txPackets == 0L && this.operations == 0L;
        }

        private final void $$robo$$android_net_NetworkStats_Entry$add(Entry another) {
            this.rxBytes += another.rxBytes;
            this.rxPackets += another.rxPackets;
            this.txBytes += another.txBytes;
            this.txPackets += another.txPackets;
            this.operations += another.operations;
        }

        private final String $$robo$$android_net_NetworkStats_Entry$toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("iface=").append(this.iface);
            builder.append(" uid=").append(this.uid);
            builder.append(" set=").append(NetworkStats.setToString(this.set));
            builder.append(" tag=").append(NetworkStats.tagToString(this.tag));
            builder.append(" rxBytes=").append(this.rxBytes);
            builder.append(" rxPackets=").append(this.rxPackets);
            builder.append(" txBytes=").append(this.txBytes);
            builder.append(" txPackets=").append(this.txPackets);
            builder.append(" operations=").append(this.operations);
            return builder.toString();
        }

        private final boolean $$robo$$android_net_NetworkStats_Entry$equals(Object o) {
            if (o instanceof Entry) {
                Entry e = (Entry)o;
                return this.uid == e.uid && this.set == e.set && this.tag == e.tag && this.rxBytes == e.rxBytes && this.rxPackets == e.rxPackets && this.txBytes == e.txBytes && this.txPackets == e.txPackets && this.operations == e.operations && this.iface.equals(e.iface);
            }
            return false;
        }

        private void __constructor__() {
            this.$$robo$$android_net_NetworkStats_Entry$__constructor__();
        }

        public Entry() {
            this(IFACE_ALL, -1, 0, 0, 0L, 0L, 0L, 0L, 0L);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_NetworkStats_Entry$__constructor__(), 0, this);
        }

        private void __constructor__(long l, long l2, long l3, long l4, long l5) {
            this.$$robo$$android_net_NetworkStats_Entry$__constructor__(l, l2, l3, l4, l5);
        }

        public Entry(long l, long l2, long l3, long l4, long l5) {
            this(IFACE_ALL, -1, 0, 0, l, l2, l3, l4, l5);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_NetworkStats_Entry$__constructor__(long long long long long ), 0, this, l, l2, l3, l4, l5);
        }

        private void __constructor__(String string2, int n, int n2, int n3, long l, long l2, long l3, long l4, long l5) {
            this.$$robo$$android_net_NetworkStats_Entry$__constructor__(string2, n, n2, n3, l, l2, l3, l4, l5);
        }

        public Entry(String string2, int n, int n2, int n3, long l, long l2, long l3, long l4, long l5) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_NetworkStats_Entry$__constructor__(java.lang.String int int int long long long long long ), 0, this, string2, n, n2, n3, l, l2, l3, l4, l5);
        }

        public boolean isNegative() {
            return (boolean)InvokeDynamicSupport.bootstrap("isNegative", $$robo$$android_net_NetworkStats_Entry$isNegative(), 0, this);
        }

        public boolean isEmpty() {
            return (boolean)InvokeDynamicSupport.bootstrap("isEmpty", $$robo$$android_net_NetworkStats_Entry$isEmpty(), 0, this);
        }

        public void add(Entry entry) {
            InvokeDynamicSupport.bootstrap("add", $$robo$$android_net_NetworkStats_Entry$add(android.net.NetworkStats$Entry ), 0, this, entry);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_NetworkStats_Entry$toString(), 0, this);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_net_NetworkStats_Entry$equals(java.lang.Object ), 0, this, object);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Entry)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

