/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.DhcpResults;
import android.os.Parcel;
import android.util.Log;
import android.util.Pair;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Locale;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class NetworkUtils
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "NetworkUtils";
    public static int RESET_IPV4_ADDRESSES = 1;
    public static int RESET_IPV6_ADDRESSES = 2;
    public static int RESET_ALL_ADDRESSES = 3;

    private void $$robo$$android_net_NetworkUtils$__constructor__() {
    }

    private static final int $$robo$$android_net_NetworkUtils$resetConnections(String string2, int n) {
        return 0;
    }

    private static final boolean $$robo$$android_net_NetworkUtils$runDhcp(String string2, DhcpResults dhcpResults) {
        return false;
    }

    private static final boolean $$robo$$android_net_NetworkUtils$runDhcpRenew(String string2, DhcpResults dhcpResults) {
        return false;
    }

    private static final boolean $$robo$$android_net_NetworkUtils$stopDhcp(String string2) {
        return false;
    }

    private static final boolean $$robo$$android_net_NetworkUtils$releaseDhcpLease(String string2) {
        return false;
    }

    private static final String $$robo$$android_net_NetworkUtils$getDhcpError() {
        return null;
    }

    private static final boolean $$robo$$android_net_NetworkUtils$bindProcessToNetwork(int n) {
        return false;
    }

    private static final int $$robo$$android_net_NetworkUtils$getNetworkBoundToProcess() {
        return 0;
    }

    private static final boolean $$robo$$android_net_NetworkUtils$bindProcessToNetworkForHostResolution(int n) {
        return false;
    }

    private static final int $$robo$$android_net_NetworkUtils$bindSocketToNetwork(int n, int n2) {
        return 0;
    }

    private static final boolean $$robo$$android_net_NetworkUtils$protectFromVpn(int n) {
        return false;
    }

    private static final InetAddress $$robo$$android_net_NetworkUtils$intToInetAddress(int hostAddress) {
        byte[] addressBytes = new byte[]{(byte)(0xFF & hostAddress), (byte)(0xFF & hostAddress >> 8), (byte)(0xFF & hostAddress >> 16), (byte)(0xFF & hostAddress >> 24)};
        try {
            return InetAddress.getByAddress(addressBytes);
        }
        catch (UnknownHostException e) {
            throw new AssertionError();
        }
    }

    private static final int $$robo$$android_net_NetworkUtils$inetAddressToInt(Inet4Address inetAddr) throws IllegalArgumentException {
        byte[] addr = inetAddr.getAddress();
        return (addr[3] & 0xFF) << 24 | (addr[2] & 0xFF) << 16 | (addr[1] & 0xFF) << 8 | addr[0] & 0xFF;
    }

    private static final int $$robo$$android_net_NetworkUtils$prefixLengthToNetmaskInt(int prefixLength) throws IllegalArgumentException {
        if (prefixLength < 0 || prefixLength > 32) {
            throw new IllegalArgumentException("Invalid prefix length (0 <= prefix <= 32)");
        }
        int value = -1 << 32 - prefixLength;
        return Integer.reverseBytes(value);
    }

    private static final int $$robo$$android_net_NetworkUtils$netmaskIntToPrefixLength(int netmask) {
        return Integer.bitCount(netmask);
    }

    private static final InetAddress $$robo$$android_net_NetworkUtils$numericToInetAddress(String addrString) throws IllegalArgumentException {
        return InetAddress.parseNumericAddress(addrString);
    }

    private static final void $$robo$$android_net_NetworkUtils$parcelInetAddress(Parcel parcel, InetAddress address, int flags) {
        byte[] addressArray = address != null ? address.getAddress() : null;
        parcel.writeByteArray(addressArray);
    }

    private static final InetAddress $$robo$$android_net_NetworkUtils$unparcelInetAddress(Parcel in) {
        byte[] addressArray = in.createByteArray();
        if (addressArray == null) {
            return null;
        }
        try {
            return InetAddress.getByAddress(addressArray);
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    private static final void $$robo$$android_net_NetworkUtils$maskRawAddress(byte[] array2, int prefixLength) {
        if (prefixLength < 0 || prefixLength > array2.length * 8) {
            throw new RuntimeException("IP address with " + array2.length + " bytes has invalid prefix length " + prefixLength);
        }
        int offset = prefixLength / 8;
        int remainder = prefixLength % 8;
        byte mask = (byte)(255 << 8 - remainder);
        if (offset < array2.length) {
            array2[offset] = (byte)(array2[offset] & mask);
        }
        ++offset;
        while (offset < array2.length) {
            array2[offset] = 0;
            ++offset;
        }
    }

    private static final InetAddress $$robo$$android_net_NetworkUtils$getNetworkPart(InetAddress address, int prefixLength) {
        byte[] array2 = address.getAddress();
        NetworkUtils.maskRawAddress(array2, prefixLength);
        InetAddress netPart = null;
        try {
            netPart = InetAddress.getByAddress(array2);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("getNetworkPart error - " + e.toString());
        }
        return netPart;
    }

    private static final Pair<InetAddress, Integer> $$robo$$android_net_NetworkUtils$parseIpAndMask(String ipAndMaskString) {
        InetAddress address = null;
        int prefixLength = -1;
        try {
            String[] pieces = ipAndMaskString.split("/", 2);
            prefixLength = Integer.parseInt(pieces[1]);
            address = InetAddress.parseNumericAddress(pieces[0]);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (address == null || prefixLength == -1) {
            throw new IllegalArgumentException("Invalid IP address and mask " + ipAndMaskString);
        }
        return new Pair<Object, Integer>(address, prefixLength);
    }

    private static final boolean $$robo$$android_net_NetworkUtils$addressTypeMatches(InetAddress left, InetAddress right) {
        return left instanceof Inet4Address && right instanceof Inet4Address || left instanceof Inet6Address && right instanceof Inet6Address;
    }

    private static final InetAddress $$robo$$android_net_NetworkUtils$hexToInet6Address(String addrHexString) throws IllegalArgumentException {
        try {
            return NetworkUtils.numericToInetAddress(String.format(Locale.US, "%s:%s:%s:%s:%s:%s:%s:%s", addrHexString.substring(0, 4), addrHexString.substring(4, 8), addrHexString.substring(8, 12), addrHexString.substring(12, 16), addrHexString.substring(16, 20), addrHexString.substring(20, 24), addrHexString.substring(24, 28), addrHexString.substring(28, 32)));
        }
        catch (Exception e) {
            Log.e("NetworkUtils", "error in hexToInet6Address(" + addrHexString + "): " + e);
            throw new IllegalArgumentException(e);
        }
    }

    private static final String[] $$robo$$android_net_NetworkUtils$makeStrings(Collection<InetAddress> addrs) {
        String[] result = new String[addrs.size()];
        int i = 0;
        for (InetAddress addr : addrs) {
            result[i++] = addr.getHostAddress();
        }
        return result;
    }

    private static final String $$robo$$android_net_NetworkUtils$trimV4AddrZeros(String addr) {
        if (addr == null) {
            return null;
        }
        String[] octets = addr.split("\\.");
        if (octets.length != 4) {
            return addr;
        }
        StringBuilder builder = new StringBuilder(16);
        String result = null;
        for (int i = 0; i < 4; ++i) {
            try {
                if (octets[i].length() > 3) {
                    return addr;
                }
                builder.append(Integer.parseInt(octets[i]));
            }
            catch (NumberFormatException e) {
                return addr;
            }
            if (i >= 3) continue;
            builder.append('.');
        }
        result = builder.toString();
        return result;
    }

    private void __constructor__() {
        this.$$robo$$android_net_NetworkUtils$__constructor__();
    }

    public NetworkUtils() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_NetworkUtils$__constructor__(), 0, this);
    }

    private static final native /* synthetic */ int $$robo$$resetConnections$nativeBinding(String var0, int var1);

    public static int resetConnections(String string2, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("resetConnections", $$robo$$android_net_NetworkUtils$resetConnections(java.lang.String int ), 1, (String)string2, (int)n);
    }

    private static final native /* synthetic */ boolean $$robo$$runDhcp$nativeBinding(String var0, DhcpResults var1);

    public static boolean runDhcp(String string2, DhcpResults dhcpResults) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("runDhcp", $$robo$$android_net_NetworkUtils$runDhcp(java.lang.String android.net.DhcpResults ), 1, (String)string2, (DhcpResults)dhcpResults);
    }

    private static final native /* synthetic */ boolean $$robo$$runDhcpRenew$nativeBinding(String var0, DhcpResults var1);

    public static boolean runDhcpRenew(String string2, DhcpResults dhcpResults) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("runDhcpRenew", $$robo$$android_net_NetworkUtils$runDhcpRenew(java.lang.String android.net.DhcpResults ), 1, (String)string2, (DhcpResults)dhcpResults);
    }

    private static final native /* synthetic */ boolean $$robo$$stopDhcp$nativeBinding(String var0);

    public static boolean stopDhcp(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("stopDhcp", $$robo$$android_net_NetworkUtils$stopDhcp(java.lang.String ), 1, (String)string2);
    }

    private static final native /* synthetic */ boolean $$robo$$releaseDhcpLease$nativeBinding(String var0);

    public static boolean releaseDhcpLease(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("releaseDhcpLease", $$robo$$android_net_NetworkUtils$releaseDhcpLease(java.lang.String ), 1, (String)string2);
    }

    private static final native /* synthetic */ String $$robo$$getDhcpError$nativeBinding();

    public static String getDhcpError() {
        return InvokeDynamicSupport.bootstrapStatic("getDhcpError", $$robo$$android_net_NetworkUtils$getDhcpError(), 1);
    }

    private static final native /* synthetic */ boolean $$robo$$bindProcessToNetwork$nativeBinding(int var0);

    public static boolean bindProcessToNetwork(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("bindProcessToNetwork", $$robo$$android_net_NetworkUtils$bindProcessToNetwork(int ), 1, (int)n);
    }

    private static final native /* synthetic */ int $$robo$$getNetworkBoundToProcess$nativeBinding();

    public static int getNetworkBoundToProcess() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getNetworkBoundToProcess", $$robo$$android_net_NetworkUtils$getNetworkBoundToProcess(), 1);
    }

    private static final native /* synthetic */ boolean $$robo$$bindProcessToNetworkForHostResolution$nativeBinding(int var0);

    public static boolean bindProcessToNetworkForHostResolution(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("bindProcessToNetworkForHostResolution", $$robo$$android_net_NetworkUtils$bindProcessToNetworkForHostResolution(int ), 1, (int)n);
    }

    private static final native /* synthetic */ int $$robo$$bindSocketToNetwork$nativeBinding(int var0, int var1);

    public static int bindSocketToNetwork(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("bindSocketToNetwork", $$robo$$android_net_NetworkUtils$bindSocketToNetwork(int int ), 1, (int)n, (int)n2);
    }

    private static final native /* synthetic */ boolean $$robo$$protectFromVpn$nativeBinding(int var0);

    public static boolean protectFromVpn(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("protectFromVpn", $$robo$$android_net_NetworkUtils$protectFromVpn(int ), 1, (int)n);
    }

    public static InetAddress intToInetAddress(int n) {
        return InvokeDynamicSupport.bootstrapStatic("intToInetAddress", $$robo$$android_net_NetworkUtils$intToInetAddress(int ), 0, (int)n);
    }

    public static int inetAddressToInt(Inet4Address inet4Address) throws IllegalArgumentException {
        return (int)InvokeDynamicSupport.bootstrapStatic("inetAddressToInt", $$robo$$android_net_NetworkUtils$inetAddressToInt(java.net.Inet4Address ), 0, (Inet4Address)inet4Address);
    }

    public static int prefixLengthToNetmaskInt(int n) throws IllegalArgumentException {
        return (int)InvokeDynamicSupport.bootstrapStatic("prefixLengthToNetmaskInt", $$robo$$android_net_NetworkUtils$prefixLengthToNetmaskInt(int ), 0, (int)n);
    }

    public static int netmaskIntToPrefixLength(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("netmaskIntToPrefixLength", $$robo$$android_net_NetworkUtils$netmaskIntToPrefixLength(int ), 0, (int)n);
    }

    public static InetAddress numericToInetAddress(String string2) throws IllegalArgumentException {
        return InvokeDynamicSupport.bootstrapStatic("numericToInetAddress", $$robo$$android_net_NetworkUtils$numericToInetAddress(java.lang.String ), 0, (String)string2);
    }

    protected static void parcelInetAddress(Parcel parcel, InetAddress inetAddress, int n) {
        InvokeDynamicSupport.bootstrapStatic("parcelInetAddress", $$robo$$android_net_NetworkUtils$parcelInetAddress(android.os.Parcel java.net.InetAddress int ), 0, (Parcel)parcel, (InetAddress)inetAddress, (int)n);
    }

    protected static InetAddress unparcelInetAddress(Parcel parcel) {
        return InvokeDynamicSupport.bootstrapStatic("unparcelInetAddress", $$robo$$android_net_NetworkUtils$unparcelInetAddress(android.os.Parcel ), 0, (Parcel)parcel);
    }

    public static void maskRawAddress(byte[] byArray, int n) {
        InvokeDynamicSupport.bootstrapStatic("maskRawAddress", $$robo$$android_net_NetworkUtils$maskRawAddress(byte[] int ), 0, (byte[])byArray, (int)n);
    }

    public static InetAddress getNetworkPart(InetAddress inetAddress, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getNetworkPart", $$robo$$android_net_NetworkUtils$getNetworkPart(java.net.InetAddress int ), 0, (InetAddress)inetAddress, (int)n);
    }

    public static Pair<InetAddress, Integer> parseIpAndMask(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("parseIpAndMask", $$robo$$android_net_NetworkUtils$parseIpAndMask(java.lang.String ), 0, (String)string2);
    }

    public static boolean addressTypeMatches(InetAddress inetAddress, InetAddress inetAddress2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("addressTypeMatches", $$robo$$android_net_NetworkUtils$addressTypeMatches(java.net.InetAddress java.net.InetAddress ), 0, (InetAddress)inetAddress, (InetAddress)inetAddress2);
    }

    public static InetAddress hexToInet6Address(String string2) throws IllegalArgumentException {
        return InvokeDynamicSupport.bootstrapStatic("hexToInet6Address", $$robo$$android_net_NetworkUtils$hexToInet6Address(java.lang.String ), 0, (String)string2);
    }

    public static String[] makeStrings(Collection<InetAddress> collection) {
        return InvokeDynamicSupport.bootstrapStatic("makeStrings", $$robo$$android_net_NetworkUtils$makeStrings(java.util.Collection<java.net.InetAddress> ), 0, collection);
    }

    public static String trimV4AddrZeros(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("trimV4AddrZeros", $$robo$$android_net_NetworkUtils$trimV4AddrZeros(java.lang.String ), 0, (String)string2);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NetworkUtils)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

