/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.BaseNetworkStateTracker;
import android.net.LinkProperties;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.util.Log;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ProxyDataTracker
extends BaseNetworkStateTracker
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "ProxyDataTracker";
    private static String NETWORK_TYPE = "PROXY";
    private static String DNS1 = "8.8.8.8";
    private static String DNS2 = "8.8.4.4";
    private static String INTERFACE_NAME = "ifb0";
    private static String REASON_ENABLED = "enabled";
    private static String REASON_DISABLED = "disabled";
    private static String REASON_PROXY_DOWN = "proxy_down";
    private static int MSG_TEAR_DOWN_REQUEST = 1;
    private static int MSG_SETUP_REQUEST = 2;
    private static String PERMISSION_PROXY_STATUS_SENDER = "android.permission.ACCESS_NETWORK_CONDITIONS";
    private static String ACTION_PROXY_STATUS_CHANGE = "com.android.net.PROXY_STATUS_CHANGE";
    private static String KEY_IS_PROXY_AVAILABLE = "is_proxy_available";
    private static String KEY_REPLY_TO_MESSENGER_BINDER = "reply_to_messenger_binder";
    private static String KEY_REPLY_TO_MESSENGER_BINDER_BUNDLE = "reply_to_messenger_binder_bundle";
    private Handler mTarget;
    private Messenger mProxyStatusService;
    private AtomicBoolean mReconnectRequested;
    private AtomicBoolean mIsProxyAvailable;
    private AtomicInteger mDefaultGatewayAddr;
    private BroadcastReceiver mProxyStatusServiceListener;

    private void $$robo$$android_net_ProxyDataTracker$__constructor__() {
        this.mReconnectRequested = new AtomicBoolean(false);
        this.mIsProxyAvailable = new AtomicBoolean(false);
        this.mDefaultGatewayAddr = new AtomicInteger(0);
        this.mProxyStatusServiceListener = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ ProxyDataTracker this$0;

            private void $$robo$$android_net_ProxyDataTracker_1$__constructor__(ProxyDataTracker proxyDataTracker) {
            }

            private final void $$robo$$android_net_ProxyDataTracker_1$onReceive(Context context, Intent intent) {
                if (intent.getAction().equals("com.android.net.PROXY_STATUS_CHANGE")) {
                    this.this$0.mIsProxyAvailable.set(intent.getBooleanExtra("is_proxy_available", false));
                    if (this.this$0.mIsProxyAvailable.get()) {
                        Bundle bundle = intent.getBundleExtra("reply_to_messenger_binder_bundle");
                        if (bundle == null || bundle.getBinder("reply_to_messenger_binder") == null) {
                            Log.e("ProxyDataTracker", "no messenger binder in the intent to send future requests");
                            this.this$0.mIsProxyAvailable.set(false);
                            return;
                        }
                        this.this$0.mProxyStatusService = new Messenger(bundle.getBinder("reply_to_messenger_binder"));
                        if (this.this$0.mReconnectRequested.get()) {
                            this.this$0.reconnect();
                        }
                    } else {
                        this.this$0.setDetailedState(NetworkInfo.DetailedState.DISCONNECTED, "proxy_down", null);
                    }
                } else {
                    Log.d("ProxyDataTracker", "Unrecognized broadcast intent");
                }
            }

            private void __constructor__(ProxyDataTracker proxyDataTracker) {
                this.$$robo$$android_net_ProxyDataTracker_1$__constructor__(proxyDataTracker);
            }
            {
                this.this$0 = proxyDataTracker;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_ProxyDataTracker_1$__constructor__(android.net.ProxyDataTracker ), 0, this, proxyDataTracker);
            }

            @Override
            public void onReceive(Context context, Intent intent) {
                InvokeDynamicSupport.bootstrap("onReceive", $$robo$$android_net_ProxyDataTracker_1$onReceive(android.content.Context android.content.Intent ), 0, this, context, intent);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mNetworkInfo = new NetworkInfo(16, 0, "PROXY", "");
        this.mLinkProperties = new LinkProperties();
        this.mNetworkCapabilities = new NetworkCapabilities();
        this.mNetworkInfo.setIsAvailable(true);
        try {
            this.mLinkProperties.addDnsServer(InetAddress.getByName("8.8.8.8"));
            this.mLinkProperties.addDnsServer(InetAddress.getByName("8.8.4.4"));
            this.mLinkProperties.setInterfaceName("ifb0");
        }
        catch (UnknownHostException e) {
            Log.e("ProxyDataTracker", "Could not add DNS address", e);
        }
    }

    private final Object $$robo$$android_net_ProxyDataTracker$clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    private final void $$robo$$android_net_ProxyDataTracker$startMonitoring(Context context, Handler target) {
        this.mContext = context;
        this.mTarget = target;
        this.mContext.registerReceiver(this.mProxyStatusServiceListener, new IntentFilter("com.android.net.PROXY_STATUS_CHANGE"), "android.permission.ACCESS_NETWORK_CONDITIONS", null);
    }

    private final boolean $$robo$$android_net_ProxyDataTracker$teardown() {
        this.setTeardownRequested(true);
        this.mReconnectRequested.set(false);
        try {
            if (this.mIsProxyAvailable.get() && this.mProxyStatusService != null) {
                this.mProxyStatusService.send(Message.obtain(null, 1));
            }
        }
        catch (RemoteException e) {
            Log.e("ProxyDataTracker", "Unable to connect to proxy status service", e);
            return false;
        }
        this.setDetailedState(NetworkInfo.DetailedState.DISCONNECTED, "disabled", null);
        return true;
    }

    private final boolean $$robo$$android_net_ProxyDataTracker$reconnect() {
        this.mReconnectRequested.set(true);
        this.setTeardownRequested(false);
        if (!this.mIsProxyAvailable.get()) {
            Log.w("ProxyDataTracker", "Reconnect requested even though proxy service is not up. Bailing.");
            return false;
        }
        this.setDetailedState(NetworkInfo.DetailedState.CONNECTING, "enabled", null);
        try {
            this.mProxyStatusService.send(Message.obtain(null, 2));
        }
        catch (RemoteException e) {
            Log.e("ProxyDataTracker", "Unable to connect to proxy status service", e);
            this.setDetailedState(NetworkInfo.DetailedState.DISCONNECTED, "proxy_down", null);
            return false;
        }
        this.setDetailedState(NetworkInfo.DetailedState.CONNECTED, "enabled", null);
        return true;
    }

    private final int $$robo$$android_net_ProxyDataTracker$getDefaultGatewayAddr() {
        return this.mDefaultGatewayAddr.get();
    }

    private final String $$robo$$android_net_ProxyDataTracker$getTcpBufferSizesPropName() {
        return "net.tcp.buffersize.wifi";
    }

    private final void $$robo$$android_net_ProxyDataTracker$setDetailedState(NetworkInfo.DetailedState state, String reason, String extraInfo) {
        this.mNetworkInfo.setDetailedState(state, reason, extraInfo);
        Message msg = this.mTarget.obtainMessage(458752, this.mNetworkInfo);
        msg.sendToTarget();
    }

    private void __constructor__() {
        this.$$robo$$android_net_ProxyDataTracker$__constructor__();
    }

    public ProxyDataTracker() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_ProxyDataTracker$__constructor__(), 0, this);
    }

    public Object clone() throws CloneNotSupportedException {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_net_ProxyDataTracker$clone(), 0, this);
    }

    @Override
    public void startMonitoring(Context context, Handler handler) {
        InvokeDynamicSupport.bootstrap("startMonitoring", $$robo$$android_net_ProxyDataTracker$startMonitoring(android.content.Context android.os.Handler ), 0, this, context, handler);
    }

    @Override
    public boolean teardown() {
        return (boolean)InvokeDynamicSupport.bootstrap("teardown", $$robo$$android_net_ProxyDataTracker$teardown(), 0, this);
    }

    @Override
    public boolean reconnect() {
        return (boolean)InvokeDynamicSupport.bootstrap("reconnect", $$robo$$android_net_ProxyDataTracker$reconnect(), 0, this);
    }

    public int getDefaultGatewayAddr() {
        return (int)InvokeDynamicSupport.bootstrap("getDefaultGatewayAddr", $$robo$$android_net_ProxyDataTracker$getDefaultGatewayAddr(), 0, this);
    }

    @Override
    public String getTcpBufferSizesPropName() {
        return InvokeDynamicSupport.bootstrap("getTcpBufferSizesPropName", $$robo$$android_net_ProxyDataTracker$getTcpBufferSizesPropName(), 0, this);
    }

    private void setDetailedState(NetworkInfo.DetailedState detailedState, String string2, String string3) {
        InvokeDynamicSupport.bootstrap("setDetailedState", $$robo$$android_net_ProxyDataTracker$setDetailedState(android.net.NetworkInfo$DetailedState java.lang.String java.lang.String ), 0, this, detailedState, string2, string3);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ProxyDataTracker)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

