/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.SSLSessionCache;
import android.os.SystemProperties;
import android.util.Log;
import com.android.org.conscrypt.OpenSSLContextImpl;
import com.android.org.conscrypt.OpenSSLSocketImpl;
import com.android.org.conscrypt.SSLClientSessionCache;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.security.KeyManagementException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.SocketFactory;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SSLCertificateSocketFactory
extends SSLSocketFactory
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "SSLCertificateSocketFactory";
    private static TrustManager[] INSECURE_TRUST_MANAGER;
    private SSLSocketFactory mInsecureFactory;
    private SSLSocketFactory mSecureFactory;
    private TrustManager[] mTrustManagers;
    private KeyManager[] mKeyManagers;
    private byte[] mNpnProtocols;
    private byte[] mAlpnProtocols;
    private PrivateKey mChannelIdPrivateKey;
    private int mHandshakeTimeoutMillis;
    private SSLClientSessionCache mSessionCache;
    private boolean mSecure;

    @Deprecated
    private void $$robo$$android_net_SSLCertificateSocketFactory$__constructor__(int handshakeTimeoutMillis) {
    }

    private void $$robo$$android_net_SSLCertificateSocketFactory$__constructor__(int handshakeTimeoutMillis, SSLSessionCache cache, boolean secure) {
        this.mInsecureFactory = null;
        this.mSecureFactory = null;
        this.mTrustManagers = null;
        this.mKeyManagers = null;
        this.mNpnProtocols = null;
        this.mAlpnProtocols = null;
        this.mChannelIdPrivateKey = null;
        this.mHandshakeTimeoutMillis = handshakeTimeoutMillis;
        this.mSessionCache = cache == null ? null : cache.mSessionCache;
        this.mSecure = secure;
    }

    private static final SocketFactory $$robo$$android_net_SSLCertificateSocketFactory$getDefault(int handshakeTimeoutMillis) {
        return new SSLCertificateSocketFactory(handshakeTimeoutMillis, null, true);
    }

    private static final SSLSocketFactory $$robo$$android_net_SSLCertificateSocketFactory$getDefault(int handshakeTimeoutMillis, SSLSessionCache cache) {
        return new SSLCertificateSocketFactory(handshakeTimeoutMillis, cache, true);
    }

    private static final SSLSocketFactory $$robo$$android_net_SSLCertificateSocketFactory$getInsecure(int handshakeTimeoutMillis, SSLSessionCache cache) {
        return new SSLCertificateSocketFactory(handshakeTimeoutMillis, cache, false);
    }

    private static final org.apache.http.conn.ssl.SSLSocketFactory $$robo$$android_net_SSLCertificateSocketFactory$getHttpSocketFactory(int handshakeTimeoutMillis, SSLSessionCache cache) {
        return new org.apache.http.conn.ssl.SSLSocketFactory(new SSLCertificateSocketFactory(handshakeTimeoutMillis, cache, true));
    }

    private static final void $$robo$$android_net_SSLCertificateSocketFactory$verifyHostname(Socket socket, String hostname) throws IOException {
        if (!(socket instanceof SSLSocket)) {
            throw new IllegalArgumentException("Attempt to verify non-SSL socket");
        }
        if (!SSLCertificateSocketFactory.isSslCheckRelaxed()) {
            SSLSocket ssl = (SSLSocket)socket;
            ssl.startHandshake();
            SSLSession session = ssl.getSession();
            if (session == null) {
                throw new SSLException("Cannot verify SSL socket without session");
            }
            if (!HttpsURLConnection.getDefaultHostnameVerifier().verify(hostname, session)) {
                throw new SSLPeerUnverifiedException("Cannot verify hostname: " + hostname);
            }
        }
    }

    private final SSLSocketFactory $$robo$$android_net_SSLCertificateSocketFactory$makeSocketFactory(KeyManager[] keyManagers, TrustManager[] trustManagers) {
        try {
            OpenSSLContextImpl sslContext = new OpenSSLContextImpl();
            sslContext.engineInit(keyManagers, trustManagers, null);
            sslContext.engineGetClientSessionContext().setPersistentCache(this.mSessionCache);
            return sslContext.engineGetSocketFactory();
        }
        catch (KeyManagementException e) {
            Log.wtf("SSLCertificateSocketFactory", e);
            return (SSLSocketFactory)SSLSocketFactory.getDefault();
        }
    }

    private static final boolean $$robo$$android_net_SSLCertificateSocketFactory$isSslCheckRelaxed() {
        return "1".equals(SystemProperties.get("ro.debuggable")) && "yes".equals(SystemProperties.get("socket.relaxsslcheck"));
    }

    private final synchronized SSLSocketFactory $$robo$$android_net_SSLCertificateSocketFactory$getDelegate() {
        if (!this.mSecure || SSLCertificateSocketFactory.isSslCheckRelaxed()) {
            if (this.mInsecureFactory == null) {
                if (this.mSecure) {
                    Log.w("SSLCertificateSocketFactory", "*** BYPASSING SSL SECURITY CHECKS (socket.relaxsslcheck=yes) ***");
                } else {
                    Log.w("SSLCertificateSocketFactory", "Bypassing SSL security checks at caller's request");
                }
                this.mInsecureFactory = this.makeSocketFactory(this.mKeyManagers, INSECURE_TRUST_MANAGER);
            }
            return this.mInsecureFactory;
        }
        if (this.mSecureFactory == null) {
            this.mSecureFactory = this.makeSocketFactory(this.mKeyManagers, this.mTrustManagers);
        }
        return this.mSecureFactory;
    }

    private final void $$robo$$android_net_SSLCertificateSocketFactory$setTrustManagers(TrustManager[] trustManager) {
        this.mTrustManagers = trustManager;
        this.mSecureFactory = null;
    }

    private final void $$robo$$android_net_SSLCertificateSocketFactory$setNpnProtocols(byte[][] npnProtocols) {
        this.mNpnProtocols = SSLCertificateSocketFactory.toLengthPrefixedList(npnProtocols);
    }

    private final void $$robo$$android_net_SSLCertificateSocketFactory$setAlpnProtocols(byte[][] protocols) {
        this.mAlpnProtocols = SSLCertificateSocketFactory.toLengthPrefixedList(protocols);
    }

    private static final byte[] $$robo$$android_net_SSLCertificateSocketFactory$toLengthPrefixedList(byte[] ... items) {
        if (items.length == 0) {
            throw new IllegalArgumentException("items.length == 0");
        }
        int totalLength = 0;
        for (byte[] s : items) {
            if (s.length == 0 || s.length > 255) {
                throw new IllegalArgumentException("s.length == 0 || s.length > 255: " + s.length);
            }
            totalLength += 1 + s.length;
        }
        byte[] result = new byte[totalLength];
        int pos = 0;
        for (byte[] s : items) {
            result[pos++] = (byte)s.length;
            for (byte b : s) {
                result[pos++] = b;
            }
        }
        return result;
    }

    private final byte[] $$robo$$android_net_SSLCertificateSocketFactory$getNpnSelectedProtocol(Socket socket) {
        return SSLCertificateSocketFactory.castToOpenSSLSocket(socket).getNpnSelectedProtocol();
    }

    private final byte[] $$robo$$android_net_SSLCertificateSocketFactory$getAlpnSelectedProtocol(Socket socket) {
        return SSLCertificateSocketFactory.castToOpenSSLSocket(socket).getAlpnSelectedProtocol();
    }

    private final void $$robo$$android_net_SSLCertificateSocketFactory$setKeyManagers(KeyManager[] keyManagers) {
        this.mKeyManagers = keyManagers;
        this.mSecureFactory = null;
        this.mInsecureFactory = null;
    }

    private final void $$robo$$android_net_SSLCertificateSocketFactory$setChannelIdPrivateKey(PrivateKey privateKey) {
        this.mChannelIdPrivateKey = privateKey;
    }

    private final void $$robo$$android_net_SSLCertificateSocketFactory$setUseSessionTickets(Socket socket, boolean useSessionTickets) {
        SSLCertificateSocketFactory.castToOpenSSLSocket(socket).setUseSessionTickets(useSessionTickets);
    }

    private final void $$robo$$android_net_SSLCertificateSocketFactory$setHostname(Socket socket, String hostName) {
        SSLCertificateSocketFactory.castToOpenSSLSocket(socket).setHostname(hostName);
    }

    private final void $$robo$$android_net_SSLCertificateSocketFactory$setSoWriteTimeout(Socket socket, int writeTimeoutMilliseconds) throws SocketException {
        SSLCertificateSocketFactory.castToOpenSSLSocket(socket).setSoWriteTimeout(writeTimeoutMilliseconds);
    }

    private static final OpenSSLSocketImpl $$robo$$android_net_SSLCertificateSocketFactory$castToOpenSSLSocket(Socket socket) {
        if (!(socket instanceof OpenSSLSocketImpl)) {
            throw new IllegalArgumentException("Socket not created by this factory: " + socket);
        }
        return (OpenSSLSocketImpl)socket;
    }

    private final Socket $$robo$$android_net_SSLCertificateSocketFactory$createSocket(Socket k, String host, int port, boolean close) throws IOException {
        OpenSSLSocketImpl s = (OpenSSLSocketImpl)this.getDelegate().createSocket(k, host, port, close);
        s.setNpnProtocols(this.mNpnProtocols);
        s.setAlpnProtocols(this.mAlpnProtocols);
        s.setHandshakeTimeout(this.mHandshakeTimeoutMillis);
        s.setChannelIdPrivateKey(this.mChannelIdPrivateKey);
        if (this.mSecure) {
            SSLCertificateSocketFactory.verifyHostname(s, host);
        }
        return s;
    }

    private final Socket $$robo$$android_net_SSLCertificateSocketFactory$createSocket() throws IOException {
        OpenSSLSocketImpl s = (OpenSSLSocketImpl)this.getDelegate().createSocket();
        s.setNpnProtocols(this.mNpnProtocols);
        s.setAlpnProtocols(this.mAlpnProtocols);
        s.setHandshakeTimeout(this.mHandshakeTimeoutMillis);
        s.setChannelIdPrivateKey(this.mChannelIdPrivateKey);
        return s;
    }

    private final Socket $$robo$$android_net_SSLCertificateSocketFactory$createSocket(InetAddress addr, int port, InetAddress localAddr, int localPort) throws IOException {
        OpenSSLSocketImpl s = (OpenSSLSocketImpl)this.getDelegate().createSocket(addr, port, localAddr, localPort);
        s.setNpnProtocols(this.mNpnProtocols);
        s.setAlpnProtocols(this.mAlpnProtocols);
        s.setHandshakeTimeout(this.mHandshakeTimeoutMillis);
        s.setChannelIdPrivateKey(this.mChannelIdPrivateKey);
        return s;
    }

    private final Socket $$robo$$android_net_SSLCertificateSocketFactory$createSocket(InetAddress addr, int port) throws IOException {
        OpenSSLSocketImpl s = (OpenSSLSocketImpl)this.getDelegate().createSocket(addr, port);
        s.setNpnProtocols(this.mNpnProtocols);
        s.setAlpnProtocols(this.mAlpnProtocols);
        s.setHandshakeTimeout(this.mHandshakeTimeoutMillis);
        s.setChannelIdPrivateKey(this.mChannelIdPrivateKey);
        return s;
    }

    private final Socket $$robo$$android_net_SSLCertificateSocketFactory$createSocket(String host, int port, InetAddress localAddr, int localPort) throws IOException {
        OpenSSLSocketImpl s = (OpenSSLSocketImpl)this.getDelegate().createSocket(host, port, localAddr, localPort);
        s.setNpnProtocols(this.mNpnProtocols);
        s.setAlpnProtocols(this.mAlpnProtocols);
        s.setHandshakeTimeout(this.mHandshakeTimeoutMillis);
        s.setChannelIdPrivateKey(this.mChannelIdPrivateKey);
        if (this.mSecure) {
            SSLCertificateSocketFactory.verifyHostname(s, host);
        }
        return s;
    }

    private final Socket $$robo$$android_net_SSLCertificateSocketFactory$createSocket(String host, int port) throws IOException {
        OpenSSLSocketImpl s = (OpenSSLSocketImpl)this.getDelegate().createSocket(host, port);
        s.setNpnProtocols(this.mNpnProtocols);
        s.setAlpnProtocols(this.mAlpnProtocols);
        s.setHandshakeTimeout(this.mHandshakeTimeoutMillis);
        s.setChannelIdPrivateKey(this.mChannelIdPrivateKey);
        if (this.mSecure) {
            SSLCertificateSocketFactory.verifyHostname(s, host);
        }
        return s;
    }

    private final String[] $$robo$$android_net_SSLCertificateSocketFactory$getDefaultCipherSuites() {
        return this.getDelegate().getDefaultCipherSuites();
    }

    private final String[] $$robo$$android_net_SSLCertificateSocketFactory$getSupportedCipherSuites() {
        return this.getDelegate().getSupportedCipherSuites();
    }

    static void __staticInitializer__() {
        INSECURE_TRUST_MANAGER = new TrustManager[]{new X509TrustManager(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_net_SSLCertificateSocketFactory_1$__constructor__() {
            }

            private final X509Certificate[] $$robo$$android_net_SSLCertificateSocketFactory_1$getAcceptedIssuers() {
                return null;
            }

            private final void $$robo$$android_net_SSLCertificateSocketFactory_1$checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            private final void $$robo$$android_net_SSLCertificateSocketFactory_1$checkServerTrusted(X509Certificate[] certs, String authType) {
            }

            private void __constructor__() {
                this.$$robo$$android_net_SSLCertificateSocketFactory_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_SSLCertificateSocketFactory_1$__constructor__(), 0, this);
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return InvokeDynamicSupport.bootstrap("getAcceptedIssuers", $$robo$$android_net_SSLCertificateSocketFactory_1$getAcceptedIssuers(), 0, this);
            }

            @Override
            public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string2) {
                InvokeDynamicSupport.bootstrap("checkClientTrusted", $$robo$$android_net_SSLCertificateSocketFactory_1$checkClientTrusted(java.security.cert.X509Certificate[] java.lang.String ), 0, this, x509CertificateArray, string2);
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string2) {
                InvokeDynamicSupport.bootstrap("checkServerTrusted", $$robo$$android_net_SSLCertificateSocketFactory_1$checkServerTrusted(java.security.cert.X509Certificate[] java.lang.String ), 0, this, x509CertificateArray, string2);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }};
    }

    private void __constructor__(int n) {
        this.$$robo$$android_net_SSLCertificateSocketFactory$__constructor__(n);
    }

    public SSLCertificateSocketFactory(int n) {
        this(n, null, true);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_SSLCertificateSocketFactory$__constructor__(int ), 0, this, n);
    }

    private void __constructor__(int n, SSLSessionCache sSLSessionCache, boolean bl) {
        this.$$robo$$android_net_SSLCertificateSocketFactory$__constructor__(n, sSLSessionCache, bl);
    }

    private SSLCertificateSocketFactory(int n, SSLSessionCache sSLSessionCache, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_SSLCertificateSocketFactory$__constructor__(int android.net.SSLSessionCache boolean ), 0, this, n, sSLSessionCache, bl);
    }

    public static SocketFactory getDefault(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getDefault", $$robo$$android_net_SSLCertificateSocketFactory$getDefault(int ), 0, (int)n);
    }

    public static SSLSocketFactory getDefault(int n, SSLSessionCache sSLSessionCache) {
        return InvokeDynamicSupport.bootstrapStatic("getDefault", $$robo$$android_net_SSLCertificateSocketFactory$getDefault(int android.net.SSLSessionCache ), 0, (int)n, (SSLSessionCache)sSLSessionCache);
    }

    public static SSLSocketFactory getInsecure(int n, SSLSessionCache sSLSessionCache) {
        return InvokeDynamicSupport.bootstrapStatic("getInsecure", $$robo$$android_net_SSLCertificateSocketFactory$getInsecure(int android.net.SSLSessionCache ), 0, (int)n, (SSLSessionCache)sSLSessionCache);
    }

    public static org.apache.http.conn.ssl.SSLSocketFactory getHttpSocketFactory(int n, SSLSessionCache sSLSessionCache) {
        return InvokeDynamicSupport.bootstrapStatic("getHttpSocketFactory", $$robo$$android_net_SSLCertificateSocketFactory$getHttpSocketFactory(int android.net.SSLSessionCache ), 0, (int)n, (SSLSessionCache)sSLSessionCache);
    }

    public static void verifyHostname(Socket socket, String string2) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("verifyHostname", $$robo$$android_net_SSLCertificateSocketFactory$verifyHostname(java.net.Socket java.lang.String ), 0, (Socket)socket, (String)string2);
    }

    private SSLSocketFactory makeSocketFactory(KeyManager[] keyManagerArray, TrustManager[] trustManagerArray) {
        return InvokeDynamicSupport.bootstrap("makeSocketFactory", $$robo$$android_net_SSLCertificateSocketFactory$makeSocketFactory(javax.net.ssl.KeyManager[] javax.net.ssl.TrustManager[] ), 0, this, keyManagerArray, trustManagerArray);
    }

    private static boolean isSslCheckRelaxed() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isSslCheckRelaxed", $$robo$$android_net_SSLCertificateSocketFactory$isSslCheckRelaxed(), 0);
    }

    private synchronized SSLSocketFactory getDelegate() {
        return InvokeDynamicSupport.bootstrap("getDelegate", $$robo$$android_net_SSLCertificateSocketFactory$getDelegate(), 0, this);
    }

    public void setTrustManagers(TrustManager[] trustManagerArray) {
        InvokeDynamicSupport.bootstrap("setTrustManagers", $$robo$$android_net_SSLCertificateSocketFactory$setTrustManagers(javax.net.ssl.TrustManager[] ), 0, this, trustManagerArray);
    }

    public void setNpnProtocols(byte[][] byArray) {
        InvokeDynamicSupport.bootstrap("setNpnProtocols", $$robo$$android_net_SSLCertificateSocketFactory$setNpnProtocols(byte[][] ), 0, this, byArray);
    }

    public void setAlpnProtocols(byte[][] byArray) {
        InvokeDynamicSupport.bootstrap("setAlpnProtocols", $$robo$$android_net_SSLCertificateSocketFactory$setAlpnProtocols(byte[][] ), 0, this, byArray);
    }

    static byte[] toLengthPrefixedList(byte[] ... byArray) {
        return InvokeDynamicSupport.bootstrapStatic("toLengthPrefixedList", $$robo$$android_net_SSLCertificateSocketFactory$toLengthPrefixedList(byte[][] ), 0, (byte[][])byArray);
    }

    public byte[] getNpnSelectedProtocol(Socket socket) {
        return InvokeDynamicSupport.bootstrap("getNpnSelectedProtocol", $$robo$$android_net_SSLCertificateSocketFactory$getNpnSelectedProtocol(java.net.Socket ), 0, this, socket);
    }

    public byte[] getAlpnSelectedProtocol(Socket socket) {
        return InvokeDynamicSupport.bootstrap("getAlpnSelectedProtocol", $$robo$$android_net_SSLCertificateSocketFactory$getAlpnSelectedProtocol(java.net.Socket ), 0, this, socket);
    }

    public void setKeyManagers(KeyManager[] keyManagerArray) {
        InvokeDynamicSupport.bootstrap("setKeyManagers", $$robo$$android_net_SSLCertificateSocketFactory$setKeyManagers(javax.net.ssl.KeyManager[] ), 0, this, keyManagerArray);
    }

    public void setChannelIdPrivateKey(PrivateKey privateKey) {
        InvokeDynamicSupport.bootstrap("setChannelIdPrivateKey", $$robo$$android_net_SSLCertificateSocketFactory$setChannelIdPrivateKey(java.security.PrivateKey ), 0, this, privateKey);
    }

    public void setUseSessionTickets(Socket socket, boolean bl) {
        InvokeDynamicSupport.bootstrap("setUseSessionTickets", $$robo$$android_net_SSLCertificateSocketFactory$setUseSessionTickets(java.net.Socket boolean ), 0, this, socket, bl);
    }

    public void setHostname(Socket socket, String string2) {
        InvokeDynamicSupport.bootstrap("setHostname", $$robo$$android_net_SSLCertificateSocketFactory$setHostname(java.net.Socket java.lang.String ), 0, this, socket, string2);
    }

    public void setSoWriteTimeout(Socket socket, int n) throws SocketException {
        InvokeDynamicSupport.bootstrap("setSoWriteTimeout", $$robo$$android_net_SSLCertificateSocketFactory$setSoWriteTimeout(java.net.Socket int ), 0, this, socket, n);
    }

    private static OpenSSLSocketImpl castToOpenSSLSocket(Socket socket) {
        return InvokeDynamicSupport.bootstrapStatic("castToOpenSSLSocket", $$robo$$android_net_SSLCertificateSocketFactory$castToOpenSSLSocket(java.net.Socket ), 0, (Socket)socket);
    }

    @Override
    public Socket createSocket(Socket socket, String string2, int n, boolean bl) throws IOException {
        return InvokeDynamicSupport.bootstrap("createSocket", $$robo$$android_net_SSLCertificateSocketFactory$createSocket(java.net.Socket java.lang.String int boolean ), 0, this, socket, string2, n, bl);
    }

    @Override
    public Socket createSocket() throws IOException {
        return InvokeDynamicSupport.bootstrap("createSocket", $$robo$$android_net_SSLCertificateSocketFactory$createSocket(), 0, this);
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        return InvokeDynamicSupport.bootstrap("createSocket", $$robo$$android_net_SSLCertificateSocketFactory$createSocket(java.net.InetAddress int java.net.InetAddress int ), 0, this, inetAddress, n, inetAddress2, n2);
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int n) throws IOException {
        return InvokeDynamicSupport.bootstrap("createSocket", $$robo$$android_net_SSLCertificateSocketFactory$createSocket(java.net.InetAddress int ), 0, this, inetAddress, n);
    }

    @Override
    public Socket createSocket(String string2, int n, InetAddress inetAddress, int n2) throws IOException {
        return InvokeDynamicSupport.bootstrap("createSocket", $$robo$$android_net_SSLCertificateSocketFactory$createSocket(java.lang.String int java.net.InetAddress int ), 0, this, string2, n, inetAddress, n2);
    }

    @Override
    public Socket createSocket(String string2, int n) throws IOException {
        return InvokeDynamicSupport.bootstrap("createSocket", $$robo$$android_net_SSLCertificateSocketFactory$createSocket(java.lang.String int ), 0, this, string2, n);
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return InvokeDynamicSupport.bootstrap("getDefaultCipherSuites", $$robo$$android_net_SSLCertificateSocketFactory$getDefaultCipherSuites(), 0, this);
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return InvokeDynamicSupport.bootstrap("getSupportedCipherSuites", $$robo$$android_net_SSLCertificateSocketFactory$getSupportedCipherSuites(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(SSLCertificateSocketFactory.class);
    }

    public /* synthetic */ SSLCertificateSocketFactory() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SSLCertificateSocketFactory)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

