/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.LinkQualityInfo;
import android.os.SystemClock;
import android.util.Slog;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SamplingDataTracker
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static boolean DBG = false;
    private static String TAG = "SamplingDataTracker";
    private SamplingSnapshot mBeginningSample;
    private SamplingSnapshot mEndingSample;
    private SamplingSnapshot mLastSample;
    public Object mSamplingDataLock;
    private int MINIMUM_SAMPLING_INTERVAL = 15000;
    private int MINIMUM_SAMPLED_PACKETS = 30;

    private void $$robo$$android_net_SamplingDataTracker$__constructor__() {
        this.mSamplingDataLock = new Object();
        this.MINIMUM_SAMPLING_INTERVAL = 15000;
        this.MINIMUM_SAMPLED_PACKETS = 30;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$android_net_SamplingDataTracker$getSamplingSnapshots(Map<String, SamplingSnapshot> mapIfaceToSample) {
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader("/proc/net/dev"));
            reader.readLine();
            reader.readLine();
            while ((line = reader.readLine()) != null) {
                String currentIface;
                String[] tokens = (line = line.trim()).split("[ ]+");
                if (tokens.length < 17 || !mapIfaceToSample.containsKey(currentIface = tokens[0].split(":")[0])) continue;
                try {
                    SamplingSnapshot ss = new SamplingSnapshot();
                    ss.mTxByteCount = Long.parseLong(tokens[1]);
                    ss.mTxPacketCount = Long.parseLong(tokens[2]);
                    ss.mTxPacketErrorCount = Long.parseLong(tokens[3]);
                    ss.mRxByteCount = Long.parseLong(tokens[9]);
                    ss.mRxPacketCount = Long.parseLong(tokens[10]);
                    ss.mRxPacketErrorCount = Long.parseLong(tokens[11]);
                    ss.mTimestamp = SystemClock.elapsedRealtime();
                    mapIfaceToSample.put(currentIface, ss);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        catch (FileNotFoundException e) {
            Slog.e("SamplingDataTracker", "could not find /proc/net/dev");
        }
        catch (IOException e) {
            Slog.e("SamplingDataTracker", "could not read /proc/net/dev");
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                Slog.e("SamplingDataTracker", "could not close /proc/net/dev");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_net_SamplingDataTracker$startSampling(SamplingSnapshot s) {
        Object object = this.mSamplingDataLock;
        synchronized (object) {
            this.mLastSample = s;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_net_SamplingDataTracker$stopSampling(SamplingSnapshot s) {
        Object object = this.mSamplingDataLock;
        synchronized (object) {
            if (this.mLastSample != null && s.mTimestamp - this.mLastSample.mTimestamp > 15000L && this.getSampledPacketCount(this.mLastSample, s) > 30L) {
                this.mBeginningSample = this.mLastSample;
                this.mEndingSample = s;
                this.mLastSample = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_net_SamplingDataTracker$resetSamplingData() {
        Object object = this.mSamplingDataLock;
        synchronized (object) {
            this.mLastSample = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long $$robo$$android_net_SamplingDataTracker$getSampledTxByteCount() {
        Object object = this.mSamplingDataLock;
        synchronized (object) {
            if (this.mBeginningSample != null && this.mEndingSample != null) {
                return this.mEndingSample.mTxByteCount - this.mBeginningSample.mTxByteCount;
            }
            return Long.MAX_VALUE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long $$robo$$android_net_SamplingDataTracker$getSampledTxPacketCount() {
        Object object = this.mSamplingDataLock;
        synchronized (object) {
            if (this.mBeginningSample != null && this.mEndingSample != null) {
                return this.mEndingSample.mTxPacketCount - this.mBeginningSample.mTxPacketCount;
            }
            return Long.MAX_VALUE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long $$robo$$android_net_SamplingDataTracker$getSampledTxPacketErrorCount() {
        Object object = this.mSamplingDataLock;
        synchronized (object) {
            if (this.mBeginningSample != null && this.mEndingSample != null) {
                return this.mEndingSample.mTxPacketErrorCount - this.mBeginningSample.mTxPacketErrorCount;
            }
            return Long.MAX_VALUE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long $$robo$$android_net_SamplingDataTracker$getSampledRxByteCount() {
        Object object = this.mSamplingDataLock;
        synchronized (object) {
            if (this.mBeginningSample != null && this.mEndingSample != null) {
                return this.mEndingSample.mRxByteCount - this.mBeginningSample.mRxByteCount;
            }
            return Long.MAX_VALUE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long $$robo$$android_net_SamplingDataTracker$getSampledRxPacketCount() {
        Object object = this.mSamplingDataLock;
        synchronized (object) {
            if (this.mBeginningSample != null && this.mEndingSample != null) {
                return this.mEndingSample.mRxPacketCount - this.mBeginningSample.mRxPacketCount;
            }
            return Long.MAX_VALUE;
        }
    }

    private final long $$robo$$android_net_SamplingDataTracker$getSampledPacketCount() {
        return this.getSampledPacketCount(this.mBeginningSample, this.mEndingSample);
    }

    private final long $$robo$$android_net_SamplingDataTracker$getSampledPacketCount(SamplingSnapshot begin, SamplingSnapshot end) {
        if (begin != null && end != null) {
            long rxPacketCount = end.mRxPacketCount - begin.mRxPacketCount;
            long txPacketCount = end.mTxPacketCount - begin.mTxPacketCount;
            return rxPacketCount + txPacketCount;
        }
        return Long.MAX_VALUE;
    }

    private final long $$robo$$android_net_SamplingDataTracker$getSampledPacketErrorCount() {
        if (this.mBeginningSample != null && this.mEndingSample != null) {
            long rxPacketErrorCount = this.getSampledRxPacketErrorCount();
            long txPacketErrorCount = this.getSampledTxPacketErrorCount();
            return rxPacketErrorCount + txPacketErrorCount;
        }
        return Long.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long $$robo$$android_net_SamplingDataTracker$getSampledRxPacketErrorCount() {
        Object object = this.mSamplingDataLock;
        synchronized (object) {
            if (this.mBeginningSample != null && this.mEndingSample != null) {
                return this.mEndingSample.mRxPacketErrorCount - this.mBeginningSample.mRxPacketErrorCount;
            }
            return Long.MAX_VALUE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long $$robo$$android_net_SamplingDataTracker$getSampleTimestamp() {
        Object object = this.mSamplingDataLock;
        synchronized (object) {
            if (this.mEndingSample != null) {
                return this.mEndingSample.mTimestamp;
            }
            return Long.MAX_VALUE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_net_SamplingDataTracker$getSampleDuration() {
        Object object = this.mSamplingDataLock;
        synchronized (object) {
            if (this.mBeginningSample != null && this.mEndingSample != null) {
                return (int)(this.mEndingSample.mTimestamp - this.mBeginningSample.mTimestamp);
            }
            return Integer.MAX_VALUE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_net_SamplingDataTracker$setCommonLinkQualityInfoFields(LinkQualityInfo li) {
        Object object = this.mSamplingDataLock;
        synchronized (object) {
            li.setLastDataSampleTime(this.getSampleTimestamp());
            li.setDataSampleDuration(this.getSampleDuration());
            li.setPacketCount(this.getSampledPacketCount());
            li.setPacketErrorCount(this.getSampledPacketErrorCount());
        }
    }

    private void __constructor__() {
        this.$$robo$$android_net_SamplingDataTracker$__constructor__();
    }

    public SamplingDataTracker() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_SamplingDataTracker$__constructor__(), 0, this);
    }

    public static void getSamplingSnapshots(Map<String, SamplingSnapshot> map) {
        InvokeDynamicSupport.bootstrapStatic("getSamplingSnapshots", $$robo$$android_net_SamplingDataTracker$getSamplingSnapshots(java.util.Map<java.lang.String, android.net.SamplingDataTracker$SamplingSnapshot> ), 0, map);
    }

    public void startSampling(SamplingSnapshot samplingSnapshot) {
        InvokeDynamicSupport.bootstrap("startSampling", $$robo$$android_net_SamplingDataTracker$startSampling(android.net.SamplingDataTracker$SamplingSnapshot ), 0, this, samplingSnapshot);
    }

    public void stopSampling(SamplingSnapshot samplingSnapshot) {
        InvokeDynamicSupport.bootstrap("stopSampling", $$robo$$android_net_SamplingDataTracker$stopSampling(android.net.SamplingDataTracker$SamplingSnapshot ), 0, this, samplingSnapshot);
    }

    public void resetSamplingData() {
        InvokeDynamicSupport.bootstrap("resetSamplingData", $$robo$$android_net_SamplingDataTracker$resetSamplingData(), 0, this);
    }

    public long getSampledTxByteCount() {
        return (long)InvokeDynamicSupport.bootstrap("getSampledTxByteCount", $$robo$$android_net_SamplingDataTracker$getSampledTxByteCount(), 0, this);
    }

    public long getSampledTxPacketCount() {
        return (long)InvokeDynamicSupport.bootstrap("getSampledTxPacketCount", $$robo$$android_net_SamplingDataTracker$getSampledTxPacketCount(), 0, this);
    }

    public long getSampledTxPacketErrorCount() {
        return (long)InvokeDynamicSupport.bootstrap("getSampledTxPacketErrorCount", $$robo$$android_net_SamplingDataTracker$getSampledTxPacketErrorCount(), 0, this);
    }

    public long getSampledRxByteCount() {
        return (long)InvokeDynamicSupport.bootstrap("getSampledRxByteCount", $$robo$$android_net_SamplingDataTracker$getSampledRxByteCount(), 0, this);
    }

    public long getSampledRxPacketCount() {
        return (long)InvokeDynamicSupport.bootstrap("getSampledRxPacketCount", $$robo$$android_net_SamplingDataTracker$getSampledRxPacketCount(), 0, this);
    }

    public long getSampledPacketCount() {
        return (long)InvokeDynamicSupport.bootstrap("getSampledPacketCount", $$robo$$android_net_SamplingDataTracker$getSampledPacketCount(), 0, this);
    }

    public long getSampledPacketCount(SamplingSnapshot samplingSnapshot, SamplingSnapshot samplingSnapshot2) {
        return (long)InvokeDynamicSupport.bootstrap("getSampledPacketCount", $$robo$$android_net_SamplingDataTracker$getSampledPacketCount(android.net.SamplingDataTracker$SamplingSnapshot android.net.SamplingDataTracker$SamplingSnapshot ), 0, this, samplingSnapshot, samplingSnapshot2);
    }

    public long getSampledPacketErrorCount() {
        return (long)InvokeDynamicSupport.bootstrap("getSampledPacketErrorCount", $$robo$$android_net_SamplingDataTracker$getSampledPacketErrorCount(), 0, this);
    }

    public long getSampledRxPacketErrorCount() {
        return (long)InvokeDynamicSupport.bootstrap("getSampledRxPacketErrorCount", $$robo$$android_net_SamplingDataTracker$getSampledRxPacketErrorCount(), 0, this);
    }

    public long getSampleTimestamp() {
        return (long)InvokeDynamicSupport.bootstrap("getSampleTimestamp", $$robo$$android_net_SamplingDataTracker$getSampleTimestamp(), 0, this);
    }

    public int getSampleDuration() {
        return (int)InvokeDynamicSupport.bootstrap("getSampleDuration", $$robo$$android_net_SamplingDataTracker$getSampleDuration(), 0, this);
    }

    public void setCommonLinkQualityInfoFields(LinkQualityInfo linkQualityInfo) {
        InvokeDynamicSupport.bootstrap("setCommonLinkQualityInfoFields", $$robo$$android_net_SamplingDataTracker$setCommonLinkQualityInfoFields(android.net.LinkQualityInfo ), 0, this, linkQualityInfo);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SamplingDataTracker)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class SamplingSnapshot
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public long mTxByteCount;
        public long mRxByteCount;
        public long mTxPacketCount;
        public long mRxPacketCount;
        public long mTxPacketErrorCount;
        public long mRxPacketErrorCount;
        public long mTimestamp;

        private void $$robo$$android_net_SamplingDataTracker_SamplingSnapshot$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_net_SamplingDataTracker_SamplingSnapshot$__constructor__();
        }

        public SamplingSnapshot() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_SamplingDataTracker_SamplingSnapshot$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SamplingSnapshot)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

