/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class UrlQuerySanitizer
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private HashMap<String, ValueSanitizer> mSanitizers;
    private HashMap<String, String> mEntries;
    private ArrayList<ParameterValuePair> mEntriesList;
    private boolean mAllowUnregisteredParamaters;
    private boolean mPreferFirstRepeatedParameter;
    private ValueSanitizer mUnregisteredParameterValueSanitizer;
    private static ValueSanitizer sAllIllegal;
    private static ValueSanitizer sAllButNulLegal;
    private static ValueSanitizer sAllButWhitespaceLegal;
    private static ValueSanitizer sURLLegal;
    private static ValueSanitizer sUrlAndSpaceLegal;
    private static ValueSanitizer sAmpLegal;
    private static ValueSanitizer sAmpAndSpaceLegal;
    private static ValueSanitizer sSpaceLegal;
    private static ValueSanitizer sAllButNulAndAngleBracketsLegal;

    private final ValueSanitizer $$robo$$android_net_UrlQuerySanitizer$getUnregisteredParameterValueSanitizer() {
        return this.mUnregisteredParameterValueSanitizer;
    }

    private final void $$robo$$android_net_UrlQuerySanitizer$setUnregisteredParameterValueSanitizer(ValueSanitizer sanitizer) {
        this.mUnregisteredParameterValueSanitizer = sanitizer;
    }

    private static final ValueSanitizer $$robo$$android_net_UrlQuerySanitizer$getAllIllegal() {
        return sAllIllegal;
    }

    private static final ValueSanitizer $$robo$$android_net_UrlQuerySanitizer$getAllButNulLegal() {
        return sAllButNulLegal;
    }

    private static final ValueSanitizer $$robo$$android_net_UrlQuerySanitizer$getAllButWhitespaceLegal() {
        return sAllButWhitespaceLegal;
    }

    private static final ValueSanitizer $$robo$$android_net_UrlQuerySanitizer$getUrlLegal() {
        return sURLLegal;
    }

    private static final ValueSanitizer $$robo$$android_net_UrlQuerySanitizer$getUrlAndSpaceLegal() {
        return sUrlAndSpaceLegal;
    }

    private static final ValueSanitizer $$robo$$android_net_UrlQuerySanitizer$getAmpLegal() {
        return sAmpLegal;
    }

    private static final ValueSanitizer $$robo$$android_net_UrlQuerySanitizer$getAmpAndSpaceLegal() {
        return sAmpAndSpaceLegal;
    }

    private static final ValueSanitizer $$robo$$android_net_UrlQuerySanitizer$getSpaceLegal() {
        return sSpaceLegal;
    }

    private static final ValueSanitizer $$robo$$android_net_UrlQuerySanitizer$getAllButNulAndAngleBracketsLegal() {
        return sAllButNulAndAngleBracketsLegal;
    }

    private void $$robo$$android_net_UrlQuerySanitizer$__constructor__() {
        this.mSanitizers = new HashMap();
        this.mEntries = new HashMap();
        this.mEntriesList = new ArrayList();
        this.mUnregisteredParameterValueSanitizer = UrlQuerySanitizer.getAllIllegal();
    }

    private void $$robo$$android_net_UrlQuerySanitizer$__constructor__(String url) {
        this.mSanitizers = new HashMap();
        this.mEntries = new HashMap();
        this.mEntriesList = new ArrayList();
        this.mUnregisteredParameterValueSanitizer = UrlQuerySanitizer.getAllIllegal();
        this.setAllowUnregisteredParamaters(true);
        this.parseUrl(url);
    }

    private final void $$robo$$android_net_UrlQuerySanitizer$parseUrl(String url) {
        int queryIndex = url.indexOf(63);
        String query = queryIndex >= 0 ? url.substring(queryIndex + 1) : "";
        this.parseQuery(query);
    }

    private final void $$robo$$android_net_UrlQuerySanitizer$parseQuery(String query) {
        this.clear();
        StringTokenizer tokenizer = new StringTokenizer(query, "&");
        while (tokenizer.hasMoreElements()) {
            String attributeValuePair = tokenizer.nextToken();
            if (attributeValuePair.length() <= 0) continue;
            int assignmentIndex = attributeValuePair.indexOf(61);
            if (assignmentIndex < 0) {
                this.parseEntry(attributeValuePair, "");
                continue;
            }
            this.parseEntry(attributeValuePair.substring(0, assignmentIndex), attributeValuePair.substring(assignmentIndex + 1));
        }
    }

    private final Set<String> $$robo$$android_net_UrlQuerySanitizer$getParameterSet() {
        return this.mEntries.keySet();
    }

    private final List<ParameterValuePair> $$robo$$android_net_UrlQuerySanitizer$getParameterList() {
        return this.mEntriesList;
    }

    private final boolean $$robo$$android_net_UrlQuerySanitizer$hasParameter(String parameter) {
        return this.mEntries.containsKey(parameter);
    }

    private final String $$robo$$android_net_UrlQuerySanitizer$getValue(String parameter) {
        return this.mEntries.get(parameter);
    }

    private final void $$robo$$android_net_UrlQuerySanitizer$registerParameter(String parameter, ValueSanitizer valueSanitizer) {
        if (valueSanitizer == null) {
            this.mSanitizers.remove(parameter);
        }
        this.mSanitizers.put(parameter, valueSanitizer);
    }

    private final void $$robo$$android_net_UrlQuerySanitizer$registerParameters(String[] parameters, ValueSanitizer valueSanitizer) {
        int length = parameters.length;
        for (int i = 0; i < length; ++i) {
            this.mSanitizers.put(parameters[i], valueSanitizer);
        }
    }

    private final void $$robo$$android_net_UrlQuerySanitizer$setAllowUnregisteredParamaters(boolean allowUnregisteredParamaters) {
        this.mAllowUnregisteredParamaters = allowUnregisteredParamaters;
    }

    private final boolean $$robo$$android_net_UrlQuerySanitizer$getAllowUnregisteredParamaters() {
        return this.mAllowUnregisteredParamaters;
    }

    private final void $$robo$$android_net_UrlQuerySanitizer$setPreferFirstRepeatedParameter(boolean preferFirstRepeatedParameter) {
        this.mPreferFirstRepeatedParameter = preferFirstRepeatedParameter;
    }

    private final boolean $$robo$$android_net_UrlQuerySanitizer$getPreferFirstRepeatedParameter() {
        return this.mPreferFirstRepeatedParameter;
    }

    private final void $$robo$$android_net_UrlQuerySanitizer$parseEntry(String parameter, String value) {
        String unescapedParameter = this.unescape(parameter);
        ValueSanitizer valueSanitizer = this.getEffectiveValueSanitizer(unescapedParameter);
        if (valueSanitizer == null) {
            return;
        }
        String unescapedValue = this.unescape(value);
        String sanitizedValue = valueSanitizer.sanitize(unescapedValue);
        this.addSanitizedEntry(unescapedParameter, sanitizedValue);
    }

    private final void $$robo$$android_net_UrlQuerySanitizer$addSanitizedEntry(String parameter, String value) {
        this.mEntriesList.add(new ParameterValuePair(this, parameter, value));
        if (this.mPreferFirstRepeatedParameter && this.mEntries.containsKey(parameter)) {
            return;
        }
        this.mEntries.put(parameter, value);
    }

    private final ValueSanitizer $$robo$$android_net_UrlQuerySanitizer$getValueSanitizer(String parameter) {
        return this.mSanitizers.get(parameter);
    }

    private final ValueSanitizer $$robo$$android_net_UrlQuerySanitizer$getEffectiveValueSanitizer(String parameter) {
        ValueSanitizer sanitizer = this.getValueSanitizer(parameter);
        if (sanitizer == null && this.mAllowUnregisteredParamaters) {
            sanitizer = this.getUnregisteredParameterValueSanitizer();
        }
        return sanitizer;
    }

    private final String $$robo$$android_net_UrlQuerySanitizer$unescape(String string2) {
        int firstEscape = string2.indexOf(37);
        if (firstEscape < 0 && (firstEscape = string2.indexOf(43)) < 0) {
            return string2;
        }
        int length = string2.length();
        StringBuilder stringBuilder = new StringBuilder(length);
        stringBuilder.append(string2.substring(0, firstEscape));
        for (int i = firstEscape; i < length; ++i) {
            char c = string2.charAt(i);
            if (c == '+') {
                c = ' ';
            } else if (c == '%' && i + 2 < length) {
                char c1 = string2.charAt(i + 1);
                char c2 = string2.charAt(i + 2);
                if (this.isHexDigit(c1) && this.isHexDigit(c2)) {
                    c = (char)(this.decodeHexDigit(c1) * 16 + this.decodeHexDigit(c2));
                    i += 2;
                }
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    private final boolean $$robo$$android_net_UrlQuerySanitizer$isHexDigit(char c) {
        return this.decodeHexDigit(c) >= 0;
    }

    private final int $$robo$$android_net_UrlQuerySanitizer$decodeHexDigit(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        return -1;
    }

    private final void $$robo$$android_net_UrlQuerySanitizer$clear() {
        this.mEntries.clear();
        this.mEntriesList.clear();
    }

    static void __staticInitializer__() {
        sAllIllegal = new IllegalCharacterValueSanitizer(0);
        sAllButNulLegal = new IllegalCharacterValueSanitizer(1535);
        sAllButWhitespaceLegal = new IllegalCharacterValueSanitizer(1532);
        sURLLegal = new IllegalCharacterValueSanitizer(404);
        sUrlAndSpaceLegal = new IllegalCharacterValueSanitizer(405);
        sAmpLegal = new IllegalCharacterValueSanitizer(128);
        sAmpAndSpaceLegal = new IllegalCharacterValueSanitizer(129);
        sSpaceLegal = new IllegalCharacterValueSanitizer(1);
        sAllButNulAndAngleBracketsLegal = new IllegalCharacterValueSanitizer(1439);
    }

    public ValueSanitizer getUnregisteredParameterValueSanitizer() {
        return InvokeDynamicSupport.bootstrap("getUnregisteredParameterValueSanitizer", $$robo$$android_net_UrlQuerySanitizer$getUnregisteredParameterValueSanitizer(), 0, this);
    }

    public void setUnregisteredParameterValueSanitizer(ValueSanitizer valueSanitizer) {
        InvokeDynamicSupport.bootstrap("setUnregisteredParameterValueSanitizer", $$robo$$android_net_UrlQuerySanitizer$setUnregisteredParameterValueSanitizer(android.net.UrlQuerySanitizer$ValueSanitizer ), 0, this, valueSanitizer);
    }

    public static ValueSanitizer getAllIllegal() {
        return InvokeDynamicSupport.bootstrapStatic("getAllIllegal", $$robo$$android_net_UrlQuerySanitizer$getAllIllegal(), 0);
    }

    public static ValueSanitizer getAllButNulLegal() {
        return InvokeDynamicSupport.bootstrapStatic("getAllButNulLegal", $$robo$$android_net_UrlQuerySanitizer$getAllButNulLegal(), 0);
    }

    public static ValueSanitizer getAllButWhitespaceLegal() {
        return InvokeDynamicSupport.bootstrapStatic("getAllButWhitespaceLegal", $$robo$$android_net_UrlQuerySanitizer$getAllButWhitespaceLegal(), 0);
    }

    public static ValueSanitizer getUrlLegal() {
        return InvokeDynamicSupport.bootstrapStatic("getUrlLegal", $$robo$$android_net_UrlQuerySanitizer$getUrlLegal(), 0);
    }

    public static ValueSanitizer getUrlAndSpaceLegal() {
        return InvokeDynamicSupport.bootstrapStatic("getUrlAndSpaceLegal", $$robo$$android_net_UrlQuerySanitizer$getUrlAndSpaceLegal(), 0);
    }

    public static ValueSanitizer getAmpLegal() {
        return InvokeDynamicSupport.bootstrapStatic("getAmpLegal", $$robo$$android_net_UrlQuerySanitizer$getAmpLegal(), 0);
    }

    public static ValueSanitizer getAmpAndSpaceLegal() {
        return InvokeDynamicSupport.bootstrapStatic("getAmpAndSpaceLegal", $$robo$$android_net_UrlQuerySanitizer$getAmpAndSpaceLegal(), 0);
    }

    public static ValueSanitizer getSpaceLegal() {
        return InvokeDynamicSupport.bootstrapStatic("getSpaceLegal", $$robo$$android_net_UrlQuerySanitizer$getSpaceLegal(), 0);
    }

    public static ValueSanitizer getAllButNulAndAngleBracketsLegal() {
        return InvokeDynamicSupport.bootstrapStatic("getAllButNulAndAngleBracketsLegal", $$robo$$android_net_UrlQuerySanitizer$getAllButNulAndAngleBracketsLegal(), 0);
    }

    private void __constructor__() {
        this.$$robo$$android_net_UrlQuerySanitizer$__constructor__();
    }

    public UrlQuerySanitizer() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_UrlQuerySanitizer$__constructor__(), 0, this);
    }

    private void __constructor__(String string2) {
        this.$$robo$$android_net_UrlQuerySanitizer$__constructor__(string2);
    }

    public UrlQuerySanitizer(String string2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_UrlQuerySanitizer$__constructor__(java.lang.String ), 0, this, string2);
    }

    public void parseUrl(String string2) {
        InvokeDynamicSupport.bootstrap("parseUrl", $$robo$$android_net_UrlQuerySanitizer$parseUrl(java.lang.String ), 0, this, string2);
    }

    public void parseQuery(String string2) {
        InvokeDynamicSupport.bootstrap("parseQuery", $$robo$$android_net_UrlQuerySanitizer$parseQuery(java.lang.String ), 0, this, string2);
    }

    public Set<String> getParameterSet() {
        return InvokeDynamicSupport.bootstrap("getParameterSet", $$robo$$android_net_UrlQuerySanitizer$getParameterSet(), 0, this);
    }

    public List<ParameterValuePair> getParameterList() {
        return InvokeDynamicSupport.bootstrap("getParameterList", $$robo$$android_net_UrlQuerySanitizer$getParameterList(), 0, this);
    }

    public boolean hasParameter(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasParameter", $$robo$$android_net_UrlQuerySanitizer$hasParameter(java.lang.String ), 0, this, string2);
    }

    public String getValue(String string2) {
        return InvokeDynamicSupport.bootstrap("getValue", $$robo$$android_net_UrlQuerySanitizer$getValue(java.lang.String ), 0, this, string2);
    }

    public void registerParameter(String string2, ValueSanitizer valueSanitizer) {
        InvokeDynamicSupport.bootstrap("registerParameter", $$robo$$android_net_UrlQuerySanitizer$registerParameter(java.lang.String android.net.UrlQuerySanitizer$ValueSanitizer ), 0, this, string2, valueSanitizer);
    }

    public void registerParameters(String[] stringArray, ValueSanitizer valueSanitizer) {
        InvokeDynamicSupport.bootstrap("registerParameters", $$robo$$android_net_UrlQuerySanitizer$registerParameters(java.lang.String[] android.net.UrlQuerySanitizer$ValueSanitizer ), 0, this, stringArray, valueSanitizer);
    }

    public void setAllowUnregisteredParamaters(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAllowUnregisteredParamaters", $$robo$$android_net_UrlQuerySanitizer$setAllowUnregisteredParamaters(boolean ), 0, this, bl);
    }

    public boolean getAllowUnregisteredParamaters() {
        return (boolean)InvokeDynamicSupport.bootstrap("getAllowUnregisteredParamaters", $$robo$$android_net_UrlQuerySanitizer$getAllowUnregisteredParamaters(), 0, this);
    }

    public void setPreferFirstRepeatedParameter(boolean bl) {
        InvokeDynamicSupport.bootstrap("setPreferFirstRepeatedParameter", $$robo$$android_net_UrlQuerySanitizer$setPreferFirstRepeatedParameter(boolean ), 0, this, bl);
    }

    public boolean getPreferFirstRepeatedParameter() {
        return (boolean)InvokeDynamicSupport.bootstrap("getPreferFirstRepeatedParameter", $$robo$$android_net_UrlQuerySanitizer$getPreferFirstRepeatedParameter(), 0, this);
    }

    protected void parseEntry(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("parseEntry", $$robo$$android_net_UrlQuerySanitizer$parseEntry(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    protected void addSanitizedEntry(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("addSanitizedEntry", $$robo$$android_net_UrlQuerySanitizer$addSanitizedEntry(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public ValueSanitizer getValueSanitizer(String string2) {
        return InvokeDynamicSupport.bootstrap("getValueSanitizer", $$robo$$android_net_UrlQuerySanitizer$getValueSanitizer(java.lang.String ), 0, this, string2);
    }

    public ValueSanitizer getEffectiveValueSanitizer(String string2) {
        return InvokeDynamicSupport.bootstrap("getEffectiveValueSanitizer", $$robo$$android_net_UrlQuerySanitizer$getEffectiveValueSanitizer(java.lang.String ), 0, this, string2);
    }

    public String unescape(String string2) {
        return InvokeDynamicSupport.bootstrap("unescape", $$robo$$android_net_UrlQuerySanitizer$unescape(java.lang.String ), 0, this, string2);
    }

    protected boolean isHexDigit(char c) {
        return (boolean)InvokeDynamicSupport.bootstrap("isHexDigit", $$robo$$android_net_UrlQuerySanitizer$isHexDigit(char ), 0, this, c);
    }

    protected int decodeHexDigit(char c) {
        return (int)InvokeDynamicSupport.bootstrap("decodeHexDigit", $$robo$$android_net_UrlQuerySanitizer$decodeHexDigit(char ), 0, this, c);
    }

    protected void clear() {
        InvokeDynamicSupport.bootstrap("clear", $$robo$$android_net_UrlQuerySanitizer$clear(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(UrlQuerySanitizer.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UrlQuerySanitizer)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class IllegalCharacterValueSanitizer
    implements ValueSanitizer,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mFlags;
        public static int SPACE_OK = 1;
        public static int OTHER_WHITESPACE_OK = 2;
        public static int NON_7_BIT_ASCII_OK = 4;
        public static int DQUOTE_OK = 8;
        public static int SQUOTE_OK = 16;
        public static int LT_OK = 32;
        public static int GT_OK = 64;
        public static int AMP_OK = 128;
        public static int PCT_OK = 256;
        public static int NUL_OK = 512;
        public static int SCRIPT_URL_OK = 1024;
        public static int ALL_OK = 2047;
        public static int ALL_WHITESPACE_OK = 3;
        public static int ALL_ILLEGAL = 0;
        public static int ALL_BUT_NUL_LEGAL = 1535;
        public static int ALL_BUT_WHITESPACE_LEGAL = 1532;
        public static int URL_LEGAL = 404;
        public static int URL_AND_SPACE_LEGAL = 405;
        public static int AMP_LEGAL = 128;
        public static int AMP_AND_SPACE_LEGAL = 129;
        public static int SPACE_LEGAL = 1;
        public static int ALL_BUT_NUL_AND_ANGLE_BRACKETS_LEGAL = 1439;
        private static String JAVASCRIPT_PREFIX = "javascript:";
        private static String VBSCRIPT_PREFIX = "vbscript:";
        private static int MIN_SCRIPT_PREFIX_LENGTH;

        private void $$robo$$android_net_UrlQuerySanitizer_IllegalCharacterValueSanitizer$__constructor__(int flags) {
            this.mFlags = flags;
        }

        private final String $$robo$$android_net_UrlQuerySanitizer_IllegalCharacterValueSanitizer$sanitize(String value) {
            String asLower;
            if (value == null) {
                return null;
            }
            int length = value.length();
            if ((this.mFlags & 0x400) != 0 && length >= MIN_SCRIPT_PREFIX_LENGTH && ((asLower = value.toLowerCase(Locale.ROOT)).startsWith("javascript:") || asLower.startsWith("vbscript:"))) {
                return "";
            }
            if ((this.mFlags & 3) == 0) {
                value = this.trimWhitespace(value);
                length = value.length();
            }
            StringBuilder stringBuilder = new StringBuilder(length);
            for (int i = 0; i < length; ++i) {
                int c = value.charAt(i);
                if (!this.characterIsLegal((char)c)) {
                    c = (this.mFlags & 1) != 0 ? 32 : 95;
                }
                stringBuilder.append((char)c);
            }
            return stringBuilder.toString();
        }

        private final String $$robo$$android_net_UrlQuerySanitizer_IllegalCharacterValueSanitizer$trimWhitespace(String value) {
            int start;
            int last;
            int end = last = value.length() - 1;
            for (start = 0; start <= end && this.isWhitespace(value.charAt(start)); ++start) {
            }
            while (end >= start && this.isWhitespace(value.charAt(end))) {
                --end;
            }
            if (start == 0 && end == last) {
                return value;
            }
            return value.substring(start, end + 1);
        }

        private final boolean $$robo$$android_net_UrlQuerySanitizer_IllegalCharacterValueSanitizer$isWhitespace(char c) {
            switch (c) {
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case ' ': {
                    return true;
                }
            }
            return false;
        }

        private final boolean $$robo$$android_net_UrlQuerySanitizer_IllegalCharacterValueSanitizer$characterIsLegal(char c) {
            switch (c) {
                case ' ': {
                    return (this.mFlags & 1) != 0;
                }
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': {
                    return (this.mFlags & 2) != 0;
                }
                case '\"': {
                    return (this.mFlags & 8) != 0;
                }
                case '\'': {
                    return (this.mFlags & 0x10) != 0;
                }
                case '<': {
                    return (this.mFlags & 0x20) != 0;
                }
                case '>': {
                    return (this.mFlags & 0x40) != 0;
                }
                case '&': {
                    return (this.mFlags & 0x80) != 0;
                }
                case '%': {
                    return (this.mFlags & 0x100) != 0;
                }
                case '\u0000': {
                    return (this.mFlags & 0x200) != 0;
                }
            }
            return c >= ' ' && c < '\u007f' || c >= '\u0080' && (this.mFlags & 4) != 0;
        }

        static void __staticInitializer__() {
            MIN_SCRIPT_PREFIX_LENGTH = Math.min("javascript:".length(), "vbscript:".length());
        }

        private void __constructor__(int n) {
            this.$$robo$$android_net_UrlQuerySanitizer_IllegalCharacterValueSanitizer$__constructor__(n);
        }

        public IllegalCharacterValueSanitizer(int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_UrlQuerySanitizer_IllegalCharacterValueSanitizer$__constructor__(int ), 0, this, n);
        }

        @Override
        public String sanitize(String string2) {
            return InvokeDynamicSupport.bootstrap("sanitize", $$robo$$android_net_UrlQuerySanitizer_IllegalCharacterValueSanitizer$sanitize(java.lang.String ), 0, this, string2);
        }

        private String trimWhitespace(String string2) {
            return InvokeDynamicSupport.bootstrap("trimWhitespace", $$robo$$android_net_UrlQuerySanitizer_IllegalCharacterValueSanitizer$trimWhitespace(java.lang.String ), 0, this, string2);
        }

        private boolean isWhitespace(char c) {
            return (boolean)InvokeDynamicSupport.bootstrap("isWhitespace", $$robo$$android_net_UrlQuerySanitizer_IllegalCharacterValueSanitizer$isWhitespace(char ), 0, this, c);
        }

        private boolean characterIsLegal(char c) {
            return (boolean)InvokeDynamicSupport.bootstrap("characterIsLegal", $$robo$$android_net_UrlQuerySanitizer_IllegalCharacterValueSanitizer$characterIsLegal(char ), 0, this, c);
        }

        static {
            RobolectricInternals.classInitializing(IllegalCharacterValueSanitizer.class);
        }

        public /* synthetic */ IllegalCharacterValueSanitizer() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IllegalCharacterValueSanitizer)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface ValueSanitizer
    extends InstrumentedInterface {
        public String sanitize(String var1);
    }

    public class ParameterValuePair
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public String mParameter;
        public String mValue;
        /* synthetic */ UrlQuerySanitizer this$0;

        private void $$robo$$android_net_UrlQuerySanitizer_ParameterValuePair$__constructor__(UrlQuerySanitizer urlQuerySanitizer, String parameter, String value) {
            this.mParameter = parameter;
            this.mValue = value;
        }

        private void __constructor__(UrlQuerySanitizer urlQuerySanitizer, String string2, String string3) {
            this.$$robo$$android_net_UrlQuerySanitizer_ParameterValuePair$__constructor__(urlQuerySanitizer, string2, string3);
        }

        public ParameterValuePair(UrlQuerySanitizer urlQuerySanitizer, String string2, String string3) {
            this.this$0 = urlQuerySanitizer;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_UrlQuerySanitizer_ParameterValuePair$__constructor__(android.net.UrlQuerySanitizer java.lang.String java.lang.String ), 0, this, urlQuerySanitizer, string2, string3);
        }

        public /* synthetic */ ParameterValuePair() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ParameterValuePair)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

