/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.content.ContentResolver;
import android.content.Context;
import android.net.SSLCertificateSocketFactory;
import android.net.SSLSessionCache;
import android.os.Looper;
import android.util.Base64;
import android.util.Log;
import com.android.internal.http.HttpDateTime;
import com.google.errorprone.annotations.DoNotMock;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.RequestWrapper;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.BasicHttpProcessor;
import org.apache.http.protocol.HttpContext;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class AndroidHttpClient
implements HttpClient,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static long DEFAULT_SYNC_MIN_GZIP_BYTES;
    private static int SOCKET_OPERATION_TIMEOUT = 60000;
    private static String TAG = "AndroidHttpClient";
    private static String[] textContentTypes;
    private static HttpRequestInterceptor sThreadCheckInterceptor;
    private HttpClient delegate;
    private RuntimeException mLeakedException;
    private volatile LoggingConfiguration curlConfiguration;

    private static final AndroidHttpClient $$robo$$android_net_http_AndroidHttpClient$newInstance(String userAgent, Context context) {
        BasicHttpParams params = new BasicHttpParams();
        HttpConnectionParams.setStaleCheckingEnabled(params, false);
        HttpConnectionParams.setConnectionTimeout(params, 60000);
        HttpConnectionParams.setSoTimeout(params, 60000);
        HttpConnectionParams.setSocketBufferSize(params, 8192);
        HttpClientParams.setRedirecting(params, false);
        SSLSessionCache sessionCache = context == null ? null : new SSLSessionCache(context);
        HttpProtocolParams.setUserAgent(params, userAgent);
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", PlainSocketFactory.getSocketFactory(), 80));
        schemeRegistry.register(new Scheme("https", SSLCertificateSocketFactory.getHttpSocketFactory(60000, sessionCache), 443));
        ThreadSafeClientConnManager manager = new ThreadSafeClientConnManager(params, schemeRegistry);
        return new AndroidHttpClient(manager, params);
    }

    private static final AndroidHttpClient $$robo$$android_net_http_AndroidHttpClient$newInstance(String userAgent) {
        return AndroidHttpClient.newInstance(userAgent, null);
    }

    private void $$robo$$android_net_http_AndroidHttpClient$__constructor__(ClientConnectionManager ccm, HttpParams params) {
        this.mLeakedException = new IllegalStateException("AndroidHttpClient created and never closed");
        this.delegate = new ShadowedObject(this, ccm, params){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ AndroidHttpClient this$0;

            private void $$robo$$android_net_http_AndroidHttpClient_2$__constructor__(AndroidHttpClient androidHttpClient, ClientConnectionManager x0, HttpParams x1) {
            }

            private final BasicHttpProcessor $$robo$$android_net_http_AndroidHttpClient_2$createHttpProcessor() {
                BasicHttpProcessor processor = super.createHttpProcessor();
                processor.addRequestInterceptor(sThreadCheckInterceptor);
                processor.addRequestInterceptor(new CurlLogger(this.this$0));
                return processor;
            }

            private final HttpContext $$robo$$android_net_http_AndroidHttpClient_2$createHttpContext() {
                BasicHttpContext context = new BasicHttpContext();
                context.setAttribute("http.authscheme-registry", this.getAuthSchemes());
                context.setAttribute("http.cookiespec-registry", this.getCookieSpecs());
                context.setAttribute("http.auth.credentials-provider", this.getCredentialsProvider());
                return context;
            }

            private void __constructor__(AndroidHttpClient androidHttpClient, ClientConnectionManager clientConnectionManager, HttpParams httpParams) {
                this.$$robo$$android_net_http_AndroidHttpClient_2$__constructor__(androidHttpClient, clientConnectionManager, httpParams);
            }
            {
                this.this$0 = androidHttpClient;
                super(clientConnectionManager, httpParams);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_http_AndroidHttpClient_2$__constructor__(android.net.http.AndroidHttpClient org.apache.http.conn.ClientConnectionManager org.apache.http.params.HttpParams ), 0, this, androidHttpClient, clientConnectionManager, httpParams);
            }

            @Override
            protected BasicHttpProcessor createHttpProcessor() {
                return InvokeDynamicSupport.bootstrap("createHttpProcessor", $$robo$$android_net_http_AndroidHttpClient_2$createHttpProcessor(), 0, this);
            }

            @Override
            protected HttpContext createHttpContext() {
                return InvokeDynamicSupport.bootstrap("createHttpContext", $$robo$$android_net_http_AndroidHttpClient_2$createHttpContext(), 0, this);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private final void $$robo$$android_net_http_AndroidHttpClient$finalize() throws Throwable {
        super.finalize();
        if (this.mLeakedException != null) {
            Log.e("AndroidHttpClient", "Leak found", this.mLeakedException);
            this.mLeakedException = null;
        }
    }

    private static final void $$robo$$android_net_http_AndroidHttpClient$modifyRequestToAcceptGzipResponse(HttpRequest request) {
        request.addHeader("Accept-Encoding", "gzip");
    }

    private static final InputStream $$robo$$android_net_http_AndroidHttpClient$getUngzippedContent(HttpEntity entity) throws IOException {
        InputStream responseStream = entity.getContent();
        if (responseStream == null) {
            return responseStream;
        }
        Header header = entity.getContentEncoding();
        if (header == null) {
            return responseStream;
        }
        String contentEncoding = header.getValue();
        if (contentEncoding == null) {
            return responseStream;
        }
        if (contentEncoding.contains("gzip")) {
            responseStream = new GZIPInputStream(responseStream);
        }
        return responseStream;
    }

    private final void $$robo$$android_net_http_AndroidHttpClient$close() {
        if (this.mLeakedException != null) {
            this.getConnectionManager().shutdown();
            this.mLeakedException = null;
        }
    }

    private final HttpParams $$robo$$android_net_http_AndroidHttpClient$getParams() {
        return this.delegate.getParams();
    }

    private final ClientConnectionManager $$robo$$android_net_http_AndroidHttpClient$getConnectionManager() {
        return this.delegate.getConnectionManager();
    }

    private final HttpResponse $$robo$$android_net_http_AndroidHttpClient$execute(HttpUriRequest request) throws IOException {
        return this.delegate.execute(request);
    }

    private final HttpResponse $$robo$$android_net_http_AndroidHttpClient$execute(HttpUriRequest request, HttpContext context) throws IOException {
        return this.delegate.execute(request, context);
    }

    private final HttpResponse $$robo$$android_net_http_AndroidHttpClient$execute(HttpHost target, HttpRequest request) throws IOException {
        return this.delegate.execute(target, request);
    }

    private final HttpResponse $$robo$$android_net_http_AndroidHttpClient$execute(HttpHost target, HttpRequest request, HttpContext context) throws IOException {
        return this.delegate.execute(target, request, context);
    }

    private final <T> T $$robo$$android_net_http_AndroidHttpClient$execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        return this.delegate.execute(request, responseHandler);
    }

    private final <T> T $$robo$$android_net_http_AndroidHttpClient$execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
        return this.delegate.execute(request, responseHandler, context);
    }

    private final <T> T $$robo$$android_net_http_AndroidHttpClient$execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        return this.delegate.execute(target, request, responseHandler);
    }

    private final <T> T $$robo$$android_net_http_AndroidHttpClient$execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
        return this.delegate.execute(target, request, responseHandler, context);
    }

    private static final AbstractHttpEntity $$robo$$android_net_http_AndroidHttpClient$getCompressedEntity(byte[] data, ContentResolver resolver) throws IOException {
        ByteArrayEntity entity;
        if ((long)data.length < AndroidHttpClient.getMinGzipSize(resolver)) {
            entity = new ByteArrayEntity(data);
        } else {
            ByteArrayOutputStream arr = new ByteArrayOutputStream();
            GZIPOutputStream zipper = new GZIPOutputStream(arr);
            zipper.write(data);
            ((OutputStream)zipper).close();
            entity = new ByteArrayEntity(arr.toByteArray());
            entity.setContentEncoding("gzip");
        }
        return entity;
    }

    private static final long $$robo$$android_net_http_AndroidHttpClient$getMinGzipSize(ContentResolver resolver) {
        return DEFAULT_SYNC_MIN_GZIP_BYTES;
    }

    private final void $$robo$$android_net_http_AndroidHttpClient$enableCurlLogging(String name, int level) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (level < 2 || level > 7) {
            throw new IllegalArgumentException("Level is out of range [2..7]");
        }
        this.curlConfiguration = new LoggingConfiguration(name, level);
    }

    private final void $$robo$$android_net_http_AndroidHttpClient$disableCurlLogging() {
        this.curlConfiguration = null;
    }

    private static final String $$robo$$android_net_http_AndroidHttpClient$toCurl(HttpUriRequest request, boolean logAuthToken) throws IOException {
        HttpEntityEnclosingRequest entityRequest;
        HttpEntity entity;
        HttpRequest original;
        StringBuilder builder = new StringBuilder();
        builder.append("curl ");
        builder.append("-X ");
        builder.append(request.getMethod());
        builder.append(" ");
        for (Header header : request.getAllHeaders()) {
            if (!logAuthToken && (header.getName().equals("Authorization") || header.getName().equals("Cookie"))) continue;
            builder.append("--header \"");
            builder.append(header.toString().trim());
            builder.append("\" ");
        }
        URI uri = request.getURI();
        if (request instanceof RequestWrapper && (original = ((RequestWrapper)request).getOriginal()) instanceof HttpUriRequest) {
            uri = ((HttpUriRequest)original).getURI();
        }
        builder.append("\"");
        builder.append(uri);
        builder.append("\"");
        if (request instanceof HttpEntityEnclosingRequest && (entity = (entityRequest = (HttpEntityEnclosingRequest)((Object)request)).getEntity()) != null && entity.isRepeatable()) {
            if (entity.getContentLength() < 1024L) {
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                entity.writeTo(stream);
                if (AndroidHttpClient.isBinaryContent(request)) {
                    String base64 = Base64.encodeToString(stream.toByteArray(), 2);
                    builder.insert(0, "echo '" + base64 + "' | base64 -d > /tmp/$$.bin; ");
                    builder.append(" --data-binary @/tmp/$$.bin");
                } else {
                    String entityString = stream.toString();
                    builder.append(" --data-ascii \"").append(entityString).append("\"");
                }
            } else {
                builder.append(" [TOO MUCH DATA TO INCLUDE]");
            }
        }
        return builder.toString();
    }

    private static final boolean $$robo$$android_net_http_AndroidHttpClient$isBinaryContent(HttpUriRequest request) {
        Header[] headers = request.getHeaders("content-encoding");
        if (headers != null) {
            for (Header header : headers) {
                if (!"gzip".equalsIgnoreCase(header.getValue())) continue;
                return true;
            }
        }
        if ((headers = request.getHeaders("content-type")) != null) {
            for (Header header : headers) {
                for (String contentType : textContentTypes) {
                    if (!header.getValue().startsWith(contentType)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static final long $$robo$$android_net_http_AndroidHttpClient$parseDate(String dateString) {
        return HttpDateTime.parse(dateString);
    }

    static void __staticInitializer__() {
        DEFAULT_SYNC_MIN_GZIP_BYTES = 256L;
        textContentTypes = new String[]{"text/", "application/xml", "application/json"};
        sThreadCheckInterceptor = new HttpRequestInterceptor(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_net_http_AndroidHttpClient_1$__constructor__() {
            }

            private final void $$robo$$android_net_http_AndroidHttpClient_1$process(HttpRequest request, HttpContext context) {
                if (Looper.myLooper() != null && Looper.myLooper() == Looper.getMainLooper()) {
                    throw new RuntimeException("This thread forbids HTTP requests");
                }
            }

            private void __constructor__() {
                this.$$robo$$android_net_http_AndroidHttpClient_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_http_AndroidHttpClient_1$__constructor__(), 0, this);
            }

            @Override
            public void process(HttpRequest httpRequest, HttpContext httpContext) {
                InvokeDynamicSupport.bootstrap("process", $$robo$$android_net_http_AndroidHttpClient_1$process(org.apache.http.HttpRequest org.apache.http.protocol.HttpContext ), 0, this, httpRequest, httpContext);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    public static AndroidHttpClient newInstance(String string2, Context context) {
        return InvokeDynamicSupport.bootstrapStatic("newInstance", $$robo$$android_net_http_AndroidHttpClient$newInstance(java.lang.String android.content.Context ), 0, (String)string2, (Context)context);
    }

    public static AndroidHttpClient newInstance(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("newInstance", $$robo$$android_net_http_AndroidHttpClient$newInstance(java.lang.String ), 0, (String)string2);
    }

    private void __constructor__(ClientConnectionManager clientConnectionManager, HttpParams httpParams) {
        this.$$robo$$android_net_http_AndroidHttpClient$__constructor__(clientConnectionManager, httpParams);
    }

    private AndroidHttpClient(ClientConnectionManager clientConnectionManager, HttpParams httpParams) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_http_AndroidHttpClient$__constructor__(org.apache.http.conn.ClientConnectionManager org.apache.http.params.HttpParams ), 0, this, clientConnectionManager, httpParams);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_net_http_AndroidHttpClient$finalize(), 0, this);
    }

    public static void modifyRequestToAcceptGzipResponse(HttpRequest httpRequest) {
        InvokeDynamicSupport.bootstrapStatic("modifyRequestToAcceptGzipResponse", $$robo$$android_net_http_AndroidHttpClient$modifyRequestToAcceptGzipResponse(org.apache.http.HttpRequest ), 0, (HttpRequest)httpRequest);
    }

    public static InputStream getUngzippedContent(HttpEntity httpEntity) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("getUngzippedContent", $$robo$$android_net_http_AndroidHttpClient$getUngzippedContent(org.apache.http.HttpEntity ), 0, (HttpEntity)httpEntity);
    }

    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_net_http_AndroidHttpClient$close(), 0, this);
    }

    @Override
    public HttpParams getParams() {
        return InvokeDynamicSupport.bootstrap("getParams", $$robo$$android_net_http_AndroidHttpClient$getParams(), 0, this);
    }

    @Override
    public ClientConnectionManager getConnectionManager() {
        return InvokeDynamicSupport.bootstrap("getConnectionManager", $$robo$$android_net_http_AndroidHttpClient$getConnectionManager(), 0, this);
    }

    @Override
    public HttpResponse execute(HttpUriRequest httpUriRequest) throws IOException {
        return InvokeDynamicSupport.bootstrap("execute", $$robo$$android_net_http_AndroidHttpClient$execute(org.apache.http.client.methods.HttpUriRequest ), 0, this, httpUriRequest);
    }

    @Override
    public HttpResponse execute(HttpUriRequest httpUriRequest, HttpContext httpContext) throws IOException {
        return InvokeDynamicSupport.bootstrap("execute", $$robo$$android_net_http_AndroidHttpClient$execute(org.apache.http.client.methods.HttpUriRequest org.apache.http.protocol.HttpContext ), 0, this, httpUriRequest, httpContext);
    }

    @Override
    public HttpResponse execute(HttpHost httpHost, HttpRequest httpRequest) throws IOException {
        return InvokeDynamicSupport.bootstrap("execute", $$robo$$android_net_http_AndroidHttpClient$execute(org.apache.http.HttpHost org.apache.http.HttpRequest ), 0, this, httpHost, httpRequest);
    }

    @Override
    public HttpResponse execute(HttpHost httpHost, HttpRequest httpRequest, HttpContext httpContext) throws IOException {
        return InvokeDynamicSupport.bootstrap("execute", $$robo$$android_net_http_AndroidHttpClient$execute(org.apache.http.HttpHost org.apache.http.HttpRequest org.apache.http.protocol.HttpContext ), 0, this, httpHost, httpRequest, httpContext);
    }

    @Override
    public <T> T execute(HttpUriRequest httpUriRequest, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        return (T)InvokeDynamicSupport.bootstrap("execute", $$robo$$android_net_http_AndroidHttpClient$execute(org.apache.http.client.methods.HttpUriRequest org.apache.http.client.ResponseHandler<? extends T> ), 0, this, httpUriRequest, responseHandler);
    }

    @Override
    public <T> T execute(HttpUriRequest httpUriRequest, ResponseHandler<? extends T> responseHandler, HttpContext httpContext) throws IOException, ClientProtocolException {
        return (T)InvokeDynamicSupport.bootstrap("execute", $$robo$$android_net_http_AndroidHttpClient$execute(org.apache.http.client.methods.HttpUriRequest org.apache.http.client.ResponseHandler<? extends T> org.apache.http.protocol.HttpContext ), 0, this, httpUriRequest, responseHandler, httpContext);
    }

    @Override
    public <T> T execute(HttpHost httpHost, HttpRequest httpRequest, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        return (T)InvokeDynamicSupport.bootstrap("execute", $$robo$$android_net_http_AndroidHttpClient$execute(org.apache.http.HttpHost org.apache.http.HttpRequest org.apache.http.client.ResponseHandler<? extends T> ), 0, this, httpHost, httpRequest, responseHandler);
    }

    @Override
    public <T> T execute(HttpHost httpHost, HttpRequest httpRequest, ResponseHandler<? extends T> responseHandler, HttpContext httpContext) throws IOException, ClientProtocolException {
        return (T)InvokeDynamicSupport.bootstrap("execute", $$robo$$android_net_http_AndroidHttpClient$execute(org.apache.http.HttpHost org.apache.http.HttpRequest org.apache.http.client.ResponseHandler<? extends T> org.apache.http.protocol.HttpContext ), 0, this, httpHost, httpRequest, responseHandler, httpContext);
    }

    public static AbstractHttpEntity getCompressedEntity(byte[] byArray, ContentResolver contentResolver) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("getCompressedEntity", $$robo$$android_net_http_AndroidHttpClient$getCompressedEntity(byte[] android.content.ContentResolver ), 0, (byte[])byArray, (ContentResolver)contentResolver);
    }

    public static long getMinGzipSize(ContentResolver contentResolver) {
        return (long)InvokeDynamicSupport.bootstrapStatic("getMinGzipSize", $$robo$$android_net_http_AndroidHttpClient$getMinGzipSize(android.content.ContentResolver ), 0, (ContentResolver)contentResolver);
    }

    public void enableCurlLogging(String string2, int n) {
        InvokeDynamicSupport.bootstrap("enableCurlLogging", $$robo$$android_net_http_AndroidHttpClient$enableCurlLogging(java.lang.String int ), 0, this, string2, n);
    }

    public void disableCurlLogging() {
        InvokeDynamicSupport.bootstrap("disableCurlLogging", $$robo$$android_net_http_AndroidHttpClient$disableCurlLogging(), 0, this);
    }

    private static String toCurl(HttpUriRequest httpUriRequest, boolean bl) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("toCurl", $$robo$$android_net_http_AndroidHttpClient$toCurl(org.apache.http.client.methods.HttpUriRequest boolean ), 0, (HttpUriRequest)httpUriRequest, (boolean)bl);
    }

    private static boolean isBinaryContent(HttpUriRequest httpUriRequest) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isBinaryContent", $$robo$$android_net_http_AndroidHttpClient$isBinaryContent(org.apache.http.client.methods.HttpUriRequest ), 0, (HttpUriRequest)httpUriRequest);
    }

    public static long parseDate(String string2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("parseDate", $$robo$$android_net_http_AndroidHttpClient$parseDate(java.lang.String ), 0, (String)string2);
    }

    static {
        RobolectricInternals.classInitializing(AndroidHttpClient.class);
    }

    public /* synthetic */ AndroidHttpClient() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AndroidHttpClient)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class CurlLogger
    implements HttpRequestInterceptor,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ AndroidHttpClient this$0;

        private void $$robo$$android_net_http_AndroidHttpClient_CurlLogger$__constructor__(AndroidHttpClient androidHttpClient) {
        }

        private final void $$robo$$android_net_http_AndroidHttpClient_CurlLogger$process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            LoggingConfiguration configuration = this.this$0.curlConfiguration;
            if (configuration != null && configuration.isLoggable() && request instanceof HttpUriRequest) {
                configuration.println(AndroidHttpClient.toCurl((HttpUriRequest)request, false));
            }
        }

        private /* synthetic */ void $$robo$$android_net_http_AndroidHttpClient_CurlLogger$__constructor__(AndroidHttpClient x0, 1 x1) {
        }

        private void __constructor__(AndroidHttpClient androidHttpClient) {
            this.$$robo$$android_net_http_AndroidHttpClient_CurlLogger$__constructor__(androidHttpClient);
        }

        private CurlLogger(AndroidHttpClient androidHttpClient) {
            this.this$0 = androidHttpClient;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_http_AndroidHttpClient_CurlLogger$__constructor__(android.net.http.AndroidHttpClient ), 0, this, androidHttpClient);
        }

        @Override
        public void process(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
            InvokeDynamicSupport.bootstrap("process", $$robo$$android_net_http_AndroidHttpClient_CurlLogger$process(org.apache.http.HttpRequest org.apache.http.protocol.HttpContext ), 0, this, httpRequest, httpContext);
        }

        private /* synthetic */ void __constructor__(AndroidHttpClient androidHttpClient, 1 var2_2) {
            this.$$robo$$android_net_http_AndroidHttpClient_CurlLogger$__constructor__(androidHttpClient, var2_2);
        }

        public /* synthetic */ CurlLogger() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CurlLogger)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class LoggingConfiguration
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private String tag;
        private int level;

        private void $$robo$$android_net_http_AndroidHttpClient_LoggingConfiguration$__constructor__(String tag, int level) {
            this.tag = tag;
            this.level = level;
        }

        private final boolean $$robo$$android_net_http_AndroidHttpClient_LoggingConfiguration$isLoggable() {
            return Log.isLoggable(this.tag, this.level);
        }

        private final void $$robo$$android_net_http_AndroidHttpClient_LoggingConfiguration$println(String message) {
            Log.println(this.level, this.tag, message);
        }

        private /* synthetic */ void $$robo$$android_net_http_AndroidHttpClient_LoggingConfiguration$__constructor__(String x0, int x1, 1 x2) {
        }

        private void __constructor__(String string2, int n) {
            this.$$robo$$android_net_http_AndroidHttpClient_LoggingConfiguration$__constructor__(string2, n);
        }

        private LoggingConfiguration(String string2, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_http_AndroidHttpClient_LoggingConfiguration$__constructor__(java.lang.String int ), 0, this, string2, n);
        }

        private boolean isLoggable() {
            return (boolean)InvokeDynamicSupport.bootstrap("isLoggable", $$robo$$android_net_http_AndroidHttpClient_LoggingConfiguration$isLoggable(), 0, this);
        }

        private void println(String string2) {
            InvokeDynamicSupport.bootstrap("println", $$robo$$android_net_http_AndroidHttpClient_LoggingConfiguration$println(java.lang.String ), 0, this, string2);
        }

        private /* synthetic */ void __constructor__(String string2, int n, 1 var3_3) {
            this.$$robo$$android_net_http_AndroidHttpClient_LoggingConfiguration$__constructor__(string2, n, var3_3);
        }

        public /* synthetic */ LoggingConfiguration() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LoggingConfiguration)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

