/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.net.http.Headers;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import org.apache.http.HttpConnection;
import org.apache.http.HttpConnectionMetrics;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpInetConnection;
import org.apache.http.HttpRequest;
import org.apache.http.NoHttpResponseException;
import org.apache.http.ParseException;
import org.apache.http.StatusLine;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.impl.HttpConnectionMetricsImpl;
import org.apache.http.impl.entity.EntitySerializer;
import org.apache.http.impl.entity.StrictContentLengthStrategy;
import org.apache.http.impl.io.ChunkedInputStream;
import org.apache.http.impl.io.ContentLengthInputStream;
import org.apache.http.impl.io.HttpRequestWriter;
import org.apache.http.impl.io.IdentityInputStream;
import org.apache.http.impl.io.SocketInputBuffer;
import org.apache.http.impl.io.SocketOutputBuffer;
import org.apache.http.io.HttpMessageWriter;
import org.apache.http.io.SessionInputBuffer;
import org.apache.http.io.SessionOutputBuffer;
import org.apache.http.message.BasicLineParser;
import org.apache.http.message.ParserCursor;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.CharArrayBuffer;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class AndroidHttpClientConnection
implements HttpInetConnection,
HttpConnection,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private SessionInputBuffer inbuffer;
    private SessionOutputBuffer outbuffer;
    private int maxHeaderCount;
    private int maxLineLength;
    private EntitySerializer entityserializer;
    private HttpMessageWriter requestWriter;
    private HttpConnectionMetricsImpl metrics;
    private volatile boolean open;
    private Socket socket;

    private void $$robo$$android_net_http_AndroidHttpClientConnection$__constructor__() {
        this.inbuffer = null;
        this.outbuffer = null;
        this.requestWriter = null;
        this.metrics = null;
        this.socket = null;
        this.entityserializer = new EntitySerializer(new StrictContentLengthStrategy());
    }

    private final void $$robo$$android_net_http_AndroidHttpClientConnection$bind(Socket socket, HttpParams params) throws IOException {
        if (socket == null) {
            throw new IllegalArgumentException("Socket may not be null");
        }
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.assertNotOpen();
        socket.setTcpNoDelay(HttpConnectionParams.getTcpNoDelay(params));
        socket.setSoTimeout(HttpConnectionParams.getSoTimeout(params));
        int linger = HttpConnectionParams.getLinger(params);
        if (linger >= 0) {
            socket.setSoLinger(linger > 0, linger);
        }
        this.socket = socket;
        int buffersize = HttpConnectionParams.getSocketBufferSize(params);
        this.inbuffer = new SocketInputBuffer(socket, buffersize, params);
        this.outbuffer = new SocketOutputBuffer(socket, buffersize, params);
        this.maxHeaderCount = params.getIntParameter("http.connection.max-header-count", -1);
        this.maxLineLength = params.getIntParameter("http.connection.max-line-length", -1);
        this.requestWriter = new HttpRequestWriter(this.outbuffer, null, params);
        this.metrics = new HttpConnectionMetricsImpl(this.inbuffer.getMetrics(), this.outbuffer.getMetrics());
        this.open = true;
    }

    private final String $$robo$$android_net_http_AndroidHttpClientConnection$toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getClass().getSimpleName()).append("[");
        if (this.isOpen()) {
            buffer.append(this.getRemotePort());
        } else {
            buffer.append("closed");
        }
        buffer.append("]");
        return buffer.toString();
    }

    private final void $$robo$$android_net_http_AndroidHttpClientConnection$assertNotOpen() {
        if (this.open) {
            throw new IllegalStateException("Connection is already open");
        }
    }

    private final void $$robo$$android_net_http_AndroidHttpClientConnection$assertOpen() {
        if (!this.open) {
            throw new IllegalStateException("Connection is not open");
        }
    }

    private final boolean $$robo$$android_net_http_AndroidHttpClientConnection$isOpen() {
        return this.open && this.socket != null && this.socket.isConnected();
    }

    private final InetAddress $$robo$$android_net_http_AndroidHttpClientConnection$getLocalAddress() {
        if (this.socket != null) {
            return this.socket.getLocalAddress();
        }
        return null;
    }

    private final int $$robo$$android_net_http_AndroidHttpClientConnection$getLocalPort() {
        if (this.socket != null) {
            return this.socket.getLocalPort();
        }
        return -1;
    }

    private final InetAddress $$robo$$android_net_http_AndroidHttpClientConnection$getRemoteAddress() {
        if (this.socket != null) {
            return this.socket.getInetAddress();
        }
        return null;
    }

    private final int $$robo$$android_net_http_AndroidHttpClientConnection$getRemotePort() {
        if (this.socket != null) {
            return this.socket.getPort();
        }
        return -1;
    }

    private final void $$robo$$android_net_http_AndroidHttpClientConnection$setSocketTimeout(int timeout) {
        this.assertOpen();
        if (this.socket != null) {
            try {
                this.socket.setSoTimeout(timeout);
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
    }

    private final int $$robo$$android_net_http_AndroidHttpClientConnection$getSocketTimeout() {
        if (this.socket != null) {
            try {
                return this.socket.getSoTimeout();
            }
            catch (SocketException ignore) {
                return -1;
            }
        }
        return -1;
    }

    private final void $$robo$$android_net_http_AndroidHttpClientConnection$shutdown() throws IOException {
        this.open = false;
        Socket tmpsocket = this.socket;
        if (tmpsocket != null) {
            tmpsocket.close();
        }
    }

    private final void $$robo$$android_net_http_AndroidHttpClientConnection$close() throws IOException {
        if (!this.open) {
            return;
        }
        this.open = false;
        this.doFlush();
        try {
            try {
                this.socket.shutdownOutput();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.socket.shutdownInput();
            }
            catch (IOException iOException) {}
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.socket.close();
    }

    private final void $$robo$$android_net_http_AndroidHttpClientConnection$sendRequestHeader(HttpRequest request) throws HttpException, IOException {
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        this.assertOpen();
        this.requestWriter.write(request);
        this.metrics.incrementRequestCount();
    }

    private final void $$robo$$android_net_http_AndroidHttpClientConnection$sendRequestEntity(HttpEntityEnclosingRequest request) throws HttpException, IOException {
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        this.assertOpen();
        if (request.getEntity() == null) {
            return;
        }
        this.entityserializer.serialize(this.outbuffer, request, request.getEntity());
    }

    private final void $$robo$$android_net_http_AndroidHttpClientConnection$doFlush() throws IOException {
        this.outbuffer.flush();
    }

    private final void $$robo$$android_net_http_AndroidHttpClientConnection$flush() throws IOException {
        this.assertOpen();
        this.doFlush();
    }

    private final StatusLine $$robo$$android_net_http_AndroidHttpClientConnection$parseResponseHeader(Headers headers) throws IOException, ParseException {
        CharArrayBuffer previous;
        int statusCode;
        StatusLine statusline;
        block10: {
            this.assertOpen();
            CharArrayBuffer current = new CharArrayBuffer(64);
            if (this.inbuffer.readLine(current) == -1) {
                throw new NoHttpResponseException("The target server failed to respond");
            }
            statusline = BasicLineParser.DEFAULT.parseStatusLine(current, new ParserCursor(0, current.length()));
            statusCode = statusline.getStatusCode();
            previous = null;
            int headerNumber = 0;
            do {
                if (current == null) {
                    current = new CharArrayBuffer(64);
                } else {
                    current.clear();
                }
                int l = this.inbuffer.readLine(current);
                if (l == -1 || current.length() < 1) break block10;
                char first = current.charAt(0);
                if ((first == ' ' || first == '\t') && previous != null) {
                    char ch;
                    int start;
                    int length = current.length();
                    for (start = 0; start < length && ((ch = current.charAt(start)) == ' ' || ch == '\t'); ++start) {
                    }
                    if (this.maxLineLength > 0 && previous.length() + 1 + current.length() - start > this.maxLineLength) {
                        throw new IOException("Maximum line length limit exceeded");
                    }
                    previous.append(' ');
                    previous.append(current, start, current.length() - start);
                    continue;
                }
                if (previous != null) {
                    headers.parseHeader(previous);
                }
                ++headerNumber;
                previous = current;
                current = null;
            } while (this.maxHeaderCount <= 0 || headerNumber < this.maxHeaderCount);
            throw new IOException("Maximum header count exceeded");
        }
        if (previous != null) {
            headers.parseHeader(previous);
        }
        if (statusCode >= 200) {
            this.metrics.incrementResponseCount();
        }
        return statusline;
    }

    private final HttpEntity $$robo$$android_net_http_AndroidHttpClientConnection$receiveResponseEntity(Headers headers) {
        String contentEncodingHeader;
        this.assertOpen();
        BasicHttpEntity entity = new BasicHttpEntity();
        long len = this.determineLength(headers);
        if (len == -2L) {
            entity.setChunked(true);
            entity.setContentLength(-1L);
            entity.setContent(new ChunkedInputStream(this.inbuffer));
        } else if (len == -1L) {
            entity.setChunked(false);
            entity.setContentLength(-1L);
            entity.setContent(new IdentityInputStream(this.inbuffer));
        } else {
            entity.setChunked(false);
            entity.setContentLength(len);
            entity.setContent(new ContentLengthInputStream(this.inbuffer, len));
        }
        String contentTypeHeader = headers.getContentType();
        if (contentTypeHeader != null) {
            entity.setContentType(contentTypeHeader);
        }
        if ((contentEncodingHeader = headers.getContentEncoding()) != null) {
            entity.setContentEncoding(contentEncodingHeader);
        }
        return entity;
    }

    private final long $$robo$$android_net_http_AndroidHttpClientConnection$determineLength(Headers headers) {
        long transferEncoding = headers.getTransferEncoding();
        if (transferEncoding < 0L) {
            return transferEncoding;
        }
        long contentlen = headers.getContentLength();
        if (contentlen > -1L) {
            return contentlen;
        }
        return -1L;
    }

    private final boolean $$robo$$android_net_http_AndroidHttpClientConnection$isStale() {
        this.assertOpen();
        try {
            this.inbuffer.isDataAvailable(1);
            return false;
        }
        catch (IOException ex) {
            return true;
        }
    }

    private final HttpConnectionMetrics $$robo$$android_net_http_AndroidHttpClientConnection$getMetrics() {
        return this.metrics;
    }

    private void __constructor__() {
        this.$$robo$$android_net_http_AndroidHttpClientConnection$__constructor__();
    }

    public AndroidHttpClientConnection() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_http_AndroidHttpClientConnection$__constructor__(), 0, this);
    }

    public void bind(Socket socket, HttpParams httpParams) throws IOException {
        InvokeDynamicSupport.bootstrap("bind", $$robo$$android_net_http_AndroidHttpClientConnection$bind(java.net.Socket org.apache.http.params.HttpParams ), 0, this, socket, httpParams);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_http_AndroidHttpClientConnection$toString(), 0, this);
    }

    private void assertNotOpen() {
        InvokeDynamicSupport.bootstrap("assertNotOpen", $$robo$$android_net_http_AndroidHttpClientConnection$assertNotOpen(), 0, this);
    }

    private void assertOpen() {
        InvokeDynamicSupport.bootstrap("assertOpen", $$robo$$android_net_http_AndroidHttpClientConnection$assertOpen(), 0, this);
    }

    @Override
    public boolean isOpen() {
        return (boolean)InvokeDynamicSupport.bootstrap("isOpen", $$robo$$android_net_http_AndroidHttpClientConnection$isOpen(), 0, this);
    }

    @Override
    public InetAddress getLocalAddress() {
        return InvokeDynamicSupport.bootstrap("getLocalAddress", $$robo$$android_net_http_AndroidHttpClientConnection$getLocalAddress(), 0, this);
    }

    @Override
    public int getLocalPort() {
        return (int)InvokeDynamicSupport.bootstrap("getLocalPort", $$robo$$android_net_http_AndroidHttpClientConnection$getLocalPort(), 0, this);
    }

    @Override
    public InetAddress getRemoteAddress() {
        return InvokeDynamicSupport.bootstrap("getRemoteAddress", $$robo$$android_net_http_AndroidHttpClientConnection$getRemoteAddress(), 0, this);
    }

    @Override
    public int getRemotePort() {
        return (int)InvokeDynamicSupport.bootstrap("getRemotePort", $$robo$$android_net_http_AndroidHttpClientConnection$getRemotePort(), 0, this);
    }

    @Override
    public void setSocketTimeout(int n) {
        InvokeDynamicSupport.bootstrap("setSocketTimeout", $$robo$$android_net_http_AndroidHttpClientConnection$setSocketTimeout(int ), 0, this, n);
    }

    @Override
    public int getSocketTimeout() {
        return (int)InvokeDynamicSupport.bootstrap("getSocketTimeout", $$robo$$android_net_http_AndroidHttpClientConnection$getSocketTimeout(), 0, this);
    }

    @Override
    public void shutdown() throws IOException {
        InvokeDynamicSupport.bootstrap("shutdown", $$robo$$android_net_http_AndroidHttpClientConnection$shutdown(), 0, this);
    }

    @Override
    public void close() throws IOException {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_net_http_AndroidHttpClientConnection$close(), 0, this);
    }

    public void sendRequestHeader(HttpRequest httpRequest) throws HttpException, IOException {
        InvokeDynamicSupport.bootstrap("sendRequestHeader", $$robo$$android_net_http_AndroidHttpClientConnection$sendRequestHeader(org.apache.http.HttpRequest ), 0, this, httpRequest);
    }

    public void sendRequestEntity(HttpEntityEnclosingRequest httpEntityEnclosingRequest) throws HttpException, IOException {
        InvokeDynamicSupport.bootstrap("sendRequestEntity", $$robo$$android_net_http_AndroidHttpClientConnection$sendRequestEntity(org.apache.http.HttpEntityEnclosingRequest ), 0, this, httpEntityEnclosingRequest);
    }

    protected void doFlush() throws IOException {
        InvokeDynamicSupport.bootstrap("doFlush", $$robo$$android_net_http_AndroidHttpClientConnection$doFlush(), 0, this);
    }

    public void flush() throws IOException {
        InvokeDynamicSupport.bootstrap("flush", $$robo$$android_net_http_AndroidHttpClientConnection$flush(), 0, this);
    }

    public StatusLine parseResponseHeader(Headers headers) throws IOException, ParseException {
        return InvokeDynamicSupport.bootstrap("parseResponseHeader", $$robo$$android_net_http_AndroidHttpClientConnection$parseResponseHeader(android.net.http.Headers ), 0, this, headers);
    }

    public HttpEntity receiveResponseEntity(Headers headers) {
        return InvokeDynamicSupport.bootstrap("receiveResponseEntity", $$robo$$android_net_http_AndroidHttpClientConnection$receiveResponseEntity(android.net.http.Headers ), 0, this, headers);
    }

    private long determineLength(Headers headers) {
        return (long)InvokeDynamicSupport.bootstrap("determineLength", $$robo$$android_net_http_AndroidHttpClientConnection$determineLength(android.net.http.Headers ), 0, this, headers);
    }

    @Override
    public boolean isStale() {
        return (boolean)InvokeDynamicSupport.bootstrap("isStale", $$robo$$android_net_http_AndroidHttpClientConnection$isStale(), 0, this);
    }

    @Override
    public HttpConnectionMetrics getMetrics() {
        return InvokeDynamicSupport.bootstrap("getMetrics", $$robo$$android_net_http_AndroidHttpClientConnection$getMetrics(), 0, this);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AndroidHttpClientConnection)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

