/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.content.Context;
import android.net.http.AndroidHttpClientConnection;
import android.net.http.ErrorStrings;
import android.net.http.HttpConnection;
import android.net.http.HttpsConnection;
import android.net.http.Request;
import android.net.http.RequestFeeder;
import android.net.http.SSLConnectionClosedByUserException;
import android.net.http.SslCertificate;
import android.os.SystemClock;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.LinkedList;
import javax.net.ssl.SSLHandshakeException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpVersion;
import org.apache.http.ParseException;
import org.apache.http.ProtocolVersion;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class Connection
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static int SOCKET_TIMEOUT = 60000;
    private static int SEND = 0;
    private static int READ = 1;
    private static int DRAIN = 2;
    private static int DONE = 3;
    private static String[] states;
    Context mContext;
    protected AndroidHttpClientConnection mHttpClientConnection;
    protected SslCertificate mCertificate;
    HttpHost mHost;
    private boolean mCanPersist;
    private HttpContext mHttpContext;
    private static int STATE_NORMAL;
    private static int STATE_CANCEL_REQUESTED;
    private int mActive;
    private static int RETRY_REQUEST_LIMIT = 2;
    private static int MIN_PIPE = 2;
    private static int MAX_PIPE = 3;
    private static String HTTP_CONNECTION = "http.connection";
    RequestFeeder mRequestFeeder;
    private byte[] mBuf;

    private void $$robo$$android_net_http_Connection$__constructor__(Context context, HttpHost host, RequestFeeder requestFeeder) {
        this.mHttpClientConnection = null;
        this.mCertificate = null;
        this.mActive = STATE_NORMAL;
        this.mContext = context;
        this.mHost = host;
        this.mRequestFeeder = requestFeeder;
        this.mCanPersist = false;
        this.mHttpContext = new BasicHttpContext(null);
    }

    private final HttpHost $$robo$$android_net_http_Connection$getHost() {
        return this.mHost;
    }

    private static final Connection $$robo$$android_net_http_Connection$getConnection(Context context, HttpHost host, HttpHost proxy, RequestFeeder requestFeeder) {
        if (host.getSchemeName().equals("http")) {
            return new HttpConnection(context, host, requestFeeder);
        }
        return new HttpsConnection(context, host, proxy, requestFeeder);
    }

    private final SslCertificate $$robo$$android_net_http_Connection$getCertificate() {
        return this.mCertificate;
    }

    private final void $$robo$$android_net_http_Connection$cancel() {
        this.mActive = STATE_CANCEL_REQUESTED;
        this.closeConnection();
    }

    private final void $$robo$$android_net_http_Connection$processRequests(Request firstRequest) {
        Request req = null;
        int error = 0;
        Exception exception = null;
        LinkedList<Request> pipe = new LinkedList<Request>();
        int minPipe = 2;
        int maxPipe = 3;
        int state = 0;
        while (state != 3) {
            if (this.mActive == STATE_CANCEL_REQUESTED) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.mActive = STATE_NORMAL;
            }
            switch (state) {
                case 0: {
                    if (pipe.size() == maxPipe) {
                        state = 1;
                        break;
                    }
                    if (firstRequest == null) {
                        req = this.mRequestFeeder.getRequest(this.mHost);
                    } else {
                        req = firstRequest;
                        firstRequest = null;
                    }
                    if (req == null) {
                        state = 2;
                        break;
                    }
                    req.setConnection(this);
                    if (req.mCancelled) {
                        req.complete();
                        break;
                    }
                    if (!(this.mHttpClientConnection != null && this.mHttpClientConnection.isOpen() || this.openHttpConnection(req))) {
                        state = 3;
                        break;
                    }
                    req.mEventHandler.certificate(this.mCertificate);
                    try {
                        req.sendRequest(this.mHttpClientConnection);
                    }
                    catch (HttpException e) {
                        exception = e;
                        error = -1;
                    }
                    catch (IOException e) {
                        exception = e;
                        error = -7;
                    }
                    catch (IllegalStateException e) {
                        exception = e;
                        error = -7;
                    }
                    if (exception != null) {
                        if (this.httpFailure(req, error, exception) && !req.mCancelled) {
                            pipe.addLast(req);
                        }
                        exception = null;
                        state = this.clearPipe(pipe) ? 3 : 0;
                        maxPipe = 1;
                        minPipe = 1;
                        break;
                    }
                    pipe.addLast(req);
                    if (this.mCanPersist) break;
                    state = 1;
                    break;
                }
                case 1: 
                case 2: {
                    boolean empty = !this.mRequestFeeder.haveRequest(this.mHost);
                    int pipeSize = pipe.size();
                    if (state != 2 && pipeSize < minPipe && !empty && this.mCanPersist) {
                        state = 0;
                        break;
                    }
                    if (pipeSize == 0) {
                        state = empty ? 3 : 0;
                        break;
                    }
                    req = (Request)pipe.removeFirst();
                    try {
                        req.readResponse(this.mHttpClientConnection);
                    }
                    catch (ParseException e) {
                        exception = e;
                        error = -7;
                    }
                    catch (IOException e) {
                        exception = e;
                        error = -7;
                    }
                    catch (IllegalStateException e) {
                        exception = e;
                        error = -7;
                    }
                    if (exception != null) {
                        if (this.httpFailure(req, error, exception) && !req.mCancelled) {
                            req.reset();
                            pipe.addFirst(req);
                        }
                        exception = null;
                        this.mCanPersist = false;
                    }
                    if (this.mCanPersist) break;
                    this.closeConnection();
                    this.mHttpContext.removeAttribute("http.connection");
                    this.clearPipe(pipe);
                    maxPipe = 1;
                    minPipe = 1;
                    state = 0;
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_net_http_Connection$clearPipe(LinkedList<Request> pipe) {
        boolean empty = true;
        RequestFeeder requestFeeder = this.mRequestFeeder;
        synchronized (requestFeeder) {
            while (!pipe.isEmpty()) {
                Request tReq = pipe.removeLast();
                this.mRequestFeeder.requeueRequest(tReq);
                empty = false;
            }
            if (empty) {
                empty = !this.mRequestFeeder.haveRequest(this.mHost);
            }
        }
        return empty;
    }

    private final boolean $$robo$$android_net_http_Connection$openHttpConnection(Request req) {
        long now = SystemClock.uptimeMillis();
        int error = 0;
        Exception exception = null;
        try {
            this.mCertificate = null;
            this.mHttpClientConnection = this.openConnection(req);
            if (this.mHttpClientConnection == null) {
                req.mFailCount = 2;
                return false;
            }
            this.mHttpClientConnection.setSocketTimeout(60000);
            this.mHttpContext.setAttribute("http.connection", this.mHttpClientConnection);
        }
        catch (UnknownHostException e) {
            error = -2;
            exception = e;
        }
        catch (IllegalArgumentException e) {
            error = -6;
            req.mFailCount = 2;
            exception = e;
        }
        catch (SSLConnectionClosedByUserException e) {
            req.mFailCount = 2;
            return false;
        }
        catch (SSLHandshakeException e) {
            req.mFailCount = 2;
            error = -11;
            exception = e;
        }
        catch (IOException e) {
            error = -6;
            exception = e;
        }
        if (error == 0) {
            return true;
        }
        if (req.mFailCount < 2) {
            this.mRequestFeeder.requeueRequest(req);
            ++req.mFailCount;
        } else {
            this.httpFailure(req, error, exception);
        }
        return error == 0;
    }

    private final boolean $$robo$$android_net_http_Connection$httpFailure(Request req, int errorId, Exception e) {
        boolean ret = true;
        if (++req.mFailCount >= 2) {
            Throwable cause;
            ret = false;
            String error = errorId < 0 ? ErrorStrings.getString(errorId, this.mContext) : ((cause = e.getCause()) != null ? cause.toString() : e.getMessage());
            req.mEventHandler.error(errorId, error);
            req.complete();
        }
        this.closeConnection();
        this.mHttpContext.removeAttribute("http.connection");
        return ret;
    }

    private final HttpContext $$robo$$android_net_http_Connection$getHttpContext() {
        return this.mHttpContext;
    }

    private final boolean $$robo$$android_net_http_Connection$keepAlive(HttpEntity entity, ProtocolVersion ver, int connType, HttpContext context) {
        org.apache.http.HttpConnection conn = (org.apache.http.HttpConnection)context.getAttribute("http.connection");
        if (conn != null && !conn.isOpen()) {
            return false;
        }
        if (entity != null && entity.getContentLength() < 0L && (!entity.isChunked() || ver.lessEquals(HttpVersion.HTTP_1_0))) {
            return false;
        }
        if (connType == 1) {
            return false;
        }
        if (connType == 2) {
            return true;
        }
        return !ver.lessEquals(HttpVersion.HTTP_1_0);
    }

    private final void $$robo$$android_net_http_Connection$setCanPersist(HttpEntity entity, ProtocolVersion ver, int connType) {
        this.mCanPersist = this.keepAlive(entity, ver, connType, this.mHttpContext);
    }

    private final void $$robo$$android_net_http_Connection$setCanPersist(boolean canPersist) {
        this.mCanPersist = canPersist;
    }

    private final boolean $$robo$$android_net_http_Connection$getCanPersist() {
        return this.mCanPersist;
    }

    abstract String getScheme();

    abstract void closeConnection();

    abstract AndroidHttpClientConnection openConnection(Request var1) throws IOException;

    private final synchronized String $$robo$$android_net_http_Connection$toString() {
        return this.mHost.toString();
    }

    private final byte[] $$robo$$android_net_http_Connection$getBuf() {
        if (this.mBuf == null) {
            this.mBuf = new byte[8192];
        }
        return this.mBuf;
    }

    static void __staticInitializer__() {
        states = new String[]{"SEND", "READ", "DRAIN", "DONE"};
        STATE_NORMAL = 0;
        STATE_CANCEL_REQUESTED = 1;
    }

    private void __constructor__(Context context, HttpHost httpHost, RequestFeeder requestFeeder) {
        this.$$robo$$android_net_http_Connection$__constructor__(context, httpHost, requestFeeder);
    }

    protected Connection(Context context, HttpHost httpHost, RequestFeeder requestFeeder) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_http_Connection$__constructor__(android.content.Context org.apache.http.HttpHost android.net.http.RequestFeeder ), 0, this, context, httpHost, requestFeeder);
    }

    HttpHost getHost() {
        return InvokeDynamicSupport.bootstrap("getHost", $$robo$$android_net_http_Connection$getHost(), 0, this);
    }

    static Connection getConnection(Context context, HttpHost httpHost, HttpHost httpHost2, RequestFeeder requestFeeder) {
        return InvokeDynamicSupport.bootstrapStatic("getConnection", $$robo$$android_net_http_Connection$getConnection(android.content.Context org.apache.http.HttpHost org.apache.http.HttpHost android.net.http.RequestFeeder ), 0, (Context)context, (HttpHost)httpHost, (HttpHost)httpHost2, (RequestFeeder)requestFeeder);
    }

    SslCertificate getCertificate() {
        return InvokeDynamicSupport.bootstrap("getCertificate", $$robo$$android_net_http_Connection$getCertificate(), 0, this);
    }

    void cancel() {
        InvokeDynamicSupport.bootstrap("cancel", $$robo$$android_net_http_Connection$cancel(), 0, this);
    }

    void processRequests(Request request) {
        InvokeDynamicSupport.bootstrap("processRequests", $$robo$$android_net_http_Connection$processRequests(android.net.http.Request ), 0, this, request);
    }

    private boolean clearPipe(LinkedList<Request> linkedList) {
        return (boolean)InvokeDynamicSupport.bootstrap("clearPipe", $$robo$$android_net_http_Connection$clearPipe(java.util.LinkedList<android.net.http.Request> ), 0, this, linkedList);
    }

    private boolean openHttpConnection(Request request) {
        return (boolean)InvokeDynamicSupport.bootstrap("openHttpConnection", $$robo$$android_net_http_Connection$openHttpConnection(android.net.http.Request ), 0, this, request);
    }

    private boolean httpFailure(Request request, int n, Exception exception) {
        return (boolean)InvokeDynamicSupport.bootstrap("httpFailure", $$robo$$android_net_http_Connection$httpFailure(android.net.http.Request int java.lang.Exception ), 0, this, request, n, exception);
    }

    HttpContext getHttpContext() {
        return InvokeDynamicSupport.bootstrap("getHttpContext", $$robo$$android_net_http_Connection$getHttpContext(), 0, this);
    }

    private boolean keepAlive(HttpEntity httpEntity, ProtocolVersion protocolVersion, int n, HttpContext httpContext) {
        return (boolean)InvokeDynamicSupport.bootstrap("keepAlive", $$robo$$android_net_http_Connection$keepAlive(org.apache.http.HttpEntity org.apache.http.ProtocolVersion int org.apache.http.protocol.HttpContext ), 0, this, httpEntity, protocolVersion, n, httpContext);
    }

    void setCanPersist(HttpEntity httpEntity, ProtocolVersion protocolVersion, int n) {
        InvokeDynamicSupport.bootstrap("setCanPersist", $$robo$$android_net_http_Connection$setCanPersist(org.apache.http.HttpEntity org.apache.http.ProtocolVersion int ), 0, this, httpEntity, protocolVersion, n);
    }

    void setCanPersist(boolean bl) {
        InvokeDynamicSupport.bootstrap("setCanPersist", $$robo$$android_net_http_Connection$setCanPersist(boolean ), 0, this, bl);
    }

    boolean getCanPersist() {
        return (boolean)InvokeDynamicSupport.bootstrap("getCanPersist", $$robo$$android_net_http_Connection$getCanPersist(), 0, this);
    }

    public synchronized String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_http_Connection$toString(), 0, this);
    }

    byte[] getBuf() {
        return InvokeDynamicSupport.bootstrap("getBuf", $$robo$$android_net_http_Connection$getBuf(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(Connection.class);
    }

    public /* synthetic */ Connection() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Connection)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

